#!/usr/bin/env python3
# -*- coding: utf-8 -*-

'''
Programmname:       Titrierer
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
import time
import random
import math
#import sys
import os
from tkinter import *

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=4)
        self.eingaberahmen=Frame(self.frame1,  pady=4, padx=4, bd=2, relief=RIDGE)
        self.versuchsrahmen=Frame(self.frame1, pady=0, padx=4)
        self.ausgaberahmen=Frame(self.frame1,  pady=0, padx=4)
        self.kontrollrahmen=Frame(self.frame1, pady=0, padx=0)
        for f, row, column, columnspan, rowspan, sticky in (
                (frame,       0, 0, 1, 1, E+W),
                # Rahmen 1 als Hintergrund
                (self.frame1, 0, 0, 1, 1, E+W),
                # Rahmen 2, 3 und 4 für links oben Eingabe, rechts gesamt Versuch und links unten Auswertung
                (self.eingaberahmen,  0, 0, 1, 1, N+W),
                (self.versuchsrahmen, 0, 1, 1, 2, E+W),
                (self.ausgaberahmen,  1, 0, 1, 1, W+E+N+S),
                (self.kontrollrahmen, 2, 0, 2, 1, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, rowspan=rowspan, sticky=sticky)

        ################### Daten ##############################################
        self.indikatoren={
            # Name: (Umschlagsbereich sauer, alkalisch, farbe saurer, farbe stärker alkalisch)
            'NO_IND':(        0.0,  0.0, 'white',  'white'),
            'Bromthymolblau':(6.0,  7.6, 'yellow', 'blue'),
            'Phenolpthalein':(8.2, 10.0, 'white',  'magenta'),
            'Methylrot':(     4.4,  6.2, 'red',    'yellow')
        }
        self.ausgangskombinationen={
            # Schlüssel: (Indikator als Schlüssel, pos. für sauer oder alkalisch im Ausgangszustand)
            'X_X':('NO_IND', 2), 
            'naoh_loes_hcl_loes':('Bromthymolblau', 2),
            'naoh_loes_hoac_loes':('Phenolpthalein', 2),
            'hcl_loes_naoh_loes':('Bromthymolblau', 3),
            'hcl_loes_nh3_loes':('Methylrot', 3)
        }
        ########################################################################
        ##                          GUI-Elemente                              ##
        ########################################################################

        ## Eingaberahmen #######################################################
        self.eingabel2=Label(self.eingaberahmen, text='Konzentration [mol/l]')
        self.eingabel3=Label(self.eingaberahmen, text='Zugegebenes Volumen [ml]')
        # Maßlösung
        self.eingabel4=Label(self.eingaberahmen, text='Maßlösung:', anchor=W, justify=LEFT)
        global massloesung
        massloesung=StringVar()
        massloesung.set('X')
        self.eingabe_mass_r1=Radiobutton(self.eingaberahmen,
                                   text='Natronlauge',
                                   variable=massloesung, 
                                   value='naoh_loes',
                                   indicatoron=1, 
                                   command=self.massloesung_festlegen,
                                   anchor=W,
                                   justify=LEFT)
        self.eingabe_mass_r2=Radiobutton(self.eingaberahmen,
                                   text='Salzsäure',
                                   variable=massloesung, 
                                   value='hcl_loes',
                                   indicatoron=1, 
                                   command=self.massloesung_festlegen,
                                   anchor=W,
                                   justify=LEFT)
        global massloesung_konz
        massloesung_konz=StringVar()
        massloesung_konz.set('X')
        self.eingabe_mass_konz_r1=Radiobutton(self.eingaberahmen,
                                              text='0,1',
                                              variable=massloesung_konz, 
                                              value='0.1',
                                              indicatoron=1, 
                                              command=self.massloesung_konz_festlegen,
                                              anchor=W,
                                              justify=LEFT)
        self.eingabe_mass_konz_r2=Radiobutton(self.eingaberahmen,
                                              text='1,0',
                                              variable=massloesung_konz, 
                                              value='1.0',
                                              indicatoron=1, 
                                              command=self.massloesung_konz_festlegen,
                                              anchor=W,
                                              justify=LEFT)
        self.startwertscale1=0
        self.eingabescale1=Scale(self.eingaberahmen, 
                                 length=250, from_=0, to=20, resolution=0.5,
                                 showvalue=1, orient=HORIZONTAL,
                                 command=self.massloesung_vol_festlegen,
                                 state=DISABLED)
        # Probelösung
        self.eingabel5=Label(self.eingaberahmen, text='Probelösung:', anchor=W, justify=LEFT)
        global probeloesung
        probeloesung=StringVar()
        probeloesung.set('X')
        self.eingabe_prob_r1=Radiobutton(self.eingaberahmen,
                                   text='Salzsäure',
                                   variable=probeloesung, 
                                   value='hcl_loes',
                                   indicatoron=1, 
                                   command=self.probeloesung_festlegen,
                                   anchor=W,
                                   justify=LEFT)
        self.eingabe_prob_r2=Radiobutton(self.eingaberahmen,
                                   text='Essigsäure',
                                   variable=probeloesung, 
                                   value='hoac_loes',
                                   indicatoron=1, 
                                   command=self.probeloesung_festlegen,
                                   anchor=W,
                                   justify=LEFT)
        self.eingabe_prob_r3=Radiobutton(self.eingaberahmen,
                                   text='Natronlauge',
                                   variable=probeloesung, 
                                   value='naoh_loes',
                                   indicatoron=1, 
                                   command=self.probeloesung_festlegen,
                                   anchor=W,
                                   justify=LEFT)
        self.eingabe_prob_r4=Radiobutton(self.eingaberahmen,
                                   text='Ammoniaklösung',
                                   variable=probeloesung, 
                                   value='nh3_loes',
                                   indicatoron=1, 
                                   command=self.probeloesung_festlegen,
                                   anchor=W,
                                   justify=LEFT)
        icon_important=PhotoImage(file='daten/img/emblem-important.gif')
        self.eingabeb1=Button(self.eingaberahmen, 
                              text='Bei Farbumschlag\nKonzentration \nbestimmen',
                              command=self.probeloesung_konz_bestimmen,
                              image=icon_important,
                              compound=LEFT,
                              justify=LEFT)
        self.eingabeb1.icon_reset=icon_important
        self.eingabel6=Label(self.eingaberahmen, text='Vorgelegtes Volumen [ml]')
        self.startwertscale2=20
        self.eingabescale2=Scale(self.eingaberahmen, 
                                 length=80, from_=20, to=40, resolution=5,
                                 showvalue=1, orient=HORIZONTAL,
                                 command=self.probeloesung_vol_festlegen)
        self.eingabescale2.set(self.startwertscale2)
        self.eingabescale2.config(state=DISABLED)
        self.eingabel7=Label(self.eingaberahmen, text='', fg='white')
        for i, row, column, columnspan, rowspan, sticky in (
                                                                                            (self.eingabel2,      0, 2, 1, 1, E+W),        (self.eingabel3,      0, 3, 1, 1, E+W),
            (self.eingabel4,  1, 0, 1, 1, E+W), (self.eingabe_mass_r1,  1, 1, 1, 1, E+W),   (self.eingabe_mass_konz_r2,  1, 2, 1, 1, E+W), (self.eingabescale1,  1, 3, 1, 2, E),
                                                (self.eingabe_mass_r2,  2, 1, 1, 1, E+W),   (self.eingabe_mass_konz_r1,  2, 2, 1, 1, E+W),
                                                                                                                                           (self.eingabel6,      3, 3, 1, 1, E+W), 
            (self.eingabel5,  4, 0, 1, 1, E+W), (self.eingabe_prob_r1,  4, 1, 1, 1, E+W),   (self.eingabeb1,      4, 2, 1, 3, E+W),        (self.eingabescale2,  4, 3, 1, 2, E),
                                                (self.eingabe_prob_r2,  5, 1, 1, 1, E+W),
                                                (self.eingabe_prob_r3,  6, 1, 1, 1, E+W), 
                                                (self.eingabe_prob_r4,  7, 1, 1, 1, E+W),   (self.eingabel7,      7, 2, 1, 1, E+W),
                                                ):
            i.grid(row=row, column=column, columnspan=columnspan, rowspan=rowspan, sticky=sticky)
        self.deaktiviert_ausgangszustand=(                       self.eingabel2, self.eingabel3,
                                                                 self.eingabe_mass_konz_r1,  self.eingabescale1, 
                                         self.eingabel5,         self.eingabe_mass_konz_r2,  self.eingabel6,
                                         self.eingabe_prob_r1,   self.eingabeb1,             self.eingabescale2,
                                         self.eingabe_prob_r2,
                                         self.eingabe_prob_r3, 
                                         self.eingabe_prob_r4)
        self.aktiviert_alkalimetrie=(                        self.eingabe_mass_konz_r1,
                                                             self.eingabe_mass_konz_r2,
                                     self.eingabe_prob_r1,
                                     self.eingabe_prob_r2)
        self.aktiviert_acidimetrie=(                         self.eingabe_mass_konz_r1,
                                                             self.eingabe_mass_konz_r2,
                                     self.eingabe_prob_r3,
                                     self.eingabe_prob_r4)
        for i in self.deaktiviert_ausgangszustand:
            i.config(state=DISABLED)

        ## Versuchsrahmen ######################################################
        self.versuchscanvas=Canvas(self.versuchsrahmen, width=250, height=500, bg='white')
        self.fluessigkeitsgrenzen=1
        self.probeloesung_fuellhoehe=int(float(self.eingabescale2.get()*2.5))
        self.probeloesung_indikatorfarbe='lightgrey'
        self.probeloesung_inhalt=self.versuchscanvas.create_rectangle(30,  
                                                                      470-self.probeloesung_fuellhoehe,  
                                                                      220,  
                                                                      470, 
                                                                      fill=self.probeloesung_indikatorfarbe, 
                                                                      width=self.fluessigkeitsgrenzen,
                                                                      outline='black')
        # Gefäß für die Probelösung
        self.versuchscanvas.create_line( 30,  320,  30,  470, width=2.5)
        self.versuchscanvas.create_line( 29,  470, 222,  470, width=2.5)
        self.versuchscanvas.create_line(220,  320, 220,  470, width=2.5)
        # Gefäß für die Maßlösung
        self.versuchscanvas.create_line(100,   20,  100,  300, width=2.5)
        self.versuchscanvas.create_line(150,   20,  150,  300, width=2.5)
        self.versuchscanvas.create_line( 99,  300,  119,  300, width=2.5)
        self.versuchscanvas.create_line(131,  300,  152,  300, width=2.5)
        self.versuchscanvas.create_line(119,  300,  119,  340, width=2.5)
        self.versuchscanvas.create_line(131,  300,  131,  340, width=2.5)
        self.versuchscanvas.create_rectangle(110,  315,  140,  325, fill='gray', outline='black')
        self.versuchscanvas.create_rectangle(140,  310,  145,  330, fill='gray', outline='black')
        # Ausgangslinie als Meniskus-"Bogen" für die Maßlösung
        self.ausgangshoehe_massloesungs_linie=35
        self.bogenkruemmung=15
        self.massloesungs_bogen=self.versuchscanvas.create_arc(100, 
                                                               self.ausgangshoehe_massloesungs_linie-self.bogenkruemmung,  
                                                               150,  
                                                               self.ausgangshoehe_massloesungs_linie, 
                                                               style=ARC,
                                                               start=0,
                                                               extent=-180,
                                                               width=self.fluessigkeitsgrenzen)
        # Leerer Beschriftungstext für die Maßlösung
        self.massloesung_textinhalt='Maßlösung'
        self.massloesung_text=self.versuchscanvas.create_text(245,
                                                              60,
                                                              text=self.massloesung_textinhalt,
                                                              anchor=NE,
                                                              justify=RIGHT)
        # Skalierung Bürette der Maßlösung
        for i in range(0, 20):
            y_wert=self.ausgangshoehe_massloesungs_linie+int(i*13.25)
            self.versuchscanvas.create_line(131, 
                                            y_wert,  
                                            134,  
                                            y_wert, 
                                            width=1)
        for i in range(0, 20, 5):
            y_wert=self.ausgangshoehe_massloesungs_linie+int(i*13.25)
            self.versuchscanvas.create_line(125, 
                                            y_wert,  
                                            134,  
                                            y_wert, 
                                            width=1)
        # Leerer Beschriftungstext für die Probelösung
        self.probeloesung_textinhalt='Probelösung'
        self.probeloesung_text=self.versuchscanvas.create_text(125,
                                                               485,
                                                               text=self.probeloesung_textinhalt,
                                                               anchor=CENTER,
                                                               justify=RIGHT)
        # Unsichtbarer Maßlösungstropfen, der bei Zugabe sichtbar wird
        global letzter_zugabestand
        letzter_zugabestand=0.0
        self.tropfen=self.versuchscanvas.create_oval(120, 
                                                     350,
                                                     130,
                                                     365,
                                                     fill='white',
                                                     state=HIDDEN)

        for i, row, column in ((self.versuchscanvas, 0, 0),):
            i.grid(row=row, column=column)

        ## Ausgaberahmenrahmen #################################################
        self.breite=640
        self.hoehe=320
        self.ausgabecanvas=Canvas(self.ausgaberahmen, 
                                  width=self.breite, 
                                  height=self.hoehe, 
                                  bg='white')
        ## Achsen
        self.abstand_zur_seite=50
        self.abstand_nach_obenunten=40
        self.schrift_abstand=20
        self.linien_staerke=1.5
        # y-Achse: pH-Wert
        self.y_achsenlaenge=self.hoehe-2*self.abstand_nach_obenunten
        self.x_achsenlaenge=self.breite-2*self.abstand_zur_seite
        self.ausgabecanvas.create_line(self.abstand_zur_seite, 
                                       self.abstand_nach_obenunten, 
                                       self.abstand_zur_seite, 
                                       self.abstand_nach_obenunten+self.y_achsenlaenge, 
                                       #arrow=FIRST,
                                       #arrowshape=str(self.linien_staerke+5)+' '+str(self.linien_staerke+7)+' '+str(self.linien_staerke+2),
                                       width=self.linien_staerke)
        self.ausgabecanvas.create_text(self.abstand_zur_seite-self.schrift_abstand-10, 
                                       self.abstand_nach_obenunten-25, 
                                       text='pH', 
                                       anchor=N)
        # Skalierung y-Achse
        self.y_skalierungsweite=float(self.y_achsenlaenge)/float(14)
        for i in range(0, 15):
            self.ausgabecanvas.create_line(self.abstand_zur_seite-6,
                                           self.abstand_nach_obenunten+i*self.y_skalierungsweite,
                                           self.abstand_zur_seite,
                                           self.abstand_nach_obenunten+i*self.y_skalierungsweite,
                                           width=0.5)
        for i in (0, 7, 14):
            self.ausgabecanvas.create_text(self.abstand_zur_seite-15,
                                           self.hoehe-(self.abstand_nach_obenunten+i*self.y_skalierungsweite)-0.5*self.y_skalierungsweite,
                                           text=str(i),
                                           anchor=N)
        # x-Achse: Zugegebenes Volumen der Maßlösung
        self.ausgabecanvas.create_line(self.abstand_zur_seite, 
                                       self.abstand_nach_obenunten+self.y_achsenlaenge, 
                                       self.breite-self.abstand_zur_seite, 
                                       self.abstand_nach_obenunten+self.y_achsenlaenge, 
                                       #arrow=LAST,
                                       #arrowshape=str(self.linien_staerke+5)+' '+str(self.linien_staerke+7)+' '+str(self.linien_staerke+2),
                                       width=self.linien_staerke)
        self.ausgabecanvas.create_text(self.abstand_zur_seite+self.breite-2*self.abstand_zur_seite, 
                                       self.abstand_nach_obenunten+self.hoehe-2*self.abstand_nach_obenunten+self.schrift_abstand, 
                                       text='V [ml]', 
                                       anchor=N)
        for i, row, column, sticky in ((self.ausgabecanvas, 0, 0, E+W),):
            i.grid(row=row, column=column, sticky=sticky)
        # Skalierung x-Achse
        self.x_skalierungsweite=float(self.x_achsenlaenge)/float(20)
        for i in range(0, 21):
            self.ausgabecanvas.create_line(self.abstand_zur_seite+i*self.x_skalierungsweite,
                                           self.hoehe-self.abstand_nach_obenunten,
                                           self.abstand_zur_seite+i*self.x_skalierungsweite,
                                           self.hoehe-self.abstand_nach_obenunten+6,
                                           width=0.5)
        for i in (0, 10, 20):
            self.ausgabecanvas.create_text(self.abstand_zur_seite+i*self.x_skalierungsweite,
                                           self.hoehe-self.abstand_nach_obenunten+0.2*self.x_skalierungsweite,
                                           text=str(i),
                                           anchor=N)
        # Grenzlinie bei pH=7, parallel zur x-Achse
        self.ausgabecanvas.create_line(self.abstand_zur_seite, 
                                       self.abstand_nach_obenunten+self.y_achsenlaenge/2.0, 
                                       self.breite-self.abstand_zur_seite, 
                                       self.abstand_nach_obenunten+self.y_achsenlaenge/2.0, 
                                       width=1,
                                       stipple='gray25')


        ## Kontrollrahmen ######################################################
        self.kontrolll1=Label(self.kontrollrahmen, text='Ermittelte Konzentration der Probelösung:')
        self.kontrolle1=Entry(self.kontrollrahmen, width=5)
        self.kontrolll2=Label(self.kontrollrahmen, text='mol/l ')
        icon_reset = PhotoImage(file='daten/img/view-refresh.gif')
        self.kontrollb1=Button(self.kontrollrahmen,
                         text='Zurücksetzen', 
                         command=self.zurueck_setzen,
                         image=icon_reset,
                         compound=LEFT)
        self.kontrollb1.icon_reset=icon_reset
        icon_exit = PhotoImage(file='daten/img/dialog-close.gif')
        self.kontrollb2=Button(self.kontrollrahmen,
                         text='Beenden', 
                         command=root.destroy,
                         image=icon_exit,
                         compound=LEFT)
        self.kontrollb2.icon_exit=icon_exit
        for i in (self.kontrolll1, self.kontrolle1, self.kontrolll2):
            i.config(state=DISABLED)
        for i, row, column in ((self.kontrolll1, 0, 0),
                               (self.kontrolle1, 0, 1),
                               (self.kontrolll2, 0, 2),
                               (self.kontrollb1, 0, 3),
                               (self.kontrollb2, 0, 4)):
            i.grid(row=row, column=column)
        
        ########################################################################
        ##                          Funktionen                                ##
        ########################################################################

        global zufaellige_probeloesung_konz
        zufaellige_probeloesung_konz=StringVar()

    def massloesung_festlegen(self):
        #print('massloesung_festlegen')
        self.massloesung=str(massloesung.get())
        #print(self.massloesung)
        probeloesung.set('X')
        for i in (self.eingabel2, self.eingabe_mass_konz_r1, self.eingabe_mass_konz_r2):
            i.config(state=NORMAL)
        for i in (self.eingabe_mass_r1, self.eingabe_mass_r2):
            i.config(state=DISABLED)
        if self.massloesung == 'naoh_loes':
            self.massloesung_textinhalt='Natronlauge'
        elif self.massloesung == 'hcl_loes':
            self.massloesung_textinhalt='Salzsäure'
        print(self.massloesung_textinhalt)
        self.versuchscanvas.itemconfig(self.massloesung_text, text=self.massloesung_textinhalt)

    def massloesung_konz_festlegen(self):
        #print('massloesung_konz_festlegen')
        self.massloesung_konz=str(massloesung_konz.get())
        for i in (self.eingabe_mass_konz_r1, self.eingabe_mass_konz_r2):
            i.config(state=DISABLED)
        self.massloesung=str(massloesung.get())
        #print(self.massloesung)
        probeloesung.set('X')
        if self.massloesung == 'naoh_loes':
            for i in self.aktiviert_alkalimetrie:
                i.config(state=NORMAL)
            for i in (self.eingabe_mass_r1, self.eingabe_mass_r2,
                      self.eingabe_mass_konz_r1, self.eingabe_mass_konz_r2,
                      self.eingabe_prob_r3, self.eingabe_prob_r4):
                i.config(state=DISABLED)
        elif self.massloesung == 'hcl_loes':
            for i in self.aktiviert_acidimetrie:
                i.config(state=NORMAL)
            for i in (self.eingabe_mass_r1, self.eingabe_mass_r2,
                      self.eingabe_mass_konz_r1, self.eingabe_mass_konz_r2,
                      self.eingabe_prob_r1, self.eingabe_prob_r2):
                i.config(state=DISABLED)
        for i in (self.eingabel5, ):
            i.config(state=NORMAL)
         
    def massloesung_vol_festlegen(self, a):
        #print('massloesung_vol_festlegen', str(a))
        # Ausgangsstoffkombination => Pufferbereiche für pH-Berechnung!
        self.massloesung=str(massloesung.get())
        self.probeloesung=str(probeloesung.get())
        self.probeloesung_vol=float(self.eingabescale2.get())
        self.massloesung_vol=float(a)
        # Probelösung-Schieberegler deaktivieren, um deren Volumen konstant zu halten
        if self.massloesung_vol > 0:
            self.eingabel6.config(state=DISABLED)
            self.eingabescale2.config(state=DISABLED)
        # Workaround, da beim Start noch kein (Zahlen-)Wert für die Konzentration der Maßlösung gesetzt wurde
        self.massloesung_konz=str(massloesung_konz.get())
        # Ab hier entweder mit try:/except: oder alles unter den if-Block einrücken 
        if self.massloesung_konz != 'X':
            self.massloesung_konz=float(self.massloesung_konz)
        # Anpassen des Pegels der Maßlösung
        self.ausgangshoehe_massloesungs_linie_neu=self.ausgangshoehe_massloesungs_linie+int(self.massloesung_vol*13.25)
        self.versuchscanvas.coords(self.massloesungs_bogen, 
                                   100, 
                                   self.ausgangshoehe_massloesungs_linie_neu-self.bogenkruemmung, 
                                   150, 
                                   self.ausgangshoehe_massloesungs_linie_neu)
        # Zutropfen animieren
        global letzter_zugabestand
        if letzter_zugabestand < self.massloesung_vol:
            #print('mache kurz sichtbar')
            self.versuchscanvas.itemconfig(self.tropfen, state=NORMAL)
            self.versuchscanvas.update()
            time.sleep(0.5)
            self.versuchscanvas.itemconfig(self.tropfen, state=HIDDEN)
        letzter_zugabestand=self.massloesung_vol
        self.schluessel=self.massloesung+'_'+self.probeloesung
        #print(self.schluessel)
        self.indikatorname=str(self.ausgangskombinationen[self.schluessel][0])
        self.probeloesung_indikatorfarbe=self.indikatoren[self.indikatorname][self.ausgangskombinationen[self.schluessel][1]]
        #print(self.indikatorname)
        if self.schluessel != 'X_X':
            self.versuchscanvas.itemconfig(self.probeloesung_text, 
                                           text=self.probeloesung_textinhalt+' mit '+self.indikatorname, 
                                           anchor=CENTER)
            self.versuchscanvas.itemconfig(self.probeloesung_inhalt,
                                           fill=self.probeloesung_indikatorfarbe)
            ## Äquivalenzvolumen v_mass berechnen
            ## c_mass * v_mass = c_prob * v_prob
            ## v_mass = (c_prob * v_prob)/c_mass
            global zufaellige_probeloesung_konz
            self.c_prob=float(zufaellige_probeloesung_konz)
            self.v_prob=float(self.eingabescale2.get())
            self.c_mass=float(massloesung_konz.get())
            self.v_mass_lang=(self.c_prob * self.v_prob) / self.c_mass
            self.v_mass=(math.ceil(self.v_mass_lang)+math.floor(self.v_mass_lang))/2.0
            #print('Äquivalenzvolumen = '+str(self.v_mass))
        ########################################################################
        ##  Fall 1: Maßlösung Natronlauge, Probelösung Essigsäure             ##
        ##          Titration einer schwachen Säure mit einer starken Base    ##
        ########################################################################
        if self.schluessel == 'naoh_loes_hoac_loes':
            ## Startwert: pH-Wert nur der schwachen Säure, Zugegebene Basenmenge 0 Milliliter
            self.c_schwache_saeure_ausg=self.c_prob                     # Variable, zufällig generiert, gehäuft um den Wert 0.5 herum
            self.pks_schwache_saeure=4.75                               # Säurekonstante von Essigsäure
            self.c_starke_base_zugegeben=self.c_mass 
            self.v_starke_base_zugegeben=float(self.eingabescale1.get())# Variable aus Schieberegler 1
            self.v_schwache_saeure_ausg=self.v_prob                     # Variable aus Schieberegler 2
            self.n_schwache_saeure_ausg=float(self.c_schwache_saeure_ausg)*float(self.v_schwache_saeure_ausg)/1000
            if self.v_starke_base_zugegeben == 0:
                self.pH=1.0/2.0*(self.pks_schwache_saeure-math.log10(self.c_schwache_saeure_ausg))
                self.probeloesung_indikatorfarbe_vorher=self.indikatoren[self.indikatorname][2]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_vorher)
                #print('Start pH-Wert:', self.pH)
            ## Weitere Werte im Pufferbreich kleiner als der Äquivalenzpunkt
            elif self.v_starke_base_zugegeben > 0 and self.v_starke_base_zugegeben < self.v_mass:
                self.v_starke_base_zugegeben=float(self.v_starke_base_zugegeben)/1000.0
                self.n_starke_base_zugegeben=float(self.c_starke_base_zugegeben)*float(self.v_starke_base_zugegeben)
                self.n_schwache_saeure_puffer=self.n_schwache_saeure_ausg-self.n_starke_base_zugegeben
                self.n_saeureanion_puffer=self.n_starke_base_zugegeben
                #print('Quotient=', float(self.n_saeureanion_puffer)/float(self.n_schwache_saeure_puffer))
                try:
                    self.pH=self.pks_schwache_saeure+math.log10(float(self.n_saeureanion_puffer)/float(self.n_schwache_saeure_puffer))
                except:
                    self.pH=None
                self.probeloesung_indikatorfarbe_vorher=self.indikatoren[self.indikatorname][2]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_vorher)
                #print('pH-Wert im Pufferbereich:', self.pH)
            ## Am Äquivalenzpunkt: Lösung von Natriumionen und Acetationen
            elif self.v_starke_base_zugegeben == self.v_mass:
                self.pkb_korrespond_schwache_base=9.25 # Basenkonstante des Acetations
                self.c_korrespond_schwache_base=self.c_schwache_saeure_ausg
                self.pOH=1.0/2.0*(self.pkb_korrespond_schwache_base-math.log10(self.c_korrespond_schwache_base))
                self.pH=14.0-self.pOH
                self.probeloesung_indikatorfarbe_nachher=self.indikatoren[self.indikatorname][3]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_nachher)
                #print('pH-Wert am Aquivalenzpunkt:', self.pH)
            ## Werte jenseits des Äquivalenzpunkt: Nur die weiter zugegebene starke Base entscheidet
            elif self.v_starke_base_zugegeben > self.v_mass:
                self.v_starke_base_zugegeben=float(self.v_starke_base_zugegeben-self.v_mass)/1000.0
                self.n_starke_base_zugegeben=float(self.c_starke_base_zugegeben)*float(self.v_starke_base_zugegeben)
                try:
                    self.pOH=-math.log10(self.n_starke_base_zugegeben/(float(self.v_schwache_saeure_ausg))*1000)
                    self.pH=14-self.pOH
                except:
                    self.pH=None
                self.probeloesung_indikatorfarbe_nachher=self.indikatoren[self.indikatorname][3]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_nachher)
                #print('pH-Wert nach dem Aquivalenzpunkt:', self.pH)
        ########################################################################
        ##  Fall 2: Maßlösung Natronlauge, Probelösung Salzsäure              ##
        ##          Titration einer starken Säure mit einer starken Base      ##
        ########################################################################
        elif self.schluessel == 'naoh_loes_hcl_loes':
            ## Startwert: pH-Wert nur der starken Säure, Zugegebene Basenmenge 0 Milliliter
            self.c_starke_saeure_ausg=self.c_prob                       # Variable, zufällig generiert, gehäuft um den Wert 0.5 herum
            self.c_starke_base_zugegeben=self.c_mass 
            self.v_starke_base_zugegeben=float(self.eingabescale1.get())# Variable aus Schieberegler 1
            self.v_starke_saeure_ausg=self.v_prob                       # Variable aus Schieberegler 2
            self.n_starke_saeure_ausg=float(self.c_starke_saeure_ausg)*float(self.v_starke_saeure_ausg)/1000
            if self.v_starke_base_zugegeben == 0:
                self.pH=-math.log10(self.c_starke_saeure_ausg)
                self.probeloesung_indikatorfarbe_vorher=self.indikatoren[self.indikatorname][2]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_vorher)
                #print('Start pH-Wert:', self.pH)
            ## Weitere Werte im Bereich kleiner als der Äquivalenzpunkt
            elif self.v_starke_base_zugegeben > 0 and self.v_starke_base_zugegeben < self.v_mass:
                self.v_starke_base_zugegeben=float(self.v_starke_base_zugegeben)/1000.0
                self.n_starke_base_zugegeben=float(self.c_starke_base_zugegeben)*float(self.v_starke_base_zugegeben)
                try:
                    self.pH=-math.log10(((self.n_starke_saeure_ausg-self.n_starke_base_zugegeben)/float(self.v_starke_saeure_ausg))*1000)
                except:
                    self.pH_puffer=None
                self.probeloesung_indikatorfarbe_vorher=self.indikatoren[self.indikatorname][2]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_vorher)
                #print('pH-Wert im sauren Bereich:', self.pH)
            ## Am Äquivalenzpunkt: Lösung von Natriumionen und Chloridionen
            elif self.v_starke_base_zugegeben == self.v_mass:
                self.pH=7.0
                self.probeloesung_indikatorfarbe_nachher=self.indikatoren[self.indikatorname][3]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_nachher)
                #print('pH-Wert am Aquivalenzpunkt:', self.pH)
            ## Werte jenseits des Äquivalenzpunkt: Nur die weiter zugegebene starke Base entscheidet
            elif self.v_starke_base_zugegeben > self.v_mass:
                self.v_starke_base_zugegeben=float(self.v_starke_base_zugegeben-self.v_mass)/1000.0
                self.n_starke_base_zugegeben=float(self.c_starke_base_zugegeben)*float(self.v_starke_base_zugegeben)
                try:
                    self.pOH=-math.log10(self.n_starke_base_zugegeben/(float(self.v_starke_saeure_ausg))*1000)
                    self.pH=14-self.pOH
                except:
                    self.pH=None
                self.probeloesung_indikatorfarbe_nachher=self.indikatoren[self.indikatorname][3]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_nachher)
                #print('pH-Wert im alkalischen Bereich:', self.pH)
        ########################################################################
        ##  Fall 3: Maßlösung Salzsäure, Probelösung Natronlauge              ##
        ##          Titration einer starken Base mit einer starken Säure      ##
        ########################################################################
        elif self.schluessel == 'hcl_loes_naoh_loes':
            ## Startwert: pH-Wert nur der starken Base, Zugegebene Säuremenge 0 Milliliter
            self.c_starke_base_ausg=self.c_prob                       # Variable, zufällig generiert, gehäuft um den Wert 0.5 herum
            self.c_starke_saeure_zugegeben=self.c_mass 
            self.v_starke_saeure_zugegeben=float(self.eingabescale1.get()) # Variable aus Schieberegler 1
            self.v_starke_base_ausg=self.v_prob                            # Variable aus Schieberegler 2
            self.n_starke_base_ausg=float(self.c_starke_base_ausg)*float(self.v_starke_base_ausg)/1000
            if self.v_starke_saeure_zugegeben == 0:
                self.pOH_starke_base_ausg=-math.log10(self.c_starke_base_ausg)
                self.pH=14-self.pOH
                self.probeloesung_indikatorfarbe_vorher=self.indikatoren[self.indikatorname][3]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_vorher)
                #print('Start pH-Wert:', self.pH)
            ## Weitere Werte im Bereich kleiner als der Äquivalenzpunkt
            elif self.v_starke_saeure_zugegeben > 0 and self.v_starke_saeure_zugegeben < self.v_mass:
                self.v_starke_saeure_zugegeben=float(self.v_starke_saeure_zugegeben)/1000.0
                self.n_starke_saeure_zugegeben=float(self.c_starke_saeure_zugegeben)*float(self.v_starke_saeure_zugegeben)
                try:
                    self.pOH=-math.log10(((self.n_starke_base_ausg-self.n_starke_saeure_zugegeben)/float(self.v_starke_base_ausg))*1000)
                    self.pH=14-self.pOH
                except:
                    self.pH=None
                self.probeloesung_indikatorfarbe_vorher=self.indikatoren[self.indikatorname][3]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_vorher)
                #print('pH-Wert im alkalischen Bereich:', self.pH)
            ## Am Äquivalenzpunkt: Lösung von Natriumionen und Chloridionen
            elif self.v_starke_saeure_zugegeben == self.v_mass:
                self.pH=7.0
                self.probeloesung_indikatorfarbe_nachher=self.indikatoren[self.indikatorname][2]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_nachher)
                #print('pH-Wert am Aquivalenzpunkt:', self.pH)
            ## Werte jenseits des Äquivalenzpunkt: Nur die weiter zugegebene starke Säure entscheidet
            elif self.v_starke_saeure_zugegeben > self.v_mass:
                self.v_starke_saeure_zugegeben=float(self.v_starke_saeure_zugegeben-self.v_mass)/1000.0
                self.n_starke_saeure_zugegeben=float(self.c_starke_saeure_zugegeben)*float(self.v_starke_saeure_zugegeben)
                try:
                    self.pH=-math.log10(self.n_starke_saeure_zugegeben/(float(self.v_starke_base_ausg))*1000)
                except:
                    self.pH=None
                self.probeloesung_indikatorfarbe_nachher=self.indikatoren[self.indikatorname][2]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_nachher)
                #print('pH-Wert im sauren Bereich:', self.pH)
        ########################################################################
        ##  Fall 4: Maßlösung Salzsäure, Probelösung Ammoniak-Lösung          ##
        ##          Titration einer schwachen Base mit einer starken Säure    ##
        ########################################################################
        if self.schluessel == 'hcl_loes_nh3_loes':
            ## Startwert: pH-Wert nur der schwachen Base, Zugegebene Säuremenge 0 Milliliter
            self.c_schwache_base_ausg=self.c_prob                       # Variable, zufällig generiert, gehäuft um den Wert 0.5 herum
            self.pkb_schwache_base=4.75                                 # Basenkonstante von Ammoniak
            self.c_starke_saeure_zugegeben=self.c_mass 
            self.v_starke_saeure_zugegeben=float(self.eingabescale1.get()) # Variable aus Schieberegler 1
            self.v_schwache_base_ausg=self.v_prob                          # Variable aus Schieberegler 2
            self.n_schwache_base_ausg=float(self.c_schwache_base_ausg)*float(self.v_schwache_base_ausg)/1000.0
            if self.v_starke_saeure_zugegeben == 0:
                self.pOH_schwache_base_ausg=1.0/2.0*(self.pkb_schwache_base-math.log10(self.c_schwache_base_ausg))
                self.pH=14-self.pOH_schwache_base_ausg
                self.probeloesung_indikatorfarbe_vorher=self.indikatoren[self.indikatorname][3]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_vorher)
                #print('Start pH-Wert:', self.pH)
            ## Weitere Werte im Pufferbreich größer als der Äquivalenzpunkt
            elif self.v_starke_saeure_zugegeben > 0 and self.v_starke_saeure_zugegeben < self.v_mass:
                self.v_starke_saeure_zugegeben=float(self.v_starke_saeure_zugegeben)/1000.0
                self.n_starke_saeure_zugegeben=float(self.c_starke_saeure_zugegeben)*float(self.v_starke_saeure_zugegeben)
                self.n_schwache_base_puffer=self.n_schwache_base_ausg-self.n_starke_saeure_zugegeben
                self.n_saeure_puffer=self.n_starke_saeure_zugegeben
                #print('Quotient=', float(self.n_saeureanion_puffer)/float(self.n_schwache_saeure_puffer))
                try:
                    self.pOH_puffer=self.pkb_schwache_base+math.log10(float(self.n_saeure_puffer)/float(self.n_schwache_base_puffer))
                    self.pH=14-self.pOH_puffer
                except:
                    self.pH=None
                self.probeloesung_indikatorfarbe_vorher=self.indikatoren[self.indikatorname][3]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_vorher)
                #print('pH-Wert im Pufferbereich:', self.pH)
            ## Am Äquivalenzpunkt: Lösung von Ammoniumionen und Chloridionen
            elif self.v_starke_saeure_zugegeben == self.v_mass:
                self.pka_korrespond_schwache_saeure=9.25     # Säurekonstante des Ammoniumions
                self.c_korrespond_schwache_base=self.c_schwache_base_ausg
                self.pH=1.0/2.0*(self.pka_korrespond_schwache_saeure-math.log10(self.c_korrespond_schwache_base))
                self.probeloesung_indikatorfarbe_nachher=self.indikatoren[self.indikatorname][2]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_nachher)
                #print('pH-Wert am Aquivalenzpunkt:', self.pH)
            ## Werte jenseits des Äquivalenzpunkt: Nur die weiter zugegebene starke Säure entscheidet
            elif self.v_starke_saeure_zugegeben > self.v_mass:
                self.v_starke_saeure_zugegeben=float(self.v_starke_saeure_zugegeben-self.v_mass)/1000.0
                self.n_starke_saeure_zugegeben=float(self.c_starke_saeure_zugegeben)*float(self.v_starke_saeure_zugegeben)
                try:
                    self.pH=-math.log10(self.n_starke_saeure_zugegeben/(float(self.v_schwache_base_ausg))*1000)
                except:
                    self.pH=None
                self.probeloesung_indikatorfarbe_nachher=self.indikatoren[self.indikatorname][2]
                self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe_nachher)
                #print('pH-Wert nach dem Aquivalenzpunkt:', self.pH)
        # pH-Wert anschließend gegen das zugegebene Volumen der Maßlösung auftragen/plotten
        if self.schluessel != 'X_X':
            # y-Koordinate aus pH-Wert und Skalierung
            #print('pH-Wert:', self.pH, self.y_skalierungsweite)
            self.y_koordinate=self.hoehe-(self.abstand_nach_obenunten+self.pH*self.y_skalierungsweite)
            # x-Koordinate aus pH-Wert und Skalierung
            #print('Zugegebenes Volumen:', self.massloesung_vol, self.x_skalierungsweite)
            self.x_koordinate=self.abstand_zur_seite+(self.massloesung_vol*self.x_skalierungsweite)
            self.punkt=Punkt_im_koordinatensystem(self.ausgabecanvas, self.x_koordinate, self.y_koordinate)
            self.ausgabecanvas.update()
        # TO DO: Punkte verbinden, Kurve glätten
        # TO DO: Hinterlegung des Graphen mit dem jeweils passenden Indikator
        
    def probeloesung_festlegen(self):
        #print('probeloesung_festlegen')
        self.probeloesung=str(probeloesung.get())
        #print(self.probeloesung)
        for i in (self.eingabel3, self.eingabescale1, self.eingabeb1, self.eingabel6, self.eingabescale2):
            i.config(state=NORMAL)
        global zufaellige_probeloesung_konz
        # Zufällige Konzentration der Probelösung merklich kleiner halten als die
        # der Maßlösung, damit die Volumenänderung bei der pH-wert-Berechnung
        # vernachlässigt werden kann
        if str(massloesung_konz.get()) == '0.1':
            #print('niedrige Konzentration der Maßlösung')
            grenze=20
        elif str(massloesung_konz.get()) == '1.0':
            #print('hohe Konzentration der Maßlösung')
            grenze=101
        zufaellige_probeloesung_konz=self.zufalls_probeloesung_konz(grenze)
        self.eingabel7.config(text=zufaellige_probeloesung_konz)
        for i in (self.eingabe_prob_r1, self.eingabe_prob_r2, self.eingabe_prob_r3, self.eingabe_prob_r4):
            i.config(state=DISABLED)
        if self.probeloesung == 'naoh_loes':
            self.probeloesung_textinhalt='Natronlauge'
        elif self.probeloesung == 'hcl_loes':
            self.probeloesung_textinhalt='Salzsäure'
        elif self.probeloesung == 'hoac_loes':
            self.probeloesung_textinhalt='Essigsäure'
        elif self.probeloesung == 'nh3_loes':
            self.probeloesung_textinhalt='Ammoniaklösung'
        #print(self.probeloesung_textinhalt)
        self.versuchscanvas.itemconfig(self.probeloesung_text, text=self.probeloesung_textinhalt)

    def probeloesung_konz_bestimmen(self):
        #print('probeloesung_konz_bestimmen')
        self.v_mass=float(self.eingabescale1.get())
        self.c_mass=float(massloesung_konz.get())
        self.v_prob=float(self.eingabescale2.get())
        self.c_prob_zu_lang=(self.c_mass*self.v_mass)/self.v_prob
        self.c_prob='%.2f' % (self.c_prob_zu_lang,)
        self.kontrolll1.config(state=NORMAL)
        self.kontrolll2.config(state=NORMAL)
        self.kontrolle1.config(state=NORMAL)
        self.kontrolle1.delete(0, END)
        self.kontrolle1.insert(0, str(self.c_prob))
        self.kontrolle1.config(state=DISABLED, disabledbackground='white', disabledforeground='black')
        # TO DO: Vergleich mit dem zufällig generierten Wert

    def probeloesung_vol_festlegen(self, a):
        #print('probeloesung_vol_festlegen')
        self.probeloesung_vol=str(a)
        self.probeloesung_fuellhoehe=int(float(a)*2.5)
        self.versuchscanvas.coords(self.probeloesung_inhalt, 
                                   30, 
                                   470-self.probeloesung_fuellhoehe, 
                                   220, 
                                   470)

    def zurueck_setzen(self):
        #print('zurueck_setzen')
        massloesung.set('X')
        massloesung_konz.set('X')
        probeloesung.set('X')
        for i in self.deaktiviert_ausgangszustand:
            i.config(state=DISABLED)
        for i,v in ((self.eingabescale1, self.startwertscale1),
                    (self.eingabescale2, self.startwertscale2)):
            i.config(state=NORMAL)
            i.set(v)
            i.config(state=DISABLED)
        self.kontrolle1.config(state=NORMAL)
        self.kontrolle1.delete(0, END)
        for i in (self.kontrolll1, self.kontrolle1, self.kontrolll2):
            i.config(state=DISABLED)
        for i in (self.eingabe_mass_r1, self.eingabe_mass_r2):
            i.config(state=NORMAL)
        self.eingabel7.config(text='')
        self.versuchscanvas.itemconfig(self.massloesung_text, text='Maßlösung')
        self.versuchscanvas.itemconfig(self.probeloesung_text, text='Probelösung')
        self.probeloesung_indikatorfarbe='lightgrey'
        self.versuchscanvas.itemconfig(self.probeloesung_inhalt, fill=self.probeloesung_indikatorfarbe)
        self.punkte_liste=self.ausgabecanvas.find_withtag('punkte_tag')
        #print(self.punkte_liste)
        for i in self.punkte_liste:
            self.ausgabecanvas.delete(i)
        for i in (self.versuchscanvas, self.ausgabecanvas):
            i.update()

    def zufalls_probeloesung_konz(self, grenze):
        ## Einfache Zufallszahl aus dem Bereich
        #zahl_zu_lang=float(random.randrange(1, grenze, 1))/float(100)
        ## Normalverteilte Zufallszahl gauss(mu, sigma) um den Mittelwert mu mit der Standardabweichung sigma
        zahl_zu_lang=float(random.gauss((float(grenze)/float(100))/float(2), 0.04))
        while zahl_zu_lang > 1.00:
         zahl_zu_lang=float(random.gauss((float(grenze)/float(100))/float(2), 0.04))
        zahl_als_string='%.2f' % (zahl_zu_lang,)
        return zahl_als_string

################################################################################

class Punkt_im_koordinatensystem:
    def __init__(self, canvas, x1, y1):
        self.canvas=canvas
        self.x1=x1
        self.y1=y1
        # Punktbeschreibung
        self.x1=self.x1-4
        self.y1=self.y1-4
        self.x2=self.x1+8
        self.y2=self.y1+8
        self.canvas.create_oval(self.x1, 
                                self.y1, 
                                self.x2, 
                                self.y2,
                                fill='cornflowerblue',
                                tags='punkte_tag')

################################################################################
root = Tk()
root.title('Titrierer')
app = Fenster(root)
root.mainloop()
