#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
import random
# Datendatei
import sys
sys.path.insert(0, 'daten')
from tensidsammlung import tenside
import webbrowser


class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame)
        self.frame2=Frame(frame, height=100)
        self.frame3=Frame(frame, bd=4)
        for f, row, column, columnspan, sticky in (
                (frame,            0, 0, 1, W),
                (self.frame1,      1, 0, 1, W),
                (self.frame2,      2, 0, 1, E+W),
                (self.frame3,      3, 0, 1, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 1: Auswahlmenü Tensideigenschaft
        # Menüleiste als Rahmen innerhalb von Rahmen 1
        self.menueleiste=Frame(self.frame1, bd=2, relief=FLAT)
        master.config(menu=self.menueleiste)

        # Menüknöpfe
        self.mb_datei=Menubutton(self.menueleiste, text='Datei')
        self.mb_tenside=Menubutton(self.menueleiste, text='Tenside')
        # mit diesen zwei Menüknöpfen verknüpfte Drop-Down-Menüs
        # Datei zum Programm Beenden
        self.menue_datei=Menu(self.mb_datei, tearoff=0)
        self.menue_datei.insert_command(0, label='Beenden', command=root.destroy)
        self.mb_datei.config(menu=self.menue_datei)
        # Tenside
        self.menue_tenside=Menu(self.mb_tenside, tearoff=0)
        # Untermenü 1: Struktur
        self.menue_tenside.choices1=Menu(self.menue_tenside, tearoff=0)
        self.menue_tenside.choices1.add_command(label='1.1 Amphiphiler Bau und Zeichenerklärung', command=self.amphiphiler_bau)
        self.menue_tenside.add_cascade(label='1 Struktur', menu=self.menue_tenside.choices1)
        # Untermenü 2: Grenzflächenaktivität
        self.menue_tenside.choices2=Menu(self.menue_tenside, tearoff=0)
        self.menue_tenside.choices2.add_command(label='2.1 Verringerung der Oberflächenspannung', command=self.oberflaechenspannung)
        self.menue_tenside.choices2.add_command(label='2.2 Schaumbildung', command=self.schaumbildung)
        self.menue_tenside.choices2.add_command(label='2.3 Verbesserung der Benetzbarkeit', command=self.benetzbarkeit)
        self.menue_tenside.add_cascade(label='2 Grenzflächenaktivität', menu=self.menue_tenside.choices2)
        # Untermenü 3: Phasengemische
        self.menue_tenside.choices3=Menu(self.menue_tenside, tearoff=0)
        self.menue_tenside.choices3.add_command(label='3.1 Bildung von Micellen', command=self.micellenbildung)
        self.menue_tenside.choices3.add_command(label='3.2 Aufbau der Zellmembran', command=self.zellmembranaufbau)
        self.menue_tenside.choices3.add_command(label='3.3 Öl in Wasser Emulsion', command=self.oel_in_wasser)
        self.menue_tenside.choices3.add_command(label='3.4 Wasser in Öl Emulsion', command=self.wasser_in_oel)
        self.menue_tenside.add_cascade(label='3 Phasengemische', menu=self.menue_tenside.choices3)
        # Untermenü 4: Waschwirkung
        self.menue_tenside.choices4=Menu(self.menue_tenside, tearoff=0)
        self.menue_tenside.choices4.add_command(label='4.1 Fettschmutz an unpolarer Faser', command=self.waschen_unpolar)
        self.menue_tenside.choices4.add_command(label='4.2 Fettschmutz an anionischer Faser', command=self.waschen_anionisch)
        self.menue_tenside.add_cascade(label='4 Waschwirkung', menu=self.menue_tenside.choices4)

        # Menü und Untermenüs hinzufügen
        self.mb_tenside.config(menu=self.menue_tenside)

        # Menüelemente anzeigen
        for i, row, column, sticky in (
                (self.menueleiste,    0, 0, E+W),
                (self.mb_datei,       0, 0, W),
                (self.mb_tenside,     0, 1, W)):
            i.grid(row=row, column=column, sticky=sticky)

        # Rahmen 2: Anzeige der Eigenschaften
        self.f2canvas1=Canvas(self.frame2, width=600, height=500, bg='white')
        self.f2text1=Text(self.frame2, height=24, wrap=WORD, bg='white', width='32', font=('dejavu', '11'))

        # Rahmen 3: Auswahl der möglichen Monomere wird je nach Menüeintrag automatisch generiert
        # s.u. bei den Funktionen!
        self.f3l1=Label(self.frame3,
                        text='Wähle zunächst oben im Tenside-Hauptmenü ein Unterkapitel aus!', fg='red')
        self.f3l1.pack(anchor=W)

        for w, row, column, columnspan, sticky in (
                (self.f2canvas1, 0, 0, 1, E+W),
                (self.f2text1,   0, 1, 1, E+W),
                ):
            w.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        ########################################################################

        global a0
        a0=StringVar()

    def amphiphiler_bau(self):
        #print('1.1 amphiphiler_bau')
        global a0
        self.a0='amphiphiler_bau'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('strukturformel')
        self.r1.select()
        self.auswahl_eigenschaften()

    def oberflaechenspannung(self):
        #print('2.1 oberflaechenspannung')
        global a0
        self.a0='oberflaechenspannung'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('nur_wasser')
        self.r1.select()
        self.auswahl_eigenschaften()

    def schaumbildung(self):
        #print('2.2 schaumbildung')
        global a0
        self.a0='schaumbildung'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('nur_wasser')
        self.r1.select()
        self.auswahl_eigenschaften()

    def benetzbarkeit(self):
        #print('2.3 benetzbarkeit')
        global a0
        self.a0='benetzbarkeit'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('nur_wasser')
        self.r1.select()
        self.auswahl_eigenschaften()

    def micellenbildung(self):
        #print('3.1 micellenbildung')
        global a0
        self.a0='micellenbildung'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('wasser_mit_viel_tensid')
        self.r1.select()
        self.auswahl_eigenschaften()

    def zellmembranaufbau(self):
        #print('3.2 zellmembranaufbau')
        global a0
        self.a0='zellmembranaufbau'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('lipid_doppelschicht')
        self.r1.select()
        self.auswahl_eigenschaften()

    def oel_in_wasser(self):
        #print('3.3 oel_in_wasser')
        global a0
        self.a0='oel_in_wasser'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('oel_und_wasser')
        self.r1.select()
        self.auswahl_eigenschaften()

    def wasser_in_oel(self):
        #print('3.4 wasser_in_oel')
        global a0
        self.a0='wasser_in_oel'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('wasser_und_oel')
        self.r1.select()
        self.auswahl_eigenschaften()

    def waschen_unpolar(self):
        #print('4.1 waschen_unpolar')
        global a0
        self.a0='waschen_unpolar'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('faserbenetzung')
        self.r1.select()
        self.auswahl_eigenschaften()

    def waschen_anionisch(self):
        #print('4.2 waschen_anionisch')
        global a0
        self.a0='waschen_anionisch'
        a0.set(self.a0)
        self.mkRadiobuttons(self.frame3, self.a0)
        a1.set('faserbenetzung')
        self.r1.select()
        self.auswahl_eigenschaften()

    def mkRadiobuttons(self, frame, a0):
        try:
            self.r1.destroy()
            self.r2.destroy()
            self.r3.destroy()
            self.r4.destroy()
            self.r5.destroy()
            self.r6.destroy()
            self.r7.destroy()
        except:
            pass
        self.a0=a0
        global a1
        a1=StringVar()
        if self.a0 == 'amphiphiler_bau':
            self.r1=Radiobutton(frame,
                                text='A Strukturformel eines Fettsäureanions',
                                variable=a1,
                                value='strukturformel',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='B Schema anionisches Tensid',
                                variable=a1,
                                value='schema_anionisch',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r3=Radiobutton(frame,
                                text='C Schema kationisches Tensid',
                                variable=a1,
                                value='schema_kationisch',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r4=Radiobutton(frame,
                                text='D Schema polare Phase (Flüssigkeit oder Gas)',
                                variable=a1,
                                value='schema_polare_phase',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r5=Radiobutton(frame,
                                text='E Schema unpolare Phase (Flüssigkeit oder Gas)',
                                variable=a1,
                                value='schema_unpolare_phase',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle eine Darstellung aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
            self.r3.pack(anchor=W, fill=BOTH, expand=1)
            self.r4.pack(anchor=W, fill=BOTH, expand=1)
            self.r5.pack(anchor=W, fill=BOTH, expand=1)
        elif self.a0 == 'oberflaechenspannung':
            self.r1=Radiobutton(frame,
                                text='1. Nur Wasser',
                                variable=a1,
                                value='nur_wasser',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='2. Wasser mit Wasserläufer',
                                variable=a1,
                                value='wasser_mit_wasserlaeufer',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r3=Radiobutton(frame,
                                text='3. Tensid-Lösung',
                                variable=a1,
                                value='tensid_loesung',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r4=Radiobutton(frame,
                                text='4. Tensid-Lösung mit Wasserläufer',
                                variable=a1,
                                value='tensid_loesung_mit_wasserlaeufer',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle einen Teilschritt aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
            self.r3.pack(anchor=W, fill=BOTH, expand=1)
            self.r4.pack(anchor=W, fill=BOTH, expand=1)
        elif self.a0 == 'schaumbildung':
            self.r1=Radiobutton(frame,
                                text='1. Nur Wasser',
                                variable=a1,
                                value='nur_wasser',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='2. Wasser mit viel Tensid',
                                variable=a1,
                                value='wasser_mit_viel_tensid',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r3=Radiobutton(frame,
                                text='3. Luftblase in Tensid-Lösung',
                                variable=a1,
                                value='luftblase_in_tensid_loesung',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r4=Radiobutton(frame,
                                text='4. Aufsteigende Luftblase',
                                variable=a1,
                                value='aufsteigende_luftblase',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r5=Radiobutton(frame,
                                text='5. Freie Seifenblase',
                                variable=a1,
                                value='freie_seifenblase',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle einen Teilschritt aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
            self.r3.pack(anchor=W, fill=BOTH, expand=1)
            self.r4.pack(anchor=W, fill=BOTH, expand=1)
            self.r5.pack(anchor=W, fill=BOTH, expand=1)
        elif self.a0 == 'benetzbarkeit':
            self.r1=Radiobutton(frame,
                                text='1. Nur Wasser an einer Oberfläche',
                                variable=a1,
                                value='nur_wasser',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='2. Tensid-Lösung an einer Oberfläche',
                                variable=a1,
                                value='tensid_loesung',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r3=Radiobutton(frame,
                                text='3. Unter Berücksichtigung einer negativ polarisierten Oberfläche',
                                variable=a1,
                                value='negativ_polarisierte_oberflaeche',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle einen Teilschritt aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
            self.r3.pack(anchor=W, fill=BOTH, expand=1)
        elif self.a0 == 'micellenbildung':
            self.r1=Radiobutton(frame,
                                text='1. Wasser mit viel Tensid',
                                variable=a1,
                                value='wasser_mit_viel_tensid',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='2. Bildung von Kugel-Micellen',
                                variable=a1,
                                value='kugel_micellen',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r3=Radiobutton(frame,
                                text='3. Bildung von Stab-Micellen',
                                variable=a1,
                                value='stab_micellen',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle einen Teilschritt aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
            self.r3.pack(anchor=W, fill=BOTH, expand=1)
        elif self.a0 == 'zellmembranaufbau':
            self.r1=Radiobutton(frame,
                                text='1. Lipid-Doppelschicht',
                                variable=a1,
                                value='lipid_doppelschicht',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='2. Mit eingebetteten Proteinen',
                                variable=a1,
                                value='eingebettete_proteine',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle eine Darstellung aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
        elif self.a0 == 'oel_in_wasser':
            self.r1=Radiobutton(frame,
                                text='1. Öl und Wasser in getrennten Phasen',
                                variable=a1,
                                value='oel_und_wasser',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='2. Stabilisierte Öl-in-Wasser-Emulsion',
                                variable=a1,
                                value='oel_in_wasser_emulsion',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle einen Teilschritt aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
        elif self.a0 == 'wasser_in_oel':
            self.r1=Radiobutton(frame,
                                text='1. Wasser und Öl in getrennten Phasen',
                                variable=a1,
                                value='wasser_und_oel',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='2. Stabilisierte Wasser-in-Öl-Emulsion',
                                variable=a1,
                                value='wasser_in_oel_emulsion',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle einen Teilschritt aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
        elif self.a0 == 'waschen_unpolar':
            self.r1=Radiobutton(frame,
                                text='1. Benetzung der Faser',
                                variable=a1,
                                value='faserbenetzung',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='2. Bildung stabiler Fettschmutz-Micellen',
                                variable=a1,
                                value='fettschmutz_micellen',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle einen Teilschritt aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
        elif self.a0 == 'waschen_anionisch':
            self.r1=Radiobutton(frame,
                                text='1. Benetzung der Faser',
                                variable=a1,
                                value='faserbenetzung',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r2=Radiobutton(frame,
                                text='2. Bildung stabiler Fettschmutz-Micellen',
                                variable=a1,
                                value='fettschmutz_micellen',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.r3=Radiobutton(frame,
                                text='3. Kationisches Tensid als "Weichspüler"',
                                variable=a1,
                                value='weichspueler',
                                anchor=W,
                                justify=LEFT,
                                indicatoron=0,
                                command=self.auswahl_eigenschaften)
            self.f3l1.config(text='Wähle einen Teilschritt aus:', fg='black')
            self.r1.pack(anchor=W, fill=BOTH, expand=1)
            self.r2.pack(anchor=W, fill=BOTH, expand=1)
            self.r3.pack(anchor=W, fill=BOTH, expand=1)


    def auswahl_eigenschaften(self):
        global a0
        self.unterkapitel=str(a0.get())
        global a1
        self.teilschritt=str(a1.get())
        print(self.unterkapitel+'/'+self.teilschritt)
        self.pfad='daten/img/'+self.unterkapitel+'/'+self.teilschritt+'.gif'
        self.wechselbild=PhotoImage(file=self.pfad)
        self.f2canvas1.create_image(0, 0, image=self.wechselbild, anchor=NW)
        # TO DO.: Text für den Teilschritt holen und in Textfeld einfügen
        self.beschreibungstext=str(tenside[self.unterkapitel][self.teilschritt])
        self.f2text1.config(state=NORMAL)
        self.f2text1.delete(1.0, END)
        self.f2text1.insert(1.0, self.beschreibungstext)
        self.f2text1.config(state=DISABLED)

################################################################################
root = Tk()
root.title('Tensider')
#root.option_add("*Text.Font", "dejavu 12")
#root.minsize()
app = Fenster(root)
root.mainloop()
