#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
import random
# Datendatei
import sys
sys.path.insert(0, 'daten')
from molekuelsammlung import molekuele

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=4)
        self.frame2=Frame(frame, pady=4, padx=4)
        self.frame3=Frame(frame, pady=4, padx=4)
        self.frame4=Frame(frame, pady=4, padx=4)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 6, E+W),
                (self.frame1, 0, 0, 6, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 1, 1, 5, E+W),
                (self.frame4, 2, 0, 6, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 1: Anzeige des Namens und der Summen- bzw. Halbstrukturformel 
        #           des gesuchten Moleküls
        self.f1l1=Label(self.frame1, text='Name:')
        self.f1e1=Entry(self.frame1, background='white', 
                        #disabledbackground='white',
                        #disabledforeground='black',
                        width='30', 
                        font=('arial', '11'))
        self.f1l2=Label(self.frame1, text='Summenformel:')
        self.f1e2=Entry(self.frame1, background='white', 
                        #disabledbackground='white',
                        #disabledforeground='black',
                        width='20', 
                        font=('arial', '11'))
        for i, row, column, columnspan, rowspan, sticky in (
                (self.f1l1,     0, 0, 1, 1, E+W), 
                (self.f1e1,     0, 1, 1, 1, E+W),
                (self.f1l2,     0, 2, 1, 1, E+W), 
                (self.f1e2,     0, 3, 1, 1, E+W)
                ):
            i.grid(row=row, column=column, columnspan=columnspan, 
                   rowspan=rowspan, sticky=sticky)
        
        # Rahmen 2: Auswahl des einzufügenden Fertigbausteins
        self.f2l1=Label(self.frame2, text='1. Wähle den einzufügenden Bausteien aus:')
        global a1
        a1 = StringVar()
        a1.set('X')
        self.f2a1r1=Radiobutton(self.frame2, 
                             text='Wasserstoffatom H•',
                             variable=a1, 
                             value='H',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r2=Radiobutton(self.frame2, 
                             text='Fluoratom F•',
                             variable=a1, 
                             value='F',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r3=Radiobutton(self.frame2, 
                             text='Chloratom Cl•',
                             variable=a1, 
                             value='Cl',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r4=Radiobutton(self.frame2, 
                             text='Bromatom Br•',
                             variable=a1, 
                             value='Br',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r5=Radiobutton(self.frame2, 
                             text='Iodatom I•',
                             variable=a1, 
                             value='I',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r6=Radiobutton(self.frame2, 
                             text='Hydroxy-Gruppe HO•',
                             variable=a1, 
                             value='HO',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r7=Radiobutton(self.frame2, 
                             text='Amino-Gruppe H₂N•',
                             variable=a1, 
                             value='H2N',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r8=Radiobutton(self.frame2, 
                             text='Methyl-Gruppe H₃C•',
                             variable=a1, 
                             value='H3C',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r9=Radiobutton(self.frame2, 
                             text='Aminonium-Gruppe [H₃N•]⁺\n(= protonierte Amino-Gruppe)',
                             variable=a1, 
                             value='H3N',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r10=Radiobutton(self.frame2, 
                             text='Oxonium-Gruppe [H₂O•]⁺\n(= protonierte Hydroxy-Gruppe)',
                             variable=a1, 
                             value='H2O',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r11=Radiobutton(self.frame2, 
                             text='Oxid-Gruppe [O•]⁻\n(= deprotonierte Hydroxy-Gruppe)',
                             variable=a1, 
                             value='O',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r12=Radiobutton(self.frame2, 
                             text='Methylen-Gruppe mit zwei Einfachbindungen •H₂C•',
                             variable=a1, 
                             value='H2C_zweimal_einfach',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r13=Radiobutton(self.frame2, 
                             text='Methylen-Gruppe mit einer Doppelbindung H₂C:',
                             variable=a1, 
                             value='H2C_einmal_doppel',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r14=Radiobutton(self.frame2, 
                             text='Carbonyl-Gruppe mit zwei Einfachbindungen •C(=O)•',
                             variable=a1, 
                             value='CO',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        self.f2a1r15=Radiobutton(self.frame2, 
                             text='Baustein wieder entfernen',
                             variable=a1, 
                             value='X',
                             indicatoron=0, 
                             command=self.a1_festlegen,
                             anchor=W,
                             justify=LEFT)
        for i, state in (
            (self.f1e1,     DISABLED),
            (self.f1e2,     DISABLED),
            (self.f2a1r1,   DISABLED),
            (self.f2a1r2,   DISABLED),
            (self.f2a1r3,   DISABLED),
            (self.f2a1r4,   DISABLED),
            (self.f2a1r5,   DISABLED),
            (self.f2a1r6,   DISABLED),
            (self.f2a1r7,   DISABLED),
            (self.f2a1r8,   DISABLED),
            (self.f2a1r9,   DISABLED),
            (self.f2a1r10,  DISABLED),
            (self.f2a1r11,  DISABLED),
            (self.f2a1r12,  DISABLED),
            (self.f2a1r13,  DISABLED),
            (self.f2a1r14,  DISABLED),
            (self.f2a1r15,  DISABLED),
            ):
            i.config(state=state)
        
        for i, row, column, columnspan, rowspan, sticky in (
                (self.f2l1,      0,  0, 1, 1, E+W), 
                (self.f2a1r1,      1,  0, 1, 1, E+W), 
                (self.f2a1r2,      2,  0, 1, 1, E+W), 
                (self.f2a1r3,      3,  0, 1, 1, E+W),
                (self.f2a1r4,      4,  0, 1, 1, E+W),
                (self.f2a1r5,      5,  0, 1, 1, E+W),
                (self.f2a1r6,      6,  0, 1, 1, E+W),
                (self.f2a1r7,      7,  0, 1, 1, E+W),
                (self.f2a1r8,      8,  0, 1, 1, E+W),
                (self.f2a1r9,      9,  0, 1, 1, E+W),
                (self.f2a1r10,     10, 0, 1, 1, E+W),
                (self.f2a1r11,     11, 0, 1, 1, E+W),
                (self.f2a1r12,     12, 0, 1, 1, E+W),
                (self.f2a1r13,     13, 0, 1, 1, E+W),
                (self.f2a1r14,     14, 0, 1, 1, E+W),
                (self.f2a1r15,     15, 0, 1, 1, E+W)
                ):
            i.grid(row=row, column=column, columnspan=columnspan, 
                   rowspan=rowspan, sticky=sticky)
                   
        
        # Rahmen 3: Zielfelder für die Bausteine als Radiobuttons mit GIFs
        self.f3l1=Label(self.frame3, 
                        text='2. Wähle das Zielfeld aus:')
        global a2
        a2 = StringVar()
        a2.set('X')
        icon_f3a2r1=PhotoImage(file='daten/img/startflaeche_buttons.gif')
        self.f3a2r1=Radiobutton(self.frame3, 
                                variable=a2, 
                                value='feld1',
                                indicatoron=0, 
                                command=self.a2_festlegen, 
                                image=icon_f3a2r1,
                                bg='white')
        self.f3a2r1.icon_f3a2r1=icon_f3a2r1
        icon_f3a2r2=PhotoImage(file='daten/img/startflaeche_buttons.gif')
        self.f3a2r2=Radiobutton(self.frame3, 
                                variable=a2, 
                                value='feld2', 
                                indicatoron=0, 
                                command=self.a2_festlegen, 
                                image=icon_f3a2r2,
                                bg='white')
        self.f3a2r2.icon_f3a2r2=icon_f3a2r2
        icon_f3a2r3=PhotoImage(file='daten/img/startflaeche_buttons.gif')
        self.f3a2r3=Radiobutton(self.frame3, 
                                variable=a2, 
                                value='feld3', 
                                indicatoron=0, 
                                command=self.a2_festlegen, 
                                image=icon_f3a2r3,
                                bg='white')
        self.f3l2=Label(self.frame3, 
                        text='Lösung:')
        self.f3a2r3.icon_f3a2r3=icon_f3a2r3

        for i, state in (
            (self.f3a2r1,     DISABLED),
            (self.f3a2r2,     DISABLED),
            (self.f3a2r3,     DISABLED)
            ):
            i.config(state=state)
        
        for i, row, column, columnspan, rowspan, sticky in (
                (self.f3l1,           0,  0, 3, 1, E+W), 
                (self.f3a2r1,         1,  0, 1, 1, E+W), 
                (self.f3a2r2,         1,  1, 1, 1, E+W), 
                (self.f3a2r3,         1,  2, 1, 1, E+W)
                ):
            i.grid(row=row, column=column, columnspan=columnspan, 
                   rowspan=rowspan, sticky=sticky)
        
        # Rahmen 4: Navigationsknöpfe
        self.menueleiste=Frame(self.frame4, bd=2, relief=RIDGE)
        master.config(menu=self.menueleiste)
        # Menüknöpfe
        self.mb_auswahl=Menubutton(self.menueleiste, text='Molekül oder Molekülion auswählen')
        self.menue_auswahl=Menu(self.mb_auswahl, tearoff=0)
        self.nr=IntVar()
        self.menue_auswahl.add_radiobutton(label=molekuele[0][0], variable=self.nr, value=0, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[1][0], variable=self.nr, value=1, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[2][0], variable=self.nr, value=2, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[3][0], variable=self.nr, value=3, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[4][0], variable=self.nr, value=4, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[5][0], variable=self.nr, value=5, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[6][0], variable=self.nr, value=6, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[7][0], variable=self.nr, value=7, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[8][0], variable=self.nr, value=8, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[9][0], variable=self.nr, value=9, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[10][0], variable=self.nr, value=10, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[11][0], variable=self.nr, value=11, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[12][0], variable=self.nr, value=12, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[13][0], variable=self.nr, value=13, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[14][0], variable=self.nr, value=14, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[15][0], variable=self.nr, value=15, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[16][0], variable=self.nr, value=16, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[17][0], variable=self.nr, value=17, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[18][0], variable=self.nr, value=18, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[19][0], variable=self.nr, value=19, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[20][0], variable=self.nr, value=20, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[21][0], variable=self.nr, value=21, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[22][0], variable=self.nr, value=22, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[23][0], variable=self.nr, value=23, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[24][0], variable=self.nr, value=24, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[25][0], variable=self.nr, value=25, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[26][0], variable=self.nr, value=26, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[27][0], variable=self.nr, value=27, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[28][0], variable=self.nr, value=28, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[29][0], variable=self.nr, value=29, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[30][0], variable=self.nr, value=30, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[31][0], variable=self.nr, value=31, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[32][0], variable=self.nr, value=32, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[33][0], variable=self.nr, value=33, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[34][0], variable=self.nr, value=34, command=self.auswahl_molekuel)
        self.menue_auswahl.add_radiobutton(label=molekuele[35][0], variable=self.nr, value=35, command=self.auswahl_molekuel)
        self.mb_auswahl.config(menu=self.menue_auswahl)
        self.f4b2=Button(self.frame4, 
                         text='Lösung anzeigen', 
                         command=self.loesung_ueberpruefen)
        self.f4b3=Button(self.frame4, 
                         text='Beenden', 
                          command=root.destroy)
        for i, row, column, columnspan, rowspan, sticky in (
                (self.menueleiste,   0,  0, 1, 1, E+W), 
                (self.mb_auswahl,    0,  0, 1, 1, W),
                (self.f4b2,          0,  1, 1, 1, E+W), 
                (self.f4b3,          0,  2, 1, 1, E+W)
                ):
            i.grid(row=row, column=column, columnspan=columnspan, 
                   rowspan=rowspan, sticky=sticky)
    
        ########################################################################
    
    def a2_festlegen(self):
        self.gruppe=str(a1.get())
        self.feld=str(a2.get())
        self.gruppe_feld1='X'
        self.gruppe_feld2='X'
        self.gruppe_feld3='X'
        if self.feld == 'feld1':
            icon_f3a2r1=PhotoImage(file='daten/img'+os.sep+self.feld+os.sep+self.gruppe+'.gif')
            self.gruppe_feld1=self.gruppe
            self.f3a2r1.config(image=icon_f3a2r1)
            self.f3a2r1.icon_f3a2r1=icon_f3a2r1
        elif self.feld == 'feld2':
            icon_f3a2r2=PhotoImage(file='daten/img'+os.sep+self.feld+os.sep+self.gruppe+'.gif')
            self.gruppe_feld2=self.gruppe
            self.f3a2r2.config(image=icon_f3a2r2)
            self.f3a2r2.icon_f3a2r2=icon_f3a2r2
        elif self.feld == 'feld3':
            icon_f3a2r3=PhotoImage(file='daten/img'+os.sep+self.feld+os.sep+self.gruppe+'.gif')
            self.gruppe_feld3=self.gruppe
            self.f3a2r3.config(image=icon_f3a2r3)
            self.f3a2r3.icon_f3a2r3=icon_f3a2r3
        #print self.gruppe_feld1+self.gruppe_feld2+self.gruppe_feld3
        
    def a1_festlegen(self):
        pass
        #print(a1.get())
        
    def auswahl_molekuel(self):
        for i, state in (
            (self.f1e1,     NORMAL),
            (self.f1e2,     NORMAL),
            (self.f2a1r1,   NORMAL),
            (self.f2a1r2,   NORMAL),
            (self.f2a1r3,   NORMAL),
            (self.f2a1r4,   NORMAL),
            (self.f2a1r5,   NORMAL),
            (self.f2a1r6,   NORMAL),
            (self.f2a1r7,   NORMAL),
            (self.f2a1r8,   NORMAL),
            (self.f2a1r9,   NORMAL),
            (self.f2a1r10,  NORMAL),
            (self.f2a1r11,  NORMAL),
            (self.f2a1r12,  NORMAL),
            (self.f2a1r13,  NORMAL),
            (self.f2a1r14,  NORMAL),
            (self.f2a1r15,  NORMAL),
            (self.f3a2r1,   NORMAL),
            (self.f3a2r2,   NORMAL),
            (self.f3a2r3,   NORMAL),
            ):
            i.config(state=state)
        a1.set('H')
        self.a1_festlegen()
        #print('auswahl_molekuel')
        self.laufzahl=self.nr.get()
        self.molekuelname=molekuele[self.laufzahl][0]
        self.summenformel=molekuele[self.laufzahl][1]
        self.f1e1.delete(0, END)
        self.f1e2.delete(0, END)
        self.f1e1.insert(0, self.molekuelname)
        self.f1e2.insert(0, self.summenformel)
        icon_f3a2r1=PhotoImage(file='daten/img/startflaeche_buttons.gif')
        self.f3a2r1.config(image=icon_f3a2r1)
        self.f3a2r1.icon_f3a2r1=icon_f3a2r1
        icon_f3a2r2=PhotoImage(file='daten/img/startflaeche_buttons.gif')
        self.f3a2r2.config(image=icon_f3a2r2)
        self.f3a2r2.icon_f3a2r2=icon_f3a2r2
        icon_f3a2r3=PhotoImage(file='daten/img/startflaeche_buttons.gif')
        self.f3a2r3.config(image=icon_f3a2r3)
        self.f3a2r3.icon_f3a2r3=icon_f3a2r3
        
    def loesung_ueberpruefen(self):
        self.laufzahl=self.nr.get()
        self.loesung_feld1=molekuele[self.laufzahl][2]
        self.loesung_feld2=molekuele[self.laufzahl][3]
        self.loesung_feld3=molekuele[self.laufzahl][4]
        icon_f3a2r1=PhotoImage(file='daten/img/feld1/'+self.loesung_feld1+'.gif')
        self.f3a2r1.config(image=icon_f3a2r1)
        self.f3a2r1.icon_f3a2r1=icon_f3a2r1
        icon_f3a2r2=PhotoImage(file='daten/img/feld2/'+self.loesung_feld2+'.gif')
        self.f3a2r2.config(image=icon_f3a2r2)
        self.f3a2r2.icon_f3a2r2=icon_f3a2r2
        icon_f3a2r3=PhotoImage(file='daten/img/feld2/'+self.loesung_feld3+'.gif')
        self.f3a2r3.config(image=icon_f3a2r3)
        self.f3a2r3.icon_f3a2r3=icon_f3a2r3

################################################################################
root = Tk()
root.title('Strukturformler')
app = Fenster(root)
root.mainloop()
