#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame0=Frame(frame)
        self.frame1=Frame(frame)
        self.frame2=Frame(frame)
        self.frame3=Frame(frame, bd=8, padx=8)
        self.frame4=Frame(frame, bd=8, padx=8)
        self.frame5=Frame(frame, pady=8)
        self.frame6=Frame(frame)
        for f, row, column, columnspan in ((frame, 0, 0, 1),
                                           (self.frame0, 0, 0, 2),
                                           (self.frame1, 1, 0, 1),
                                           (self.frame2, 1, 1, 1),
                                           (self.frame3, 2, 0, 1),
                                           (self.frame4, 2, 1, 1),
                                           (self.frame5, 3, 0, 2),
                                           (self.frame6, 4, 0, 2)):
            f.grid(row=row, column=column, columnspan=columnspan)

        # Chemische Daten
        self.carbonylverbindungen={
            '00':'Aldehyd',
            '01':'Aldehyd',
            '10':'Aldehyd',
            '11':'Keton',
            '20':'Carbonsäure und Aldehyd',
            '02':'Aldehyd und Carbonsäure',
            '21':'Carbonsäure',
            '12':'Carbonsäure',
            '22':'Kohlensäure',
            '30':'Ester',
            '03':'Ester',
            '31':'Ester',
            '13':'Ester',
            '32':'Kohlensäureester',
            '23':'Kohlensäureester',
            '33':'Kohlensäurediester',
            '40':'Carbonsäureamid',
            '04':'Carbonsäureamid',
            '41':'Carbonsäureamid',
            '14':'Carbonsäureamid',
            '44':'Harnstoff',
            '42':'Carbamidsäure',
            '24':'Carbamidsäure',
            '43':'Carbamidsäureester',
            '34':'Carbamidsäureester'
        }

        self.hydroxyverbindungen={
            # Hydroxyverbindungen
            '0000':'Primärer Alkohol',
            '0010':'Primärer Alkohol',
            '0020':'Hydrat',
            '0030':'Halbacetal',
            '0040':'Halbaminal',
            '0100':'Primärer Alkohol',
            '0110':'Sekundärer Alkohol',
            '0120':'Hydrat',
            '0130':'Halbacetal',
            '0140':'Halbaminal',
            '0200':'Hydrat',
            '0210':'Hydrat',
            '0220':'Nicht erlaubt',
            '0230':'Nicht erlaubt',
            '0240':'Nicht stabil',
            '0300':'Halbacetal',
            '0310':'Halbacetal',
            '0320':'Nicht stabil',
            '0330':'Nicht stabil',
            '0340':'Nicht stabil',
            '0400':'Halbaminal',
            '0410':'Halbaminal',
            '0420':'Nicht stabil',
            '0430':'Nicht stabil',
            '0440':'Nicht stabil',
            '1000':'Primärer Alkohol',
            '1010':'Sekundärer Alkohol',
            '1020':'Hydrat',
            '1030':'Halbacetal',
            '1040':'Halbaminal',
            '1100':'Sekundärer Alkohol',
            '1110':'Tertiärer Alkohol',
            '1120':'Hydrat',
            '1130':'Halbketal',
            '1140':'Halbaminal',
            '1200':'Hydrat',
            '1210':'Hydrat',
            '1220':'Nicht erlaubt',
            '1230':'Nicht erlaubt',
            '1240':'Nicht stabil',
            '1300':'Halbacetal',
            '1310':'Halbketal',
            '1320':'Nicht stabil',
            '1330':'Nicht stabil',
            '1340':'Nicht stabil',
            '1400':'Halbaminal',
            '1410':'Halbaminal',
            '1420':'Nicht stabil',
            '1430':'Nicht stabil',
            '1440':'Nicht stabil',
            '2000':'Hydrat',
            '2010':'Hydrat',
            '2020':'Nicht stabil',
            '2030':'Nicht stabil',
            '2040':'Nicht stabil',
            '2100':'Hydrat',
            '2110':'Hydrat',
            '2120':'Nicht stabil',
            '2130':'Nicht stabil',
            '2140':'Nicht stabil',
            '2200':'Nicht stabil',
            '2210':'Nicht stabil',
            '2220':'Nicht erlaubt',
            '2230':'Nicht erlaubt',
            '2240':'Nicht stabil',
            '2300':'Nicht stabil',
            '2310':'Nicht stabil',
            '2320':'Nicht stabil',
            '2330':'Nicht stabil',
            '2340':'Nicht stabil',
            '2400':'Nicht stabil',
            '2410':'Nicht stabil',
            '2420':'Nicht stabil',
            '2430':'Nicht stabil',
            '2440':'Nicht stabil',
            '3000':'Halbacetal',
            '3010':'Halbacetal',
            '3020':'Nicht stabil',
            '3030':'Nicht stabil',
            '3040':'Nicht stabil',
            '3100':'Halbacetal',
            '3110':'Halbketal',
            '3120':'Nicht stabil',
            '3130':'Nicht stabil',
            '3140':'Nicht stabil',
            '3200':'Nicht stabil',
            '3210':'Nicht stabil',
            '3220':'Nicht erlaubt',
            '3230':'Nicht erlaubt',
            '3240':'Nicht stabil',
            '3300':'Nicht stabil',
            '3310':'Nicht stabil',
            '3320':'Nicht stabil',
            '3330':'Nicht stabil',
            '3340':'Nicht stabil',
            '3400':'Nicht stabil',
            '3410':'Nicht stabil',
            '3420':'Nicht stabil',
            '3430':'Nicht stabil',
            '3440':'Nicht stabil',
            '4000':'Halbaminal',
            '4010':'Halbaminal',
            '4020':'Nicht stabil',
            '4030':'Nicht stabil',
            '4040':'Nicht stabil',
            '4100':'Halbaminal',
            '4110':'Halbaminal',
            '4120':'Nicht stabil',
            '4130':'Nicht stabil',
            '4140':'Nicht stabil',
            '4200':'Nicht stabil',
            '4210':'Nicht stabil',
            '4220':'Nicht erlaubt',
            '4230':'Nicht erlaubt',
            '4240':'Nicht stabil',
            '4300':'Nicht stabil',
            '4310':'Nicht stabil',
            '4320':'Nicht stabil',
            '4330':'Nicht stabil',
            '4340':'Nicht stabil',
            '4400':'Nicht stabil',
            '4410':'Nicht stabil',
            '4420':'Nicht stabil',
            '4430':'Nicht stabil',
            '4440':'Nicht stabil',
            # Carboxyverbindungen
            '0001':'Ether',
            '0011':'Ether',
            '0021':'Halbacetal',
            '0031':'Vollacetal',
            '0041':'Halbaminal',
            '0101':'Ether',
            '0111':'Ether',
            '0121':'Halbacetal',
            '0131':'Vollacetal',
            '0141':'Halbaminal',
            '0201':'Halbacetal',
            '0211':'Halbacetal',
            '0221':'Nicht erlaubt',
            '0231':'Nicht erlaubt',
            '0241':'Nicht stabil',
            '0301':'Vollacetal',
            '0311':'Vollacetal',
            '0321':'Nicht stabil',
            '0331':'Nicht stabil',
            '0341':'Nicht stabil',
            '0401':'Halbaminal',
            '0411':'Nicht stabil',
            '0421':'Nicht stabil',
            '0431':'Nicht stabil',
            '0441':'Nicht stabil',
            '1001':'Ether',
            '1011':'Ether',
            '1021':'Halbacetal',
            '1031':'Vollacetal',
            '1041':'Halbaminal',
            '1101':'Ether',
            '1111':'Ether',
            '1121':'Halbketal',
            '1131':'Vollketal',
            '1141':'Halbaminal',
            '1201':'Halbacetal',
            '1211':'Halbketal',
            '1221':'Nicht erlaubt',
            '1231':'Nicht erlaubt',
            '1241':'Nicht stabil',
            '1301':'Vollacetal',
            '1311':'Vollketal',
            '1321':'Nicht stabil',
            '1331':'Nicht stabil',
            '1341':'Nicht stabil',
            '1401':'Halbaminal',
            '1411':'Halbaminal',
            '1421':'Nicht stabil',
            '1431':'Nicht stabil',
            '1441':'Nicht stabil',
            '2001':'Halbacetal',
            '2011':'Halbacetal',
            '2021':'Nicht stabil',
            '2031':'Nicht stabil',
            '2041':'Nicht stabil',
            '2101':'Halbacetal',
            '2111':'Halbketal',
            '2121':'Nicht stabil',
            '2131':'Nicht stabil',
            '2141':'Nicht stabil',
            '2201':'Nicht stabil',
            '2211':'Nicht stabil',
            '2221':'Nicht erlaubt',
            '2231':'Nicht erlaubt',
            '2241':'Nicht stabil',
            '2301':'Nicht stabil',
            '2311':'Nicht stabil',
            '2321':'Nicht stabil',
            '2331':'Nicht stabil',
            '2341':'Nicht stabil',
            '2401':'Nicht stabil',
            '2411':'Nicht stabil',
            '2421':'Nicht stabil',
            '2431':'Nicht stabil',
            '2441':'Nicht stabil',
            '3001':'Vollacetal',
            '3011':'Vollacetal',
            '3021':'Nicht stabil',
            '3031':'Nicht stabil',
            '3041':'Nicht stabil',
            '3101':'Vollacetal',
            '3111':'Vollketal',
            '3121':'Nicht stabil',
            '3131':'Nicht stabil',
            '3141':'Nicht stabil',
            '3201':'Nicht stabil',
            '3211':'Nicht stabil',
            '3221':'Nicht erlaubt',
            '3231':'Nicht erlaubt',
            '3241':'Nicht stabil',
            '3301':'Nicht stabil',
            '3311':'Nicht stabil',
            '3321':'Nicht stabil',
            '3331':'Nicht stabil',
            '3341':'Nicht stabil',
            '3401':'Nicht stabil',
            '3411':'Nicht stabil',
            '3421':'Nicht stabil',
            '3431':'Nicht stabil',
            '3441':'Nicht stabil',
            '4001':'Halbaminal',
            '4011':'Nicht stabil',
            '4021':'Nicht stabil',
            '4031':'Nicht stabil',
            '4041':'Nicht stabil',
            '4101':'Halbaminal',
            '4111':'Halbaminal',
            '4121':'Nicht stabil',
            '4131':'Nicht stabil',
            '4141':'Nicht stabil',
            '4201':'Nicht stabil',
            '4211':'Nicht stabil',
            '4221':'Nicht erlaubt',
            '4231':'Nicht erlaubt',
            '4241':'Nicht stabil',
            '4301':'Nicht stabil',
            '4311':'Nicht stabil',
            '4321':'Nicht stabil',
            '4331':'Nicht stabil',
            '4341':'Nicht stabil',
            '4401':'Nicht stabil',
            '4411':'Nicht stabil',
            '4421':'Nicht stabil',
            '4431':'Nicht stabil',
            '4441':'Nicht stabil',
        }

        sk_info={
            'Primärer Alkohol':'',
            'Sekundärer Alkohol':'',
            'Tertiärer Alkohol':'',
            'Aldehyd':'',
            'Keton':'',
            'Carbonsäure':'',
            'Ester':'',
            'Ether':'',
            'Carbonsäureamid':'',
            'Carbamidsäureester':'',
            'Hydrat':'',
            'Halbacetal':'',
            'Halbaminal':'',
            'Vollacetal':'',
            'Halbketal':'',
            'Vollketal':'',
            'Nicht stabil':''
        }

        self.reste1_li=('H', 'R', 'HO', 'RO', 'H₂N')
        self.reste1_re=('H', 'R', 'OH', 'OR', 'NH₂')
        self.reste2=('H', 'R')

        global v
        v = StringVar()
        v.set('X') 

        # Frame 0: Überschrift
        self.label0=Label(self.frame0, 
                          text='Sauerstoffhaltige organische Verbindungen')
        self.label0.grid(row=0, column=0)
        # Frame 1 und Frame 2: Vorauswahl
        self.radiobutton1=Radiobutton(self.frame1, 
                                       text='Carbonylverbindungen',
                                       variable=v, 
                                       value='carb', 
                                       command=self.vorauswahl_testen)
        self.radiobutton2=Radiobutton(self.frame2,
                                       text='Hydroxy- und Alkoxyverbindungen',
                                       variable=v, 
                                       value='hydrox', 
                                       command=self.vorauswahl_testen)
        for r, row, column in ((self.radiobutton1, 4, 0),
                               (self.radiobutton2, 4, 5)):
            r.grid(row=row, column=column)
       
        # Frame 3 und Frame 4: Strukturformelausschnitte
        self.scroll1=Scrollbar(self.frame3, orient=VERTICAL, width=10)
        self.listbox1=Listbox(self.frame3, width=4, height=1,
                              exportselection=0,
                              yscrollcommand=self.scroll1.set,
                              fg='white',
                              bg='red',
                              borderwidth='0',
                              selectbackground='white',
                              selectforeground='black')
        self.scroll1.config(command=self.listbox1.yview)
        self.scroll2=Scrollbar(self.frame3, orient=VERTICAL, width=10)
        self.listbox2=Listbox(self.frame3, width=4, height=1,
                              exportselection=0,
                              yscrollcommand=self.scroll2.set,
                              fg='white',
                              bg='red',
                              borderwidth='0',
                              selectbackground='white',
                              selectforeground='black')
        self.scroll2.config(command=self.listbox2.yview)
        self.scroll3=Scrollbar(self.frame4, orient=VERTICAL, width=10)
        self.listbox3=Listbox(self.frame4, width=4, height=1,
                              exportselection=0,
                              yscrollcommand=self.scroll3.set,
                              fg='white',
                              bg='red',
                              borderwidth='0',
                              selectbackground='white',
                              selectforeground='black')
        self.scroll3.config(command=self.listbox3.yview)
        self.scroll4=Scrollbar(self.frame4, orient=VERTICAL, width=10)
        self.listbox4=Listbox(self.frame4, width=4, height=1,
                              exportselection=0,
                              yscrollcommand=self.scroll4.set,
                              fg='white',
                              bg='red',
                              borderwidth='0',
                              selectbackground='white',
                              selectforeground='black')
        self.scroll4.config(command=self.listbox4.yview)
        self.scroll5=Scrollbar(self.frame4, orient=VERTICAL, width=10)
        self.listbox5=Listbox(self.frame4, width=4, height=1,
                              exportselection=0,
                              yscrollcommand=self.scroll5.set,
                              fg='white',
                              bg='red',
                              borderwidth='0',
                              selectbackground='white',
                              selectforeground='black')
        self.scroll5.config(command=self.listbox5.yview)
        self.scroll6=Scrollbar(self.frame4, orient=VERTICAL, width=10)
        self.listbox6=Listbox(self.frame4, width=4, height=1,
                              exportselection=0,
                              yscrollcommand=self.scroll6.set,
                              fg='white',
                              bg='red',
                              borderwidth='0',
                              selectbackground='white',
                              selectforeground='black')
        self.scroll6.config(command=self.listbox6.yview)
        for l, row, column in ((self.listbox1, 4, 0),
                               (self.listbox2, 4, 5),
                               (self.listbox3, 4, 0),
                               (self.listbox4, 6, 3),
                               (self.listbox5, 4, 5),
                               (self.listbox6, 0, 3)):
            l.grid(row=row, column=column)
        for l, reste in ((self.listbox1, self.reste1_li),
                         (self.listbox2, self.reste1_re),
                         (self.listbox3, self.reste1_li),
                         (self.listbox4, self.reste1_re),
                         (self.listbox5, self.reste1_re),
                         (self.listbox6, self.reste2)):
            for item in reste:
                l.insert(END, item)
                #l.select_set(0, 0)
        for l, row, column in (
                # self. frame3
                (self.scroll1, 4, 1),
                (self.scroll2, 4, 6),
                # self.frame4
                (self.scroll3, 4, 1),
                (self.scroll4, 6, 4),
                (self.scroll5, 4, 6),
                (self.scroll6, 0, 4)):
            l.grid(row=row, column=column)
        self.label1=Label(self.frame3, text='/ O \\')
        self.label2=Label(self.frame3, text='||')
        self.label3=Label(self.frame3, text=' – ')
        self.label4=Label(self.frame3, text=' – ')
        self.label5=Label(self.frame3, text='C')
        self.label6=Label(self.frame4, text='|')
        self.label7=Label(self.frame4, text='| O |')
        self.label8=Label(self.frame4, text='|')
        self.label9=Label(self.frame4, text='C')
        self.label10=Label(self.frame4, text='|')
        self.label11=Label(self.frame4, text=' – ')
        self.label12=Label(self.frame4, text=' – ')
        for l, row, column in ((self.label1, 2, 3),
                               (self.label2, 3, 3),
                               (self.label3, 4, 2),
                               (self.label4, 4, 4),
                               (self.label5, 4, 3),
                               (self.label6, 1, 3),
                               (self.label7, 2, 3),
                               (self.label8, 3, 3),
                               (self.label9, 4, 3),
                               (self.label10, 5, 3),
                               (self.label11, 4, 2),
                               (self.label12, 4, 4)):
            l.grid(row=row, column=column, sticky=E+W)
        self.label13=Label(self.frame3, text="R = Alkylrest", pady=40)
        self.label13.grid(row=7, column=0, columnspan=4)

        # Frame 5: Auswertung
        self.label13=Label(self.frame5, text='Stoffklasse:')
        self.text1=Text(self.frame5, 
                        background='white', 
                        height='1', 
                        width='40', 
                        wrap=WORD,
                        state=DISABLED)
        for w, row, column in ((self.label13, 0, 0),
                               (self.text1, 0, 1)):
            w.grid(row=row, column=column, sticky=E+W)
        #self.text1.tag_config('a', foreground="blue", underline=1)
        #self.text1.tag_bind(self.text1, '<Button-1>', self.link_oeffnen)
        #self.text1.config(cursor='arrow')
        #self.text1.config(state=NORMAL)
        #self.text1.insert(INSERT, "click here!", "a")

        # Frame 6: Buttons
        self.button1=Button(self.frame6,
                            text='Stoffklasse ermitteln',
                            command=self.auswahl)
        self.button2=Button(self.frame6,
                            text='Zurücksetzen',
                            command=self.zuruecksetzen)
        self.button3=Button(self.frame6,
                            text='Beenden',
                            command=root.destroy)
        for b, row, column in ((self.button1, 0, 0),
                               (self.button2, 0, 1),
                               (self.button3, 0, 2)):
            b.grid(row=row, column=column, sticky=E+W)

        self.listboxen_carb=(self.listbox1, self.listbox2)
        self.listboxen_hydrox=(self.listbox3, self.listbox4, 
                          self.listbox5, self.listbox6)
        #self.scroll_carb=(self.scroll1, self.scroll2)
        #self.scroll_hydrox=(self.scroll3, self.scroll4, 
        #                    self.scroll5, self.scroll6) 
        for t in (self.listboxen_carb, self.listboxen_hydrox):
            for i in t:
                i.select_set(0, 0)
                i.config(state=DISABLED)

    ############################################################################
    def auswahl(self):
        self.vorauswahl = v.get()
        if self.vorauswahl == 'carb':
            self.auswahl_carbonylverb()
        elif self.vorauswahl == 'hydrox':
            self.auswahl_hydroxyverb()

    def auswahl_carbonylverb(self):
        i1=self.listbox1.curselection()[0]
        i2=self.listbox2.curselection()[0]
        schluessel=str(i1)+str(i2)
        #print(schluessel, self.carbonylverbindungen[schluessel])
        self.text1.config(state=NORMAL)
        self.text1.config(bg='white')
        self.text1.delete(1.0, END)
        self.text1.insert(INSERT, self.carbonylverbindungen[schluessel])
        self.text1.config(state=DISABLED)

    def auswahl_hydroxyverb(self):
        i3=self.listbox3.curselection()[0]
        i4=self.listbox4.curselection()[0]
        i5=self.listbox5.curselection()[0]
        i6=self.listbox6.curselection()[0]
        schluessel=str(i3)+str(i4)+str(i5)+str(i6)
        #print(schluessel, self.hydroxyverbindungen[schluessel])
        self.text1.config(state=NORMAL)
        self.text1.config(bg='white')
        self.text1.delete(1.0, END)
        self.text1.insert(INSERT, self.hydroxyverbindungen[schluessel])
        self.text1.config(state=DISABLED)

    def vorauswahl_testen(self):
        self.vorauswahl = v.get()
        self.text1.config(state=NORMAL)
        self.text1.config(bg='white')
        self.text1.delete(1.0, END)
        self.text1.config()
        self.text1.config(state=DISABLED)
        if self.vorauswahl == 'carb':
            #print('Auswahl=carb')
            for i in self.listboxen_carb:
                i.config(state=NORMAL)
            for i in self.listboxen_hydrox:
                i.see(0)
                i.select_set(0, 0)
                i.config(state=DISABLED)
        elif self.vorauswahl == 'hydrox':
            #print('Auswahl=hydrox')
            for i in self.listboxen_hydrox:
                i.config(state=NORMAL)
            for i in self.listboxen_carb:
                i.see(0)
                i.select_set(0, 0)
                i.config(state=DISABLED)

    def zuruecksetzen(self):
        #print('zuruecksetzen')
        global v
        v.set('X') 
        for i in self.listboxen_carb:
                i.config(state=NORMAL)
                i.see(0)
                i.select_set(0, 0)
                i.config(state=DISABLED)
        for i in self.listboxen_hydrox:
                i.config(state=NORMAL)
                i.see(0)
                i.select_set(0, 0)
                i.config(state=DISABLED)
        self.text1.config(state=NORMAL)
        self.text1.delete(1.0, END)
        self.text1.config(bg='white')
        self.text1.config(state=DISABLED)
        
    def link_oeffnen(self):
        print('link_oeffnen')

################################################################################
root = Tk()
root.title('Stoffklassenermittler')
app = Fenster(root)
root.mainloop()
