#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
import random
# Datendatei
import sys
sys.path.insert(0, 'daten')
from elementsammlung import elemente

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=4)
        self.frame2=Frame(frame, pady=4, padx=4)
        self.frame3=Frame(frame, pady=4, padx=4)
        self.frame4=Frame(frame, pady=4, padx=4)
        self.frame5=Frame(frame, pady=4, padx=4)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 3, E+W),
                (self.frame1, 0, 0, 1, NW),
                (self.frame3, 0, 1, 1, NW),
                (self.frame5, 0, 2, 1, NW),
                (self.frame2, 1, 0, 3, W+E+N+S),
                (self.frame4, 2, 0, 3, SW)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 5: Platzhalter
        self.f5l1=Label(self.frame5, text='', width=20)
        self.f5l1.grid(row=0, column=0, sticky=E+W)

        # Rahmen 1: Steuerelemente für die Anzeige der Elemente
        self.f1l1=Label(self.frame1, text='Colouring:', anchor=W)
        global farbauswahl
        farbauswahl=StringVar()
        farbauswahl.set('X')
        self.f1esr1=Radiobutton(self.frame1, 
                                text='None',
                                variable=farbauswahl, 
                                value='keine',
                                indicatoron=1, 
                                command=self.farbauswahl_festlegen,
                                anchor=W,
                                justify=LEFT)
        self.f1esr2=Radiobutton(self.frame1, 
                                text='Main groups (columns)',
                                variable=farbauswahl, 
                                value='hauptgruppen',
                                indicatoron=1, 
                                command=self.farbauswahl_festlegen,
                                anchor=W,
                                justify=LEFT)
        self.f1esr3=Radiobutton(self.frame1, 
                                text='Periods (rows)',
                                variable=farbauswahl, 
                                value='perioden',
                                indicatoron=1, 
                                command=self.farbauswahl_festlegen,
                                anchor=W,
                                justify=LEFT)
        self.f1esr4=Radiobutton(self.frame1, 
                                text='Metals and Nonmetals',
                                variable=farbauswahl, 
                                value='menime',
                                indicatoron=1, 
                                command=self.farbauswahl_festlegen,
                                anchor=W,
                                justify=LEFT)
        self.f1l2=Label(self.frame1, text='Arrangement:', anchor=W)
        global anordnung
        anordnung=StringVar()
        anordnung.set('X')
        self.f1ar1=Radiobutton(self.frame1, 
                                text='Linear',
                                variable=anordnung, 
                                value='linear',
                                indicatoron=1, 
                                command=self.anordnung_festlegen,
                                anchor=W,
                                justify=LEFT)
        self.f1ar2=Radiobutton(self.frame1, 
                                text='Tabular',
                                variable=anordnung, 
                                value='tabellarisch',
                                indicatoron=1, 
                                command=self.anordnung_festlegen,
                                anchor=W,
                                justify=LEFT)
        for i, row, column, sticky in (
                (self.f1l1,         0,  0,  E+W), 
                (self.f1esr1,       1,  0,  E+W), 
                (self.f1esr2,       2,  0,  E+W), 
                (self.f1esr3,       3,  0,  E+W),
                (self.f1esr4,       4,  0,  E+W),
                (self.f1l2,         5,  0,  E+W), 
                (self.f1ar1,        6,  0,  E+W), 
                (self.f1ar2,        7,  0,  E+W), 
                #(self.f1b1,         8,  0,  E+W), 
                ):
            i.grid(row=row, column=column, sticky=sticky)
        farbauswahl.set('keine')
        anordnung.set('linear')
        
        # Rahmen 2: Anzeige der Elementsymbole
        global elementschluessel
        elementschluessel=StringVar()
        elementschluessel.set('X')
        self.f2esr1=Radiobutton(self.frame2, 
                                text='H',
                                variable=elementschluessel, 
                                value='H',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr2=Radiobutton(self.frame2, 
                                text='He',
                                variable=elementschluessel, 
                                value='He',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr3=Radiobutton(self.frame2, 
                                text='Li',
                                variable=elementschluessel, 
                                value='Li',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr4=Radiobutton(self.frame2, 
                                text='Be',
                                variable=elementschluessel, 
                                value='Be',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr5=Radiobutton(self.frame2, 
                                text='B',
                                variable=elementschluessel, 
                                value='B',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr6=Radiobutton(self.frame2, 
                                text='C',
                                variable=elementschluessel, 
                                value='C',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr7=Radiobutton(self.frame2, 
                                text='N',
                                variable=elementschluessel, 
                                value='N',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr8=Radiobutton(self.frame2, 
                                text='O',
                                variable=elementschluessel, 
                                value='O',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr9=Radiobutton(self.frame2, 
                                text='F',
                                variable=elementschluessel, 
                                value='F',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr10=Radiobutton(self.frame2, 
                                text='Ne',
                                variable=elementschluessel, 
                                value='Ne',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr11=Radiobutton(self.frame2, 
                                text='Na',
                                variable=elementschluessel, 
                                value='Na',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr12=Radiobutton(self.frame2, 
                                text='Mg',
                                variable=elementschluessel, 
                                value='Mg',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr13=Radiobutton(self.frame2, 
                                text='Al',
                                variable=elementschluessel, 
                                value='Al',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr14=Radiobutton(self.frame2, 
                                text='Si',
                                variable=elementschluessel, 
                                value='Si',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr15=Radiobutton(self.frame2, 
                                text='P',
                                variable=elementschluessel, 
                                value='P',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr16=Radiobutton(self.frame2, 
                                text='S',
                                variable=elementschluessel, 
                                value='S',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr17=Radiobutton(self.frame2, 
                                text='Cl',
                                variable=elementschluessel, 
                                value='Cl',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr18=Radiobutton(self.frame2, 
                                text='Ar',
                                variable=elementschluessel, 
                                value='Ar',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr19=Radiobutton(self.frame2, 
                                text='K',
                                variable=elementschluessel, 
                                value='K',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)
        self.f2esr20=Radiobutton(self.frame2, 
                                text='Ca',
                                variable=elementschluessel, 
                                value='Ca',
                                indicatoron=0, 
                                padx=8,
                                pady=8,
                                width=2,
                                font=('Arial', 14, 'bold'),
                                background='#E1E1E0E0E0E0',
                                command=self.elementschluessel_festlegen)

        # Rahmen 3: Ausgabe der Eigenschaften und ihrer Werte 
        #           ggfs. Aufrufen der Animationen/Abbildungen
        self.f3l1=Label(self.frame3, text='Name:', 
                        anchor=E, justify=RIGHT)
        self.f3e1=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='black',
                        width='50', font=('arial', '11'))
        self.f3gll1=Label(self.frame3, text='Particle properties')
        self.f3l2=Label(self.frame3, text='Atomic (charge) Number:', 
                        anchor=E, justify=RIGHT)
        self.f3e2=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='red',
                        foreground='red',
                        width='50', font=('arial', '11'))
        self.f3l3=Label(self.frame3, text='Neutron number:', 
                        anchor=E, justify=RIGHT)
        self.f3e3=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='darkgreen',
                        foreground='darkgreen',
                        width='50', font=('arial', '11'))
        self.f3l3b=Label(self.frame3, text='Mass number:', 
                        anchor=E, justify=RIGHT)
        self.f3e3b=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='black',
                        width='50', font=('arial', '11'))
        self.f3l4=Label(self.frame3, text='Valence electron number:', 
                        anchor=E, justify=RIGHT)
        self.f3e4=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='blue',
                        foreground='blue',
                        width='50', font=('arial', '11'))
        self.f3l5=Label(self.frame3, text='Valence shell:', 
                        anchor=E, justify=RIGHT)
        self.f3e5=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='black',
                        width='50', font=('arial', '11'))
        self.f3l6=Label(self.frame3, text='Atomic radius in Pikometers [pm]:', 
                        anchor=E, justify=RIGHT)
        self.f3e6=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='black',
                        width='50', font=('arial', '11'))
        self.f3l7=Label(self.frame3, text='Electronegativity:', 
                        anchor=E, justify=RIGHT)
        self.f3e7=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='black',
                        width='50', font=('arial', '11'))
        self.f3l8=Label(self.frame3, text='Structure:', 
                        anchor=E, justify=RIGHT)
        self.f3e8=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='black',
                        width='50', font=('arial', '11'))
        
        self.f3gll2=Label(self.frame3, text='Material property')
        self.f3l9=Label(self.frame3, text='Farbe:', 
                        anchor=E, justify=RIGHT)
        self.f3e9=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='black',
                        width='50', font=('arial', '11'))
        self.f3l10=Label(self.frame3, text='State of matter:', 
                        anchor=E, justify=RIGHT)
        self.f3e10=Entry(self.frame3, background='white', 
                        disabledbackground='white',
                        disabledforeground='black',
                        width='50', font=('arial', '11'))
        
        for i, state in ((self.f3e1, DISABLED),
                         (self.f3e2, DISABLED),
                         (self.f3e3, DISABLED),
                         (self.f3e3b, DISABLED),
                         (self.f3e4, DISABLED),
                         (self.f3e5, DISABLED),
                         (self.f3e6, DISABLED),
                         (self.f3e7, DISABLED),
                         (self.f3e8, DISABLED),
                         (self.f3e9, DISABLED),
                         (self.f3e10, DISABLED)
                         ):
            i.config(state=state)
        
        for i, row, column, columnspan, sticky in (
                (self.f3l1,       0,  0, 1, E+W), 
                (self.f3e1,       0,  1, 1, E+W), 
                # Teilcheneigenschaften
                (self.f3gll1,     1,  0, 2, E+W), 
                (self.f3l2,       2,  0, 1, E+W), 
                (self.f3e2,       2,  1, 1, E+W), 
                (self.f3l3,       3,  0, 1, E+W), 
                (self.f3e3,       3,  1, 1, E+W), 
                (self.f3l3b,      4,  0, 1, E+W), 
                (self.f3e3b,      4,  1, 1, E+W), 
                (self.f3l4,       5,  0, 1, E+W), 
                (self.f3e4,       5,  1, 1, E+W), 
                (self.f3l5,       6,  0, 1, E+W), 
                (self.f3e5,       6,  1, 1, E+W),
                (self.f3l6,       7,  0, 1, E+W), 
                (self.f3e6,       7,  1, 1, E+W),
                (self.f3l7,       8,  0, 1, E+W), 
                (self.f3e7,       8,  1, 1, E+W),
                (self.f3l8,       9,  0, 1, E+W), 
                (self.f3e8,       9,  1, 1, E+W),
                # Stoffeigenschaften
                (self.f3gll2,     10,  0, 2, E+W), 
                (self.f3l9,       11,  0, 1, E+W), 
                (self.f3e9,       11,  1, 1, E+W),
                (self.f3l10,      12,  0, 1, E+W), 
                (self.f3e10,      12,  1, 1, E+W),
                ):
            i.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)
        
        # Rahmen 4: Navigationsknöpfe
        self.f4b1=Button(self.frame4, 
                         text='View Bohr model', 
                         command=self.schalenmodell_anzeigen)
        self.f4b1b=Button(self.frame4, 
                         text='View fabric and structure ', 
                         command=self.stoff_und_struktur_anzeigen)
        self.f4b2=Button(self.frame4, 
                         text='Reset', 
                         command=self.zurueck_setzen)
        self.f4b3=Button(self.frame4, 
                         text='Exit', 
                         command=root.destroy)
        self.f4b1.grid(row=0, column=0, sticky=E+W)
        self.f4b1b.grid(row=0, column=1, sticky=E+W)
        self.f4b2.grid(row=0, column=2, sticky=E+W)
        self.f4b3.grid(row=0, column=3, sticky=E+W)
        # Elementsymbole erstmalig anzeigen
        self.anordnung_festlegen()
        elementschluessel.set('H')
        self.elementschluessel_festlegen()
        
        ########################################################################
        ##                          Nebenfenster                              ##
        ########################################################################

        global unterFensterZahl
        unterFensterZahl = int(0)
        global namensLaengeUnterfenster
        namensLaengeUnterfenster = str('')

    def schalenmodell_fenster_test(self):
        global namensLaengeUnterfenster
        global unterFensterZahl
        try:
            namensLaengeUnterfenster = self.nw.winfo_name()
            if len(namensLaengeUnterfenster) > 1:
                self.nw.destroy()
        except:
            pass
            unterFensterZahl = 0
        if unterFensterZahl < 1:
            self.schalenmodell_fenster()

    def stoff_und_struktur_fenster_test(self):
        global namensLaengeUnterfenster
        global unterFensterZahl
        try:
            namensLaengeUnterfenster = self.nw.winfo_name()
            if len(namensLaengeUnterfenster) > 1:
                self.nw.destroy()
        except:
            pass
            unterFensterZahl = 0
        if unterFensterZahl < 1:
            self.stoff_und_struktur_fenster()

    def stoff_und_struktur_fenster(self):
        """Funktion zum Oeffnen des Nebenfensters"""
        self.nw = Toplevel(root)
        self.elementschluessel=str(elementschluessel.get())
        #print self.elementschluessel
        self.elementname=str(elemente[self.elementschluessel][0])
        self.nw.title('Fabric and structure of the element '+self.elementname)
        self.nwFrame=Frame(self.nw)
        self.nwFrame.grid(row=0, column=0)
        self.canvas1=Canvas(self.nwFrame, 
                            width=250, height=250)
        self.canvas2=Canvas(self.nwFrame, 
                            width=250, height=250, bg="white")
        self.nwButton1 = Button(self.nwFrame, 
                         text='Close', 
                         command=self.stoff_und_struktur_fenster_schliessen)
        self.canvas1.grid(row=0, column=0, columnspan=1, sticky=E+W)
        self.canvas2.grid(row=0, column=1, columnspan=1, sticky=E+W)
        self.nwButton1.grid(row=1, column=0, columnspan=2, sticky=E+W)
        self.bild_stoff=PhotoImage(file='daten/img/stoff/'+self.elementschluessel+'.gif')
        self.canvas1.create_image(0, 0, image=self.bild_stoff, anchor=NW)
        self.bild_struktur=PhotoImage(file='daten/img/struktur/'+self.elementschluessel+'.gif')
        self.canvas2.create_image(0, 0, image=self.bild_struktur, anchor=NW)

    def schalenmodell_fenster(self):
        """Funktion zum Oeffnen des Nebenfensters"""
        self.nw = Toplevel(root)
        self.elementschluessel=str(elementschluessel.get())
        #print self.elementschluessel
        self.elementname=str(elemente[self.elementschluessel][0])
        self.nw.title('Bohr model of the '+self.elementname+'-atom')
        self.nwFrame=Frame(self.nw)
        self.nwFrame.grid(row=0, column=0)
        self.canvas1=Canvas(self.nwFrame, 
                            width=400, height=400, bg="white")
        self.nwButton1 = Button(self.nwFrame, 
                         text='Close', 
                         command=self.schalenmodell_fenster_schliessen)
        self.canvas1.grid(row=0, column=0, sticky=E+W)
        self.nwButton1.grid(row=2, column=0, sticky=E+W)
        
        #                                 x1,  y1,  x2,  y2, Zusatzeigenschaft
        self.grenze='' # später: ''
        self.flaeche=''     # später: ''
        # Schalen: n bis k
        self.k = self.canvas1.create_oval(120,  120, 280,  280, fill=self.flaeche, outline=self.grenze, width=4)
        self.l = self.canvas1.create_oval( 75,   75, 325,  325, fill=self.flaeche, outline=self.grenze, width=4)
        self.m = self.canvas1.create_oval( 35,   35, 365,  365, fill=self.flaeche, outline=self.grenze, width=4)
        self.n = self.canvas1.create_oval( 11,   11, 389,  389, fill=self.flaeche, outline=self.grenze, width=4)
        # Elektronen: e1 bis e20
        # K-Schale
        self.e1= self.canvas1.create_oval(116,  185, 131,  200, fill=self.flaeche, outline=self.grenze)
        self.e2= self.canvas1.create_oval(271,  185, 286,  200, fill=self.flaeche, outline=self.grenze)
        # L-Schale
        self.e3= self.canvas1.create_oval(158,   70, 173,   85, fill=self.flaeche, outline=self.grenze)
        self.e4= self.canvas1.create_oval(234,   70, 249,   85, fill=self.flaeche, outline=self.grenze)
        self.e5= self.canvas1.create_oval(312,  149, 327,  164, fill=self.flaeche, outline=self.grenze)
        self.e6= self.canvas1.create_oval(312,  220, 327,  235, fill=self.flaeche, outline=self.grenze)
        self.e7= self.canvas1.create_oval(234,  313, 249,  328, fill=self.flaeche, outline=self.grenze)
        self.e8= self.canvas1.create_oval(158,  313, 173,  328, fill=self.flaeche, outline=self.grenze)
        self.e9= self.canvas1.create_oval( 75,  220,  90,  235, fill=self.flaeche, outline=self.grenze)
        self.e10=self.canvas1.create_oval( 75,  149,  90,  164, fill=self.flaeche, outline=self.grenze)
        # M-Schale
        self.e11=self.canvas1.create_oval(147,   32, 162,   47, fill=self.flaeche, outline=self.grenze)
        self.e12=self.canvas1.create_oval(248,   32, 263,   47, fill=self.flaeche, outline=self.grenze)
        self.e13=self.canvas1.create_oval(347,  146, 362,  161, fill=self.flaeche, outline=self.grenze)
        self.e14=self.canvas1.create_oval(347,  241, 362,  256, fill=self.flaeche, outline=self.grenze)
        self.e15=self.canvas1.create_oval(248,  345, 263,  360, fill=self.flaeche, outline=self.grenze)
        self.e16=self.canvas1.create_oval(147,  348, 162,  363, fill=self.flaeche, outline=self.grenze)
        self.e17=self.canvas1.create_oval( 38,  241,  53,  256, fill=self.flaeche, outline=self.grenze)
        self.e18=self.canvas1.create_oval( 38,  146,  53,  161, fill=self.flaeche, outline=self.grenze)
        # N-Schale
        self.e19=self.canvas1.create_oval(135,   12, 150,   27, fill=self.flaeche, outline=self.grenze)
        self.e20=self.canvas1.create_oval(258,   12, 273,   27, fill=self.flaeche, outline=self.grenze)
        # Protonen: p1 bis p20
        # zur K-Schale
        self.p1= self.canvas1.create_oval(193,  198, 208,  213, fill=self.flaeche, outline=self.grenze)
        self.p2= self.canvas1.create_oval(209,  198, 224,  213, fill=self.flaeche, outline=self.grenze)
        # zur L-Schale
        self.p3 = self.canvas1.create_oval(202,  184, 217,  199, fill=self.flaeche, outline=self.grenze)
        self.p4 = self.canvas1.create_oval(219,  184, 235,  199, fill=self.flaeche, outline=self.grenze)
        self.p5 = self.canvas1.create_oval(225,  199, 240,  214, fill=self.flaeche, outline=self.grenze)
        self.p6 = self.canvas1.create_oval(216,  212, 231,  227, fill=self.flaeche, outline=self.grenze)
        self.p7 = self.canvas1.create_oval(200,  212, 215,  227, fill=self.flaeche, outline=self.grenze)
        self.p8 = self.canvas1.create_oval(184,  211, 199,  226, fill=self.flaeche, outline=self.grenze)
        self.p9 = self.canvas1.create_oval(177,  197, 192,  212, fill=self.flaeche, outline=self.grenze)
        self.p10= self.canvas1.create_oval(186,  183, 201,  198, fill=self.flaeche, outline=self.grenze)
        # zur M-Schale
        self.p11=self.canvas1.create_oval(169,  182, 184,  197, fill=self.flaeche, outline=self.grenze)
        self.p12=self.canvas1.create_oval(177,  167, 192,  182, fill=self.flaeche, outline=self.grenze)
        self.p13=self.canvas1.create_oval(195,  168, 210,  183, fill=self.flaeche, outline=self.grenze)
        self.p14=self.canvas1.create_oval(212,  168, 227,  183, fill=self.flaeche, outline=self.grenze)
        self.p15=self.canvas1.create_oval(235,  184, 250,  199, fill=self.flaeche, outline=self.grenze)
        self.p16=self.canvas1.create_oval(232,  215, 245,  230, fill=self.flaeche, outline=self.grenze)
        self.p17=self.canvas1.create_oval(208,  226, 223,  241, fill=self.flaeche, outline=self.grenze)
        self.p18=self.canvas1.create_oval(190,  226, 205,  241, fill=self.flaeche, outline=self.grenze)
        # zur N-Schale
        self.p19=self.canvas1.create_oval(167,  212, 182,  227, fill=self.flaeche, outline=self.grenze)
        self.p20=self.canvas1.create_oval(174,  226, 189,  241, fill=self.flaeche, outline=self.grenze)

        if self.elementschluessel == 'H':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.e1, 'blue', 'blue'),
                    (self.p1, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'He':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Li':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Be':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'B':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'C':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'N':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'O':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'F':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Ne':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Na':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Mg':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.e12, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black'),
                    (self.p12, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Al':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.e12, 'blue', 'blue'),
                    (self.e13, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black'),
                    (self.p12, 'red', 'black'),
                    (self.p13, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Si':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.e12, 'blue', 'blue'),
                    (self.e13, 'blue', 'blue'),
                    (self.e14, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black'),
                    (self.p12, 'red', 'black'),
                    (self.p13, 'red', 'black'),
                    (self.p14, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'P':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.e12, 'blue', 'blue'),
                    (self.e13, 'blue', 'blue'),
                    (self.e14, 'blue', 'blue'),
                    (self.e15, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black'),
                    (self.p12, 'red', 'black'),
                    (self.p13, 'red', 'black'),
                    (self.p14, 'red', 'black'),
                    (self.p15, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'S':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.e12, 'blue', 'blue'),
                    (self.e13, 'blue', 'blue'),
                    (self.e14, 'blue', 'blue'),
                    (self.e15, 'blue', 'blue'),
                    (self.e16, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black'),
                    (self.p12, 'red', 'black'),
                    (self.p13, 'red', 'black'),
                    (self.p14, 'red', 'black'),
                    (self.p15, 'red', 'black'),
                    (self.p16, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Cl':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.e12, 'blue', 'blue'),
                    (self.e13, 'blue', 'blue'),
                    (self.e14, 'blue', 'blue'),
                    (self.e15, 'blue', 'blue'),
                    (self.e16, 'blue', 'blue'),
                    (self.e17, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black'),
                    (self.p12, 'red', 'black'),
                    (self.p13, 'red', 'black'),
                    (self.p14, 'red', 'black'),
                    (self.p15, 'red', 'black'),
                    (self.p16, 'red', 'black'),
                    (self.p17, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Ar':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.e12, 'blue', 'blue'),
                    (self.e13, 'blue', 'blue'),
                    (self.e14, 'blue', 'blue'),
                    (self.e15, 'blue', 'blue'),
                    (self.e16, 'blue', 'blue'),
                    (self.e17, 'blue', 'blue'),
                    (self.e18, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black'),
                    (self.p12, 'red', 'black'),
                    (self.p13, 'red', 'black'),
                    (self.p14, 'red', 'black'),
                    (self.p15, 'red', 'black'),
                    (self.p16, 'red', 'black'),
                    (self.p17, 'red', 'black'),
                    (self.p18, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'K':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.n, '', '#FFFF66660000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.e12, 'blue', 'blue'),
                    (self.e13, 'blue', 'blue'),
                    (self.e14, 'blue', 'blue'),
                    (self.e15, 'blue', 'blue'),
                    (self.e16, 'blue', 'blue'),
                    (self.e17, 'blue', 'blue'),
                    (self.e18, 'blue', 'blue'),
                    (self.e19, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black'),
                    (self.p12, 'red', 'black'),
                    (self.p13, 'red', 'black'),
                    (self.p14, 'red', 'black'),
                    (self.p15, 'red', 'black'),
                    (self.p16, 'red', 'black'),
                    (self.p17, 'red', 'black'),
                    (self.p18, 'red', 'black'),
                    (self.p19, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        elif self.elementschluessel == 'Ca':
            for widget, fuellfarbe, outline in (
                    (self.k, '', '#9B9B6A6A0000'),
                    (self.l, '', '#FFFF99999999'),
                    (self.m, '', '#000099990000'),
                    (self.n, '', '#FFFF66660000'),
                    (self.e1, 'blue', 'blue'),
                    (self.e2, 'blue', 'blue'),
                    (self.e3, 'blue', 'blue'),
                    (self.e4, 'blue', 'blue'),
                    (self.e5, 'blue', 'blue'),
                    (self.e6, 'blue', 'blue'),
                    (self.e7, 'blue', 'blue'),
                    (self.e8, 'blue', 'blue'),
                    (self.e9, 'blue', 'blue'),
                    (self.e10, 'blue', 'blue'),
                    (self.e11, 'blue', 'blue'),
                    (self.e12, 'blue', 'blue'),
                    (self.e13, 'blue', 'blue'),
                    (self.e14, 'blue', 'blue'),
                    (self.e15, 'blue', 'blue'),
                    (self.e16, 'blue', 'blue'),
                    (self.e17, 'blue', 'blue'),
                    (self.e18, 'blue', 'blue'),
                    (self.e19, 'blue', 'blue'),
                    (self.e20, 'blue', 'blue'),
                    (self.p1, 'red', 'black'),
                    (self.p2, 'red', 'black'),
                    (self.p3, 'red', 'black'),
                    (self.p4, 'red', 'black'),
                    (self.p5, 'red', 'black'),
                    (self.p6, 'red', 'black'),
                    (self.p7, 'red', 'black'),
                    (self.p8, 'red', 'black'),
                    (self.p9, 'red', 'black'),
                    (self.p10, 'red', 'black'),
                    (self.p11, 'red', 'black'),
                    (self.p12, 'red', 'black'),
                    (self.p13, 'red', 'black'),
                    (self.p14, 'red', 'black'),
                    (self.p15, 'red', 'black'),
                    (self.p16, 'red', 'black'),
                    (self.p17, 'red', 'black'),
                    (self.p18, 'red', 'black'),
                    (self.p19, 'red', 'black'),
                    (self.p20, 'red', 'black')
                    ):
                self.canvas1.itemconfig(widget, fill=fuellfarbe, outline=outline)
        
        
    def schalenmodell_fenster_schliessen(self):
        self.nw.destroy()
        global unterFensterZahl
        if unterFensterZahl >= 1:
            try:
                unterFensterZahl = 0
            except:
                pass
                
    def stoff_und_struktur_fenster_schliessen(self):
        self.nw.destroy()
        global unterFensterZahl
        if unterFensterZahl >= 1:
            try:
                unterFensterZahl = 0
            except:
                pass
    
    
        ########################################################################
        ##                      Ende Nebenfenster                             ##
        ########################################################################

    def schalenmodell_anzeigen(self):
        self.elementschluessel=str(elementschluessel.get())
        #print('schalenmodell_anzeigen = '+self.elementschluessel)
        self.schalenmodell_fenster_test()
        
    def stoff_und_struktur_anzeigen(self):
        self.elementschluessel=str(elementschluessel.get())
        #print('schalenmodell_anzeigen = '+self.elementschluessel)
        self.stoff_und_struktur_fenster_test()

    def zurueck_setzen(self):
        for i, state in ((self.f3e1, NORMAL),
                         (self.f3e2, NORMAL),
                         (self.f3e3, NORMAL),
                         (self.f3e3b, NORMAL),
                         (self.f3e4, NORMAL),
                         (self.f3e5, NORMAL),
                         (self.f3e6, NORMAL),
                         (self.f3e7, NORMAL),
                         (self.f3e8, NORMAL),
                         (self.f3e9, NORMAL),
                         (self.f3e10, NORMAL)
                         ):
            i.config(state=state)
        for widget in (self.f3e1,
                       self.f3e2,
                       self.f3e3, 
                       self.f3e3b, 
                       self.f3e4,
                       self.f3e5,
                       self.f3e6,
                       self.f3e7):
            widget.delete(0, END)
        for i, state in ((self.f3e1, DISABLED),
                         (self.f3e2, DISABLED),
                         (self.f3e3, DISABLED),
                         (self.f3e3b, DISABLED),
                         (self.f3e4, DISABLED),
                         (self.f3e5, DISABLED),
                         (self.f3e6, DISABLED),
                         (self.f3e7, DISABLED),
                         (self.f3e8, DISABLED),
                         (self.f3e9, DISABLED),
                         (self.f3e10, DISABLED)
                         ):
            i.config(state=state)
        elementschluessel.set('H')
        anordnung.set('linear')
        farbauswahl.set('keine')
        self.elementschluessel_festlegen()
        self.anordnung_festlegen()
        self.farbauswahl_festlegen()
    
    def elementschluessel_festlegen(self):
        self.elementschluessel=str(elementschluessel.get())
        #print self.elementschluessel
        self.elementname=str(elemente[self.elementschluessel][0])
        self.protonenzahl=str(elemente[self.elementschluessel][1])
        self.neutronenzahl=str(elemente[self.elementschluessel][2])
        self.massenzahl=int(elemente[self.elementschluessel][1]+int(elemente[self.elementschluessel][2]))
        self.valenzelektronenzahl=str(elemente[self.elementschluessel][3])
        self.valenzschale=str(elemente[self.elementschluessel][4])
        self.atomradius=str(elemente[self.elementschluessel][5])
        self.en=str(elemente[self.elementschluessel][6])
        self.struktur=str(elemente[self.elementschluessel][7])
        self.farbe=str(elemente[self.elementschluessel][8])
        self.zustand=str(elemente[self.elementschluessel][9])
        
        for i, state in ((self.f3e1, NORMAL),
                         (self.f3e2, NORMAL),
                         (self.f3e3, NORMAL),
                         (self.f3e3b, NORMAL),
                         (self.f3e4, NORMAL),
                         (self.f3e5, NORMAL),
                         (self.f3e6, NORMAL),
                         (self.f3e7, NORMAL),
                         (self.f3e8, NORMAL),
                         (self.f3e9, NORMAL),
                         (self.f3e10, NORMAL)
                         ):
            i.config(state=state)
        for widget, text in ((self.f3e1, self.elementname),
                             (self.f3e2, self.protonenzahl),
                             (self.f3e3, self.neutronenzahl),
                             (self.f3e3b, self.massenzahl),
                             (self.f3e4, self.valenzelektronenzahl),
                             (self.f3e5, self.valenzschale),
                             (self.f3e6, self.atomradius),
                             (self.f3e7, self.en),
                             (self.f3e8, self.struktur),
                             (self.f3e9, self.farbe),
                             (self.f3e10, self.zustand)):
            widget.delete(0, END)
            widget.insert(0, text)
            if self.valenzschale == 'K':
                self.f3e5.config(disabledbackground='#9B9B6A6A0000',
                                 disabledforeground='white')
            elif self.valenzschale == 'L':
                self.f3e5.config(disabledbackground='#FFFF99999999',
                                 disabledforeground='white')
            elif self.valenzschale == 'M':
                self.f3e5.config(disabledbackground='#000099990000',
                                 disabledforeground='white')
            elif self.valenzschale == 'N':
                self.f3e5.config(disabledbackground='#FFFF66660000',
                                 disabledforeground='white')
        
        for i, state in ((self.f3e1, DISABLED),
                         (self.f3e2, DISABLED),
                         (self.f3e3, DISABLED),
                         (self.f3e3b, DISABLED),
                         (self.f3e4, DISABLED),
                         (self.f3e5, DISABLED),
                         (self.f3e6, DISABLED),
                         (self.f3e7, DISABLED),
                         (self.f3e8, DISABLED),
                         (self.f3e9, DISABLED),
                         (self.f3e10, DISABLED)
                         ):
            i.config(state=state)
        
    def farbauswahl_festlegen(self):
        self.farbauswahl=str(farbauswahl.get())
        #print self.farbauswahl
        if self.farbauswahl == 'keine':
            for i, background in (
                    (self.f2esr1,     '#E1E1E0E0E0E0'),
                    (self.f2esr2,     '#E1E1E0E0E0E0'),
                    (self.f2esr3,     '#E1E1E0E0E0E0'),
                    (self.f2esr4,     '#E1E1E0E0E0E0'),
                    (self.f2esr5,     '#E1E1E0E0E0E0'),
                    (self.f2esr6,     '#E1E1E0E0E0E0'),
                    (self.f2esr7,     '#E1E1E0E0E0E0'),
                    (self.f2esr8,     '#E1E1E0E0E0E0'),
                    (self.f2esr9,     '#E1E1E0E0E0E0'),
                    (self.f2esr10,    '#E1E1E0E0E0E0'),
                    (self.f2esr11,    '#E1E1E0E0E0E0'),
                    (self.f2esr12,    '#E1E1E0E0E0E0'),
                    (self.f2esr13,    '#E1E1E0E0E0E0'),
                    (self.f2esr14,    '#E1E1E0E0E0E0'),
                    (self.f2esr15,    '#E1E1E0E0E0E0'),
                    (self.f2esr16,    '#E1E1E0E0E0E0'),
                    (self.f2esr17,    '#E1E1E0E0E0E0'),
                    (self.f2esr18,    '#E1E1E0E0E0E0'),
                    (self.f2esr19,    '#E1E1E0E0E0E0'),
                    (self.f2esr20,    '#E1E1E0E0E0E0')):
                i.config(background=background)
        elif self.farbauswahl == 'hauptgruppen':
            for i, background in (
                    (self.f2esr1,     '#FFFFFFFFFFFF'),
                    (self.f2esr2,     '#FFFF00000000'),
                    (self.f2esr3,     '#ffffffffffff'),
                    (self.f2esr4,     '#0000CCCC9999'),
                    (self.f2esr5,     '#FFFF0000FFFF'),
                    (self.f2esr6,     '#1E1E9090FFFF'),
                    (self.f2esr7,     '#333399990000'),
                    (self.f2esr8,     '#FFFFCCCC0000'),
                    (self.f2esr9,     '#FFFF66660000'),
                    (self.f2esr10,    '#FFFF00000000'),
                    (self.f2esr11,    '#FFFFFFFFFFFF'),
                    (self.f2esr12,    '#0000CCCC9999'),
                    (self.f2esr13,    '#FFFF0000FFFF'),
                    (self.f2esr14,    '#1E1E9090FFFF'),
                    (self.f2esr15,    '#333399990000'),
                    (self.f2esr16,    '#FFFFCCCC0000'),
                    (self.f2esr17,    '#FFFF66660000'),
                    (self.f2esr18,    '#FFFF00000000'),
                    (self.f2esr19,    '#FFFFFFFFFFFF'),
                    (self.f2esr20,    '#0000CCCC9999')):
                i.config(background=background)
        elif self.farbauswahl == 'perioden':
            for i, background in (
                    (self.f2esr1,     '#9B9B6A6A0000'),
                    (self.f2esr2,     '#9B9B6A6A0000'),
                    (self.f2esr3,     '#FFFF99999999'),
                    (self.f2esr4,     '#FFFF99999999'),
                    (self.f2esr5,     '#FFFF99999999'),
                    (self.f2esr6,     '#FFFF99999999'),
                    (self.f2esr7,     '#FFFF99999999'),
                    (self.f2esr8,     '#FFFF99999999'),
                    (self.f2esr9,     '#FFFF99999999'),
                    (self.f2esr10,    '#FFFF99999999'),
                    (self.f2esr11,    '#000099990000'),
                    (self.f2esr12,    '#000099990000'),
                    (self.f2esr13,    '#000099990000'),
                    (self.f2esr14,    '#000099990000'),
                    (self.f2esr15,    '#000099990000'),
                    (self.f2esr16,    '#000099990000'),
                    (self.f2esr17,    '#000099990000'),
                    (self.f2esr18,    '#000099990000'),
                    (self.f2esr19,    '#FFFF66660000'),
                    (self.f2esr20,    '#FFFF66660000')):
                i.config(background=background)
        elif self.farbauswahl == 'menime':
            for i, background in (
                    (self.f2esr1,     '#FFFF00000000'),
                    (self.f2esr2,     '#000000000000'),
                    (self.f2esr3,     '#E0E0FFFFFFFF'),
                    (self.f2esr4,     '#E0E0FFFFFFFF'),
                    (self.f2esr5,     '#EBEBB4B4B4B4'),
                    (self.f2esr6,     '#FFFF00000000'),
                    (self.f2esr7,     '#FFFF00000000'),
                    (self.f2esr8,     '#FFFF00000000'),
                    (self.f2esr9,     '#FFFF00000000'),
                    (self.f2esr10,    '#000000000000'),
                    (self.f2esr11,    '#E0E0FFFFFFFF'),
                    (self.f2esr12,    '#E0E0FFFFFFFF'),
                    (self.f2esr13,    '#E0E0FFFFFFFF'),
                    (self.f2esr14,    '#EBEBB4B4B4B4'),
                    (self.f2esr15,    '#FFFF00000000'),
                    (self.f2esr16,    '#FFFF00000000'),
                    (self.f2esr17,    '#FFFF00000000'),
                    (self.f2esr18,    '#000000000000'),
                    (self.f2esr19,    '#E0E0FFFFFFFF'),
                    (self.f2esr20,    '#E0E0FFFFFFFF')):
                i.config(background=background)

    def anordnung_festlegen(self):
        self.anordnung=str(anordnung.get())
        #print self.anordnung
        if self.anordnung == 'linear':
            for i, row, column, sticky in (
                    (self.f2esr1,       0,  0,  E+W), 
                    (self.f2esr2,       0,  1,  E+W), 
                    (self.f2esr3,       0,  2,  E+W), 
                    (self.f2esr4,       0,  3,  E+W), 
                    (self.f2esr5,       0,  4,  E+W), 
                    (self.f2esr6,       0,  5,  E+W), 
                    (self.f2esr7,       0,  6,  E+W), 
                    (self.f2esr8,       0,  7,  E+W), 
                    (self.f2esr9,       0,  8,  E+W), 
                    (self.f2esr10,      0,  9,  E+W), 
                    (self.f2esr11,      0,  10, E+W), 
                    (self.f2esr12,      0,  11, E+W), 
                    (self.f2esr13,      0,  12, E+W), 
                    (self.f2esr14,      0,  13, E+W), 
                    (self.f2esr15,      0,  14, E+W), 
                    (self.f2esr16,      0,  15, E+W), 
                    (self.f2esr17,      0,  16, E+W), 
                    (self.f2esr18,      0,  17, E+W), 
                    (self.f2esr19,      0,  18, E+W), 
                    (self.f2esr20,      0,  19, E+W)):
                i.grid(row=row, column=column, sticky=sticky)
        elif self.anordnung == 'tabellarisch':
            for i, row, column, sticky in (
                    (self.f2esr1,       0,  0,  E+W), 
                    (self.f2esr2,       0,  7,  E+W), 
                    (self.f2esr3,       1,  0,  E+W), 
                    (self.f2esr4,       1,  1,  E+W), 
                    (self.f2esr5,       1,  2,  E+W), 
                    (self.f2esr6,       1,  3,  E+W), 
                    (self.f2esr7,       1,  4,  E+W), 
                    (self.f2esr8,       1,  5,  E+W), 
                    (self.f2esr9,       1,  6,  E+W), 
                    (self.f2esr10,      1,  7,  E+W), 
                    (self.f2esr11,      2,  0,  E+W), 
                    (self.f2esr12,      2,  1,  E+W), 
                    (self.f2esr13,      2,  2,  E+W), 
                    (self.f2esr14,      2,  3,  E+W), 
                    (self.f2esr15,      2,  4,  E+W), 
                    (self.f2esr16,      2,  5,  E+W), 
                    (self.f2esr17,      2,  6,  E+W), 
                    (self.f2esr18,      2,  7,  E+W), 
                    (self.f2esr19,      3,  0,  E+W), 
                    (self.f2esr20,      3,  1,  E+W)):
                i.grid(row=row, column=column, sticky=sticky)
################################################################################
root = Tk()
root.title('PSEler')
app = Fenster(root)
root.minsize(width=920, height=510)
root.mainloop()
