#!/usr/bin/env python3
#-*- encoding=utf8 -*-

# Elementsammlung in der Form:
# Elementsymbol:
#               Name
#  - Teilcheneigenschaften:
#               Ordnungszahl/Protonenzahl/Gesamtelektronenzahl
#               Neutronenzahl
#               Valenzelektronenzahl/Hauptgruppennummer
#               Hauptquantenzahl/Nummer der Valenzschale
#               Struktur
#  - Stoffeigenschaften:
#               Farbe
#               Zustand
#               ggfs. Vektorgrafikinformationen zur Elektronenbesetzung


elemente={
#        Name               p+/e-  n       val-e-  schale   atomradius EN
'H':    ('Hydrogen',        1,     0,      1,      'K',     37,        2.2,   
         'Distinct diatomic molecules', 'Colourless', 'Gaseous'),
'He':   ('Helium',          2,     2,      2,      'K',  'not comparable', 'undefined', 
         'Single atoms', 'Colourless', 'Gaseous'),
'Li':   ('Lithium',         3,     4,      1,      'L',      152,       1.0,   
         'Metal cation lattice with electron gas', 'Shiny metallic', 'Solid'),
'Be':   ('Beryllium',       4,     5,      2,      'L',       112,         1.5,
         'Metal cation lattice with electron gas', 'Shiny metallic',  'Solid'),
'B':    ('Boron',             5,     6,      3,      'L',       88,         2.0,
         'Macromolecules of many atoms or atomic lattice', 'Black', 'Solid'),
'C':    ('Carbon',     6,     6,      4,      'L',       77,         2.5,
         'Macromolecule made ​​up of many layers of atoms or atomic lattice', 'Black or Colourless', 'Solid'),
'N':    ('Nitrogen',      7,     7,      5,      'L',       70,         3.1,
         'Distinct diatomic molecules', 'Colourless', 'Gaseous'),
'O':    ('Oxygen',      8,     8,      6,      'L',       66,         3.5,
         'Distinct diatomic molecules', 'Colourless', 'Gaseous'),
'F':    ('Fluorine',           9,     10,     7,      'L',       64,         4.1,
         'Distinct diatomic molecules', 'Colourless  to pale yellow', 'Gaseous'),
'Ne':   ('Neon',            10,    10,     8,      'L', 'not comparable', 'undefined',
         'Single atoms', 'Colourless', 'Gaseous'),
'Na':   ('Sodium',         11,    12,     1,      'M',       186,         1.0,
         'Metal cation lattice with electron gas', 'Shiny metallic',  'Solid'),
'Mg':   ('Magnesium',       12,    12,     2,      'M',       160,         1.2,
         'Metal cation lattice with electron gas', 'Shiny metallic',  'Solid'),
'Al':   ('Aluminium',       13,    14,     3,      'M',       143,         1.5,
         'Metal cation lattice with electron gas', 'Shiny metallic',  'Solid'),
'Si':   ('Silicon',        14,    14,     4,      'M',       117,         1.7,
         'Macromolecules of many atoms or atomic lattice', 'Darkgray shiny', 'Solid'),
'P':    ('Phosphorus',        15,    16,     5,      'M',       110,         2.1,
         'Molekülgitter aus vieratomiges Molekülen', 'White', 'Solid'),
'S':    ('Sulfur',        16,    16,     6,      'M',       104,         2.4,
         'Molekülgitter aus achtatomigen Molekülen', 'Yellow', 'Solid'),
'Cl':   ('Chlorine',           17,    18,     7,      'M',       99,         2.8,
         'Distinct diatomic molecules', 'Grün', 'Gaseous'),
'Ar':   ('Argon',           18,    22,     8,      'M', 'not comparable', 'undefined',
         'Single atoms',  'Colourless', 'Gaseous'),
'K':    ('Potassium',          19,    20,     1,      'N',       231,         0.9,
         'Metal cation lattice with electron gas', 'Shiny metallic', 'Solid'),
'Ca':   ('Calcium',         20,    20,     2,      'N',       197,         1.0,
         'Metal cation lattice with electron gas', 'Shiny metallic', 'Solid')
}
