#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *
from tkinter import scrolledtext
import os
import string
import sys
import webbrowser
sys.path.insert(0, 'daten')
from textdaten import textdaten
from summenformeln import summenformeln
textfeld_schriftart='arial'
textfeld_schriftgroesse='11'
textfeld_schrift=textfeld_schriftart+' '+textfeld_schriftgroesse

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame)
        self.frame2=Frame(frame)
        self.frame3=Frame(self.frame2, padx=2, pady=2)
        self.frame4=Frame(self.frame2, padx=2, pady=2)
        self.frame5=Frame(self.frame2, padx=2, pady=2)
        self.frame6=Frame(self.frame2, padx=2, pady=2)
        ## Rahmen 1: Auswahl Arrhenius oder Brönsted
        self.f1l1=Label(self.frame1, text='In wässriger Lösung')
        self.f1l2=Label(self.frame1, text='In der Gasphase')
        self.reak=StringVar()
        self.reak.set('X')
        self.f1r1=Radiobutton(self.frame1, 
                              variable=self.reak,
                              text='Wasser mit Chlorwasserstoff',
                              value='h2ohcl',
                              command=self.setze_reak,
                              indicatoron=0)
        self.f1r2=Radiobutton(self.frame1, 
                              variable=self.reak,
                              text='Ammoniak mit Wasser',
                              value='nh3h2o',
                              command=self.setze_reak,
                              indicatoron=0)
        self.f1r3=Radiobutton(self.frame1, 
                              variable=self.reak,
                              text='Ammoniak mit Chlorwasserstoff',
                              value='nh3hcl',
                              command=self.setze_reak,
                              indicatoron=0)
        ## Rahmen 2: Hülle für die Rahmen 3-5
        ## Rahmen 3: Modell-/Betrachtungsebene; Verkürzung/Ausweitung der Informationsdarstellung
        self.f3l1=Label(self.frame3, text='Darstellungsebene:', anchor=W, justify=LEFT)
        self.ebene=StringVar()
        self.ebene.set('X')
        self.f3r1=Radiobutton(self.frame3, 
                              variable=self.ebene,
                              text='Kugelmodell',
                              value='kugel',
                              command=self.setze_ebene,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        self.f3r2=Radiobutton(self.frame3, 
                              variable=self.ebene,
                              text='Summenformel',
                              value='summe',
                              command=self.setze_ebene,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        self.f3r3=Radiobutton(self.frame3, 
                              variable=self.ebene,
                              text='Strukturformel',
                              value='struktur',
                              command=self.setze_ebene,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        self.f3r4=Radiobutton(self.frame3, 
                              variable=self.ebene,
                              text='Schalenmodell',
                              value='schalen',
                              command=self.setze_ebene,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        ## Rahmen 4: Abgabe/Aufnahme/gekoppelt als Übergang analog zu Redox
        self.f4l1=Label(self.frame4, text='"Teilgleichungen:"', anchor=W, justify=LEFT)
        self.darst=StringVar()
        self.darst.set('X')
        self.f4r1=Radiobutton(self.frame4, 
                              variable=self.darst,
                              text='Nur Protonenaufnahme',
                              value='auf',
                              command=self.setze_darst,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        self.f4r2=Radiobutton(self.frame4, 
                              variable=self.darst,
                              text='Nur Protonenabgabe',
                              value='ab',
                              command=self.setze_darst,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        self.f4l2=Label(self.frame4, text='Gesamtgleichung:', anchor=W, justify=LEFT)
        self.f4r3=Radiobutton(self.frame4, 
                              variable=self.darst,
                              text='Protonenübergang',
                              value='ueber',
                              command=self.setze_darst,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        ## Rahmen 5: Abbildung und Auswahl des Schritts
        self.f5c1=Canvas(self.frame5, width=400, height=300, bg='white')
        #TODO: Startbild zeichnen
        startbildpfad='daten/img/start.gif'
        self.bild=PhotoImage(file=startbildpfad)
        self.f5c1.create_image(0, 0, image=self.bild, anchor=NW)
        self.f5t1=scrolledtext.ScrolledText(self.frame5, width=60, height=8, wrap=WORD, bg='white')
        self.schritt=StringVar()
        self.schritt.set('X')
        self.f5r1=Radiobutton(self.frame5, 
                              variable=self.schritt,
                              text='Edukte',
                              value='ed',
                              command=self.setze_schritt,
                              indicatoron=0)
        self.f5r2=Radiobutton(self.frame5, 
                              variable=self.schritt,
                              text='Übergangszustand',
                              value='uez',
                              command=self.setze_schritt,
                              indicatoron=0)
        self.f5r3=Radiobutton(self.frame5, 
                              variable=self.schritt,
                              text='Produkte',
                              value='prod',
                              command=self.setze_schritt,
                              indicatoron=0)
        ## Rahmen 6: Navigation
        self.icon_reset=PhotoImage(file='daten/icons/view-refresh.gif')
        self.f6b1=Button(self.frame6, 
                         text='Zurücksetzen', 
                         command=self.zurueck_setzen,
                         image=self.icon_reset,
                         compound=LEFT)
        self.f6b1.icon_reset=self.icon_reset
        self.icon_exit = PhotoImage(file='daten/icons/dialog-close.gif')
        self.f6b2=Button(self.frame6, 
                         text='Beenden', 
                         command=root.destroy,
                         image=self.icon_exit,
                         compound=LEFT)
        self.f6b2.icon_exit=self.icon_exit
        ## Fensterelemente setzen und anzeigen
        for i, row, rowspan, column, columnspan, sticky in (
                (frame,       0, 1, 0, 1, E+W),
                (self.frame1, 0, 1, 0, 1, E+W),
                (self.frame2, 1, 1, 0, 1, E+W),
                # in Frame2:
                (self.frame3, 0, 1, 0, 1, E+W), (self.frame5, 0, 3, 1, 1, E+W),
                (self.frame4, 1, 1, 0, 1, E+W), 
                (self.frame6, 2, 1, 0, 1, E+W),
                # Rahmen 1
                (self.f1l1, 0, 1, 0, 2, E+W),                               (self.f1l2, 0, 1, 2, 1, E+W),
                (self.f1r1, 1, 1, 0, 1, E+W), (self.f1r2, 1, 1, 1, 1, E+W), (self.f1r3, 1, 1, 2, 1, E+W),
                # Rahmen 2: Hülle für 3-6
                # Rahmen 3
                (self.f3l1, 0, 1, 0, 1, W),
                (self.f3r1, 1, 1, 0, 1, E+W),
                (self.f3r2, 2, 1, 0, 1, E+W),
                (self.f3r3, 3, 1, 0, 1, E+W),
                (self.f3r4, 4, 1, 0, 1, E+W),
                # Rahmen 4
                (self.f4l1, 0, 1, 0, 1, W),
                (self.f4r1, 1, 1, 0, 1, E+W),
                (self.f4r2, 2, 1, 0, 1, E+W),
                (self.f4l2, 3, 1, 0, 1, W),
                (self.f4r3, 4, 1, 0, 1, E+W),
                # Rahmen 5
                (self.f5c1, 0, 1, 0, 3, E+W),
                (self.f5t1, 1, 1, 0, 3, E+W),
                (self.f5r1, 2, 1, 0, 1, E+W), (self.f5r2, 2, 1, 1, 1, E+W), (self.f5r3, 2, 1, 2, 1, E+W),
                # Rahmen 6
                (self.f6b1, 0, 1, 0, 1, E+W),  
                (self.f6b2, 1, 1, 0, 1, E+W),
                ):
            i.grid(row=row, rowspan=rowspan, column=column, columnspan=columnspan, sticky=sticky)
        self.beim_start_inaktiv=(self.f3l1,
                                 self.f3r1, self.f3r2, self.f3r3, self.f3r4,
                                 self.f4l1, self.f4l2,
                                 self.f4r1, self.f4r2, self.f4r3, 
                                 self.f5r1, self.f5r2, self.f5r3,
                                 self.f5t1, self.f6b1)
        self.auswahl_ebene=(self.f3l1, self.f3r1, self.f3r2, self.f3r3, self.f3r4)
        self.auswahl_darst=(self.f4l1, self.f4l2, self.f4r1, self.f4r2, self.f4r3)
        self.auswahl_schritt=(self.f5r1, self.f5r2, self.f5r3)
        for i in self.beim_start_inaktiv:
            i.config(state=DISABLED)
        ##########  Funktionen  ################################################

    def zurueck_setzen(self):
        for i in (self.reak, self.ebene, self.darst, self.schritt):
            i.set('X')
        for i in self.beim_start_inaktiv:
            i.config(state=DISABLED)
        self.f5t1.config(state=NORMAL)
        self.f5t1.delete(0.0, END)
        self.f5t1.config(state=DISABLED)
        for i in self.f5c1.find_all():
            self.f5c1.delete(i)
        startbildpfad='daten/img/start.gif'
        self.bild=PhotoImage(file=startbildpfad)
        self.f5c1.create_image(0, 0, image=self.bild, anchor=NW)
        self.f5c1.config(background='white')
        self.f5c1.update()
        #print('zurueck_setzen')

    def setze_reak(self):
        reak=str(self.reak.get())
        self.ebene.set('kugel')
        for i in self.f5c1.find_all():
            self.f5c1.delete(i)
        self.f5c1.config(background='white')
        self.f5c1.update()
        for i in self.auswahl_ebene:
            i.config(state=NORMAL)
        self.f3r1.invoke()
        self.f6b1.config(state=NORMAL)
        #print('setze_reak', reak)

    def setze_ebene(self):
        reak=str(self.reak.get())
        ebene=str(self.ebene.get())
        darst=str(self.darst.get())
        schritt=str(self.schritt.get())
        if ebene == 'summe':
            self.f5r2.config(state=DISABLED)
        elif ebene == 'schalen' and darst == 'auf':
            self.f5r2.config(state=DISABLED)
        elif ebene == 'schalen' and darst == 'ab':
            self.f5r2.config(state=DISABLED)
        else:
            self.f5r2.config(state=NORMAL)
        self.darst.set('ueber')
        for i in self.auswahl_darst:
            i.config(state=NORMAL)
        self.f4r3.invoke()
        self.setze_darst()
        if 'X' not in (reak, ebene, darst, schritt):
            self.setze_bild(reak, ebene, darst, schritt)
            self.setze_text(reak, ebene, darst, schritt)
        #print('setze_ebene', ebene)
        
    def setze_darst(self):
        reak=str(self.reak.get())
        ebene=str(self.ebene.get())
        darst=str(self.darst.get())
        schritt=str(self.schritt.get())
        for i in self.auswahl_schritt:
            i.config(state=NORMAL)
        if ebene == 'summe':
            self.f5r2.config(state=DISABLED)
        elif ebene == 'schalen' and darst == 'auf':
            self.f5r2.config(state=DISABLED)
        elif ebene == 'schalen' and darst == 'ab':
            self.f5r2.config(state=DISABLED)
        else:
            self.f5r2.config(state=NORMAL)
        if 'X' not in (reak, ebene, darst, schritt):
            self.setze_bild(reak, ebene, darst, schritt)
            self.setze_text(reak, ebene, darst, schritt)
        self.f5r1.select()
        self.f5r1.invoke()
        self.setze_schritt()
        #print('setze_darst', darst)
        
    def setze_schritt(self):
        reak=str(self.reak.get())
        ebene=str(self.ebene.get())
        darst=str(self.darst.get())
        schritt=str(self.schritt.get())
        if ebene == 'summe':
            self.f5r2.config(state=DISABLED)
        elif ebene == 'schalen' and darst == 'auf':
            self.f5r2.config(state=DISABLED)
        elif ebene == 'schalen' and darst == 'ab':
            self.f5r2.config(state=DISABLED)
        else:
            self.f5r2.config(state=NORMAL)
        self.setze_bild(reak, ebene, darst, schritt)
        self.setze_text(reak, ebene, darst, schritt)
        #print('setze_schritt', schritt)
    
    def setze_bild(self, reak, ebene, darst, schritt):
        if 'X' not in (reak, ebene, darst, schritt):
            bildpfad='daten/img/'+reak+'/'+ebene+'/'+darst+'/'+reak+'_'+ebene+'_'+darst+'_'+schritt+'.gif'
            for i in self.f5c1.find_all():
                self.f5c1.delete(i)
            try:
                if ebene != 'summe':
                    self.bild=PhotoImage(file=bildpfad)
                    self.f5c1.create_image(0, 0, image=self.bild, anchor=NW)
                    self.f5c1.config(background='white')
                    self.f5c1.update()
            except:
                pass
                #print('Bild '+bildpfad+' nicht gefunden')
            try:
                if ebene == 'summe':
                    schluessel=reak+'_'+ebene+'_'+darst+'_'+schritt
                    summenformel=summenformeln[schluessel]
                    self.f5c1.create_text(40,
                                          80,
                                          text=summenformel,
                                          fill='black',
                                          font=('arial', '44'),
                                          anchor=NW,
                                          justify=LEFT,)
            except:
                pass
            #print('setze_bild', bildpfad)
        else:
            print('auswahl fehlt!')
            
    def setze_text(self, reak, ebene, darst, schritt):
        if 'X' not in (reak, ebene, darst, schritt):
            schluessel=reak+'_'+ebene+'_'+darst+'_'+schritt
            einsetztext=textdaten[schluessel]
            #print('setze_text', schluessel)
            self.f5t1.config(state=NORMAL)
            self.f5t1.delete(0.0, END)
            self.f5t1.insert(0.0, einsetztext)
            self.f5t1.config(state=DISABLED)
        else:
            pass
            #print('auswahl fehlt!')

################################################################################
root = Tk()
root.title('Protonierer')
root.option_add('*Text.Font', textfeld_schrift)
app = Fenster(root)
root.mainloop()
