#!/usr/bin/env python3
#-*- encoding=utf8 -*-

textdaten={

################################################################################
##                         Wasser mit Chlorwasserstoff                        ##
################################################################################

##############   Kugelmodell   #################################################
# - Edukte
'h2ohcl_kugel_ueber_ed':\
'Die beiden weiß eingefärbten Wasserstoffatome bilden zusammen mit dem rot eingefärbten Sauerstoffatom ein Wassermolekül. Ein weiß eingefärbtes Wasserstoffatom bildet zusammen mit dem grün eingefärbten Chloratom ein Chlorwasserstoff-Molekül.',
'h2ohcl_kugel_auf_ed':\
'Die beiden weiß eingefärbten Wasserstoffatome bilden zusammen mit dem rot eingefärbten Sauerstoffatom ein Wassermolekül. Das hier ebenfalls weiß eingefärbte Proton kommt in wässriger Lösung nicht einzeln vor. Es darf keinesfalls mit einem ungeladenen Wasserstoffatom verwechselt werden!',
'h2ohcl_kugel_ab_ed':\
'Ein weiß eingefärbtes Wasserstoffatom bildet zusammen mit dem grün eingefärbten Chloratom ein Chlorwasserstoff-Molekül.',
# - Übergangszustand
'h2ohcl_kugel_ueber_uez':\
'Die beiden Moleküle nähern sich aneinander soweit an, dass eine Überlappung des noch an das Chlorwasserstoffmolekül gebundenen Wasserstoffatoms mit dem Wassermolekül auftritt.',
'h2ohcl_kugel_auf_uez':\
'Das neu hinzugekommene Proton lagert sich an das Wassermolekül an.',
'h2ohcl_kugel_ab_uez':\
'Das vorher im Chlorwasserstoffmolekül gebundene positiv polarisierte Wasserstoffatom wird als Proton abgespalten.',
# - Produkte
'h2ohcl_kugel_ueber_prod':\
'Nur das Proton (nicht jedoch das ganze Wasserstoffatom!) wurde auf das Wassermolekül übertragen, so dass ein Oxoniumion entstanden ist. Ebenso entsteht ein Chloridion.',
'h2ohcl_kugel_auf_prod':\
'Es entsteht ein Oxoniumion.',
'h2ohcl_kugel_ab_prod':\
'Das hier weiß eingefärbte Proton kommt in wässriger Lösung nicht einzeln vor. Es trägt eine positive Ladung und darf keinesfalls mit einem ungeladenen Wasserstoffatom verwechselt werden. Es entsteht ein Chloridion.',

##############   Summenformel   ################################################
# - Edukte
'h2ohcl_summe_ueber_ed':\
'Ein Wassermolekül besteht aus zwei Wasserstoffatomen und einem Sauerstoffatom. Ein Chlorwasserstoffmolekül besteht aus einem Wasserstoffatom und einem Chloratom.',
'h2ohcl_summe_auf_ed':\
'Ein Wassermolekül besteht aus zwei Wasserstoffatomen und einem Sauerstoffatom. Zusätzlich ist hier ein (so nicht existentes) einzelnes Proton dargestellt. Die Schreibweise H⁺ drückt aus, dass es sich um ein vom Element Wasserstoff abgeleitetes, positiv geladenes Teilchen handelt. Die (hier nicht verwendete) alternative Schreibweise p⁺ würde ausdrücken, dass es sich eigentlich nur um ein "nacktes" Elementarteilchen, genauer um einen Kernbaustein, noch ohne, bzw. mit leerer Hülle handelt.',
'h2ohcl_summe_ab_ed':\
'Ein Chlorwasserstoffmolekül besteht aus einem Wasserstoffatom und einem Chloratom.',
# - Übergangszustand
#'h2ohcl_summe_ueber_uez':'',
#'h2ohcl_summe_auf_uez':'',
#'h2ohcl_summe_ab_uez':'',
# - Produkte
'h2ohcl_summe_ueber_prod':\
'Ein Oxoniumion besteht aus drei Wasserstoffatomen (genauer: zwei Wasserstoffatomen und einem Proton) und einem Sauerstoffatom, es trägt eine positive Ladung. Ein Chloridion trägt eine negative Ladung.',
'h2ohcl_summe_auf_prod':\
'Ein Oxoniumion besteht aus drei Wasserstoffatomen (genauer: zwei Wasserstoffatomen und einem Proton) und einem Sauerstoffatom, es trägt eine positive Ladung.',
'h2ohcl_summe_ab_prod':\
'Das einzelne Proton kommt so nicht in wässriger Lösung vor. Das Chloridion trägt eine negative Ladung.',

##############   Strukturformel   ##############################################
# - Edukte
'h2ohcl_struktur_ueber_ed':\
'Ein Wassermolekül enthält aufgrund der hohen Elektronegativitätsdifferenz zwei polare H-O-Bindungen. Am Sauerstoffatom befinden sich zwei freie Elektronenpaare. Das Sauerstoffatom ist negativ polarisiert. Das Wasserstoffatom des Chlorwasserstoffmoleküls ist aufgrund der ebenfalls hohen Elektronegativitätsdifferenz stark positiv polarisiert.',
'h2ohcl_struktur_auf_ed':\
'Ein Wassermolekül enthält aufgrund der hohen Elektronegativitätsdifferenz zwei polare H-O-Bindungen. Am Sauerstoffatom befinden sich zwei freie Elektronenpaare. Das Sauerstoffatom ist negativ polarisiert. Das (so nicht existente) einzelne Proton ist einfach positiv geladen.',
'h2ohcl_struktur_ab_ed':\
'Das Wasserstoffatom des Chlorwasserstoffmoleküls ist aufgrund der ebenfalls hohen Elektronegativitätsdifferenz stark positiv polarisiert.',
# - Übergangszustand
'h2ohcl_struktur_ueber_uez':\
'Das freie Elektronenpaar des negativ polarisierten Sauerstoffatoms des Wassermoleküls greift am positiv polarisierten Wasserstoffatom des Chlorwasserstoffmoleküls an (vgl. mit Wasserstoffbrückenbindung!). Es bildet sich eine neue O-H-Bindung aus. Gleichzeitig wird die H-Cl-Bindung heterolytisch gespalten.',
'h2ohcl_struktur_auf_uez':\
'Das freie Elektronenpaar des negativ polarisierten Sauerstoffatoms des Wassermoleküls greift am positiv geladenen Proton an. Es bildet sich eine neue O-H-Bindung aus.',
'h2ohcl_struktur_ab_uez':\
'Die polare H-Cl-Bindung wird heterolytisch gespalten.',
# - Produkte
'h2ohcl_struktur_ueber_prod':\
'Ein Oxoniumion besitzt drei polare H-O-Bindungen. Am zentralen Sauerstoffatom befindet sich ein freies Elektronenpaar. Das Oxoniumion trägt eine positive Ladung. Am Sauerstoffatom liegt eine positive formale Ladung. Das Chloridion besitzt mit vier freien Elektronenpaaren eine negative Ladung.',
'h2ohcl_struktur_auf_prod':\
'Ein Oxoniumion besitzt drei polare H-O-Bindungen. Am zentralen Sauerstoffatom befindet sich ein freies Elektronenpaar. Das Oxoniumion trägt eine positive Ladung. Am Sauerstoffatom liegt eine positive formale Ladung.',
'h2ohcl_struktur_ab_prod':\
'Das (nicht existente) einzelne Proton besitzt im Gegensatz zu einem Wasserstoffatom kein einziges Valenzelektron. Das Chloridion besitzt mit vier freien Elektronenpaaren eine negative Ladung.',

##############   Schalenmodell   ###############################################
# - Edukte
'h2ohcl_schalen_ueber_ed':\
'Auf der Valenzschale des Sauerstoffatoms im Wassermolekül befinden sich insgesamt acht Valenzelektronen, da es zwei seiner vorher bereits im Atom vorhandenen sechs Valenzelektronen mit zwei Wasserstoffatomen teilt, die im Gegenzug jeweils ein zusätzliches Valenzelektron beisteuern. Im Wassermolekül sind insgesamt 10 Protonen und 10 Gesamtelektronen vorhanden, die Ladung beträgt also Null. Im Chlorwasserstoffmolekül sind insgesammt 18 Protonen und 18 Gesamtelektronen vorhanden, die Ladung beträgt also ebenfalls Null.',
'h2ohcl_schalen_auf_ed':\
'Im Wassermolekül sind insgesamt 10 Protonen und 10 Gesamtelektronen vorhanden, die Ladung beträgt also Null. Das (nicht existente) einzelne Proton besitzt im Gegensatz zu einem Wasserstoffatom kein einziges Valenzelektron, die K-schale ist also nicht besetzt (leer).',
'h2ohcl_schalen_ab_ed':\
'Im Chlorwasserstoffmolekül sind insgesammt 18 Protonen und 18 Gesamtelektronen vorhanden, die Ladung beträgt also ebenfalls Null.',
# - Übergangszustand
'h2ohcl_schalen_ueber_uez':\
'Der hier im Überlappungsbereich dargestellt Zustand mit vier Elektronen (entsprechend zwei Bindungselektronenpaaren) ist nicht stabil, da ein Wasserstoffatom maximal zwei Valenzelektronen auf seiner Valenzschale haben kann. Es müssen also sofort zwei Elektronen (entsprechend einem Bindungselektronenpaar) durch eine heterolytische Bindungsspaltung wieder entfernt werden.',
'h2ohcl_schalen_auf_uez':\
'Da hier die beim Deprotonierungsschritt der Säure notwendige Bindungsspaltung nicht dargestellt wird, entspricht hier der Übergangszustand bereits dem Produkt.',
'h2ohcl_schalen_ab_uez':\
'Das einzelne Proton wird abgespalten, die beiden Bindungselektronen bleiben aber beim elektronegativeren Element, so dass ein Chloridion entsteht.',
# - Produkte
'h2ohcl_schalen_ueber_prod':\
'Das Sauerstoffatom im Oxoniumion erreicht eine stabile Valenzelektronenkonfiguration mit drei bindenden und einem freien Elektronenpaar. Das Oxoniumion enthält insgesamt 11 Protonen allerdings nur 10 Gesamtelektronen, so dass es eine einfach positive Ladung trägt. Das Chloridion enthält 17 Protonen und 18 Gesamtelektronen, so dass es eine einfach negative Ladung trägt.',
'h2ohcl_schalen_auf_prod':\
'Das Sauerstoffatom im Oxoniumion erreicht eine stabile Valenzelektronenkonfiguration mit drei bindenden und einem freien Elektronenpaar. Das Oxoniumion enthält insgesamt 11 Protonen allerdings nur 10 Gesamtelektronen, so dass es eine einfach positive Ladung trägt.',
'h2ohcl_schalen_ab_prod':\
'Das (nicht existente) einzelne Proton besitzt im Gegensatz zu einem Wasserstoffatom kein einziges Valenzelektron, so dass es eine einfach positive Ladung besitzt. Das Chloridion enthält 17 Protonen und 18 Gesamtelektronen, so dass es eine einfach negative Ladung trägt.',


################################################################################
##                          Ammoniak mit Wasser                               ##
################################################################################

##############   Kugelmodell   #################################################
# - Edukte
'nh3h2o_kugel_ueber_ed':\
'Die drei weiß eingefärbten Wasserstoffatome bilden zusammen mit dem blau eingefärbten Stickstoffatom ein Ammoniakmolekül. Zwei weiß eingefärbte Wasserstoffatome bilden zusammen mit dem rot eingefärbten Sauerstoffatom ein Wassermolekül.',
'nh3h2o_kugel_auf_ed':\
'Die drei weiß eingefärbten Wasserstoffatome bilden zusammen mit dem blau eingefärbten Stickstoffatom ein Ammoniakmolekül. Das hier ebenfalls weiß eingefärbte Proton kommt in wässriger Lösung nicht einzeln vor. Es darf keinesfalls mit einem ungeladenen Wasserstoffatom verwechselt werden!',
'nh3h2o_kugel_ab_ed':\
'Zwei weiß eingefärbte Wasserstoffatome bilden zusammen mit dem rot eingefärbten Sauerstoffatom ein Wassermolekül.',
# - Übergangszustand
'nh3h2o_kugel_ueber_uez':\
'Die beiden Moleküle nähern sich aneinander soweit an, dass eine Überlappung des noch an das Wassermolekül gebundenen Wasserstoffatoms mit dem Ammoniakmolekül auftritt.',
'nh3h2o_kugel_auf_uez':\
'Das neu hinzugekommene Proton lagert sich an das Ammoniakmolekül an.',
'nh3h2o_kugel_ab_uez':\
'Das vorher im Wassermolekül gebundene positiv polarisierte Wasserstoffatom wird als Proton abgespalten.',
# - Produkte
'nh3h2o_kugel_ueber_prod':\
'Nur das Proton (nicht jedoch das ganze Wasserstoffatom!) wurde auf das Ammoniakmolekül übertragen, so dass ein Ammoniumion entstanden ist. Ebenso entsteht ein Hydroxidion.',
'nh3h2o_kugel_auf_prod':\
'Es entsteht ein Ammoniumion.',
'nh3h2o_kugel_ab_prod':\
'Das hier weiß eingefärbte Proton kommt in wässriger Lösung nicht einzeln vor. Es trägt eine positive Ladung und darf keinesfalls mit einem ungeladenen Wasserstoffatom verwechselt werden. Es entsteht ein Hydroxidion.',

##############   Summenformel   ################################################
# - Edukte
'nh3h2o_summe_ueber_ed':\
'Ein Ammoniakmolekül besteht aus drei Wasserstoffatomen und einem Stickstoffatom. Ein Wassermolekül besteht aus zwei Wasserstoffatomen und einem Sauerstoffatom.',
'nh3h2o_summe_auf_ed':\
'Ein Ammoniakmolekül besteht aus drei Wasserstoffatomen und einem Stickstoffatom. Zusätzlich ist hier ein (so nicht existentes) einzelnes Proton dargestellt. Die Schreibweise H⁺ drückt aus, dass es sich um ein vom Element Wasserstoff abgeleitetes, positiv geladenes Teilchen handelt. Die (hier nicht verwendete) alternative Schreibweise p⁺ würde ausdrücken, dass es sich eigentlich nur um ein "nacktes" Elementarteilchen, genauer um einen Kernbaustein, noch ohne, bzw. mit leerer Hülle handelt. Die K-Schale ist also nicht besetzt.',
'nh3h2o_summe_ab_ed':\
'Ein Wassermolekül besteht aus zwei Wasserstoffatomen und einem Sauerstoffatom.',
# - Übergangszustand
#'nh3h2o_summe_ueber_uez':'',
#'nh3h2o_summe_auf_uez':'',
#'nh3h2o_summe_ab_uez':'',
# - Produkte
'nh3h2o_summe_ueber_prod':\
'Ein Ammoniumion besteht aus vier Wasserstoffatomen (genauer: drei Wasserstoffatomen und einem Proton) und einem Stickstoffatom, es trägt eine positive Ladung. Ein Hydroxidion besteht aus einem Wasserstoffatom und einem Sauerstoffatom, es trägt eine negative Ladung.',
'nh3h2o_summe_auf_prod':\
'Ein Ammoniumion besteht aus vier Wasserstoffatomen (genauer: drei Wasserstoffatomen und einem Proton) und einem Stickstoffatom, es trägt eine positive Ladung.',
'nh3h2o_summe_ab_prod':\
'Das einzelne Proton kommt so nicht in wässriger Lösung vor. Das Hydroxidion trägt eine negative Ladung.',

##############   Strukturformel   ##############################################
# - Edukte
'nh3h2o_struktur_ueber_ed':\
'Ein Ammoniakmolekül enthält aufgrund der hohen Elektronegativitätsdifferenz drei polare H-N-Bindungen. Am Stickstoffatom befindet sich ein freies Elektronenpaar. Das Stickstoffatom ist negativ polarisiert. Das Wasserstoffatom des Wassermoleküls ist aufgrund der ebenfalls hohen Elektronegativitätsdifferenz stark positiv polarisiert.',
'nh3h2o_struktur_auf_ed':\
'Ein Ammoniakmolekül enthält aufgrund der hohen Elektronegativitätsdifferenz drei polare H-N-Bindungen. Am Stickstoffatom befindet sich ein freies Elektronenpaar. Das Stickstoffatom ist negativ polarisiert. Das (so nicht existente) einzelne Proton ist einfach positiv geladen.',
'nh3h2o_struktur_ab_ed':\
'Das Wasserstoffatom des Wassermoleküls ist aufgrund der ebenfalls hohen Elektronegativitätsdifferenz stark positiv polarisiert.',
# - Übergangszustand
'nh3h2o_struktur_ueber_uez':\
'Das freie Elektronenpaar des negativ polarisierten Stickstoffatoms des Ammoniakmoleküls greift am positiv polarisierten Wasserstoffatom des Wassermoleküls an (vgl. mit Wasserstoffbrückenbindung!). Es bildet sich eine neue N-H-Bindung aus. Gleichzeitig wird die H-O-Bindung heterolytisch gespalten.',
'nh3h2o_struktur_auf_uez':\
'Das freie Elektronenpaar des negativ polarisierten Stickstoffatoms des Ammoniakmoleküls greift am positiv geladenen Proton an. Es bildet sich eine neue N-H-Bindung aus.',
'nh3h2o_struktur_ab_uez':\
'Die polare H-O-Bindung wird heterolytisch gespalten.',
# - Produkte
'nh3h2o_struktur_ueber_prod':\
'Ein Ammoniumion besitzt vier polare H-N-Bindungen. Das Ammoniumion trägt eine positive Ladung. Am Stickstoffatom liegt eine positive formale Ladung. Das Sauerstoffatom des Hydroxidions besitzt mit drei bindenden und einem freien Elektronenpaar eine negative formale Ladung. Das gesamte Hydroxidion ist einfach negativ geladen.',
'nh3h2o_struktur_auf_prod':\
'Ein Ammoniumion besitzt vier polare H-N-Bindungen. Das Ammoniumion trägt eine positive Ladung. Am Stickstoffatom liegt eine positive formale Ladung.',
'nh3h2o_struktur_ab_prod':\
'Das (nicht existente) einzelne Proton besitzt im Gegensatz zu einem Wasserstoffatom kein einziges Valenzelektron. Das Sauerstoffatom des Hydroxidions besitzt mit drei bindenden und einem freien Elektronenpaar eine negative formale Ladung. Das gesamte Hydroxidion ist einfach negativ geladen.',

##############   Schalenmodell   ###############################################
# - Edukte
'nh3h2o_schalen_ueber_ed':\
'Auf der Valenzschale des Stickstoffatoms im Ammoniakmolekül befinden sich insgesamt acht Valenzelektronen, da es drei seiner vorher bereits im Atom vorhandenen fünf Valenzelektronen mit drei Wasserstoffatomen teilt, die im Gegenzug jeweils ein zusätzliches Valenzelektron beisteuern. Im Ammoniakmolekül sind insgesamt 10 Protonen und 10 Gesamtelektronen vorhanden, die Ladung beträgt also Null. Im Wassermolekül sind insgesammt 10 Protonen und 10 Gesamtelektronen vorhanden, die Ladung beträgt also ebenfalls Null.',
'nh3h2o_schalen_auf_ed':\
'Im Ammoniakmolekül sind insgesamt 10 Protonen und 10 Gesamtelektronen vorhanden, die Ladung beträgt also Null. Das (nicht existente) einzelne Proton besitzt im Gegensatz zu einem Wasserstoffatom kein einziges Valenzelektron, die K-schale ist also nicht besetzt (leer).',
'nh3h2o_schalen_ab_ed':\
'Im Wassermolekül sind insgesammt 10 Protonen und 10 Gesamtelektronen vorhanden, die Ladung beträgt also ebenfalls Null.',
# - Übergangszustand
'nh3h2o_schalen_ueber_uez':\
'Der hier im Überlappungsbereich dargestellt Zustand mit vier Elektronen (entsprechend zwei Bindungselektronenpaaren) ist nicht stabil, da ein Wasserstoffatom maximal zwei Valenzelektronen auf seiner Valenzschale haben kann. Es müssen also sofort zwei Elektronen (entsprechend einem Bindungselektronenpaar) durch eine heterolytische Bindungsspaltung wieder entfernt werden.',
'nh3h2o_schalen_auf_uez':\
'Da hier die beim Deprotonierungsschritt der Säure notwendige Bindungsspaltung nicht dargestellt wird, entspricht hier der Übergangszustand bereits dem Produkt.',
'nh3h2o_schalen_ab_uez':\
'Das einzelne Proton wird abgespalten, die beiden Bindungselektronen bleiben aber beim elektronegativeren Element, so dass ein Hydroxidion entsteht.',
# - Produkte
'nh3h2o_schalen_ueber_prod':\
'Das Stickstoffatom im Ammoniumion erreicht eine stabile Valenzelektronenkonfiguration mit vier bindenden Elektronenpaaren. Das Ammoniumion enthält insgesamt 11 Protonen allerdings nur 10 Gesamtelektronen, so dass es eine einfach positive Ladung trägt. Das Hydroxidion enthält 9 Protonen und 10 Gesamtelektronen, so dass es eine einfach negative Ladung trägt.',
'nh3h2o_schalen_auf_prod':\
'Das Stickstoffatom im Ammoniumion erreicht eine stabile Valenzelektronenkonfiguration mit vier bindenden Elektronenpaaren. Das Ammoniumion enthält insgesamt 11 Protonen allerdings nur 10 Gesamtelektronen, so dass es eine einfach positive Ladung trägt.',
'nh3h2o_schalen_ab_prod':\
'Das (nicht existente) einzelne Proton besitzt im Gegensatz zu einem Wasserstoffatom kein einziges Valenzelektron, so dass es eine einfach positive Ladung besitzt. Das Hydroxidion enthält 9 Protonen und 10 Gesamtelektronen, so dass es eine einfach negative Ladung trägt.',


################################################################################
##                    Ammoniak mit Chlorwasserstoff                           ##
################################################################################

##############   Kugelmodell   #################################################
# - Edukte
'nh3hcl_kugel_ueber_ed':\
'Die drei weiß eingefärbten Wasserstoffatome bilden zusammen mit dem blau eingefärbten Stickstoffatom ein Ammoniakmolekül. Ein weiß eingefärbtes Wasserstoffatom bildet zusammen mit dem grün eingefärbten Chloratom ein Chlorwasserstoff-Molekül.',
'nh3hcl_kugel_auf_ed':\
'Die drei weiß eingefärbten Wasserstoffatome bilden zusammen mit dem blau eingefärbten Stickstoffatom ein Ammoniakmolekül. Das hier ebenfalls weiß eingefärbte Proton kommt in wässriger Lösung nicht einzeln vor. Es darf keinesfalls mit einem ungeladenen Wasserstoffatom verwechselt werden!',
'nh3hcl_kugel_ab_ed':\
'Ein weiß eingefärbtes Wasserstoffatom bildet zusammen mit dem grün eingefärbten Chloratom ein Chlorwasserstoff-Molekül.',
# - Übergangszustand
'nh3hcl_kugel_ueber_uez':\
'Die beiden Moleküle nähern sich aneinander soweit an, dass eine Überlappung des noch an das Chlorwasserstoffmolekül gebundenen Wasserstoffatoms mit dem Ammoniakmolekül auftritt.',
'nh3hcl_kugel_auf_uez':\
'Das neu hinzugekommene Proton lagert sich an das Ammoniakmolekül an.',
'nh3hcl_kugel_ab_uez':\
'Das vorher im Wassermolekül gebundene positiv polarisierte Wasserstoffatom wird als Proton abgespalten.',
# - Produkte
'nh3hcl_kugel_ueber_prod':\
'Nur das Proton (nicht jedoch das ganze Wasserstoffatom!) wurde auf das Ammoniakmolekül übertragen, so dass ein Ammoniumion entstanden ist. Ebenso entsteht ein Chloridion.',
'nh3hcl_kugel_auf_prod':\
'Es entsteht ein Ammoniumion.',
'nh3hcl_kugel_ab_prod':\
'Das hier weiß eingefärbte Proton kommt in wässriger Lösung nicht einzeln vor. Es trägt eine positive Ladung und darf keinesfalls mit einem ungeladenen Wasserstoffatom verwechselt werden. Es entsteht ein Chloridion.',

##############   Summenformel   ################################################
# - Edukte
'nh3hcl_summe_ueber_ed':\
'Ein Ammoniakmolekül besteht aus drei Wasserstoffatomen und einem Stickstoffatom. Ein Chlorwasserstoffmolekül besteht aus einem Wasserstoffatom und einem Chloratom.',
'nh3hcl_summe_auf_ed':\
'Ein Ammoniakmolekül besteht aus drei Wasserstoffatomen und einem Stickstoffatom. Zusätzlich ist hier ein (so nicht existentes) einzelnes Proton dargestellt. Die Schreibweise H⁺ drückt aus, dass es sich um ein vom Element Wasserstoff abgeleitetes, positiv geladenes Teilchen handelt. Die (hier nicht verwendete) alternative Schreibweise p⁺ würde ausdrücken, dass es sich eigentlich nur um ein "nacktes" Elementarteilchen, genauer um einen Kernbaustein, noch ohne, bzw. mit leerer Hülle handelt. Die K-Schale ist also nicht besetzt.',
'nh3hcl_summe_ab_ed':\
'Ein Chlorwasserstoffmolekül besteht aus einem Wasserstoffatom und einem Chloratom.',
# - Übergangszustand
#'nh3hcl_summe_ueber_uez':'',
#'nh3hcl_summe_auf_uez':'',
#'nh3hcl_summe_ab_uez':'',
# - Produkte
'nh3hcl_summe_ueber_prod':\
'Ein Ammoniumion besteht aus vier Wasserstoffatomen (genauer: drei Wasserstoffatomen und einem Proton) und einem Stickstoffatom, es trägt eine positive Ladung. Ein Chloridion trägt eine negative Ladung.',
'nh3hcl_summe_auf_prod':\
'Ein Ammoniumion besteht aus vier Wasserstoffatomen (genauer: drei Wasserstoffatomen und einem Proton) und einem Stickstoffatom, es trägt eine positive Ladung.',
'nh3hcl_summe_ab_prod':\
'Das einzelne Proton kommt so nicht in wässriger Lösung vor. Das Chloridion trägt eine negative Ladung.',

##############   Strukturformel   ##############################################
# - Edukte
'nh3hcl_struktur_ueber_ed':\
'Ein Ammoniakmolekül enthält aufgrund der hohen Elektronegativitätsdifferenz drei polare H-N-Bindungen. Am Stickstoffatom befindet sich ein freies Elektronenpaar. Das Stickstoffatom ist negativ polarisiert. Das Wasserstoffatom des Chlorwasserstoffmoleküls ist aufgrund der ebenfalls hohen Elektronegativitätsdifferenz stark positiv polarisiert.',
'nh3hcl_struktur_auf_ed':\
'Ein Ammoniakmolekül enthält aufgrund der hohen Elektronegativitätsdifferenz drei polare H-N-Bindungen. Am Stickstoffatom befindet sich ein freies Elektronenpaar. Das Stickstoffatom ist negativ polarisiert. Das (so nicht existente) einzelne Proton ist einfach positiv geladen.',
'nh3hcl_struktur_ab_ed':\
'Das Wasserstoffatom des Chlorwasserstoffmoleküls ist aufgrund der ebenfalls hohen Elektronegativitätsdifferenz stark positiv polarisiert.',
# - Übergangszustand
'nh3hcl_struktur_ueber_uez':\
'Das freie Elektronenpaar des negativ polarisierten Stickstoffatoms des Ammoniakmoleküls greift am positiv polarisierten Wasserstoffatom des des Chlorwasserstoffmoleküls an (vgl. mit Wasserstoffbrückenbindung!). Es bildet sich eine neue N-H-Bindung aus. Gleichzeitig wird die H-Cl-Bindung heterolytisch gespalten.',
'nh3hcl_struktur_auf_uez':\
'Ein Ammoniakmolekül enthält aufgrund der hohen Elektronegativitätsdifferenz zwei polare H-N-Bindungen. Am Stickstoffatom befindet sich ein freies Elektronenpaar. Das Stickstoffatom ist negativ polarisiert. Das (so nicht existente) einzelne Proton ist einfach positiv geladen.',
'nh3hcl_struktur_ab_uez':\
'Die polare H-Cl-Bindung wird heterolytisch gespalten.',
# - Produkte
'nh3hcl_struktur_ueber_prod':\
'Ein Ammoniumion besitzt vier polare H-N-Bindungen. Das Ammoniumion trägt eine positive Ladung. Am Stickstoffatom liegt eine positive formale Ladung. Das Chloridion besitzt mit vier freien Elektronenpaaren eine negative Ladung.',
'nh3hcl_struktur_auf_prod':\
'Ein Ammoniumion besitzt vier polare H-N-Bindungen. Das Ammoniumion trägt eine positive Ladung. Am Stickstoffatom liegt eine positive formale Ladung.',
'nh3hcl_struktur_ab_prod':\
'Das (nicht existente) einzelne Proton besitzt im Gegensatz zu einem Wasserstoffatom kein einziges Valenzelektron. Das Chloridion besitzt mit vier freien Elektronenpaaren eine negative Ladung.',

##############   Schalenmodell   ###############################################
# - Edukte
'nh3hcl_schalen_ueber_ed':\
'Auf der Valenzschale des Stickstoffatoms im Ammoniakmolekül befinden sich insgesamt acht Valenzelektronen, da es drei seiner vorher bereits im Atom vorhandenen fünf Valenzelektronen mit drei Wasserstoffatomen teilt, die im Gegenzug jeweils ein zusätzliches Valenzelektron beisteuern. Im Ammoniakmolekül sind insgesamt 10 Protonen und 10 Gesamtelektronen vorhanden, die Ladung beträgt also Null. Im Chlorwasserstoffmolekül sind insgesammt 18 Protonen und 18 Gesamtelektronen vorhanden, die Ladung beträgt also ebenfalls Null.',
'nh3hcl_schalen_auf_ed':\
'Im Ammoniakmolekül sind insgesamt 10 Protonen und 10 Gesamtelektronen vorhanden, die Ladung beträgt also Null. Das (nicht existente) einzelne Proton besitzt im Gegensatz zu einem Wasserstoffatom kein einziges Valenzelektron, die K-schale ist also nicht besetzt (leer).',
'nh3hcl_schalen_ab_ed':\
'Im Chlorwasserstoffmolekül sind insgesammt 18 Protonen und 18 Gesamtelektronen vorhanden, die Ladung beträgt also ebenfalls Null.',
# - Übergangszustand
'nh3hcl_schalen_ueber_uez':\
'Der hier im Überlappungsbereich dargestellt Zustand mit vier Elektronen (entsprechend zwei Bindungselektronenpaaren) ist nicht stabil, da ein Wasserstoffatom maximal zwei Valenzelektronen auf seiner Valenzschale haben kann. Es müssen also sofort zwei Elektronen (entsprechend einem Bindungselektronenpaar) durch eine heterolytische Bindungsspaltung wieder entfernt werden.',
'nh3hcl_schalen_auf_uez':\
'Da hier die beim Deprotonierungsschritt der Säure notwendige Bindungsspaltung nicht dargestellt wird, entspricht hier der Übergangszustand bereits dem Produkt.',
'nh3hcl_schalen_ab_uez':\
'Das einzelne Proton wird abgespalten, die beiden Bindungselektronen bleiben aber beim elektronegativeren Element, so dass ein Chloridion entsteht.',
# - Produkte
'nh3hcl_schalen_ueber_prod':\
'Das Stickstoffatom im Ammoniumion erreicht eine stabile Valenzelektronenkonfiguration mit vier bindenden Elektronenpaaren. Das Ammoniumion enthält insgesamt 11 Protonen allerdings nur 10 Gesamtelektronen, so dass es eine einfach positive Ladung trägt. Das Chloridion enthält 17 Protonen und 18 Gesamtelektronen, so dass es eine einfach negative Ladung trägt.',
'nh3hcl_schalen_auf_prod':\
'Das Stickstoffatom im Ammoniumion erreicht eine stabile Valenzelektronenkonfiguration mit vier bindenden Elektronenpaaren. Das Ammoniumion enthält insgesamt 11 Protonen allerdings nur 10 Gesamtelektronen, so dass es eine einfach positive Ladung trägt.',
'nh3hcl_schalen_ab_prod':\
'Das (nicht existente) einzelne Proton besitzt im Gegensatz zu einem Wasserstoffatom kein einziges Valenzelektron, so dass es eine einfach positive Ladung besitzt. Das Chloridion enthält 17 Protonen und 18 Gesamtelektronen, so dass es eine einfach negative Ladung trägt.',


}
