#!/usr/bin/python3
# -*- coding: utf-8 -*-
'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
from tkinter import *
from tkinter import messagebox
import codecs
import math
##############################################################################################
import sys

sys.path.insert(0, 'daten')

from daten import PKSWERTE
##############################################################################################
class Fenster:
    def __init__(self, master):
        frame = Frame(master)
        frame.pack()
        self.frame = Frame(frame)
        self.frame.pack()
        self.l1 = Label(self.frame, text=u'Angaben zur S\xe4ure:')
        self.l1.grid(row=0, column=0, columnspan=12)
        self.l3 = Label(self.frame, text=u'St\xe4rke:')
        self.l3.grid(row=1, column=0, columnspan=4, sticky=W)
        global cR1
        cR1=StringVar()
        self.r1 = Radiobutton(self.frame, text=u'stark und\nsehr stark', variable=cR1, command=self.AuswahlStark, value='stark')
        self.r1.select()
        self.r1.grid(row=1, column=4, columnspan=4, sticky=W)
        global cR2
        cR2=StringVar()
        self.r2 = Radiobutton(self.frame, text=u'mittelstark \nund schwach', variable=cR2, command=self.AuswahlSchwach, value='schwach')
        self.r2.grid(row=1, column=8, columnspan=4, sticky=W)
        self.l3 = Label(self.frame, text=u'Name:')
        self.l3.grid(row=2, column=0, columnspan=4, sticky=W)
        self.e1 = Entry(self.frame, background = '#ffffff', width=24)
        self.e1.config(state=DISABLED)
        self.e1.grid(row=2, column=4, columnspan=8, sticky=W)
        self.l2 = Label(self.frame, text=u'Konzentration:')
        self.l2.grid(row=3, column=0, columnspan=4, sticky=W)
        self.e2 = Entry(self.frame, background = '#ffffff', width=5)
        self.e2.insert(0, '1.00')
        self.e2.grid(row=3, column=4, columnspan=2, sticky=W)
        self.l4 = Label(self.frame, text=u'mal 10 hoch')
        self.l4.grid(row=3, column=6, columnspan=2, sticky=W)
        self.e3 = Entry(self.frame, background = '#ffffff', width=5)
        self.e3.insert(0, '0')
        self.e3.grid(row=3, column=8, columnspan=2, sticky=W)
        self.l5 = Label(self.frame, text=u'Mol pro Liter')
        self.l5.grid(row=3, column=10, columnspan=2, sticky=W)
        self.l6 = Label(self.frame, text='pH-Wert:')
        self.l6.grid(row=4, column=0, columnspan=4, sticky=W)
        self.e4 = Entry(self.frame, background = '#ffffff', width=24)
        self.e4.config(state=DISABLED)
        self.e4.grid(row=4, column=4, columnspan=8, sticky=W)
        self.b0 = Button(self.frame, text='Hilfe', command=self.HilfeAnzeigen)
        self.b0.grid(row=10, column=0, columnspan=4, sticky=E+W+S+W)
        self.b1 = Button(self.frame, text='Berechnen', command=self.Berechnen)
        self.b1.grid(row=10, column=4, columnspan=4, sticky=E+W+S+W)
        self.b2 = Button(self.frame, text='Beenden', command=frame.quit)
        self.b2.grid(row=10, column=8, columnspan=4, sticky=N+E+W+S)   
##############################################################################################
    def AuswahlStark(self):
        self.r2.deselect()
        self.e1.delete(0, END)
        self.e1.config(state=DISABLED)

    def AuswahlSchwach(self):
        self.r1.deselect()
        self.e1.config(state=NORMAL)
 
    def Berechnen(self):
        ZAHL1 = float(self.e2.get())
        EXPONENT2 = float(self.e3.get())
        if EXPONENT2 < -6:
            self.e3.delete(0, END)
            self.e3.insert(0, '-6')
            EXPONENT2 = float(self.e3.get())
        SAEUREKONZENTRATION=ZAHL1*(10**EXPONENT2)
        if SAEUREKONZENTRATION > 1.00:
            self.e2.delete(0, END)
            self.e2.insert(0, '1.00')
            ZAHL1 = float(self.e2.get())
            self.e3.delete(0, END)
            self.e3.insert(0, '0')
            EXPONENT2 = float(self.e3.get())
        #print 'c(HA) =',SAEUREKONZENTRATION,'mol/l'
        R1 = str(cR1.get())
        R2 = str(cR2.get())
        if R1 == 'stark':
            #print R1
            pH = -1*math.log10(SAEUREKONZENTRATION)
        if R2 == 'schwach':
            try:
                global SNAME
                SNAME = self.e1.get()
                pKs = PKSWERTE[unicode(SNAME)]
                #print 'pKs von',SNAME,'=',pKs
            except:
                pKs = 4.75
            #print R2
            pH = 0.5*(float(pKs)-math.log10(SAEUREKONZENTRATION))  
        pH = '%.2f' % (pH,)
        #print 'pH-Wert =',pH
        self.e4.config(state=NORMAL)
        self.e4.delete(0, END)
        self.e4.insert(0, pH)

    def HilfeAnzeigen(self):
        messagebox.showinfo(title = 'Kurzhilfe', message = u'Schritt 1:\nW\xe4hle aus, ob es sich um eine starke oder um eine schwache S\xe4ure handelt.\n\nSchritt 2:\nGib im Falle der schwachen S\xe4ure an, ob es sich um \n- Hydrogensulfation\n- Phosphors\xe4ure\n- Essigs\xe4ure\n- Kohlens\xe4ure\n- Dihydrogenphosphation\n- Ammoniumion\n- Hydrogencarbonation\n- Hydrogenphosphation\nhandelt. Dann wird jeweils der richtige pKs-Wert eingelesen.\nSonst wird automatisch ein pKs-Wert von 4.75 angenommen.\n\nSchritt 3:\nGib die Ausgangs- (Stoffmengen-) Konzentration der S\xe4ureteilchen (HA) an.\nBeachte, dass Gleitkommazahlen (float) in der englischen Schreibweise mit einem Punkt und nicht mit einem Komma als Trennzeichen geschrieben werden.\nDer Faktor 10 hoch Null entspricht dem Faktor Eins.\nDie maximale Konzentration einer verd\xfcnnten L\xf6sung betr\xe4gt 1 Mol pro Liter.\nF\xfcr Konzentrationen von weniger als 10 hoch -6 m\xfcsste die Autoprotolyse des Wassers mit ber\xfccksichtigt werden.\nDer Wertebereich f\xfcr g\xfcltige Konzentration bewegt sich also zwischen 1 Mol pro Liter und 10 hoch -6 Mol pro Liter.')
##############################################################################################
root = Tk()
root.title('pH-Wert')
app = Fenster(root)
root.mainloop()
