#!/usr/bin/env python3
'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
from tkinter import *
from tkinter import messagebox
#from tkinter import filedialog
from tkinter import font
from tkinter import constants
#from tkinter import scrolledtext
import os
#import tkMessageBox
#import ScrolledText
#import tkFileDialog
import codecs
#import tkFont
#from Tkconstants import *



# Daten
import sys
sys.path.insert(0, 'daten')
from daten import E1_Daten
from daten import E3_Daten
##############################################################################################

class Fenster:

    def __init__(self, master):
        frame = Frame(master)
        frame.pack()
        self.fonts = {'Ueberschrift':('Helvetica', 14, 'bold'),
                      'Beschriftung' : ('Helvetica', 14),
                      'Elementsymbol' :('Courier New', 16, 'bold'),
                      'Element_Index' :('Courier New', 14, 'bold')
                      }
        self.frame1 = Frame(frame)
        self.frame1.pack(side = TOP, expand = TRUE, fill = X)
        #self.frame1.config(background='green')
        self.frame2 = Frame(frame)
        self.frame2.pack(side = TOP, expand = TRUE, fill = X)
        #self.frame2.config(background='dark grey')
        self.frame3 = Frame(frame)
        self.frame3.pack(side = TOP, expand = TRUE, fill = X)
        #self.frame3.config(background='dark red')

        self.l1 = Label(self.frame1, text=u'1. Lege fest, um welchen Verbindungstyp es sich \nbez\u00FCglich der Zahl der beteiligten Elemente handelt:', font = self.fonts['Ueberschrift'])
        self.l1.grid(row=2, column=0, columnspan=8, sticky=W, padx=4, pady=4)
        global cR1
        cR1=StringVar()
        self.r1 = Radiobutton(self.frame1, text=u'bin\u00E4r \n(aus zwei Elementen)', variable=cR1, value='binaer', command=self.AuswahlBinaer, font = self.fonts['Beschriftung'])
        self.r1.select()
        self.r1.grid(row=3, column=0, columnspan=4, sticky=W)
        global cR2
        cR2=StringVar()
        self.r2 = Radiobutton(self.frame1, text=u'tern\u00E4r \n(aus drei Elementen)', variable=cR2, value='ternaer', command=self.AuswahlTernaer, font = self.fonts['Beschriftung'])
        self.r2.grid(row=3, column=4, columnspan=4, sticky=W)

        self.l2 = Label(self.frame1, text=u'2. Erg\u00E4nze die Elementsymbole und die Indices:', font = self.fonts['Ueberschrift'])
        self.l2.grid(row=4, column=0, columnspan=8, sticky=W, padx=4, pady=4)


        self.l3 = Label(self.frame2, text='OZ:', font = self.fonts['Beschriftung'])
        self.l3.grid(row=5, column=0, columnspan=2, sticky=W, padx=4, pady=4)
        self.e1 = Entry(self.frame2, text='', width=5, background = '#ffffff', font = self.fonts['Elementsymbol'])
        self.e1.config(state=DISABLED)
        self.e1.grid(row=5, column=5, columnspan=2, sticky=W)

        self.l4 = Label(self.frame2, text='Elementsymbole:', font = self.fonts['Beschriftung'])
        self.l4.grid(row=6, column=0, columnspan=2, sticky=W, padx=4, pady=4)
        self.e2 = Entry(self.frame2, width=2, background = '#ffffff', relief = RIDGE, bd = 3, font = self.fonts['Elementsymbol'])
        self.e2.config(state=DISABLED)
        self.e2.grid(row=6, column=3, sticky=S+N+W)
        self.e3 = Entry(self.frame2, width=2, background = '#ffffff', relief = RIDGE, bd = 3, font = self.fonts['Elementsymbol'])
        self.e3.grid(row=6, column=5, sticky=S+N+W)
        self.e4 = Entry(self.frame2, width=2, background = '#ffffff', relief = RIDGE, bd = 3, font = self.fonts['Elementsymbol'])
        self.e4.grid(row=6, column=7, sticky=S+N+W)

        self.l5 = Label(self.frame2, text='Indices:', font = self.fonts['Beschriftung'])
        self.l5.grid(row=7, column=0, columnspan=2, sticky=W, padx=4, pady=4)
        self.e5 = Entry(self.frame2, width=2, background = '#ffffff', relief = RIDGE, bd = 3, font = self.fonts['Element_Index'])
        self.e5.config(state=DISABLED)
        self.e5.grid(row=7, column=4, sticky=W)
        self.e6 = Entry(self.frame2, width=2, background = '#ffffff', relief = RIDGE, bd = 3, font = self.fonts['Element_Index'])
        self.e6.insert(0, '1')
        self.e6.grid(row=7, column=6, sticky=W)
        self.e7 = Entry(self.frame2, width=2, background = '#ffffff', relief = RIDGE, bd = 3, font = self.fonts['Element_Index'])
        self.e7.insert(0, '1')
        self.e7.grid(row=7, column=8, sticky=W)

        self.l6 = Label(self.frame2, text='Gesamtladung:', font = self.fonts['Beschriftung'])
        self.l6.grid(row=5, column=9, columnspan=2, sticky=W, padx=4, pady=4)
        self.e8 = Entry(self.frame2, width=3, background = '#ffffff', relief = RIDGE, bd = 3, font = self.fonts['Elementsymbol'])
        self.e8.insert(0, '0')
        self.e8.grid(row=6, column=9, sticky=W)

        self.b0 = Button(self.frame3, text='Hilfe', command=self.HilfeAnzeigen, font = self.fonts['Beschriftung'])
        self.b0.config(state=NORMAL)
        self.b0.grid(row=0, column=0, columnspan=2, sticky=N+E+W+S)
        self.b1 = Button(self.frame3, text=u'Zur\u00FCcksetzen', command=self.KnopfReset, font = self.fonts['Beschriftung'])
        self.b1.config(state=DISABLED)
        self.b1.grid(row=0, column=2, columnspan=2, sticky=N+E+W+S)
        self.b2 = Button(self.frame3, text='Oxidationszahl\nermitteln', command=self.KnopfOZErmitteln, font = self.fonts['Beschriftung'])
        self.b2.grid(row=0, column=4, columnspan=2, sticky=N+E+W+S)
        self.b3 = Button(self.frame3, text='Beenden', command=frame.quit, font = self.fonts['Beschriftung'])
        self.b3.config(state=DISABLED)
        self.b3.grid(row=0, column=6, columnspan=2, sticky=N+E+W+S)

##############################################################################################

    def AuswahlBinaer(self):
        #print 'Binaer-Reset'
        self.r1.select()
        self.r2.deselect()
        self.e2.delete(0, END)
        self.e2.config(state=DISABLED)
        self.e5.delete(0, END)
        self.e5.config(state=DISABLED)
        self.e3.delete(0, END)
        self.e4.delete(0, END)
        self.e6.delete(0, END)
        self.e6.insert(0, '1')
        self.e7.delete(0, END)
        self.e7.insert(0, '1')
        self.e1.config(state=NORMAL)
        self.e1.delete(0, END)
        self.e1.config(state=DISABLED)
        self.b3.config(state=DISABLED)
        self.e8.delete(0, END)
        self.e8.insert(0, '0')
        self.e8.select_range(0, END)
        self.b2.config(state=NORMAL)
        R1 = str(cR1.get())
        self.r2.deselect()
        self.e2.delete(0, END)
        self.e2.config(state=DISABLED)
        self.e5.delete(0, END)
        self.e5.config(state=DISABLED)
        
    def AuswahlTernaer(self):
        #print 'Ternaer-Reset'
        self.r2.select()
        self.r1.deselect()
        self.e2.delete(0, END)
        self.e2.config(state=DISABLED)
        self.e5.delete(0, END)
        self.e5.config(state=DISABLED)
        self.e3.delete(0, END)
        self.e4.delete(0, END)
        self.e6.delete(0, END)
        self.e6.insert(0, '1')
        self.e7.delete(0, END)
        self.e7.insert(0, '1')
        self.e1.config(state=NORMAL)
        self.e1.delete(0, END)
        self.e1.config(state=DISABLED)
        self.b3.config(state=DISABLED)
        self.e8.delete(0, END)
        self.e8.insert(0, '0')
        self.e8.select_range(0, END)
        self.b2.config(state=NORMAL)
        R2 = str(cR2.get())
        self.r1.deselect()
        self.e2.config(state=NORMAL)
        self.e5.config(state=NORMAL) 
        self.e5.insert(0, '1')       

    def KnopfReset(self):
        #print 'Reset'
        self.r1.select()
        self.r2.deselect()
        self.e2.delete(0, END)
        self.e2.config(state=DISABLED)
        self.e5.delete(0, END)
        self.e5.config(state=DISABLED)
        self.e3.delete(0, END)
        self.e4.delete(0, END)
        self.e6.delete(0, END)
        self.e6.insert(0, '1')
        self.e7.delete(0, END)
        self.e7.insert(0, '1')
        self.e1.config(state=NORMAL)
        self.e1.delete(0, END)
        self.e1.config(state=DISABLED)
        self.b3.config(state=DISABLED)
        self.e8.delete(0, END)
        self.e8.insert(0, '0')
        self.e8.select_range(0, END)
        self.b2.config(state=NORMAL)

    def KnopfOZErmitteln(self):
        #print 'OZErmitteln'
        R1 = str(cR1.get())
        R2 = str(cR2.get())
        self.b1.config(state=NORMAL)
        self.b3.config(state=NORMAL)
        if R1 == 'binaer':
            #print R1
            E2 = str(self.e3.get())
            E2_Ind = int(self.e6.get())
            #print 'Element 2:',E2
            #print 'Index 2:',E2_Ind
            E3 = str(self.e4.get())
            E3_Ind = int(self.e7.get())
            LADUNG = int(self.e8.get())
            #print LADUNG
            #print 'Element 3:',E3
            #print 'Index 3:',E3_Ind
            OZ=int((-1*(int(E3_Ind)*int(E3_Daten[E3][0]))+int(LADUNG))/int(E2_Ind))
            #print(OZ,type(OZ))
            if str(OZ) == '-4':
                OZ_roem='-IV'
            if str(OZ) == '-3':
                OZ_roem='-III'
            if str(OZ) == '-2':
                OZ_roem='-II'
            if str(OZ) == '-1':
               OZ_roem='-I'
            if str(OZ) == '0':
               OZ_roem='0'
            if str(OZ) == '1':
               OZ_roem='+I'
            if str(OZ) == '2':
               OZ_roem='+II'
            if str(OZ) == '3':
               OZ_roem='+III'
            if str(OZ) == '4':
               OZ_roem='+IV'
            if str(OZ) == '5':
               OZ_roem='+V'
            if str(OZ) == '6':
               OZ_roem='+VI'
            if str(OZ) == '7':
               OZ_roem='+VII'
            #print 'Die Oxidationszahl des Elements',E2,'lautet:',OZ_roem
            self.e1.config(state=NORMAL)
            self.e1.insert(0, OZ_roem)
            self.e1.config(background='orange')
        self.b2.config(state=DISABLED)
     
        if R2 == 'ternaer':
            #print R2
            E1 = str(self.e2.get())
            E1_Ind = int(self.e5.get())
            #print 'Element 1:',E1
            #print 'Index 1:',E1_Ind
            E2 = str(self.e3.get())
            E2_Ind = int(self.e6.get())
            #print 'Element 2:',E2
            #print 'Index 2:',E2_Ind
            E3 = str(self.e4.get())
            E3_Ind = int(self.e7.get())
            #print 'Element 3:',E3
            #print 'Index 3:',E3_Ind
            LADUNG = int(self.e8.get())
            #print LADUNG
            OZ=(-1*(int(E1_Ind)*int(E1_Daten[E1][0])+int(E3_Ind)*int(E3_Daten[E3][0]))+int(LADUNG))/int(E2_Ind)
            if str(OZ) == '-4':
                OZ_roem='-IV'
            if str(OZ) == '-3':
                OZ_roem='-III'
            if str(OZ) == '-2':
                OZ_roem='-II'
            if str(OZ) == '-1':
                OZ_roem='-I'
            if str(OZ) == '0':
                OZ_roem='0'
            if str(OZ) == '1':
               OZ_roem='+I'
            if str(OZ) == '2':
               OZ_roem='+II'
            if str(OZ) == '3':
               OZ_roem='+III'
            if str(OZ) == '4':
               OZ_roem='+IV'
            if str(OZ) == '5':
               OZ_roem='+V'
            if str(OZ) == '6':
               OZ_roem='+VI'
            if str(OZ) == '7':
               OZ_roem='+VII'
            #print 'Die Oxidationszahl des Elements',E2,'lautet:',OZ_roem
            self.e1.config(state=NORMAL)
            self.e1.insert(0, OZ_roem)
            self.e1.config(background='orange')
        self.b2.config(state=DISABLED)

    def HilfeAnzeigen(self):
        messagebox.showinfo(title = 'Kurzhilfe', message = u'Element 1 ist ein Metall oder Wasserstoff mit bekannter OZ.\nIn einer bin\u00E4ren Verbindung wie \neinem Molek\u00FClion kann dieses entfallen!\nElement 2 ist das Element, dessen OZ gesucht wird.\nElement 3 ist ein Nichtmetall mit bekannter OZ.\nUm in einem bin\u00E4ren Salz beide Ionen bestimmen zu k\u00F6nnen, kann man das Kation auch als Element 1 nehmen, das Anion als Element 2, wobei dann Element 3 entf\u00E4llt!\nGib in diesem Fall f\u00Fcr Element 3 "fehlt" und als Index "0" an.\nDie Eingabe erfolgt in der Form:\n    1.2. 3.4. 5.6.  \n    E1<x>E2<y>E3<z>\n7. \nGesamtladung\n\nMit organischen Verbindungen wie Traubenzucker\nC<6>H<12>O<6> \nfunktioniert dieses einfache Programm nicht, da Kohlenstoff \nhier nicht in der Position als \nElement 2 steht. Au\u00DFerdem wird nur die mittlere OZ ermittelt!\nIn der Schreibweise H<12>C<6>O<6> klappt\'s aber wieder ganz gut.\nAusnahmen wie F<2>O ergeben je nach Reihenfolge \nFehler - Teste und begr\u00FCnde! ;-)')

##############################################################################################
root = Tk()
root.title('Ozer')
app = Fenster(root)
root.mainloop()
