#!/usr/bin/env python3
#-*- encoding=utf8 -*-


'''
Programmfunktion:

 Sagt die Farbe einer wässrigen Universalindikator-Lösung voraus,
 in die eine nicht näher definierte Menge der entsprechenden organischen
 Säure oder Base gegeben wird.
 Es können die folgenden Konzepte veranschaulicht werden:
 - Korrespondierende Säure-Base-Paare:
    * In einer SB-Reaktion reagieren immer zwei korrespondierende SB-Paare 
      miteinander.
    * Je stärker die Säure, desto schwächer die korrespondierende Base und
      umgekehrt.
 - Substituenteneffekte:
    * Positive Mesomere oder Induktive Effekte mit Elektronenschub,
      aktivieren Nucleophile, hier also die Basen.
    * Negative Mesomere oder Induktive Effekte mit Elektronenzug,
      aktivieren Elektrophile, hier also die Säuren.
 - Gleichgewicht(sreaktionen):
    * Aus der Indikatorfarbe kann abgeleitet werden, wie viele des jeweils 
      durch den Indikator angezeigten Teilchen anteilig gebildet werden:
      Vereinfacht wird davon ausgegangen, dass eine Rotfärbung mit einer 
      höheren Anzahl von Oxoniumionen, eine Blaufürbung mit einer höheren Anzahl
      von Hydroxidionen korreliert. Orange und Grün werden vereinfacht als 
      Mischfarbe zwischen Gelb und Rot bzw. Blau interpretiert.
 - Hinweis für Fortgeschrittene:
    * Die Eigenschaften Nucleophilie bzw. Elektrophilie geben eher Auskunft 
      über kinetische Fragestellungen der Art 'wie schnell läuft die Reaktion
      bei einer bestimmten Temperatur ab?', nicht jedoch über thermodynamische
      Fragestellungen der Art 'liegt das Gleichgewicht eher auf der Seite der
      Endstoffe?'.
      Die Analogisierung mit den aus der Thermodynamik entlehnten Begriffen der
      (Lewis-)Säuren und Basen wie im HSAB-Konzept ist daher eine weitere 
      Vereinfachung, die hier aber für Schüler als zulässig erachtet wird.
      
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4)
        self.frame2=Frame(frame, pady=4)
        self.frame3=Frame(frame, pady=4)
        self.frame4=Frame(frame)
        for f, row, column, columnspan in ((frame,       0, 0, 1),
                                           (self.frame1, 0, 0, 1),
                                           (self.frame2, 1, 0, 1),
                                           (self.frame3, 2, 0, 1)):
            f.grid(row=row, column=column, columnspan=columnspan)

        self.gleichungen={
            'C6H5NH3+': ('H₂O',     'C₆H₅NH₃⁺',     'H₃O⁺',         'C₆H₅NH₂',  
                         'wasser',  'aniliniumion', 'oxoniumion',   'anilin',
                         'Wasser',  'Aniliniumion', 'Oxoniumion',   'Anilin',
                         'white',   'white',        'orangered',    'white'),
            'NH4+':     ('H₂O',     'NH4⁺',         'H₃O⁺',         'NH₃', 
                         'wasser',  'ammoniumion',  'oxoniumion',   'ammoniak',
                         'Wasser',  'Ammoniumion',  'Oxoniumion',   'Ammoniak',
                         'white',   'white',        'darkorange',   'white'),
            'CH3COOH':  ('H₂O',     'CH₃COOH',      'H₃O⁺',         'CH₃COO⁻',  
                         'wasser',  'ethansaeure',  'oxoniumion',   'ethanoation',
                         'Wasser',  'Ethansäure',   'Oxoniumion',   'Ethanoation',
                         'white',   'white',        'darkorange',   'white'),
            'C6H5OH':   ('H₂O',     'C₆H₅OH',       'H₃O⁺',         'C₆H₅O⁻', 
                         'wasser',  'phenol',       'oxoniumion',   'phenolation',
                         'Wasser',  'Phenol',       'Oxoniumion',   'Phenolation',
                         'white',   'white',        'orange',       'white'),
            'CH3CH2OH': ('H₂O',     'CH₃CH₂OH',     'H₃O⁺',         'CH₃CH₂O⁻', 
                         'wasser',  'ethanol',      'oxoniumion',   'ethanolation',
                         'Wasser',  'Ethanol',      'Oxoniumion',   'Ethanolation',
                         'yellow',  'white',        'white',        'white'),
            'C6H5NH2':  ('C₆H₅NH₂', 'H₂O',          'C₆H₅NH₃⁺',     'OH⁻', 
                         'anilin',  'wasser',       'aniliniumion', 'hydroxidion',
                         'Anilin',  'Wasser',       'Aniliniumion', 'Hydroxidion',
                         'white',   'white',        'white',        'yellowgreen'),
            'NH3':      ('NH₃',     'H₂O',          'NH₄⁺',         'OH⁻', 
                         'ammoniak','wasser',       'ammoniumion',  'hydroxidion',
                         'Ammoniak','Wasser',       'Ammoniumion',  'Hydroxidion',
                         'white',   'white',        'white',        'forestgreen'),
            'CH3COO-':  ('CH₃COO⁻', 'H₂O',          'CH₃COOH',      'OH⁻', 
                         'ethanoation','wasser',     'ethansaeure',  'hydroxidion',
                         'Ethanoation','Wasser',     'Ethansäure',   'Hydroxidion',
                         'white',      'white',      'white',        'forestgreen'),
            'C6H5O-':   ('C₆H₅O⁻',  'H₂O',          'C₆H₅OH',       'OH⁻', 
                         'phenolation','wasser',    'phenol',       'hydroxidion',
                         'Phenolation','Wasser',    'Phenol',       'Hydroxidion',
                         'white',      'white',     'white',        'darkcyan'),
            'CH3CH2O-': ('CH₃CH₂O⁻','H₂O',          'CH₃CH₂OH',     'OH⁻',  
                         'ethanolation','wasser',   'ethanol',      'hydroxidion',
                         'Ethanolation','Wasser',   'Ethanol',      'Hydroxidion',
                         'white',       'white',    'white',        'blue',)
            }

        # Frame 1: Protonendruckreihe
        self.l1=Label(self.frame1, text='Substituenten-\neffekt')
        self.l2=Label(self.frame1, text='Säurestärke', fg='red')
        self.l3=Label(self.frame1, text='S', font=('bold'), fg='red')
        self.l4=Label(self.frame1, text='B', font=('bold'), fg='blue')
        self.l5=Label(self.frame1, text='Basenstärke', fg='blue')
        self.l6=Label(self.frame1, text='Substituenen-\neffekt')
        global ausgangsstoff
        ausgangsstoff = StringVar()
        ausgangsstoff.set('wasser')
        self.sr1=Radiobutton(self.frame1, 
                             text='Oxoniumion',
                             variable=ausgangsstoff, 
                             value='H3O+',
                             indicatoron=0, 
                             activebackground='red',
                             activeforeground='white',
                             selectcolor='red',
                             disabledforeground='white',
                             background='red',
                             command=self.ausgangsstoff_festlegen)
        self.sr2=Radiobutton(self.frame1, 
                             text='Aniliniumion',
                             variable=ausgangsstoff, 
                             value='C6H5NH3+',
                             indicatoron=0, 
                             activebackground='orangered',
                             activeforeground='black',
                             selectcolor='orangered',
                             command=self.ausgangsstoff_festlegen)
        self.sr3=Radiobutton(self.frame1, 
                             text='Ammoniumion',
                             variable=ausgangsstoff, 
                             value='NH4+',
                             indicatoron=0, 
                             activebackground='darkorange',
                             activeforeground='black',
                             selectcolor='darkorange',
                             command=self.ausgangsstoff_festlegen)
        self.sr4=Radiobutton(self.frame1, 
                             text='Ethansäure \n(= Essigsäure)',
                             variable=ausgangsstoff, 
                             value='CH3COOH',
                             indicatoron=0, 
                             activebackground='darkorange',
                             activeforeground='black',
                             selectcolor='darkorange',
                             command=self.ausgangsstoff_festlegen)
        self.sr5=Radiobutton(self.frame1, 
                             text='Phenol',
                             variable=ausgangsstoff, 
                             value='C6H5OH',
                             indicatoron=0, 
                             activebackground='orange',
                             activeforeground='black',
                             selectcolor='orange',
                             command=self.ausgangsstoff_festlegen)
        self.sr6=Radiobutton(self.frame1, 
                             text='Wasser',
                             variable=ausgangsstoff, 
                             value='H2O',
                             indicatoron=0, 
                             activebackground='yellow',
                             activeforeground='black',
                             selectcolor='yellow',
                             disabledforeground='black',
                             background='yellow',
                             command=self.ausgangsstoff_festlegen)
        self.sr7=Radiobutton(self.frame1, 
                             text='Ethanol',
                             variable=ausgangsstoff, 
                             value='CH3CH2OH',
                             indicatoron=0, 
                             activebackground='yellow',
                             activeforeground='black',
                             selectcolor='yellow',
                             command=self.ausgangsstoff_festlegen)
        self.br1=Radiobutton(self.frame1, 
                             text='Wasser',
                             variable=ausgangsstoff, 
                             value='H2O',
                             indicatoron=0, 
                             activebackground='yellow',
                             activeforeground='black',
                             selectcolor='yellow',
                             disabledforeground='black',
                             background='yellow',
                             command=self.ausgangsstoff_festlegen)
        self.br2=Radiobutton(self.frame1, 
                             text='Anilin',
                             variable=ausgangsstoff, 
                             value='C6H5NH2',
                             indicatoron=0, 
                             activebackground='yellowgreen',
                             activeforeground='black',
                             selectcolor='yellowgreen',
                             command=self.ausgangsstoff_festlegen)
        self.br3=Radiobutton(self.frame1, 
                             text='Ammoniak',
                             variable=ausgangsstoff, 
                             value='NH3',
                             indicatoron=0, 
                             activebackground='forestgreen',
                             activeforeground='black',
                             selectcolor='forestgreen',
                             command=self.ausgangsstoff_festlegen)
        self.br4=Radiobutton(self.frame1, 
                             text='Ethanoation \n(= Acetation)',
                             variable=ausgangsstoff, 
                             value='CH3COO-',
                             indicatoron=0, 
                             activebackground='forestgreen',
                             activeforeground='black',
                             selectcolor='forestgreen',
                             command=self.ausgangsstoff_festlegen)
        self.br5=Radiobutton(self.frame1, 
                             text='Phenolation',
                             variable=ausgangsstoff, 
                             value='C6H5O-',
                             indicatoron=0, 
                             activebackground='darkcyan',
                             activeforeground='white',
                             selectcolor='darkcyan',
                             command=self.ausgangsstoff_festlegen)
        self.br6=Radiobutton(self.frame1, 
                             text='Hydroxidion',
                             variable=ausgangsstoff, 
                             value='OH-',
                             indicatoron=0, 
                             activebackground='blue',
                             activeforeground='white',
                             selectcolor='blue',
                             disabledforeground='white',
                             background='blue',
                             command=self.ausgangsstoff_festlegen)
        self.br7=Radiobutton(self.frame1, 
                             text='Ethanolation',
                             variable=ausgangsstoff, 
                             value='CH3CH2O-',
                             indicatoron=0, 
                             activebackground='blue',
                             activeforeground='white',
                             selectcolor='blue',
                             command=self.ausgangsstoff_festlegen)
        # Anilin
        self.l7=Label(self.frame1, text='-M \ndes Phenylrests', fg='red')
        self.l8=Label(self.frame1, 
                      text='Etwas stärker als \ndas Ammoniumion', 
                      bg='orangered')
        self.l9=Label(self.frame1, text='-M \ndes Phenylrests', fg='red')
        self.l10=Label(self.frame1, 
                       text='Etwas schwächer als\n Ammoniak', 
                       bg='yellowgreen')
        # Ethansäure
        self.l11=Label(self.frame1, text='-M \nder Carbonylgruppe', fg='red')
        self.l12=Label(self.frame1, 
                       text='Deutlich stärker als\n Ethanol, mittelstark', 
                       bg='darkorange')
        self.l13=Label(self.frame1, text='-M \nder Carbonylgruppe', fg='red')
        self.l14=Label(self.frame1, 
                       text='Deutlich schwächer als\n das Ethanolation, mittelstark', 
                       bg='forestgreen')
        # Phenol
        self.l15=Label(self.frame1, text='-M \ndes Phenylrests', fg='red')
        self.l16=Label(self.frame1, 
                       text='Etwas stärker als\n Ethanol', 
                       bg='orange')
        self.l17=Label(self.frame1, text='-M \ndes Phenylrests', fg='red')
        self.l18=Label(self.frame1, 
                       text='Etwas schwächer als\n das Ethanolation', 
                       bg='darkcyan',
                       fg='white')
        # Ethanol
        self.l19=Label(self.frame1, text='+I \ndes Ethylrests', fg='blue')
        self.l20=Label(self.frame1, 
                       text='Noch schwächer als\n Wasser', 
                       bg='yellow')
        self.l21=Label(self.frame1, text='+I \ndes Ethylrests', fg='blue')
        self.l22=Label(self.frame1, 
                       text='Noch stärker als \ndas Hydroxidion', 
                       bg='blue',
                       fg='white')
        # Fixpunkte zur Orientierung
        self.l23=Label(self.frame1, text='stark', bg='red', fg='white')
        self.l24=Label(self.frame1, text='schwach', bg='yellow', fg='black')
        self.l25=Label(self.frame1, text='Standard')
        self.l26=Label(self.frame1, text='schwach', bg='yellow', fg='black')
        self.l27=Label(self.frame1, text='Standard')
        self.l28=Label(self.frame1, text='stark', bg='blue', fg='white')
        # Mittlere Stärke
        self.l29=Label(self.frame1, text='mittelstark', bg='darkorange')
        self.l30=Label(self.frame1, text='mittelstark', bg='forestgreen')
        
        for i in (self.l23,     self.l8,    self.l29,   self.l12, 
                  self.l16,     self.l24,   self.l20,    self.l26, 
                  self.l10,     self.l30,   self.l14,   self.l18, 
                  self.l28,     self.l22):
            i.config(borderwidth=4)
        
        for i, row, column, columnspan, sticky in (
                # Kopfzeile
                (self.l1,     0, 0, 1, E+W),
                (self.l2,     0, 1, 1, E+W),
                (self.l3,     0, 2, 1, E+W),
                (self.l4,     0, 3, 1, E+W),
                (self.l5,     0, 4, 1, E+W),
                (self.l6,     0, 5, 1, E+W),
                # S/B-Ausgangsstoff-Auswahl
                (self.sr1,    1, 2, 1, E+W+N+S),
                (self.sr2,    2, 2, 1, E+W+N+S),
                (self.sr3,    3, 2, 1, E+W+N+S),
                (self.sr4,    4, 2, 1, E+W+N+S),
                (self.sr5,    5, 2, 1, E+W+N+S),
                (self.sr6,    6, 2, 1, E+W+N+S),
                (self.sr7,    7, 2, 1, E+W+N+S),
                (self.br1,    1, 3, 1, E+W+N+S),
                (self.br2,    2, 3, 1, E+W+N+S),
                (self.br3,    3, 3, 1, E+W+N+S),
                (self.br4,    4, 3, 1, E+W+N+S),
                (self.br5,    5, 3, 1, E+W+N+S),
                (self.br6,    6, 3, 1, E+W+N+S),
                (self.br7,    7, 3, 1, E+W+N+S),
                # Substiuenteneffekte
                (self.l7,     2, 0, 1, E+W),
                (self.l8,     2, 1, 1, E+W),
                (self.l9,     2, 5, 1, E+W),
                (self.l10,    2, 4, 1, E+W),
                (self.l11,    4, 0, 1, E+W),
                (self.l12,    4, 1, 1, E+W),
                (self.l13,    4, 5, 1, E+W),
                (self.l14,    4, 4, 1, E+W),
                (self.l15,    5, 0, 1, E+W),
                (self.l16,    5, 1, 1, E+W),
                (self.l17,    5, 5, 1, E+W),
                (self.l18,    5, 4, 1, E+W),
                (self.l19,    7, 0, 1, E+W),
                (self.l20,    7, 1, 1, E+W),
                (self.l21,    7, 5, 1, E+W),
                (self.l22,    7, 4, 1, E+W),
                # Fixpunkte
                (self.l23,    1, 1, 1, E+W),
                (self.l24,    6, 1, 1, E+W),
                (self.l25,    6, 0, 1, E+W),
                (self.l26,    1, 4, 1, E+W),
                (self.l27,    1, 5, 1, E+W),
                (self.l28,    6, 4, 1, E+W),
                # Mittlere Stärke
                (self.l29,    3, 1, 1, E+W),
                (self.l30,    3, 4, 1, E+W)):
            i.grid(row=row, column=column, 
                   columnspan=columnspan, sticky=sticky)
        self.sr6.select()
        for i in (self.sr1, self.sr6, self.br1, self.br6):
            i.config(state=DISABLED)

        # Rahmen 2: Reaktionsgleichung als Strukturformel und als Summenformel
        self.canvas1=Canvas(self.frame2, width=180, height=180, bg='white')
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)
        self.canvas2=Canvas(self.frame2, width=180, height=180, bg='white')
        self.bild2=PhotoImage(file='daten/img/start.gif')
        self.canvas2.create_image(0, 0, image=self.bild2, anchor = NW)
        self.canvas3=Canvas(self.frame2, width=180, height=180, bg='white')
        self.bild3=PhotoImage(file='daten/img/start.gif')
        self.canvas3.create_image(0, 0, image=self.bild3, anchor = NW)
        self.canvas4=Canvas(self.frame2, width=180, height=180, bg='white')
        self.bild4=PhotoImage(file='daten/img/start.gif')
        self.canvas4.create_image(0, 0, image=self.bild4, anchor = NW)
        self.f2l1=Label(self.frame2, text='Strukturformelgleichung:', pady=4)
        self.f2l2=Label(self.frame2, text='+')
        self.f2l3=Label(self.frame2, text=u'\u21CC')  #\u2192
        self.f2l4=Label(self.frame2, text='+')
        self.f2l5=Label(self.frame2, text='B1', fg='blue')
        self.f2l6=Label(self.frame2, text='S2', fg='red')
        self.f2l7=Label(self.frame2, text='S1', fg='red')
        self.f2l8=Label(self.frame2, text='B2', fg='blue')
        self.f2e1=Entry(self.frame2, 
                        width=10, 
                        disabledbackground='white',
                        disabledforeground='black',
                        state=DISABLED)
        self.f2e2=Entry(self.frame2, 
                        width=10, 
                        disabledbackground='white',
                        disabledforeground='black',
                        state=DISABLED)
        self.f2e3=Entry(self.frame2, 
                        width=10, 
                        disabledbackground='white',
                        disabledforeground='black',
                        state=DISABLED)
        self.f2e4=Entry(self.frame2, 
                        width=10, 
                        disabledbackground='white',
                        disabledforeground='black',
                        state=DISABLED)
        
        for i, row, column, columnspan, sticky in (
                # Label
                (self.f2l1,     0, 0, 7, E+W),
                (self.f2l2,     1, 1, 1, E+W),
                (self.f2l3,     1, 3, 1, E+W),
                (self.f2l4,     1, 5, 1, E+W),
                (self.f2l5,     3, 0, 1, E+W),
                (self.f2l6,     3, 2, 1, E+W),
                (self.f2l7,     3, 4, 1, E+W),
                (self.f2l8,     3, 6, 1, E+W),
                # Canvas
                (self.canvas1,  1, 0, 1, E+W),
                (self.canvas2,  1, 2, 1, E+W),
                (self.canvas3,  1, 4, 1, E+W),
                (self.canvas4,  1, 6, 1, E+W),
                # Eingabefelder
                (self.f2e1,     2, 0, 1, E+W),
                (self.f2e2,     2, 2, 1, E+W),
                (self.f2e3,     2, 4, 1, E+W),
                (self.f2e4,     2, 6, 1, E+W)):
            i.grid(row=row, column=column, 
                   columnspan=columnspan, sticky=sticky)

        # Rahmen 3: Beenden
        self.f3b1=Button(self.frame3, 
                         text='Beenden',
                         command=root.destroy)
        self.f3b1.grid(row=0, column=0, sticky=E+W)

    def ausgangsstoff_festlegen(self):
        self.ausgangsstoff=str(ausgangsstoff.get())
        #print(self.ausgangsstoff)
        self.sf_b1=str(self.gleichungen[self.ausgangsstoff][0])
        self.sf_s2=str(self.gleichungen[self.ausgangsstoff][1])
        self.sf_s1=str(self.gleichungen[self.ausgangsstoff][2])
        self.sf_b2=str(self.gleichungen[self.ausgangsstoff][3])
        self.bild_b1=str(self.gleichungen[self.ausgangsstoff][4])
        self.bild_s2=str(self.gleichungen[self.ausgangsstoff][5])
        self.bild_s1=str(self.gleichungen[self.ausgangsstoff][6])
        self.bild_b2=str(self.gleichungen[self.ausgangsstoff][7])
        self.name_b1=str(self.gleichungen[self.ausgangsstoff][8])
        self.name_s2=str(self.gleichungen[self.ausgangsstoff][9])
        self.name_s1=str(self.gleichungen[self.ausgangsstoff][10])
        self.name_b2=str(self.gleichungen[self.ausgangsstoff][11])
        self.bgfarbe_b1=str(self.gleichungen[self.ausgangsstoff][12])
        self.bgfarbe_s2=str(self.gleichungen[self.ausgangsstoff][13])
        self.bgfarbe_s1=str(self.gleichungen[self.ausgangsstoff][14])
        self.bgfarbe_b2=str(self.gleichungen[self.ausgangsstoff][15])
        for i in (self.f2e1, self.f2e2, self.f2e3, self.f2e4):
            i.config(state=NORMAL)
            i.delete(0, END)
        for i, farbe in ((self.f2e1, self.bgfarbe_b1), 
                         (self.f2e2, self.bgfarbe_s2),
                         (self.f2e3, self.bgfarbe_s1),
                         (self.f2e4, self.bgfarbe_b2)):
            i.config(background=farbe)
        for i, ausgabe in ((self.f2e1, self.name_b1+' ('+self.sf_b1+')'), 
                           (self.f2e2, self.name_s2+' ('+self.sf_s2+')'),
                           (self.f2e3, self.name_s1+' ('+self.sf_s1+')'),
                           (self.f2e4, self.name_b2+' ('+self.sf_b2+')')):
            i.insert(0, ausgabe)
        #for i in (self.f2e1, self.f2e2, self.f2e3, self.f2e4):
        #    i.config(state=DISABLED)
        self.bild1=PhotoImage(file='daten/img/'+self.bild_b1+'.gif')
        self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)
        self.bild2=PhotoImage(file='daten/img/'+self.bild_s2+'.gif')
        self.canvas2.create_image(0, 0, image=self.bild2, anchor = NW)
        self.bild3=PhotoImage(file='daten/img/'+self.bild_s1+'.gif')
        self.canvas3.create_image(0, 0, image=self.bild3, anchor = NW)
        self.bild4=PhotoImage(file='daten/img/'+self.bild_b2+'.gif')
        self.canvas4.create_image(0, 0, image=self.bild4, anchor = NW)


################################################################################
root = Tk()
root.title('Organische Säuren und Basen in Wasser')
app = Fenster(root)
root.mainloop()
