#!/usr/bin/env python3
# -*- coding: utf-8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *
import os
import codecs
import sys
import re
import math
sys.path.insert(0, 'daten')
from halbzellendaten import halbzellendaten

## Schriftart und Schriftgröße hier anpassen:
gui_schriftart='arial'
gui_schriftgroesse='11'

class Fenster:
    def __init__(self, master):
        ########################################################################
        ##                      GUI Hauptfenster                              ##
        ########################################################################
        # Rahmen
        frame=Frame(master)
        self.standard_hintergrundfarbe=str(root.cget('background'))
        self.frame1=Frame(frame)
        self.frame2=Frame(frame)
        self.frame3=Frame(frame)
        self.frame4=Frame(frame)
        self.frame5=Frame(frame)
        self.frame6=Frame(frame)
        self.frame7=Frame(frame)
        # Rahmen 1: Halbzellenauswahl-Liste
        self.f1l1=Label(self.frame1, text='Halbzelle:')
        self.halbzellen=('Li/Li⁺',              'Na/Na⁺',               'Al/Al³⁺',              'H₂/2H₂O (alkalisch)',  'Zn/Zn²⁺',
                         'Fe/Fe²⁺',             'Cd/Cd²⁺',              'Pb/PbSO₄ (sauer)',     'Ni/Ni²⁺',              'Sn/Sn²⁺',
                         'H₂/2H₃O⁺ (sauer)',    'Cu/Cu²⁺',              '2OH⁻/O₂ (alkalisch)',  '2I⁻/I₂',               'Ag/Ag⁺',
                         '2Br⁻/Br₂',            '2H₂O/O₂ (sauer)',      '2Cl⁻/Cl₂',             'Mn²⁺/MnO₄⁻ (sauer)',   'PbSO₄/PbO₂ (sauer)')
        self.listbox1=Listbox(self.frame1,
                              width=20,
                              height=20,
                              selectmode=BROWSE,
                              exportselection=0,
                              bg='white')
        for item in self.halbzellen:
            self.listbox1.insert(END, item)
        self.listbox1.bind('<<ListboxSelect>>', self.auswahl_halbzelle_event, '+')
        self.listbox1.bind('<Return>',          self.auswahl_halbzelle_event, '+')
        self.listbox1.activate(0)
        self.listbox1.select_set(0)
        self.listbox1.focus()
        # Rahmen 2: Oxidationsteilreaktion
        self.f2l1=Label(self.frame2, text='Oxidationsteilreaktion:')
        self.f2e1=Entry(self.frame2, width=60, bg='white', disabledbackground='white', disabledforeground='black')
        # Rahmen 3: Schieberegler zum Verändern der Werte, aktivieren je nach pH-Abhängigkeit
        self.f3l1=Label(self.frame3, text='c(')
        self.f3l2=Label(self.frame3, text='Redm')
        self.f3l3=Label(self.frame3, text=')')
        self.f3scale1=Scale(self.frame3,
                            length=200,
                            from_=0.001,
                            to=1.00,
                            resolution=0.001,
                            showvalue=1,
                            orient=HORIZONTAL,
                            command=self.setze_redm)
        self.f3scale1.set(1)
        self.f3l4=Label(self.frame3, text='c(')
        self.f3l5=Label(self.frame3, text='Oxm')
        self.f3l6=Label(self.frame3, text=')')
        self.f3scale2=Scale(self.frame3,
                            length=200,
                            from_=0.001,
                            to=1.00,
                            resolution=0.001,
                            showvalue=1,
                            orient=HORIZONTAL,
                            command=self.setze_oxm)
        self.f3scale2.set(1)
        self.f3l7=Label(self.frame3, text='pH-Wert', state=DISABLED)
        self.f3scale3=Scale(self.frame3,
                            length=200,
                            from_=0,
                            to=14,
                            resolution=0.1,
                            showvalue=1,
                            orient=HORIZONTAL,
                            command=self.setze_ph)
        self.f3scale3.set(7)
        self.f3scale3.config(state=DISABLED)
        # Rahmen 4: Mathematische Gleichung mit Summenformeln bzw. Zahlenwerten
        gui_schrift_klein=gui_schriftart+' '+str(int(gui_schriftgroesse)-2)
        self.f4l1=Label(self.frame4, text='E')
        self.f4l2=Label(self.frame4, text='=')
        self.f4l3=Label(self.frame4, text='E⁰')
        self.f4l3b=Label(self.frame4, text='')
        self.f4l4=Label(self.frame4, text='+')
        self.f4l5=Label(self.frame4, text='—'*4)
        self.f4l6=Label(self.frame4, text='•')
        self.f4l7=Label(self.frame4, text='lg')
        self.f4l8=Label(self.frame4, text='—'*36)
        self.f4l9=Label(self.frame4, text='0,059')
        self.f4l10=Label(self.frame4, text='V')
        self.f4l11=Label(self.frame4, text='c')
        self.f4l12=Label(self.frame4, text='SF_OXM')
        self.f4l13=Label(self.frame4, text='•')
        self.f4l14=Label(self.frame4, text='c')
        self.f4l15=Label(self.frame4, text='SF_LA_re')
        self.f4l16=Label(self.frame4, text='•')
        self.f4l17=Label(self.frame4, text='c')
        self.f4l18=Label(self.frame4, text='SF_SA_re')
        self.f4l19=Label(self.frame4, text='KO_OXM', font=gui_schrift_klein)
        self.f4l20=Label(self.frame4, text='KO_LA_re', font=gui_schrift_klein)
        self.f4l21=Label(self.frame4, text='KO_SA_re', font=gui_schrift_klein)
        self.f4l22=Label(self.frame4, text='KO_EL')
        self.f4l23=Label(self.frame4, text='KO_REDM', font=gui_schrift_klein)
        self.f4l24=Label(self.frame4, text='KO_LA_li', font=gui_schrift_klein)
        self.f4l25=Label(self.frame4, text='KO_SA_li', font=gui_schrift_klein)
        self.f4l26=Label(self.frame4, text='c')
        self.f4l27=Label(self.frame4, text='SF_REDM')
        self.f4l28=Label(self.frame4, text='•')
        self.f4l29=Label(self.frame4, text='c')
        self.f4l30=Label(self.frame4, text='SF_LA_li')
        self.f4l31=Label(self.frame4, text='•')
        self.f4l32=Label(self.frame4, text='c')
        self.f4l33=Label(self.frame4, text='SF_SA_li')
        # Rahmen 5: Puffer, evtl. für Mathematische Gleichung mit Zahlenwerten
        # Rahmen 6: Lösung
        self.f6l1=Label(self.frame6, text='E')
        self.f6l2=Label(self.frame6, text='=')
        self.f6e1=Entry(self.frame6, 
                        width=20, 
                        bg='white', 
                        state=DISABLED, 
                        disabledforeground='black',
                        disabledbackground=self.standard_hintergrundfarbe)
        self.f6l3=Label(self.frame6, text='V')
        # Rahmen 7: Navigation
        self.icon_zuruecksetzen=PhotoImage(file='daten/icons/zuruecksetzen.gif')
        self.f7b1=Button(self.frame7,
                         text='Zurücksetzen',
                         command=self.zurueck_setzen,
                         image=self.icon_zuruecksetzen,
                         compound=LEFT)
        self.f7b1.icon_zuruecksetzen=self.icon_zuruecksetzen
        self.icon_zahlen=PhotoImage(file='daten/icons/zahlen.gif')
        self.f7b2=Button(self.frame7,
                         text='Zahlenwerte einsetzen',
                         command=self.zahlen_einsetzen,
                         image=self.icon_zahlen,
                         compound=LEFT)
        self.f7b2.icon_zahlen=self.icon_zahlen
        self.icon_berechnen=PhotoImage(file='daten/icons/berechnen.gif')
        self.f7b3=Button(self.frame7,
                         text='Berechnen',
                         command=self.berechnen,
                         image=self.icon_berechnen,
                         compound=LEFT,
                         state=DISABLED)
        self.f7b3.icon_berechnen=self.icon_berechnen
        self.icon_beenden=PhotoImage(file='daten/icons/beenden.gif')
        self.f7b4=Button(self.frame7,
                         text='Beenden',
                         command=root.destroy,
                         image=self.icon_beenden,
                         compound=LEFT)
        self.f7b4.icon_beenden=self.icon_beenden
        ########################################################################
        # Fensterelemente setzen
        for i, row, rowspan, column, columnspan, sticky in (
                # Rahmen
                (frame,         0, 1, 0, 1, E+W),
                (self.frame1,   0, 5, 0, 1, N+W), (self.frame2,  0, 1, 1, 1, E+W),
                                                  (self.frame3,  1, 1, 1, 1, E+W),
                                                  (self.frame4,  2, 1, 1, 1, E+W),
                                                  (self.frame5,  3, 1, 1, 1, E+W),
                                                  (self.frame6,  4, 1, 1, 1, E+W),
                (self.frame7,   5, 1, 0, 2, E+W),
                # Rahmen 1
                (self.f1l1,     0, 1, 0, 1, E+W),
                (self.listbox1, 1, 1, 0, 1, E+W),
                # Rahmen 2
                (self.f2l1,     0, 1, 0, 1, E+W),
                (self.f2e1,     1, 1, 0, 1, E+W),
                # Rahmen 3
                (self.f3l1, 0, 1, 0, 1, E), (self.f3l2, 0, 1, 1, 1, E+W), (self.f3l3, 0, 1, 2, 1, W), (self.f3scale1, 0, 1, 3, 1, E+W), 
                (self.f3l4, 1, 1, 0, 1, E), (self.f3l5, 1, 1, 1, 1, E+W), (self.f3l6, 1, 1, 2, 1, W), (self.f3scale2, 1, 1, 3, 1, E+W), 
                (self.f3l7, 2, 1, 0, 3, E),                                                           (self.f3scale3, 2, 1, 3, 1, E+W), 
                # Rahmen 4
                (self.f4l1,  2, 1,  0,  1, E+W),
                (self.f4l2,  2, 1,  1,  1, E+W),
                (self.f4l3,  2, 1,  2,  1, E+W),
                (self.f4l3b, 2, 1,  3,  1, E+W),
                (self.f4l4,  2, 1,  4,  1, E+W),
                (self.f4l5,  2, 1,  5,  2, E+W),
                (self.f4l6,  2, 1,  7,  1, E+W),
                (self.f4l7,  2, 1,  8,  1, E+W),
                (self.f4l8,  2, 1,  9, 11, E+W),
                (self.f4l9,  1, 1,  5,  1, E),
                (self.f4l10, 1, 1,  6,  1, W),
                (self.f4l11, 1, 1,  9,  1, E),
                (self.f4l12, 1, 1, 10,  1, W),
                (self.f4l13, 1, 1, 12,  1, E+W),
                (self.f4l14, 1, 1, 13,  1, E),
                (self.f4l15, 1, 1, 14,  1, W),
                (self.f4l16, 1, 1, 16,  1, E+W),
                (self.f4l17, 1, 1, 17,  1, E),
                (self.f4l18, 1, 1, 18,  1, W),
                (self.f4l19, 0, 1, 11,  1, E+W),
                (self.f4l20, 0, 1, 15,  1, E+W),
                (self.f4l21, 0, 1, 19,  1, E+W),
                (self.f4l22, 3, 2,  5,  2, E+W),
                (self.f4l23, 3, 1, 11,  1, E+W),
                (self.f4l24, 3, 1, 15,  1, E+W),
                (self.f4l25, 3, 1, 19,  1, E+W),
                (self.f4l26, 4, 1,  9,  1, E),
                (self.f4l27, 4, 1, 10,  1, W),
                (self.f4l28, 4, 1, 12,  1, E+W),
                (self.f4l29, 4, 1, 13,  1, E),
                (self.f4l30, 4, 1, 14,  1, W),
                (self.f4l31, 4, 1, 16,  1, E+W),
                (self.f4l32, 4, 1, 17,  1, E),
                (self.f4l33, 4, 1, 18,  1, W),
                # Rahmen 5
                # Rahmen 6
                (self.f6l1,  0, 1, 0, 1, E+W),
                (self.f6l2,  0, 1, 1, 1, E+W),
                (self.f6e1,  0, 1, 2, 1, E+W),
                (self.f6l3,  0, 1, 3, 1, E+W),
                # Rahmen 7
                (self.f7b1,     0, 1, 0, 1, E+W),
                (self.f7b2,     0, 1, 1, 1, E+W),
                (self.f7b3,     0, 1, 2, 1, E+W),
                (self.f7b4,     0, 1, 3, 1, E+W),
                ):
            i.grid(row=row, rowspan=rowspan, column=column, columnspan=columnspan, sticky=sticky)

            self.auswahl_halbzelle()
    ############################################################################
    ##                             Funktionen                                 ##
    ############################################################################

    def zurueck_setzen(self):
        self.f2e1.config(state=NORMAL)
        self.f2e1.delete(0, END)
        self.f2e1.config(state=DISABLED)
        self.listbox1.activate(0)
        self.listbox1.select_set(0)
        self.listbox1.focus()
        self.auswahl_halbzelle()
        self.f3l2.config(text='Redm')
        self.f3l5.config(text='Oxm')
        self.f3scale3.set(7)
        self.f3scale3.config(state=DISABLED)
        self.f3l7.config(state=DISABLED)
        self.f3scale1.set(1)
        self.f3scale2.set(1)
        self.f7b3.config(state=DISABLED)
        self.f6e1.config(state=NORMAL)
        self.f6e1.delete(0, END)
        self.f6e1.config(state=DISABLED, disabledbackground=self.standard_hintergrundfarbe)
        #print('zurueck_setzen')

    def zahlen_einsetzen(self):
        self.f7b3.config(state=NORMAL)
        halbzellennummer=0
        try:
            halbzellennummer=int(self.listbox1.curselection()[0])
        except:
            pass
        # Metall-Halbzellen
        if halbzellennummer in (0, 1, 2, 4, 5, 6, 8, 9, 11, 14): # 14 ergänzt
            c_redm=self.f3scale2.get()
            c_redm_text='%.3f' % (c_redm)
            self.f4l11.config(text='')
            self.f4l12.config(text=c_redm_text)
            self.f4l26.config(text='')
            self.f4l27.config(text='1')
            #print('Metall-Halbzelle', c_redm_text)
        # Einfache Nichtmetall-Halbzellen
        if halbzellennummer in (13, 15, 17):
            c_oxm=self.f3scale1.get()
            c_oxm_text='%.3f' % (c_oxm)
            self.f4l11.config(text='')
            self.f4l12.config(text='1')
            self.f4l26.config(text='')
            self.f4l27.config(text=c_oxm_text)
            #print('Einfache Nichtmetall-Halbzelle', c_oxm_text)
        # pH-Abhängige Nichtmetall bzw. Übergangsmetall-Halbzellen
        if halbzellennummer in (3,):
            c_hydroxidionen=self.ermittle_c_hydroxidionen(self.f3scale3.get())
            c_hydroxidionen_text='%.24f' % (c_hydroxidionen)
            self.f4l11.config(text='')
            self.f4l12.config(text='1')
            self.f4l26.config(text='')
            self.f4l27.config(text='1')
            self.f4l29.config(text='')
            self.f4l30.config(text=c_hydroxidionen_text)
            #print('pH-Abhängige Nichtmetall-Halbzelle', c_oxoniumionen_text)
        if halbzellennummer in (10,):
            c_oxoniumionen=self.ermittle_c_oxoniumionen(self.f3scale3.get())
            c_oxoniumionen_text='%.24f' % (c_oxoniumionen)
            self.f4l11.config(text='')
            self.f4l12.config(text=c_oxoniumionen_text)
            self.f4l26.config(text='')
            self.f4l27.config(text='1')
            self.f4l32.config(text='')
            self.f4l33.config(text='1')
            #print('pH-Abhängige Nichtmetall-Halbzelle', c_oxoniumionen_text)
        if halbzellennummer in (12,):
            c_hydroxidionen=self.ermittle_c_hydroxidionen(self.f3scale3.get())
            c_hydroxidionen_text='%.24f' % (c_hydroxidionen)
            self.f4l11.config(text='')
            self.f4l12.config(text='1')
            self.f4l26.config(text='')
            self.f4l27.config(text=c_hydroxidionen_text)
            self.f4l17.config(text='')
            self.f4l18.config(text='1')
            #print('pH-Abhängige Nichtmetall-Halbzelle', c_hydroxidionen_text)
        if halbzellennummer in (16,):
            c_oxoniumionen=self.ermittle_c_oxoniumionen(self.f3scale3.get())
            c_oxoniumionen_text='%.24f' % (c_oxoniumionen)
            self.f4l11.config(text='')
            self.f4l12.config(text='1')
            self.f4l26.config(text='')
            self.f4l27.config(text='1')
            self.f4l14.config(text='')
            self.f4l15.config(text=c_oxoniumionen_text)
            #print('pH-Abhängige Nichtmetall-Halbzelle', c_oxoniumionen_text)
        if halbzellennummer in (18,):
            c_oxm=self.f3scale1.get()
            c_oxm_text='%.3f' % (c_oxm)
            c_redm=self.f3scale2.get()
            c_redm_text='%.3f' % (c_redm)
            c_oxoniumionen=self.ermittle_c_oxoniumionen(self.f3scale3.get())
            c_oxoniumionen_text='%.26f' % (c_oxoniumionen)
            self.f4l11.config(text='')
            self.f4l12.config(text=c_redm_text)
            self.f4l26.config(text='')
            self.f4l27.config(text=c_oxm_text)
            self.f4l14.config(text='')
            self.f4l15.config(text=c_oxoniumionen_text)
            self.f4l32.config(text='')
            self.f4l33.config(text='1')
            #print('pH-Abhängige Nichtmetall-Halbzelle', c_oxoniumionen_text)
        if halbzellennummer in (19,):
            c_oxoniumionen=self.ermittle_c_oxoniumionen(self.f3scale3.get())
            c_oxoniumionen_text='%.24f' % (c_oxoniumionen)
            self.f4l11.config(text='')
            self.f4l12.config(text='1')
            self.f4l26.config(text='')
            self.f4l27.config(text='1')
            self.f4l14.config(text='')
            self.f4l15.config(text=c_oxoniumionen_text)
            self.f4l17.config(text='')
            self.f4l18.config(text='1')
            self.f4l32.config(text='')
            self.f4l33.config(text='1')
            #print('pH-Abhängige Nichtmetall-Halbzelle', c_oxoniumionen_text)
        # Nicht durch Oxm, Redm oder pH beeinflussbare Halbzelle
        if halbzellennummer in (7,):
            self.f4l11.config(text='')
            self.f4l12.config(text='1')
            self.f4l26.config(text='')
            self.f4l27.config(text='1')
            self.f4l29.config(text='')
            self.f4l30.config(text='1')
        #print('zahlen_einsetzen')
        
    def ermittle_c_oxoniumionen(self, ph):
        c_oxoniumionen=10.0**(-ph)
        return c_oxoniumionen
        
    def ermittle_c_hydroxidionen(self, ph):
        pOH=14-ph
        c_hydroxidionen=10.0**(-pOH)
        return c_hydroxidionen
        
    def berechnen(self):
        self.zahlen_einsetzen()
        halbzellennummer=0
        try:
            halbzellennummer=int(self.listbox1.curselection()[0])
        except:
            pass
        #TODO: für alle Kombinationen  Gesamtlogteil ermitteln und übergeben
        # Metall-Halbzellen
        if halbzellennummer in (0, 1, 2, 4, 5, 6, 8, 9, 11, 14): # 14 ergänzt
            c_oxm=float(self.f4l12.cget('text'))
            if len(self.f4l19.cget('text')) == 0:
                ko_oxm=1.0
            else:
                ko_oxm=float(self.f4l19.cget('text'))
            logteil=c_oxm**ko_oxm
        # Einfache Nichtmetall-Halbzellen
        if halbzellennummer in (13, 15, 17):
            c_redm=float(self.f4l27.cget('text'))
            if len(self.f4l23.cget('text')) == 0:
                ko_redm=1.0
            else:
                ko_redm=float(self.f4l23.cget('text'))
            logteil=1.0/(c_redm**ko_redm)
        # pH-Abhängige Nichtmetall bzw. Übergangsmetall-Halbzellen
        if halbzellennummer in (3,):
            c_hydroxidionen=float(self.f4l30.cget('text'))
            if len(self.f4l25.cget('text')) == 0:
                ko_la_li=1.0
            else:
                ko_la_li=float(self.f4l25.cget('text'))
            logteil=1.0/(c_hydroxidionen**ko_la_li)
        if halbzellennummer in (10,):
            c_oxm=float(self.f4l12.cget('text'))
            if len(self.f4l19.cget('text')) == 0:
                ko_oxm=1.0
            else:
                ko_oxm=float(self.f4l19.cget('text'))
            logteil=c_oxm**ko_oxm
        if halbzellennummer in (12,):
            c_redm=float(self.f4l27.cget('text'))
            if len(self.f4l23.cget('text')) == 0:
                ko_redm=1.0
            else:
                ko_redm=float(self.f4l23.cget('text'))
            logteil=1.0/(c_redm**ko_redm)
        if halbzellennummer in (16,):
            c_la_re=float(self.f4l15.cget('text'))
            if len(self.f4l20.cget('text')) == 0:
                ko_la_re=1.0
            else:
                ko_la_re=float(self.f4l20.cget('text'))
            logteil=c_la_re**ko_la_re
        if halbzellennummer in (18,):
            c_oxm=float(self.f4l12.cget('text'))
            if len(self.f4l19.cget('text')) == 0:
                ko_oxm=1.0
            else:
                ko_oxm=float(self.f4l19.cget('text'))
            c_redm=float(self.f4l27.cget('text'))
            if len(self.f4l23.cget('text')) == 0:
                ko_redm=1.0
            else:
                ko_redm=float(self.f4l23.cget('text'))
            c_la_re=float(self.f4l15.cget('text'))
            if len(self.f4l20.cget('text')) == 0:
                ko_la_re=1.0
            else:
                ko_la_re=float(self.f4l20.cget('text'))
            logteil=((c_oxm**ko_oxm)*(c_la_re**ko_la_re))/(c_redm**ko_redm)
        if halbzellennummer in (19,):
            c_la_re=float(self.f4l15.cget('text'))
            if len(self.f4l20.cget('text')) == 0:
                ko_la_re=1.0
            else:
                ko_la_re=float(self.f4l20.cget('text'))
            logteil=(c_la_re**ko_la_re)
        # Nicht durch Oxm, Redm oder pH beeinflussbare Halbzelle
        if halbzellennummer in (7,):
            logteil=1.0
        if logteil:
            e0=float(self.f4l3.cget('text'))
            z=float(self.f4l22.cget('text'))
            #print(e0, type(e0))
            e=self.ermittle_e(e0, z, logteil)
            e_text='%.4f' % (e)
            self.f6e1.config(state=NORMAL)
            self.f6e1.delete(0, END)
            self.f6e1.insert(0, e_text)
            self.f6e1.config(state=DISABLED, disabledbackground='white')
        #print('berechnen')

    def ermittle_e(self, e0, z, logteil):
        e=e0+(0.059/z)*math.log10(logteil)
        return e

    def auswahl_halbzelle(self):
        halbzellennummer=0
        try:
            halbzellennummer=int(self.listbox1.curselection()[0])
        except:
            pass
        text_oxidationsteilreaktion=self.erstelle_oxidationsteilreaktion(halbzellennummer)
        self.f2e1.config(state=NORMAL)
        self.f2e1.delete(0, END)
        self.f2e1.insert(0, text_oxidationsteilreaktion)
        self.f2e1.config(state=DISABLED)
        self.f3l2.config(text=halbzellendaten[halbzellennummer]['redm_haelfte'][1])
        self.f3l5.config(text=halbzellendaten[halbzellennummer]['oxm_haelfte'][1])
        self.f3scale1.set(1)
        self.f3scale2.set(1)
        # Alle Schieberegler und Label in Frame3 aktivieren
        for i in (self.f3l1, self.f3l2, self.f3l3, self.f3scale1,
                  self.f3l4, self.f3l5, self.f3l6, self.f3scale2,
                  self.f3l7, self.f3scale3):
            i.config(state=NORMAL)
        if halbzellennummer in (0, 1, 2, 
                                4, 5, 6, 
                                8, 9, 11,
                                13, 14, 15,
                                17):
            self.f3scale3.set(7)
            self.f3scale3.config(state=DISABLED)
            self.f3l7.config(state=DISABLED)
        elif halbzellennummer in (3,12,):
            self.f3scale3.config(state=NORMAL)
            self.f3scale3.set(14)
            self.f3l7.config(state=NORMAL)
        elif halbzellennummer in (7, 10, 16, 18, 19):
            self.f3scale3.config(state=NORMAL)
            self.f3scale3.set(0)
            self.f3l7.config(state=NORMAL)
        # E0
        E0=halbzellendaten[halbzellennummer]['E0']
        # linke Hälfte
        KO_REDM=halbzellendaten[halbzellennummer]['redm_haelfte'][0]
        SF_REDM=halbzellendaten[halbzellennummer]['redm_haelfte'][1]
        KO_LA_li=halbzellendaten[halbzellennummer]['redm_haelfte'][2]
        SF_LA_li=halbzellendaten[halbzellennummer]['redm_haelfte'][3]
        KO_SA_li=halbzellendaten[halbzellennummer]['redm_haelfte'][4]
        SF_SA_li=halbzellendaten[halbzellennummer]['redm_haelfte'][5]
        # rechte Hälfte
        KO_OXM=halbzellendaten[halbzellennummer]['oxm_haelfte'][0]
        SF_OXM=halbzellendaten[halbzellennummer]['oxm_haelfte'][1]
        KO_EL=halbzellendaten[halbzellennummer]['oxm_haelfte'][2]
        SF_EL=halbzellendaten[halbzellennummer]['oxm_haelfte'][3]
        KO_LA_re=halbzellendaten[halbzellennummer]['oxm_haelfte'][4]
        SF_LA_re=halbzellendaten[halbzellennummer]['oxm_haelfte'][5]
        KO_SA_re=halbzellendaten[halbzellennummer]['oxm_haelfte'][6]
        SF_SA_re=halbzellendaten[halbzellennummer]['oxm_haelfte'][7]
        self.f4l3.config(text=str(E0))
        self.f4l3b.config(text='V')
        self.f4l22.config(text=str(KO_EL))
        # überflüssige Werte ausblenden:
        # erst alle Felder wieder neu anzeigen
        for i in (self.f4l11, self.f4l14, self.f4l17,
                  self.f4l26, self.f4l29, self.f4l32):
            i.config(text='c')
        for i in (self.f4l13, self.f4l16,
                  self.f4l28, self.f4l31):
            i.config(text='•')
        # obere Hälfte/Zähler: Produkte
        self.f4l12.config(text='('+str(SF_OXM)+')')
        if str(KO_OXM) == '1':
            KO_OXM=''
        self.f4l19.config(text=str(KO_OXM))
        self.f4l15.config(text='('+str(SF_LA_re)+')')
        if str(KO_LA_re) == '1':
            KO_LA_re=''
        self.f4l20.config(text=str(KO_LA_re))
        self.f4l18.config(text='('+str(SF_SA_re)+')')
        if str(KO_SA_re) == '1':
            KO_SA_re=''
        self.f4l21.config(text=str(KO_SA_re))
        # untere Hälfte/Nenner: Edukte
        self.f4l27.config(text='('+str(SF_REDM)+')')
        if str(KO_REDM) == '1':
            KO_REDM=''
        self.f4l23.config(text=str(KO_REDM))
        self.f4l30.config(text='('+str(SF_LA_li)+')')
        if str(KO_LA_li) == '1':
            KO_LA_li=''
        self.f4l24.config(text=str(KO_LA_li))
        self.f4l33.config(text='('+str(SF_SA_li)+')')
        if str(KO_SA_li) == '1':
            KO_SA_li=''
        self.f4l25.config(text=str(KO_SA_li))
        # hier alle überflüssigen Felder ausblenden
        if halbzellennummer in (0, 1, 2, 4, 5, 6, 8, 9, 11, 13, 14, 15, 17):
            self.f4l8.config(text='—'*8)
            for i in (self.f4l14, self.f4l17,
                      self.f4l29, self.f4l32,
                      self.f4l15, self.f4l18,
                      self.f4l30, self.f4l33,
                      self.f4l13, self.f4l16,
                      self.f4l28, self.f4l31):
                i.config(text='')
        if halbzellennummer in (3, 7):
            self.f4l8.config(text='—'*20)
            for i in (self.f4l13, self.f4l14, self.f4l15,
                      self.f4l16, self.f4l17, self.f4l18,
                      self.f4l31, self.f4l32, self.f4l33):
                i.config(text='')
        if halbzellennummer == 10:
            self.f4l8.config(text='—'*20)
            for i in (self.f4l13, self.f4l14, self.f4l15,
                      self.f4l16, self.f4l17, self.f4l18,
                      self.f4l28, self.f4l29, self.f4l30):
                i.config(text='')
        if halbzellennummer == 12:
            self.f4l8.config(text='—'*20)
            for i in (self.f4l13, self.f4l14, self.f4l15,
                      self.f4l28, self.f4l29, self.f4l30,
                      self.f4l31, self.f4l32, self.f4l33):
                i.config(text='')
        if halbzellennummer == 16:
            self.f4l8.config(text='—'*20)
            for i in (self.f4l16, self.f4l17, self.f4l18,
                      self.f4l28, self.f4l29, self.f4l30,
                      self.f4l31, self.f4l32, self.f4l33):
                i.config(text='')
        if halbzellennummer == 18:
            self.f4l8.config(text='—'*20)
            for i in (self.f4l16, self.f4l17, self.f4l18,
                      self.f4l28, self.f4l29, self.f4l30):
                i.config(text='')
        if halbzellennummer == 19:
            self.f4l8.config(text='—'*20)
            for i in (self.f4l28, self.f4l29, self.f4l30):
                i.config(text='')
        # Alle Label wieder aktivieren (Schieberegler werden bereits oben eingestellt)
        for i in (self.f4l11, self.f4l12, self.f4l19,      self.f4l14, self.f4l15, self.f4l20,    self.f4l17, self.f4l18, self.f4l21,
                  self.f4l26, self.f4l27, self.f4l23,      self.f4l28, self.f4l29, self.f4l24,    self.f4l32, self.f4l33, self.f4l25):
            i.config(state=NORMAL)
        # Alle Feststoffe und Partialdruckabhängige Gase ausgrauen/deaktivieren!
        if halbzellennummer in (0, 1, 2, 4, 5, 6, 8, 9, 11, 14):
            for i in (self.f4l26, self.f4l27, self.f4l23):
                i.config(state=DISABLED)
        if halbzellennummer in (3, 7, 16):
            for i in (self.f4l11, self.f4l12, self.f4l19,
                      self.f4l26, self.f4l27, self.f4l23):
                i.config(state=DISABLED)
        if halbzellennummer in (13, 15, 17):
            for i in (self.f4l11, self.f4l12, self.f4l19):
                i.config(state=DISABLED)
        if halbzellennummer in (10,):
            for i in (self.f4l26, self.f4l27, self.f4l23,     self.f4l32, self.f4l33, self.f4l25):
                i.config(state=DISABLED)
        if halbzellennummer in (12,):
            for i in (self.f4l11, self.f4l12, self.f4l19,    self.f4l17, self.f4l18, self.f4l21):
                i.config(state=DISABLED)
        if halbzellennummer in (18,):
            for i in (self.f4l32, self.f4l33, self.f4l25):
                i.config(state=DISABLED)
        if halbzellennummer in (19,):
            for i in (self.f4l11, self.f4l12, self.f4l19,
                      self.f4l26, self.f4l27, self.f4l23,    self.f4l32, self.f4l33, self.f4l25):
                i.config(state=DISABLED)
        # Schieberegler und Label in Frame3 ebenfalls deaktivieren!
        if halbzellennummer in (0, 1, 2, 4, 5, 6, 8, 9, 11, 14):
            for i in (self.f3l1, self.f3l2, self.f3l3, self.f3scale1,):
                i.config(state=DISABLED)
        if halbzellennummer in (3, 10, 12, 16, 19):
            for i in (self.f3l1, self.f3l2, self.f3l3, self.f3scale1,
                      self.f3l4, self.f3l5, self.f3l6, self.f3scale2):
                i.config(state=DISABLED)
        if halbzellennummer in (7,):
            for i in (self.f3l1, self.f3l2, self.f3l3, self.f3scale1,
                      self.f3l4, self.f3l5, self.f3l6, self.f3scale2,
                      self.f3l7, self.f3scale3):
                i.config(state=DISABLED)
        if halbzellennummer in (13, 15, 17):
            for i in (self.f3l4, self.f3l5, self.f3l6, self.f3scale2,
                      self.f3l7, self.f3scale3):
                i.config(state=DISABLED)
        self.f7b3.config(state=DISABLED)
        self.f6e1.config(state=NORMAL)
        self.f6e1.delete(0, END)
        self.f6e1.config(state=DISABLED, disabledbackground=self.standard_hintergrundfarbe)
        #print(halbzellennummer, type(halbzellennummer))

    def erstelle_oxidationsteilreaktion(self, index):
        # linke Hälfte
        KO_REDM=halbzellendaten[index]['redm_haelfte'][0]
        SF_REDM=halbzellendaten[index]['redm_haelfte'][1]
        KO_LA_li=halbzellendaten[index]['redm_haelfte'][2]
        SF_LA_li=halbzellendaten[index]['redm_haelfte'][3]
        KO_SA_li=halbzellendaten[index]['redm_haelfte'][4]
        SF_SA_li=halbzellendaten[index]['redm_haelfte'][5]
        # rechte Hälfte
        KO_OXM=halbzellendaten[index]['oxm_haelfte'][0]
        SF_OXM=halbzellendaten[index]['oxm_haelfte'][1]
        KO_EL=halbzellendaten[index]['oxm_haelfte'][2]
        SF_EL=halbzellendaten[index]['oxm_haelfte'][3]
        KO_LA_re=halbzellendaten[index]['oxm_haelfte'][4]
        SF_LA_re=halbzellendaten[index]['oxm_haelfte'][5]
        KO_SA_re=halbzellendaten[index]['oxm_haelfte'][6]
        SF_SA_re=halbzellendaten[index]['oxm_haelfte'][7]
        text_oxidationsteilreaktion_lang='''
{0}{1}+{2}{3}+{4}{5} ⇌ {6}{7}+{8}{9}+{10}{11}+{12}{13}'''.format(
            KO_REDM, SF_REDM, KO_LA_li, SF_LA_li, KO_SA_li, SF_SA_li,
            KO_OXM, SF_OXM, KO_EL, SF_EL, KO_LA_re, SF_LA_re, KO_SA_re, SF_SA_re
        ).lstrip('\n')
        # überflüssige ++ und Koeffizienten 1 eliminieren: mit re-Modul!
        text_oxidationsteilreaktion=re.sub('\+\+\Z', '',text_oxidationsteilreaktion_lang)
        text_oxidationsteilreaktion=re.sub('\+\Z', '',text_oxidationsteilreaktion)
        if len(SF_LA_li) < 1 and len(SF_SA_li) < 1:
            text_oxidationsteilreaktion=re.sub('\+\+', '',text_oxidationsteilreaktion)
        elif len(SF_LA_li) > 1:
            text_oxidationsteilreaktion=re.sub('\+\+', '+',text_oxidationsteilreaktion)
        text_oxidationsteilreaktion=re.sub('\+ ', '',text_oxidationsteilreaktion)
        text_oxidationsteilreaktion=re.sub('\+\+', '+',text_oxidationsteilreaktion)
        text_oxidationsteilreaktion=re.sub('1', '',text_oxidationsteilreaktion) 
        return text_oxidationsteilreaktion

    def setze_redm(self, a):
        c_redm=float(a)
        #print('setze_redm', c_redm)

    def setze_oxm(self, a):
        c_oxm=float(a)
        #print('setze_oxm', c_oxm)

    def setze_ph(self, a):
        ph=float(a)
        #print('setze_ph', ph)

    def auswahl_halbzelle_event(self, event):
        self.auswahl_halbzelle()

################################################################################
##                      Hauptschleife                                         ##
################################################################################
root=Tk()
root.title('Nernster')
#root.minsize(520,460)
gui_schrift=gui_schriftart+' '+gui_schriftgroesse
root.option_add('*Font', gui_schrift)
app=Fenster(root)
root.mainloop()
