#!/usr/bin/env python3
#-*- coding: utf-8 -*-

'''
Copyright (C) 2011  Joachim Jakob, Andreas Gagel

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
import os
import sys
import math
import tkinter
from tkinter import *
from tkinter import messagebox
import codecs
import tkinter.font
import time
import tkinter.constants
#from tkconstants import *
# nur fuer Icons auf Knoepfen:
from PIL import Image, ImageTk

#############################################################################################################################

# Anzahl der geoeffneten Nebenfenster
i = 0
# Anzahl der laufenden Animationen vom Typ 1
a1 = 0
# Anzahl der laufenden Animationen vom Typ 2
a2 = 0

###############################################################################################################################

class Main:

    def __init__(self):
        self.gui = MainWindow(self)
        self.gui.mw.mainloop()

###############################################################################################################################

class MainWindow:

    def __init__(self, main):
        self.main = main
        self.mw = tkinter.Tk()
        self.mw.title('Ammoniak-Synthese')

        # Rahmen 1 um das gesamte Fenster
        self.frame1 = tkinter.Frame(self.mw)
        self.frame1.grid(row=0, column=0)
        # Rahmen 2 fuer die Ueberschrift und 
        # die Reaktionsgleichung sowie das MWG
        self.frame2 = tkinter.Frame(self.frame1)
        self.frame2.grid(row=0, column=0, columnspan=4)
        # Rahmen 3 fuer die Schieberegler und Knoepfe
        # in der linken Hauptspalte
        self.frame3 = tkinter.Frame(self.frame1)
        self.frame3.grid(row=1, rowspan=2, column=0, columnspan=1)
        # Rahmen 4 fuer die Animationen bzw. Bilder
        self.frame4 = tkinter.Frame(self.frame1)
        self.frame4.grid(row=1, column=1, columnspan=3)
        # Rahmen 5 fuer die Navigationsknoepfe wie Reset, Hilfe oder Beenden
        self.frame5 = tkinter.Frame(self.frame1)
        self.frame5.grid(row=2, column=1, columnspan=3)

        ## Inhalt von Rahmen 2
        # Entscheidungsfenster Animation
        self.label1 = tkinter.Label(self.frame2, text='Reaktionsablauf')
        self.label1.grid(row=0, column=0, columnspan=2)
        # Knopf zum oeffnen des Nebenfensters 1
        self.button0 = tkinter.Button(self.frame2, text=u'Animationsfenster \u00F6ffnen', command=self.neuesFenster1)
        self.button0.grid(row=1, column=0)
        # Knopf zum oeffnen des Nebenfensters 2
        #self.button100 = tkinter.Button(self.frame2, text=u'Technische Durchf\xfchrung', command=self.neuesFenster1)
        #self.button100.grid(row=1, column=1)

        ## Inhalt von Rahmen 3
        # Einflussfaktoren
        self.label2 = tkinter.Label(self.frame3, text="Einflussfaktor")
        # Temperatur
        global cAuswahl
        cAuswahl=tkinter.StringVar()
        self.radio1 = tkinter.Radiobutton(self.frame3, 
                                          variable=cAuswahl, 
                                          value='Temperatur', 
                                          command=self.Auswahl, 
                                          indicatoron=0, 
                                          text='Temperatur')
        self.scale1 = tkinter.Scale(self.frame3, 
                                    length=200,
                                    from_=0, 
                                    to=100, 
                                    resolution=25,
                                    showvalue=0,
                                    orient=HORIZONTAL)
        self.scale1.set(50)
        self.scale1.config(state=DISABLED)
        self.label3 = tkinter.Label(self.frame3, text='Niedrig')
        self.label4 = tkinter.Label(self.frame3, text='Hoch')

        # Druck
        self.radio2 = tkinter.Radiobutton(self.frame3,
                                          variable=cAuswahl,
                                          value='Druck',
                                          command=self.Auswahl,
                                          indicator=0,
                                          text='Druck')
                                          
        self.scale2 = tkinter.Scale(self.frame3, 
                                    length=200,
                                    from_=0, 
                                    to=100,
                                    resolution=25,
                                    showvalue=0, 
                                    orient=HORIZONTAL)
        self.scale2.set(50)
        self.scale2.config(state=DISABLED)
        self.label5 = tkinter.Label(self.frame3, text='Niedrig')
        self.label6 = tkinter.Label(self.frame3, text='Hoch')
        
        # Wasserstoffkonzentration
        self.radio3 = tkinter.Radiobutton(self.frame3,
                                          variable=cAuswahl,
                                          value='Wasserstoffkonzentration',
                                          command=self.Auswahl,
                                          indicatoron=0,
                                          text='Wasserstoffkonzentration')
                                          
        self.scale3 = tkinter.Scale(self.frame3,  
                                    length=200,
                                    from_=0, 
                                    to=100,
                                    resolution=25,
                                    showvalue=0,
                                    orient=HORIZONTAL)
        self.scale3.set(50)
        self.scale3.config(state=DISABLED)
        self.label7 = tkinter.Label(self.frame3, text='Niedrig')
        self.label8 = tkinter.Label(self.frame3, text='Hoch')

        # Stickstoffkonzentration
        self.radio4 = tkinter.Radiobutton(self.frame3,
                                          variable=cAuswahl,
                                          value='Stickstoffkonzentration',
                                          command=self.Auswahl,
                                          indicatoron=0,
                                          text='Stickstoffkonzentration')
                                          
        self.scale4 = tkinter.Scale(self.frame3, 
                                    length=200,
                                    from_=0, 
                                    to=100,
                                    resolution=25,
                                    showvalue=0,
                                    orient=HORIZONTAL)
        self.scale4.set(50)
        self.scale4.config(state=DISABLED)
        self.label9 = tkinter.Label(self.frame3, text='Niedrig')
        self.label10 = tkinter.Label(self.frame3, text='Hoch')

        # Ammoniakkonzentration
        self.radio5 = tkinter.Radiobutton(self.frame3,
                                          variable=cAuswahl,
                                          value='Ammoniakkonzentration',
                                          command=self.Auswahl,
                                          indicatoron=0,
                                          text='Ammoniakkonzentration')
        self.scale5 = tkinter.Scale(self.frame3, 
                                    length=200,
                                    from_=0, 
                                    to=100,
                                    resolution=25,
                                    showvalue=0,
                                    orient=HORIZONTAL)
        self.scale5.set(50)
        self.scale5.config(state=DISABLED)
        self.label11 = tkinter.Label(self.frame3, text='Niedrig')
        self.label12 = tkinter.Label(self.frame3, text='Hoch')

        # Steuerknoepfe
        #Zustandsauswahl
        self.labelZustand = tkinter.Label(self.frame3, text="Zustand")
        Auswertungbild=Image.open('daten/icons/auswertung.gif')
        Auswertungphoto = ImageTk.PhotoImage(Auswertungbild)
        global cZustand
        cZustand=tkinter.StringVar()
        self.radioAusg = tkinter.Radiobutton(self.frame3,
                                            variable=cZustand,
                                            value='ausg',
                                            compound=RIGHT, 
                                            text='Ausgangszustand',
                                            anchor=W,
                                            image=Auswertungphoto, 
                                            command=self.AuswertungAusg,
                                            state=DISABLED,
                                            indicatoron=0)
        self.radioAusg.image = Auswertungphoto
        self.radioGG = tkinter.Radiobutton(self.frame3,
                                           variable=cZustand,
                                           value='gg',
                                           compound=RIGHT, 
                                           text='Gleichgewicht',
                                           anchor=W,
                                           image=Auswertungphoto,
                                           command=self.AuswertungGG,
                                           state=DISABLED,
                                           indicatoron=0)
        self.radioGG.image = Auswertungphoto
        # Navigationsbuttons Reset, Hilfe, Beenden
        Resetbild=Image.open('daten/icons/reset.gif')
        Resetphoto = ImageTk.PhotoImage(Resetbild)
        self.button2 = tkinter.Button(self.frame5, 
                                      compound=LEFT,
                                      text=u'Zur\xfccksetzen', 
                                      image=Resetphoto,
                                      anchor=CENTER, 
                                      command=self.Reset)
        self.button2.image = Resetphoto


        Hilfebild=Image.open('daten/icons/hilfe.gif')
        Hilfephoto = ImageTk.PhotoImage(Hilfebild)
        self.button3 = tkinter.Button(self.frame5, 
                                      compound=LEFT, 
                                      text='Hilfe', 
                                      image=Hilfephoto,
                                      anchor=CENTER,
                                      command=self.Hilfe)
        self.button3.image = Hilfephoto

        Beendenbild=Image.open('daten/icons/beenden.gif')
        Beendenphoto = ImageTk.PhotoImage(Beendenbild)
        self.button4 = tkinter.Button(self.frame5, 
                                      compound=LEFT, 
                                      text='Beenden', 
                                      image=Beendenphoto,
                                      anchor=CENTER,
                                      command=self.mw.destroy)
        self.button4.image = Beendenphoto

        # Dummy Label als Abstandhalter
        self.dlabel1 = tkinter.Label(self.frame3, text=' ')
        self.dlabel2 = tkinter.Label(self.frame3, text=' ')
        self.dlabel3 = tkinter.Label(self.frame3, text=' ')
        self.dlabel4 = tkinter.Label(self.frame3, text=' ')
        self.dlabel5 = tkinter.Label(self.frame3, text=' ')
        self.dlabel6 = tkinter.Label(self.frame3, text=' ')

        # Fensterelemente Rahmen 3 setzen
        for i, row, column, columnspan, sticky in [
                (self.label2, 0, 0, 3, E+W),

                (self.radio1, 2, 0, 2, E+W),
                (self.scale1, 4, 0, 2, E+W),
                (self.label3, 5, 0, 1, W),
                (self.label4, 5, 1, 1, E),

                (self.dlabel1, 14, 0, 2, E+W),
                (self.radio2, 15, 0, 2, E+W),
                (self.scale2, 16, 0, 2, E+W),
                (self.label5, 17, 0, 1, W),
                (self.label6, 17, 1, 1, E),

                (self.dlabel2, 27, 0, 2, E+W),
                (self.radio3, 28, 0, 2, E+W),
                (self.scale3, 29, 0, 2, W),
                (self.label7, 30, 0, 1, W),
                (self.label8, 30, 1, 1, E),

                (self.dlabel3, 40, 0, 2, E+W),
                (self.radio4, 41, 0, 2, E+W),
                (self.scale4, 42, 0, 2, W),
                (self.label9, 43, 0, 1, W),
                (self.label10, 43, 1, 1, E),

                (self.dlabel4, 53, 0, 2, E+W),
                (self.radio5, 54, 0, 2, E+W),
                (self.scale5, 55, 0, 2, W),
                (self.label11, 56, 0, 1, W),
                (self.label12, 56, 1, 1, E),

                (self.dlabel5, 57, 0, 2, E+W),
                (self.labelZustand, 58, 0, 2, E+W),
                (self.radioAusg, 59, 0, 2, E+W),
                (self.radioGG, 60, 0, 2, E+W), 
                (self.dlabel6, 61, 0, 2, E+W)]:
            i.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        ## Inhalt von Rahmen 4
        self.canvas1 = tkinter.Canvas(self.frame4, width = 670, height = 525, bg = 'darkgrey')
        self.canvas1.grid(row=0, column=0)
        self.bild1 = tkinter.PhotoImage(file = 'daten/img/start.gif')
        self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
        # Inhalt von Rahmen 5
        self.button2.grid(row=0, column=0, sticky=E+W),
        self.button3.grid(row=0, column=1, sticky=E+W),
        self.button4.grid(row=0, column=2, sticky=E+W)

###############################################################################################################################

    def Hilfe(self):
        messagebox.showinfo(title = 'Hilfe', message = u'1. W\xe4hle zun\xe4chst den gew\xfcnschten Einflussfaktor aus.\n2. Stelle mit dem Schieberegler den gew\xfcnschten Wert ein.\n3. Betrachte die Lage dieses Gleichgewichts und leite daraus ein wichtiges Prinzip ab.\nErstellt 2008 von\nAndreas Gagel und Joachim Jakob (KGA)\nmit Python/tkinter.\nLizenz: GNU GPL.')

    def Auswahl(self):
        global Auswahl
        Auswahl = str(cAuswahl.get())
        print(Auswahl)
        if Auswahl == 'Temperatur':
            self.radioAusg.config(state=NORMAL)
            self.radioGG.config(state=NORMAL)
            self.scale1.config(state=NORMAL)
            for a in (self.radio2, self.radio3, self.radio4, self.radio5):
                a.config(state=NORMAL)
                a.deselect()
                a.config(state=DISABLED)
            for b in (self.scale2, self.scale3, self.scale4, self.scale5):
                b.config(state=NORMAL)
                b.set(50)
                b.config(state=DISABLED)
        if Auswahl == 'Druck':
            self.radioAusg.config(state=NORMAL)
            self.radioGG.config(state=NORMAL)
            self.scale2.config(state=NORMAL)
            for c in (self.radio1, self.radio3, self.radio4, self.radio5):
                c.config(state=NORMAL)
                c.deselect()
                c.config(state=DISABLED)
            for d in (self.scale1, self.scale3, self.scale4, self.scale5):
                d.config(state=NORMAL)
                d.set(50)
                d.config(state=DISABLED)
        if Auswahl == 'Wasserstoffkonzentration':
            self.radioAusg.config(state=NORMAL)
            self.radioGG.config(state=NORMAL)
            self.scale3.config(state=NORMAL)
            for e in (self.radio1, self.radio2, self.radio4, self.radio5):
                e.config(state=NORMAL)
                e.deselect()
                e.config(state=DISABLED)
            for f in (self.scale1, self.scale2, self.scale4, self.scale5):
                f.config(state=NORMAL)
                f.set(50)
                f.config(state=DISABLED)
        if Auswahl == 'Stickstoffkonzentration':
            self.radioAusg.config(state=NORMAL)
            self.radioGG.config(state=NORMAL)
            self.scale4.config(state=NORMAL)
            for c in (self.radio1, self.radio2, self.radio3, self.radio5):
                c.config(state=NORMAL)
                c.deselect()
                c.config(state=DISABLED)
            for d in (self.scale1, self.scale2, self.scale3, self.scale5):
                d.config(state=NORMAL)
                d.set(50)
                d.config(state=DISABLED)
        if Auswahl == 'Ammoniakkonzentration':
            self.radioAusg.config(state=NORMAL)
            self.radioGG.config(state=NORMAL)
            self.scale5.config(state=NORMAL)
            for c in (self.radio1, self.radio2, self.radio3, self.radio4):
                c.config(state=NORMAL)
                c.deselect()
                c.config(state=DISABLED)
            for d in (self.scale1, self.scale2, self.scale3, self.scale4):
                d.config(state=NORMAL)
                d.set(50)
                d.config(state=DISABLED)
 
    def AuswertungAusg(self):
        print("Auswertung Ausgangszustand")
        # Bilder mit gg
        if Auswahl == 'Temperatur':
            Zahlenwert = int(self.scale1.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/T1_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/T2_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/T3_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/T4_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/T5_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
        if Auswahl == 'Druck':
            Zahlenwert = int(self.scale2.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/P1_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/P2_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/P3_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/P4_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/P5_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW) 
        if Auswahl == 'Wasserstoffkonzentration':
            Zahlenwert = int(self.scale3.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/H1_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/H2_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/H3_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/H4_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/H5_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
        if Auswahl == 'Stickstoffkonzentration':
            Zahlenwert = int(self.scale4.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/N1_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/N2_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/N3_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/N4_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/N5_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
        if Auswahl == 'Ammoniakkonzentration':
            Zahlenwert = int(self.scale5.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/NH1_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/NH2_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/NH3_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/NH4_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/ausg/NH5_ausg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)

    def AuswertungGG(self):
        print("Auswertung Gleichgewichtszustand")
        # Bilder mit gg
        if Auswahl == 'Temperatur':
            Zahlenwert = int(self.scale1.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/T1_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/T2_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/T3_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/T4_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/T5_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
        if Auswahl == 'Druck':
            Zahlenwert = int(self.scale2.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/P1_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/P2_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/P3_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/P4_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/P5_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW) 
        if Auswahl == 'Wasserstoffkonzentration':
            Zahlenwert = int(self.scale3.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/H1_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/H2_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/H3_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/H4_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/H5_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
        if Auswahl == 'Stickstoffkonzentration':
            Zahlenwert = int(self.scale4.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/N1_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/N2_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/N3_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/N4_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/N5_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
        if Auswahl == 'Ammoniakkonzentration':
            Zahlenwert = int(self.scale5.get())
            print(Zahlenwert)
            if str(Zahlenwert) == str(0):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/NH1_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(25):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/NH2_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(50):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/NH3_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(75):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/NH4_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
            if str(Zahlenwert) == str(100):
                try:
                    self.bild1.destroy()
                except:
                    pass
                self.bild1 = tkinter.PhotoImage(file = 'daten/img/gg/NH5_gg.gif')
                self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)

    def Reset(self):
        print("Reset") 
        self.radio1.config(state=NORMAL)
        self.radio1.deselect()
        self.scale1.config(state=NORMAL)
        self.scale1.set(50)
        self.scale1.config(state=DISABLED)
        self.radio2.config(state=NORMAL)
        self.radio2.deselect()
        self.scale2.config(state=NORMAL)
        self.scale2.set(50)
        self.scale2.config(state=DISABLED)
        self.radio3.config(state=NORMAL)
        self.radio3.deselect()
        self.scale3.config(state=NORMAL)
        self.scale3.set(50)
        self.scale3.config(state=DISABLED)
        self.radio4.config(state=NORMAL)
        self.radio4.deselect()
        self.scale4.config(state=NORMAL)
        self.scale4.set(50)
        self.scale4.config(state=DISABLED)
        self.radio5.config(state=NORMAL)
        self.radio5.deselect()
        self.scale5.config(state=NORMAL)
        self.scale5.set(50)
        self.scale5.config(state=DISABLED)
        self.radioAusg.config(state=NORMAL)
        self.radioGG.config(state=NORMAL)
        self.radioAusg.deselect()
        self.radioGG.deselect()
        self.radioAusg.config(state=DISABLED)
        self.radioGG.config(state=DISABLED)
        try:
            self.bild1.destroy()
        except:
            pass
        self.bild1 = tkinter.PhotoImage(file = 'daten/img/start.gif')
        self.canvas1.create_image(45, 45, image = self.bild1, anchor = NW)
        global i
        i = 0
        global a1
        global a2
        a1 = 0
        a2 = 0
        
################################# Funktionen innerhalb des Nebenfensters ###################################
    def neuesFenster1(self):
        """Funktion zum Oeffnen des Nebenfensters"""
        global i
        if i < 1:
            i = i + 1
            global a1
            global a2
            a1 = 0
            a2 = 0
            #print('i nach Oeffnen des neuen Fensters =',i)
            self.nw = tkinter.Toplevel(self.mw)
            self.nw.title('Animationsfenster')
            # Rahmen im Nebenfenster
            self.nwFrame = tkinter.Frame(self.nw)
            self.nwFrame.grid(row=0, column=0)
            self.nwCanvas1 = tkinter.Canvas(self.nwFrame, width = 580, height = 435, bg = 'darkgrey')
            self.nwCanvas1.grid(row=0, column=0, columnspan=2)
            PROGDIR=str(os.getcwd())
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani')
            IMAGENAME='ani0.gif'
            IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
            self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
            self.nwCanvas1.create_image(295, 220, image = self.bild1)
            #Animation 1
            self.nwButton1 = tkinter.Button(self.nwFrame, text='Start Animation 1', command=self.startAnimation1)
            self.nwButton1.grid(row=2, column=0)
            self.nwLabel21 = tkinter.Label(self.nwFrame, text='Verhalten von Gasteilchen')
            self.nwLabel21.grid(row=2, column=1, sticky=W)
            #Animation 2
            self.nwButton2 = tkinter.Button(self.nwFrame, text='Start Animation 2', command=self.startAnimation2)
            self.nwButton2.grid(row=3, column=0)
            self.nwLabel22 = tkinter.Label(self.nwFrame, text='Geschwindigkeitsverteilung bei niedriger Temperatur')
            self.nwLabel22.grid(row=3, column=1, sticky=W)
            #Animation 3
            self.nwButton3 = tkinter.Button(self.nwFrame, text='Start Animation 3', command=self.startAnimation3)
            self.nwButton3.grid(row=4, column=0)
            self.nwLabel23 = tkinter.Label(self.nwFrame, text='Geschwindigkeitsverteilung bei hoher Temperatur')
            self.nwLabel23.grid(row=4, column=1, sticky=W)            
            #Animation 4
            self.nwButton4 = tkinter.Button(self.nwFrame, text='Start Animation 4', command=self.startAnimation4)
            self.nwButton4.grid(row=5, column=0)
            self.nwLabel24 = tkinter.Label(self.nwFrame, text='Bildung von Ammoniak - ohne Katalysator')
            self.nwLabel24.grid(row=5, column=1, sticky=W)
            #Animation 5
            self.nwButton5 = tkinter.Button(self.nwFrame, text='Start Animation 5', command=self.startAnimation5)
            self.nwButton5.grid(row=6, column=0)
            self.nwLabel25 = tkinter.Label(self.nwFrame, text='Zerfall von Ammoniak - ohne Katalysator')
            self.nwLabel25.grid(row=6, column=1, sticky=W)
            #Animation 6
            self.nwButton6 = tkinter.Button(self.nwFrame, text='Start Animation 6', command=self.startAnimation6)
            self.nwButton6.grid(row=7, column=0)
            self.nwLabel26 = tkinter.Label(self.nwFrame, text='Bildung von Ammoniak - mit Katalysator')
            self.nwLabel26.grid(row=7, column=1, sticky=W)
            #Animation 7
            self.nwButton7 = tkinter.Button(self.nwFrame, text='Start Animation 7', command=self.startAnimation7)
            self.nwButton7.grid(row=8, column=0)
            self.nwLabel27 = tkinter.Label(self.nwFrame, text='Zerfall von Ammoniak - mit Katalysator')
            self.nwLabel27.grid(row=8, column=1, sticky=W)            
            #Animationsfenster schliessen
            self.nwButton8 = tkinter.Button(self.nwFrame, text=u'Animationsfenster schlie\u00DFen', command=self.nebenFensterSchliessen)
            self.nwButton8.grid(row=9, column=0, columnspan=2)
        else:
            #print('Es ist schon ein Nebenfenster geoeffnet')
            pass

    def startAnimation1(self):
        """Funktion innerhalb des Nebenfensters, z.B. Animationsstart"""
        self.Reset()
        global a1
        global a2
        if a1 < 1 and a2 < 1:
            a1 = 1
            a2 = 1
            PROGDIR=str(os.getcwd())
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani/ani1')
            BILDANZAHL=len(os.listdir(ANIMDIR))
            #print(BILDANZAHL)
            L = []
            L = os.listdir(ANIMDIR)
            L.sort()
            #print(L)
            for j in range(len(L)-1):
                #print(j)
                IMAGENAME='ani1-'+str(j)+'.gif'
                IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
                #print(IMAGEPFAD)
                self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
                self.nwCanvas1.create_image(295, 220, image = self.bild1)
                self.nwCanvas1.update()
                for k in range(0, 19):
                    time.sleep(0.01)
                    self.nw.update()
            IMAGENAME='ani0.gif'
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani')
            IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
            self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
            self.nwCanvas1.create_image(295, 220, image = self.bild1)
            a1 = 0
            a2 = 0
        else:
            #print('Animation wurde bereits gestartet')
            pass

    def startAnimation2(self):
        """Funktion innerhalb des Nebenfensters, z.B. Animationsstart"""
        self.Reset()
        global a1
        global a2
        if a1 < 1 and a2 < 1:
            a1 = 1
            a2 = 1
            PROGDIR=str(os.getcwd())
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani/ani2')
            BILDANZAHL=len(os.listdir(ANIMDIR))
            #print(BILDANZAHL)
            L = []
            L = os.listdir(ANIMDIR)
            L.sort()
            #print(L)
            for j in range(len(L)-1):
                #print(j)
                IMAGENAME='ani2-'+str(j)+'.gif'
                IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
                #print(IMAGEPFAD)
                self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
                self.nwCanvas1.create_image(295, 220, image = self.bild1)
                self.nwCanvas1.update()
                for k in range(0, 19):
                    time.sleep(0.01)
                    self.nw.update()
            IMAGENAME='ani0.gif'
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani')
            IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
            self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
            self.nwCanvas1.create_image(295, 220, image = self.bild1)
            a1 = 0
            a2 = 0
        else:
            #print('Animation wurde bereits gestartet')
            pass

    def startAnimation3(self):
        """Funktion innerhalb des Nebenfensters, z.B. Animationsstart"""
        self.Reset()
        global a1
        global a2
        if a1 < 1 and a2 < 1:
            a1 = 1
            a2 = 1
            PROGDIR=str(os.getcwd())
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani/ani3')
            BILDANZAHL=len(os.listdir(ANIMDIR))
            #print(BILDANZAHL)
            L = []
            L = os.listdir(ANIMDIR)
            L.sort()
            #print(L)
            for j in range(len(L)-1):
                #print(j)
                IMAGENAME='ani3-'+str(j)+'.gif'
                IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
                #print(IMAGEPFAD)
                self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
                self.nwCanvas1.create_image(295, 220, image = self.bild1)
                self.nwCanvas1.update()
                for k in range(0, 19):
                    time.sleep(0.01)
                    self.nw.update()
            IMAGENAME='ani0.gif'
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani')
            IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
            self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
            self.nwCanvas1.create_image(295, 220, image = self.bild1)
            a1 = 0
            a2 = 0
        else:
            #print('Animation wurde bereits gestartet')
            pass

    def startAnimation4(self):
        """Funktion innerhalb des Nebenfensters, z.B. Animationsstart"""
        self.Reset()
        global a1
        global a2
        if a1 < 1 and a2 < 1:
            a1 = 1
            a2 = 1
            PROGDIR=str(os.getcwd())
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani/ani4')
            BILDANZAHL=len(os.listdir(ANIMDIR))
            #print(BILDANZAHL)
            L = []
            L = os.listdir(ANIMDIR)
            L.sort()
            #print(L)
            for j in range(len(L)-1):
                #print(j)
                IMAGENAME='ani4-'+str(j)+'.gif'
                IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
                #print(IMAGEPFAD)
                self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
                self.nwCanvas1.create_image(295, 220, image = self.bild1)
                self.nwCanvas1.update()
                for k in range(0, 19):
                    time.sleep(0.01)
                    self.nw.update()
            IMAGENAME='ani0.gif'
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani')
            IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
            self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
            self.nwCanvas1.create_image(295, 220, image = self.bild1)
            a1 = 0
            a2 = 0
        else:
            #print('Animation wurde bereits gestartet')
            pass

    def startAnimation5(self):
        """Funktion innerhalb des Nebenfensters, z.B. Animationsstart"""
        self.Reset()
        global a1
        global a2
        if a1 < 1 and a2 < 1:
            a1 = 1
            a2 = 1
            PROGDIR=str(os.getcwd())
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani/ani5')
            BILDANZAHL=len(os.listdir(ANIMDIR))
            #print(BILDANZAHL)
            L = []
            L = os.listdir(ANIMDIR)
            L.sort()
            #print(L)
            for j in range(len(L)-1):
                #print(j)
                IMAGENAME='ani5-'+str(j)+'.gif'
                IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
                #print(IMAGEPFAD)
                self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
                self.nwCanvas1.create_image(295, 220, image = self.bild1)
                self.nwCanvas1.update()
                for k in range(0, 19):
                    time.sleep(0.01)
                    self.nw.update()
            IMAGENAME='ani0.gif'
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani')
            IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
            self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
            self.nwCanvas1.create_image(295, 220, image = self.bild1)
            a1 = 0
            a2 = 0
        else:
            #print('Animation wurde bereits gestartet')
            pass

    def startAnimation6(self):
        """Funktion innerhalb des Nebenfensters, z.B. Animationsstart"""
        self.Reset()
        global a1
        global a2
        if a1 < 1 and a2 < 1:
            a1 = 1
            a2 = 1
            PROGDIR=str(os.getcwd())
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani/ani6')
            BILDANZAHL=len(os.listdir(ANIMDIR))
            #print(BILDANZAHL)
            L = []
            L = os.listdir(ANIMDIR)
            L.sort()
            #print(L)
            for j in range(len(L)-1):
                #print(j
                IMAGENAME='ani6-'+str(j)+'.gif'
                IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
                #print(IMAGEPFAD)
                self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
                self.nwCanvas1.create_image(295, 220, image = self.bild1)
                self.nwCanvas1.update()
                for k in range(0, 19):
                    time.sleep(0.01)
                    self.nw.update()
            IMAGENAME='ani0.gif'
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani')
            IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
            self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
            self.nwCanvas1.create_image(295, 220, image = self.bild1)
            a1 = 0
            a2 = 0
        else:
            #print('Animation wurde bereits gestartet')
            pass
            
    def startAnimation7(self):
        """Funktion innerhalb des Nebenfensters, z.B. Animationsstart"""
        self.Reset()
        global a1
        global a2
        if a1 < 1 and a2 < 1:
            a1 = 1
            a2 = 1
            PROGDIR=str(os.getcwd())
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani/ani7')
            BILDANZAHL=len(os.listdir(ANIMDIR))
            #print(BILDANZAHL)
            L = []
            L = os.listdir(ANIMDIR)
            L.sort()
            #print(L)
            for j in range(len(L)-1):
                #print(j
                IMAGENAME='ani7-'+str(j)+'.gif'
                IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
                #print(IMAGEPFAD)
                self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
                self.nwCanvas1.create_image(295, 220, image = self.bild1)
                self.nwCanvas1.update()
                for k in range(0, 19):
                    time.sleep(0.01)
                    self.nw.update()
            IMAGENAME='ani0.gif'
            ANIMDIR=os.path.join(PROGDIR, 'daten/ani')
            IMAGEPFAD=os.path.join(ANIMDIR, IMAGENAME)
            self.bild1 = tkinter.PhotoImage(file = IMAGEPFAD)
            self.nwCanvas1.create_image(295, 220, image = self.bild1)
            a1 = 0
            a2 = 0
        else:
            #print('Animation wurde bereits gestartet')
            pass


    def nebenFensterSchliessen(self):
        """Funktion Nebenfenster Schliessen"""
        global i
        i = 0
        global a1
        global a2
        a1 = 0
        a2 = 0
        #print('i nach Schliessen des neuen Fensters =',i)
        #print('Nebenfenster Schliessen')
        self.nw.destroy()

###############################################################################################################################

if __name__ == '__main__':
   app = Main()


