#!/usr/bin/python3
# -*- coding: utf-8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *
from tkinter import messagebox
from tkinter import font
import codecs
import math

##############################################################################################
AvogadroKonstante=float(6.023)*10**23  #6.023e+23
MolaresNormvolumen=float(22.41)
##############################################################################################
class Fenster:
    def __init__(self, master):
        frame = Frame(master)
        frame.pack()
        self.frame = Frame(frame)
        self.frame.pack()
        self.fonts = {'Ueberschrift':('Helvetica', 12, 'bold'),
                      'Unterueberschrift':('Helvetica', 11, 'bold'),
                      'Beschriftung' : ('Helvetica', 12),
                      'Zahlen' :('Courier New', 12)
                      }
        self.l1 = Label(self.frame, text='Gesucht:', font = self.fonts['Ueberschrift'])
        self.l1.grid(row=0, column=0, columnspan=12)
        global cGesucht
        cGesucht=StringVar()
        self.r1 = Radiobutton(self.frame, text='Volumen \n(eines Gases)', variable=cGesucht, command=self.AuswahlGesucht, value='Volumen', font = self.fonts['Beschriftung'])
        self.r1.select()
        self.r1.grid(row=1, column=1, columnspan=2, sticky=W)
        self.r2 = Radiobutton(self.frame, text='Masse', variable=cGesucht, command=self.AuswahlGesucht, value='Masse', font = self.fonts['Beschriftung'])
        self.r2.grid(row=1, column=3, columnspan=2, sticky=W)
        self.r3 = Radiobutton(self.frame, text='Teilchenzahl', variable=cGesucht, command=self.AuswahlGesucht, value='Teilchenzahl', font = self.fonts['Beschriftung'])
        self.r3.grid(row=1, column=5, columnspan=2, sticky=W)
        self.r4 = Radiobutton(self.frame, text='Stoffmenge', variable=cGesucht, command=self.AuswahlGesucht, value='Stoffmenge', font = self.fonts['Beschriftung'])
        self.r4.grid(row=1, column=7, columnspan=2, sticky=W)

        self.l2 = Label(self.frame, text='Gegeben:', font = self.fonts['Ueberschrift'])
        self.l2.grid(row=2, column=0, columnspan=12)

        self.lGr1 = Label(self.frame, text=u'Gr\u00F6\u00DFe (Symbol)', font = self.fonts['Unterueberschrift'])
        self.lGr1.grid(row=3, column=1, columnspan=2, sticky=W)
        self.lGr2 = Label(self.frame, text='Zahlenwert', font = self.fonts['Unterueberschrift'])
        self.lGr2.grid(row=3, column=5, columnspan=2, sticky=W)
        self.lGr3 = Label(self.frame, text='Einheit', font = self.fonts['Unterueberschrift'], fg='dark grey')
        self.lGr3.grid(row=3, column=7, columnspan=2, sticky=W)

        self.l3a = Label(self.frame, text='Stoffmenge (n):', font = self.fonts['Beschriftung'])
        self.l3a.grid(row=4, column=1, columnspan=4, sticky=W)
        self.e1 = Entry(self.frame, background = '#ffffff', width=12, font = self.fonts['Zahlen'])
        self.e1.grid(row=4, column=5, columnspan=2, sticky=W)
        self.l3b = Label(self.frame, text='Mol', font = self.fonts['Beschriftung'], fg='dark grey')
        self.l3b.grid(row=4, column=7, columnspan=2, sticky=W)

        self.l4a = Label(self.frame, text='Molare Masse (M):', font = self.fonts['Beschriftung'])
        self.l4a.grid(row=5, column=1, columnspan=4, sticky=W)
        self.e2 = Entry(self.frame, background = '#ffffff', width=12, font = self.fonts['Zahlen'])
        self.e2.config(state=DISABLED)
        self.e2.grid(row=5, column=5, columnspan=2, sticky=W)
        self.l4b = Label(self.frame, text='Gramm pro Mol', font = self.fonts['Beschriftung'], fg='dark grey')
        self.l4b.grid(row=5, column=7, columnspan=2, sticky=W)

        global cStGesucht
        cStGesucht=StringVar()
        cStGesucht.set('')
        self.r5 = Radiobutton(self.frame, text='', variable=cStGesucht, command=self.AuswahlStGesucht, value='StMasse', font = self.fonts['Beschriftung'])
        self.r5.config(state=DISABLED)
        self.r5.grid(row=6, column=0, sticky=W)
        self.l5a = Label(self.frame, text='Masse (m):', font = self.fonts['Beschriftung'])
        self.l5a.grid(row=6, column=1, columnspan=4, sticky=W)
        self.e3 = Entry(self.frame, background = '#ffffff', width=12, font = self.fonts['Zahlen'])
        self.e3.config(state=DISABLED)
        self.e3.grid(row=6, column=5, columnspan=2, sticky=W)
        self.l5b = Label(self.frame, text='Gramm', font = self.fonts['Beschriftung'], fg='dark grey')
        self.l5b.grid(row=6, column=7, columnspan=2, sticky=W)

        self.r6 = Radiobutton(self.frame, text='', variable=cStGesucht, command=self.AuswahlStGesucht, value='StVolumen', font = self.fonts['Beschriftung'])
        self.r6.config(state=DISABLED)
        self.r6.grid(row=7, column=0, sticky=W)
        self.l6a = Label(self.frame, text='Volumen (V) \n(eines Gases):', font = self.fonts['Beschriftung'])
        self.l6a.grid(row=7, column=1, columnspan=4, sticky=W)
        self.e4 = Entry(self.frame, background = '#ffffff', width=12, font = self.fonts['Zahlen'])
        self.e4.config(state=DISABLED)
        self.e4.grid(row=7, column=5, columnspan=2, sticky=W)
        self.l6b = Label(self.frame, text='Liter', font = self.fonts['Beschriftung'], fg='dark grey')
        self.l6b.grid(row=7, column=7, columnspan=2, sticky=W)

        self.r7 = Radiobutton(self.frame, text='', variable=cStGesucht, command=self.AuswahlStGesucht, value='StTeilchenzahl', font = self.fonts['Beschriftung'])
        self.r7.config(state=DISABLED)
        self.r7.grid(row=8, column=0, sticky=W)
        self.l7a = Label(self.frame, text='Teilchenzahl (N):', font = self.fonts['Beschriftung'])
        self.l7a.grid(row=8, column=1, columnspan=4, sticky=W)
        self.e5 = Entry(self.frame, background = '#ffffff', width=12, font = self.fonts['Zahlen'])
        self.e5.config(state=DISABLED)
        self.e5.grid(row=8, column=5, columnspan=2, sticky=W)
        self.l7b = Label(self.frame, text=u'mal 10 hoch', font = self.fonts['Beschriftung'])
        self.l7b.grid(row=8, column=7, columnspan=2, sticky=W)
        self.e6 = Entry(self.frame, background = '#ffffff', width=6, font = self.fonts['Zahlen'])
        self.e6.config(state=DISABLED)
        self.e6.grid(row=8, column=9, columnspan=2, sticky=W)

        self.l8 = Label(self.frame, text=u'L\u00F6sung:', font = self.fonts['Ueberschrift'])
        self.l8.grid(row=9, column=0, columnspan=12)
        self.t1 = Text(self.frame, background = '#ffffff', height = '2', width = '40', wrap = WORD, font = self.fonts['Zahlen'])
        self.t1.grid(row=9, column=0, columnspan=12, sticky=EW)
        self.b1 = Button(self.frame, text='Hilfe', command=self.HilfeAnzeigen)
        self.b1.grid(row=10, column=1, columnspan=3, sticky=E+W+S+W)
        self.b2 = Button(self.frame, text='Berechnen', command=self.Berechnen)
        self.b2.grid(row=10, column=4, columnspan=3, sticky=E+W+S+W)
        self.b3 = Button(self.frame, text='Beenden', command=frame.quit)
        self.b3.grid(row=10, column=7, columnspan=3, sticky=N+E+W+S) 
        self.r1.invoke()

##############################################################################################

    def AuswahlGesucht(self):
        global Auswahl
        Auswahl=str(cGesucht.get())
        if Auswahl == 'Volumen':
            cStGesucht.set('')
            StAuswahl=str(cStGesucht.get())
            self.e1.config(state=NORMAL)
            self.e1.delete(0, END)
            self.e2.config(state=NORMAL)
            self.e2.delete(0, END)
            self.e2.config(state=DISABLED)
            self.e3.config(state=NORMAL)
            self.e3.delete(0, END)
            self.e3.config(state=DISABLED)
            self.e4.config(state=NORMAL)
            self.e4.delete(0, END)
            self.e4.config(state=DISABLED)
            self.e5.config(state=NORMAL)
            self.e5.delete(0, END)
            self.e5.config(state=DISABLED)
            self.e6.config(state=NORMAL)
            self.e6.delete(0, END)
            self.e6.config(state=DISABLED)
            self.r5.deselect()
            self.r5.config(state=DISABLED)
            self.r6.deselect()
            self.r6.config(state=DISABLED)
            self.r7.deselect()
            self.r7.config(state=DISABLED)
            self.t1.delete(1.0, END)
        if Auswahl == 'Masse':
            cStGesucht.set('')
            StAuswahl=str(cStGesucht.get())
            self.e1.config(state=NORMAL)
            self.e1.delete(0, END)
            self.e2.config(state=NORMAL)
            self.e2.delete(0, END)
            self.e3.config(state=NORMAL)
            self.e3.delete(0, END)
            self.e3.config(state=DISABLED)
            self.e4.config(state=NORMAL)
            self.e4.delete(0, END)
            self.e4.config(state=DISABLED)
            self.e5.config(state=NORMAL)
            self.e5.delete(0, END)
            self.e5.config(state=DISABLED)
            self.e6.config(state=NORMAL)
            self.e6.delete(0, END)
            self.e6.config(state=DISABLED)
            self.r5.deselect()
            self.r5.config(state=DISABLED)
            self.r6.deselect()
            self.r6.config(state=DISABLED)
            self.r7.deselect()
            self.r7.config(state=DISABLED)
            self.t1.delete(1.0, END)
        if Auswahl == 'Teilchenzahl':
            cStGesucht.set('')
            StAuswahl=str(cStGesucht.get())
            self.e1.config(state=NORMAL)
            self.e1.delete(0, END)
            self.e2.config(state=NORMAL)
            self.e2.delete(0, END)
            self.e2.config(state=DISABLED)
            self.e3.config(state=NORMAL)
            self.e3.delete(0, END)
            self.e3.config(state=DISABLED)
            self.e4.config(state=NORMAL)
            self.e4.delete(0, END)
            self.e4.config(state=DISABLED)
            self.e5.config(state=NORMAL)
            self.e5.delete(0, END)
            self.e5.config(state=DISABLED)
            self.e6.config(state=NORMAL)
            self.e6.delete(0, END)
            self.e6.config(state=DISABLED)
            self.r5.deselect()
            self.r5.config(state=DISABLED)
            self.r6.deselect()
            self.r6.config(state=DISABLED)
            self.r7.deselect()
            self.r7.config(state=DISABLED)
            self.t1.delete(1.0, END)
        if Auswahl == 'Stoffmenge':
            cStGesucht.set('')
            StAuswahl=str(cStGesucht.get())
            self.e1.config(state=NORMAL)
            self.e1.delete(0, END)
            self.e1.config(state=DISABLED)
            self.e2.config(state=NORMAL)
            self.e2.delete(0, END)
            self.e3.config(state=NORMAL)
            self.e3.delete(0, END)
            self.e4.config(state=NORMAL)
            self.e4.delete(0, END)
            self.e4.config(state=DISABLED)
            self.e5.config(state=NORMAL)
            self.e5.delete(0, END)
            self.e5.config(state=DISABLED)
            self.e6.config(state=NORMAL)
            self.e6.delete(0, END)
            self.e6.config(state=DISABLED)
            self.r5.config(state=NORMAL)
            self.r5.select()
            self.r5.invoke()
            self.r6.config(state=NORMAL)
            self.r7.config(state=NORMAL)
            self.t1.delete(1.0, END)
            
    def AuswahlStGesucht(self):
            global StAuswahl
            StAuswahl=str(cStGesucht.get())
            if StAuswahl == 'StMasse':
                self.e1.config(state=NORMAL)
                self.e1.delete(0, END)
                self.e1.config(state=DISABLED)
                self.e2.config(state=NORMAL)
                self.e2.delete(0, END)
                self.e3.config(state=NORMAL)
                self.e3.delete(0, END)
                self.e4.config(state=NORMAL)
                self.e4.delete(0, END)
                self.e4.config(state=DISABLED)
                self.e6.config(state=NORMAL)
                self.e6.delete(0, END)
                self.e6.config(state=DISABLED)
                self.e5.config(state=NORMAL)
                self.e5.delete(0, END)
                self.e5.config(state=DISABLED)
                self.e6.config(state=NORMAL)
                self.e6.delete(0, END)
                self.e6.config(state=DISABLED)
                self.t1.delete(1.0, END)
            if StAuswahl == 'StVolumen':
                self.e1.config(state=NORMAL)
                self.e1.delete(0, END)
                self.e1.config(state=DISABLED)
                self.e2.config(state=NORMAL)
                self.e2.delete(0, END)
                self.e2.config(state=DISABLED)
                self.e3.config(state=NORMAL)
                self.e3.delete(0, END)
                self.e3.config(state=DISABLED)
                self.e4.config(state=NORMAL)
                self.e4.delete(0, END)
                self.e4.insert(0, '22.41')
                self.e5.config(state=NORMAL)
                self.e5.delete(0, END)
                self.e5.config(state=DISABLED)
                self.e6.config(state=NORMAL)
                self.e6.delete(0, END)
                self.e6.config(state=DISABLED)
                self.t1.delete(1.0, END)
            if StAuswahl == 'StTeilchenzahl':
                self.e1.config(state=NORMAL)
                self.e1.delete(0, END)
                self.e1.config(state=DISABLED)
                self.e2.config(state=NORMAL)
                self.e2.delete(0, END)
                self.e2.config(state=DISABLED)
                self.e3.config(state=NORMAL)
                self.e3.delete(0, END)
                self.e3.config(state=DISABLED)
                self.e4.config(state=NORMAL)
                self.e4.delete(0, END)
                self.e4.config(state=DISABLED)
                self.e5.config(state=NORMAL)
                self.e5.delete(0, END)
                self.e5.insert(0, '6.023')
                self.e6.config(state=NORMAL)
                self.e6.delete(0, END)
                self.e6.insert(0, '23')
                self.t1.delete(1.0, END)

    def HilfeAnzeigen(self):
        messagebox.showinfo(title = 'Kurzhilfe', message = u'Alle messbaren Gr\u00F6\u00DFen sind zur Stoffmenge proportional!\nDie Stoffmenge ist also proportional zum Volumen, zur Masse und zur Teilchenzahl.\nDie jeweiligen Proportionalit\u00E4tsfaktoren sind \nim Falle des Volumens der Kehrwert des Molaren Normvolumens 1/Vm, \nim Falle der Masse der Kehrwert der Molaren Masse 1/M und\nim Falle der Teilchenzahl der Kehrwert der Avogadro Konstante 1/NA.\nDie Reaktionsenergie \u0394H (vereinfacht f\u00FCr Reaktionsenthalpie)\nwurde hier weggelassen.\nAber auch hier gilt der Proportionalit\u00E4tsfaktor des Kehrwerts der Molaren Reaktionsenthalpie 1/\u0394Hm.')

    def Berechnen(self):
        Auswahl=str(cGesucht.get())
        StAuswahl=str(cStGesucht.get())
        if Auswahl == 'Volumen' and StAuswahl == '':
            #print 'Fall 1: Volumenberechnung'
            n=str(self.e1.get())
            #print 'Stoffmenge n =',n
            try:
                V=float(n)*MolaresNormvolumen
                V = '%.2f' % (V,)
                #print V
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT, '%s %s %s' % (u'Das gesuchte Volumen betr\u00E4gt',V,'Liter.'))
            except:
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'Gib zuerst die Stoffmenge in der Form 1.00 an!')

        if Auswahl == 'Masse' and StAuswahl == '':
            #print 'Fall 2: Massenberechnung'
            n=str(self.e1.get())
            M=str(self.e2.get())
            #print 'Stoffmenge n =',n,'\nMolare Masse M =',M
            try:
                m=float(n)*float(M)
                m = '%.2f' % (m,)
                #print m
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'%s %s %s' % (u'Die gesuchte Masse betr\u00E4gt',m,'Gramm.'))
            except:
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'Gib zuerst die Stoffmenge und die Molare Masse in der Form 1.00  an!')

        if Auswahl == 'Teilchenzahl' and StAuswahl == '':
            #print 'Fall 3: Teilchenzahlberechnung'
            n=str(self.e1.get())
            #print 'Stoffmenge n =',n
            try:
                N=float(n)*AvogadroKonstante
                N = long(N)
                #print N
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT, '%s %s %s' % (u'Die gesuchte Teilchenzahl betr\u00E4gt',N,'.'))
            except:
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'Gib zuerst die Stoffmenge in der Form 1.00 an!')

        if Auswahl == 'Stoffmenge' and StAuswahl == 'StMasse':
            #print 'Fall 4: Stoffmengenberechnung aus der Masse und der Molaren Massse'
            M=str(self.e2.get())
            m=str(self.e3.get())
            try:
                n=float(m)/float(M)
                n = '%.2f' % (n,)
                #print n
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'%s %s %s' % (u'Die gesuchte Stoffmenge betr\u00E4gt',n,'Mol.'))
            except:
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'Gib zuerst die Molare Masse und die Masse in der Form 1.00  an!')

        if Auswahl == 'Stoffmenge' and StAuswahl == 'StVolumen':
            #print 'Fall 5: Stoffmengenberechnung aus dem Volumen'
            V=str(self.e4.get())
            try:
                n=float(V)/MolaresNormvolumen
                n = '%.2f' % (n,)
                #print n
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'%s %s %s' % (u'Die gesuchte Stoffmenge betr\u00E4gt',n,'Mol.'))
            except:
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'Gib zuerst das Volumen in der Form 1.00  an!')

        if Auswahl == 'Stoffmenge' and StAuswahl == 'StTeilchenzahl':
            #print 'Fall 6: Stoffmengenberechnung aus der Teilchenzahl' 
            ZAHL1=str(self.e5.get())
            EXPONENT2=str(self.e6.get())     
            try:
                N=float(ZAHL1)*(10**float(EXPONENT2))
                n=float(N)/AvogadroKonstante
                n = '%.2f' % (n,)
                #print n
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'%s %s %s' % (u'Die gesuchte Stoffmenge betr\u00E4gt',n,'Mol.'))
            except:
                self.t1.delete(1.0, END)
                self.t1.insert(INSERT,'Gib zuerst die Teilchenzahl in der Form "Gleitkommazahl mit Punkt als Trenner" mal 10 hoch "Exponent"  an!')
 
##############################################################################################
root = Tk()
root.title('Molrechner')
app = Fenster(root)
root.mainloop()
