#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
#import tkFont
# Textdatei
import sys
sys.path.insert(0, 'daten')
from textdaten import teilschritte_text
import webbrowser

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4)
        self.frame2=Frame(frame, pady=4, padx=8)
        self.frame3=Frame(frame, pady=4)
        self.frame4=Frame(frame, pady=4, padx=8)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 6, E+W),
                (self.frame2, 1, 0, 1, W),
                (self.frame3, 1, 1, 5, W),
                (self.frame4, 2, 0, 6, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 1: Auswahl des Reaktionsmechanismus und der Ausgangsstoffe
        # Auswahl 1: Radikalisch,  elektrophil oder nucleophil
        global a1
        a1 = StringVar()
        a1.set('X')
        self.a1r1=Radiobutton(self.frame1, 
                             text='Radikalische',
                             variable=a1, 
                             value='ra',
                             indicatoron=0, 
                             command=self.a1_festlegen)
        self.a1l1=Label(self.frame1, 
                             text='Ionische')
        self.a1r2=Radiobutton(self.frame1, 
                             text='Elektrophile',
                             variable=a1, 
                             value='el',
                             indicatoron=0, 
                             command=self.a1_festlegen)
        self.a1r3=Radiobutton(self.frame1, 
                             text='Nucleophile',
                             variable=a1, 
                             value='nu',
                             indicatoron=0, 
                             command=self.a1_festlegen)
        # Auswahl 2: Substitution oder Addition
        global a2
        a2 = StringVar()
        a2.set('X')
        self.a2r1=Radiobutton(self.frame1, 
                             text='Substitution',
                             variable=a2, 
                             value='rad_sub',
                             indicatoron=0, 
                             command=self.a2_festlegen)
        self.a2r2=Radiobutton(self.frame1, 
                             text='Addition',
                             variable=a2, 
                             value='el_add',
                             indicatoron=0, 
                             command=self.a2_festlegen)
        self.a2r3=Radiobutton(self.frame1, 
                             text='Substitution',
                             variable=a2, 
                             value='el_sub',
                             indicatoron=0, 
                             command=self.a2_festlegen)
        self.a2r4=Radiobutton(self.frame1, 
                             text='Addition',
                             variable=a2, 
                             value='nu_add',
                             indicatoron=0, 
                             command=self.a2_festlegen)
        self.a2r5=Radiobutton(self.frame1, 
                             text='Substitution',
                             variable=a2, 
                             value='nu_sub',
                             indicatoron=0, 
                             command=self.a2_festlegen)
        # Auswahl 3: Ausgangsstoffe
        global a3
        a3 = StringVar()
        a3.set('X')
        # Radikalische Substitution
        self.a3r1=Radiobutton(self.frame1, 
                             text='Methan und Brom',
                             variable=a3, 
                             value='1_methan_und_brom',
                             justify=LEFT,
                             anchor=W,
                             command=self.a3_festlegen)
        # Elektrophile Addition
        self.a3r2=Radiobutton(self.frame1, 
                             text='Ethen und Brom\n([Di-]Halogenierung)',
                             variable=a3, 
                             value='2_ethen_und_brom',
                             justify=LEFT,
                             anchor=W, 
                             command=self.a3_festlegen)
        self.a3r3=Radiobutton(self.frame1,
                              text='Ethen und Bromwasserstoff\n([Mono-]Halogenierung)',
                              variable=a3, 
                              value='3_ethen_und_bromwasserstoff',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        self.a3r4=Radiobutton(self.frame1, 
                             text='Ethen und Wasser \n(säurekatalysierte Hydratiserierung zum Alkohol)',
                             variable=a3, 
                             value='4_ethen_und_wasser',
                             justify=LEFT,
                             anchor=W,
                             command=self.a3_festlegen)
        self.a3r5=Radiobutton(self.frame1,
                              text='Ethen und Ethen \n(säurekatalysierte kationische Polymerisation)',
                              variable=a3, 
                              value='5_ethen_und_ethen',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        self.a3r5b=Radiobutton(self.frame1,
                              text='Ethin und Chlor \n([Di-]Halogenierung)',
                              variable=a3, 
                              value='6_ethin_und_chlor',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        # Elektrophile Substitution
        self.a3r6=Radiobutton(self.frame1,
                              text='Benzol und Brom \n(Eisen(III)-bromid katalysiert)',
                              variable=a3, 
                              value='7_benzol_und_brom',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        self.a3r7=Radiobutton(self.frame1,
                              text='Benzol und Nitroniumion \n(säurekatalysierte Nitrierung)',
                              variable=a3, 
                              value='8_benzol_und_nitroniumion',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        self.a3r8=Radiobutton(self.frame1,
                              text='Benzol und Schwefeltrioxid \n(säurekatalysierte Sulfonierung)',
                              variable=a3, 
                              value='9_benzol_und_schwefeltrioxid',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        self.a3r9=Radiobutton(self.frame1,
                              text='Benzol und Carbeniumion \n(Aluminiumchlorid katalysierte Alkylierung)',
                              variable=a3, 
                              value='10_benzol_und_carbeniumion',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        # Nucleophile Addition
        self.a3r10=Radiobutton(self.frame1,
                              text='Ethanal und Methanol\n(säurekatalysierte Halbacetalbildung)',
                              variable=a3, 
                              value='11_ethanal_und_methanol',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        # Nucleophile Substitution
        self.a3r11=Radiobutton(self.frame1,
                              text='Ethansäure und Methanol\n(säurekatalysierte Veresterung)',
                              variable=a3, 
                              value='12_ethansaeure_und_methanol',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        self.a3r12=Radiobutton(self.frame1,
                              text='Ethansäure und Ammoniak\n(säurekatalysierte Säureamidbildung)',
                              variable=a3, 
                              value='13_ethansaeure_und_ammoniak',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        self.a3r13=Radiobutton(self.frame1,
                              text='Ethansäureethylester und Hydroxidionen\n(basenvermittelte Esterspaltung)',
                              variable=a3, 
                              value='14_ethansaeureethylester_und_hydroxidion',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        self.a3r14=Radiobutton(self.frame1,
                              text='Halbacetal und Methanol\n(säurekatalysierte Vollacetalbildung)',
                              variable=a3, 
                              value='15_halbacetal_und_methanol',
                              justify=LEFT,
                              anchor=W,
                              command=self.a3_festlegen)
        for i in (self.a2r1,    self.a2r2,  self.a2r3,  self.a2r4,  self.a2r5,
                  self.a3r1,    self.a3r2,  self.a3r3,  self.a3r4,  self.a3r5,
                  self.a3r5b,
                  self.a3r6,    self.a3r7,  self.a3r8,  self.a3r9,  self.a3r10,
                  self.a3r11,   self.a3r12, self.a3r13, self.a3r14):
            i.config(state=DISABLED)
        for i, row, column, columnspan, rowspan, sticky in (
                # a1
                (self.a1r1,     0, 0, 1, 2, E+W+S+N), 
                (self.a1l1,     0, 1, 4, 1, E+W),
                (self.a1r2,     1, 1, 2, 1, E+W), 
                (self.a1r3,     1, 3, 2, 1, E+W),
                # a2
                (self.a2r1,     2, 0, 1, 1, E+W),
                (self.a2r2,     2, 1, 1, 1, E+W),
                (self.a2r3,     2, 2, 1, 1, E+W),
                (self.a2r4,     2, 3, 1, 1, E+W),
                (self.a2r5,     2, 4, 1, 1, E+W),
                # a3
                # rad_sub
                (self.a3r1,     3, 0, 1, 1, E+W),
                # el_ad
                (self.a3r2,     3, 1, 1, 1, E+W),
                (self.a3r3,     4, 1, 1, 1, E+W),
                (self.a3r4,     5, 1, 1, 1, E+W),
                (self.a3r5,     6, 1, 1, 1, E+W),
                (self.a3r5b,    7, 1, 1, 1, E+W),
                # el_sub
                (self.a3r6,     3, 2, 1, 1, E+W),
                (self.a3r7,     4, 2, 1, 1, E+W),
                (self.a3r8,     5, 2, 1, 1, E+W),
                (self.a3r9,     6, 2, 1, 1, E+W),
                # nu_add
                (self.a3r10,    3, 3, 1, 1, E+W),
                # nu_sub
                (self.a3r11,    3, 4, 1, 1, E+W),
                (self.a3r12,    4, 4, 1, 1, E+W),
                (self.a3r13,    5, 4, 1, 1, E+W),
                (self.a3r14,    6, 4, 1, 1, E+W)):
            i.grid(row=row, column=column, columnspan=columnspan, 
                   rowspan=rowspan, sticky=sticky)
                   
        # Rahmen 2: Reaktionsschritte je nach gewähltem Mechanismus
        self.frame5=Frame(self.frame2, pady=8, padx=8, bd=2, relief=RIDGE)
        self.frame6=Frame(self.frame2, pady=8, padx=8, bd=2, relief=RIDGE)
        self.frame7=Frame(self.frame2, pady=8, padx=8)
        self.f2l1=Label(self.frame2,
                        anchor=NW,
                        text='Teilschritte:')
        for i, row, column, sticky in (
                (self.frame5, 1, 0, E+W), 
                (self.frame6, 2, 0, E+W),
                (self.frame7, 3, 0, E+W)):
            i.grid(row=row, column=column, sticky=sticky, ipady=4, ipadx=8)
        global a4
        a4 = StringVar()
        a4.set('X')
        # Radikalische Substitution
        self.f2a4r1=Radiobutton(self.frame5, 
                               text='1. Startreaktion',
                               variable=a4, 
                               value='1_startreaktion',
                               justify=LEFT,
                               anchor=W,
                               command=self.a4_festlegen)
        self.f2a4r2=Radiobutton(self.frame5, 
                               text='2. Kettenreaktion',
                               variable=a4, 
                               value='2_kettenreaktion',
                               justify=LEFT,
                               anchor=W,
                               command=self.a4_festlegen)
        self.f2a4r3=Radiobutton(self.frame5, 
                               text='3. Abbruchreaktion',
                               variable=a4, 
                               value='3_abbruchreaktion',
                               justify=LEFT,
                               anchor=W,
                               command=self.a4_festlegen)
        # Ionische Mechanismen
        self.f2a4r4=Radiobutton(self.frame6, 
                                text='1. Aktivierung des Elektrophils',
                                variable=a4, 
                                value='1_aktivierung_des_elektrophils',
                                justify=LEFT,
                                anchor=W,
                                command=self.a4_festlegen)
        self.f2a4r5=Radiobutton(self.frame6, 
                                text='2. Angriff des Nucleophils am Elektrophil',
                                variable=a4, 
                                value='2_angriff_des_nu_am_el',
                                justify=LEFT,
                                anchor=W,
                                command=self.a4_festlegen)
        self.f2a4r6=Radiobutton(self.frame6, 
                                text='3. Metastabiles Zwischenprodukt',
                                variable=a4, 
                                value='3_metastabiles_zwischenprodukt',
                                justify=LEFT,
                                anchor=W,
                                command=self.a4_festlegen)
        self.f2a4r7=Radiobutton(self.frame6, 
                                text='4. Additionsschritt',
                                variable=a4, 
                                value='4_additionsschritt',
                                justify=LEFT,
                                anchor=W,
                                command=self.a4_festlegen)
        self.f2a4r8=Radiobutton(self.frame6, 
                                text='4. Eliminierungsschritt',
                                variable=a4, 
                                value='4_eliminierungsschritt',
                                justify=LEFT,
                                anchor=W,
                                command=self.a4_festlegen)
        global a5
        a5 = StringVar()
        a5.set('X')
        # Radikalische Substitution
        self.f7a5r1=Radiobutton(self.frame7, 
                               text='Säurekatalyse mit Oxoniumionen',
                               variable=a5, 
                               value='mit_oxoniumion',
                               justify=LEFT,
                               anchor=W,
                               command=self.a5_festlegen)
        self.f7a5r2=Radiobutton(self.frame7, 
                               text='Säurekatalyse nur mit Protonen',
                               variable=a5, 
                               value='mit_proton',
                               justify=LEFT,
                               anchor=W,
                               command=self.a5_festlegen)
        self.banim=Button(self.frame7, 
                          text='Als Animation zeigen', 
                          command=self.zeige_anim)
        for i in (self.f2a4r1,    self.f2a4r2,  self.f2a4r3,  self.f2a4r4,  
                  self.f2a4r5,    self.f2a4r6,  self.f2a4r7,  self.f2a4r8,
                  self.f7a5r1,    self.f7a5r2,  self.banim):
            i.config(state=DISABLED)
        for i, row, column, columnspan, rowspan, sticky in (
                # a4
                (self.f2a4r1,     0, 0, 1, 1, E+W), 
                (self.f2a4r2,     1, 0, 1, 1, E+W),
                (self.f2a4r3,     2, 0, 1, 1, E+W), 
                (self.f2a4r4,     3, 0, 1, 1, E+W),
                (self.f2a4r5,     4, 0, 1, 1, E+W),
                (self.f2a4r6,     5, 0, 1, 1, E+W),
                (self.f2a4r7,     6, 0, 1, 1, E+W),
                (self.f2a4r8,     7, 0, 1, 1, E+W),
                (self.f7a5r1,     1, 0, 1, 1, E+W),
                (self.f7a5r2,     0, 0, 1, 1, E+W),
                (self.banim,      2, 0, 1, 1, E+W)):
            i.grid(row=row, column=column, columnspan=columnspan, 
                   rowspan=rowspan, sticky=sticky)
        
        # Rahmen 3: Anzeigefeld für den Teilschritt des Mechanismus
        self.canvas1=Canvas(self.frame3, 
                            width=560, 
                            height=400, 
                            bg='white')
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        self.text1=Text(self.frame3, 
                        background='white', 
                        #disabledbackground='white',
                        #disabledforeground='black',
                        height='22', 
                        width='40', 
                        wrap=WORD,
                        state=DISABLED,
                        font=('arial', '11'))
        self.scale1=Scale(self.frame3, 
                          length=560,
                          from_=1, 
                          to=3,
                          resolution=1,
                          showvalue=1,
                          orient=HORIZONTAL,
                          command=self.zwischenschritt_holen,
                          state=DISABLED,
                          label='Bild Nr.:')
        for i, row, column, columnspan, sticky in (
                (self.canvas1, 0, 0, 2, E+W), 
                (self.text1,   0, 2, 1, E+W),
                (self.scale1,  1, 0, 2, E+W)):
            i.grid(row=row, column=column, sticky=sticky, pady=2, padx=2)
        
        # Rahmen 4: Beenden und Zurücksetzen
        self.f4b1=Button(self.frame4,
                         text='Zurücksetzen',
                         command=self.zurueck_setzen)
        self.f4b2=Button(self.frame4, 
                         text='Beenden',
                         command=root.destroy)
        for i, row, column, columnspan, sticky in (
                (self.f4b1, 0, 0, 1, E+W),
                (self.f4b2, 0, 1, 1, E+W)):
            i.grid(row=row, column=column, sticky=sticky)
                  
    ############################################################################
    
    def zeige_anim(self):
        self.animdir='daten/anim'
        self.ausgangsstoffe=str(a3.get())
        self.teilschritt=str(a4.get())
        self.katalysetyp=str(a5.get())
        if self.katalysetyp == 'X':
            self.animurl='file://'+os.getcwd()+os.sep+self.animdir+os.sep+self.ausgangsstoffe+'.gif'
        elif self.katalysetyp == 'mit_oxoniumion' or self.katalysetyp == 'mit_proton':
            self.animurl='file://'+os.getcwd()+os.sep+self.animdir+os.sep+self.ausgangsstoffe+'_'+self.katalysetyp+'.gif'
        try:
            webbrowser.open(self.animurl)
        except:
            pass
    
    def zurueck_setzen(self):
        #print('zureck_setzen')
        self.scale1.config(state=NORMAL)
        self.scale1.set(1)
        for i in (a1, a2, a3, a4, a5):
            i.set('X')
        for i, state in (
            (self.a1r1, NORMAL),
            (self.a1r2, NORMAL),
            (self.a1r3, NORMAL),
            (self.a2r1, DISABLED),
            (self.a2r2, DISABLED),
            (self.a2r3, DISABLED),
            (self.a2r4, DISABLED),
            (self.a2r5, DISABLED),
            (self.a3r1, DISABLED),
            (self.a3r2, DISABLED),
            (self.a3r3, DISABLED),
            (self.a3r4, DISABLED),
            (self.a3r5, DISABLED),
            (self.a3r5b, DISABLED),
            (self.a3r6, DISABLED),
            (self.a3r7, DISABLED),
            (self.a3r8, DISABLED),
            (self.a3r9, DISABLED),
            (self.a3r10, DISABLED),
            (self.a3r11, DISABLED),
            (self.a3r12, DISABLED),
            (self.a3r13, DISABLED),
            (self.a3r14, DISABLED),
            (self.f2a4r1, DISABLED),
            (self.f2a4r2, DISABLED),
            (self.f2a4r3, DISABLED),
            (self.f2a4r4, DISABLED),
            (self.f2a4r5, DISABLED),
            (self.f2a4r6, DISABLED),
            (self.f2a4r7, DISABLED),
            (self.f2a4r8, DISABLED),
            (self.scale1, DISABLED),
            (self.f7a5r1, DISABLED),
            (self.f7a5r2, DISABLED),
            (self.banim, DISABLED)):
            i.config(state=state)
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        self.text1.config(state=NORMAL)
        self.text1.delete(0.0, END)
        self.text1.config(state=DISABLED)

    def a1_festlegen(self):
        #print(a1.get())
        if a1.get() == 'ra':
            for i, state in ((self.a1r1, DISABLED),
                             (self.a1r2, DISABLED),
                             (self.a1r3, DISABLED),
                             (self.a2r1, NORMAL)):
                i.config(state=state)
        elif a1.get() == 'el':
            for i, state in ((self.a1r1, DISABLED),
                             (self.a1r2, DISABLED),
                             (self.a1r3, DISABLED),
                             (self.a2r2, NORMAL),
                             (self.a2r3, NORMAL)):
                i.config(state=state)
        elif a1.get() == 'nu':
            for i, state in ((self.a1r1, DISABLED),
                             (self.a1r2, DISABLED),
                             (self.a1r3, DISABLED),
                             (self.a2r4, NORMAL),
                             (self.a2r5, NORMAL)):
                i.config(state=state)

    def a2_festlegen(self):
        #print(a2.get())
        if a2.get() == 'rad_sub':
            for i, state in ((self.a2r1, DISABLED),
                             (self.a3r1, NORMAL)):
                i.config(state=state)
                a3.set('1_methan_und_brom')
                self.a3r1.select()
                self.a3_festlegen()
        elif a2.get() == 'el_add':
            for i, state in ((self.a2r2, DISABLED),
                             (self.a2r3, DISABLED),
                             (self.a3r2, NORMAL),
                             (self.a3r3, NORMAL),
                             (self.a3r4, NORMAL),
                             (self.a3r5, NORMAL),
                             (self.a3r5b, NORMAL)
                             ):
                i.config(state=state)
        elif a2.get() == 'el_sub':
            for i, state in ((self.a2r2, DISABLED),
                             (self.a2r3, DISABLED),
                             (self.a3r6, NORMAL),
                             (self.a3r7, NORMAL),
                             (self.a3r8, NORMAL),
                             (self.a3r9, NORMAL)
                             ):
                i.config(state=state)
        elif a2.get() == 'nu_add':
            for i, state in ((self.a2r4, DISABLED),
                             (self.a2r5, DISABLED),
                             (self.a3r10, NORMAL)):
                i.config(state=state)
                a3.set('11_ethanal_und_methanol')
                self.a3r10.select()
                self.a3_festlegen()
        elif a2.get() == 'nu_sub':
            for i, state in ((self.a2r4, DISABLED),
                             (self.a2r5, DISABLED),
                             (self.a3r11, NORMAL),
                             (self.a3r12, NORMAL),
                             (self.a3r13, NORMAL),
                             (self.a3r14, NORMAL)
                             ):
                i.config(state=state)
        
    def a3_festlegen(self):
        #print(a3.get())
        if a3.get() == '1_methan_und_brom':
            for i, state in ((self.a3r1, DISABLED),
                             (self.f2a4r1, NORMAL),
                             (self.f2a4r2, NORMAL),
                             (self.f2a4r3, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)):
                i.config(state=state)
            a4.set('1_startreaktion')
            self.f2a4r1.select()
            self.a4_festlegen()
        if a3.get() == '2_ethen_und_brom':
            for i, state in ((self.a3r2, DISABLED),
                             (self.a3r3, DISABLED),
                             (self.a3r4, DISABLED),
                             (self.a3r5, DISABLED),
                             (self.a3r5b, DISABLED),
                             (self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             (self.f2a4r7, NORMAL),
                             #(self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('1_aktivierung_des_elektrophils')
            self.f2a4r4.select()
            self.a4_festlegen()
        elif a3.get() == '3_ethen_und_bromwasserstoff':
            for i, state in ((self.a3r2, DISABLED),
                             (self.a3r3, DISABLED),
                             (self.a3r4, DISABLED),
                             (self.a3r5, DISABLED),
                             (self.a3r5b, DISABLED),
                             #(self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             (self.f2a4r7, NORMAL),
                             #(self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('2_angrif_des_nu_am_el')
            self.f2a4r5.select()
            self.a4_festlegen()
        elif a3.get() == '4_ethen_und_wasser':
            for i, state in ((self.a3r2, DISABLED),
                             (self.a3r3, DISABLED),
                             (self.a3r4, DISABLED),
                             (self.a3r5, DISABLED),
                             (self.a3r5b, DISABLED),
                             #(self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             (self.f2a4r7, NORMAL),
                             #(self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.f7a5r1, NORMAL),
                             (self.f7a5r2, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('2_angrif_des_nu_am_el')
            self.f2a4r5.select()
            a5.set('mit_proton')
            self.f7a5r2.select()
            self.a4_festlegen()
            self.a5_festlegen()
        elif a3.get() == '5_ethen_und_ethen':
            for i, state in ((self.a3r2, DISABLED),
                             (self.a3r3, DISABLED),
                             (self.a3r4, DISABLED),
                             (self.a3r5, DISABLED),
                             (self.a3r5b, DISABLED),
                             #(self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             (self.f2a4r7, NORMAL),
                             #(self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.f7a5r1, NORMAL),
                             (self.f7a5r2, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('2_angrif_des_nu_am_el')
            self.f2a4r5.select()
            a5.set('mit_proton')
            self.f7a5r2.select()
            self.a4_festlegen()
            self.a5_festlegen()
        elif a3.get() == '6_ethin_und_chlor':
            for i, state in ((self.a3r2, DISABLED),
                             (self.a3r3, DISABLED),
                             (self.a3r4, DISABLED),
                             (self.a3r5, DISABLED),
                             (self.a3r5b, DISABLED),
                             (self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             (self.f2a4r7, NORMAL),
                             #(self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('1_aktivierung_des_elektrophils')
            self.f2a4r4.select()
            self.a4_festlegen()
        elif a3.get() == '7_benzol_und_brom':
            for i, state in ((self.a3r6, DISABLED),
                             (self.a3r7, DISABLED),
                             (self.a3r8, DISABLED),
                             (self.a3r9, DISABLED),
                             (self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             #(self.f2a4r7, NORMAL),
                             (self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('1_aktivierung_des_elektrophils')
            self.f2a4r4.select()
            self.a4_festlegen()
        elif a3.get() == '8_benzol_und_nitroniumion':
            for i, state in ((self.a3r6, DISABLED),
                             (self.a3r7, DISABLED),
                             (self.a3r8, DISABLED),
                             (self.a3r9, DISABLED),
                             (self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             #(self.f2a4r7, NORMAL),
                             (self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.f7a5r1, NORMAL),
                             (self.f7a5r2, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('1_aktivierung_des_elektrophils')
            self.f2a4r4.select()
            a5.set('mit_proton')
            self.f7a5r2.select()
            self.a4_festlegen()
            self.a5_festlegen()
        elif a3.get() == '9_benzol_und_schwefeltrioxid':
            for i, state in ((self.a3r6, DISABLED),
                             (self.a3r7, DISABLED),
                             (self.a3r8, DISABLED),
                             (self.a3r9, DISABLED),
                             (self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             #(self.f2a4r7, NORMAL),
                             (self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.f7a5r1, NORMAL),
                             (self.f7a5r2, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('1_aktivierung_des_elektrophils')
            self.f2a4r4.select()
            a5.set('mit_proton')
            self.f7a5r2.select()
            self.a4_festlegen()
            self.a5_festlegen()
        elif a3.get() == '10_benzol_und_carbeniumion':
            for i, state in ((self.a3r6, DISABLED),
                             (self.a3r7, DISABLED),
                             (self.a3r8, DISABLED),
                             (self.a3r9, DISABLED),
                             (self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             #(self.f2a4r7, NORMAL),
                             (self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('1_aktivierung_des_elektrophils')
            self.f2a4r4.select()
            self.a4_festlegen()
        elif a3.get() == '11_ethanal_und_methanol':
            for i, state in ((self.a3r10, DISABLED),
                             #(self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             (self.f2a4r7, NORMAL),
                             #(self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('2_angriff_des_nu_am_el')
            self.f2a4r5.select()
            self.a4_festlegen()
        elif a3.get() == '12_ethansaeure_und_methanol':
            for i, state in ((self.a3r11, DISABLED),
                             (self.a3r12, DISABLED),
                             (self.a3r13, DISABLED),
                             (self.a3r14, DISABLED),
                             (self.a3r9, DISABLED),
                             (self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             #(self.f2a4r7, NORMAL),
                             (self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('1_aktivierung_des_elektrophils')
            self.f2a4r4.select()
            self.a4_festlegen()
        elif a3.get() == '13_ethansaeure_und_ammoniak':
            for i, state in ((self.a3r11, DISABLED),
                             (self.a3r12, DISABLED),
                             (self.a3r13, DISABLED),
                             (self.a3r14, DISABLED),
                             (self.a3r9, DISABLED),
                             (self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             #(self.f2a4r7, NORMAL),
                             (self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('1_aktivierung_des_elektrophils')
            self.f2a4r4.select()
            self.a4_festlegen()
        elif a3.get() == '14_ethansaeureethylester_und_hydroxidion':
            for i, state in ((self.a3r11, DISABLED),
                             (self.a3r12, DISABLED),
                             (self.a3r13, DISABLED),
                             (self.a3r14, DISABLED),
                             (self.a3r9, DISABLED),
                             #(self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             #(self.f2a4r7, NORMAL),
                             (self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('2_angriff_des_nu_am_el')
            self.f2a4r5.select()
            self.a4_festlegen()
        elif a3.get() == '15_halbacetal_und_methanol':
            for i, state in ((self.a3r11, DISABLED),
                             (self.a3r12, DISABLED),
                             (self.a3r13, DISABLED),
                             (self.a3r14, DISABLED),
                             (self.a3r9, DISABLED),
                             (self.f2a4r4, NORMAL),
                             (self.f2a4r5, NORMAL),
                             (self.f2a4r6, NORMAL),
                             #(self.f2a4r7, NORMAL),
                             (self.f2a4r8, NORMAL),
                             (self.scale1, NORMAL),
                             (self.banim, NORMAL)
                             ):
                i.config(state=state)
            a4.set('1_aktivierung_des_elektrophils')
            self.f2a4r4.select()
            self.a4_festlegen()

    def a4_festlegen(self):
        self.bilderdir='daten/img'
        self.mechanismus=str(a2.get())
        self.ausgangsstoffe=str(a3.get())
        self.teilschritt=str(a4.get())
        self.scale1.set(1)
        self.bildnr=str(self.scale1.get())
        self.katalysetyp=str(a5.get())
        # TO DO: bei reiner Protonenkatalyse ggfs. nur diese Bilder und diesen Text holen
        if self.katalysetyp == 'X':
            self.bildpfad=self.bilderdir+os.sep+self.ausgangsstoffe+os.sep+self.teilschritt+self.bildnr+'.gif'
            self.text1.config(state=NORMAL)
            self.ausgabetext=teilschritte_text[self.ausgangsstoffe][self.teilschritt][int(self.scale1.get())-1]
            # Falls zu diesem Feld kein Bild- und kein Texteintrag vorliegt.
            if self.ausgabetext == 'k.a.':
                self.ausgabetext='Dieser Teilschritt entfällt in diesem Mechanismus.'
                self.bildpfad=self.bilderdir+os.sep+'kommt_nicht_vor.gif'
            self.text1.delete(0.0, END)
            self.text1.insert(0.0, self.ausgabetext)
            self.text1.config(state=DISABLED)
            #print self.ausgabetext
            #print self.bildpfad
            self.bild1=PhotoImage(file=self.bildpfad)
            self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)
        elif self.katalysetyp == 'mit_oxoniumion' or self.katalysetyp == 'mit_proton':
            self.bildpfad=self.bilderdir+os.sep+self.ausgangsstoffe+os.sep+self.katalysetyp+os.sep+self.teilschritt+self.bildnr+'.gif'
            self.text1.config(state=NORMAL)
            self.ausgabetext=teilschritte_text[self.ausgangsstoffe][self.katalysetyp][self.teilschritt][int(self.scale1.get())-1]
            # Falls zu diesem Feld kein Bild- und kein Texteintrag vorliegt.
            if self.ausgabetext == 'k.a.':
                self.ausgabetext='Dieser Teilschritt entfällt in diesem Mechanismus.'
                self.bildpfad=self.bilderdir+os.sep+'kommt_nicht_vor.gif'
            self.text1.delete(0.0, END)
            self.text1.insert(0.0, self.ausgabetext)
            self.text1.config(state=DISABLED)
            #print self.ausgabetext
            #print self.bildpfad
            self.bild1=PhotoImage(file=self.bildpfad)
            self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)
        
    def zwischenschritt_holen(self, a):
        self.bilderdir='daten/img'
        self.mechanismus=str(a2.get())
        self.ausgangsstoffe=str(a3.get())
        self.teilschritt=str(a4.get())
        self.bildnr=str(self.scale1.get())
        self.katalysetyp=str(a5.get())
        # TO DO: bei reiner Protonenkatalyse ggfs. nur diese Bilder und diesen Text holen
        if self.mechanismus != 'X' and self.ausgangsstoffe != 'X' and self.teilschritt != 'X':
            if  self.katalysetyp == 'X':
                self.bildpfad=self.bilderdir+os.sep+self.ausgangsstoffe+os.sep+self.teilschritt+self.bildnr+'.gif'
                self.text1.config(state=NORMAL)
                self.ausgabetext=teilschritte_text[self.ausgangsstoffe][self.teilschritt][int(self.scale1.get())-1]
                # Falls zu diesem Feld kein Bild- und kein Texteintrag vorliegt.
                if self.ausgabetext == 'k.a.':
                    self.ausgabetext='Dieser Teilschritt entfällt in diesem Mechanismus.'
                    self.bildpfad=self.bilderdir+os.sep+'kommt_nicht_vor.gif'
                self.text1.delete(0.0, END)
                self.text1.insert(0.0, self.ausgabetext)
                self.text1.config(state=DISABLED)
                #print self.ausgabetext
                #print self.bildpfad
                self.bild1=PhotoImage(file=self.bildpfad)
                self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)
            elif self.katalysetyp == 'mit_oxoniumion' or self.katalysetyp == 'mit_proton':
                self.bildpfad=self.bilderdir+os.sep+self.ausgangsstoffe+os.sep+self.katalysetyp+os.sep+self.teilschritt+self.bildnr+'.gif'
                self.text1.config(state=NORMAL)
                self.ausgabetext=teilschritte_text[self.ausgangsstoffe][self.katalysetyp][self.teilschritt][int(self.scale1.get())-1]
                # Falls zu diesem Feld kein Bild- und kein Texteintrag vorliegt.
                if self.ausgabetext == 'k.a.':
                    self.ausgabetext='Dieser Teilschritt entfällt in diesem Mechanismus.'
                    self.bildpfad=self.bilderdir+os.sep+'kommt_nicht_vor.gif'
                self.text1.delete(0.0, END)
                self.text1.insert(0.0, self.ausgabetext)
                self.text1.config(state=DISABLED)
                #print self.ausgabetext
                #print self.bildpfad
                self.bild1=PhotoImage(file=self.bildpfad)
                self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)

    def a5_festlegen(self):
        print(a5.get())
        self.bilderdir='daten/img'
        self.mechanismus=str(a2.get())
        self.ausgangsstoffe=str(a3.get())
        self.teilschritt=str(a4.get())
        self.bildnr=str(self.scale1.get())
        self.katalysetyp=str(a5.get())
        # TO DO: bei reiner Protonenkatalyse ggfs. nur diese Bilder und diesen Text holen
        if self.mechanismus != 'X' and self.ausgangsstoffe != 'X' and self.teilschritt != 'X':
            if  self.katalysetyp == 'X':
                self.bildpfad=self.bilderdir+os.sep+self.ausgangsstoffe+os.sep+self.teilschritt+self.bildnr+'.gif'
                self.text1.config(state=NORMAL)
                self.ausgabetext=teilschritte_text[self.ausgangsstoffe][self.teilschritt][int(self.scale1.get())-1]
                # Falls zu diesem Feld kein Bild- und kein Texteintrag vorliegt.
                if self.ausgabetext == 'k.a.':
                    self.ausgabetext='Dieser Teilschritt entfällt in diesem Mechanismus.'
                    self.bildpfad=self.bilderdir+os.sep+'kommt_nicht_vor.gif'
                self.text1.delete(0.0, END)
                self.text1.insert(0.0, self.ausgabetext)
                self.text1.config(state=DISABLED)
                #print self.ausgabetext
                #print self.bildpfad
                self.bild1=PhotoImage(file=self.bildpfad)
                self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)
            elif self.katalysetyp == 'mit_oxoniumion' or self.katalysetyp == 'mit_proton':
                self.bildpfad=self.bilderdir+os.sep+self.ausgangsstoffe+os.sep+self.katalysetyp+os.sep+self.teilschritt+self.bildnr+'.gif'
                self.text1.config(state=NORMAL)
                self.ausgabetext=teilschritte_text[self.ausgangsstoffe][self.katalysetyp][self.teilschritt][int(self.scale1.get())-1]
                # Falls zu diesem Feld kein Bild- und kein Texteintrag vorliegt.
                if self.ausgabetext == 'k.a.':
                    self.ausgabetext='Dieser Teilschritt entfällt in diesem Mechanismus.'
                    self.bildpfad=self.bilderdir+os.sep+'kommt_nicht_vor.gif'
                self.text1.delete(0.0, END)
                self.text1.insert(0.0, self.ausgabetext)
                self.text1.config(state=DISABLED)
                #print self.ausgabetext
                #print self.bildpfad
                self.bild1=PhotoImage(file=self.bildpfad)
                self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)


################################################################################
root = Tk()
root.title('Mechanismer')
app = Fenster(root)
root.mainloop()
