#!/usr/bin/env python3
# -*- coding: utf-8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
import string
import webbrowser

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=4)
        self.frame2=Frame(frame, pady=4, padx=4, bd=2, relief=RIDGE)
        self.frame3=Frame(frame, pady=4, padx=4)
        self.frame4=Frame(frame, pady=4, padx=4)
        self.frame5=Frame(frame, pady=4, padx=4)
        self.frame6=Frame(frame, pady=4, padx=4)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 1, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 2, 0, 1, E+W),
                (self.frame4, 3, 0, 1, E+W),
                (self.frame5, 4, 0, 1, E+W),
                (self.frame6, 5, 0, 1, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)
        # Rahmen 1: Zeichenfläche
        self.f1canvas1=Canvas(self.frame1, width=780, height=620, bg='white')
        # Rahmen 2: Speicher auswählen
        self.f2l1=Label(self.frame2, text='Speicher:')
        self.var1 = StringVar()
        self.var1.set('0')
        self.var2 = StringVar()
        self.var2.set('0')
        self.var3 = StringVar()
        self.var3.set('0')
        self.f2c1=Checkbutton(self.frame2,
                              text='Atmosphäre, Hydrosphäre und Lithosphäre',
                              variable=self.var1,
                              onvalue='1',
                              offvalue='0',
                              anchor=W,
                              command=self.zeige_stationen)
        self.f2c2=Checkbutton(self.frame2,
                              text='Biosphäre',
                              variable=self.var2,
                              onvalue='1',
                              offvalue='0',
                              anchor=W,
                              command=self.zeige_stationen)
        self.f2c3=Checkbutton(self.frame2,
                              text='Fossile Brennstoffe',
                              variable=self.var3,
                              onvalue='1',
                              offvalue='0',
                              anchor=W,
                              command=self.zeige_stationen)
        icon_help = PhotoImage(file='daten/img/help.gif')
        self.f2b2=Button(self.frame2,
                         command=self.hilfe_abiotische_speicher,
                         image=icon_help,
                         compound=LEFT,
                         text='')
        self.f2b2.icon_help=icon_help
        self.f2b3=Button(self.frame2,
                         command=self.hilfe_biotische_speicher,
                         image=icon_help,
                         compound=LEFT,
                         text='')
        self.f2b3.icon_help=icon_help
        self.f2b4=Button(self.frame2,
                         command=self.hilfe_fossile_brennstoffe,
                         image=icon_help,
                         compound=LEFT,
                         text='')
        self.f2b4.icon_help=icon_help
        # Stoff-Flüsse
        self.f2l2=Label(self.frame2, text='Stoff-Flüsse:')
        self.f2l3=Label(self.frame2, text='Vulkanausbrüche', fg='red')
        self.f2b5=Button(self.frame2,
                         command=self.hilfe_vulkanausbruch,
                         image=icon_help,
                         compound=LEFT,
                         text='')
        self.f2b5.icon_help=icon_help
        self.f2l4=Label(self.frame2, text='Gesteinserosion', fg='red')
        self.f2l5=Label(self.frame2, text='Gesteinsbildung', fg='darkgreen')
        self.f2b6=Button(self.frame2,
                         command=self.hilfe_gesteine,
                         image=icon_help,
                         compound=LEFT,
                         text='')
        self.f2b6.icon_help=icon_help
        self.f2l6=Label(self.frame2, text='Ausgasen', fg='red')
        self.f2l7=Label(self.frame2, text='Lösen', fg='darkgreen')
        self.f2b7=Button(self.frame2,
                         command=self.hilfe_gase,
                         image=icon_help,
                         compound=LEFT,
                         text='')
        self.f2b7.icon_help=icon_help
        self.f2l8=Label(self.frame2, text='Gärung und Zellatmung', fg='red')
        self.f2l9=Label(self.frame2, text='Fotosynthese', fg='darkgreen')
        self.f2b8=Button(self.frame2,
                         command=self.hilfe_stoffwechsel,
                         image=icon_help,
                         compound=LEFT,
                         text='')
        self.f2b8.icon_help=icon_help
        self.f2l10=Label(self.frame2, text='Verbrennung', fg='red')
        self.f2b9=Button(self.frame2,
                         command=self.hilfe_verbrennung,
                         image=icon_help,
                         compound=LEFT,
                         text='')
        self.f2b9.icon_help=icon_help

        # Rahmen 3: Kontroll- und Steuerelemente für Störung durch Verbrennung fossiler Brennstoffe
        self.f3l1=Label(self.frame3,
                        text='Modell für den Einfluss der Verbrennung fossiler Brennstoffe:',
                        state=DISABLED)
        #sc1=IntVar()
        #sc1=0
        self.schritt_anzahl=9
        self.f3scale1=Scale(self.frame3,
                            length=700,
                            from_=0,
                            to=self.schritt_anzahl,
                            resolution=1,
                            showvalue=0,
                            orient=HORIZONTAL,
                            command=self.zeige_schritt,
                            state=DISABLED)
        icon_flag = PhotoImage(file='daten/img/flag.gif')
        self.f3b1=Button(self.frame3,
                         command=self.extrafenster_schritt_test,
                         image=icon_flag,
                         compound=LEFT,
                         text='',
                         state=DISABLED)
        self.f3b1.icon_flag=icon_flag
        icon_zuruecksetzen = PhotoImage(file='daten/img/zuruecksetzen.gif')
        self.f3b2=Button(self.frame3,
                         command=self.schritte_zurecksetzen,
                         image=icon_zuruecksetzen,
                         compound=LEFT,
                         text='',
                         state=DISABLED)
        self.f3b2.icon_zuruecksetzen=icon_zuruecksetzen

        # Rahmen 4: Programmnavigation
        self.f4b1=Button(self.frame4, text='Beenden', command=root.destroy)

        # Alle Fensterelemente der Rahmen 1 bis 4 anzeigen
        for i, row, rowspan, column, columnspan, sticky in (
                # Rahmen 1
                (self.f1canvas1, 0, 1, 0, 1, E+W),
                # Rahmen 2
                (self.f2l1, 0, 1, 0, 2, W),                             (self.f2l2, 0, 1, 2, 4, W),
                (self.f2c1, 1, 3, 0, 1, W), (self.f2b2, 1, 1, 1, 1, W), (self.f2l3, 1, 2, 2, 1, W),                             (self.f2b5, 1, 1, 4, 1, W),
                                                                        (self.f2l4, 2, 1, 2, 1, W), (self.f2l5, 2, 1, 3, 1, W), (self.f2b6, 2, 1, 4, 1, W),
                                                                        (self.f2l6, 3, 1, 2, 1, W), (self.f2l7, 3, 1, 3, 1, W), (self.f2b7, 3, 1, 4, 1, W),
                (self.f2c2, 4, 1, 0, 1, W), (self.f2b3, 4, 1, 1, 1, W), (self.f2l8, 4, 1, 2, 1, W), (self.f2l9, 4, 1, 3, 1, W), (self.f2b8, 4, 1, 4, 1, W),
                (self.f2c3, 5, 1, 0, 1, W), (self.f2b4, 5, 1, 1, 1, W), (self.f2l10, 5, 2, 2, 1, W),                            (self.f2b9, 5, 1, 4, 1, W),
                # Rahmen 3
                (self.f3l1, 0, 1, 0, 5, W),
                (self.f3b2, 1, 1, 0, 1, W), (self.f3scale1, 1, 1, 1, 4, W), (self.f3b1, 1, 1, 5, 1, W),

                # Rahmen 4
                (self.f4b1, 0, 1, 0, 1, W)
                ):
            i.grid(row=row, columnspan=columnspan, column=column, sticky=sticky)
        self.f2c1.select()
        self.zeige_stationen()

    def zeige_schritt(self, a):
        self.alle_linien=(self.loesen, self.ausgasen, self.gesteinsbildung,
                          self.gesteinserosion, self.fotosynthese, self.gaerung_zellatmung,
                          self.verbrennung, self.vulkanausbruch)
        self.alle_bloecke=(self.atm, self.hyd, self.lit, self.fos, self.bio)
        if self.f3scale1.get() == 0:
            #print(a, 'aktiviere Teil 1')
            for i in (self.f2l1, self.f2l2,
                      self.f2c1, self.f2b2, self.f2l3,            self.f2b5,
                                            self.f2l4, self.f2l5, self.f2b6,
                                            self.f2l6, self.f2l7, self.f2b7,
                      self.f2c2, self.f2b3, self.f2l8, self.f2l9, self.f2b8,
                      self.f2c3, self.f2b4, self.f2l10,           self.f2b9):
                i.config(state=NORMAL)
            # alle zuruecksetzen
            for i in self.alle_linien:
                i.schriftgroesse_aendern(12)
                i.linienbreite_aendern(3)
            for i in self.alle_bloecke:
                i.hintergrund_aendern('white')
            self.vulkanausbruch.zustand_aendern(NORMAL)
            self.f1canvas1.config(bg='white')
        elif self.f3scale1.get() > 0:
            #print(a, 'deaktiviere Teil 1')
            for i in (self.f2l1, self.f2l2,
                      self.f2c1, self.f2b2, self.f2l3,            self.f2b5,
                                            self.f2l4, self.f2l5, self.f2b6,
                                            self.f2l6, self.f2l7, self.f2b7,
                      self.f2c2, self.f2b3, self.f2l8, self.f2l9, self.f2b8,
                      self.f2c3, self.f2b4, self.f2l10,           self.f2b9):
                i.config(state=DISABLED)
            if self.f3scale1.get() == 1:
                # alle zurücksetzen
                for i in self.alle_linien:
                    i.schriftgroesse_aendern(12)
                    i.linienbreite_aendern(3)
                for i in self.alle_bloecke:
                    i.hintergrund_aendern('white')
                self.f1canvas1.config(bg='white')
                # Spezialfall einstellen
                self.verbrennung.schriftgroesse_aendern(22)
                self.verbrennung.linienbreite_aendern(10)
                self.atm.hintergrund_aendern('#FFFF80808080')
                self.vulkanausbruch.zustand_aendern(HIDDEN)
            elif self.f3scale1.get() == 2:
                # alle zurücksetzen
                for i in self.alle_linien:
                    i.schriftgroesse_aendern(12)
                    i.linienbreite_aendern(3)
                for i in self.alle_bloecke:
                    i.hintergrund_aendern('white')
                self.f1canvas1.config(bg='white')
                # Spezialfall einstellen
                self.verbrennung.schriftgroesse_aendern(22)
                self.verbrennung.linienbreite_aendern(10)
                self.fotosynthese.schriftgroesse_aendern(22)
                self.fotosynthese.linienbreite_aendern(10)
                self.atm.hintergrund_aendern('#FFFFAAAAAAAA')
                self.vulkanausbruch.zustand_aendern(HIDDEN)
            elif self.f3scale1.get() == 3:
                # alle zurücksetzen
                for i in self.alle_linien:
                    i.schriftgroesse_aendern(12)
                    i.linienbreite_aendern(3)
                for i in self.alle_bloecke:
                    i.hintergrund_aendern('white')
                self.f1canvas1.config(bg='white')
                # Spezialfall einstellen
                self.verbrennung.schriftgroesse_aendern(22)
                self.verbrennung.linienbreite_aendern(10)
                self.fotosynthese.schriftgroesse_aendern(22)
                self.fotosynthese.linienbreite_aendern(10)
                self.loesen.schriftgroesse_aendern(22)
                self.loesen.linienbreite_aendern(10)
                #self.atm.hintergrund_aendern('white')
                self.vulkanausbruch.zustand_aendern(HIDDEN)
            elif self.f3scale1.get() == 4:
                # alle zurücksetzen
                for i in self.alle_linien:
                    i.schriftgroesse_aendern(12)
                    i.linienbreite_aendern(3)
                for i in self.alle_bloecke:
                    i.hintergrund_aendern('white')
                self.f1canvas1.config(bg='white')
                # Spezialfall einstellen
                self.verbrennung.schriftgroesse_aendern(22)
                self.verbrennung.linienbreite_aendern(18)
                self.atm.hintergrund_aendern('#FFFF80808080')
                self.vulkanausbruch.zustand_aendern(HIDDEN)
            elif self.f3scale1.get() == 5:
                # alle zurücksetzen
                for i in self.alle_linien:
                    i.schriftgroesse_aendern(12)
                    i.linienbreite_aendern(3)
                for i in self.alle_bloecke:
                    i.hintergrund_aendern('white')
                self.f1canvas1.config(bg='white')
                # Spezialfall einstellen
                self.verbrennung.schriftgroesse_aendern(22)
                self.verbrennung.linienbreite_aendern(18)
                self.atm.hintergrund_aendern('#FFFF80808080')
                self.f1canvas1.config(bg='#FFFFD5D5D5D5')
                self.vulkanausbruch.zustand_aendern(HIDDEN)
            elif self.f3scale1.get() == 6:
                # alle zurücksetzen
                for i in self.alle_linien:
                    i.schriftgroesse_aendern(12)
                    i.linienbreite_aendern(3)
                for i in self.alle_bloecke:
                    i.hintergrund_aendern('white')
                self.f1canvas1.config(bg='white')
                # Spezialfall einstellen
                self.verbrennung.schriftgroesse_aendern(22)
                self.verbrennung.linienbreite_aendern(18)
                self.gaerung_zellatmung.schriftgroesse_aendern(22)
                self.gaerung_zellatmung.linienbreite_aendern(18)
                self.atm.hintergrund_aendern('#FFFF55555555')
                self.f1canvas1.config(bg='#FFFFAAAAAAAA')
                self.vulkanausbruch.zustand_aendern(HIDDEN)
            elif self.f3scale1.get() == 7:
                # alle zurücksetzen
                for i in self.alle_linien:
                    i.schriftgroesse_aendern(12)
                    i.linienbreite_aendern(3)
                for i in self.alle_bloecke:
                    i.hintergrund_aendern('white')
                self.f1canvas1.config(bg='white')
                # Spezialfall einstellen
                self.verbrennung.schriftgroesse_aendern(22)
                self.verbrennung.linienbreite_aendern(18)
                self.gaerung_zellatmung.schriftgroesse_aendern(22)
                self.gaerung_zellatmung.linienbreite_aendern(18)
                self.ausgasen.schriftgroesse_aendern(22)
                self.ausgasen.linienbreite_aendern(18)
                self.atm.hintergrund_aendern('#FFFF2A2A2A2A')
                self.f1canvas1.config(bg='#FFFF80808080')
                self.vulkanausbruch.zustand_aendern(HIDDEN)
            elif self.f3scale1.get() == 8:
                # alle zurücksetzen
                for i in self.alle_linien:
                    i.schriftgroesse_aendern(12)
                    i.linienbreite_aendern(3)
                for i in self.alle_bloecke:
                    i.hintergrund_aendern('white')
                self.f1canvas1.config(bg='white')
                # Spezialfall einstellen
                self.verbrennung.schriftgroesse_aendern(22)
                self.verbrennung.linienbreite_aendern(18)
                self.ausgasen.schriftgroesse_aendern(30)
                self.ausgasen.linienbreite_aendern(22)
                self.gaerung_zellatmung.schriftgroesse_aendern(22)
                self.gaerung_zellatmung.linienbreite_aendern(18)
                self.gesteinserosion.schriftgroesse_aendern(22)
                self.gesteinserosion.linienbreite_aendern(18)
                self.atm.hintergrund_aendern('#D4D400000000')
                self.f1canvas1.config(bg='#FFFF55555555')
                self.vulkanausbruch.zustand_aendern(HIDDEN)
            elif self.f3scale1.get() == 9:
                # alle zurücksetzen
                for i in self.alle_linien:
                    i.schriftgroesse_aendern(12)
                    i.linienbreite_aendern(3)
                for i in self.alle_bloecke:
                    i.hintergrund_aendern('white')
                self.f1canvas1.config(bg='white')
                # Spezialfall einstellen
                self.verbrennung.schriftgroesse_aendern(22)
                self.verbrennung.linienbreite_aendern(30)
                self.ausgasen.schriftgroesse_aendern(30)
                self.ausgasen.linienbreite_aendern(40)
                self.gaerung_zellatmung.schriftgroesse_aendern(22)
                self.gaerung_zellatmung.linienbreite_aendern(30)
                self.gesteinserosion.schriftgroesse_aendern(22)
                self.gesteinserosion.linienbreite_aendern(30)
                self.atm.hintergrund_aendern('#AAAA00000000')
                self.f1canvas1.config(bg='#D4D400000000')
                self.vulkanausbruch.zustand_aendern(HIDDEN)


            # TO DO: Zeichenelemente anpassen
            # schriftrgröße test:
            #self.verbrennung.schriftgroesse_aendern(22)
            # hintergrundfarbe test:
            #self.atm.hintergrund_aendern('cyan')

    def schritte_zurecksetzen(self):
        self.f3scale1.set(0)

    def hilfe_oeffnen(self, seitenname):
        self.seitenname=seitenname
        self.seiten_url='file://'+os.getcwd()+os.sep+'daten/html'+os.sep+self.seitenname+'.html'
        webbrowser.open(self.seiten_url)

    def hilfe_verbrennung(self):
        self.hilfe_oeffnen('verbrennung')

    def hilfe_stoffwechsel(self):
        self.hilfe_oeffnen('stoffwechsel')

    def hilfe_gase(self):
        #print('gase')
        self.hilfe_oeffnen('gase')

    def hilfe_gesteine(self):
        #print('gesteine')
        self.hilfe_oeffnen('gesteine')

    def hilfe_vulkanausbruch(self):
        #print('vulkanausbruch')
        self.hilfe_oeffnen('vulkanausbruch')

    def hilfe_abiotische_speicher(self):
        #print('abiotische_speicher')
        self.hilfe_oeffnen('abiotische_speicher')

    def hilfe_biotische_speicher(self):
        #print('biotische_speicher')
        self.hilfe_oeffnen('biotische_speicher')

    def hilfe_fossile_brennstoffe(self):
        #print('fossile_brennstoffe')
        self.hilfe_oeffnen('fossile_brennstoffe')

    def zeige_stationen(self):
        #print('stationen_anzeigen')
        self.auswahl1=str(self.var1.get()+self.var2.get()+self.var3.get())
        #print(self.auswahl1)
        # Evtl. bereits vorhandene Zeichenelemente löschen!
        for i in self.f1canvas1.find_all():
            self.f1canvas1.delete(i)
        self.speicherhoehe=90
        self.speicherbreite=220
        # Stofffluesse (darunterliegend!)
        self.loesen=stofffluss(self.f1canvas1,                520,  55,  245, 140,   'Lösen',                  'darkgreen', LAST,  12, NORMAL, 3, 90, 90)
        self.ausgasen=stofffluss(self.f1canvas1,              520,  75,  245, 140,   'Ausgasen',               'red',       FIRST, 12, NORMAL, 3, -40, 100)
        self.gesteinsbildung=stofffluss(self.f1canvas1,       240,  355, 0, 300,   'Gesteinsbildung',        'darkgreen', FIRST,  12, NORMAL, 3, 95, 10)
        self.gesteinserosion=stofffluss(self.f1canvas1,       240,  345, 0, 300,   'Gesteinserosion',        'red',       LAST, 12, NORMAL, 3, 95, -30)
        self.fotosynthese=stofffluss(self.f1canvas1,          250,  500, -390, 150,   'Fotosynthese',           'darkgreen', FIRST,  12, NORMAL, 3, 30, -50)
        self.gaerung_zellatmung=stofffluss(self.f1canvas1,    240,  500, -390, 150,   'Gärung und\nZellatmung', 'red',       LAST, 12, NORMAL, 3, -80, -70)
        self.verbrennung=stofffluss(self.f1canvas1,           540,  500, -390, -130,   'Verbrennung',            'red',       LAST, 12, NORMAL, 3, 0, -50)
        self.vulkanausbruch=stofffluss(self.f1canvas1,        130,  300, -235, 170,   'Vulkan-\nausbrüche',        'red',       LAST, 12, NORMAL, 3, -10, -150)
        # Speicher
        self.atm=speicher(self.f1canvas1, 300,  20, self.speicherbreite, self.speicherhoehe,      'Atmosphäre',            'CO₂ ; CH₄',             12, NORMAL)
        self.hyd=speicher(self.f1canvas1, 540,  300, self.speicherbreite, self.speicherhoehe,     'Ozeane',                'CO₂ (gelöst) ; HCO₃⁻',  12, NORMAL)
        self.lit=speicher(self.f1canvas1, 20, 300, self.speicherbreite, self.speicherhoehe,       'Gestein',               'CaCO₃',                 12, NORMAL)
        self.fos=speicher(self.f1canvas1, 430, 500, self.speicherbreite, self.speicherhoehe,      'Fossile Brennstoffe',   'Kohlenwasserstoffe',    12, NORMAL)
        self.bio=speicher(self.f1canvas1, 140, 500, self.speicherbreite, self.speicherhoehe,      'Biomasse in Lebewesen', 'Kohlenhydrate; Proteine;\nFette; Nukleinsäuren', 12, NORMAL)
        # Kombinationen
        # Alle
        self.alle_zeichenelemente=(
            self.loesen, self.ausgasen, self.gesteinsbildung, self.gesteinserosion, self.fotosynthese, self.gaerung_zellatmung, self.verbrennung, self.vulkanausbruch,
            self.atm, self.hyd, self.lit, self.fos, self.bio
            )
        self.abiotische_speicher=(
            self.loesen, self.ausgasen, self.gesteinsbildung, self.gesteinserosion, self.vulkanausbruch,
            self.atm, self.hyd, self.lit,
            )
        self.biotische_speicher=(
            self.fotosynthese, self.gaerung_zellatmung,
            self.atm, self.bio
            )
        self.fossile_brennstoffe=(
            self.verbrennung,
            self.atm, self.fos,
            )
        self.anzeigeauswahl={
            '000':'',
            '100':(self.abiotische_speicher, ),
            '010':(self.biotische_speicher, ),
            '001':(self.fossile_brennstoffe, ),
            '110':(self.abiotische_speicher, self.biotische_speicher),
            '011':(self.biotische_speicher, self.fossile_brennstoffe),
            '101':(self.abiotische_speicher, self.fossile_brennstoffe),
            '111':(self.abiotische_speicher, self.biotische_speicher, self.fossile_brennstoffe)
        }
        # Dann erstmal alle verstecken:
        for w in self.alle_zeichenelemente:
            w.zustand_aendern(HIDDEN)
        # TO DO: Je nach Auswahl die Speicher und die Stoffflüsse sichtbar machen
        for i in self.anzeigeauswahl[self.auswahl1]:
            for w in i:
                w.zustand_aendern(NORMAL)
        # Leinwand updaten
        self.f1canvas1.config(background='white')
        self.f1canvas1.update()
        if self.auswahl1 == '111':
            self.f3l1.config(state=NORMAL)
            self.f3scale1.config(state=NORMAL)
            self.f3b1.config(state=NORMAL)
            self.f3b2.config(state=NORMAL)
        else:
            self.f3l1.config(state=DISABLED)
            self.f3scale1.config(state=NORMAL)
            self.f3scale1.set(0)
            self.f3scale1.config(state=DISABLED)
            self.f3b1.config(state=DISABLED)
            self.f3b2.config(state=DISABLED)
            try:
                self.extrafenster_schritt_schliessen()
            except:
                pass
        if self.auswahl1 == '000':
            self.f2c1.select()
            self.zeige_stationen()

        ########################################################################
        ##                          Nebenfenster                              ##
        ########################################################################

        global unterFensterZahl
        unterFensterZahl = int(0)
        global namensLaengeUnterfenster
        namensLaengeUnterfenster = str('')

    def extrafenster_schritt_test(self):
        global namensLaengeUnterfenster
        global unterFensterZahl
        try:
            namensLaengeUnterfenster = self.nw.winfo_name()
            if len(namensLaengeUnterfenster) > 1:
                self.nw.destroy()
        except:
            pass
            unterFensterZahl = 0
        if unterFensterZahl < 1:
            self.extrafenster_schritt()

    def extrafenster_schritt(self):
        self.schritte_texte={
        0:'Die Stoff-Flüsse bewegen sich mit leichten jahreszeitlichen Schwankungen um einen relativ konstanten Mittelwert.',
        1:'Durch die Verbrennung fossiler Brennstoffe wird das dynamische Gleichgewicht gestört und die CO₂-Konzentration in der Atmosphäre wird erhöht. \nDer Eintrag von CO₂ in die Atmosphäre über Vulkanausbrüche wird vernachlässigt, da hier nur der kurzfristige Kohlenstoffkreislauf (nur mit einer Dauer von bis zu maximal mehren Tausend Jahren) berücksichtigt wird.',
        2:'Kurzfristig kann ein Teil des überschüssigen CO₂ aus der Atmosphäre in Form von (v.a. pflanzlicher) Biomasse gebunden werden. \nDies ist ein Selbstheilungs- bzw. Selbstregulationsschritt durch eine negative Rückkopplung im Kreislauf.',
        3:'Kurzfristig kann ein weiterer Teil des überschüssigen CO₂ aus der Atmosphäre in den Ozeanen gelöst werden.\nDies ist ebenfalls ein Selbstheilungs- bzw. Selbstregulationsschritt durch eine negative Rückkopplung im Kreislauf.',
        4:'Können diese beiden Speicher aber nichts mehr aufnehmen, und wird die Verbrennung fossiler Brennstoffe unvermindert fortgesetzt, so steigt die CO₂-Konzentration in der Atmosphäre stark an.',
        5:'Durch den Treibhauseffekt erfolgt eine globale Erwärmung.',
        6:'Durch die höhere Temperatur nimmt die Destruententätigkeit anteilig stärker zu als die Primärproduktion von Biomasse durch die Produzenten (Pflanzen).\nDadurch wird netto noch mehr CO₂ aus der Biomasse in die Atmosphäre freigesetzt. \nDies ist ein, das Gleichgewicht zunehmend zerstörender, positiver Rückkopplungsschritt, der einen Teufelskreis in Gang setzt und immer weiter verstärkt.',
        7:'Durch die höhere Temperatur auch der Ozeane wird die Löslichkeit von CO₂ in den Ozeanen verringert, es wird vermehrt an die Atmosphäre abgegeben. \nDie Temperatur steigt weiter an. \nDies ist ein weiterer, das Gleichgewicht zunehmend zerstörender, positiver Rückkopplungsschritt, der einen Teufelskreis in Gang setzt und immer weiter verstärkt.',
        8:'Durch den niedrigeren pH-Wert werden mehr Carbonatgesteine gelöst bzw. die Gesteinsbildung durch Meereslebewesen mit Kalkschale wird gestört. Es wird CO₂ aus dem Gestein freigesetzt und aus den Ozeanen in die Atmosphäre abgegeben. \nDie Temperatur steigt noch weiter an. \nDies ist ein noch ein dritter, das Gleichgewicht zunehmend zerstörender, positiver Rückkopplungsschritt, der einen Teufelskreis in Gang setzt und immer weiter verstärkt.',
        9:'Der gestiegene CO₂-Gehalt in der Atmosphäre führt zu einer weiteren globalen Erwärmung der Atmosphäre. \nDurch die sich selbst und gegenseitig immer weiter verstärkenden positiven Rückkopplungsschritte, wird ein Teufelskreis wahrscheinlich, der zu einer sehr starken Erwärmung führt.'
        }

        self.nw = Toplevel(root)
        self.schritt_nr=self.f3scale1.get()
        #print(self.schritt_nr, 'extrafenster_schritt')
        self.nw.title('Schritt Nr. '+str(self.schritt_nr))
        self.nwFrame=Frame(self.nw)
        self.nwText=Text(self.nwFrame, width=80, height=12, wrap=WORD, bg='white', font=('dejavu', 11))
        self.nwText.insert(1.0, self.schritte_texte[self.schritt_nr])
        if self.schritt_nr == 5:
            self.nwText.config(bg='#FFFFD5D5D5D5')
        elif self.schritt_nr == 6:
            self.nwText.config(bg='#FFFFAAAAAAAA')
        elif self.schritt_nr == 7:
            self.nwText.config(bg='#FFFF80808080')
        elif self.schritt_nr == 8:
            self.nwText.config(bg='#FFFF55555555')
        elif self.schritt_nr == 9:
            self.nwText.config(bg='#D4D400000000')

        self.nwButton=Button(self.nwFrame, text='Fenster Schließen',
                         command=self.extrafenster_schritt_schliessen)
        self.nwFrame.pack()
        self.nwText.pack()
        self.nwButton.pack()

    def extrafenster_schritt_schliessen(self):
        self.nw.destroy()
        global unterFensterZahl
        if unterFensterZahl >= 1:
            try:
                unterFensterZahl = 0
            except:
                pass


        ########################################################################
        ##                          Klassendefinitionen                       ##
        ########################################################################

class speicher:
    def __init__(self, canvas, x1, y1,  breite, hoehe, sphaere, stoffe, schriftgroesse, ausgangszustand):
        self.canvas=canvas
        self.x1=x1
        self.y1=y1
        self.hoehe=hoehe
        self.breite=breite
        self.sphaere=sphaere
        self.stoffe=stoffe
        self.schriftgroesse=schriftgroesse
        self.ausgangszustand=ausgangszustand
        self.kasten=self.canvas.create_rectangle(self.x1,
                                                 self.y1,
                                                 self.x1+self.breite,
                                                 self.y1+self.hoehe,
                                                 fill='white',
                                                 state=self.ausgangszustand)
        self.textinhalt=self.canvas.create_text(self.x1+5,
                                                self.y1+5,
                                                text=self.sphaere+'\n'+self.stoffe,
                                                fill='black',
                                                font=('helvetica', self.schriftgroesse),
                                                anchor=NW,
                                                justify=LEFT,
                                                state=self.ausgangszustand)
    def zustand_aendern(self, zustand):
        self.zustand=zustand
        self.canvas.itemconfig(self.kasten, state=self.zustand)
        self.canvas.itemconfig(self.textinhalt, state=self.zustand)

    def hintergrund_aendern(self, farbe):
        self.farbe=farbe
        self.canvas.itemconfig(self.kasten, fill=self.farbe)

class stofffluss:
    def __init__(self, canvas, x1, y1, hoehe, breite, fluss, farbe, pfeilpos, schriftgroesse, ausgangszustand, linienbreite, xversch, yversch):
        self.canvas=canvas
        self.x1=x1
        self.y1=y1
        self.hoehe=hoehe
        self.breite=breite
        self.fluss=fluss
        self.farbe=farbe
        self.pfeilpos=pfeilpos
        self.schriftgroesse=schriftgroesse
        self.ausgangszustand=ausgangszustand
        self.linienbreite=linienbreite
        self.xversch=xversch
        self.yversch=yversch
        self.linie=self.canvas.create_line(self.x1,
                                           self.y1,
                                           self.x1+self.breite,
                                           self.y1+self.hoehe,
                                           fill=self.farbe,
                                           arrow=self.pfeilpos,
                                           arrowshape=str(self.linienbreite+5)+' '+str(self.linienbreite+7)+' '+str(self.linienbreite+2),
                                           state=self.ausgangszustand,
                                           width=linienbreite)
        self.textinhalt=self.canvas.create_text(self.x1+self.xversch,
                                                self.y1+self.yversch,
                                                text=self.fluss,
                                                fill=self.farbe,
                                                font=('helvetica', self.schriftgroesse),
                                                anchor=NW,
                                                justify=LEFT,
                                                state=self.ausgangszustand)

    def zustand_aendern(self, zustand):
        self.zustand=zustand
        self.canvas.itemconfig(self.linie, state=self.zustand)
        self.canvas.itemconfig(self.textinhalt, state=self.zustand)

    def linienbreite_aendern(self, linienbreite):
        self.linienbreite=linienbreite
        self.canvas.itemconfig(self.linie,
                               width=self.linienbreite,
                               arrowshape=str(self.linienbreite+5)+' '+str(self.linienbreite+7)+' '+str(self.linienbreite+2))

    def schriftgroesse_aendern(self, schriftgroesse):
        self.schriftgroesse=str(schriftgroesse)
        self.canvas.itemconfig(self.textinhalt, font=('helvetica', self.schriftgroesse))


#############################################################################
root = Tk()
root.title('Kohlenstoffkreisläufer')
app = Fenster(root)
root.mainloop()
