#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *
import os
import string
import sys
import webbrowser
#import ScrolledText
from tkinter import scrolledtext
sys.path.insert(0, 'daten')
from textdaten import textdaten
textfeld_schriftart='arial'
textfeld_schriftgroesse='10'
textfeld_schrift=textfeld_schriftart+' '+textfeld_schriftgroesse

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame)
        self.frame2=Frame(frame)
        self.frame3=Frame(frame)
        self.frame4=Frame(frame)
        self.frame5=Frame(frame)
        self.frame6=Frame(frame)
        for f, row, rowspan, column, columnspan, sticky in (
                (frame,       0, 1, 0, 1, E+W),
                (self.frame1, 0, 1, 0, 3, E+W),
                (self.frame2, 1, 1, 0, 1, E+W), (self.frame4, 1, 2, 1, 1, E+W), (self.frame5, 1, 2, 2, 1, E+W),
                (self.frame3, 2, 1, 0, 1, E+W), 
                (self.frame6, 3, 1, 0, 2, E+W),
                ):
            f.grid(row=row, rowspan=rowspan, column=column, columnspan=columnspan, sticky=sticky)
        ## Rahmen 1: Auswahl des Katalyse Typs sowie der jeweiligen Beispielreaktion
        self.typ=StringVar()
        self.typ.set('X')
        self.f1r1=Radiobutton(self.frame1, 
                              variable=self.typ,
                              text='Heterogene Katalyse',
                              value='het',
                              command=self.setze_typ,
                              indicatoron=0)
        self.f1r2=Radiobutton(self.frame1, 
                              variable=self.typ,
                              text='Homogene Katalyse',
                              value='hom',
                              command=self.setze_typ,
                              indicatoron=0)
        self.bsp=StringVar()
        self.bsp.set('X')
        self.f1r3=Radiobutton(self.frame1, 
                              variable=self.bsp,
                              text='Zersetzung von Wasserstoffperoxid\n(Mangan(IV)-oxid katalysiert)',
                              value='h2o2mno2',
                              command=self.setze_bsp,
                              anchor=W,
                              justify=LEFT)
        self.f1r4=Radiobutton(self.frame1, 
                              variable=self.bsp,
                              text='Oxidation von Zink mit verdünnter Salzsäure\n(Kupfer katalysiert)',
                              value='znhcl',
                              command=self.setze_bsp,
                              anchor=W,
                              justify=LEFT)
        self.f1r5=Radiobutton(self.frame1, 
                              variable=self.bsp,
                              text='Oxidation von Kohlenstoffmonoxid mit Stickstoffmonoxid\n(Platin katalysiert)',
                              value='cono',
                              command=self.setze_bsp,
                              anchor=W,
                              justify=LEFT)
        self.f1r6=Radiobutton(self.frame1, 
                              variable=self.bsp,
                              text='Zersetzung von Wasserstoffperoxid\n(Eisen(III)-chlorid katalysiert)',
                              value='h2o2fecl3',
                              command=self.setze_bsp,
                              anchor=W,
                              justify=LEFT)
        self.f1r7=Radiobutton(self.frame1, 
                              variable=self.bsp,
                              text='Zersetzung von Harnstoff\n(Urease katalysiert)',
                              value='urea',
                              command=self.setze_bsp,
                              anchor=W,
                              justify=LEFT)
        self.f1r8=Radiobutton(self.frame1, 
                              variable=self.bsp,
                              text='Bromierung von Benzol\n(Eisen(III)-bromid katalysiert)',
                              value='c6h6br2febr3',
                              command=self.setze_bsp,
                              anchor=W,
                              justify=LEFT)
        ## Rahmen 2: Seitenmenü Teilschritte
        self.teilschritt=StringVar()
        self.teilschritt.set('X')
        self.f2r1=Radiobutton(self.frame2, 
                              variable=self.teilschritt,
                              text='Ohne Katalysator',
                              value='ohne',
                              command=self.setze_teilschritt,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        self.f2r2=Radiobutton(self.frame2, 
                              variable=self.teilschritt,
                              text='⁠Ⅰ Beginn eines Katalysezyklus',
                              value='I',
                              command=self.setze_teilschritt,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        self.f2r3=Radiobutton(self.frame2, 
                              variable=self.teilschritt,
                              text='Ⅱ Eigentlicher Reaktionsschritt',
                              value='II',
                              command=self.setze_teilschritt,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        self.f2r4=Radiobutton(self.frame2, 
                              variable=self.teilschritt,
                              text='Ⅲ Ende des Katalysezyklus',
                              value='III',
                              command=self.setze_teilschritt,
                              indicatoron=0,
                              anchor=W,
                              justify=LEFT)
        ## Rahmen 3: Seitenmenü Schema und Diagramm
        self.icon_kreislauf=PhotoImage(file='daten/icons/kreislauf.gif')
        self.f3b1=Button(self.frame3, 
                         text='Katalysezyklus Schema', 
                         command=self.zeige_kreislaufschema,
                         image=self.icon_kreislauf,
                         compound=LEFT)
        self.f3b1.icon_kreislauf=self.icon_kreislauf
        self.icon_diagramm=PhotoImage(file='daten/icons/diagramm.gif')
        self.f3b2=Button(self.frame3, 
                         text='Energiediagramm', 
                         command=self.zeige_energiediagramm,
                         image=self.icon_diagramm,
                         compound=LEFT)
        self.f3b2.icon_diagramm=self.icon_diagramm
        ## Rahmen 4: Beobachtung auf Stoffebene
        self.f4l1=Label(self.frame4, text='Beobachtung:')
        self.f4c1=Canvas(self.frame4, width=200, height=300, bg='white')
        self.bild_stoffebene=PhotoImage(file='daten/img/stoffebene/start.gif')
        self.f4c1.create_image(0, 0, image=self.bild_stoffebene, anchor=NW)
        self.f4t1=scrolledtext.ScrolledText(self.frame4, width=20, height=7, wrap=WORD, bg='white')
        ## Rahmen 5: Folgerung auf Teilchenebene
        self.f5l1=Label(self.frame5, text='Folgerung:')
        self.f5c1=Canvas(self.frame5, width=400, height=300, bg='white')
        self.bild_teilchenebene=PhotoImage(file='daten/img/teilchenebene/start.gif')
        self.f5c1.create_image(0, 0, image=self.bild_teilchenebene, anchor=NW)
        self.f5t1=scrolledtext.ScrolledText(self.frame5, width=20, height=7, wrap=WORD, bg='white')
        ## Rahmen 6: Zurücksetzen und Beenden
        self.icon_reset=PhotoImage(file='daten/icons/view-refresh.gif')
        self.f6b1=Button(self.frame6, 
                         text='Zurücksetzen', 
                         command=self.zurueck_setzen,
                         image=self.icon_reset,
                         compound=LEFT)
        self.f6b1.icon_reset=self.icon_reset
        self.icon_exit = PhotoImage(file='daten/icons/dialog-close.gif')
        self.f6b2=Button(self.frame6, 
                         text='Beenden', 
                         command=root.destroy,
                         image=self.icon_exit,
                         compound=LEFT)
        self.f6b2.icon_exit=self.icon_exit
        ## Fensterelemente setzen und anzeigen
        for i, row, rowspan, column, columnspan, sticky in (
                # Rahmen 1
                (self.f1r1, 0, 1, 0, 1, E+W),  (self.f1r2, 0, 1, 1, 1, E+W),
                (self.f1r3, 1, 1, 0, 1, E+W),  (self.f1r6, 1, 1, 1, 1, E+W),
                (self.f1r4, 2, 1, 0, 1, E+W),  (self.f1r7, 2, 1, 1, 1, E+W),
                (self.f1r5, 3, 1, 0, 1, E+W),  (self.f1r8, 3, 1, 1, 1, E+W),
                # Rahmen 2
                (self.f2r1, 0, 1, 0, 1, E+W),
                (self.f2r2, 1, 1, 0, 1, E+W),
                (self.f2r3, 2, 1, 0, 1, E+W),
                (self.f2r4, 3, 1, 0, 1, E+W),
                # Rahmen 3
                (self.f3b1, 0, 1, 0, 1, E+W),
                (self.f3b2, 1, 1, 0, 1, E+W),
                # Rahmen 4
                #(self.f4l1, 0, 1, 0, 1, E+W),
                (self.f4c1, 1, 1, 0, 1, E+W),
                (self.f4t1, 2, 1, 0, 1, E+W),
                # Rahmen 5
                #(self.f5l1, 0, 1, 0, 1, E+W),
                (self.f5c1, 1, 1, 0, 1, E+W),
                (self.f5t1, 2, 1, 0, 1, E+W),
                # Rahmen 6
                (self.f6b1, 0, 1, 0, 1, E+W),  (self.f6b2, 0, 1, 1, 1, E+W),
                ):
            i.grid(row=row, rowspan=rowspan, column=column, columnspan=columnspan, sticky=sticky)
        self.radio_het=(self.f1r3, self.f1r4, self.f1r5)
        self.radio_hom=(self.f1r6, self.f1r7, self.f1r8)
        self.radio_teilschritte=(self.f2r1, self.f2r2, self.f2r3, self.f2r4, self.f3b1, self.f3b2)
        self.beim_start_inaktiv=(
            self.f1r3, self.f1r4, self.f1r5, self.f1r6, self.f1r7, self.f1r8,
            self.f2r1, self.f2r2, self.f2r3, self.f2r4, self.f3b1, self.f3b2,
            self.f4t1, self.f5t1)
        for i in self.beim_start_inaktiv:
            i.config(state=DISABLED)

        ##########  Funktionen  ################################################
    def setze_typ(self):
        typ=str(self.typ.get())
        self.bsp.set('X')
        self.teilschritt.set('X')
        for i in self.radio_teilschritte:
            i.config(state=DISABLED)
        if typ == 'het':
            for i in self.radio_het:
                i.config(state=NORMAL)
            for i in self.radio_hom:
                i.config(state=DISABLED)
            self.f1r3.select()
            self.setze_bsp()
        elif typ == 'hom':
            for i in self.radio_het:
                i.config(state=DISABLED)
            for i in self.radio_hom:
                i.config(state=NORMAL)
            self.f1r6.select()
            self.setze_bsp()
        for i in (self.f4t1, self.f5t1):
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        self.setze_bsp()
        #print('setze_typ', typ)

    def setze_bsp(self):
        typ=str(self.typ.get())
        try:
            bsp=str(self.bsp.get())
        except:
            pass
        for i in self.radio_teilschritte:
            i.config(state=NORMAL)
        self.teilschritt.set('X')
        for i in (self.f4t1, self.f5t1):
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        #print('setze_bsp', typ, bsp)
        self.teilschritt.set('ohne')
        self.setze_teilschritt()

    def setze_teilschritt(self):
        typ=str(self.typ.get())
        bsp=str(self.bsp.get())
        teilschritt=str(self.teilschritt.get())
        # Bilder einfügen
        for i in self.f4c1.find_all():
            self.f4c1.delete(i)
        bildpfad_stoffebene='daten/img/stoffebene/'+typ+'_'+bsp+'_'+teilschritt+'.gif'
        self.bild_stoffebene=PhotoImage(file=bildpfad_stoffebene)
        self.f4c1.create_image(0, 0, image=self.bild_stoffebene, anchor=NW)
        self.f4c1.config(background='white')
        self.f4c1.update()
        for i in self.f5c1.find_all():
            self.f5c1.delete(i)
        bildpfad_teilchenebene='daten/img/teilchenebene/'+typ+'_'+bsp+'_'+teilschritt+'.gif'
        self.bild_teilchenebene=PhotoImage(file=bildpfad_teilchenebene)
        self.f5c1.create_image(0, 0, image=self.bild_teilchenebene, anchor=NW)
        self.f5c1.config(background='white')
        self.f5c1.update()
        ## Text einfügen
        schluessel=typ+'_'+bsp+'_'+teilschritt
        text_stoffebene=textdaten[schluessel]['stoffebene']
        text_teilchenebene=textdaten[schluessel]['teilchenebene']
        for i, text in ((self.f4t1, text_stoffebene),
                        (self.f5t1, text_teilchenebene)):
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.insert(0.0, text)
            i.config(state=DISABLED)
        #print('setze_teilschritt')

    def zeige_kreislaufschema(self):
        typ=str(self.typ.get())
        bsp=str(self.bsp.get())
        bildpfad='daten/img/katalysezyklus/katalysezyklus_'+bsp+'.gif'
        self.zeige_bilddatei(bildpfad)
        #print('zeige_kreislaufschema', bildpfad)

    def zeige_energiediagramm(self):
        typ=str(self.typ.get())
        bsp=str(self.bsp.get())
        bildpfad='daten/img/energiediagramm/energiediagramm_'+typ+'.gif'
        self.zeige_bilddatei(bildpfad)
        #print('zeige_energiediagramm', bildpfad)

    def zeige_bilddatei(self, bildpfad):
        voller_pfad='file://'+os.getcwd()+'/'+bildpfad
        try:
            webbrowser.open(voller_pfad, autoraise=0)
        except:
            pass

    def zurueck_setzen(self):
        self.typ.set('X')
        self.bsp.set('X')
        self.teilschritt.set('X')
        for i in self.beim_start_inaktiv:
            i.config(state=DISABLED)
        # Bilder einfügen
        for i in self.f4c1.find_all():
            self.f4c1.delete(i)
        bildpfad_stoffebene='daten/img/stoffebene/start.gif'
        self.bild_stoffebene=PhotoImage(file=bildpfad_stoffebene)
        self.f4c1.create_image(0, 0, image=self.bild_stoffebene, anchor=NW)
        self.f4c1.config(background='white')
        self.f4c1.update()
        for i in self.f5c1.find_all():
            self.f5c1.delete(i)
        bildpfad_teilchenebene='daten/img/teilchenebene/start.gif'
        self.bild_teilchenebene=PhotoImage(file=bildpfad_teilchenebene)
        self.f5c1.create_image(0, 0, image=self.bild_teilchenebene, anchor=NW)
        self.f5c1.config(background='white')
        self.f5c1.update()
        for i in (self.f4t1, self.f5t1):
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        #print('zurueck_setzen')

################################################################################
root = Tk()
root.title('Katalyser')
root.option_add('*Text.Font', textfeld_schrift)
app = Fenster(root)
root.mainloop()
