#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, bd=2, padx=8)
        self.frame2=Frame(frame, bd=8, padx=8, width=200, height=400)
        self.frame3=Frame(frame)
        self.frame4=Frame(frame)
        for f, row, column, columnspan in ((frame,       0, 0, 1),
                                           (self.frame1, 1, 0, 1),
                                           (self.frame2, 2, 0, 1),
                                           (self.frame3, 3, 0, 1),
                                           (self.frame4, 4, 0, 1)):
            f.grid(row=row, column=column, columnspan=columnspan)
        
        self.hexosen={
            'aldose':{
                'rererere':'D-Allose',
                'lirerere':'D-Altrose',
                'relirere':'D-Glucose',
                'lilirere':'D-Mannose',
                'rerelire':'D-Gulose',
                'lirelire':'D-Idose',
                'relilire':'D-Galactose',
                'lililire':'D-Talose',
                'lililili':'L-Allose',
                'relilili':'L-Altrose',
                'lirelili':'L-Glucose',
                'rerelili':'L-Mannose',
                'lilireli':'L-Gulose',
                'relireli':'L-Idose',
                'lirereli':'L-Galactose',
                'rerereli':'L-Talose'},
            'ketose':{
                'rerere':'D-Psicose',
                'lirere':'D-Fructose',
                'relire':'D-Sorbose',
                'lilire':'D-Tagatose',
                'lilili':'L-Psicose',
                'relili':'L-Fructose',
                'lireli':'L-Sorbose',
                'rereli':'L-Tagatose'}
        }
        
        global carbonyltyp
        carbonyltyp = StringVar()
        carbonyltyp.set('X')
        # Frame 1: Auswahl
        # Auswahl 1: Aldose oder Ketose
        self.a1l1=Label(self.frame1, 
                        anchor=E,
                        text='1. Carbonylverbindungstyp')
        self.a1r1=Radiobutton(self.frame1, 
                                 text='Aldose',
                                 variable=carbonyltyp, 
                                 value='aldose',
                                 indicatoron=0, 
                                 command=self.carbonyltyp_bestimmen)
        self.a1r2=Radiobutton(self.frame1, 
                                 text='Ketose',
                                 variable=carbonyltyp, 
                                 value='ketose',
                                 indicatoron=0, 
                                 command=self.carbonyltyp_bestimmen)
        self.a2l1=Label(self.frame1, 
                        anchor=E, 
                        text='2. Stellung der OH-Gruppen')
        for f, row, column, columnspan, sticky in (
                (self.a1l1, 0, 0, 6, E+W),
                (self.a1r1, 1, 0, 3, E+W),
                (self.a1r2, 1, 3, 3, E+W),
                (self.a2l1, 2, 0, 6, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)
        
        # Frame 2:  
        # Auswahl 2: Stellung der OH-Gruppe an C1 bis C5
        self.l3=Label(self.frame2, text='C')
        self.l6=Label(self.frame2, text='|')
        self.l9=Label(self.frame2, text='C')
        self.l12=Label(self.frame2, text='|')
        self.l14=Label(self.frame2, text=' – ')
        self.l15=Label(self.frame2, text='C')
        self.l16=Label(self.frame2, text=' – ')
        self.l18=Label(self.frame2, text='|')
        self.l20=Label(self.frame2, text=' – ')
        self.l21=Label(self.frame2, text='C')
        self.l22=Label(self.frame2, text=' – ')
        self.l24=Label(self.frame2, text='|')
        self.l26=Label(self.frame2, text=' – ')
        self.l27=Label(self.frame2, text='C')
        self.l28=Label(self.frame2, text=' – ')
        self.l30=Label(self.frame2, text='|')
        self.l31=Label(self.frame2, text='CH₂OH')
        for f, row, column, columnspan in ((self.l3,  2, 2, 1),
                                           (self.l6,  3, 2, 1),
                                           (self.l9,  4, 2, 1),
                                           (self.l12, 5, 2, 1),
                                           (self.l14, 6, 1, 1),
                                           (self.l15, 6, 2, 1),
                                           (self.l16, 6, 3, 1),
                                           (self.l18, 7, 2, 1),
                                           (self.l20, 8, 1, 1),
                                           (self.l21, 8, 2, 1),
                                           (self.l22, 8, 3, 1),
                                           (self.l24, 9, 2, 1),
                                           (self.l26, 10, 1, 1),
                                           (self.l27, 10, 2, 1),
                                           (self.l28, 10, 3, 1),
                                           (self.l30, 11, 2, 1),
                                           (self.l31, 12, 2, 2)):
            f.grid(row=row, column=column, columnspan=columnspan)

        # Frame 3: Ausgabe des Stoffnamens
        self.f3l1=Label(self.frame3, text='Name des Monosaccharids:')
        self.f3e1=Entry(self.frame3, width=20, bg='white')
        for i, row, column in ((self.f3l1, 0, 0),
                               (self.f3e1, 0, 1)):
            i.grid(row=row, column=column)
        
        # Frame 4: Navigationsköpfe
        self.b1=Button(self.frame4, 
                       text='Name ermitteln',
                       command=self.name_ermitteln)
        self.b2=Button(self.frame4, 
                       text='Zurücksetzen',
                       state=DISABLED,
                       command=self.zuruecksetzen)
        self.b3=Button(self.frame4, 
                       text='Beenden',
                       command=root.destroy)
        for i , row, column in ((self.b1, 0, 0),
                                (self.b2, 0, 1),
                                (self.b3, 0, 2)):
            i.grid(row=row, column=column)
        ########################################################################

    def create_aldose(self):
        self.l1=Label(self.frame2, text='/O\\')
        self.l2=Label(self.frame2, text='||')
        self.l4=Label(self.frame2, text=' – ')
        self.l5=Label(self.frame2, text='H')
        self.l8=Label(self.frame2, text=' – ')
        self.l10=Label(self.frame2, text=' – ')
        for f, row, column, columnspan in((self.l1,   0, 2, 1),
                                          (self.l2,   1, 2, 1),
                                          (self.l4,   2, 3, 1),
                                          (self.l5,   2, 4, 1),
                                          (self.l8,   4, 1, 1),
                                          (self.l10,  4, 3, 1)):
            f.grid(row=row, column=column, columnspan=columnspan)

    def create_ketose(self):
        self.l3.config(text='CH₂OH')
        self.l10=Label(self.frame2, text=' = ')
        self.l11a=Label(self.frame2, text='_')
        self.l11=Label(self.frame2, text='O')
        self.l11b=Label(self.frame2, text='¯')
        for f, row, column, columnspan in((self.l3,   2, 2, 2),
                                          (self.l10,  4, 3, 1),
                                          (self.l11a, 3, 4, 1),
                                          (self.l11,  4, 4, 1),
                                          (self.l11b, 5, 4, 1)):
            f.grid(row=row, column=column, columnspan=columnspan)

    def create_auswahl2_aldose(self):
        global c2
        c2 = StringVar()
        c2.set('X')
        self.a2r2li=Radiobutton(self.frame2, 
                                 text='links',
                                 variable=c2, 
                                 value='li',
                                 indicatoron=0, 
                                 command=self.c2_bestimmen)
        self.a2r2re=Radiobutton(self.frame2, 
                                 text='rechts',
                                 variable=c2, 
                                 value='re',
                                 indicatoron=0, 
                                 command=self.c2_bestimmen)
        global c3
        c3 = StringVar()
        c3.set('X')
        self.a2r3li=Radiobutton(self.frame2, 
                                 text='links',
                                 variable=c3, 
                                 value='li',
                                 indicatoron=0, 
                                 command=self.c3_bestimmen)
        self.a2r3re=Radiobutton(self.frame2, 
                                 text='rechts',
                                 variable=c3, 
                                 value='re',
                                 indicatoron=0, 
                                 command=self.c3_bestimmen)
        global c4
        c4 = StringVar()
        c4.set('X')
        self.a2r4li=Radiobutton(self.frame2, 
                                 text='links',
                                 variable=c4, 
                                 value='li',
                                 indicatoron=0, 
                                 command=self.c4_bestimmen)
        self.a2r4re=Radiobutton(self.frame2, 
                                 text='rechts',
                                 variable=c4, 
                                 value='re',
                                 indicatoron=0, 
                                 command=self.c4_bestimmen)
        global c5
        c5 = StringVar()
        c5.set('X')
        self.a2r5li=Radiobutton(self.frame2, 
                                 text='links',
                                 variable=c5, 
                                 value='li',
                                 indicatoron=0, 
                                 command=self.c5_bestimmen)
        self.a2r5re=Radiobutton(self.frame2, 
                                 text='rechts',
                                 variable=c5, 
                                 value='re',
                                 indicatoron=0, 
                                 command=self.c5_bestimmen)
        for f, row, column, columnspan in((self.a2r2li,  4, 0, 1),
                                          (self.a2r2re,  4, 4, 1),
                                          (self.a2r3li,  6, 0, 1),
                                          (self.a2r3re,  6, 4, 1),
                                          (self.a2r4li,  8, 0, 1),
                                          (self.a2r4re,  8, 4, 1),
                                          (self.a2r5li, 10, 0, 1),
                                          (self.a2r5re, 10, 4, 1)):
            f.grid(row=row, column=column, columnspan=columnspan)
        c2.set('re')
        c3.set('li')
        c4.set('re')
        c5.set('re')
        self.c2_bestimmen()
        self.c3_bestimmen()
        self.c4_bestimmen()
        self.c5_bestimmen()
        
    def create_auswahl2_ketose(self):
        global c3
        c3 = StringVar()
        c3.set('X')
        self.a2r3li=Radiobutton(self.frame2, 
                                 text='links',
                                 variable=c3, 
                                 value='li',
                                 indicatoron=0, 
                                 command=self.c3_bestimmen)
        self.a2r3re=Radiobutton(self.frame2, 
                                 text='rechts',
                                 variable=c3, 
                                 value='re',
                                 indicatoron=0, 
                                 command=self.c3_bestimmen)
        global c4
        c4 = StringVar()
        c4.set('X')
        self.a2r4li=Radiobutton(self.frame2, 
                                 text='links',
                                 variable=c4, 
                                 value='li',
                                 indicatoron=0, 
                                 command=self.c4_bestimmen)
        self.a2r4re=Radiobutton(self.frame2, 
                                 text='rechts',
                                 variable=c4, 
                                 value='re',
                                 indicatoron=0, 
                                 command=self.c4_bestimmen)
        global c5
        c5 = StringVar()
        c5.set('X')
        self.a2r5li=Radiobutton(self.frame2, 
                                 text='links',
                                 variable=c5, 
                                 value='li',
                                 indicatoron=0, 
                                 command=self.c5_bestimmen)
        self.a2r5re=Radiobutton(self.frame2, 
                                 text='rechts',
                                 variable=c5, 
                                 value='re',
                                 indicatoron=0, 
                                 command=self.c5_bestimmen)
        for f, row, column, columnspan in((self.a2r3li,  6, 0, 1),
                                          (self.a2r3re,  6, 4, 1),
                                          (self.a2r4li,  8, 0, 1),
                                          (self.a2r4re,  8, 4, 1),
                                          (self.a2r5li, 10, 0, 1),
                                          (self.a2r5re, 10, 4, 1)):
            f.grid(row=row, column=column, columnspan=columnspan)
        c3.set('li')
        c4.set('re')
        c5.set('re')
        self.c3_bestimmen()
        self.c4_bestimmen()
        self.c5_bestimmen()

    def carbonyltyp_bestimmen(self):
        self.carbonyltyp = carbonyltyp.get()
        #print self.carbonyltyp
        if self.carbonyltyp == 'aldose':
            self.create_aldose()
            self.create_auswahl2_aldose()
            self.a1r1.config(state=DISABLED)
            self.a1r2.config(state=DISABLED)
        elif self.carbonyltyp == 'ketose':
            self.create_ketose()
            self.create_auswahl2_ketose()
            self.a1r1.config(state=DISABLED)
            self.a1r2.config(state=DISABLED)
        self.b2.config(state=NORMAL)

    def c2_bestimmen(self):
        self.c2 = c2.get()
        #print self.c2
        self.name_ermitteln()
        if self.c2 == 're':
            self.a2r2li.config(text='H')
            self.a2r2re.config(text='OH')
        elif self.c2 == 'li':
            self.a2r2li.config(text='HO')
            self.a2r2re.config(text='H')

    def c3_bestimmen(self):
        self.c3 = c3.get()
        #print self.c3
        self.name_ermitteln()
        if self.c3 == 're':
            self.a2r3li.config(text='H')
            self.a2r3re.config(text='OH')
        elif self.c3 == 'li':
            self.a2r3li.config(text='HO')
            self.a2r3re.config(text='H')

    def c4_bestimmen(self):
        self.c4 = c4.get()
        #print self.c4
        self.name_ermitteln()
        if self.c4 == 're':
            self.a2r4li.config(text='H')
            self.a2r4re.config(text='OH')
        elif self.c4 == 'li':
            self.a2r4li.config(text='HO')
            self.a2r4re.config(text='H')

    def c5_bestimmen(self):
        self.c5 = c5.get()
        #print self.c5
        self.name_ermitteln()
        if self.c5 == 're':
            self.a2r5li.config(text='H')
            self.a2r5re.config(text='OH')
        elif self.c5 == 'li':
            self.a2r5li.config(text='HO')
            self.a2r5re.config(text='H')

    def name_ermitteln(self):
        self.f3e1.delete(0, END)
        self.carbonyltyp=carbonyltyp.get()
        self.c2=c2.get()
        self.c3=c3.get()
        self.c4=c4.get()
        self.c5=c5.get()
        if self.carbonyltyp == 'aldose':
            stoffname=str(self.hexosen[self.carbonyltyp][self.c2+self.c3+self.c4+self.c5])
        elif self.carbonyltyp == 'ketose':
            stoffname=str(self.hexosen[self.carbonyltyp][self.c3+self.c4+self.c5])
        self.f3e1.insert(0, stoffname)

    def zuruecksetzen(self):
        #print('zuruecksetzen')
        self.carbonyltyp = carbonyltyp.get()
        if self.carbonyltyp == 'aldose':
            for w in (self.l1,      self.l2,       self.l4,     self.l5, 
                      self.l8,      self.l10,      self.a2r2li, 
                      self.a2r2re,  self.a2r3li,   self.a2r3re, self.a2r4li, 
                      self.a2r4re,  self.a2r5li,   self.a2r5re, self.a2r3li, 
                      self.a2r3re,  self.a2r4li,   self.a2r4re, self.a2r5li, 
                      self.a2r5re):
                w.destroy()
        elif self.carbonyltyp == 'ketose':
            for w in (    self.l10,      self.l11a,   self.l11, 
                      self.l11b,    self.a2r3re, self.a2r4li, 
                      self.a2r4re,  self.a2r5li,   self.a2r5re, self.a2r3li, 
                      self.a2r3re,  self.a2r4li,   self.a2r4re, self.a2r5li, 
                      self.a2r5re):
                w.destroy()
            self.l3.config(text='C')
            self.l3.grid(row=2, column=2, columnspan=1)
        self.a1r1.config(state=NORMAL)
        self.a1r2.config(state=NORMAL)
        carbonyltyp.set('X')
        self.b2.config(state=DISABLED)
        c2.set('X')
        c3.set('X')
        c4.set('X')
        c5.set('X')
        self.f3e1.delete(0, END)

################################################################################
root = Tk()
root.title('Hexoser')
app = Fenster(root)
root.mainloop()
