#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
import random

class NO2_Teilchen:
    def __init__(self, canvas, x1, y1):
        self.canvas=canvas
        self.x1_N1=x1
        self.y1_N1=y1
        # O-Atom Nr. 1
        self.x1_O1=self.x1_N1+12
        self.y1_O1=self.y1_N1+3
        self.x2_O1=self.x1_O1+17
        self.y2_O1=self.y1_O1+17
        self.canvas.create_oval(self.x1_O1, self.y1_O1, self.x2_O1, self.y2_O1,
                                fill='#808000000000')
        # N-Atom Nr. 1
        self.x2_N1=self.x1_N1+20
        self.y2_N1=self.y1_N1+20
        self.canvas.create_oval(self.x1_N1, self.y1_N1, self.x2_N1, self.y2_N1,
                                fill='#808000000000')
        # O-Atom Nr. 2
        self.x1_O2=self.x1_N1+5
        self.y1_O2=self.y1_N1+10
        self.x2_O2=self.x1_O2+17
        self.y2_O2=self.y1_O2+17
        self.canvas.create_oval(self.x1_O2, self.y1_O2, self.x2_O2, self.y2_O2,
                                fill='#808000000000')

class N2O4_Teilchen:
    def __init__(self, canvas, x1, y1):
        self.canvas=canvas
        self.x1_N1=x1
        self.y1_N1=y1
        # O-Atom Nr. 1
        self.x1_O1=self.x1_N1-12
        self.y1_O1=self.y1_N1+3
        self.x2_O1=self.x1_O1+17
        self.y2_O1=self.y1_O1+17
        self.canvas.create_oval(self.x1_O1, self.y1_O1, self.x2_O1, self.y2_O1,
                                fill='#FAFAF0F0E6E6')
        # N-Atom Nr. 1
        self.x2_N1=self.x1_N1+20
        self.y2_N1=self.y1_N1+20
        self.canvas.create_oval(self.x1_N1, self.y1_N1, self.x2_N1, self.y2_N1,
                                fill='#FAFAF0F0E6E6')
        # O-Atom Nr. 2
        self.x1_O2=self.x1_N1-5
        self.y1_O2=self.y1_N1-10
        self.x2_O2=self.x1_O2+17
        self.y2_O2=self.y1_O2+17
        self.canvas.create_oval(self.x1_O2, self.y1_O2, self.x2_O2, self.y2_O2,
                                fill='#FAFAF0F0E6E6')
        # O-Atom Nr. 3
        self.x1_O3=self.x1_N1+22
        self.y1_O3=self.y1_N1+12
        self.x2_O3=self.x1_O3+17
        self.y2_O3=self.y1_O3+17
        self.canvas.create_oval(self.x1_O3, self.y1_O3, self.x2_O3, self.y2_O3,
                                fill='#FAFAF0F0E6E6')
        # N-Atom Nr. 2
        self.x1_N2=self.x1_N1+10
        self.y1_N2=self.y1_N1+10
        self.x2_N2=self.x1_N2+20
        self.y2_N2=self.y1_N2+20
        self.canvas.create_oval(self.x1_N2, self.y1_N2, self.x2_N2, self.y2_N2,
                                fill='#FAFAF0F0E6E6')
        # O-Atom Nr. 4
        self.x1_O4=self.x1_N1+12
        self.y1_O4=self.y1_N1+22
        self.x2_O4=self.x1_O4+17
        self.y2_O4=self.y1_O4+17
        self.canvas.create_oval(self.x1_O4, self.y1_O4, self.x2_O4, self.y2_O4,
                                fill='#FAFAF0F0E6E6')



class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=4)
        self.frame2=Frame(frame, pady=4, padx=4)
        self.frame3=Frame(frame, pady=4, padx=4)
        self.frame4=Frame(frame, pady=4, padx=4)
        self.frame5=Frame(frame, pady=4, padx=4)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 1, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 2, 0, 1, E+W),
                (self.frame4, 3, 0, 1, E+W),
                (self.frame5, 4, 0, 1, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        ## Werte
        self.NO2={
            0:(0,       '#FAFAF0F0E6E6'),
            10:(4,      '#F1F1DEDED4D4'),
            20:(8,      '#E7E7CBCBC3C3'),
            30:(20,     '#DEDEB9B9B1B1'),
            40:(24,     '#D4D4A6A69F9F'),
            50:(40,     '#CBCB94948E8E'),
            60:(50,     '#C2C281817C7C'),
            70:(72,     '#B8B86F6F6A6A'),
            80:(78,     '#AFAf5C5C5858'),
            90:(82,     '#A6A64A4A4747'),
            100:(90,    '#9C9C37373535'),
            110:(96,    '#939325252323'),
            120:(98,    '#898912121212'),
            130:(100,   '#808000000000')
        }
        self.T=0

        # Rahmen 1: Zeichenfläche des Gefäßes und der Teilchen
        self.f1l1=Label(self.frame1, text='Farbe eines Gefäßes \nmit NO₂/N₂O₄-Gemisch:')
        self.canvas1=Canvas(self.frame1, bg='white', width=200, height=300)
        self.rect1=self.canvas1.create_rectangle(20,  20,   180, 280, width=2.5)
        self.f1l2=Label(self.frame1, text='Vergrößerte Teilchendarstellung:')
        self.canvas2=Canvas(self.frame1, bg='white', width=600, height=600)
        self.rect2=self.canvas2.create_rectangle(20,  20,   580, 580, width=2.5)
        # Rahmen 2: Schieberegler Temperatur
        self.label1=Label(self.frame2, text='Temperatur in °C:', anchor=SE, justify=RIGHT)
        self.scale1=Scale(self.frame2, length=600, from_=0, to=130, resolution=10, 
                          showvalue=1, orient=HORIZONTAL, 
                          command=self.werte_fuer_temp_ermitteln)
        self.scale1.set(20)
        # Rahmen 3: Zahlenwerte Teilchenverhältnis
        self.f3l1=Label(self.frame3, text='Anteil NO₂ (in Massen-%):', anchor=SE, justify=RIGHT)
        self.f3e1=Entry(self.frame3, width=4, 
                        disabledbackground='#808000000000', 
                        disabledforeground='white', 
                        justify=RIGHT,
                        state=DISABLED)
        self.f3l2=Label(self.frame3, text='Anteil N₂O₄ (in Massen-%):', anchor=SE, justify=RIGHT)
        self.f3e2=Entry(self.frame3, width=4, 
                        disabledbackground='#FAFAF0F0E6E6', 
                        disabledforeground='black', 
                        justify=RIGHT,
                        state=DISABLED)
        self.f3l3=Label(self.frame3, text='Teilchenanteil NO₂:', anchor=SE, justify=RIGHT)
        self.f3e3=Entry(self.frame3, width=4, 
                        disabledbackground='#808000000000', 
                        disabledforeground='white', 
                        justify=RIGHT,
                        state=DISABLED)
        self.f3l4=Label(self.frame3, text='Teilchenanteil N₂O₄:', anchor=SE, justify=RIGHT)
        self.f3e4=Entry(self.frame3, width=4, 
                        disabledbackground='#FAFAF0F0E6E6', 
                        disabledforeground='black', 
                        justify=RIGHT,
                        state=DISABLED)
        # Rahmen 5: Beenden-Knopf
        self.button1=Button(self.frame5, text='Zurücksetzen', command=self.zurueck_setzen)
        self.button2=Button(self.frame5, text='Beenden', command=root.destroy)

        for i, row, columnspan, column, sticky in (
                (self.f1l1,                     0, 1, 0, E+W), 
                (self.f1l2,                     0, 1, 1, E+W), 
                (self.canvas1,                  1, 1, 0, E+W), 
                (self.canvas2,                  1, 1, 1, E+W), 
                (self.label1,                   0, 1, 0, E+W),
                (self.scale1,                   0, 1, 1, E+W),
                (self.f3l1,                     0, 1, 0, E+W), 
                (self.f3e1,                     0, 1, 1, E+W), 
                (self.f3l2,                     1, 1, 0, E+W), 
                (self.f3e2,                     1, 1, 1, E+W), 
                (self.f3l3,                     0, 1, 2, E+W), 
                (self.f3e3,                     0, 1, 3, E+W), 
                (self.f3l4,                     1, 1, 2, E+W), 
                (self.f3e4,                     1, 1, 3, E+W), 
                (self.button1,                  0, 1, 0, E+W),
                (self.button2,                  0, 1, 1, E+W) ):
            i.grid(row=row, columnspan=columnspan, column=column)
        
    def werte_fuer_temp_ermitteln(self, a):
        self.T=self.scale1.get()
        self.NO2_akt=int(self.NO2[self.T][0])
        self.N2O4=int(50-self.NO2_akt/2)
        # Werte anzeigen
        for i, state, text in (
                (self.f3e1, NORMAL, str(self.NO2_akt)),
                (self.f3e2, NORMAL, str(2*self.N2O4)),
                (self.f3e3, NORMAL, str(self.NO2_akt)),
                (self.f3e4, NORMAL, str(self.N2O4))):
            i.config(state=state)
            i.delete(0, END)
            i.insert(0, text)
            i.config(state=DISABLED)
        # Gefäßfarbe anzeigen
        self.gefaess_farbe_hex=self.NO2[self.T][1]
        self.rect1=self.canvas1.create_rectangle(20,  20,   180, 280, 
                                                 width=2.5, 
                                                 fill=self.gefaess_farbe_hex)
        # Teilchen anzeigen
        # Variante 1: komplette Leichwand löschen
        #self.canvas2.destroy()
        #self.canvas2=Canvas(self.frame1, bg='white', width=600, height=600)
        #self.canvas2.grid(row=1, rowspan=1, column=1, sticky=E+W)
        # Variante 2: Alle Zeichenobjekte suchen und nur diese löschen
        for i in self.canvas2.find_all():
            self.canvas2.delete(i)
        # Rahmen bei beiden Varianten neu zeichnen
        self.rect2=self.canvas2.create_rectangle(20,  20,   580, 580, width=2.5)
        for i in range(0, self.NO2_akt):
            x1=random.randint(40, 520)
            y1=random.randint(40, 520)
            self.i=NO2_Teilchen(self.canvas2, x1, y1)
        for j in range(0, int(self.N2O4)):
            x1=random.randint(40, 520)
            y1=random.randint(40, 520)
            self.j=N2O4_Teilchen(self.canvas2, x1, y1)
        # Leinwand updaten
        self.canvas2.config(background='white')
        self.canvas2.update()
    
    def zurueck_setzen(self):
        self.scale1.set(20)
    
################################################################################
root = Tk()
root.title('Gleichgewichttemperaturer')
app = Fenster(root)
root.mainloop()
