#!/usr/bin/env python3
# -*- encoding:utf-8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *
from tkinter import scrolledtext
from tkinter import font
#import ScrolledText
#import tkFont
import os
import random

class Fenster:

    def __init__(self, master):
        frame = Frame(master)
        frame.pack()
        # GIFs vorher Encodieren mit:
        # print(open('bildname.gif', 'rb').read().encode('base64'))
        icon_zurueck='''\
R0lGODlhEAAQAOcGAAolWAwsYVyEvWOEpGqVxurx+P///0ZlmlBxqVt/shs6ayZGeSxOhTxckhEx
Xg0uXAgePSZcrCZdrgkgQxMxYCVaqSVaqhg7cAskSSVZqCRZqRtEgAwoUCNVoSJXpSFPlCZbqggd
Pg8sWCZaqqvD5q/F5SNWoitKdCxLdCJVohY2ZwsjRitboS5fpwgeQBg9cxo1XnibzwgeQAgiRwkm
TwsqVw4rWA4vYBAzaRExYRI5cRQ9eRU3ZBdCghg5axlGihs+bRxMkyFSnSNGeSROfSlKfStQgy1M
ey5ShS5XiDFPezJcmTVSeTZZjDdgkzlekkFurENonURpoERqnk1sk01zqU91r1d9tFd+rliDulmB
u1qFuVt4mFuBuF2Bs1+EvGGGvmKDqGKKw2ODrGaDo2iNw2mQyWyYzG6Sxm+MtHCQsXGVy3OZz3SW
wXebz3ubv3yu4H2Rr3+duIGl2IKkzoSlyoSo24WjwImox4mqz4ms4Iqs1Yysy42w446x5I+w1I+w
25Gwz5G01JKhtZOwyJSzy5WzzZfB8Zi+75m40Jm40pq+76XD2KjG2rG5xsPh8NPX3v//////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////yH5BAEKAP8ALAAAAAAQABAA
AAiuAP8JHEiwoMGD/0CMEFgiBgmEKbIIEVgGkpmDLQQ9CiLwiyMxBT1AUcSo0Q+BVwZpIWgCC6FC
hhL1EFgljpWBLMLIuYOHT6AdAqekkfKvwxIuZNS8qZPnjw6BTrY8+ffBCBMqY9rQ2QMIh8AkZ5AM
fFEkSpc1dvzcEEgEzhCCKpqAcdNnUQ2BQBD5KCjiCJo5emgI5HEox0EYXtjMEIjCxgmEK5TIQGgw
hAvKCAMCADs=
'''
        icon_naechster='''\
R0lGODlhEAAQAMZPAAcdOwkdPwgfQQskRwskSQ0oUA8tWBIvXBIxYBk1XhQ2aBc2ahY6cBg/eBtB
eRtDgB1FgB1Ihx9JiSpKeB9Mjx9NjyxOgCFRlzJTgiRVniNWniVWoyRXpSdYoidZoDxXfThbjzBc
njlckjxfkzZjo0luo09wnE11qlB2rFR6sV2CuV2DuVyEtGOHsmaHsGOIvWSJv2WJvWaLwWuLu2yM
sWuPxWuQxW+SxnCUyXiYv3ebz3ec0ICfv36fxX+hxoCix4WkxIGl2YinyIiox4moyYSo25KxzZSz
zpSzz5G05pW20Zy71KPC2aTC2rbW6f//////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////yH5
BAEKAH8ALAAAAAAQABAAAAdugH+Cg4SFhBkchop/Fywdi4UUTkokkIMRTE1LJxuWD0dIR0YtHpAN
Q0RCQDw0IYsMPj89OS4mGBIahgoxLyopJSMWEBWGCDU2MisoIg6LBjs6ODAgC5AFRUE3EweWBEkz
CZaCAh8D4oIBAOfrgoEAOw==
'''
        icon_beenden='''\
R0lGODlhEAAQAOePAIsAAI0AAI4AAI8AAJIAAJUAAJkAAJoAAJQCAp4AAKAAAKYAAKcAAKgAAKsA
AKwAAK0AAKcCAK8AALAAALEAAKsCALIAAKcDA7MAALQAAK4CALUAALYAAK8DAroAAJkJCbsAAKcG
ALwAALMDAL8AAMAAALsCAKUJALcEAKULAKwLALkJALEQAL4NAKoTAKsREb8NAL0QALkQEL0RALMV
AKwbAcIWAKodHcUgDLMsALgpKcsvAMcxALg2ALE2Fbk3ALA1Nbc1NaVABbs+AL44N9BBANFCALVJ
ErdERNFEB8BKANJFAMFLAL9NBcxKANJKAMpIQrFYEsJUEMZVEcFcANFZAM1UVK1iMs9YOtZcAM5h
ANpfAL5kP8VgYLtoMs5pAMluBcdlZdRsAMxtYtR8AMR5WNx4YNt8X9F/btp9etCCZtuBgdyBgbaN
f9+EhMyLeNSIiNSLd+GHhNuJid6JgsSSeeGKhOGLg8ySf9qXXOKams2kd9qqc+enp+inp9y1ste4
sNO+ueHHrebGrefKuOPTzejWzera1O7b1vLb2/bl4vTu7fbw7ffx7vnz8f//////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////yH5BAEKAP8ALAAAAAAQABAA
AAjWAP8JHEiwYEEACIB0CYPkQwCD/wTcmNPHj0U9QQgUDPAiDZ07duS4WcNGh8aBCaCgURTnjJkx
ieBYuQBA4IAOWPA8clSGC6JHf4jIKCDQwIokU+o8anToESAfOEwoEKggxpItVNo8ehRIyJMdMBgI
XNCiSJYohbYuulLFiI0HAhug4HHE0CNBex4x8uJkBgSqFGi8eTQIDBk+jwj9GOFg4AYNNdQ00SLm
Sx4pLDIQNOChgoscQ5Qw6aGCw4SCB0pYiHAiRQgJJChA/OfAAwgPIjDM3k0wIAA7
'''
        self.originalmenge=(
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E'
        )
        self.teilchenmenge=[
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
            'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E'
        ]
        self.zyklusnummer=0
        self.fonts = {'Beschriftung':('Arial', 11),
                      'FesteBreite':('Monospace', '16')}
        self.frame1=Frame(frame, padx=2, pady=2)
        self.f1l1=Label(self.frame1,
                        text='Teilchenübersicht:\nE=Edukt, P=Produkt',
                        justify=LEFT,
                        font=self.fonts['Beschriftung'])
        self.f1t1=Text(self.frame1,
                       width=21,
                       height=10,
                       background='black',
                       foreground='#0f0',
                       font=self.fonts['FesteBreite'],
                       state=DISABLED)
        self.f1l2=Label(self.frame1,
                        text='Edukt-Teilchenanteil:',
                        justify=LEFT,
                        font=self.fonts['Beschriftung'])
        self.f1e1=Entry(self.frame1,
                        width="4",
                        font=self.fonts['Beschriftung'],
                        state=DISABLED,
                        justify=RIGHT)
        self.f1l3=Label(self.frame1,
                        text='Produkt-Teilchenanteil:',
                        justify=LEFT,
                        font=self.fonts['Beschriftung'])
        self.f1e2=Entry(self.frame1,
                        width="4",
                        font=self.fonts['Beschriftung'],
                        state=DISABLED,
                        justify=RIGHT)
        self.icon_zurueck=PhotoImage(master=root, data=icon_zurueck)
        self.f1b1=Button(self.frame1, text='Zurücksetzen',
                         command=self.zurueck_setzen,
                         font=self.fonts['Beschriftung'],
                         image=self.icon_zurueck,
                         compound=LEFT)
        self.f1b1.icon_zurueck=self.icon_zurueck
        self.icon_naechster=PhotoImage(master=root, data=icon_naechster)
        self.f1b2=Button(self.frame1, text='Nächster Reaktionszyklus',
                         command=self.naechster_zyklus,
                         font=self.fonts['Beschriftung'],
                         image=self.icon_naechster,
                         compound=LEFT)
        self.f1b1.ico_naechster=self.icon_naechster
        self.icon_beenden=PhotoImage(master=root, data=icon_beenden)
        self.f1b3=Button(self.frame1, text='Beenden',
                         command=root.destroy,
                         font=self.fonts['Beschriftung'],
                         image=self.icon_beenden,
                         compound=LEFT)
        self.f1b1.icon_beenden=self.icon_beenden
        for i, row, column, columnspan, sticky in ((self.frame1, 0, 0, 1, E+W),
                                                   (self.f1l1,   0, 0, 2, W),
                                                   (self.f1t1,   1, 0, 2, W),
                                                   (self.f1l2,   2, 0, 1, E),
                                                   (self.f1e1,   2, 1, 1, W),
                                                   (self.f1l3,   3, 0, 1, E),
                                                   (self.f1e2,   3, 1, 1, W),
                                                   (self.f1b1,   4, 0, 1, E+W),
                                                   (self.f1b2,   4, 1, 1, E+W),
                                                   (self.f1b3,  5, 0, 2, E+W)
                                                   ):
            i.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)
        self.zurueck_setzen()

    def zurueck_setzen(self):
        #print('zurueck_setzen')
        zaehler=0
        teilchenausgabe=''
        for i in self.originalmenge:
            if zaehler in (9, 19, 29, 39, 49, 59, 69, 79, 89):
                teilchenausgabe=teilchenausgabe+' '+i+'\n'
            else:
                teilchenausgabe=teilchenausgabe+' '+i
            zaehler=zaehler+1
        self.f1t1.config(state=NORMAL)
        self.f1t1.delete(0.0, END)
        self.f1t1.insert(0.0, teilchenausgabe)
        self.f1t1.config(state=DISABLED)
        self.f1e1.config(state=NORMAL)
        self.f1e1.delete(0, END)
        self.f1e1.insert(0, '100')
        self.f1e1.config(state=NORMAL)
        self.f1e2.config(state=NORMAL)
        self.f1e2.delete(0, END)
        self.f1e2.insert(0, '0')
        self.f1e2.config(state=NORMAL)
        self.zyklusnummer=0

    def naechster_zyklus(self):
        #print('naechster_zyklus')
        ausgangstext=self.f1t1.get(0.0, END)
        #print(ausgangstext)
        l=[]
        for i in ausgangstext:
            if i == 'E' or i == 'P':
                l.append(i)
        #print(l, type(l))
        self.teilchenmenge=l
        #print(self.teilchenmenge)
        zaehler=0
        teilchenausgabe=''
        m=[]
        self.zyklusnummer=self.zyklusnummer+1
        if self.zyklusnummer == 1:
            for i in self.teilchenmenge:
                zufallszahl=random.randint(0, 10)
                if zufallszahl in (0, 4, 6, 7) and i == 'P':
                    i='E'
                elif zufallszahl in (1, 2, 3, 5, 8, 9):
                    i='P'
                m.append(i)
            #print(m)
            # Anzahl von P in der Liste m ermitteln:
            p=0
            for i in m:
                if i == 'P':
                    p=p+1
            # Anzahl von E in der Liste ermitteln:
            e=100-p
            for i in m:
                if zaehler in (9, 19, 29, 39, 49, 59, 69, 79, 89):
                    teilchenausgabe=teilchenausgabe+' '+i+'\n'
                else:
                    teilchenausgabe=teilchenausgabe+' '+i
                zaehler=zaehler+1
        elif self.zyklusnummer > 1:
            for i in self.teilchenmenge:
                zufallszahl=random.randint(0, 10)
                if zufallszahl in (0, 4, 7) and i == 'P':
                    i='E'
                elif zufallszahl in (1, 2, 3, 5, 6, 8, 9):
                    i='P'
                m.append(i)
            #print(m)
            # Anzahl von P in der Liste m ermitteln:
            p=0
            for i in m:
                if i == 'P':
                    p=p+1
            # Anzahl von E in der Liste ermitteln:
            e=100-p
            for i in m:
                if zaehler in (9, 19, 29, 39, 49, 59, 69, 79, 89):
                    teilchenausgabe=teilchenausgabe+' '+i+'\n'
                else:
                    teilchenausgabe=teilchenausgabe+' '+i
                zaehler=zaehler+1
        self.f1e1.config(state=NORMAL)
        self.f1e1.delete(0, END)
        self.f1e1.insert(0, str(e))
        self.f1e1.config(state=NORMAL)
        self.f1e2.config(state=NORMAL)
        self.f1e2.delete(0, END)
        self.f1e2.insert(0, str(p))
        self.f1e2.config(state=NORMAL)
        self.f1t1.config(state=NORMAL)
        self.f1t1.delete(0.0, END)
        self.f1t1.insert(0.0, teilchenausgabe)
        self.f1t1.config(state=DISABLED)

##############################################################################################
root = Tk()
root.title('Gleichgewichtseinsteller')
app=Fenster(root)
#root.option_add('*Font', 'Arial 12')
root.mainloop()
