#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=4)
        self.frame2=Frame(frame, pady=4, padx=4)
        self.frame3=Frame(frame, pady=4, padx=4)
        self.frame4=Frame(frame, pady=4, padx=4)
        self.frame5=Frame(frame, pady=4, padx=4)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 1, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 2, 0, 1, E+W),
                (self.frame4, 3, 0, 1, E+W),
                (self.frame5, 4, 0, 1, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        ## Startwerte
        # Variabel: Entspricht den Konzentrationen der Ausgangs- und Endstoffe
        self.alte_fuellhoehe_A_0=200
        self.alte_fuellhoehe_B_0=100
        # Variabel: Entspricht dem Verhältnis der Gleichgewichtskonstanten der Hin- und Rückreaktion (je nach gewählter Reaktion)
        self.pipettenbreite_A=10
        self.pipettenbreite_B=5
        # Konstant: Hier vereinfacht für Flächen- statt Volumenberechnung
        global gefaessbreite_A
        global gefaessbreite_B
        gefaessbreite_A=100
        gefaessbreite_B=100

        # Rahmen 1: Zeichenfläche der Gefäße
        self.canvas1=Canvas(self.frame1, bg='white', width=600, height=400)
        
        # Rahmen 2: Schieberegler für die Ausgangsfüllmenge und die Pipettenbreite
        self.scale_ausgangshoehe_A=Scale(self.frame2,
                                         length=200, from_=50, to=300, resolution=20, 
                                         showvalue=1, orient=HORIZONTAL, 
                                         command=self.werte_fuer_schritt_ermitteln)
        self.scale_ausgangshoehe_A.set(200)
        self.scale_pipettenbreite_A=Scale(self.frame2, 
                                          length=80, from_=5, to=20, resolution=5, 
                                          showvalue=1, orient=HORIZONTAL, 
                                          command=self.werte_fuer_schritt_ermitteln)
        self.scale_pipettenbreite_A.set(10)
        self.scale_ausgangshoehe_B=Scale(self.frame2, 
                                         length=200, from_=50, to=300, resolution=20, 
                                         showvalue=1, orient=HORIZONTAL, 
                                         command=self.werte_fuer_schritt_ermitteln)
        self.scale_ausgangshoehe_B.set(100)
        self.scale_pipettenbreite_B=Scale(self.frame2, 
                                          length=80, from_=5, to=20, resolution=5, 
                                          showvalue=1, orient=HORIZONTAL, 
                                          command=self.werte_fuer_schritt_ermitteln)
        self.scale_pipettenbreite_B.set(5)
        self.f2l1=Label(self.frame2, text='Füllhöhe in Gefäß A\n(Konzentration Edukte)')
        self.f2l2=Label(self.frame2, text='Pipetettenbreite\n(Hinreaktion)')
        self.f2l3=Label(self.frame2, text='Füllhöhe in Gefäß B\n(Konzentration Produkte)')
        self.f2l4=Label(self.frame2, text='Pipetettenbreite\n(Rückreaktion)')
        
        # Rahmen 3: Schieberegler für die Schritte
        self.label1=Label(self.frame3, text='Übertragungsschritt Nr.:', anchor=NW, justify=LEFT)
        self.scale1=Scale(self.frame3, length=600, from_=0, to=50, resolution=1, 
                          showvalue=1, orient=HORIZONTAL, 
                          command=self.werte_fuer_schritt_ermitteln)
        for i, row, columnspan, column, sticky in (
                (self.canvas1,                  0, 1, 0, E+W), 
                (self.scale_ausgangshoehe_A,    0, 1, 0, E+W), 
                (self.scale_pipettenbreite_A,   0, 1, 1, E+W),
                (self.scale_ausgangshoehe_B,    0, 1, 2, E+W), 
                (self.scale_pipettenbreite_B,   0, 1, 3, E+W),
                (self.f2l1,                     1, 1, 0, E+W), 
                (self.f2l2,                     1, 1, 1, E+W),
                (self.f2l3,                     1, 1, 2, E+W), 
                (self.f2l4,                     1, 1, 3, E+W),
                # Rahmen 3
                (self.label1, 1, 1, 0, E+W), 
                (self.scale1, 2, 1, 0, E+W)):
            i.grid(row=row, columnspan=columnspan, column=column)

        # Rahmen 4: Werte anzeigen
        self.f4l1=Label(self.frame4, text='Füllhöhe\nin Gefäß A:', anchor=NE, justify=RIGHT)
        self.f4e1=Entry(self.frame4, width=10, disabledbackground='white', disabledforeground='black', state=DISABLED)
        self.f4l2=Label(self.frame4, text='Hinübertragenes\nVolumen:', anchor=NE, justify=RIGHT)
        self.f4e2=Entry(self.frame4, width=10, disabledbackground='blue', disabledforeground='white', state=DISABLED)
        self.f4l3=Label(self.frame4, text='Rückübertragenes\nVolumen:', anchor=NE, justify=RIGHT)
        self.f4e3=Entry(self.frame4, width=10, disabledbackground='darkgreen', disabledforeground='white', state=DISABLED)
        self.f4l4=Label(self.frame4, text='Füllhöhe\nin Gefäß B:', anchor=NE, justify=RIGHT)
        self.f4e4=Entry(self.frame4, width=10, disabledbackground='white', disabledforeground='black', state=DISABLED)
        for i, row, columnspan, column, sticky in (
                (self.f4l1,                     0, 1, 0, E+W), 
                (self.f4e1,                     0, 1, 1, E+W),
                (self.f4l2,                     1, 1, 0, E+W), 
                (self.f4e2,                     1, 1, 1, E+W),
                (self.f4l3,                     1, 1, 2, E+W), 
                (self.f4e3,                     1, 1, 3, E+W),
                (self.f4l4,                     0, 1, 2, E+W), 
                (self.f4e4,                     0, 1, 3, E+W)
                ):
            i.grid(row=row, columnspan=columnspan, column=column, sticky=sticky)

        # Rahmen 5: Beenden-Knopf
        self.button1=Button(self.frame5, text='Zurücksetzen', command=self.zurueck_setzen)
        self.button2=Button(self.frame5, text='Beenden', command=root.destroy)
        self.button1.grid(row=0, column=0, sticky=E+W)
        self.button2.grid(row=0, column=1, sticky=E+W)

    ############################################################################

    def zurueck_setzen(self):
        self.scale1.set(0)
        self.scale_ausgangshoehe_A.set(200)
        self.scale_pipettenbreite_A.set(10)
        self.scale_ausgangshoehe_B.set(100)
        self.scale_pipettenbreite_B.set(5)

    def neue_fuellhoehe(self, alte_fuellhoehe_A, alte_fuellhoehe_B,
                              pipettenbreite_A, pipettenbreite_B,
                              gefaessbreite_A, gefaessbreite_B):
        # Fläche hin und rück ist gleich dem Produkt aus der alten Füllhöhe und der Pipettenbreite
        self.austauschflaeche_hin=float(alte_fuellhoehe_A)*float(pipettenbreite_A)
        self.austauschflaeche_rueck=float(alte_fuellhoehe_B)*float(pipettenbreite_B)
        # Die neue Fläche ist gleich der Summe bzw. der Differenz der übergegangenen Flächen
        self.neue_gesamtflaeche_A=float(alte_fuellhoehe_A)*float(gefaessbreite_A)-float(self.austauschflaeche_hin)+float(self.austauschflaeche_rueck)
        self.neue_gesamtflaeche_B=float(alte_fuellhoehe_B)*float(gefaessbreite_B)+float(self.austauschflaeche_hin)-float(self.austauschflaeche_rueck)
        self.fuellhoehe_neu_A=float(self.neue_gesamtflaeche_A)/float(gefaessbreite_A)
        self.fuellhoehe_neu_B=float(self.neue_gesamtflaeche_B)/float(gefaessbreite_B)
        return self.fuellhoehe_neu_A, self.fuellhoehe_neu_B, self.austauschflaeche_hin, self.austauschflaeche_rueck

    def zeichne_gefaesse(self, alte_fuellhoehe_A, alte_fuellhoehe_B):
        global gefaessbreite_A
        global gefaessbreite_B
        self.pipettenbreite_A=self.scale_pipettenbreite_A.get()
        self.pipettenbreite_B=self.scale_pipettenbreite_B.get()
        self.alte_fuellhoehe_A=alte_fuellhoehe_A
        self.alte_fuellhoehe_B=alte_fuellhoehe_B
        Y1_A=400-self.alte_fuellhoehe_A
        Y1_B=400-self.alte_fuellhoehe_B
        # Gefaess_A zeichnen
        try:
            self.canvas1.delete(self.gefaess_A)
        except:
            #print('loeschen von gefaess_A fehlgeschlagen')
            pass
        #                                            x1,  y1,   x2,  y2
        self.gefaess_A=self.canvas1.create_rectangle(100, Y1_A, 200, 350,
                                                     fill='lightblue',
                                                     outline='white')
        # Gefaess_B zeichnen
        try:
            self.canvas1.delete(self.gefaess_B)
        except:
            #print('loeschen von gefaess_B fehlgeschlagen')
            pass
        #                                            x1,  y1,   x2,  y2
        self.gefaess_B=self.canvas1.create_rectangle(400, Y1_B, 500, 350,
                                                     fill='lightblue',
                                                     outline='white')
        # Pipette_A zeichnen
        try:
            self.canvas1.delete(self.pipette_A)
        except:
            #print('loeschen von pipette_A fehlgeschlagen')
            pass
        X1_pip_A=150-(float(self.pipettenbreite_A)/2)
        X2_pip_A=150+(float(self.pipettenbreite_A)/2)
        #                                            x1,       y1,   x2,       y2
        self.pipette_A=self.canvas1.create_rectangle(X1_pip_A, Y1_A, X2_pip_A, 350,
                                                     fill='blue',
                                                     outline='white')
        # Pipette_B zeichnen
        try:
            self.canvas1.delete(self.pipette_B)
        except:
            #print('loeschen von pipette_B fehlgeschlagen')
            pass
        X1_pip_B=450-(float(self.pipettenbreite_B)/2)
        X2_pip_B=450+(float(self.pipettenbreite_B)/2)
        #                                            x1,       y1,   x2,       y2
        self.pipette_B=self.canvas1.create_rectangle(X1_pip_B, Y1_B, X2_pip_B, 350,
                                                     fill='darkgreen',
                                                     outline='white')
        # Begrenzungen zeichnen
        try:
            for line in self.linien:
                try:
                    self.canvas1.delete(line)
                except:
                    pass
        except:
            pass
        # Begrenzungen Gefäß A
        self.line1=self.canvas1.create_line(100,  75, 100, 350, width=2.0)
        self.line2=self.canvas1.create_line(100, 350, 200, 350, width=2.0)
        self.line3=self.canvas1.create_line(200,  75, 200, 350, width=2.0)
        # Begrenzungen Pipette A
        self.line4=self.canvas1.create_line(X1_pip_A,  50, X1_pip_A, 350, width=2.5)
        self.line5=self.canvas1.create_line(X2_pip_A,  50, X2_pip_A, 350, width=2.5)
        # Begrenzungen Gefäß B
        self.line6=self.canvas1.create_line(400,  75, 400, 350, width=2.0)
        self.line7=self.canvas1.create_line(400, 350, 500, 350, width=2.0)
        self.line8=self.canvas1.create_line(500,  75, 500, 350, width=2.0)
        # Begrenzungen Pipette B
        self.line9=self.canvas1.create_line(X1_pip_B,  50, X1_pip_B, 350, width=2.5)
        self.line10=self.canvas1.create_line(X2_pip_B,  50, X2_pip_B, 350, width=2.5)
        self.linien=(self.line1, self.line2, self.line3, self.line4, self.line5,
                     self.line6, self.line7, self.line8, self.line9, self.line10)
        # Pipettenhütchen
        self.canvas1.create_oval(130, 20, 170, 70, fill='orange', outline='orange')
        self.canvas1.create_oval(430, 20, 470, 70, fill='orange', outline='orange')
        # Leinwand updaten
        self.canvas1.config(background='white')
        self.canvas1.update()
        
        

        ## Startwerte evtl. verändern:
    def werte_fuer_schritt_ermitteln(self, a):
        self.schritt_nr=int(self.scale1.get())
        #print('werte_fuer_schritt_ermitteln: '+str(self.schritt_nr))
        self.pipettenbreite_A=self.scale_pipettenbreite_A.get()
        self.pipettenbreite_B=self.scale_pipettenbreite_B.get()
        self.alte_fuellhoehe_A_0=self.scale_ausgangshoehe_A.get()
        self.alte_fuellhoehe_B_0=self.scale_ausgangshoehe_B.get()
        global gefaessbreite_A
        global gefaessbreite_B
        # 1. Schritt
        self.alte_fuellhoehe_A_1=self.neue_fuellhoehe(self.alte_fuellhoehe_A_0, self.alte_fuellhoehe_B_0, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_1=self.neue_fuellhoehe(self.alte_fuellhoehe_A_0, self.alte_fuellhoehe_B_0, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_1=self.neue_fuellhoehe(self.alte_fuellhoehe_A_0, self.alte_fuellhoehe_B_0, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_1=self.neue_fuellhoehe(self.alte_fuellhoehe_A_0, self.alte_fuellhoehe_B_0, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        # 2. Schritt
        self.alte_fuellhoehe_A_2=self.neue_fuellhoehe(self.alte_fuellhoehe_A_1, self.alte_fuellhoehe_B_1, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_2=self.neue_fuellhoehe(self.alte_fuellhoehe_A_1, self.alte_fuellhoehe_B_1, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_2=self.neue_fuellhoehe(self.alte_fuellhoehe_A_1, self.alte_fuellhoehe_B_1, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_2=self.neue_fuellhoehe(self.alte_fuellhoehe_A_1, self.alte_fuellhoehe_B_1, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        # 3. Schritt
        self.alte_fuellhoehe_A_3=self.neue_fuellhoehe(self.alte_fuellhoehe_A_2, self.alte_fuellhoehe_B_2, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_3=self.neue_fuellhoehe(self.alte_fuellhoehe_A_2, self.alte_fuellhoehe_B_2, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_3=self.neue_fuellhoehe(self.alte_fuellhoehe_A_2, self.alte_fuellhoehe_B_2, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_3=self.neue_fuellhoehe(self.alte_fuellhoehe_A_2, self.alte_fuellhoehe_B_2, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        # 4. Schritt
        self.alte_fuellhoehe_A_4=self.neue_fuellhoehe(self.alte_fuellhoehe_A_3, self.alte_fuellhoehe_B_3, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_4=self.neue_fuellhoehe(self.alte_fuellhoehe_A_3, self.alte_fuellhoehe_B_3, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_4=self.neue_fuellhoehe(self.alte_fuellhoehe_A_3, self.alte_fuellhoehe_B_3, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_4=self.neue_fuellhoehe(self.alte_fuellhoehe_A_3, self.alte_fuellhoehe_B_3, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        # 5. Schritt
        self.alte_fuellhoehe_A_5=self.neue_fuellhoehe(self.alte_fuellhoehe_A_4, self.alte_fuellhoehe_B_4, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_5=self.neue_fuellhoehe(self.alte_fuellhoehe_A_4, self.alte_fuellhoehe_B_4, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_5=self.neue_fuellhoehe(self.alte_fuellhoehe_A_4, self.alte_fuellhoehe_B_4, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_5=self.neue_fuellhoehe(self.alte_fuellhoehe_A_4, self.alte_fuellhoehe_B_4, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        # 6. Schritt
        self.alte_fuellhoehe_A_6=self.neue_fuellhoehe(self.alte_fuellhoehe_A_5, self.alte_fuellhoehe_B_5, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_6=self.neue_fuellhoehe(self.alte_fuellhoehe_A_5, self.alte_fuellhoehe_B_5, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_6=self.neue_fuellhoehe(self.alte_fuellhoehe_A_5, self.alte_fuellhoehe_B_5, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_6=self.neue_fuellhoehe(self.alte_fuellhoehe_A_5, self.alte_fuellhoehe_B_5, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        # 7. Schritt
        self.alte_fuellhoehe_A_7=self.neue_fuellhoehe(self.alte_fuellhoehe_A_6, self.alte_fuellhoehe_B_6, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_7=self.neue_fuellhoehe(self.alte_fuellhoehe_A_6, self.alte_fuellhoehe_B_6, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_7=self.neue_fuellhoehe(self.alte_fuellhoehe_A_6, self.alte_fuellhoehe_B_6, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_7=self.neue_fuellhoehe(self.alte_fuellhoehe_A_6, self.alte_fuellhoehe_B_6, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        # 8. Schritt
        self.alte_fuellhoehe_A_8=self.neue_fuellhoehe(self.alte_fuellhoehe_A_7, self.alte_fuellhoehe_B_7, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_8=self.neue_fuellhoehe(self.alte_fuellhoehe_A_7, self.alte_fuellhoehe_B_7, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_8=self.neue_fuellhoehe(self.alte_fuellhoehe_A_7, self.alte_fuellhoehe_B_7, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_8=self.neue_fuellhoehe(self.alte_fuellhoehe_A_7, self.alte_fuellhoehe_B_7, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        # 9. Schritt
        self.alte_fuellhoehe_A_9=self.neue_fuellhoehe(self.alte_fuellhoehe_A_8, self.alte_fuellhoehe_B_8, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_9=self.neue_fuellhoehe(self.alte_fuellhoehe_A_8, self.alte_fuellhoehe_B_8, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_9=self.neue_fuellhoehe(self.alte_fuellhoehe_A_8, self.alte_fuellhoehe_B_8, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_9=self.neue_fuellhoehe(self.alte_fuellhoehe_A_8, self.alte_fuellhoehe_B_8, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        # 10. Schritt
        self.alte_fuellhoehe_A_10=self.neue_fuellhoehe(self.alte_fuellhoehe_A_9, self.alte_fuellhoehe_B_9, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_10=self.neue_fuellhoehe(self.alte_fuellhoehe_A_9, self.alte_fuellhoehe_B_9, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_10=self.neue_fuellhoehe(self.alte_fuellhoehe_A_9, self.alte_fuellhoehe_B_9, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_10=self.neue_fuellhoehe(self.alte_fuellhoehe_A_9, self.alte_fuellhoehe_B_9, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 11. Schritt
        self.alte_fuellhoehe_A_11=self.neue_fuellhoehe(self.alte_fuellhoehe_A_10, self.alte_fuellhoehe_B_10, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_11=self.neue_fuellhoehe(self.alte_fuellhoehe_A_10, self.alte_fuellhoehe_B_10, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_11=self.neue_fuellhoehe(self.alte_fuellhoehe_A_10, self.alte_fuellhoehe_B_10, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_11=self.neue_fuellhoehe(self.alte_fuellhoehe_A_10, self.alte_fuellhoehe_B_10, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 12. Schritt
        self.alte_fuellhoehe_A_12=self.neue_fuellhoehe(self.alte_fuellhoehe_A_11, self.alte_fuellhoehe_B_11, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_12=self.neue_fuellhoehe(self.alte_fuellhoehe_A_11, self.alte_fuellhoehe_B_11, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_12=self.neue_fuellhoehe(self.alte_fuellhoehe_A_11, self.alte_fuellhoehe_B_11, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_12=self.neue_fuellhoehe(self.alte_fuellhoehe_A_11, self.alte_fuellhoehe_B_11, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 13. Schritt
        self.alte_fuellhoehe_A_13=self.neue_fuellhoehe(self.alte_fuellhoehe_A_12, self.alte_fuellhoehe_B_12, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_13=self.neue_fuellhoehe(self.alte_fuellhoehe_A_12, self.alte_fuellhoehe_B_12, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_13=self.neue_fuellhoehe(self.alte_fuellhoehe_A_12, self.alte_fuellhoehe_B_12, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_13=self.neue_fuellhoehe(self.alte_fuellhoehe_A_12, self.alte_fuellhoehe_B_12, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 14. Schritt
        self.alte_fuellhoehe_A_14=self.neue_fuellhoehe(self.alte_fuellhoehe_A_13, self.alte_fuellhoehe_B_13, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_14=self.neue_fuellhoehe(self.alte_fuellhoehe_A_13, self.alte_fuellhoehe_B_13, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_14=self.neue_fuellhoehe(self.alte_fuellhoehe_A_13, self.alte_fuellhoehe_B_13, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_14=self.neue_fuellhoehe(self.alte_fuellhoehe_A_13, self.alte_fuellhoehe_B_13, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 15. Schritt
        self.alte_fuellhoehe_A_15=self.neue_fuellhoehe(self.alte_fuellhoehe_A_14, self.alte_fuellhoehe_B_14, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_15=self.neue_fuellhoehe(self.alte_fuellhoehe_A_14, self.alte_fuellhoehe_B_14, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_15=self.neue_fuellhoehe(self.alte_fuellhoehe_A_14, self.alte_fuellhoehe_B_14, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_15=self.neue_fuellhoehe(self.alte_fuellhoehe_A_14, self.alte_fuellhoehe_B_14, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 16. Schritt
        self.alte_fuellhoehe_A_16=self.neue_fuellhoehe(self.alte_fuellhoehe_A_15, self.alte_fuellhoehe_B_15, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_16=self.neue_fuellhoehe(self.alte_fuellhoehe_A_15, self.alte_fuellhoehe_B_15, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_16=self.neue_fuellhoehe(self.alte_fuellhoehe_A_15, self.alte_fuellhoehe_B_15, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_16=self.neue_fuellhoehe(self.alte_fuellhoehe_A_15, self.alte_fuellhoehe_B_15, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 17. Schritt
        self.alte_fuellhoehe_A_17=self.neue_fuellhoehe(self.alte_fuellhoehe_A_16, self.alte_fuellhoehe_B_16, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_17=self.neue_fuellhoehe(self.alte_fuellhoehe_A_16, self.alte_fuellhoehe_B_16, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_17=self.neue_fuellhoehe(self.alte_fuellhoehe_A_16, self.alte_fuellhoehe_B_16, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_17=self.neue_fuellhoehe(self.alte_fuellhoehe_A_16, self.alte_fuellhoehe_B_16, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 18. Schritt
        self.alte_fuellhoehe_A_18=self.neue_fuellhoehe(self.alte_fuellhoehe_A_17, self.alte_fuellhoehe_B_17, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_18=self.neue_fuellhoehe(self.alte_fuellhoehe_A_17, self.alte_fuellhoehe_B_17, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_18=self.neue_fuellhoehe(self.alte_fuellhoehe_A_17, self.alte_fuellhoehe_B_17, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_18=self.neue_fuellhoehe(self.alte_fuellhoehe_A_17, self.alte_fuellhoehe_B_17, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 19. Schritt
        self.alte_fuellhoehe_A_19=self.neue_fuellhoehe(self.alte_fuellhoehe_A_18, self.alte_fuellhoehe_B_18, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_19=self.neue_fuellhoehe(self.alte_fuellhoehe_A_18, self.alte_fuellhoehe_B_18, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_19=self.neue_fuellhoehe(self.alte_fuellhoehe_A_18, self.alte_fuellhoehe_B_18, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_19=self.neue_fuellhoehe(self.alte_fuellhoehe_A_18, self.alte_fuellhoehe_B_18, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 20. Schritt
        self.alte_fuellhoehe_A_20=self.neue_fuellhoehe(self.alte_fuellhoehe_A_19, self.alte_fuellhoehe_B_19, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_20=self.neue_fuellhoehe(self.alte_fuellhoehe_A_19, self.alte_fuellhoehe_B_19, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_20=self.neue_fuellhoehe(self.alte_fuellhoehe_A_19, self.alte_fuellhoehe_B_19, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_20=self.neue_fuellhoehe(self.alte_fuellhoehe_A_19, self.alte_fuellhoehe_B_19, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 21. Schritt
        self.alte_fuellhoehe_A_21=self.neue_fuellhoehe(self.alte_fuellhoehe_A_20, self.alte_fuellhoehe_B_20, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_21=self.neue_fuellhoehe(self.alte_fuellhoehe_A_20, self.alte_fuellhoehe_B_20, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_21=self.neue_fuellhoehe(self.alte_fuellhoehe_A_20, self.alte_fuellhoehe_B_20, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_21=self.neue_fuellhoehe(self.alte_fuellhoehe_A_20, self.alte_fuellhoehe_B_20, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 22. Schritt
        self.alte_fuellhoehe_A_22=self.neue_fuellhoehe(self.alte_fuellhoehe_A_21, self.alte_fuellhoehe_B_21, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_22=self.neue_fuellhoehe(self.alte_fuellhoehe_A_21, self.alte_fuellhoehe_B_21, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_22=self.neue_fuellhoehe(self.alte_fuellhoehe_A_21, self.alte_fuellhoehe_B_21, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_22=self.neue_fuellhoehe(self.alte_fuellhoehe_A_21, self.alte_fuellhoehe_B_21, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 23. Schritt
        self.alte_fuellhoehe_A_23=self.neue_fuellhoehe(self.alte_fuellhoehe_A_22, self.alte_fuellhoehe_B_22, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_23=self.neue_fuellhoehe(self.alte_fuellhoehe_A_22, self.alte_fuellhoehe_B_22, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_23=self.neue_fuellhoehe(self.alte_fuellhoehe_A_22, self.alte_fuellhoehe_B_22, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_23=self.neue_fuellhoehe(self.alte_fuellhoehe_A_22, self.alte_fuellhoehe_B_22, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 24. Schritt
        self.alte_fuellhoehe_A_24=self.neue_fuellhoehe(self.alte_fuellhoehe_A_23, self.alte_fuellhoehe_B_23, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_24=self.neue_fuellhoehe(self.alte_fuellhoehe_A_23, self.alte_fuellhoehe_B_23, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_24=self.neue_fuellhoehe(self.alte_fuellhoehe_A_23, self.alte_fuellhoehe_B_23, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_24=self.neue_fuellhoehe(self.alte_fuellhoehe_A_23, self.alte_fuellhoehe_B_23, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 25. Schritt
        self.alte_fuellhoehe_A_25=self.neue_fuellhoehe(self.alte_fuellhoehe_A_24, self.alte_fuellhoehe_B_24, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_25=self.neue_fuellhoehe(self.alte_fuellhoehe_A_24, self.alte_fuellhoehe_B_24, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_25=self.neue_fuellhoehe(self.alte_fuellhoehe_A_24, self.alte_fuellhoehe_B_24, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_25=self.neue_fuellhoehe(self.alte_fuellhoehe_A_24, self.alte_fuellhoehe_B_24, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 26. Schritt
        self.alte_fuellhoehe_A_26=self.neue_fuellhoehe(self.alte_fuellhoehe_A_25, self.alte_fuellhoehe_B_25, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_26=self.neue_fuellhoehe(self.alte_fuellhoehe_A_25, self.alte_fuellhoehe_B_25, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_26=self.neue_fuellhoehe(self.alte_fuellhoehe_A_25, self.alte_fuellhoehe_B_25, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_26=self.neue_fuellhoehe(self.alte_fuellhoehe_A_25, self.alte_fuellhoehe_B_25, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 27. Schritt
        self.alte_fuellhoehe_A_27=self.neue_fuellhoehe(self.alte_fuellhoehe_A_26, self.alte_fuellhoehe_B_26, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_27=self.neue_fuellhoehe(self.alte_fuellhoehe_A_26, self.alte_fuellhoehe_B_26, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_27=self.neue_fuellhoehe(self.alte_fuellhoehe_A_26, self.alte_fuellhoehe_B_26, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_27=self.neue_fuellhoehe(self.alte_fuellhoehe_A_26, self.alte_fuellhoehe_B_26, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 28. Schritt
        self.alte_fuellhoehe_A_28=self.neue_fuellhoehe(self.alte_fuellhoehe_A_27, self.alte_fuellhoehe_B_27, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_28=self.neue_fuellhoehe(self.alte_fuellhoehe_A_27, self.alte_fuellhoehe_B_27, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_28=self.neue_fuellhoehe(self.alte_fuellhoehe_A_27, self.alte_fuellhoehe_B_27, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_28=self.neue_fuellhoehe(self.alte_fuellhoehe_A_27, self.alte_fuellhoehe_B_27, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 29. Schritt
        self.alte_fuellhoehe_A_29=self.neue_fuellhoehe(self.alte_fuellhoehe_A_28, self.alte_fuellhoehe_B_28, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_29=self.neue_fuellhoehe(self.alte_fuellhoehe_A_28, self.alte_fuellhoehe_B_28, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_29=self.neue_fuellhoehe(self.alte_fuellhoehe_A_28, self.alte_fuellhoehe_B_28, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_29=self.neue_fuellhoehe(self.alte_fuellhoehe_A_28, self.alte_fuellhoehe_B_28, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 30. Schritt
        self.alte_fuellhoehe_A_30=self.neue_fuellhoehe(self.alte_fuellhoehe_A_29, self.alte_fuellhoehe_B_29, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_30=self.neue_fuellhoehe(self.alte_fuellhoehe_A_29, self.alte_fuellhoehe_B_29, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_30=self.neue_fuellhoehe(self.alte_fuellhoehe_A_29, self.alte_fuellhoehe_B_29, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_30=self.neue_fuellhoehe(self.alte_fuellhoehe_A_29, self.alte_fuellhoehe_B_29, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        
        # 31. Schritt
        self.alte_fuellhoehe_A_31=self.neue_fuellhoehe(self.alte_fuellhoehe_A_30, self.alte_fuellhoehe_B_30, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_31=self.neue_fuellhoehe(self.alte_fuellhoehe_A_30, self.alte_fuellhoehe_B_30, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_31=self.neue_fuellhoehe(self.alte_fuellhoehe_A_30, self.alte_fuellhoehe_B_30, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_31=self.neue_fuellhoehe(self.alte_fuellhoehe_A_30, self.alte_fuellhoehe_B_30, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 32. Schritt
        self.alte_fuellhoehe_A_32=self.neue_fuellhoehe(self.alte_fuellhoehe_A_31, self.alte_fuellhoehe_B_31, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_32=self.neue_fuellhoehe(self.alte_fuellhoehe_A_31, self.alte_fuellhoehe_B_31, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_32=self.neue_fuellhoehe(self.alte_fuellhoehe_A_31, self.alte_fuellhoehe_B_31, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_32=self.neue_fuellhoehe(self.alte_fuellhoehe_A_31, self.alte_fuellhoehe_B_31, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 33. Schritt
        self.alte_fuellhoehe_A_33=self.neue_fuellhoehe(self.alte_fuellhoehe_A_32, self.alte_fuellhoehe_B_32, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_33=self.neue_fuellhoehe(self.alte_fuellhoehe_A_32, self.alte_fuellhoehe_B_32, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_33=self.neue_fuellhoehe(self.alte_fuellhoehe_A_32, self.alte_fuellhoehe_B_32, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_33=self.neue_fuellhoehe(self.alte_fuellhoehe_A_32, self.alte_fuellhoehe_B_32, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 34. Schritt
        self.alte_fuellhoehe_A_34=self.neue_fuellhoehe(self.alte_fuellhoehe_A_33, self.alte_fuellhoehe_B_33, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_34=self.neue_fuellhoehe(self.alte_fuellhoehe_A_33, self.alte_fuellhoehe_B_33, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_34=self.neue_fuellhoehe(self.alte_fuellhoehe_A_33, self.alte_fuellhoehe_B_33, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_34=self.neue_fuellhoehe(self.alte_fuellhoehe_A_33, self.alte_fuellhoehe_B_33, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 35. Schritt
        self.alte_fuellhoehe_A_35=self.neue_fuellhoehe(self.alte_fuellhoehe_A_34, self.alte_fuellhoehe_B_34, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_35=self.neue_fuellhoehe(self.alte_fuellhoehe_A_34, self.alte_fuellhoehe_B_34, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_35=self.neue_fuellhoehe(self.alte_fuellhoehe_A_34, self.alte_fuellhoehe_B_34, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_35=self.neue_fuellhoehe(self.alte_fuellhoehe_A_34, self.alte_fuellhoehe_B_34, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 36. Schritt
        self.alte_fuellhoehe_A_36=self.neue_fuellhoehe(self.alte_fuellhoehe_A_35, self.alte_fuellhoehe_B_35, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_36=self.neue_fuellhoehe(self.alte_fuellhoehe_A_35, self.alte_fuellhoehe_B_35, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_36=self.neue_fuellhoehe(self.alte_fuellhoehe_A_35, self.alte_fuellhoehe_B_35, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_36=self.neue_fuellhoehe(self.alte_fuellhoehe_A_35, self.alte_fuellhoehe_B_35, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 37. Schritt
        self.alte_fuellhoehe_A_37=self.neue_fuellhoehe(self.alte_fuellhoehe_A_36, self.alte_fuellhoehe_B_36, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_37=self.neue_fuellhoehe(self.alte_fuellhoehe_A_36, self.alte_fuellhoehe_B_36, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_37=self.neue_fuellhoehe(self.alte_fuellhoehe_A_36, self.alte_fuellhoehe_B_36, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_37=self.neue_fuellhoehe(self.alte_fuellhoehe_A_36, self.alte_fuellhoehe_B_36, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 38. Schritt
        self.alte_fuellhoehe_A_38=self.neue_fuellhoehe(self.alte_fuellhoehe_A_37, self.alte_fuellhoehe_B_37, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_38=self.neue_fuellhoehe(self.alte_fuellhoehe_A_37, self.alte_fuellhoehe_B_37, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_38=self.neue_fuellhoehe(self.alte_fuellhoehe_A_37, self.alte_fuellhoehe_B_37, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_38=self.neue_fuellhoehe(self.alte_fuellhoehe_A_37, self.alte_fuellhoehe_B_37, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 39. Schritt
        self.alte_fuellhoehe_A_39=self.neue_fuellhoehe(self.alte_fuellhoehe_A_38, self.alte_fuellhoehe_B_38, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_39=self.neue_fuellhoehe(self.alte_fuellhoehe_A_38, self.alte_fuellhoehe_B_38, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_39=self.neue_fuellhoehe(self.alte_fuellhoehe_A_38, self.alte_fuellhoehe_B_38, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_39=self.neue_fuellhoehe(self.alte_fuellhoehe_A_38, self.alte_fuellhoehe_B_38, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 40. Schritt
        self.alte_fuellhoehe_A_40=self.neue_fuellhoehe(self.alte_fuellhoehe_A_39, self.alte_fuellhoehe_B_39, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_40=self.neue_fuellhoehe(self.alte_fuellhoehe_A_39, self.alte_fuellhoehe_B_39, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_40=self.neue_fuellhoehe(self.alte_fuellhoehe_A_39, self.alte_fuellhoehe_B_39, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_40=self.neue_fuellhoehe(self.alte_fuellhoehe_A_39, self.alte_fuellhoehe_B_39, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        
        # 41. Schritt
        self.alte_fuellhoehe_A_41=self.neue_fuellhoehe(self.alte_fuellhoehe_A_40, self.alte_fuellhoehe_B_40, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_41=self.neue_fuellhoehe(self.alte_fuellhoehe_A_40, self.alte_fuellhoehe_B_40, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_41=self.neue_fuellhoehe(self.alte_fuellhoehe_A_40, self.alte_fuellhoehe_B_40, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_41=self.neue_fuellhoehe(self.alte_fuellhoehe_A_40, self.alte_fuellhoehe_B_40, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 42. Schritt
        self.alte_fuellhoehe_A_42=self.neue_fuellhoehe(self.alte_fuellhoehe_A_41, self.alte_fuellhoehe_B_41, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_42=self.neue_fuellhoehe(self.alte_fuellhoehe_A_41, self.alte_fuellhoehe_B_41, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_42=self.neue_fuellhoehe(self.alte_fuellhoehe_A_41, self.alte_fuellhoehe_B_41, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_42=self.neue_fuellhoehe(self.alte_fuellhoehe_A_41, self.alte_fuellhoehe_B_41, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 43. Schritt
        self.alte_fuellhoehe_A_43=self.neue_fuellhoehe(self.alte_fuellhoehe_A_42, self.alte_fuellhoehe_B_42, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_43=self.neue_fuellhoehe(self.alte_fuellhoehe_A_42, self.alte_fuellhoehe_B_42, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_43=self.neue_fuellhoehe(self.alte_fuellhoehe_A_42, self.alte_fuellhoehe_B_42, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_43=self.neue_fuellhoehe(self.alte_fuellhoehe_A_42, self.alte_fuellhoehe_B_42, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 44. Schritt
        self.alte_fuellhoehe_A_44=self.neue_fuellhoehe(self.alte_fuellhoehe_A_43, self.alte_fuellhoehe_B_43, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_44=self.neue_fuellhoehe(self.alte_fuellhoehe_A_43, self.alte_fuellhoehe_B_43, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_44=self.neue_fuellhoehe(self.alte_fuellhoehe_A_43, self.alte_fuellhoehe_B_43, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_44=self.neue_fuellhoehe(self.alte_fuellhoehe_A_43, self.alte_fuellhoehe_B_43, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 45. Schritt
        self.alte_fuellhoehe_A_45=self.neue_fuellhoehe(self.alte_fuellhoehe_A_44, self.alte_fuellhoehe_B_44, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_45=self.neue_fuellhoehe(self.alte_fuellhoehe_A_44, self.alte_fuellhoehe_B_44, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_45=self.neue_fuellhoehe(self.alte_fuellhoehe_A_44, self.alte_fuellhoehe_B_44, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_45=self.neue_fuellhoehe(self.alte_fuellhoehe_A_44, self.alte_fuellhoehe_B_44, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 46. Schritt
        self.alte_fuellhoehe_A_46=self.neue_fuellhoehe(self.alte_fuellhoehe_A_45, self.alte_fuellhoehe_B_45, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_46=self.neue_fuellhoehe(self.alte_fuellhoehe_A_45, self.alte_fuellhoehe_B_45, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_46=self.neue_fuellhoehe(self.alte_fuellhoehe_A_45, self.alte_fuellhoehe_B_45, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_46=self.neue_fuellhoehe(self.alte_fuellhoehe_A_45, self.alte_fuellhoehe_B_45, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 47. Schritt
        self.alte_fuellhoehe_A_47=self.neue_fuellhoehe(self.alte_fuellhoehe_A_46, self.alte_fuellhoehe_B_46, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_47=self.neue_fuellhoehe(self.alte_fuellhoehe_A_46, self.alte_fuellhoehe_B_46, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_47=self.neue_fuellhoehe(self.alte_fuellhoehe_A_46, self.alte_fuellhoehe_B_46, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_47=self.neue_fuellhoehe(self.alte_fuellhoehe_A_46, self.alte_fuellhoehe_B_46, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 48. Schritt
        self.alte_fuellhoehe_A_48=self.neue_fuellhoehe(self.alte_fuellhoehe_A_47, self.alte_fuellhoehe_B_47, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_48=self.neue_fuellhoehe(self.alte_fuellhoehe_A_47, self.alte_fuellhoehe_B_47, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_48=self.neue_fuellhoehe(self.alte_fuellhoehe_A_47, self.alte_fuellhoehe_B_47, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_48=self.neue_fuellhoehe(self.alte_fuellhoehe_A_47, self.alte_fuellhoehe_B_47, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 49. Schritt
        self.alte_fuellhoehe_A_49=self.neue_fuellhoehe(self.alte_fuellhoehe_A_48, self.alte_fuellhoehe_B_48, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_49=self.neue_fuellhoehe(self.alte_fuellhoehe_A_48, self.alte_fuellhoehe_B_48, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_49=self.neue_fuellhoehe(self.alte_fuellhoehe_A_48, self.alte_fuellhoehe_B_48, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_49=self.neue_fuellhoehe(self.alte_fuellhoehe_A_48, self.alte_fuellhoehe_B_48, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]

        # 50. Schritt
        self.alte_fuellhoehe_A_50=self.neue_fuellhoehe(self.alte_fuellhoehe_A_49, self.alte_fuellhoehe_B_49, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[0]
        self.alte_fuellhoehe_B_50=self.neue_fuellhoehe(self.alte_fuellhoehe_A_49, self.alte_fuellhoehe_B_49, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[1]
        self.austauschflaeche_hin_50=self.neue_fuellhoehe(self.alte_fuellhoehe_A_49, self.alte_fuellhoehe_B_49, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[2]
        self.austauschflaeche_rueck_50=self.neue_fuellhoehe(self.alte_fuellhoehe_A_49, self.alte_fuellhoehe_B_49, self.pipettenbreite_A, self.pipettenbreite_B, gefaessbreite_A, gefaessbreite_B)[3]
        
        
        self.WERTEZUORDNUNG_A={
        'alte_fuellhoehe_A_0':self.scale_ausgangshoehe_A.get(),
        'alte_fuellhoehe_A_1':self.alte_fuellhoehe_A_1,
        'alte_fuellhoehe_A_2':self.alte_fuellhoehe_A_2,
        'alte_fuellhoehe_A_3':self.alte_fuellhoehe_A_3,
        'alte_fuellhoehe_A_4':self.alte_fuellhoehe_A_4,
        'alte_fuellhoehe_A_5':self.alte_fuellhoehe_A_5,
        'alte_fuellhoehe_A_6':self.alte_fuellhoehe_A_6,
        'alte_fuellhoehe_A_7':self.alte_fuellhoehe_A_7,
        'alte_fuellhoehe_A_8':self.alte_fuellhoehe_A_8,
        'alte_fuellhoehe_A_9':self.alte_fuellhoehe_A_9,
        'alte_fuellhoehe_A_10':self.alte_fuellhoehe_A_10,
        'alte_fuellhoehe_A_11':self.alte_fuellhoehe_A_11,
        'alte_fuellhoehe_A_12':self.alte_fuellhoehe_A_12,
        'alte_fuellhoehe_A_13':self.alte_fuellhoehe_A_13,
        'alte_fuellhoehe_A_14':self.alte_fuellhoehe_A_14,
        'alte_fuellhoehe_A_15':self.alte_fuellhoehe_A_15,
        'alte_fuellhoehe_A_16':self.alte_fuellhoehe_A_16,
        'alte_fuellhoehe_A_17':self.alte_fuellhoehe_A_17,
        'alte_fuellhoehe_A_18':self.alte_fuellhoehe_A_18,
        'alte_fuellhoehe_A_19':self.alte_fuellhoehe_A_19,
        'alte_fuellhoehe_A_20':self.alte_fuellhoehe_A_20,
        'alte_fuellhoehe_A_21':self.alte_fuellhoehe_A_21,
        'alte_fuellhoehe_A_22':self.alte_fuellhoehe_A_22,
        'alte_fuellhoehe_A_23':self.alte_fuellhoehe_A_23,
        'alte_fuellhoehe_A_24':self.alte_fuellhoehe_A_24,
        'alte_fuellhoehe_A_25':self.alte_fuellhoehe_A_25,
        'alte_fuellhoehe_A_26':self.alte_fuellhoehe_A_26,
        'alte_fuellhoehe_A_27':self.alte_fuellhoehe_A_27,
        'alte_fuellhoehe_A_28':self.alte_fuellhoehe_A_28,
        'alte_fuellhoehe_A_29':self.alte_fuellhoehe_A_29,
        'alte_fuellhoehe_A_30':self.alte_fuellhoehe_A_30,
        'alte_fuellhoehe_A_31':self.alte_fuellhoehe_A_31,
        'alte_fuellhoehe_A_32':self.alte_fuellhoehe_A_32,
        'alte_fuellhoehe_A_33':self.alte_fuellhoehe_A_33,
        'alte_fuellhoehe_A_34':self.alte_fuellhoehe_A_34,
        'alte_fuellhoehe_A_35':self.alte_fuellhoehe_A_35,
        'alte_fuellhoehe_A_36':self.alte_fuellhoehe_A_36,
        'alte_fuellhoehe_A_37':self.alte_fuellhoehe_A_37,
        'alte_fuellhoehe_A_38':self.alte_fuellhoehe_A_38,
        'alte_fuellhoehe_A_39':self.alte_fuellhoehe_A_39,
        'alte_fuellhoehe_A_40':self.alte_fuellhoehe_A_40,
        'alte_fuellhoehe_A_41':self.alte_fuellhoehe_A_41,
        'alte_fuellhoehe_A_42':self.alte_fuellhoehe_A_42,
        'alte_fuellhoehe_A_43':self.alte_fuellhoehe_A_43,
        'alte_fuellhoehe_A_44':self.alte_fuellhoehe_A_44,
        'alte_fuellhoehe_A_45':self.alte_fuellhoehe_A_45,
        'alte_fuellhoehe_A_46':self.alte_fuellhoehe_A_46,
        'alte_fuellhoehe_A_47':self.alte_fuellhoehe_A_47,
        'alte_fuellhoehe_A_48':self.alte_fuellhoehe_A_48,
        'alte_fuellhoehe_A_49':self.alte_fuellhoehe_A_49,
        'alte_fuellhoehe_A_50':self.alte_fuellhoehe_A_50,
        }
        self.WERTEZUORDNUNG_hin={
        'austauschflaeche_hin_0':self.scale_ausgangshoehe_A.get()*self.scale_pipettenbreite_A.get(),
        'austauschflaeche_hin_1':self.austauschflaeche_hin_1,
        'austauschflaeche_hin_2':self.austauschflaeche_hin_2,
        'austauschflaeche_hin_3':self.austauschflaeche_hin_3,
        'austauschflaeche_hin_4':self.austauschflaeche_hin_4,
        'austauschflaeche_hin_5':self.austauschflaeche_hin_5,
        'austauschflaeche_hin_6':self.austauschflaeche_hin_6,
        'austauschflaeche_hin_7':self.austauschflaeche_hin_7,
        'austauschflaeche_hin_8':self.austauschflaeche_hin_8,
        'austauschflaeche_hin_9':self.austauschflaeche_hin_9,
        'austauschflaeche_hin_10':self.austauschflaeche_hin_10,
        'austauschflaeche_hin_11':self.austauschflaeche_hin_11,
        'austauschflaeche_hin_12':self.austauschflaeche_hin_12,
        'austauschflaeche_hin_13':self.austauschflaeche_hin_13,
        'austauschflaeche_hin_14':self.austauschflaeche_hin_14,
        'austauschflaeche_hin_15':self.austauschflaeche_hin_15,
        'austauschflaeche_hin_16':self.austauschflaeche_hin_16,
        'austauschflaeche_hin_17':self.austauschflaeche_hin_17,
        'austauschflaeche_hin_18':self.austauschflaeche_hin_18,
        'austauschflaeche_hin_19':self.austauschflaeche_hin_19,
        'austauschflaeche_hin_20':self.austauschflaeche_hin_20,
        'austauschflaeche_hin_21':self.austauschflaeche_hin_21,
        'austauschflaeche_hin_22':self.austauschflaeche_hin_22,
        'austauschflaeche_hin_23':self.austauschflaeche_hin_23,
        'austauschflaeche_hin_24':self.austauschflaeche_hin_24,
        'austauschflaeche_hin_25':self.austauschflaeche_hin_25,
        'austauschflaeche_hin_26':self.austauschflaeche_hin_26,
        'austauschflaeche_hin_27':self.austauschflaeche_hin_27,
        'austauschflaeche_hin_28':self.austauschflaeche_hin_28,
        'austauschflaeche_hin_29':self.austauschflaeche_hin_29,
        'austauschflaeche_hin_30':self.austauschflaeche_hin_30,
        'austauschflaeche_hin_31':self.austauschflaeche_hin_31,
        'austauschflaeche_hin_32':self.austauschflaeche_hin_32,
        'austauschflaeche_hin_33':self.austauschflaeche_hin_33,
        'austauschflaeche_hin_34':self.austauschflaeche_hin_34,
        'austauschflaeche_hin_35':self.austauschflaeche_hin_35,
        'austauschflaeche_hin_36':self.austauschflaeche_hin_36,
        'austauschflaeche_hin_37':self.austauschflaeche_hin_37,
        'austauschflaeche_hin_38':self.austauschflaeche_hin_38,
        'austauschflaeche_hin_39':self.austauschflaeche_hin_39,
        'austauschflaeche_hin_40':self.austauschflaeche_hin_40,
        'austauschflaeche_hin_41':self.austauschflaeche_hin_41,
        'austauschflaeche_hin_42':self.austauschflaeche_hin_42,
        'austauschflaeche_hin_43':self.austauschflaeche_hin_43,
        'austauschflaeche_hin_44':self.austauschflaeche_hin_44,
        'austauschflaeche_hin_45':self.austauschflaeche_hin_45,
        'austauschflaeche_hin_46':self.austauschflaeche_hin_46,
        'austauschflaeche_hin_47':self.austauschflaeche_hin_47,
        'austauschflaeche_hin_48':self.austauschflaeche_hin_48,
        'austauschflaeche_hin_49':self.austauschflaeche_hin_49,
        'austauschflaeche_hin_50':self.austauschflaeche_hin_50,
        }
        self.WERTEZUORDNUNG_B={
        'alte_fuellhoehe_B_0':self.scale_ausgangshoehe_B.get(),
        'alte_fuellhoehe_B_1':self.alte_fuellhoehe_B_1,
        'alte_fuellhoehe_B_2':self.alte_fuellhoehe_B_2,
        'alte_fuellhoehe_B_3':self.alte_fuellhoehe_B_3,
        'alte_fuellhoehe_B_4':self.alte_fuellhoehe_B_4,
        'alte_fuellhoehe_B_5':self.alte_fuellhoehe_B_5,
        'alte_fuellhoehe_B_6':self.alte_fuellhoehe_B_6,
        'alte_fuellhoehe_B_7':self.alte_fuellhoehe_B_7,
        'alte_fuellhoehe_B_8':self.alte_fuellhoehe_B_8,
        'alte_fuellhoehe_B_9':self.alte_fuellhoehe_B_9,
        'alte_fuellhoehe_B_10':self.alte_fuellhoehe_B_10,
        'alte_fuellhoehe_B_11':self.alte_fuellhoehe_B_11,
        'alte_fuellhoehe_B_12':self.alte_fuellhoehe_B_12,
        'alte_fuellhoehe_B_13':self.alte_fuellhoehe_B_13,
        'alte_fuellhoehe_B_14':self.alte_fuellhoehe_B_14,
        'alte_fuellhoehe_B_15':self.alte_fuellhoehe_B_15,
        'alte_fuellhoehe_B_16':self.alte_fuellhoehe_B_16,
        'alte_fuellhoehe_B_17':self.alte_fuellhoehe_B_17,
        'alte_fuellhoehe_B_18':self.alte_fuellhoehe_B_18,
        'alte_fuellhoehe_B_19':self.alte_fuellhoehe_B_19,
        'alte_fuellhoehe_B_20':self.alte_fuellhoehe_B_20,
        'alte_fuellhoehe_B_21':self.alte_fuellhoehe_B_21,
        'alte_fuellhoehe_B_22':self.alte_fuellhoehe_B_22,
        'alte_fuellhoehe_B_23':self.alte_fuellhoehe_B_23,
        'alte_fuellhoehe_B_24':self.alte_fuellhoehe_B_24,
        'alte_fuellhoehe_B_25':self.alte_fuellhoehe_B_25,
        'alte_fuellhoehe_B_26':self.alte_fuellhoehe_B_26,
        'alte_fuellhoehe_B_27':self.alte_fuellhoehe_B_27,
        'alte_fuellhoehe_B_28':self.alte_fuellhoehe_B_28,
        'alte_fuellhoehe_B_29':self.alte_fuellhoehe_B_29,
        'alte_fuellhoehe_B_30':self.alte_fuellhoehe_B_30,
        'alte_fuellhoehe_B_31':self.alte_fuellhoehe_B_31,
        'alte_fuellhoehe_B_32':self.alte_fuellhoehe_B_32,
        'alte_fuellhoehe_B_33':self.alte_fuellhoehe_B_33,
        'alte_fuellhoehe_B_34':self.alte_fuellhoehe_B_34,
        'alte_fuellhoehe_B_35':self.alte_fuellhoehe_B_35,
        'alte_fuellhoehe_B_36':self.alte_fuellhoehe_B_36,
        'alte_fuellhoehe_B_37':self.alte_fuellhoehe_B_37,
        'alte_fuellhoehe_B_38':self.alte_fuellhoehe_B_38,
        'alte_fuellhoehe_B_39':self.alte_fuellhoehe_B_39,
        'alte_fuellhoehe_B_40':self.alte_fuellhoehe_B_40,
        'alte_fuellhoehe_B_41':self.alte_fuellhoehe_B_41,
        'alte_fuellhoehe_B_42':self.alte_fuellhoehe_B_42,
        'alte_fuellhoehe_B_43':self.alte_fuellhoehe_B_43,
        'alte_fuellhoehe_B_44':self.alte_fuellhoehe_B_44,
        'alte_fuellhoehe_B_45':self.alte_fuellhoehe_B_45,
        'alte_fuellhoehe_B_46':self.alte_fuellhoehe_B_46,
        'alte_fuellhoehe_B_47':self.alte_fuellhoehe_B_47,
        'alte_fuellhoehe_B_48':self.alte_fuellhoehe_B_48,
        'alte_fuellhoehe_B_49':self.alte_fuellhoehe_B_49,
        'alte_fuellhoehe_B_50':self.alte_fuellhoehe_B_50,
        }
        self.WERTEZUORDNUNG_rueck={
        'austauschflaeche_rueck_0':self.scale_ausgangshoehe_B.get()*self.scale_pipettenbreite_B.get(),
        'austauschflaeche_rueck_1':self.austauschflaeche_rueck_1,
        'austauschflaeche_rueck_2':self.austauschflaeche_rueck_2,
        'austauschflaeche_rueck_3':self.austauschflaeche_rueck_3,
        'austauschflaeche_rueck_4':self.austauschflaeche_rueck_4,
        'austauschflaeche_rueck_5':self.austauschflaeche_rueck_5,
        'austauschflaeche_rueck_6':self.austauschflaeche_rueck_6,
        'austauschflaeche_rueck_7':self.austauschflaeche_rueck_7,
        'austauschflaeche_rueck_8':self.austauschflaeche_rueck_8,
        'austauschflaeche_rueck_9':self.austauschflaeche_rueck_9,
        'austauschflaeche_rueck_10':self.austauschflaeche_rueck_10,
        'austauschflaeche_rueck_11':self.austauschflaeche_rueck_11,
        'austauschflaeche_rueck_12':self.austauschflaeche_rueck_12,
        'austauschflaeche_rueck_13':self.austauschflaeche_rueck_13,
        'austauschflaeche_rueck_14':self.austauschflaeche_rueck_14,
        'austauschflaeche_rueck_15':self.austauschflaeche_rueck_15,
        'austauschflaeche_rueck_16':self.austauschflaeche_rueck_16,
        'austauschflaeche_rueck_17':self.austauschflaeche_rueck_17,
        'austauschflaeche_rueck_18':self.austauschflaeche_rueck_18,
        'austauschflaeche_rueck_19':self.austauschflaeche_rueck_19,
        'austauschflaeche_rueck_20':self.austauschflaeche_rueck_20,
        'austauschflaeche_rueck_21':self.austauschflaeche_rueck_21,
        'austauschflaeche_rueck_22':self.austauschflaeche_rueck_22,
        'austauschflaeche_rueck_23':self.austauschflaeche_rueck_23,
        'austauschflaeche_rueck_24':self.austauschflaeche_rueck_24,
        'austauschflaeche_rueck_25':self.austauschflaeche_rueck_25,
        'austauschflaeche_rueck_26':self.austauschflaeche_rueck_26,
        'austauschflaeche_rueck_27':self.austauschflaeche_rueck_27,
        'austauschflaeche_rueck_28':self.austauschflaeche_rueck_28,
        'austauschflaeche_rueck_29':self.austauschflaeche_rueck_29,
        'austauschflaeche_rueck_30':self.austauschflaeche_rueck_30,
        'austauschflaeche_rueck_31':self.austauschflaeche_rueck_31,
        'austauschflaeche_rueck_32':self.austauschflaeche_rueck_32,
        'austauschflaeche_rueck_33':self.austauschflaeche_rueck_33,
        'austauschflaeche_rueck_34':self.austauschflaeche_rueck_34,
        'austauschflaeche_rueck_35':self.austauschflaeche_rueck_35,
        'austauschflaeche_rueck_36':self.austauschflaeche_rueck_36,
        'austauschflaeche_rueck_37':self.austauschflaeche_rueck_37,
        'austauschflaeche_rueck_38':self.austauschflaeche_rueck_38,
        'austauschflaeche_rueck_39':self.austauschflaeche_rueck_39,
        'austauschflaeche_rueck_40':self.austauschflaeche_rueck_40,
        'austauschflaeche_rueck_40':self.austauschflaeche_rueck_40,
        'austauschflaeche_rueck_41':self.austauschflaeche_rueck_41,
        'austauschflaeche_rueck_42':self.austauschflaeche_rueck_42,
        'austauschflaeche_rueck_43':self.austauschflaeche_rueck_43,
        'austauschflaeche_rueck_44':self.austauschflaeche_rueck_44,
        'austauschflaeche_rueck_45':self.austauschflaeche_rueck_45,
        'austauschflaeche_rueck_46':self.austauschflaeche_rueck_46,
        'austauschflaeche_rueck_47':self.austauschflaeche_rueck_47,
        'austauschflaeche_rueck_48':self.austauschflaeche_rueck_48,
        'austauschflaeche_rueck_49':self.austauschflaeche_rueck_49,
        'austauschflaeche_rueck_50':self.austauschflaeche_rueck_50,
        }
        #print('Fuellhoehe A:', int(self.WERTEZUORDNUNG_A['alte_fuellhoehe_A_'+str(self.schritt_nr)]))
        #print('Volumen hin:', int(self.WERTEZUORDNUNG_hin['austauschflaeche_hin_'+str(self.schritt_nr)]))
        #print('Fuellhoehe B:', int(self.WERTEZUORDNUNG_B['alte_fuellhoehe_B_'+str(self.schritt_nr)]))
        #print('Volumen rueck:', int(self.WERTEZUORDNUNG_rueck['austauschflaeche_rueck_'+str(self.schritt_nr)]))
        for i in (self.f4e1, self.f4e2, self.f4e3, self.f4e4):
            i.config(state=NORMAL)
        self.f4e1.delete(0, END)
        self.f4e2.delete(0, END)
        self.f4e3.delete(0, END)
        self.f4e4.delete(0, END)
        alte_fuellhoehe_A=int(self.WERTEZUORDNUNG_A['alte_fuellhoehe_A_'+str(self.schritt_nr)])
        alte_fuellhoehe_B=int(self.WERTEZUORDNUNG_B['alte_fuellhoehe_B_'+str(self.schritt_nr)])
        self.f4e1.insert(0, str(alte_fuellhoehe_A))
        self.f4e2.insert(0, str(int(self.WERTEZUORDNUNG_hin['austauschflaeche_hin_'+str(self.schritt_nr)])))
        self.f4e3.insert(0, str(int(self.WERTEZUORDNUNG_rueck['austauschflaeche_rueck_'+str(self.schritt_nr)])))
        self.f4e4.insert(0, str(alte_fuellhoehe_B))
        for i in (self.f4e1, self.f4e2, self.f4e3, self.f4e4):
            i.config(state=DISABLED)
        self.zeichne_gefaesse(alte_fuellhoehe_A, alte_fuellhoehe_B)


################################################################################
root = Tk()
root.title('Gleichgewichtmodeller')
app = Fenster(root)
root.mainloop()

