#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
import random

# Teilchenklassendefinionen
class edukt_a_Teilchen:
    def __init__(self, canvas, x1, y1):
        # [Fe(H₂O)₆]³⁺
        self.canvas=canvas
        self.x1_u1=x1
        self.y1_u1=y1
        # Wassermolekül 1
        # H Atom Nr. 11
        self.x1_H11=self.x1_u1
        self.y1_H11=self.y1_u1
        self.x2_H11=self.x1_H11+15
        self.y2_H11=self.y1_H11+15
        self.canvas.create_oval(self.x1_H11, self.y1_H11, self.x2_H11, self.y2_H11,
                                fill='orange')
        # O Atom Nr. 11
        self.x1_O11=self.x1_u1+5
        self.y1_O11=self.y1_u1+3
        self.x2_O11=self.x1_O11+17
        self.y2_O11=self.y1_O11+17
        self.canvas.create_oval(self.x1_O11, self.y1_O11, self.x2_O11, self.y2_O11,
                                fill='orange')
        # H Atom Nr. 12
        self.x1_H12=self.x1_u1+8
        self.y1_H12=self.y1_u1
        self.x2_H12=self.x1_H12+15
        self.y2_H12=self.y1_H12+15
        self.canvas.create_oval(self.x1_H12, self.y1_H12, self.x2_H12, self.y2_H12,
                                fill='orange')
        # Wassermolekül 2
        # H Atom Nr. 21
        self.x1_H21=self.x1_u1+50
        self.y1_H21=self.y1_u1-4
        self.x2_H21=self.x1_H21+15
        self.y2_H21=self.y1_H21+15
        self.canvas.create_oval(self.x1_H21, self.y1_H21, self.x2_H21, self.y2_H21,
                                fill='orange')
        # O Atom Nr. 21
        self.x1_O21=self.x1_u1+42
        self.y1_O21=self.y1_u1
        self.x2_O21=self.x1_O21+17
        self.y2_O21=self.y1_O21+17
        self.canvas.create_oval(self.x1_O21, self.y1_O21, self.x2_O21, self.y2_O21,
                                fill='orange')
        # H Atom Nr. 22
        self.x1_H22=self.x1_u1+40
        self.y1_H22=self.y1_u1-3
        self.x2_H22=self.x1_H22+15
        self.y2_H22=self.y1_H22+15
        self.canvas.create_oval(self.x1_H22, self.y1_H22, self.x2_H22, self.y2_H22,
                                fill='orange')
        # Wassermolekül 3
        # H Atom Nr. 31
        self.x1_H31=self.x1_u1+60+4
        self.y1_H31=self.y1_u1+27-4
        self.x2_H31=self.x1_H31+15
        self.y2_H31=self.y1_H31+15
        self.canvas.create_oval(self.x1_H31, self.y1_H31, self.x2_H31, self.y2_H31,
                                fill='orange')
        # O Atom Nr. 31
        self.x1_O31=self.x1_u1+52+4
        self.y1_O31=self.y1_u1+32-4
        self.x2_O31=self.x1_O31+17
        self.y2_O31=self.y1_O31+17
        self.canvas.create_oval(self.x1_O31, self.y1_O31, self.x2_O31, self.y2_O31,
                                fill='orange')
        # H Atom Nr. 32
        self.x1_H32=self.x1_u1+58+4
        self.y1_H32=self.y1_u1+38-4
        self.x2_H32=self.x1_H32+15
        self.y2_H32=self.y1_H32+15
        self.canvas.create_oval(self.x1_H32, self.y1_H32, self.x2_H32, self.y2_H32,
                                fill='orange')
        # Zentralatom
        # Fe Atom Nr. 1
        self.x1_Fe1=self.x1_u1+14
        self.y1_Fe1=self.y1_u1+12
        self.x2_Fe1=self.x1_Fe1+40
        self.y2_Fe1=self.y1_Fe1+40
        self.canvas.create_oval(self.x1_Fe1, self.y1_Fe1, self.x2_Fe1, self.y2_Fe1,
                                fill='orange')
        # Ausgleich: x1-15; y1-22
        # Wassermolekül 4
        # H Atom Nr. 41
        self.x1_H41=self.x1_u1+70-15
        self.y1_H41=self.y1_u1+75-22
        self.x2_H41=self.x1_H41+15
        self.y2_H41=self.y1_H41+15
        self.canvas.create_oval(self.x1_H41, self.y1_H41, self.x2_H41, self.y2_H41,
                                fill='orange')
        # O Atom Nr. 41
        self.x1_O41=self.x1_u1+60-15
        self.y1_O41=self.y1_u1+67-22
        self.x2_O41=self.x1_O41+17
        self.y2_O41=self.y1_O41+17
        self.canvas.create_oval(self.x1_O41, self.y1_O41, self.x2_O41, self.y2_O41,
                                fill='orange')
        # H Atom Nr. 42
        self.x1_H42=self.x1_u1+57-15
        self.y1_H42=self.y1_u1+77-22
        self.x2_H42=self.x1_H42+15
        self.y2_H42=self.y1_H42+15
        self.canvas.create_oval(self.x1_H42, self.y1_H42, self.x2_H42, self.y2_H42,
                                fill='orange')
        # Wassermolekül 5
        # H Atom Nr. 51
        self.x1_H51=self.x1_u1+32-15
        self.y1_H51=self.y1_u1+84-22
        self.x2_H51=self.x1_H51+15
        self.y2_H51=self.y1_H51+15
        self.canvas.create_oval(self.x1_H51, self.y1_H51, self.x2_H51, self.y2_H51,
                                fill='orange')
        # O Atom Nr. 51
        self.x1_O51=self.x1_u1+37-15
        self.y1_O51=self.y1_u1+75-22
        self.x2_O51=self.x1_O51+17
        self.y2_O51=self.y1_O51+17
        self.canvas.create_oval(self.x1_O51, self.y1_O51, self.x2_O51, self.y2_O51,
                                fill='orange')
        # H Atom Nr. 52
        self.x1_H52=self.x1_u1+42-15
        self.y1_H52=self.y1_u1+87-22
        self.x2_H52=self.x1_H52+15
        self.y2_H52=self.y1_H52+15
        self.canvas.create_oval(self.x1_H52, self.y1_H52, self.x2_H52, self.y2_H52,
                                fill='orange')
        # Wassermolekül 6
        # H Atom Nr. 61
        self.x1_H61=self.x1_u1+10-15
        self.y1_H61=self.y1_u1+54-22
        self.x2_H61=self.x1_H61+15
        self.y2_H61=self.y1_H61+15
        self.canvas.create_oval(self.x1_H61, self.y1_H61, self.x2_H61, self.y2_H61,
                                fill='orange')
        # O Atom Nr. 61
        self.x1_O61=self.x1_u1+17-15
        self.y1_O61=self.y1_u1+58-22
        self.x2_O61=self.x1_O61+17
        self.y2_O61=self.y1_O61+17
        self.canvas.create_oval(self.x1_O61, self.y1_O61, self.x2_O61, self.y2_O61,
                                fill='orange')
        # H Atom Nr. 62
        self.x1_H62=self.x1_u1+15-15
        self.y1_H62=self.y1_u1+65-22
        self.x2_H62=self.x1_H62+15
        self.y2_H62=self.y1_H62+15
        self.canvas.create_oval(self.x1_H62, self.y1_H62, self.x2_H62, self.y2_H62,
                                fill='orange')

class edukt_b_Teilchen:
    def __init__(self, canvas, x1, y1):
        # SCN⁻
        self.canvas=canvas
        self.x1_u1=x1
        self.y1_u1=y1
        # S Atom Nr. 1
        self.x1_S1=self.x1_u1
        self.y1_S1=self.y1_u1
        self.x2_S1=self.x1_S1+17
        self.y2_S1=self.y1_S1+17
        self.canvas.create_oval(self.x1_S1, self.y1_S1, self.x2_S1, self.y2_S1,
                                fill='white')
        # C Atom Nr. 1
        self.x1_C1=self.x1_u1+8
        self.y1_C1=self.y1_u1+8
        self.x2_C1=self.x1_C1+17
        self.y2_C1=self.y1_C1+17
        self.canvas.create_oval(self.x1_C1, self.y1_C1, self.x2_C1, self.y2_C1,
                                fill='white')
        # N Atom Nr. 1
        self.x1_N1=self.x1_u1+16
        self.y1_N1=self.y1_u1+16
        self.x2_N1=self.x1_N1+17
        self.y2_N1=self.y1_N1+17
        self.canvas.create_oval(self.x1_N1, self.y1_N1, self.x2_N1, self.y2_N1,
                                fill='white')

class produkt_c_Teilchen:
    def __init__(self, canvas, x1, y1):
        # [Fe(H₂O)₃(SCN)₃]
        self.canvas=canvas
        self.x1_u1=x1
        self.y1_u1=y1
        # Zentralatom
        # Fe Atom Nr. 1
        self.x1_Fe1=self.x1_u1+28
        self.y1_Fe1=self.y1_u1+40
        self.x2_Fe1=self.x1_Fe1+40
        self.y2_Fe1=self.y1_Fe1+40
        self.canvas.create_oval(self.x1_Fe1, self.y1_Fe1, self.x2_Fe1, self.y2_Fe1,
                                fill='darkred')
        # Thiocyanationen 1 bis 3
        # S1 Atom Nr. 1
        self.x1_S1=self.x1_u1+40
        self.y1_S1=self.y1_u1+27
        self.x2_S1=self.x1_S1+17
        self.y2_S1=self.y1_S1+17
        self.canvas.create_oval(self.x1_S1, self.y1_S1, self.x2_S1, self.y2_S1,
                                fill='darkred')
        # C1 Atom Nr. 1
        self.x1_C1=self.x1_u1+40
        self.y1_C1=self.y1_u1+13
        self.x2_C1=self.x1_C1+17
        self.y2_C1=self.y1_C1+17
        self.canvas.create_oval(self.x1_C1, self.y1_C1, self.x2_C1, self.y2_C1,
                                fill='darkred')
        # N1 Atom Nr. 1
        self.x1_N1=self.x1_u1+40
        self.y1_N1=self.y1_u1+0
        self.x2_N1=self.x1_N1+17
        self.y2_N1=self.y1_N1+17
        self.canvas.create_oval(self.x1_N1, self.y1_N1, self.x2_N1, self.y2_N1,
                                fill='darkred')
        # S2 Atom Nr. 2
        self.x1_S2=self.x1_u1+18
        self.y1_S2=self.y1_u1+32
        self.x2_S2=self.x1_S2+17
        self.y2_S2=self.y1_S2+17
        self.canvas.create_oval(self.x1_S2, self.y1_S2, self.x2_S2, self.y2_S2,
                                fill='darkred')
        # C2 Atom Nr. 2
        self.x1_C2=self.x1_u1+8
        self.y1_C2=self.y1_u1+23
        self.x2_C2=self.x1_C2+17
        self.y2_C2=self.y1_C2+17
        self.canvas.create_oval(self.x1_C2, self.y1_C2, self.x2_C2, self.y2_C2,
                                fill='darkred')
        # N2 Atom Nr. 2
        self.x1_N2=self.x1_u1+0
        self.y1_N2=self.y1_u1+13
        self.x2_N2=self.x1_N2+17
        self.y2_N2=self.y1_N2+17
        self.canvas.create_oval(self.x1_N2, self.y1_N2, self.x2_N2, self.y2_N2,
                                fill='darkred')
        # S3 Atom Nr. 3
        self.x1_S3=self.x1_u1+60
        self.y1_S3=self.y1_u1+32
        self.x2_S3=self.x1_S3+17
        self.y2_S3=self.y1_S3+17
        self.canvas.create_oval(self.x1_S3, self.y1_S3, self.x2_S3, self.y2_S3,
                                fill='darkred')
        # C3 Atom Nr. 3
        self.x1_C3=self.x1_u1+70
        self.y1_C3=self.y1_u1+23
        self.x2_C3=self.x1_C3+17
        self.y2_C3=self.y1_C3+17
        self.canvas.create_oval(self.x1_C3, self.y1_C3, self.x2_C3, self.y2_C3,
                                fill='darkred')
        # N3 Atom Nr. 3
        self.x1_N3=self.x1_u1+77
        self.y1_N3=self.y1_u1+13
        self.x2_N3=self.x1_N3+17
        self.y2_N3=self.y1_N3+17
        self.canvas.create_oval(self.x1_N3, self.y1_N3, self.x2_N3, self.y2_N3,
                                fill='darkred')
        # Wasserliganden 1-3
        # Wassermolekül 1
        # H Atom Nr. 11
        self.x1_H11=self.x1_u1+70
        self.y1_H11=self.y1_u1+75
        self.x2_H11=self.x1_H11+15
        self.y2_H11=self.y1_H11+15
        self.canvas.create_oval(self.x1_H11, self.y1_H11, self.x2_H11, self.y2_H11,
                                fill='darkred')
        # O Atom Nr. 11
        self.x1_O11=self.x1_u1+60
        self.y1_O11=self.y1_u1+67
        self.x2_O11=self.x1_O11+17
        self.y2_O11=self.y1_O11+17
        self.canvas.create_oval(self.x1_O11, self.y1_O11, self.x2_O11, self.y2_O11,
                                fill='darkred')
        # H Atom Nr. 12
        self.x1_H12=self.x1_u1+57
        self.y1_H12=self.y1_u1+77
        self.x2_H12=self.x1_H12+15
        self.y2_H12=self.y1_H12+15
        self.canvas.create_oval(self.x1_H12, self.y1_H12, self.x2_H12, self.y2_H12,
                                fill='darkred')
        # Wassermolekül 2
        # H Atom Nr. 21
        self.x1_H21=self.x1_u1+32
        self.y1_H21=self.y1_u1+84
        self.x2_H21=self.x1_H21+15
        self.y2_H21=self.y1_H21+15
        self.canvas.create_oval(self.x1_H21, self.y1_H21, self.x2_H21, self.y2_H21,
                                fill='darkred')
        # O Atom Nr. 21
        self.x1_O21=self.x1_u1+37
        self.y1_O21=self.y1_u1+75
        self.x2_O21=self.x1_O21+17
        self.y2_O21=self.y1_O21+17
        self.canvas.create_oval(self.x1_O21, self.y1_O21, self.x2_O21, self.y2_O21,
                                fill='darkred')
        # H Atom Nr. 22
        self.x1_H22=self.x1_u1+42
        self.y1_H22=self.y1_u1+87
        self.x2_H22=self.x1_H22+15
        self.y2_H22=self.y1_H22+15
        self.canvas.create_oval(self.x1_H22, self.y1_H22, self.x2_H22, self.y2_H22,
                                fill='darkred')
        # Wassermolekül 3
        # H Atom Nr. 31
        self.x1_H31=self.x1_u1+10
        self.y1_H31=self.y1_u1+54
        self.x2_H31=self.x1_H31+15
        self.y2_H31=self.y1_H31+15
        self.canvas.create_oval(self.x1_H31, self.y1_H31, self.x2_H31, self.y2_H31,
                                fill='darkred')
        # O Atom Nr. 31
        self.x1_O31=self.x1_u1+17
        self.y1_O31=self.y1_u1+58
        self.x2_O31=self.x1_O31+17
        self.y2_O31=self.y1_O31+17
        self.canvas.create_oval(self.x1_O31, self.y1_O31, self.x2_O31, self.y2_O31,
                                fill='darkred')
        # H Atom Nr. 32
        self.x1_H32=self.x1_u1+15
        self.y1_H32=self.y1_u1+65
        self.x2_H32=self.x1_H32+15
        self.y2_H32=self.y1_H32+15
        self.canvas.create_oval(self.x1_H32, self.y1_H32, self.x2_H32, self.y2_H32,
                                fill='darkred')

class produkt_d_Teilchen:
    def __init__(self, canvas, x1, y1):
        # H₂O
        self.canvas=canvas
        self.x1_O1=x1
        self.y1_O1=y1
        # H-Atom Nr. 1
        self.x1_H1=self.x1_O1+12
        self.y1_H1=self.y1_O1+3
        self.x2_H1=self.x1_H1+15
        self.y2_H1=self.y1_H1+15
        self.canvas.create_oval(self.x1_H1, self.y1_H1, self.x2_H1, self.y2_H1,
                                fill='white')
        # O-Atom Nr. 1
        self.x2_O1=self.x1_O1+20
        self.y2_O1=self.y1_O1+20
        self.canvas.create_oval(self.x1_O1, self.y1_O1, self.x2_O1, self.y2_O1,
                                fill='white')
        # H-Atom Nr. 2
        self.x1_H2=self.x1_O1+5
        self.y1_H2=self.y1_O1+10
        self.x2_H2=self.x1_H2+15
        self.y2_H2=self.y1_H2+15
        self.canvas.create_oval(self.x1_H2, self.y1_H2, self.x2_H2, self.y2_H2,
                                fill='white')

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=4)
        self.frame2=Frame(frame, pady=4, padx=4)
        self.frame3=Frame(frame, pady=4, padx=4)
        self.frame4=Frame(frame, pady=4, padx=4)
        self.frame5=Frame(frame, pady=4, padx=4)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 1, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 2, 0, 1, E+W),
                (self.frame4, 3, 0, 1, E+W),
                (self.frame5, 4, 0, 1, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Farben und Zahlenverhältnisse der Teilchen
        ''' Farbtabelle:
        Darkred:            #8B8B00000000 (Dunkelroter Eisenthiocyanat-Komplex)
        Dunklere Farbe:     #A8A829290000 (Richtung Produkte/Endstoffe)
        Mittlere Farbe:     #C5C553530000
        Hellere Farbe:      #E2E27C7C0000 (Richtung Edukte/Ausgangsstoffe)
        Orange:             # FFFFA5A500 (Schwachgelber Eisenhexaqua-Komplex)
        '''
        # schluessel1:{schluessel2, ed_a, ed_b, prod_c, prod_d}
        self.gg={
        'X':{'1111':('#C5C553530000', 2, 6, 3, 6)
            },
        # TO DO: ÄNDERUNG der Koeffizienten anpassen 
        #        also Teilchen wegnehmen oder hinzufügen
        'edukt_a':{'0111':('#A8A829290000', 2, 3, 4, 9),
                   '1111':('#C5C553530000', 2, 6, 3, 6),
                   '2111':('#E2E27C7C0000', 2, 9, 2, 3),
                  },
        'edukt_b':{'1011':('#A8A829290000', 1, 6, 4, 9),
                   '1111':('#C5C553530000', 2, 6, 3, 6),
                   '1211':('#E2E27C7C0000', 3, 6, 2, 3),
                  },
        'produkt_c':{'1101':('#E2E27C7C0000', 3, 9, 3, 3),
                     '1111':('#C5C553530000', 2, 6, 3, 6),
                     '1121':('#A8A829290000', 1, 3, 3, 9),
                    },
        'produkt_d':{'1110':('#E2E27C7C0000', 3, 3, 2, 6),
                     '1111':('#C5C553530000', 2, 6, 3, 6),
                     '1112':('#A8A829290000', 1, 3, 4, 5),
                    },
        }

        # Rahmen 1: Zeichenfläche des Gefäßes und der Teilchen
        self.f1l1=Label(self.frame1, text='Farbe einer [Fe(H₂O)₃(SCN)₃]-Lösung:')
        self.f1canvas1=Canvas(self.frame1, bg='white', width=200, height=300)
        self.rect1=self.f1canvas1.create_rectangle(20,  20,   180, 280, width=2.5)
        self.f1l2=Label(self.frame1, text='Vergrößerte Teilchendarstellung:')
        self.f1canvas2=Canvas(self.frame1, bg='white', width=600, height=600)
        self.rect2=self.f1canvas2.create_rectangle(20,  20,   580, 580, width=2.5)
        # Rahmen 2: Reaktionsgleichung und Schieberegler
        self.f2l1=Label(self.frame2, text='Reaktionsgleichung:', anchor=NE, justify=RIGHT)
        self.f2l2=Label(self.frame2, text='[Fe(H₂O)₆]³⁺', fg='orange')
        self.f2l3=Label(self.frame2, text='+')
        self.f2l4=Label(self.frame2, text='3 SCN⁻')
        self.f2l5=Label(self.frame2, text='⇌')
        self.f2l6=Label(self.frame2, text='[Fe(H₂O)₃(SCN)₃]', fg='darkred')
        self.f2l7=Label(self.frame2, text='+')
        self.f2l8=Label(self.frame2, text='3 H₂O')
        self.f2l9=Label(self.frame2, text='Konzentration:', anchor=NE, justify=RIGHT)
        global a1
        a1=StringVar()
        a1.set('X')
        self.f2r1=Radiobutton(self.frame2, 
                              variable=a1,
                              value='edukt_a',
                              text='Edukt A',
                              indicatoron=0,
                              command=self.auswahl_stoff)
        self.f2r2=Radiobutton(self.frame2, 
                              variable=a1,
                              value='edukt_b',
                              text='Edukt B',
                              indicatoron=0,
                              command=self.auswahl_stoff)
        self.f2r3=Radiobutton(self.frame2, 
                              variable=a1,
                              value='produkt_c',
                              text='Produkt C',
                              indicatoron=0,
                              command=self.auswahl_stoff)
        self.f2r4=Radiobutton(self.frame2, 
                              variable=a1,
                              value='produkt_d',
                              text='Produkt D',
                              indicatoron=0,
                              command=self.auswahl_stoff)
        self.f2scale1=Scale(self.frame2,
                            length=80, from_=0, to=2, resolution=1, 
                            showvalue=0, orient=VERTICAL, 
                            command=self.werte_ermitteln)
        self.f2scale2=Scale(self.frame2,
                            length=80, from_=0, to=2, resolution=1, 
                            showvalue=0, orient=VERTICAL, 
                            command=self.werte_ermitteln)
        self.f2scale3=Scale(self.frame2,
                            length=80, from_=0, to=2, resolution=1, 
                            showvalue=0, orient=VERTICAL, 
                            command=self.werte_ermitteln)
        self.f2scale4=Scale(self.frame2,
                            length=80, from_=0, to=2, resolution=1, 
                            showvalue=0, orient=VERTICAL, 
                            command=self.werte_ermitteln)
        for scale, startwert in ((self.f2scale1, 1), (self.f2scale2, 1), 
                                 (self.f2scale3, 1), (self.f2scale4, 1)):
            scale.set(startwert)
            scale.config(state=DISABLED)
        # Rahmen 3: MWG
        self.f3l1=Label(self.frame3, text='Massenwirkungsgesetz:')
        self.f3l2=Label(self.frame3, text='c([Fe(H₂O)₃(SCN)₃])', fg='darkred')
        self.f3l3=Label(self.frame3, text='•')
        self.f3l4=Label(self.frame3, text='c(H₂O)³')
        self.f3l5=Label(self.frame3, text='K')
        self.f3l6=Label(self.frame3, text='=')
        self.f3l7=Label(self.frame3, text='――――――――――――――――――――――')
        self.f3l8=Label(self.frame3, text='c([Fe(H₂O)₆]³⁺)', fg='orange')
        self.f3l9=Label(self.frame3, text='•')
        self.f3l10=Label(self.frame3, text='c(SCN⁻)³')
        
        # Rahmen 4: 
        # Rahmen 5: Beenden-Knopf
        self.f5b1=Button(self.frame5, text='Zurücksetzen', command=self.zurueck_setzen)
        self.f5b2=Button(self.frame5, text='Beenden', command=root.destroy)
        
        # Fensterelemente anzeigen
        for i, row, columnspan, column, sticky in (
                # Rahmen 1
                (self.f1l1,         0, 1, 0, E+W), 
                (self.f1l2,         0, 1, 1, E+W), 
                (self.f1canvas1,    1, 1, 0, E+W), 
                (self.f1canvas2,    1, 1, 1, E+W), 
                # Rahmen 2
                (self.f2l1,         0, 1, 0, E+W), 
                (self.f2l2,         0, 1, 1, E+W), 
                (self.f2l3,         0, 1, 2, E+W), 
                (self.f2l4,         0, 1, 3, E+W), 
                (self.f2l5,         0, 1, 4, E+W),
                (self.f2l6,         0, 1, 5, E+W),
                (self.f2l7,         0, 1, 6, E+W),
                (self.f2l8,         0, 1, 7, E+W),
                (self.f2l9,         1, 1, 0, E+W),
                (self.f2r1,         1, 1, 1, E+W),
                (self.f2r2,         1, 1, 3, E+W),
                (self.f2r3,         1, 1, 5, E+W),
                (self.f2r4,         1, 1, 7, E+W), 
                (self.f2scale1,     2, 1, 1, E+W), 
                (self.f2scale2,     2, 1, 3, E+W), 
                (self.f2scale3,     2, 1, 5, E+W), 
                (self.f2scale4,     2, 1, 7, E+W),
                # Rahmen 3
                (self.f3l1,         0, 1, 0, E+W), 
                (self.f3l2,         0, 1, 3, E+W), 
                (self.f3l3,         0, 1, 4, E+W), 
                (self.f3l4,         0, 1, 5, E+W), 
                (self.f3l5,         1, 1, 1, E+W),
                (self.f3l6,         1, 1, 2, E+W),
                (self.f3l7,         1, 3, 3, E+W),
                (self.f3l8,         2, 1, 3, E+W),
                (self.f3l9,         2, 1, 4, E+W),
                (self.f3l10,        2, 1, 5, E+W),
                # Rahmen 5
                (self.f5b1,         0, 1, 0, E+W), 
                (self.f5b2,         0, 1, 1, E+W)
                ):
            i.grid(row=row, columnspan=columnspan, column=column)

    #######################   Funktionen   #####################################
    def zurueck_setzen(self):
        print('zurueck_setzen')
        for scale in (self.f2scale1, self.f2scale2, self.f2scale3, self.f2scale4):
            scale.config(state=NORMAL)
            scale.set(1)
            scale.config(state=DISABLED)
        for radio in (self.f2r1, self.f2r2, self.f2r3, self.f2r4):
            radio.config(state=NORMAL)
        a1.set('X')

    def auswahl_stoff(self):
        #print('auswahl_stoff')
        if a1.get() == 'edukt_a':
            self.f2scale1.config(state=NORMAL)
            self.f2r1.config(state=DISABLED)
            self.f2r2.config(state=DISABLED)
            self.f2r3.config(state=DISABLED)
            self.f2r4.config(state=DISABLED)
        elif a1.get() == 'edukt_b':
            self.f2scale2.config(state=NORMAL)
            self.f2r1.config(state=DISABLED)
            self.f2r2.config(state=DISABLED)
            self.f2r3.config(state=DISABLED)
            self.f2r4.config(state=DISABLED)
        elif a1.get() == 'produkt_c':
            self.f2scale3.config(state=NORMAL)
            self.f2r1.config(state=DISABLED)
            self.f2r2.config(state=DISABLED)
            self.f2r3.config(state=DISABLED)
            self.f2r4.config(state=DISABLED)
        elif a1.get() == 'produkt_d':
            self.f2scale4.config(state=NORMAL)
            self.f2r1.config(state=DISABLED)
            self.f2r2.config(state=DISABLED)
            self.f2r3.config(state=DISABLED)
            self.f2r4.config(state=DISABLED)
    
    def werte_ermitteln(self, a):
        #print('werte_ermitteln')
        self.schluessel1=str(a1.get())
        self.schluessel2=str(self.f2scale1.get())+str(self.f2scale2.get())+str(self.f2scale3.get())+str(self.f2scale4.get())
        # Gefäßfarbe anzeigen
        self.farbe=self.gg[self.schluessel1][self.schluessel2][0]
        self.rect1=self.f1canvas1.create_rectangle(20,  20,   180, 280, 
                                                   width=2.5, 
                                                   fill=self.farbe)
        # Teilchen anzeigen
        self.edukt_a=self.gg[self.schluessel1][self.schluessel2][1]
        self.edukt_b=self.gg[self.schluessel1][self.schluessel2][2]
        self.produkt_c=self.gg[self.schluessel1][self.schluessel2][3]
        self.produkt_d=self.gg[self.schluessel1][self.schluessel2][4]
        for i in self.f1canvas2.find_all():
            self.f1canvas2.delete(i)
        # Rahmen bei beiden Varianten neu zeichnen
        self.rect2=self.f1canvas2.create_rectangle(20,  20,   580, 580, width=2.5)
        for i in range(0, self.edukt_a):
            x1=random.randint(40, 510)
            y1=random.randint(40, 500)
            self.i=edukt_a_Teilchen(self.f1canvas2, x1, y1)
        for j in range(0, self.edukt_b):
            x1=random.randint(40, 520)
            y1=random.randint(40, 520)
            self.j=edukt_b_Teilchen(self.f1canvas2, x1, y1)
        for i in range(0, self.produkt_c):
            x1=random.randint(40, 490)
            y1=random.randint(40, 420)
            self.i=produkt_c_Teilchen(self.f1canvas2, x1, y1)
        for j in range(0, self.produkt_d):
            x1=random.randint(40, 520)
            y1=random.randint(40, 520)
            self.j=produkt_d_Teilchen(self.f1canvas2, x1, y1)
        
        # Leinwand updaten
        self.f1canvas2.config(background='white')
        self.f1canvas2.update()
    
################################################################################
root = Tk()
root.title('Gleichgewichtkonzentrierer')
app = Fenster(root)
root.mainloop()
