#!/usr/bin/env python3
# -*- encoding: utf-8 -*-
## Zeichensatz fuer Umlaute alternativ mit:
## encoding: utf-8
## und in den Daten mit Unicode z.B. u'\xe4' = ä

# daten.py
# Daten fuer den formulator.pyw
# Salzformel-Generator

## Autor: Joachim Jakob
##        Kronberg-Gymnasiuim Aschaffenburg
## Lizenz: GNU GENERAL PUBLIC LICENSE (GPL)
## einzusehen unter:
## http://www.gnu.org/licenses/gpl.html

import codecs

## Metalle:

# Elementname als Schluessel,
# Daten in einer Liste in der Reihenfolge:
# Elementsymbol, Betrag der Ladung, Name als Kation


M ={'Lithium':['Li',1,'Lithium'],
    'Sodium':['Na',1,'Sodium'],
    'Potassium':['K',1,'Potassium'],
    'Rubidium':['Rb',1,'Rubidium'],
    'Caesium':['Cs',1,'Caesium'],
    'Francium':['Fr',1,'Francium'],
    'Beryllium':['Be',2,'Beryllium'],
    'Magnesium':['Mg',2,'Magnesium'],
    'Calcium':['Ca',2,'Calcium','1'],
    'Strontium':['Sr',2,'Strontium'],
    'Barium':['Ba',2,'Barium'],
    'Radium':['Ra',2,'Radium'],
    'Aluminium':['Al',3,'Aluminium'],
    'Gallium':['Ga',3,'Gallium'],
    'Indium':['In',3,'Indium'],
    'Thallium':['Tl',3,'Thallium'],
    'Germanium':['Ge',4,'Germanium'],
    'Tin':['Sn',4,'Tin'],
    'Lead':['Pb',4,'Lead(IV)'],
    'Copper':['Cu',2,'Copper(II)'],
    'Iron':['Fe',3,'Iron(III)'],
    'Zinc':['Zn',2,'Zinc(II)'],
    'Silver':['Ag',1,'Silver(I)'],
    'Ammonium':['NH₄',1,'Ammonium'],
    'Nitrosyl':['NO',1,'Nitrosyl'],
    'Tetraalkylamminium':['[N(CH₂R)₄]',1,'Tetralkylammonium'],
    'Anilinium':['C₆H₅NH₃',1,'Anilin']
    }

# Nichtmetalle

# Elementname als Schluessel,
# Daten in einer Liste in der Reihenfolge:
# Elementsymbol ohne Ladung, Betrag der Ladung, 
# Name als Anion


N ={'Carbon':['(C₂)',2,'acetylide'],
    'Carbidion':['C',4,'carbide'],
    'Acetylide':['(C₂)',2,'acetylide'],
    'Nitrogen':['N',3,'nitride'],
    'Phosphorus':['P',3,'phosphide'],
    'Arsenic':['As',3,'arsenide'],
    'Oxygen':['O',2,'oxide'],
    'Sulfur':['S',2,'sulfide'],
    'Selenium':['Se',2,'selenide'],
    'Fluorine':['F',1,'fluoride'],
    'Chlorine':['Cl',1,'chlorid'],
    'Bromine':['Br',1,'bromide'],
    'Iodine':['I',1,'iodide'],
    'Hydrogen carbonate':['HCO₃',1,'hydrogencarbonate'],
    'Carbonate':['CO₃',2,'carbonate'],
    'Nitrate':['NO₃',1,'nitrate'],
    'Hydrogensulfate':['HSO₄',1,'hydrogensulfate'],
    'Sulfate':['SO₄',2,'sulfate'],
    'Dihydrogenphosphate':['H₂PO₄',1,'dihydrogenphosphate'],
    'Hydrogenphosphate':['HPO₄',2,'hydrogenphosphate'],
    'Hydrogensulfite':['HSO₃',1,'hydrogensulfite'],
    'Sulfite':['SO₃',2,'sulfite'],
    'Nitrite':['NO₂',1,'nitrite'],
    'Hydroxide':['OH',1,'hydroxide'],
    'Hydrogensulfe':['HS',1,'hydrogensulfide'],
    'Amide':['NH₂',1,'amide'],
    'Peroxide':['(O₂)',2,'peroxide'],
    'Permanganate':['MnO₄',1,'permanganate'],
    'Dichromate':['Cr₂O₇',2,'dichromate'],
    'Chromate':['CrO₄',2,'chromate'],
    'Chlorite':['ClO₂',1,'chlorite'],
    'Chlorate':['ClO₃',1,'chlorate'],
    'Perchlorate':['ClO₄',1,'perchlorate'],
    'Hypobromite':['BrO',1,'hypobromite'],
    'Bromite':['BrO₂',1,'bromite'],
    'Bromate':['BrO₃',1,'bromate'],
    'Perbromate':['BrO₄',1,'perbromate'],
    'Hypoiodite':['IO',1,'hypoiodite'],
    'Iodite':['IO₂','iodite'],
    'Iodate':['IO₃','iodate'],
    'Periodate':['IO₄',1,'periodate'],
    'Dithionate':['S₂O₆',2,'dithionate'],
    'Peroxidisulfate':['S₂O₈',2,'peroxidisulfate'],
    'Selenite':['SeO₃',2,'selenite'],
    'Selenate':['SeO₄',2,'selenate'],
    'Tellurate':['TeO₄',2,'tellurate'],
    'Arsenate':['AsO₄',3,'arsenate'],
    'Silicate':['SiO₄',4,'silicate'],
    'Borate':['BO₃',3,'borate'],
    'Molybdate':['MoO₄',2,'molybdate'],
    'Cyanate':['OCN',1,'cyanate'],
    'Thiocyanate':['SCN',1,'thiocyanate'],
    'Thiosulfate':['S₂O₃',2,'thiosulfate'],
    'Cyanide':['CN',1,'cyanide'],
    'Azide':['N₃',1,'azide'],
    'Aluminiumtetrachloride':['[AlCl₄]',1,'aluminiumtetrachloride'],
    'Hexachlorophosphate':['[PCl₆]',1,'hexachlorophosphate'],
    'Hexafluoroarsenate':['[AsF₆]',6,'hexafluoroarsenate'],
    'Acetate':['CH₃COO',1,'acetate'],
    'Butyrate':['CH₃CH₂CH₂COO',1,'butyrate'],
    'Citrate':['[C(OH)(CH₃COO)₃]',3,'citrate'],
    'Formiate':['HCOO',1,'formiate'],
    'Fumarate':['OOCCH=CHCOO',2,'fumarate'],
    'Glutarate':['OOCCH₂CH₂CH₂COO',2,'glutarate'],
    'Lactate':['CH₃CHOHCOO',1,'lactate'],
    'Laktate':['CH₃CHOHCOO',1,'laktate'],
    'Oxalate':['OOCCOO',2,'oxalate'],
    'Pyruvate':['CH₃COCOOH',1,'pyruvate'],
    'Tartrate':['OOCCHOCCHOCCOO',2,'tartrate'],
    'Hexacyanoferrate':['[Fe(CN)₆]',4,'hexacyanoferrate(II)'],
    'Ethanolate':['CH₃CH₂O',1,'ethanolate'],
    'Phosphate':['PO₄', 3, 'phosphate']
    }
