#!/usr/bin/env python3
# -*- coding: utf-8 -*-
## Zeichensatz fuer Umlaute alternativ mit:
## encoding: utf-8
## und in den Daten mit Unicode z.B. u'\xe4' = ä

# formulator.pyw
# Salzformel-Generator

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import codecs

## Import des TK-GUI-Moduls:
from tkinter import *
from tkinter import font

######################################################
# Summenformelgenerator fuer einfache binaere Salze  #
# Eingabe der Elementnamen der Ausgangsstoffe, also  #
# des Metalls und des Nichtmetalls                   #
# beschraenkt auf die Hauptgruppen,                  #
# aber ohne die meisten Halbmetalle                  #
######################################################

import sys
sys.path.insert(0, 'daten')

from daten import M
from daten import N


## Klassendefinition (Vgl. Objektorientierung im LP Informatik)

class Fenster:

    def __init__(self, master):

        frame = Frame(master)
        frame.pack()

        ## Schriften festlegen
        helv16 = font.Font(family='Helvetica', size=12, weight='bold')
        helv14 = font.Font(family='Helvetica', size=11)
        courier14 = font.Font(family='courier new', size=11, weight='bold')
        courier22 = font.Font(family='courier new', size=14, weight='bold')

        ## Ausgangsvariablen-Deklaration c fuer Kontrollvariablen z.B. in Labels

        ## Metallbestandteil
        # Elementname
        global cMN
        cMN=StringVar()
        cMN.set('Metall')
        # Elementsymbol
        global cMS
        cMS=StringVar()
        cMS.set('Me')
        # Koeffizient
        global cMK
        cMK=IntVar()
        cMK.set(1)

        ## Nichtmetallbestandteil
        # Elementname
        global cNN
        cNN=StringVar()
        cNN.set('nichtmetallid')
        # Elementsymbol
        global cNS
        cNS=StringVar()
        cNS.set('Ni')
        # Koeffizient
        global cNK
        cNK=IntVar()
        cNK.set(1)

        ## Eingabe des Elementnamens...
        self.l1 = Label(frame, text='Eingabefeld:', font=helv16)
        self.l1.grid(row=0, column=0, columnspan=6, padx=8, pady=8)

        # ...des Metalls
        self.l2 = Label(frame, 
                        text='Elementname des Metalls oder\nName des zusammengesetzten Kations mit der Endung \'-ion\':', 
                        font=helv14,
                        anchor=E,
                        justify=RIGHT)
        self.l2.grid(row=1, column=0, columnspan=2, padx=8, pady=8, sticky=E)
        self.e1 = Entry(frame, width=40, font=helv14, bg='white')
        self.e1.bind("<Return>", self.berechnen_enter)
        self.e1.grid(row=1, column=2, columnspan=4, padx=8, pady=8)

        # ...des Nichtmetalls
        self.l3 = Label(frame, 
                        text='Elementname des Nichtmetalls oder\nName des Säureanions mit der Endung \'-ion\':', 
                        font=helv14,
                        anchor=E,
                        justify=RIGHT)
        self.l3.grid(row=2, column=0, columnspan=2, padx=8, pady=8, sticky=E)
        self.e2 = Entry(frame, width=40, font=helv14, bg='white')
        self.e2.bind("<Return>", self.berechnen_enter)
        self.e2.grid(row=2, column=2, columnspan=4, padx=8, pady=8)

        ## Ausgabe der Summenformel
        self.l4 = Label(frame, text='Ausgabefeld:', font=helv16)
        self.l4.grid(row=3, column=0, columnspan=6, padx=8, pady=8)

        # ...des Metallbestandteils
        self.l5 = Label(frame, textvariable=cMS, font=courier22, relief=RIDGE)
        self.l5.grid(row=4, column=1, padx=8, pady=8, sticky=E+W)
        self.l6 = Label(frame, textvariable=cMK, font=courier14, relief=RIDGE)
        self.l6.grid(row=5, column=2, sticky=E+W)

        # ... des Nichtmetallbestandteils
        self.l7 = Label(frame, textvariable=cNS, font=courier22, relief=RIDGE)
        self.l7.grid(row=4, column=3, padx=8, pady=8, sticky=E+W)
        self.l8 = Label(frame, textvariable=cNK, font=courier14, relief=RIDGE)
        self.l8.grid(row=5, column=4, sticky=E+W)

        # Hinweis zum Kuerzen der Koeffizienten:
        self.l9 = Label(frame, text=u'Evtl. k\xfcrzen!', font=helv14)
        self.l9.grid(row=5, column=5, padx=8, pady=8)

        # ... des Salznamens
        self.l10 = Label(frame, textvariable=cMN, font=helv14, relief=RIDGE)
        self.l10.grid(row=6, column=1, padx=8, pady=8)
        self.l11 = Label(frame, textvariable=cNN, font=helv14, relief=RIDGE)
        self.l11.grid(row=6, column=3, padx=8, pady=8)

        ## Berechnen
        self.b5 = Button(frame, text='Summenformel und Namen des Salzes ermitteln', command=self.berechnen_knopf)
        self.b5.grid(row=20, column=0, columnspan=4, padx=8, pady=8, sticky=E+W)

        ## Abbruch
        self.b5 = Button(frame, text='Programm Beenden', command=frame.quit)
        self.b5.grid(row=20, column=4, columnspan=2, padx=8, pady=8, sticky=E+W)

    # Funktion, die bei Druecken des Buttons b5 aufgerufen wird
    def berechnen_knopf(self):

        # Eingabe-Werte holen
        global Me
        Me = self.e1.get()
        global Ni
        Ni = self.e2.get()

        # Elementsymbole einfuegen:
        global MetallSymbol
        MetallSymbol = str(M[Me][0])
        cMS.set(MetallSymbol)
        global NichtmetallSymbol
        NichtmetallSymbol = str(N[Ni][0]) 
        cNS.set(NichtmetallSymbol)       

        ## Koeffizienten berechnen:
        global MetallLadung
        MetallLadung = M[Me][1]
        cNK.set(MetallLadung)
        global NichtmetallLadung
        NichtmetallLadung = N[Ni][1]
        cMK.set(NichtmetallLadung)
        # Wer moechte, kann gerne auch das
        # automatische Kuerzen noch einbauen!

        ## Saznamen ermitteln:
        global MetallKation
        MetallKation = str(M[Me][2])
        cMN.set(MetallKation)
        global NichtmetallAnion
        NichtmetallAnion = str(N[Ni][2])
        cNN.set(NichtmetallAnion)

    # Funktion, die bei Druecken der Eingabetaste aufgerufen wird
    def berechnen_enter(self, event):

        # Eingabe-Werte holen
        global Me
        Me = self.e1.get()
        global Ni
        Ni = self.e2.get()

        # Elementsymbole einfuegen:
        global MetallSymbol
        MetallSymbol = str(M[Me][0])
        cMS.set(MetallSymbol)
        global NichtmetallSymbol
        NichtmetallSymbol = str(N[Ni][0]) 
        cNS.set(NichtmetallSymbol)       

        ## Koeffizienten berechnen:
        global MetallLadung
        MetallLadung = M[Me][1]
        cNK.set(MetallLadung)
        global NichtmetallLadung
        NichtmetallLadung = N[Ni][1]
        cMK.set(NichtmetallLadung)
        # Wer moechte, kann gerne auch das
        # automatische Kuerzen noch einbauen!

        ## Saznamen ermitteln:
        global MetallKation
        MetallKation = str(M[Me][2])
        cMN.set(MetallKation)
        global NichtmetallAnion
        NichtmetallAnion = str(N[Ni][2])
        cNN.set(NichtmetallAnion)


root = Tk()
root.title('Formulator')

app = Fenster(root)

root.mainloop()
