#!/usr/bin/env python3
# -*- encoding: utf-8 -*-
## Zeichensatz fuer Umlaute alternativ mit:
## encoding: utf-8
## und in den Daten mit Unicode z.B. u'\xe4' = ä

# daten.py
# Daten fuer den formulator.pyw
# Salzformel-Generator

## Autor: Joachim Jakob
##        Kronberg-Gymnasiuim Aschaffenburg
## Lizenz: GNU GENERAL PUBLIC LICENSE (GPL)
## einzusehen unter:
## http://www.gnu.org/licenses/gpl.html

import codecs

## Metalle:

# Elementname als Schluessel,
# Daten in einer Liste in der Reihenfolge:
# Elementsymbol, Betrag der Ladung, Name als Kation


M ={'Lithium':['Li',1,'Lithium'],
    'Natrium':['Na',1,'Natrium'],
    'Kalium':['K',1,'Kalium'],
    'Rubidium':['Rb',1,'Rubidium'],
    'Caesium':['Cs',1,'Caesium'],
    'Francium':['Fr',1,'Francium'],
    'Beryllium':['Be',2,'Beryllium'],
    'Magnesium':['Mg',2,'Magnesium'],
    'Calcium':['Ca',2,'Calcium','1'],
    'Strontium':['Sr',2,'Strontium'],
    'Barium':['Ba',2,'Barium'],
    'Radium':['Ra',2,'Radium'],
    'Aluminium':['Al',3,'Aluminium'],
    'Gallium':['Ga',3,'Gallium'],
    'Indium':['In',3,'Indium'],
    'Thallium':['Tl',3,'Thallium'],
    'Germanium':['Ge',4,'Germanium'],
    'Zinn':['Sn',4,'Zinn'],
    'Blei':['Pb',4,'Blei(IV)'],
    'Kupfer':['Cu',2,'Kupfer(II)'],
    'Eisen':['Fe',3,'Eisen(III)'],
    'Zink':['Zn',2,'Zink(II)'],
    'Silber':['Ag',1,'Silber(I)'],
    'Ammoniumion':['NH₄',1,'Ammonium'],
    'Nitrosyl':['NO',1,'nitrosyl'],
    'Tetraalkylamminiumion':['[N(CH₂R)₄]',1,'tetralkylammonium'],
    'Aniliniumion':['C₆H₅NH₃',1,'anilin']
    }

# Nichtmetalle

# Elementname als Schluessel,
# Daten in einer Liste in der Reihenfolge:
# Elementsymbol ohne Ladung, Betrag der Ladung, 
# Name als Anion


N ={'Kohlenstoff':['(C₂)',2,'acetylid'],
    'Carbidion':['C',4,'carbid'],
    'Acetylidion':['(C₂)',2,'acetylid'],
    'Stickstoff':['N',3,'nitrid'],
    'Phosphor':['P',3,'phosphid'],
    'Arsen':['As',3,'arsenid'],
    'Sauerstoff':['O',2,'oxid'],
    'Schwefel':['S',2,'sulfid'],
    'Selen':['Se',2,'selenid'],
    'Fluor':['F',1,'fluorid'],
    'Chlor':['Cl',1,'chlorid'],
    'Brom':['Br',1,'bromid'],
    'Iod':['I',1,'iodid'],
    'Hydrogencarbonation':['HCO₃',1,'hydrogencarbonat'],
    'Carbonation':['CO₃',2,'carbonat'],
    'Nitration':['NO₃',1,'nitrat'],
    'Hydrogensulfation':['HSO₄',1,'hydrogensulfat'],
    'Sulfation':['SO₄',2,'sulfat'],
    'Dihydrogenphosphation':['H₂PO₄',1,'dihydrogenphosphat'],
    'Hydrogenphosphation':['HPO₄',2,'hydrogenphosphat'],
    'Hydrogensulfition':['HSO₃',1,'hydrogensulfit'],
    'Sulfition':['SO₃',2,'sulfit'],
    'Nitrition':['NO₂',1,'nitrit'],
    'Hydroxidion':['OH',1,'hydroxid'],
    'Hydrogensulfidion':['HS',1,'hydrogensulfid'],
    'Amidion':['NH₂',1,'amid'],
    'Peroxidion':['(O₂)',2,'peroxid'],
    'Permanganation':['MnO₄',1,'permanganat'],
    'Dichromation':['Cr₂O₇',2,'dichromat'],
    'Chromation':['CrO₄',2,'chromat'],
    'Chlorition':['ClO₂',1,'chlorit'],
    'Chloration':['ClO₃',1,'chlorat'],
    'Perchloration':['ClO₄',1,'perchlorat'],
    'Hypobromition':['BrO',1,'hypobromit'],
    'Bromition':['BrO₂',1,'bromit'],
    'Bromation':['BrO₃',1,'bromat'],
    'Perbromation':['BrO₄',1,'perbromat'],
    'Hypoiodition':['IO',1,'hypoiodit'],
    'Iodition':['IO₂','iodit'],
    'Iodation':['IO₃','iodat'],
    'Periodation':['IO₄',1,'periodat'],
    'Dithionation':['S₂O₆',2,'dithionat'],
    'Peroxidisulfation':['S₂O₈',2,'peroxidisulfat'],
    'Selenition':['SeO₃',2,'selenit'],
    'Selenation':['SeO₄',2,'selenat'],
    'Telluration':['TeO₄',2,'tellurat'],
    'Arsenation':['AsO₄',3,'arsenat'],
    'Silikation':['SiO₄',4,'silikat'],
    'Boration':['BO₃',3,'borat'],
    'Molybdation':['MoO₄',2,'molybdat'],
    'Cyanation':['OCN',1,'cyanat'],
    'Thiocyanation':['SCN',1,'thiocyanat'],
    'Thiosulfation':['S₂O₃',2,'thiosulfat'],
    'Cyanidion':['CN',1,'cyanid'],
    'Azidion':['N₃',1,'azid'],
    'Aluminiumtetrachloridion':['[AlCl₄]',1,'aluminiumtetrachlorid'],
    'Hexachlorophosphation':['[PCl₆]',1,'hexachlorophosphat'],
    'Hexafluoroarsenation':['[AsF₆]',6,'hexafluoroarsenat'],
    'Acetation':['CH₃COO',1,'acetat'],
    'Butyration':['CH₃CH₂CH₂COO',1,'butyrat'],
    'Citration':['[C(OH)(CH₃COO)₃]',3,'citrat'],
    'Formiation':['HCOO',1,'formiat'],
    'Fumaration':['OOCCH=CHCOO',2,'fumarat'],
    'Glutaration':['OOCCH₂CH₂CH₂COO',2,'glutarat'],
    'Lactation':['CH₃CHOHCOO',1,'lactat'],
    'Laktation':['CH₃CHOHCOO',1,'laktat'],
    'Oxalation':['OOCCOO',2,'oxalat'],
    'Pyruvation':['CH₃COCOOH',1,'pyruvat'],
    'Tartration':['OOCCHOCCHOCCOO',2,'tartrat'],
    'Hexacyanoferration':['[Fe(CN)₆]',4,'hexacyanoferrat(II)'],
    'Ethanolation':['CH₃CH₂O',1,'ethanolat'],
    'Phosphation':['PO₄', 3, 'phosphat']
    }
