#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *
import os
import string
import webbrowser

textfeld_schriftart='arial'
textfeld_schriftgroesse='11'
textfeld_schrift=textfeld_schriftart+' '+textfeld_schriftgroesse

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, bd=2, padx=2, pady=2)
        self.frame2=Frame(frame, bd=2, padx=2, pady=2)
        self.frame3=Frame(frame)
        for f, row, column, columnspan in ((frame,       0, 0, 1),
                                           (self.frame1, 1, 0, 1),
                                           (self.frame2, 2, 0, 1),
                                           (self.frame3, 3, 0, 1)):
            f.grid(row=row, column=column, columnspan=columnspan)

        ## Daten zu den verschiedenen Fettsäuren
        self.fettsaeuren={
        '4_0_kdb_kdb':('Buttersäure', 
                       # Butyric acid, butanoic acid, 
                       # CID 264
                       'Butansäure', 
                       'C₃H₇COOH', 
                       '-8 °C',
                       'Milchfett, Schweiß',
                       'buttersaeure'),
        '14_0_kdb_kdb':('Myristinsäure', 
                        # Myristic acid, tetradecanoic acid 
                        # CID 11005
                        'Tetradecansäure', 
                        'C₁₃H₂₇COOH', 
                        '53,9 °C',
                        'Milchfett, Fischöl, Tier- und Pflanzenfette',
                        'myristinsaeure'),
        '14_1_9_nein':('Myristoleinsäure', 
                       # Myristoleic acid, (Z)-9-tetradecenoic acid
                       # CID 5281119
                       '(9Z)-Tetradeca-9-ensäure',
                       'C₁₃H₂₅COOH', 
                       'k.a.',
                       'Muskatnussöl',
                       'myristoleinsaeure'),
        '16_0_kdb_kdb':('Palmitinsäure', 
                        # Palmitic acid, hexadecanoic acid
                        # CID 985
                        'Hexadecansäure',
                        'C₁₅H₃₁COOH',
                        '62,8 °C',
                        'Tier- und Pflanzenfette',
                        'palmitinsaeure'),
        '16_1_9_nein':('Palmitoleinsäure', 
                       # Palmitoleic acid, (Z)-9-hexadecenoic acid
                       # CID 445638
                       '(9Z)-Hexadeca-9-ensäure',
                       'C₁₅H₂₉COOH',
                       '1 °C',
                       'Milchfett, Depotfett der Tiere, Fischtran, Pflanzenfett',
                       'palmitoleinsaeure'),
        '18_0_kdb_kdb':('Stearinsäure', 
                        # Stearic acid, octadecanoic acid 
                        # CID 5281 nur 2D !!!, http://cdb.ics.uci.edu chemical_id=3968623
                        'Octadecansäure',
                        'C₁₇H₃₅COOH',
                        '69,9 °C',
                        'Tier- und Pflanzenfette',
                        'stearinsaeure'),
        '18_1_6_nein':('Petroselinsäure', 
                       # Petroselaidic/Petroselic acid, (Z)-6-octadecenoic acid
                       # CID 11634 nur trans !!!, http://cdb.ics.uci.edu chemical_id=6694078
                       '(6Z)-Octadeca-6-ensäure',
                       'C₁₇H₃₃COOH',
                       '30 °C',
                       'Korianderöl',
                       'petroselinsaeure'),
        '18_1_9_nein':('Ölsäure', 
                       # Oleic acid, (Z)-9-octadecenoic acid
                       # CID 445639
                       '(9Z)-Octadeca-9-ensäure',
                       'C₁₇H₃₃COOH',
                       '16 °C',
                       'In allen Naturfetten',
                       'oelsaeure'),
        '18_1_9_ja':('Elaidinsäure', 
                     # Elaidic acid, (E)-9-octadecenoic acid
                     # CID 637517
                     '(9E)-Octadeca-9-ensäure',
                     'C₁₇H₃₃COOH',
                     '44 - 51 °C',
                     'Im Fett von Wiederkäuern',
                     'elaidinsaeure'),
        '18_2_9_nein':('Linolsäure', 
                       # Linoleic acid, (Z, Z)-9,12-octadecadienoic acid
                       # CID 5280450
                       '(9Z, 12Z)-Octadeca-9,12-diensäure',
                       'C₁₇H₃₁COOH',
                       '-5 °C',
                       'Distelöl, Sonnenblumenöl, Traubenkernöl',
                       'linolsaeure'),
        '18_3_9_nein':('α-Linolensäure', 
                       # α-Linolenic acid, (9Z,12Z,15Z)-octadeca-9,12,15-trienoic acid, all-cis-9,12,15-octadecatrienoic acid
                       # CID 5280934
                       '(9Z, 12Z, 15Z)-Octadeca-9,12,15-triensäure',
                       'C₁₇H₂₉COOH',
                       '-11 °C',
                       'Leinöl, Walnussöl, Hanföl, Rapsöl, Sojaöl',
                       'alphalinolensaeure'),
        '18_3_6_nein':('γ-Linolensäure', 
                       # γ-Linolenic acid, (6Z,9Z,12Z)-octadeca-9,12,15-trienoic acid, all-cis-6,9,12-octadecatrienoic acid
                       # CID 5280933
                       '(6Z, 9Z, 12Z)-Octadeca-6,9,12-triensäure',
                       'C₁₇H₂₉COOH',
                       '-11 °C',
                       'Borretschöl, Nachtkerzenöl, Hanföl',
                       'gammalinolensaeure'),
        '18_3_9_ja':('Punicinsäure', 
                     # Punicic acid, 9Z,11E,13Z-octadeca-9,11,13-trienoic acid
                     # CID 5281126
                     '(9Z, 11E, 13Z)-Octadeca-9,11,13-triensäure',
                     'C₁₇H₂₉COOH',
                     'k.a.',
                     'Kernöl des Granatapfels',
                     'punicinsaeure'),
        '20_0_kdb_kdb':('Arachinsäure', 
                        # Arachidic acid, eicosanoic acid
                        # CID 10467 nur 2D !!!, http://cdb.ics.uci.edu chemical_id=4118951
                        'Eicosansäure (= Icosansäure)',
                        'C₁₉H₃₉COOH',
                        '75,4 °C',
                        'Geringe Mengen in Pflanzensamen und Tierfetten',
                        'arachinsaeure'),
        '20_1_9_nein':('Gadoleinsäure', 
                       # Gadoleic  acid, cis-icos-9-enoic acid
                       # CID 5282767 nur 2D !!!, http://cdb.ics.uci.edu chemical_id=7608543
                       '(9Z)-Eicosa-9-ensäure',
                       'C₁₉H₃₇COOH',
                       'k.a.',
                       'Jojobaöl',
                       'gadoleinsaeure'),
        '20_1_11_nein':('Icosensäure', 
                        # Gondoic  acid, cis-icos-11-enoic acid, cis-eicos-11-enoic acid
                        # CID 5282768 nur 2D !!!, http://cdb.ics.uci.edu chemical_id=6680390
                        '(11Z)-Eicosa-11-ensäure',
                        'C₁₉H₃₇COOH',
                        '16 °C',
                        'Rapsöl',
                        'icosensaeure')
        }

        ## Rahmen 1: Auswahl
        self.f1l1=Label(self.frame1, 
                        text='Zahl der \nC-Atome:', 
                        anchor=W, 
                        justify=LEFT, 
                        padx=2)
        global c_anzahl
        c_anzahl=StringVar()
        c_anzahl.set('X')
        self.f1r1=Radiobutton(self.frame1, 
                              variable=c_anzahl,
                              text='4',
                              value='4',
                              command=self.setze_c_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1r2=Radiobutton(self.frame1, 
                              variable=c_anzahl,
                              text='14',
                              value='14',
                              command=self.setze_c_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1r3=Radiobutton(self.frame1, 
                              variable=c_anzahl,
                              text='16',
                              value='16',
                              command=self.setze_c_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1r4=Radiobutton(self.frame1, 
                              variable=c_anzahl,
                              text='18',
                              value='18',
                              command=self.setze_c_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1r5=Radiobutton(self.frame1, 
                              variable=c_anzahl,
                              text='20',
                              value='20',
                              command=self.setze_c_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1l2=Label(self.frame1, 
                        text='Zahl der \nDoppelbindungen:', 
                        anchor=W, 
                        justify=LEFT, 
                        padx=2)
        global db_anzahl
        db_anzahl=StringVar()
        db_anzahl.set('X')
        self.f1r6=Radiobutton(self.frame1, 
                              variable=db_anzahl,
                              text='0',
                              value='0',
                              command=self.setze_db_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1r7=Radiobutton(self.frame1, 
                              variable=db_anzahl,
                              text='1',
                              value='1',
                              command=self.setze_db_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1r8=Radiobutton(self.frame1, 
                              variable=db_anzahl,
                              text='2',
                              value='2',
                              command=self.setze_db_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1r9=Radiobutton(self.frame1, 
                              variable=db_anzahl,
                              text='3',
                              value='3',
                              command=self.setze_db_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1r10=Radiobutton(self.frame1, 
                              variable=db_anzahl,
                              text='4',
                              value='4',
                              command=self.setze_db_anzahl,
                              anchor=W,
                              justify=LEFT)
        self.f1l3=Label(self.frame1, 
                        text='Stellung der \nersten Doppelbindung:', 
                        anchor=W, 
                        justify=LEFT, 
                        padx=2)
        global db_stellung
        db_stellung=StringVar()
        db_stellung.set('X')
        self.f1r11=Radiobutton(self.frame1, 
                              variable=db_stellung,
                              text='6',
                              value='6',
                              command=self.setze_db_stellung,
                              anchor=W,
                              justify=LEFT)
        self.f1r12=Radiobutton(self.frame1, 
                              variable=db_stellung,
                              text='9',
                              value='9',
                              command=self.setze_db_stellung,
                              anchor=W,
                              justify=LEFT)
        self.f1r15=Radiobutton(self.frame1, 
                              variable=db_stellung,
                              text='11',
                              value='11',
                              command=self.setze_db_stellung,
                              anchor=W,
                              justify=LEFT)
        self.f1l4=Label(self.frame1, 
                        text='trans-Fettsäure?', 
                        anchor=W, 
                        justify=LEFT, 
                        padx=2)
        global transf
        transf=StringVar()
        transf.set('X')
        self.f1r13=Radiobutton(self.frame1, 
                              variable=transf,
                              text='nein',
                              value='nein',
                              command=self.setze_transf,
                              anchor=W,
                              justify=LEFT)
        self.f1r14=Radiobutton(self.frame1, 
                              variable=transf,
                              text='ja',
                              value='ja',
                              command=self.setze_transf,
                              anchor=W,
                              justify=LEFT)
        ## Rahmen 2: Ausgabe
        self.anweisungstext='Wähle zunächst oben eine Fettsäure aus und\ndrücke anschließend zum Starten des Jmol-Applets\nauf das hier erscheinende Kugelmodell!'
        # Trivialname+Chemischer Name und Hilfeseite sowie Strukturformelabbildung
        self.f2l1=Label(self.frame2, text='Name:', anchor=NE)
        self.f2text1=Text(self.frame2, width='80', height=1, bg='white', wrap=WORD)
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f2b1=Button(self.frame2,
                         width=700, 
                         height=350, 
                         bg='white',
                         command=self.info_seite_aufrufen,
                         image=self.bild1,
                         compound=LEFT,
                         text=self.anweisungstext,
                         state=DISABLED,
                         anchor=CENTER)
        self.f2b1.bild1=self.bild1
        # Summenformel, Schmelzpunkt und Vorkommen
        self.f2l2=Label(self.frame2, text='Summenformel:', anchor=NE)
        self.f2text2=Text(self.frame2, width='60', height=1, bg='white', wrap=WORD)
        self.f2l3=Label(self.frame2, text='Schmelzpunkt:', anchor=NE)
        self.f2text3=Text(self.frame2, width='40', height='1', bg='white', wrap=WORD)
        self.f2l4=Label(self.frame2, text='Vorkommen:', anchor=NE)
        self.f2text4=Text(self.frame2, width='80', height='1', bg='white', wrap=WORD)

        ## Rahmen 3: Steuerung
        icon_reset = PhotoImage(file='daten/img/view-refresh.gif')
        self.f3b1=Button(self.frame3, 
                         text='Zurücksetzen', 
                         command=self.zurueck_setzen,
                         image=icon_reset,
                         compound=LEFT)
        self.f3b1.icon_reset=icon_reset
        icon_exit = PhotoImage(file='daten/img/dialog-close.gif')
        self.f3b2=Button(self.frame3, 
                         text='Beenden', 
                         command=root.destroy,
                         image=icon_exit,
                         compound=LEFT)
        self.f3b2.icon_exit=icon_exit
        
        ## Fensterelmente setzen und anzeigen
        for i, row, column, columnspan, sticky in (
                # Rahmen 1
                (self.f1l1, 0, 0, 1, E+W), (self.f1l2, 0, 1, 1, E+W), (self.f1l3, 0, 2, 1, E+W),  (self.f1l4, 0, 3, 1, E+W),
                (self.f1r1, 1, 0, 1, E+W), (self.f1r6, 1, 1, 1, E+W), (self.f1r11, 1, 2, 1, E+W), (self.f1r13, 1, 3, 1, E+W),
                (self.f1r2, 2, 0, 1, E+W), (self.f1r7, 2, 1, 1, E+W), (self.f1r12, 2, 2, 1, E+W), (self.f1r14, 2, 3, 1, E+W),
                (self.f1r3, 3, 0, 1, E+W), (self.f1r8, 3, 1, 1, E+W), (self.f1r15, 3, 2, 1, E+W),
                (self.f1r4, 4, 0, 1, E+W), (self.f1r9, 4, 1, 1, E+W), 
                (self.f1r5, 5, 0, 1, E+W), (self.f1r10, 5, 1, 1, E+W), 
                # Rahmen 2
                (self.f2b1,      0, 0, 6, W+E+N+S), 
                (self.f2l1,      1, 0, 1, E),   (self.f2text1,  1, 1, 5, E+W), 
                (self.f2l2,      2, 0, 1, E),   (self.f2text2,  2, 1, 5, W), 
                (self.f2l3,      3, 0, 1, E),   (self.f2text3,  3, 1, 5, W),
                (self.f2l4,      4, 0, 1, E),   (self.f2text4,  4, 1, 6, W),
                # Rahmen 3
                (self.f3b1, 0, 0, 1, E+W),  (self.f3b2, 0, 1, 1, E+W)
                ):
            i.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)
        self.beim_start_deaktivierte_r=(self.f1r6, self.f1r7, self.f1r8, self.f1r9, self.f1r10, self.f1r11,
                                        self.f1r12, self.f1r13, self.f1r14, self.f1r15)
        for i in self.beim_start_deaktivierte_r:
            i.config(state=DISABLED)
        self.textfelder=(self.f2text1, self.f2text2, self.f2text3, self.f2text4)
        for i in self.textfelder:
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)

        ##########  Funktionen  ################################################

    def zurueck_setzen(self):
        print('zurueck_setzen')
        for i, wert in ((c_anzahl, 'X'), (db_anzahl, 'X'), (db_stellung, 'X'), (transf, 'X')):
            i.set(wert)
        for i in self.beim_start_deaktivierte_r:
            i.config(state=DISABLED)
        for i in self.textfelder:
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        self.f2b1.config(state=DISABLED)
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f2b1.config(image=self.bild1, text=self.anweisungstext)

    def info_seite_aufrufen(self):
        self.c_anzahl=str(c_anzahl.get())
        self.db_anzahl=str(db_anzahl.get())
        self.db_stellung=str(db_stellung.get())
        self.transf=str(transf.get())
        self.schluessel=self.c_anzahl+'_'+self.db_anzahl+'_'+self.db_stellung+'_'+self.transf
        self.name=str(self.fettsaeuren[self.schluessel][5])
        #print('info_seite_aufrufen', self.name)
        self.info_oeffnen(self.name)

    def info_oeffnen(self, seitenname):
        self.seitenname=seitenname
        self.seiten_url='http://chemie-lernprogramme.de/daten/help/fettsaeurer/html/'+self.seitenname+'.html'
        webbrowser.open(self.seiten_url)

    def setze_c_anzahl(self):
        self.c_anzahl=str(c_anzahl.get())
        #print('setze_c_anzahl', self.c_anzahl)
        for i, wert in ((db_anzahl, 'X'), (db_stellung, 'X'), (transf, 'X')):
            i.set(wert)
        for i in self.textfelder:
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        self.f2b1.config(state=DISABLED)
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f2b1.config(image=self.bild1, text=self.anweisungstext)
        for i in self.beim_start_deaktivierte_r:
            i.config(state=DISABLED)
        if self.c_anzahl == '4':
            self.f1r6.config(state=NORMAL)
        elif self.c_anzahl == '14':
            self.f1r6.config(state=NORMAL)
            self.f1r7.config(state=NORMAL)
        elif self.c_anzahl == '16':
            self.f1r6.config(state=NORMAL)
            self.f1r7.config(state=NORMAL)
        elif self.c_anzahl == '18':
            self.f1r6.config(state=NORMAL)
            self.f1r7.config(state=NORMAL)
            self.f1r8.config(state=NORMAL)
            self.f1r9.config(state=NORMAL)
        elif self.c_anzahl == '20':
            self.f1r6.config(state=NORMAL)
            self.f1r7.config(state=NORMAL)

    def setze_db_anzahl(self):
        self.c_anzahl=str(c_anzahl.get())
        self.db_anzahl=str(db_anzahl.get())
        #print('setze_db_anzahl', self.db_anzahl)
        db_stellung.set('X')
        for i in self.textfelder:
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        self.f2b1.config(state=DISABLED)
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f2b1.config(image=self.bild1, text=self.anweisungstext)
        for i in (self.f1r11, self.f1r12, self.f1r15):
            i.config(state=DISABLED)
        if self.c_anzahl == '4' and self.db_anzahl == '0':
            db_stellung.set('kdb')
            transf.set('kdb')
            self.hole_daten()
        elif self.c_anzahl == '14' and self.db_anzahl == '0':
            db_stellung.set('kdb')
            transf.set('kdb')
            self.hole_daten()
        elif self.c_anzahl == '14' and self.db_anzahl == '1':
            self.f1r12.config(state=NORMAL)
        elif self.c_anzahl == '16' and self.db_anzahl == '0':
            db_stellung.set('kdb')
            transf.set('kdb')
            self.hole_daten()
        elif self.c_anzahl == '16' and self.db_anzahl == '1':
            self.f1r12.config(state=NORMAL)
        elif self.c_anzahl == '18' and self.db_anzahl == '0':
            db_stellung.set('kdb')
            transf.set('kdb')
            self.hole_daten()
        elif self.c_anzahl == '18' and self.db_anzahl == '1':
            self.f1r11.config(state=NORMAL)
            self.f1r12.config(state=NORMAL)
        elif self.c_anzahl == '18' and self.db_anzahl == '2':
            self.f1r12.config(state=NORMAL)
        elif self.c_anzahl == '18' and self.db_anzahl == '3':
            self.f1r11.config(state=NORMAL)
            self.f1r12.config(state=NORMAL)
        elif self.c_anzahl == '20' and self.db_anzahl == '0':
            db_stellung.set('kdb')
            transf.set('kdb')
            self.hole_daten()
        elif self.c_anzahl == '20' and self.db_anzahl == '1':
            self.f1r12.config(state=NORMAL)
            self.f1r15.config(state=NORMAL)

    def setze_db_stellung(self):
        transf.set('X')
        for i in (self.f1r13, self.f1r14):
            i.config(state=DISABLED)
        self.c_anzahl=str(c_anzahl.get())
        self.db_anzahl=str(db_anzahl.get())
        self.db_stellung=str(db_stellung.get())
        for i in self.textfelder:
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        self.f2b1.config(state=DISABLED)
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f2b1.config(image=self.bild1, text=self.anweisungstext)
        #print('setze_db_stellung', self.db_stellung)
        if self.c_anzahl == '14' and self.db_anzahl == '1' and self.db_stellung == '9':
            transf.set('nein')
            self.hole_daten()
        elif self.c_anzahl == '16' and self.db_anzahl == '1' and self.db_stellung == '9':
            transf.set('nein')
            self.hole_daten()
        elif self.c_anzahl == '18' and self.db_anzahl == '1' and self.db_stellung == '6':
            transf.set('nein')
            self.hole_daten()
        elif self.c_anzahl == '18' and self.db_anzahl == '1' and self.db_stellung == '9':
            self.f1r13.config(state=NORMAL)
            self.f1r14.config(state=NORMAL)
        elif self.c_anzahl == '18' and self.db_anzahl == '2' and self.db_stellung == '9':
            transf.set('nein')
            self.hole_daten()
        elif self.c_anzahl == '18' and self.db_anzahl == '3' and self.db_stellung == '6':
            transf.set('nein')
            self.hole_daten()
        elif self.c_anzahl == '18' and self.db_anzahl == '3' and self.db_stellung == '9':
            self.f1r13.config(state=NORMAL)
            self.f1r14.config(state=NORMAL)
        elif self.c_anzahl == '20' and self.db_anzahl == '1' and self.db_stellung == '9':
            transf.set('nein')
            self.hole_daten()
        elif self.c_anzahl == '20' and self.db_anzahl == '1' and self.db_stellung == '11':
            transf.set('nein')
            self.hole_daten()

    def setze_transf(self):
        self.c_anzahl=str(c_anzahl.get())
        self.db_anzahl=str(db_anzahl.get())
        self.db_stellung=str(db_stellung.get())
        self.transf=str(transf.get())
        #print('setze_transf', self.transf)
        for i in self.textfelder:
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        self.f2b1.config(state=DISABLED)
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f2b1.config(image=self.bild1, text=self.anweisungstext)
        if self.c_anzahl == '18' and self.db_anzahl == '1' and self.db_stellung == '9' and self.transf == 'nein':
            self.hole_daten()
        elif self.c_anzahl == '18' and self.db_anzahl == '1' and self.db_stellung == '9' and self.transf == 'ja':
            self.hole_daten()
        if self.c_anzahl == '18' and self.db_anzahl == '3' and self.db_stellung == '9' and self.transf == 'nein':
            self.hole_daten()
        elif self.c_anzahl == '18' and self.db_anzahl == '3' and self.db_stellung == '9' and self.transf == 'ja':
            self.hole_daten()

    def hole_daten(self):
        self.c_anzahl=str(c_anzahl.get())
        self.db_anzahl=str(db_anzahl.get())
        self.db_stellung=str(db_stellung.get())
        self.transf=str(transf.get())
        self.schluessel=self.c_anzahl+'_'+self.db_anzahl+'_'+self.db_stellung+'_'+self.transf
        #print('hole_daten', self.schluessel)
        self.trivialname=self.fettsaeuren[self.schluessel][0]
        self.chemischername=self.fettsaeuren[self.schluessel][1]
        self.summenformel=self.fettsaeuren[self.schluessel][2]
        self.schmelzpunkt=self.fettsaeuren[self.schluessel][3]
        self.vorkommen=self.fettsaeuren[self.schluessel][4]
        #print(self.trivialname+'\n'+self.chemischername+'\n'+self.summenformel+'\n'+self.schmelzpunkt+'\n'+self.vorkommen)
        for i, text in ((self.f2text1, self.trivialname+', '+self.chemischername),
                        (self.f2text2, self.summenformel),
                        (self.f2text3, self.schmelzpunkt),
                        (self.f2text4, self.vorkommen)):
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.insert(0.0, text)
            i.config(state=DISABLED)
        self.f2b1.config(state=NORMAL)
        self.name=str(self.fettsaeuren[self.schluessel][5])
        self.bild1=PhotoImage(file='daten/img/'+self.name+'.gif')
        self.f2b1.config(image=self.bild1, text='')

################################################################################
root = Tk()
root.title('Fettsäurer')
root.option_add('*Text.Font', textfeld_schrift)
app = Fenster(root)
root.mainloop()
