#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, bd=2, padx=8)
        self.frame2=Frame(frame, bd=8, padx=8)
        self.frame3=Frame(frame)
        self.frame4=Frame(frame)
        for f, row, column, columnspan in ((frame,       0, 0, 1),
                                           (self.frame1, 1, 0, 1),
                                           (self.frame2, 2, 0, 1),
                                           (self.frame3, 3, 0, 1),
                                           (self.frame4, 4, 0, 1)):
            f.grid(row=row, column=column, columnspan=columnspan)
        self.farbstoffe={
            'benzol_X_nitro_X':
                ['nitrobenzol', 'Nitrobenzol', 'Gelb', 400],
            'benzol_amino_nitro_X':
                ['nitroanilin', 'Nitroanilin', 'Orange', 435],
            'azobenzol_hydroxy_nitro_X':
                ['hydroxynitroazobenzol', '4-Hydroxy-4\'-nitro-azobenzol', 'Gelb', 400],
            'azobenzol_amino_X_X':
                ['anilingelb', '4-Amino-azobenzol (Anilingelb)', 'Gelb', 400],
            'azobenzol_amino_nitro_X':
                ['aminonitroazobenzol', '4-Amino-4\'-nitro-azobenol', 'Orange', 435],
            'azobenzol_aminoalkyl_X_sulfon':
                ['methylorange', '4-(Dimethylamino)-azobenzol-4\'-sulfonat (Methylorange)', 'Orange', 435],
            'azobenzol_aminoalkyl_nitro_X':
                ['aminoalkylnitroazobenzol', '4-(Dimethylamino)-4\'-nitro-azobenzol', 'Rot', 490],
            'triphenylmethan_amino_X_X':
                ['kristallviolett', 'Kristallviolett', 'Violett', 580],
            'triphenylmethan_hydroxy_X_X':
                ['phenolphthalein', 'Phenolphthalein', 'Farblos', 380],
            'anthrachinon_hydroxy_X_X':
                ['alizarin', 'Alizarin', 'Orange', 435]
        }
        # Frame 1: Bausteine eines Farbstoffmoleküls
        global chromophor
        chromophor = StringVar()
        chromophor.set('X')
        self.a1l1=Label(self.frame1, 
                        font=('bold'),
                        fg='darkorange',
                        text='Chromophor')
        self.a1r1=Radiobutton(self.frame1, 
                              text='Benzol',
                              variable=chromophor, 
                              value='benzol',
                              indicatoron=0, 
                              bg='darkorange',
                              fg='white',
                              activebackground='white',
                              activeforeground='darkorange',
                              selectcolor='black',
                              command=self.chromophor_bestimmen)
        self.a1r2=Radiobutton(self.frame1, 
                              text='Azobenzol',
                              variable=chromophor, 
                              value='azobenzol',
                              indicatoron=0, 
                              bg='darkorange',
                              fg='white',
                              activebackground='white',
                              activeforeground='darkorange',
                              selectcolor='black',
                              command=self.chromophor_bestimmen)
        self.a1r3=Radiobutton(self.frame1, 
                              text='Triphenylmethan/Phthalein',
                              variable=chromophor, 
                              value='triphenylmethan',
                              indicatoron=0, 
                              bg='darkorange',
                              fg='white',
                              activebackground='white',
                              activeforeground='darkorange',
                              selectcolor='black',
                              command=self.chromophor_bestimmen)
        self.a1r4=Radiobutton(self.frame1, 
                              text='Anthrachinon',
                              variable=chromophor, 
                              value='anthrachinon',
                              indicatoron=0, 
                              bg='darkorange',
                              fg='white',
                              activebackground='white',
                              activeforeground='darkorange',
                              selectcolor='black',
                              command=self.chromophor_bestimmen)
        global auxochrom
        auxochrom = StringVar()
        auxochrom.set('X')
        self.a2l1=Label(self.frame1, 
                        font=('bold'),
                        fg='blue',
                        text='Auxochrom')
        self.a2r1=Radiobutton(self.frame1, 
                              text='Hydroxy',
                              variable=auxochrom, 
                              value='hydroxy',
                              indicatoron=0, 
                              bg='blue',
                              fg='white',
                              activebackground='white',
                              activeforeground='blue',
                              selectcolor='black',
                              command=self.auxochrom_bestimmen)
        self.a2r2=Radiobutton(self.frame1, 
                              text='Amino',
                              variable=auxochrom, 
                              value='amino',
                              indicatoron=0, 
                              bg='blue',
                              fg='white',
                              activebackground='white',
                              activeforeground='blue',
                              selectcolor='black',
                              command=self.auxochrom_bestimmen)
        self.a2r3=Radiobutton(self.frame1, 
                              text='Aminoalkyl',
                              variable=auxochrom, 
                              value='aminoalkyl',
                              indicatoron=0, 
                              bg='blue',
                              fg='white',
                              activebackground='white',
                              activeforeground='blue',
                              selectcolor='black',
                              command=self.auxochrom_bestimmen)
        global antiauxochrom
        antiauxochrom = StringVar()
        antiauxochrom.set('X')
        self.a3l1=Label(self.frame1, 
                        font=('bold'),
                        fg='red',
                        text='Antiauxochrom')
        self.a3r1=Radiobutton(self.frame1, 
                              text='Nitro',
                              variable=antiauxochrom, 
                              value='nitro',
                              indicatoron=0, 
                              bg='red',
                              fg='white',
                              activebackground='white',
                              activeforeground='red',
                              selectcolor='black',
                              command=self.antiauxochrom_bestimmen)
        global loesliche_gruppe
        loesliche_gruppe = StringVar()
        loesliche_gruppe.set('X')
        self.a4l1=Label(self.frame1, 
                        font=('bold'),
                        fg='dimgrey',
                        text='Lösliche Gruppe')
        self.a4r1=Radiobutton(self.frame1, 
                              text='Sulfonsäure/Sulfonat',
                              variable=loesliche_gruppe, 
                              value='sulfon',
                              indicatoron=0, 
                              bg='dimgrey',
                              fg='white',
                              activebackground='white',
                              activeforeground='dimgrey',
                              selectcolor='black',
                              command=self.loesliche_gruppe_bestimmen)
        self.button1=Button(self.frame1, 
                            text='Strukturformel anzeigen', 
                            command=self.farbstoff_anzeigen)
        self.button1.config(state=DISABLED)
        self.button2=Button(self.frame1, 
                            text='Zurücksetzen', 
                            command=self.zurueck_setzen)
        for i, row, column, columnspan, sticky in (
                (self.a1l1,     0, 0, 1, E+W),
                (self.a1r1,     1, 0, 1, E+W),
                (self.a1r2,     2, 0, 1, E+W),
                (self.a1r3,     3, 0, 1, E+W),
                (self.a1r4,     4, 0, 1, E+W),
                (self.a2l1,     0, 1, 1, E+W),
                (self.a2r1,     1, 1, 1, E+W),
                (self.a2r2,     2, 1, 1, E+W),
                (self.a2r3,     3, 1, 1, E+W),
                (self.a3l1,     0, 2, 1, E+W),
                (self.a3r1,     1, 2, 1, E+W),
                (self.a4l1,     0, 3, 1, E+W),
                (self.a4r1,     1, 3, 1, E+W),
                (self.button1,  5, 0, 2, E+W),
                (self.button2,  5, 2, 2, E+W)):
            i.grid(row=row, column=column, 
                   columnspan=columnspan, sticky=sticky)
        for i in (self.a2r1, self.a2r2, self.a2r3, self.a3r1, self.a4r1):
            i.config(state=DISABLED)

        # Rahmen 2: Strukturformel und Name
        self.canvas1=Canvas(self.frame2, 
                            width=600, 
                            height=400, 
                            bg='white')
        
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)
        self.label1=Label(self.frame2, 
                          text='Name des Farbstoffs:')
        self.label2=Label(self.frame2,
                          text='Farbe:')
        self.entry1=Entry(self.frame2, 
                          width=55, 
                          disabledbackground='white',
                          disabledforeground='black',
                          state=DISABLED)
        self.entry2=Entry(self.frame2, 
                          width=10, 
                          disabledbackground='white',
                          disabledforeground='black',
                          state=DISABLED)
        self.canvas1.grid(row=0, column=0, columnspan=2)
        self.label1.grid(row=1, column=0, columnspan=1, sticky=E)
        self.entry1.grid(row=1, column=1, columnspan=1, sticky=W)
        self.label2.grid(row=2, column=0, columnspan=1, sticky=E)
        self.entry2.grid(row=2, column=1, columnspan=1, sticky=W)
        
        # Rahmen 3: Spektrum und Farbe
        self.canvas2=Canvas(self.frame3, 
                            width=500, 
                            height=100, 
                            bg='white')
        
        self.bild2=PhotoImage(file='daten/img/spektrum.gif')
        self.canvas2.create_image(0, 0, image=self.bild2, anchor = NW)
        self.label3=Label(self.frame3, text='Absorbiert:')
        self.label4=Label(self.frame3, text='Reflektiert:')
        self.scale1=Scale(self.frame3, 
                          length=500,
                          from_=380, 
                          to=750,
                          resolution=1,
                          showvalue=1,
                          orient=HORIZONTAL)
        self.label5=Label(self.frame3, text='Wellenlänge \n(absorbiert) in nm:')
        self.canvas2.grid(row=0, column=1, columnspan=2, rowspan=2)
        self.label3.grid(row=0, column=0, columnspan=1, rowspan=1)
        self.label4.grid(row=1, column=0, columnspan=1, rowspan=1)
        self.scale1.grid(row=2, column=1, columnspan=1, rowspan=1)
        self.label5.grid(row=2, column=0, columnspan=1, rowspan=1)
        
        # Rahmen 4: Beenden-Knopf
        self.button3=Button(self.frame4, 
                            text='Beenden',
                            command=root.destroy)
        self.button3.grid(row=0, column=0, sticky=E+W)
        ########################################################################

    def zurueck_setzen(self):
        self.entry1.config(state=NORMAL)
        self.entry1.delete(0, END)
        self.entry1.config(state=DISABLED)
        self.entry2.config(state=NORMAL)
        self.entry2.delete(0, END)
        self.entry2.config(state=DISABLED)
        for i in (chromophor, auxochrom, antiauxochrom, loesliche_gruppe):
            i.set('X')
        for i in (self.a2r1, self.a2r2, self.a2r3, 
                  self.a3r1, self.a4r1, self.button1):
            i.config(state=DISABLED)
        for i in (self.a1r1, self.a1r2, self.a1r3, self.a1r4):
            i.config(state=NORMAL)
        self.zeige_bild('start')
        self.scale1.set(380)

    def chromophor_bestimmen(self):
        self.chromophor=str(chromophor.get())
        if self.chromophor == 'benzol':
            self.a1r2.config(state=DISABLED)
            self.a1r3.config(state=DISABLED)
            self.a1r4.config(state=DISABLED)
            self.a3r1.config(state=NORMAL)
            self.a1r1.config(state=DISABLED)
        elif self.chromophor == 'azobenzol':
            self.a1r1.config(state=DISABLED)
            self.a1r3.config(state=DISABLED)
            self.a1r4.config(state=DISABLED)
            self.a2r1.config(state=NORMAL)
            self.a2r2.config(state=NORMAL)
            self.a2r3.config(state=NORMAL)
            #self.a3r1.config(state=NORMAL)
            self.a1r2.config(state=DISABLED)
        elif self.chromophor == 'triphenylmethan':
            self.a1r1.config(state=DISABLED)
            self.a1r2.config(state=DISABLED)
            self.a1r4.config(state=DISABLED)
            self.a2r1.config(state=NORMAL)
            self.a2r2.config(state=NORMAL)
            self.a1r3.config(state=DISABLED)
        elif self.chromophor == 'anthrachinon':
            self.a1r1.config(state=DISABLED)
            self.a1r2.config(state=DISABLED)
            self.a1r3.config(state=DISABLED)
            self.a2r1.config(state=NORMAL)
            self.a1r4.config(state=DISABLED)
            auxochrom.set('hydroxy')
            self.a2r1.config(state=DISABLED)
            self.button1.config(state=NORMAL)
            
    def auxochrom_bestimmen(self):
        self.chromophor=str(chromophor.get())
        self.auxochrom=str(auxochrom.get())
        self.antiauxochrom=str(antiauxochrom.get())
        if self.chromophor == 'benzol' and self.antiauxochrom == 'nitro':
            self.a2r2.config(state=DISABLED)
        elif self.chromophor == 'azobenzol' and self.auxochrom == 'hydroxy':
            self.a2r2.config(state=DISABLED)
            self.a2r3.config(state=DISABLED)
            self.a3r1.config(state=NORMAL)
            antiauxochrom.set('nitro')
            self.a3r1.config(state=DISABLED)
            self.button1.config(state=NORMAL)
            self.a2r1.config(state=DISABLED)
        elif self.chromophor == 'azobenzol' and self.auxochrom == 'amino':
            self.a2r1.config(state=DISABLED)
            self.a2r3.config(state=DISABLED)
            self.button1.config(state=NORMAL)
            self.a2r2.config(state=DISABLED)
            self.a3r1.config(state=NORMAL)
        elif self.chromophor == 'azobenzol' and self.auxochrom == 'aminoalkyl':
            self.a2r1.config(state=DISABLED)
            self.a2r2.config(state=DISABLED)
            self.a4r1.config(state=NORMAL)
            self.a2r3.config(state=DISABLED)
            self.a3r1.config(state=NORMAL)
        elif self.chromophor == 'triphenylmethan' and self.auxochrom == 'hydroxy':
            self.a2r3.config(state=DISABLED)
            self.button1.config(state=NORMAL)
            self.a2r1.config(state=DISABLED)
        elif self.chromophor == 'triphenylmethan' and self.auxochrom == 'amino':
            self.a2r1.config(state=DISABLED)
            self.button1.config(state=NORMAL)
            self.a2r2.config(state=DISABLED)
        
    def antiauxochrom_bestimmen(self):
        self.chromophor=str(chromophor.get())
        self.auxochrom=str(auxochrom.get())
        self.antiauxochrom=str(antiauxochrom.get())
        if self.chromophor == 'benzol':
            self.a2r2.config(state=NORMAL)
            self.a3r1.config(state=DISABLED)
            self.button1.config(state=NORMAL)
        elif self.chromophor == 'azobenzol' and self.auxochrom == 'amino':
            self.a3r1.config(state=DISABLED)
            self.a4r1.config(state=DISABLED)
        elif self.chromophor == 'azobenzol' and self.auxochrom == 'aminoalkyl':
            self.button1.config(state=NORMAL)
            self.a4r1.config(state=DISABLED)

    def loesliche_gruppe_bestimmen(self):
        self.chromophor=str(chromophor.get())
        self.auxochrom=str(auxochrom.get())
        self.antiauxochrom=str(antiauxochrom.get())
        self.loesliche_gruppe=str(loesliche_gruppe.get())
        if self.chromophor == 'azobenzol' and self.auxochrom == 'amino':
            self.a3r1.config(state=DISABLED)
            self.a4r1.config(state=DISABLED)
        elif self.chromophor == 'azobenzol' and self.auxochrom == 'aminoalkyl':
            self.button1.config(state=NORMAL)
            self.a3r1.config(state=DISABLED)
            self.a4r1.config(state=DISABLED)
        
        
    def farbstoff_anzeigen(self):
        print('farbstoff_anzeigen')
        self.chromophor=str(chromophor.get())
        self.auxochrom=str(auxochrom.get())
        self.antiauxochrom=str(antiauxochrom.get())
        self.loesliche_gruppe=str(loesliche_gruppe.get())
        self.schluessel=self.chromophor+'_'+self.auxochrom+'_'+self.antiauxochrom+'_'+self.loesliche_gruppe
        print(self.farbstoffe[self.schluessel][0])
        self.zeige_bild(self.farbstoffe[self.schluessel][0])
        self.farbstoffname=str(self.farbstoffe[self.schluessel][1])
        self.entry1.config(state=NORMAL)
        self.entry1.delete(0, END)
        self.entry1.insert(0, self.farbstoffname)
        self.entry1.config(state=DISABLED)
        self.farbe=str(self.farbstoffe[self.schluessel][2])
        self.entry2.config(state=NORMAL)
        self.entry2.delete(0, END)
        self.entry2.insert(0, self.farbe)
        self.entry2.config(state=DISABLED)
        self.wellenlaenge=int(self.farbstoffe[self.schluessel][3])
        self.scale1.set(self.wellenlaenge)
        #self.button1.config(state=DISABLED)

    def zeige_bild(self, bildpfad):
        try:
            self.bild1.destroy()
        except:
            pass
        self.bild1=PhotoImage(file='daten/img/'+bildpfad+'.gif')
        self.canvas1.create_image(0, 0, image=self.bild1, anchor = NW)

################################################################################
root = Tk()
root.title('Farbstoffermittler')
app = Fenster(root)
root.mainloop()
