#!/usr/bin/env python3
# -*- coding: utf-8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
from tkinter import messagebox
import string
import webbrowser

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame)
        self.frame2=Frame(frame, pady=4, padx=4)
        self.frame3=Frame(frame, pady=4, padx=4)
        self.frame4=Frame(frame, pady=4, padx=4)
        self.frame5=Frame(frame, pady=4, padx=4)
        self.frame6=Frame(frame, pady=4, padx=4)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 1, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 2, 0, 1, E+W),
                (self.frame4, 3, 0, 1, E+W),
                (self.frame5, 4, 0, 1, E+W),
                (self.frame6, 5, 0, 1, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)
        
        self.einzel_energiewandler={
        # Lichtenergie
        '1A':('Nichtlineare Optik',),                   # 0
        '1B':('Solarzelle', 0.25),
        '1C':('Fotosynthese', 0.2),
        '1D':('Kernphotoeffekt',),                      # 3
        '1E':('Radiometer',),                           # 4
        '1F':('Solarkollektor', 0.7),
        # Elektrische Energie
        '2A':('Blitz',),                                # 0
        '2B':('Transformator',),                        # 1
        '2C':('Akkumulator', 0.8), 
        '2D':('nicht bekannt',),                        # 3
        '2E':('Elektromotor', 0.9),
        '2F':('Elektroheizung',),                       # 5
        # Chemische Energie
        '3A':('Glühwürmchen, Chemolumiszenz',),         # 0
        '3B':('Brennstoffzelle', 0.4),
        '3C':('Kohlevergasung',),                       # 2
        '3D':('nicht bekannt',),                        # 3
        '3E':('Muskel', 0.35),  # Verbrennungsmotor 0.3
        '3F':('Ölheizung', 0.8),
        # Kernenergie
        '4A':('Gammastrahlen',),                        # 0
        '4B':('Radionuklidbatterie',),                  # 1
        '4C':('Radiolyse',),                            # 2
        '4D':('Brutreaktor',),                          # 3
        '4E':('Atombombe',),                            # 4
        '4F':('Kernreaktor', 0.4),
        # Mechanische Energie
        '5A':('Synchrotonstrahlung',),                  # 0
        '5B':('Generator', 0.95),
        '5C':('Eischnee',),                             # 2
        '5D':('Reaktionen im Teilchenbeschleueniger',), # 3
        '5E':('Getriebe', 0.95),
        '5F':('Bremsen',),                              # 5
        # Wärmeenergie
        '6A':('Schwarzer Strahler',),                   # 0
        '6B':('Thermoelement',),                        # 1
        '6C':('Hochofen',),                             # 2
        '6D':('Supernova',),                            # 3
        '6E':('Dampfturbine', 0.82), 
        '6F':('Wärmeüberträger',)                       # 5
        }
        self.zugefuehrte_energieformen={
        '1':'Lichtenergie',
        '2':'Elektrische Energie',
        '3':'Chemische Energie',
        '4':'Kernenergie',
        '5':'Mechanische Energie',
        '6':'Wärmeenergie'
        }
        self.nutzbare_energieformen={
        'A':'Lichtenergie',
        'B':'Elektrische Energie',
        'C':'Chemische Energie',
        'D':'Kernenergie',
        'E':'Mechanische Energie',
        'F':'Wärmeenergie'
        }
        self.mehrstufige_energiewandler={
        'auto':('Auto',''),
        'foen':('Fön',''),
        'kohlekraftwerk':('Kohlekraftwerk',''),
        'kernkraftwerk':('Kernkraftwerk',''),
        'solarkraftwerk':('Solarkraftwerk',''),
        'mensch':('Mensch',''),
        'baum':('Baum',''),
        }
        # Rahmen 1: Auswahlmenü Energieformen oder Energiewandler
        # Menüleiste als Rahmen innerhalb von Rahmen 1
        self.menueleiste=Frame(self.frame1, bd=2, relief=FLAT)
        master.config(menu=self.menueleiste)

        # Menüknöpfe
        self.mb_datei=Menubutton(self.menueleiste, text='Datei')
        self.mb_energie_zugefuehrt=Menubutton(self.menueleiste, text='Zugeführte Energieform')
        self.mb_energie_nutzbar=Menubutton(self.menueleiste, text='Nutzbare Energieform', state=DISABLED)
        self.mb_energiewandler=Menubutton(self.menueleiste, text='Mehrstufige Energiewandler')
        self.mb_hilfe=Menubutton(self.menueleiste, text='Hilfe')
        # Drop-Down-Menüs
        # Datei
        self.menue_datei=Menu(self.mb_datei, tearoff=0)
        self.icon_refresh=PhotoImage(file='daten/icons/view-refresh.gif')
        self.menue_datei.insert_command(0, 
                                         label='Zurücksetzen',
                                         image=self.icon_refresh,
                                         compound=LEFT,
                                         command=self.zurueck_setzen)
        self.menue_datei.icon_refresh=self.icon_refresh
        self.icon_beenden=PhotoImage(file='daten/icons/dialog-close.gif')
        self.menue_datei.insert_command(1,
                                        label='Beenden',
                                        image=self.icon_beenden,
                                        compound=LEFT,
                                        command=root.destroy)
        self.menue_datei.icon_beenden=self.icon_beenden
        self.mb_datei.config(menu=self.menue_datei)
        # Zugeführte Energieform
        global a1 
        a1=StringVar()
        a1.set('X')
        self.menue_energie_zugefuehrt=Menu(self.mb_energie_zugefuehrt, tearoff=0)
        self.icon_lichtenergie=PhotoImage(file='daten/icons/lichtenergie.gif')
        self.menue_energie_zugefuehrt.add_radiobutton(label='Lichtenergie',
                                                      variable=a1, 
                                                      value='1',
                                                      image=self.icon_lichtenergie,
                                                      compound=LEFT,
                                                      command=self.auswahl_zeile)
        self.menue_energie_zugefuehrt.icon_lichtenergie=self.icon_lichtenergie
        self.icon_elektrische_energie=PhotoImage(file='daten/icons/elektrische_energie.gif')
        self.menue_energie_zugefuehrt.add_radiobutton(label='Elektrische Energie',
                                                      variable=a1, 
                                                      value='2',
                                                      image=self.icon_elektrische_energie,
                                                      compound=LEFT,
                                                      command=self.auswahl_zeile)
        self.menue_energie_zugefuehrt.icon_elektrische_energie1=self.icon_elektrische_energie
        self.icon_chemische_energie=PhotoImage(file='daten/icons/chemische_energie.gif')
        self.menue_energie_zugefuehrt.add_radiobutton(label='Chemische Energie',
                                                      variable=a1, 
                                                      value='3',
                                                      image=self.icon_chemische_energie,
                                                      compound=LEFT,
                                                      command=self.auswahl_zeile)
        self.menue_energie_zugefuehrt.icon_chemische_energie=self.icon_chemische_energie
        self.icon_kernenergie=PhotoImage(file='daten/icons/kernenergie.gif')
        self.menue_energie_zugefuehrt.add_radiobutton(label='Kernenergie',
                                                      variable=a1, 
                                                      value='4',
                                                      image=self.icon_kernenergie,
                                                      compound=LEFT,
                                                      command=self.auswahl_zeile)
        self.menue_energie_zugefuehrt.icon_kernenergie1=self.icon_kernenergie
        self.icon_mechanische_energie=PhotoImage(file='daten/icons/mechanische_energie.gif')
        self.menue_energie_zugefuehrt.add_radiobutton(label='Mechanische Energie',
                                                      variable=a1, 
                                                      value='5',
                                                      image=self.icon_mechanische_energie,
                                                      compound=LEFT,
                                                      command=self.auswahl_zeile)
        self.menue_energie_zugefuehrt.icon_mechanische_energie=self.icon_mechanische_energie
        self.icon_waermeenergie=PhotoImage(file='daten/icons/waermeenergie.gif')
        self.menue_energie_zugefuehrt.add_radiobutton(label='Wärmeenergie',
                                                      variable=a1, 
                                                      value='6',
                                                      image=self.icon_waermeenergie,
                                                      compound=LEFT,
                                                      command=self.auswahl_zeile)
        self.menue_energie_zugefuehrt.icon_waermeenergie=self.icon_waermeenergie
        self.mb_energie_zugefuehrt.config(menu=self.menue_energie_zugefuehrt)
        # Nutzbare Energieform
        global a2 
        a2=StringVar()
        a2.set('X')
        self.menue_energie_nutzbar=Menu(self.mb_energie_nutzbar, tearoff=0)
        self.menue_energie_nutzbar.add_radiobutton(label='Lichtenergie',
                                                   variable=a2, 
                                                   value='A',
                                                   image=self.icon_lichtenergie,
                                                   compound=LEFT, 
                                                   command=self.auswahl_spalte)
        self.menue_energie_nutzbar.icon_lichtenergie=self.icon_lichtenergie
        self.menue_energie_nutzbar.add_radiobutton(label='Elektrische Energie',
                                                   variable=a2, 
                                                   value='B',
                                                   image=self.icon_elektrische_energie,
                                                   compound=LEFT, 
                                                   command=self.auswahl_spalte)
        self.menue_energie_nutzbar.icon_elektrische_energie=self.icon_elektrische_energie
        self.menue_energie_nutzbar.add_radiobutton(label='Chemische Energie',
                                                   variable=a2, 
                                                   value='C',
                                                   image=self.icon_chemische_energie,
                                                   compound=LEFT, 
                                                  command=self.auswahl_spalte)
        self.menue_energie_nutzbar.icon_chemische_energie=self.icon_chemische_energie
        self.menue_energie_nutzbar.add_radiobutton(label='Kernenergie',
                                                   variable=a2, 
                                                   value='D',
                                                   image=self.icon_kernenergie,
                                                   compound=LEFT, 
                                                   command=self.auswahl_spalte)
        self.menue_energie_nutzbar.icon_kernenergie=self.icon_kernenergie
        self.menue_energie_nutzbar.add_radiobutton(label='Mechanische Energie',
                                                   variable=a2, 
                                                   value='E',
                                                   image=self.icon_mechanische_energie,
                                                   compound=LEFT, 
                                                   command=self.auswahl_spalte)
        self.menue_energie_nutzbar.icon_waermeenergie=self.icon_waermeenergie
        self.menue_energie_nutzbar.add_radiobutton(label='Wärmeenergie',
                                                   variable=a2, 
                                                   value='F',
                                                   image=self.icon_waermeenergie,
                                                   compound=LEFT,
                                                   command=self.auswahl_spalte)
        self.menue_datei.icon_waermeenergie=self.icon_waermeenergie
        self.mb_energie_nutzbar.config(menu=self.menue_energie_nutzbar)
        # Energiewandler
        global a3 
        a3=StringVar()
        a3.set('X')
        self.menue_energiewandler=Menu(self.mb_energiewandler, tearoff=0)
        self.icon_auto=PhotoImage(file='daten/icons/auto.gif')
        self.menue_energiewandler.add_radiobutton(label='Auto',
                                                  variable=a3, 
                                                  value='auto',
                                                  image=self.icon_auto,
                                                  compound=LEFT,
                                                  command=self.auswahl_energiewandler)
        self.menue_energiewandler.icon_auto=self.icon_auto
        self.icon_foen=PhotoImage(file='daten/icons/foen.gif')
        self.menue_energiewandler.add_radiobutton(label='Fön',
                                                  variable=a3, 
                                                  value='foen',
                                                  image=self.icon_foen,
                                                  compound=LEFT, 
                                                  command=self.auswahl_energiewandler)
        self.menue_energiewandler.icon_foen=self.icon_foen
        self.icon_kohlekraftwerk=PhotoImage(file='daten/icons/kohlekraftwerk.gif')
        self.menue_energiewandler.add_radiobutton(label='Kohlekraftwerk',
                                                  variable=a3, 
                                                  value='kohlekraftwerk',
                                                  image=self.icon_kohlekraftwerk,
                                                  compound=LEFT, 
                                                  command=self.auswahl_energiewandler)
        self.menue_energiewandler.icon_kohlekraftwerk=self.icon_kohlekraftwerk
        self.icon_kernkraftwerk=PhotoImage(file='daten/icons/kernkraftwerk.gif')
        self.menue_energiewandler.add_radiobutton(label='Kernkraftwerk',
                                                  variable=a3, 
                                                  value='kernkraftwerk',
                                                  image=self.icon_kernkraftwerk,
                                                  compound=LEFT, 
                                                  command=self.auswahl_energiewandler)
        self.menue_energiewandler.icon_kernkraftwerk=self.icon_kernkraftwerk
        self.icon_solarkraftwerk=PhotoImage(file='daten/icons/solarkraftwerk.gif')
        self.menue_energiewandler.add_radiobutton(label='Solarkraftwerk',
                                                  variable=a3, 
                                                  value='solarkraftwerk',
                                                  image=self.icon_solarkraftwerk,
                                                  compound=LEFT, 
                                                  command=self.auswahl_energiewandler)
        self.menue_energiewandler.icon_solarkraftwerk=self.icon_solarkraftwerk
        self.icon_mensch=PhotoImage(file='daten/icons/mensch.gif')
        self.menue_energiewandler.add_radiobutton(label='Mensch',
                                                  variable=a3, 
                                                  value='mensch',
                                                  image=self.icon_mensch,
                                                  compound=LEFT, 
                                                  command=self.auswahl_energiewandler)
        self.menue_energiewandler.icon_mensch=self.icon_mensch
        self.icon_baum=PhotoImage(file='daten/icons/baum.gif')
        self.menue_energiewandler.add_radiobutton(label='Baum',
                                                  variable=a3, 
                                                  value='baum',
                                                  image=self.icon_baum,
                                                  compound=LEFT, 
                                                  command=self.auswahl_energiewandler)
        self.menue_energiewandler.icon_baum=self.icon_baum
        self.mb_energiewandler.config(menu=self.menue_energiewandler)
        # Hilfe
        self.menue_hilfe=Menu(self.mb_hilfe, tearoff=0)
        self.icon_hilfeseite=PhotoImage(file='daten/icons/help-contents.gif')
        self.menue_hilfe.insert_command(0, 
                                        label='Energiewandler',
                                        image=self.icon_hilfeseite,
                                        compound=LEFT,
                                        command=self.hilfe_energiewandler)
        self.menue_hilfe.icon_hilfe=self.icon_hilfeseite
        self.icon_hilfe=PhotoImage(file='daten/icons/help-about.gif')
        self.menue_hilfe.insert_command(1, 
                                        label='Info',
                                        image=self.icon_hilfe,
                                        compound=LEFT,
                                        command=self.hilfe_ueber)
        self.menue_hilfe.icon_hilfe=self.icon_hilfe
        self.mb_hilfe.config(menu=self.menue_hilfe)
        # Menüelemente anzeigen
        for i, row, column, sticky in (
                (self.menueleiste,                  0, 0, E+W),
                (self.mb_datei,                     0, 0, W),
                (self.mb_energie_zugefuehrt,        0, 1, W),
                (self.mb_energie_nutzbar,           0, 2, W),
                (self.mb_energiewandler,            0, 3, W),
                (self.mb_hilfe,                     0, 4, W),
                ):
            i.grid(row=row, column=column, sticky=sticky)

        # Rahmen 2: Zeichenfläche
        self.f2canvas1=Canvas(self.frame2, width=800, height=620, bg='white')
        self.f2canvas1.grid(row=0, column=0)
        
        # Rahmen 3: Hilfeseiten Linktext
        self.f3l1=Label(self.frame3, text='Weitere Informationen:')
        self.f3text1=Text(self.frame3, 
                          width=40, 
                          height=1, 
                          bg='white', 
                          state=DISABLED)
        self.f3text1.tag_config("a", foreground="blue", underline=1)
        self.f3text1.tag_bind("a", "<Enter>", self.show_hand_cursor)
        self.f3text1.tag_bind("a", "<Leave>", self.show_arrow_cursor)
        self.f3text1.tag_bind("a", "<Button-1>", self.aufruf)
        self.f3text1.config(cursor="arrow")
        self.f3l1.grid(row=0, column=0)
        self.f3text1.grid(row=0, column=1)

    def show_hand_cursor(self, event):
        event.widget.configure(cursor="hand2")

    def show_arrow_cursor(self, event):
        event.widget.configure(cursor="")

    def hilfe_energiewandler(self):
        self.seiten_url='http://de.wikipedia.org/wiki/Energiewandler'
        webbrowser.open(self.seiten_url)

    def aufruf(self, event):
        #print('click')
        self.a1=str(a1.get())
        self.a2=str(a2.get())
        self.a3=str(a3.get())
        if self.a3 == 'X':
            #self.zugefuehrte_energieform=self.zugefuehrte_energieformen[self.a1]
            #self.nutzbare_energieform=self.nutzbare_energieformen[self.a2]
            self.schluessel=str(self.a1+self.a2)
            self.energiewandler=self.einzel_energiewandler[self.schluessel][0]
            self.seiten_url='http://de.wikipedia.org/wiki/'+self.energiewandler
            webbrowser.open(self.seiten_url)
        elif self.a1 == 'X' and self.a2 == 'X':
            self.schluessel=str(self.a3)
            self.energiewandler=self.mehrstufige_energiewandler[self.a3][0]
            self.seiten_url='http://de.wikipedia.org/wiki/'+self.energiewandler
            webbrowser.open(self.seiten_url)

    def hilfe_ueber(self):
        self.nachricht='Wähle entweder die zugeführte Energieform und anschließend die nutzbare Energieform aus, oder aber wähle direkt einen mehrstufigen Energiewandler aus.\nDie Ansicht kann unter "Datei-Zurücksetzen" neu geladen werden.'
        messagebox.showinfo(title='Info zum Energiewandler', message=self.nachricht)

    def zurueck_setzen(self):
        #print('zurueck_setzen')
        a1.set('X')
        a2.set('X')
        a3.set('X')
        for w, state in ((self.mb_energie_zugefuehrt, NORMAL),
                         (self.mb_energie_nutzbar, DISABLED),
                         (self.mb_energiewandler, NORMAL)):
            w.config(state=state)
        for i in range(0, 6):
            self.menue_energie_nutzbar.entryconfig(i, state=NORMAL)
        # bereits vorhandene Elemente löschen
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        # Leinwand updaten
        self.f2canvas1.config(background='white')
        self.f2canvas1.update()
        # Textfeld löschen
        self.f3text1.config(state=NORMAL)
        self.f3text1.delete(1.0, END)
        self.f3text1.config(state=DISABLED)
        
    def auswahl_zeile(self):
        #print('auswahl_zeile')
        self.mb_energie_nutzbar.config(state=NORMAL)
        self.mb_energiewandler.config(state=DISABLED)
        # Je nach Auswahl der Zeilen, bestimmte Spalten deaktivieren
        self.a1=str(a1.get())
        a2.set('X')
        for i in range(0, 7):
            self.menue_energie_nutzbar.entryconfig(i, state=NORMAL)
        if self.a1 == '1':
            for i in (0, 3, 4):
                self.menue_energie_nutzbar.entryconfig(i, state=DISABLED)
        elif self.a1 == '2':
            for i in (0, 1, 3, 5):
                self.menue_energie_nutzbar.entryconfig(i, state=DISABLED)
        elif self.a1 == '3':
            for i in (0, 2, 3):
                self.menue_energie_nutzbar.entryconfig(i, state=DISABLED)
        elif self.a1 == '4':
            for i in (0, 1, 2, 3, 4):
                self.menue_energie_nutzbar.entryconfig(i, state=DISABLED)
        elif self.a1 == '5':
            for i in (0, 2, 3, 5):
                self.menue_energie_nutzbar.entryconfig(i, state=DISABLED)
        elif self.a1 == '6':
            for i in (0, 1, 2, 3, 5):
                self.menue_energie_nutzbar.entryconfig(i, state=DISABLED)

    def auswahl_spalte(self):
        #print('auswahl_spalte')
        self.a1=str(a1.get())
        self.a2=str(a2.get())
        self.zugefuehrte_energieform=self.zugefuehrte_energieformen[self.a1]
        self.nutzbare_energieform=self.nutzbare_energieformen[self.a2]
        self.schluessel=str(self.a1+self.a2)
        self.energiewandler=self.einzel_energiewandler[self.schluessel][0]
        self.wirkungsgrad=self.einzel_energiewandler[self.schluessel][1]
        #print(self.schluessel, self.energiewandler, self.wirkungsgrad)
        # bereits vorhandene Elemente löschen
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        # Energiewandler zeichnen
        self.einzel_energiewandler_bild=Einzel_energiewandler(self.f2canvas1, 
                                                              300, 
                                                              100, 
                                                              self.zugefuehrte_energieform,
                                                              self.nutzbare_energieform,
                                                              self.energiewandler,
                                                              self.wirkungsgrad,
                                                              NORMAL)
        # Leinwand updaten
        self.f2canvas1.config(background='white')
        self.f2canvas1.update()
        # Hilfeseiten-Link
        self.f3text1.config(state=NORMAL)
        self.f3text1.delete(1.0, END)
        self.linktext=self.energiewandler
        self.f3text1.insert(INSERT, self.linktext, "a")

    def auswahl_energiewandler(self):
        #print('auswahl_energiewandler')
        self.mb_energie_zugefuehrt.config(state=DISABLED)
        self.mb_energie_nutzbar.config(state=DISABLED)
        self.a3=str(a3.get())
        #print(self.a3)
        self.linktext=self.mehrstufige_energiewandler[self.a3][0]
        # bereits vorhandene Elemente löschen
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        # Canvas auf Standardhintergrundfarbe setzen
        self.hintergrundfarbe=root.cget('background')
        #print(self.hintergrundfarbe)
        self.f2canvas1.config(bg=str(self.hintergrundfarbe))
        # TO DO: Energiewandler zeichnen
        self.bild1=PhotoImage(file='daten/img/'+self.a3+'.gif')
        self.f2canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        # Leinwand updaten
        #self.f2canvas1.config(background='white')
        self.f2canvas1.update()
        # Hilfeseiten-Link
        self.f3text1.config(state=NORMAL)
        self.f3text1.delete(1.0, END)
        self.f3text1.insert(INSERT, self.linktext, "a")




################################################################################
class Einzel_energiewandler:
    def __init__(self, 
                 canvas, 
                 x1, 
                 y1, 
                 zugefuehrte_energieform,
                 nutzbare_energieform,
                 energiewandler, 
                 wirkungsgrad, 
                 ausgangszustand):
        self.canvas=canvas
        self.x1=x1
        self.y1=y1
        self.zugefuehrte_energieform=zugefuehrte_energieform
        self.nutzbare_energieform=nutzbare_energieform
        self.energiewandler=energiewandler
        self.wirkungsgrad=wirkungsgrad
        self.wirkungsgrad_kurz=str(int(self.wirkungsgrad*100))
        self.wirkungsgrad_text=self.energiewandler+'\n η ≈ '+self.wirkungsgrad_kurz+'%'
        self.ausgangszustand=ausgangszustand
        self.text_zugefuehrte_energieform=self.canvas.create_text(self.x1-225,
                                                                  self.y1-25,
                                                                  text=self.zugefuehrte_energieform,
                                                                  fill='blue',
                                                                  font=('helvetica', 14),
                                                                  anchor=NW,
                                                                  justify=LEFT,
                                                                  state=self.ausgangszustand)
        self.text_nutzbare_energieform=self.canvas.create_text(self.x1+215,
                                                               self.y1-25,
                                                               text=self.nutzbare_energieform,
                                                               fill='red',
                                                               font=('helvetica', 14),
                                                               anchor=NW,
                                                               justify=LEFT,
                                                               state=self.ausgangszustand)
        self.pfeilpos1=FIRST
        self.pfeilpos2=LAST
        self.linienbreite=300
        self.x2_abwaerme=480-(self.linienbreite-self.linienbreite*self.wirkungsgrad)/2
        self.text_abwaerme=self.canvas.create_text(self.x2_abwaerme,
                                                   self.y1+425,
                                                   text='nicht nutzbare\nWärmeenergie',
                                                   fill='red',
                                                   font=('helvetica', 14),
                                                   anchor=NW,
                                                   justify=LEFT,
                                                   state=self.ausgangszustand)
        self.linie_zugefuehrte_energieform=self.canvas.create_line(self.x1-270,
                                                                   self.y1+200,
                                                                   self.x1,
                                                                   self.y1+200,
                                                                   fill='blue',
                                                                   arrow=self.pfeilpos2,
                                                                   arrowshape=str(self.linienbreite/6+5)+' '+str(self.linienbreite/6+7)+' '+str(self.linienbreite/6+2),
                                                                   width=self.linienbreite)
        self.y1_nutzbar=100+20+(self.linienbreite*self.wirkungsgrad)/2
        self.linie_nutzbare_energieform=self.canvas.create_line(self.x1+200,
                                                                self.y1_nutzbar,
                                                                self.x1+480,
                                                                self.y1_nutzbar,
                                                                fill='red',
                                                                arrow=self.pfeilpos2,
                                                                arrowshape=str(self.linienbreite/6+5)+' '+str(self.linienbreite/6+7)+' '+str(self.linienbreite/6+2),
                                                                   width=self.linienbreite*self.wirkungsgrad)
        self.y1_waerme_waagrecht=500-20-(300-self.linienbreite*self.wirkungsgrad)/2
        #self.x2_waerme_waagrecht=self.x1+220+self.linienbreite-self.linienbreite*self.wirkungsgrad
        self.x2_waerme_waagrecht=780-(self.linienbreite-self.linienbreite*self.wirkungsgrad)/2
        self.linie_waerme_waagrecht=self.canvas.create_line(self.x1+200,
                                                            self.y1_waerme_waagrecht,
                                                            self.x2_waerme_waagrecht,
                                                            self.y1_waerme_waagrecht,
                                                            fill='red',
                                                            width=self.linienbreite-self.linienbreite*self.wirkungsgrad)
        self.y1_waerme_senkrecht=500-20-(300-self.linienbreite*self.wirkungsgrad)
        #self.x1_waerme_senkrecht=self.x1+220+self.linienbreite-(self.linienbreite*self.wirkungsgrad)
        self.x1_waerme_senkrecht=780-(self.linienbreite-self.linienbreite*self.wirkungsgrad)/2
        self.linie_waerme_senkrecht=self.canvas.create_line(self.x1_waerme_senkrecht,
                                                            self.y1_waerme_senkrecht,
                                                            self.x1_waerme_senkrecht,
                                                            self.y1+500,
                                                            fill='red',
                                                            arrow=self.pfeilpos2,
                                                            arrowshape=str(self.linienbreite/8+5)+' '+str(self.linienbreite/8+7)+' '+str(self.linienbreite/8+2),
                                                            width=self.linienbreite-self.linienbreite*self.wirkungsgrad)
        self.kasten=self.canvas.create_rectangle(self.x1,
                                                 self.y1,
                                                 self.x1+200,
                                                 self.y1+400,
                                                 fill='lightgrey',
                                                 state=self.ausgangszustand)
        self.text_energiewandler=self.canvas.create_text(self.x1+5,
                                                         self.y1+5,
                                                         text=self.wirkungsgrad_text,
                                                         fill='black',
                                                         font=('helvetica', 14),
                                                         anchor=NW,
                                                         justify=LEFT,
                                                         state=self.ausgangszustand)
        
    def zustand_aendern(self, zustand):
        self.zustand=zustand
        self.canvas.itemconfig(self.kasten, state=self.zustand)
        self.canvas.itemconfig(self.textinhalt, state=self.zustand)


#############################################################################
root = Tk()
root.title('Energiewandler')
root.minsize(640, 520)
app = Fenster(root)
root.mainloop()
