#!/usr/bin/env python3
# -*- coding: utf-8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
from tkinter import messagebox
import string
import webbrowser
import math
import re 

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame)
        self.frame2=Frame(frame, pady=4, padx=4)
        self.frame3=Frame(frame, pady=4, padx=4)
        self.frame4=Frame(frame, pady=4, padx=4)
        self.frame5=Frame(frame, pady=4, padx=4)
        self.frame6=Frame(frame, pady=4, padx=4)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 1, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 2, 0, 1, E+W),
                (self.frame4, 3, 0, 1, E+W),
                (self.frame5, 4, 0, 1, E+W),
                (self.frame6, 5, 0, 1, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)
        ########################################################################
        '''
        'Nummer des Redoxpaars':{'E0':'Zahlenwert',
                                 'redm_haelfte':(
                                                koeff_redm,
                                                sf_redm,
                                                koeff_ladaus,
                                                sf_ladaus,
                                                koeff_stoffaus,
                                                sf_stoffaus),
                                 'oxm_haelfte':(koeff_oxm,
                                                sf_oxm,
                                                koeff_el,
                                                sf_el,
                                                koeff_ladaus,
                                                sf_ladaus,
                                                koeff_stoffaus,
                                                sf_stoffaus),
                                 'beschriftung':('Elektrodenmaterial',
                                                 'Ionen-Lösung',
                                                 'Farbe Elektrode',
                                                 'Farbe Lösung')
        }
        '''
        self.linke_halbzellen={
        '01':{'E0':-3.02,
              'redm_haelfte':('1',
                              'Li',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Li⁺',
                             '1',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
               'beschriftung':('Lithium-Elektrode',
                               'Lithiumionen\nin aprotischer\nElektrolyt-Lösung',
                               'gray',
                               'white')
        },
        '02':{'E0':-2.71,
              'redm_haelfte':('1',
                              'Na',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Na⁺',
                             '1',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Natrium-Elektrode',
                              'Natriumionen\nin aprotischer\nElektrolyt-Lösung',
                              'gray',
                              'white')
        },
        '03':{'E0':-1.66,
              'redm_haelfte':('1',
                              'Al',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Al³⁺',
                             '3',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Alumiunium-Elektrode',
                              'Aluminiumionen\nin aprotischer\nElektrolyt-Lösung',
                              'gray',
                              'white')
        },
        '04':{'E0':-0.83,
              'redm_haelfte':('1',
                              'H₂',
                              '2',
                              'OH⁻',
                              '',
                              ''),
              'oxm_haelfte':('2',
                             'H₂O',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Wasserstoff umspülte\nPlatin-Elektrode',
                              'Oxoniumionen-Lösung',
                              'gray',
                              'white')
        },
        '05':{'E0':-0.76,
              'redm_haelfte':('1',
                              'Zn',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Zn²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Zink-Elektrode',
                              'Zink(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '06':{'E0':-0.41,
              'redm_haelfte':('1',
                              'Fe',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Fe²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Eisen-Elektrode',
                              'Eisen(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '07':{'E0':-0.40,
              'redm_haelfte':('1',
                              'Cd',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Cd²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Cadmium-Elektrode',
                              'Cadmium(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '08':{'E0':-0.36,
              'redm_haelfte':('1',
                              'Pb',
                              '1',
                              'SO₄²⁻',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'PbSO₄',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Blei-Elektrode',
                              'Festes Blei(II)-sulfat',
                              'gray',
                              'white')
        },
        '09':{'E0':-0.23,
              'redm_haelfte':('1',
                              'Ni',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Ni²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Nickel-Elektrode',
                              'Nickel(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '10':{'E0':-0.14,
              'redm_haelfte':('1',
                              'Sn',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Sn²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Zinn-Elektrode',
                              'Zinn(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '11':{'E0':0.00,
              'redm_haelfte':('1',
                              'H₂',
                              '',
                              '',
                              '2',
                              'H₂O'),
              'oxm_haelfte':('2',
                             'H₃O⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Wasserstoff umspülte\nPlatin-Elektrode',
                              'Oxoniumionen-\nLösung',
                              'gray',
                              'white')
        },
        '12':{'E0':0.34,
              'redm_haelfte':('1',
                              'Cu',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Cu²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Kupfer-Elektrode',
                              'Kupfer(II)-ionen-\nLösung',
                              'brown',
                              'steelblue')
        },
        '13':{'E0':0.40,
              'redm_haelfte':('4',
                              'OH⁻',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'O₂',
                             '4',
                             'e⁻',
                             '',
                             '',
                             '2',
                             'H₂O'),
              'beschriftung':('Sauerstoff umspülte\nPlatin-Elektrode',
                              'Hydroxidionen-\nLösung',
                              'gray',
                              'white')
        },
        '14':{'E0':0.54,
              'redm_haelfte':('2',
                              'I⁻',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'I₂',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Iod an\nPlatin-Elektrode',
                              'Iodidionen-Stärke-\nLösung',
                              'gray',
                              'steelblue')
        },
        '15':{'E0':0.80,
              'redm_haelfte':('1',
                              'Ag',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Ag⁺',
                             '1',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Silber-Elektrode',
                              'Silber(I)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '16':{'E0':1.07,
              'redm_haelfte':('2',
                              'Br⁻',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Br₂',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Brom an \nPlatin-Elektrode',
                              'Bromidionen-\nLösung',
                              'gray',
                              'orange')
        },
        '17':{'E0':1.23,
              'redm_haelfte':('6',
                              'H₂O',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'O₂',
                             '4',
                             'e⁻',
                             '4',
                             'H₃O⁺',
                             '',
                             ''),
              'beschriftung':('Sauerstoff umspülte\nPlatin-Elektrode',
                              'Saure Lösung',
                              'gray',
                              'white')
        },
        '18':{'E0':1.36,
              'redm_haelfte':('2',
                              'Cl⁻',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Cl₂',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Chlor an\nPlatin-Elektrode',
                              'Chloridionen-\nLösung',
                              'gray',
                              'darkgreen')
        },
        '19':{'E0':1.49,
              'redm_haelfte':('1',
                              'Mn²⁺',
                              '',
                              '',
                              '12',
                              'H₂O'),
              'oxm_haelfte':('1',
                             'MnO₄⁻',
                             '5',
                             'e⁻',
                             '8',
                             'H₃O⁺',
                             '',
                             ''),
              'beschriftung':('Platin-Elektrode',
                              'Permanganationen und\nMangan(II)-ionen-Lösung',
                              'gray',
                              'purple')
        },
        '20':{'E0':1.69,
              'redm_haelfte':('1',
                              'PbSO₄',
                              '',
                              '',
                              '5',
                              'H₂O'),
              'oxm_haelfte':('1',
                             'PbO₂',
                             '2',
                             'e⁻',
                             '3',
                             'H₃O⁺',
                             '1',
                             'HSO₄⁻'),
              'beschriftung':('Blei-Elektrode',
                              'Festes Blei(II)-sulfat\nund festes \nBlei(IV)-oxid',
                              'gray',
                              'white')
        }
        }

        self.rechte_halbzellen={
        '01':{'E0':-3.02,
              'redm_haelfte':('1',
                              'Li',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Li⁺',
                             '1',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
               'beschriftung':('Lithium-Elektrode',
                               'Lithiumionen\nin aprotischer\nElektrolyt-Lösung',
                               'gray',
                               'white')
        },
        '02':{'E0':-2.71,
              'redm_haelfte':('1',
                              'Na',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Na⁺',
                             '1',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Natrium-Elektrode',
                              'Natriumionen\nin aprotischer\nElektrolyt-Lösung',
                              'gray',
                              'white')
        },
        '03':{'E0':-1.66,
              'redm_haelfte':('1',
                              'Al',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Al³⁺',
                             '3',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Alumiunium-Elektrode',
                              'Aluminiumionen\nin aprotischer\nElektrolyt-Lösung',
                              'gray',
                              'white')
        },
        '04':{'E0':-0.83,
              'redm_haelfte':('1',
                              'H₂',
                              '2',
                              'OH⁻',
                              '',
                              ''),
              'oxm_haelfte':('2',
                             'H₂O',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Wasserstoff umspülte\nPlatin-Elektrode',
                              'Oxoniumionen-\nLösung',
                              'gray',
                              'white')
        },
        '05':{'E0':-0.76,
              'redm_haelfte':('1',
                              'Zn',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Zn²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Zink-Elektrode',
                              'Zink(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '06':{'E0':-0.41,
              'redm_haelfte':('1',
                              'Fe',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Fe²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Eisen-Elektrode',
                              'Eisen(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '07':{'E0':-0.40,
              'redm_haelfte':('1',
                              'Cd',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Cd²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Cadmium-Elektrode',
                              'Cadmium(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '08':{'E0':-0.36,
              'redm_haelfte':('1',
                              'Pb',
                              '1',
                              'SO₄²⁻',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'PbSO₄',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Blei-Elektrode',
                              'Festes Blei(II)-sulfat',
                              'gray',
                              'white')
        },
        '09':{'E0':-0.23,
              'redm_haelfte':('1',
                              'Ni',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Ni²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Nickel-Elektrode',
                              'Nickel(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '10':{'E0':-0.14,
              'redm_haelfte':('1',
                              'Sn',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Sn²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Zinn-Elektrode',
                              'Zinn(II)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '11':{'E0':0.00,
              'redm_haelfte':('1',
                              'H₂',
                              '',
                              '',
                              '2',
                              'H₂O'),
              'oxm_haelfte':('2',
                             'H₃O⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Wasserstoff umspülte\nPlatin-Elektrode',
                              'Oxoniumionen-\nLösung',
                              'gray',
                              'white')
        },
        '12':{'E0':0.34,
              'redm_haelfte':('1',
                              'Cu',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Cu²⁺',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Kupfer-Elektrode',
                              'Kupfer(II)-ionen-\nLösung',
                              'brown',
                              'steelblue')
        },
        '13':{'E0':0.40,
              'redm_haelfte':('4',
                              'OH⁻',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'O₂',
                             '4',
                             'e⁻',
                             '',
                             '',
                             '2',
                             'H₂O'),
              'beschriftung':('Sauerstoff umspülte\nPlatin-Elektrode',
                              'Hydroxidionen-\nLösung',
                              'gray',
                              'white')
        },
        '14':{'E0':0.54,
              'redm_haelfte':('2',
                              'I⁻',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'I₂',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Iod an\nPlatin-Elektrode',
                              'Iodidionen-Stärke-\nLösung',
                              'gray',
                              'steelblue')
        },
        '15':{'E0':0.80,
              'redm_haelfte':('1',
                              'Ag',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Ag⁺',
                             '1',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Silber-Elektrode',
                              'Silber(I)-ionen-\nLösung',
                              'gray',
                              'white')
        },
        '16':{'E0':1.07,
              'redm_haelfte':('2',
                              'Br⁻',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Br₂',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Brom an \nPlatin-Elektrode',
                              'Bromidionen-\nLösung',
                              'gray',
                              'orange')
        },
        '17':{'E0':1.23,
              'redm_haelfte':('6',
                              'H₂O',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'O₂',
                             '4',
                             'e⁻',
                             '4',
                             'H₃O⁺',
                             '',
                             ''),
              'beschriftung':('Sauerstoff umspülte\nPlatin-Elektrode',
                              'Saure Lösung',
                              'gray',
                              'white')
        },
        '18':{'E0':1.36,
              'redm_haelfte':('2',
                              'Cl⁻',
                              '',
                              '',
                              '',
                              ''),
              'oxm_haelfte':('1',
                             'Cl₂',
                             '2',
                             'e⁻',
                             '',
                             '',
                             '',
                             ''),
              'beschriftung':('Chlor an \nPlatin-Elektrode',
                              'Chloridionen-\nLösung',
                              'gray',
                              'darkgreen')
        },
        '19':{'E0':1.49,
              'redm_haelfte':('1',
                              'Mn²⁺',
                              '',
                              '',
                              '12',
                              'H₂O'),
              'oxm_haelfte':('1',
                             'MnO₄⁻',
                             '5',
                             'e⁻',
                             '8',
                             'H₃O⁺',
                             '',
                             ''),
              'beschriftung':('Platin-Elektrode',
                              'Permanganationen und\nMangan(II)-ionen-\nLösung',
                              'gray',
                              'purple')
        },
        '20':{'E0':1.69,
              'redm_haelfte':('1',
                              'PbSO₄',
                              '',
                              '',
                              '5',
                              'H₂O'),
              'oxm_haelfte':('1',
                             'PbO₂',
                             '2',
                             'e⁻',
                             '3',
                             'H₃O⁺',
                             '1',
                             'HSO₄⁻'),
              'beschriftung':('Blei-Elektrode',
                              'Festes Blei(II)-sulfat\nund festes \nBlei(IV)-oxid',
                              'gray',
                              'white')
        }
        }

        ########################################################################
        # Rahmen 1: Auswahlmenü linke und rechte Halbzelle
        # Menüleiste als Rahmen innerhalb von Rahmen 1
        self.menueleiste=Frame(self.frame1, bd=2, relief=FLAT)
        master.config(menu=self.menueleiste)
        # Menüknöpfe
        self.mb_datei=Menubutton(self.menueleiste, text='Datei')
        self.mb_kapitel=Menubutton(self.menueleiste, text='Kapitel')
        self.mb_linke_halbzelle=Menubutton(self.menueleiste, text='Linke Halbzelle')
        self.mb_rechte_halbzelle=Menubutton(self.menueleiste, text='Rechte Halbzelle')
        self.mb_ansicht=Menubutton(self.menueleiste, text='Ansicht')
        #self.mb_hilfe=Menubutton(self.menueleiste, text='Hilfe')
        # Drop-Down-Menüs
        # Datei
        self.menue_datei=Menu(self.mb_datei, tearoff=0)
        self.icon_refresh=PhotoImage(file='daten/icons/view-refresh.gif')
        self.menue_datei.insert_command(0,
                                        label='Zurücksetzen',
                                        image=self.icon_refresh,
                                        compound=LEFT,
                                        command=self.setze_ganz_zurueck)
        self.menue_datei.icon_refresh=self.icon_refresh
        self.icon_beenden=PhotoImage(file='daten/icons/dialog-close.gif')
        self.menue_datei.insert_command(1,
                                        label='Beenden',
                                        image=self.icon_beenden,
                                        compound=LEFT,
                                        command=root.destroy)
        self.menue_datei.icon_beenden=self.icon_beenden
        self.mb_datei.config(menu=self.menue_datei)
        # Kapitel
        self.menue_kapitel=Menu(self.mb_kapitel, tearoff=0)
        # Untermenü 1: Elektronendruckreihe
        self.menue_kapitel.choices1=Menu(self.menue_kapitel, tearoff=0)
        self.menue_kapitel.choices1.add_command(label='Metalle', command=self.elektronendruckreihe_metalle)
        self.menue_kapitel.choices1.add_command(label='Nichtmetallanionen', command=self.elektronendruckreihe_nichtmetalle)
        self.menue_kapitel.add_cascade(label='Elektronendruckreihe', menu=self.menue_kapitel.choices1)
        # Untermenü 2: Konzentrationsabhänigkeit
        self.menue_kapitel.choices2=Menu(self.menue_kapitel, tearoff=0)
        self.menue_kapitel.choices2.add_command(label='Silber-Konzentrationselement [Ag/Ag⁺]; [Ag/Ag⁺]', command=self.silber_konzentrationselement)
        self.menue_kapitel.choices2.add_command(label='Kupfer-Konzentrationselement [Cu/Cu²⁺]; [Cu/Cu²⁺]', command=self.kupfer_konzentrationselement)
        self.menue_kapitel.add_cascade(label='Konzentrationsabhängigkeit', menu=self.menue_kapitel.choices2)
        # Untermenü 3: pH-Abhängigkeit
        self.menue_kapitel.choices3=Menu(self.menue_kapitel, tearoff=0)
        self.menue_kapitel.choices3.add_command(label='Säurekorrosion von Zink [Zn/Zn²⁺]; [H₂/2H₃O⁺]', command=self.saeurekorrosion_zink)
        self.menue_kapitel.choices3.add_command(label='Halbzellenpotential Permanganation/Mangan(II)-ion [H₂/2H₃O⁺]; [MnO₄⁻/Mn²⁺]', command=self.halbzellenpotential_permanganat)
        self.menue_kapitel.add_cascade(label='pH-Abhängigkeit', menu=self.menue_kapitel.choices3)
        # Untermenü 4: Galvanische Primärelemente
        self.menue_kapitel.choices4=Menu(self.menue_kapitel, tearoff=0)
        self.menue_kapitel.choices4.add_command(label='Daniell-Element [Zn/Zn²⁺]; [Cu/Cu²⁺]', command=self.daniell_element)
        self.menue_kapitel.choices4.add_command(label='Zink-Luft-Batterie (alkalisch) [Zn/Zn²⁺]; [2OH⁻/O₂]', command=self.zink_luft_batterie)
        self.menue_kapitel.add_cascade(label='Galvanische Primärelemente', menu=self.menue_kapitel.choices4)
        # Untermenü 5: Galvanische Sekundärelemente
        self.menue_kapitel.choices5=Menu(self.menue_kapitel, tearoff=0)
        self.menue_kapitel.choices5.add_command(label='Zink-Brom-Element [Zn/Zn²⁺]; [2Br⁻/Br₂]', command=self.zink_brom_element)
        self.menue_kapitel.choices5.add_command(label='Cadmium-Nickel-Akku [Cd/Cd²⁺]; [Ni/Ni²⁺]', command=self.cadmium_nickel_akku)
        self.menue_kapitel.choices5.add_command(label='Blei-Akku [Pb/PbSO₄]; [PbSO₄/PbO₂]', command=self.blei_akku)
        self.menue_kapitel.choices5.add_command(label='Brennstoffzelle (alkalisch) [H₂/2OH⁻]; [2OH⁻/O₂]', command=self.brennstoffzelle)
        self.menue_kapitel.add_cascade(label='Galvanische Sekundärelemente', menu=self.menue_kapitel.choices5)
        # Untermenü 6: Korrosion
        self.menue_kapitel.choices6=Menu(self.menue_kapitel, tearoff=0)
        self.menue_kapitel.choices6.add_command(label='Sauerstoffkorrosion von Eisen [Fe/Fe²⁺]; [2OH⁻/O₂]', command=self.sauerstoffkorrosion_eisen)
        self.menue_kapitel.choices6.add_command(label='Verzinken von Eisen [Zn/Zn²⁺]; [Fe/Fe²⁺]', command=self.verzinken)
        self.menue_kapitel.choices6.add_command(label='Verzinnen von Eisen [Fe/Fe²⁺]; [Sn/Sn²⁺]', command=self.verzinnen)
        self.menue_kapitel.add_cascade(label='Korrosion', menu=self.menue_kapitel.choices6)
        # Menü und Untermenüs hinzufügen
        self.mb_kapitel.config(menu=self.menue_kapitel)
        # Linke Halbzelle
        global a1
        a1=StringVar()
        a1.set('X')
        self.menue_linke_halbzelle=Menu(self.mb_linke_halbzelle, tearoff=0)
        self.menue_linke_halbzelle.add_radiobutton(label='Li/Li⁺',
                                                   variable=a1,
                                                   value='01',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Na/Na⁺',
                                                   variable=a1,
                                                   value='02',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Al/Al³⁺',
                                                   variable=a1,
                                                   value='03',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='H₂/2H₂O (alkalisch)',
                                                   variable=a1,
                                                   value='04',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Zn/Zn²⁺',
                                                   variable=a1,
                                                   value='05',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Fe/Fe²⁺',
                                                   variable=a1,
                                                   value='06',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Cd/Cd²⁺',
                                                   variable=a1,
                                                   value='07',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Pb/PbSO₄ (sauer)',
                                                   variable=a1,
                                                   value='08',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Ni/Ni²⁺',
                                                   variable=a1,
                                                   value='09',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Sn/Sn²⁺',
                                                   variable=a1,
                                                   value='10',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='H₂/2H₃O⁺ (sauer)',
                                                   variable=a1,
                                                   value='11',
                                                   background='white',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Cu/Cu²⁺',
                                                   variable=a1,
                                                   value='12',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='2OH⁻/O₂ (alkalisch)',
                                                   variable=a1,
                                                   value='13',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='2I⁻/I₂',
                                                   variable=a1,
                                                   value='14',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Ag/Ag⁺',
                                                   variable=a1,
                                                   value='15',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='2Br⁻/Br₂',
                                                   variable=a1,
                                                   value='16',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='2H₂O/O₂ (sauer)',
                                                   variable=a1,
                                                   value='17',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='2Cl⁻/Cl₂',
                                                   variable=a1,
                                                   value='18',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='Mn²⁺/MnO₄⁻ (sauer)',
                                                   variable=a1,
                                                   value='19',
                                                   command=self.auswahl_linke_halbzelle)
        self.menue_linke_halbzelle.add_radiobutton(label='PbSO₄/PbO₂ (sauer)',
                                                   variable=a1,
                                                   value='20',
                                                   command=self.auswahl_linke_halbzelle)
        self.mb_linke_halbzelle.config(menu=self.menue_linke_halbzelle)
        # Rechte Halbzelle
        global a2
        a2=StringVar()
        a2.set('X')
        self.menue_rechte_halbzelle=Menu(self.mb_rechte_halbzelle, tearoff=0)
        self.menue_rechte_halbzelle.add_radiobutton(label='Li/Li⁺',
                                                   variable=a2,
                                                   value='01',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Na/Na⁺',
                                                   variable=a2,
                                                   value='02',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Al/Al³⁺',
                                                   variable=a2,
                                                   value='03',
                                                  command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='H₂/2H₂O (alkalisch)',
                                                   variable=a2,
                                                   value='04',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Zn/Zn²⁺',
                                                   variable=a2,
                                                   value='05',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Fe/Fe²⁺',
                                                   variable=a2,
                                                   value='06',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Cd/Cd²⁺',
                                                   variable=a2,
                                                   value='07',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Pb/PbSO₄ (sauer)',
                                                   variable=a2,
                                                   value='08',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Ni/Ni²⁺',
                                                   variable=a2,
                                                   value='09',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Sn/Sn²⁺',
                                                   variable=a2,
                                                   value='10',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='H₂/2H₃O⁺ (sauer)',
                                                   variable=a2,
                                                   value='11',
                                                   background='white',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Cu/Cu²⁺',
                                                   variable=a2,
                                                   value='12',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='2OH⁻/O₂ (alkalisch)',
                                                   variable=a2,
                                                   value='13',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='2I⁻/I₂',
                                                   variable=a2,
                                                   value='14',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Ag/Ag⁺',
                                                   variable=a2,
                                                   value='15',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='2Br⁻/Br₂',
                                                   variable=a2,
                                                   value='16',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='2H₂O/O₂ (sauer)',
                                                   variable=a2,
                                                   value='17',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='2Cl⁻/Cl₂',
                                                   variable=a2,
                                                   value='18',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='Mn²⁺/MnO₄⁻ (sauer)',
                                                   variable=a2,
                                                   value='19',
                                                   command=self.auswahl_rechte_halbzelle)
        self.menue_rechte_halbzelle.add_radiobutton(label='PbSO₄/PbO₂ (sauer)',
                                                   variable=a2,
                                                   value='20',
                                                   command=self.auswahl_rechte_halbzelle)
        self.mb_rechte_halbzelle.config(menu=self.menue_rechte_halbzelle)
        # Ansicht
        global a3
        a3=StringVar()
        a3.set('X')
        self.menue_ansicht=Menu(self.mb_ansicht, tearoff=0)
        self.icon_versuchsaufbau=PhotoImage(file='daten/icons/versuchsaufbau.gif')
        self.menue_ansicht.add_radiobutton(label='Versuchsaufbau',
                                                  variable=a3,
                                                  value='stoffebene',
                                                  image=self.icon_versuchsaufbau,
                                                  compound=LEFT,
                                                  command=self.auswahl_ansicht)
        self.menue_ansicht.icon_versuchsaufbau=self.icon_versuchsaufbau
        self.icon_teilchenmodell=PhotoImage(file='daten/icons/teilchenmodell.gif')
        self.menue_ansicht.add_radiobutton(label='Teilchenmodell',
                                                  variable=a3,
                                                  value='teilchenebene',
                                                  image=self.icon_teilchenmodell,
                                                  compound=LEFT,
                                                  command=self.auswahl_ansicht)
        self.menue_ansicht.icon_teilchenmodell=self.icon_teilchenmodell
        self.mb_ansicht.config(menu=self.menue_ansicht)
        # Halbzellenauswahl deaktivieren
        self.mb_linke_halbzelle.config(state=DISABLED)
        self.mb_rechte_halbzelle.config(state=DISABLED)
        for i in range(0, 19):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 19):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        # Ansichtsauswahl deaktivieren
        self.mb_ansicht.config(state=DISABLED)
        # Menüelemente anzeigen
        for i, row, column, sticky in (
                (self.menueleiste,                  0, 0, E+W),
                (self.mb_datei,                     0, 0, W),
                (self.mb_kapitel,                   0, 1, W),
                (self.mb_linke_halbzelle,           0, 2, W),
                (self.mb_rechte_halbzelle,          0, 3, W),
                (self.mb_ansicht,                   0, 4, W)):
            i.grid(row=row, column=column, sticky=sticky)

        # Rahmen 2: Zeichenflächen
        self.f2canvas1=Canvas(self.frame2, width=400, height=600, bg='white')
        self.f2canvas2=Canvas(self.frame2, width=150, height=600, bg='white')
        self.f2canvas3=Canvas(self.frame2, width=400, height=600, bg='white')
        for i, row, column, sticky in (
                (self.f2canvas1, 0, 0, E+W),
                (self.f2canvas2, 0, 1, E+W),
                (self.f2canvas3, 0, 2, E+W)):
            i.grid(row=row, column=column, sticky=sticky, padx=0, pady=0)

        # Rahmen 3: Schaltelemente Abhängigkeiten Konzentration und pH-Wert
        self.f3l1=Label(self.frame3, text='Konzentration:')
        self.f3scale1=Scale(self.frame3,
                            length=100,
                            from_=0.01,
                            to=1.00,
                            resolution=0.01,
                            showvalue=1,
                            orient=HORIZONTAL,
                            command=self.konzentration_linke_halbzelle)
        self.f3scale1.set(1.00)
        self.f3l2=Label(self.frame3, text='Halbzellenreaktion:')
        self.f3e1=Entry(self.frame3, width=40, state=DISABLED)
        self.f3l3=Label(self.frame3, text='Konzentration:')
        self.f3scale2=Scale(self.frame3,
                            length=100,
                            from_=0.01,
                            to=1.00,
                            resolution=0.01,
                            showvalue=1,
                            orient=HORIZONTAL,
                            command=self.konzentration_rechte_halbzelle)
        self.f3scale2.set(1.00)
        self.f3l4=Label(self.frame3, text='Halbzellenreaktion:')
        self.f3e2=Entry(self.frame3, width=40, state=DISABLED)
        self.f3l5=Label(self.frame3, text='pH-Wert:')
        self.f3scale3=Scale(self.frame3,
                            length=100,
                            from_=0,
                            to=14,
                            resolution=1,
                            showvalue=1,
                            orient=HORIZONTAL,
                            command=self.phwert_rechte_halbzelle)
        self.f3scale2.set(1.00)
        for i in (self.f3l1, self.f3scale1, self.f3l3, self.f3scale2,
                  self.f3l2, self.f3e1,     self.f3l4, self.f3e2,
                                            self.f3l5, self.f3scale3):
            i.config(state=DISABLED)
        self.f3scale1.config(state=DISABLED)
        self.f3scale2.config(state=DISABLED)
        self.f3scale3.config(state=DISABLED)
        self.f3l6=Label(self.frame3, text='Halbzellenpotential [V]:')
        self.f3e3=Entry(self.frame3, width=8, state=DISABLED)
        self.f3l7=Label(self.frame3, text='Halbzellenpotential [V]:')
        self.f3e4=Entry(self.frame3, width=8, state=DISABLED)
        for i, row, column, sticky in (
                (self.f3l1,         0, 0, E),
                (self.f3scale1,     0, 1, E+W),
                (self.f3l3,         0, 2, E),
                (self.f3scale2,     0, 3, E+W),
                (self.f3l2,         1, 0, E),
                (self.f3e1,         1, 1, E+W),
                (self.f3l4,         1, 2, E),
                (self.f3e2,         1, 3, E+W),
                (self.f3l5,         2, 2, E),
                (self.f3scale3,     2, 3, E+W),
                (self.f3l6,         3, 0, E),
                (self.f3e3,         3, 1, W),
                (self.f3l7,         3, 2, E),
                (self.f3e4,         3, 3, W)
                ):
            i.grid(row=row, column=column, sticky=sticky, padx=0, pady=0)

        ########################################################################

        global kapitel
        kapitel=StringVar()
        kapitel.set('X')

        ########################################################################
        ####                     Funktionen Dateimenü                       ####
        ########################################################################

    def setze_ganz_zurueck(self):
        self.zurueck_setzen()
        kapitel.set('X')

    def zurueck_setzen(self):
        #print('zurueck_setzen')
        self.mb_linke_halbzelle.config(state=DISABLED)
        self.mb_rechte_halbzelle.config(state=DISABLED)
        self.mb_ansicht.config(state=DISABLED)
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        for i in (self.f3l1, self.f3scale1, self.f3l3, self.f3scale2,
                  self.f3l2, self.f3e1,     self.f3l4, self.f3e2,
                                            self.f3l5, self.f3scale3):
            i.config(state=DISABLED)
        self.f3scale1.config(state=NORMAL)
        self.f3scale2.config(state=NORMAL)
        self.f3scale3.config(state=NORMAL)
        self.f3scale1.set(1.00)
        self.f3scale2.set(1.00)
        self.f3scale3.set(0)
        self.f3scale1.config(state=DISABLED)
        self.f3scale2.config(state=DISABLED)
        self.f3scale3.config(state=DISABLED)
        self.f3e1.config(state=NORMAL)
        self.f3e2.config(state=NORMAL)
        self.f3e3.config(state=NORMAL)
        self.f3e4.config(state=NORMAL)
        self.f3e1.delete(0, END)
        self.f3e2.delete(0, END)
        self.f3e3.delete(0, END)
        self.f3e4.delete(0, END)
        self.f3e1.config(state=DISABLED)
        self.f3e2.config(state=DISABLED)
        self.f3e3.config(state=DISABLED)
        self.f3e4.config(state=DISABLED)
        for canvas in (self.f2canvas1, self.f2canvas2, self.f2canvas3):
            for i in canvas.find_all():
                canvas.delete(i)
            canvas.config(background='white')
            canvas.update()

        ################################################################
        ####                Funktionen Kapitelauswahl               ####
        ################################################################

    def elektronendruckreihe_metalle(self):
        # Mit Wasserstoff/Oxoniumionen als Bezugselektrode
        kapitel.set('elektronendruckreihe_metalle')
        #print('elektronendruckreihe_metalle')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (0, 1, 2, 4, 5, 6, 8, 9, 10, 11, 14):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (0, 1, 2, 4, 5, 6, 8, 9, 10, 11, 14):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(7)
        self.f3scale3.config(state=DISABLED)
        # Ansichtsauswahl aktivieren
        self.mb_ansicht.config(state=NORMAL)

    def elektronendruckreihe_nichtmetalle(self):
        kapitel.set('elektronendruckreihe_nichtmetalle')
        #print('elektronendruckreihe_nichtmetalle')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (13, 15, 17):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (13, 15, 17):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(7)
        self.f3scale3.config(state=DISABLED)
        # Ansichtsauswahl aktivieren
        self.mb_ansicht.config(state=NORMAL)

    def silber_konzentrationselement(self):
        kapitel.set('silber_konzentrationselement')
        #print('silber_konzentrationselement')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (14, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (14, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale1.config(state=NORMAL)
        self.f3scale2.config(state=NORMAL)
        for i in (self.f3l1, self.f3scale1, self.f3l3, self.f3scale2,
                  self.f3l2, self.f3e1,     self.f3l4, self.f3e2):
            i.config(state=NORMAL)
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(7)
        self.f3scale3.config(state=DISABLED)

    def kupfer_konzentrationselement(self):
        kapitel.set('kupfer_konzentrationselement')
        #print('kupfer_konzentrationselement')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (11, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (11, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale1.config(state=NORMAL)
        self.f3scale2.config(state=NORMAL)
        for i in (self.f3l1, self.f3scale1, self.f3l3, self.f3scale2,
                  self.f3l2, self.f3e1,     self.f3l4, self.f3e2):
            i.config(state=NORMAL)
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(7)
        self.f3scale3.config(state=DISABLED)

    def saeurekorrosion_zink(self):
        kapitel.set('saeurekorrosion_zink')
        #print('saeurekorrosion_zink')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (4, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (10, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        for i in (self.f3l5, self.f3scale3):
            i.config(state=NORMAL)
        self.f3scale3.set(0)
        

    def halbzellenpotential_permanganat(self):
        kapitel.set('halbzellenpotential_permanganat')
        #print('halbzellenpotential_permanganat')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (10, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (18, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        for i in (self.f3l5, self.f3scale3):
            i.config(state=NORMAL)
        self.f3scale3.set(0)

    def daniell_element(self):
        kapitel.set('daniell_element')
        #print('daniell_element')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (4, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (11, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3l1.config(state=NORMAL)
        self.f3l3.config(state=NORMAL)
        self.f3scale1.config(state=NORMAL)
        self.f3scale2.config(state=NORMAL)
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(7)
        self.f3scale3.config(state=DISABLED)
        # Ansichtsauswahl aktivieren
        self.mb_ansicht.config(state=NORMAL)

    def zink_luft_batterie(self):
        kapitel.set('zink_luft_batterie')
        #print('zink_luft_batterie')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (4, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (12, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(14)
        self.f3scale3.config(state=DISABLED)

    def zink_brom_element(self):
        kapitel.set('zink_brom_element')
        #print('zink_brom_element')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (4, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (15, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(7)
        self.f3scale3.config(state=DISABLED)
        # Ansichtsauswahl aktivieren
        self.mb_ansicht.config(state=NORMAL)

    def cadmium_nickel_akku(self):
        kapitel.set('cadmium_nickel_akku')
        #print('cadmium_nickel_akku')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (6, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (8, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(14)
        self.f3scale3.config(state=DISABLED)

    def blei_akku(self):
        kapitel.set('blei_akku')
        #print('blei_akku')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (7, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (19, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(0)
        self.f3scale3.config(state=DISABLED)
        # Ansichtsauswahl aktivieren
        self.mb_ansicht.config(state=NORMAL)

    def brennstoffzelle(self):
        kapitel.set('brennstoffzelle')
        #print('brennstoffzelle')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (3, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (12, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(14)
        self.f3scale3.config(state=DISABLED)
        # Ansichtsauswahl aktivieren
        self.mb_ansicht.config(state=NORMAL)

    def sauerstoffkorrosion_eisen(self):
        kapitel.set('sauerstoffkorrosion_eisen')
        #print('sauerstoffkorrosion_eisen')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (5, ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (12, ):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(14)
        self.f3scale3.config(state=DISABLED)
        # Ansichtsauswahl aktivieren
        self.mb_ansicht.config(state=NORMAL)

    def verzinken(self):
        kapitel.set('verzinken')
        #print('verzinken')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (4, 5 ):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (4, 5, 12):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(0)
        self.f3scale3.config(state=DISABLED)
        # Ansichtsauswahl aktivieren
        self.mb_ansicht.config(state=NORMAL)

    def verzinnen(self):
        kapitel.set('verzinnen')
        #print('verzinnen')
        self.zurueck_setzen()
        for i in range(0, 20):
            self.menue_linke_halbzelle.entryconfig(i, state=DISABLED)
        for i in range(0, 20):
            self.menue_rechte_halbzelle.entryconfig(i, state=DISABLED)
        for i in (5, 9):
            self.menue_linke_halbzelle.entryconfig(i, state=NORMAL)
        for i in (5, 9, 12):
            self.menue_rechte_halbzelle.entryconfig(i, state=NORMAL)
        self.mb_linke_halbzelle.config(state=NORMAL)
        for i in (a1, a2, a3):
            i.set('X')
        self.f3scale3.config(state=NORMAL)
        self.f3scale3.set(0)
        self.f3scale3.config(state=DISABLED)
        # Ansichtsauswahl aktivieren
        self.mb_ansicht.config(state=NORMAL)

        ########################################################################
        ####             Funktionen zur Ansicht der Hilfeseiten             ####
        ########################################################################

    def auswahl_ansicht(self):
        self.a3=str(a3.get())
        self.kapitel=str(kapitel.get())
        #print('auswahl_ansicht', self.kapitel, self.a3)
        self.seiten_url='file://'+os.getcwd()+os.sep+'daten/html/'+self.kapitel+'.html#'+self.a3
        #print self.seiten_url
        webbrowser.open(self.seiten_url)


        ########################################################################
        ####                       Funktionen Halbzellenauswahl             ####
        ########################################################################

    def auswahl_linke_halbzelle(self):
        self.kapitel=str(kapitel.get())
        #print(self.kapitel, 'auswahl_linke_halbzelle')
        self.a1=str(a1.get())
        self.a2=str(a2.get())
        self.mb_rechte_halbzelle.config(state=NORMAL)
        self.f3e3.config(state=NORMAL)
        self.linkes_halbzellenpotential_text=str(self.linke_halbzellen[self.a1]['E0'])
        self.linkes_halbzellenpotential_float=float(self.linke_halbzellen[self.a1]['E0'])
        self.f3e3.delete(0, END)
        self.f3e3.insert(0, self.linkes_halbzellenpotential_text)
        ## Zeichnen Fall 1: Rechte Halbzelle ist noch nicht ausgewählt
        if self.a2 == 'X':
            ########### Zeichenelemente links erzeugen -ANFANG noch ohne die Werte der rechten Halbzelle!
            # vorhandene links löschen
            for i in self.f2canvas1.find_all():
                self.f2canvas1.delete(i)
            self.farbe_loesung=self.linke_halbzellen[self.a1]['beschriftung'][3]
            self.farbe_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][2]
            self.beschriftung_loesung=self.linke_halbzellen[self.a1]['beschriftung'][1]
            self.beschriftung_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][0]
            self.versuchsaufbau_linke_halbzelle=Linke_halbzelle(self.f2canvas1,
                                                                0,
                                                                0,
                                                                self.farbe_loesung,
                                                                self.farbe_elektrode,
                                                                self.beschriftung_loesung,
                                                                self.beschriftung_elektrode,
                                                                NORMAL)
            ########### erzeugen Zeichenelemente links - ENDE
            ########### anpassen Zeichenelemente links - ANFANG
            self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('black')
            self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
            ########### anpassen Zeichenelemente links - ENDE
            # Leinwand1 updaten
            self.f2canvas1.config(background='white')
            self.f2canvas1.update()
        ## Fall 1: Rechte Halbzelle ist bereits ausgewählt
        if self.a2 != 'X':
            self.rechtes_halbzellenpotential_text=str(self.rechte_halbzellen[self.a2]['E0'])
            self.rechtes_halbzellenpotential_float=float(self.rechte_halbzellen[self.a2]['E0'])
            # Fall 1a) Messgerät auf mittlerer Zeichenfläche
            # Löschen des Messgeräts
            for i in self.f2canvas2.find_all():
                self.f2canvas2.delete(i)
            # Zeichnen des Messgeräts
            self.messgeraet=Messgeraet_und_ionenbruecke(self.f2canvas2,
                                                        50,
                                                        50,
                                                        self.linkes_halbzellenpotential_float,
                                                        self.rechtes_halbzellenpotential_float,
                                                        NORMAL)
            # Leinwand2 updaten
            self.f2canvas2.config(background='white')
            self.f2canvas2.update()
        # Werte für Halbzellengleichung links
        self.links_koeff_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][0]
        self.links_sf_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][1]
        self.links_koeff_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][2]
        self.links_sf_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][3]
        self.links_koeff_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][4]
        self.links_sf_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][5]
        self.links_koeff_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][0]
        self.links_sf_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][1]
        self.links_koeff_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][2]
        self.links_sf_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][3]
        self.links_koeff_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][4]
        self.links_sf_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][5]
        self.links_koeff_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][6]
        self.links_sf_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][7]
        self.links_reduktionsliste_li=[
            self.links_koeff_redm_li+' '+self.links_sf_redm_li,             #0
            self.links_koeff_ladaus_li+' '+self.links_sf_ladaus_li,         #1
            self.links_koeff_stoffaus_li+' '+self.links_sf_stoffaus_li,     #2
            ]
        self.links_reduktionsliste_re=[
            self.links_koeff_oxm_re+' '+self.links_sf_oxm_re,               #0
            self.links_koeff_el_re+' '+self.links_sf_el_re,                 #1
            self.links_koeff_ladaus_re+' '+self.links_sf_ladaus_re,         #2
            self.links_koeff_stoffaus_re+' '+self.links_sf_stoffaus_re      #3
            ]
        # Listen bereinigen
        laenge_li=len(self.links_reduktionsliste_li)
        i = 0
        remove = True
        while remove:
            remove = False
            for i in self.links_reduktionsliste_li[:]:
                for j in i[:]:
                    if len(j) < 1:
                        i.remove(j)
                if len(i) < 2:
                    self.links_reduktionsliste_li.remove(i)
                    remove = True
                    break
        laenge_re=len(self.links_reduktionsliste_re)
        i = 0
        remove = True
        while remove:
            remove = False
            for i in self.links_reduktionsliste_re[:]:
                for j in i[:]:
                    if len(j) < 1:
                        i.remove(j)
                if len(i) < 2:
                    self.links_reduktionsliste_re.remove(i)
                    remove = True
                    break
        # Halbzellengleichung nur links
        self.links_gleichungstext_li=''
        for i in range(0, len(self.links_reduktionsliste_li)):
            if i == 0:
                self.links_gleichungstext_li=self.links_gleichungstext_li+self.links_reduktionsliste_li[i]
            elif i > 0 and i < len(self.links_reduktionsliste_li):
                self.links_gleichungstext_li=self.links_gleichungstext_li+'+'+self.links_reduktionsliste_li[i]
        self.links_gleichungstext_re=''
        for i in range(0, len(self.links_reduktionsliste_re)):
            if i == 0:
                self.links_gleichungstext_re=self.links_gleichungstext_re+self.links_reduktionsliste_re[i]
            elif i > 0 and i < len(self.links_reduktionsliste_re):
                self.links_gleichungstext_re=self.links_gleichungstext_re+'+'+self.links_reduktionsliste_re[i]
        # Linke und rechte Hälfte kombinieren
        self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
        self.links_gleichungstext_bereinigt=re.sub('1', '', self.links_gleichungstext)
        #print(self.links_gleichungstext_bereinigt)
        self.f3l2.config(state=NORMAL)
        self.f3e1.config(state=NORMAL)
        self.f3e1.delete(0, END)
        self.f3e1.insert(0, self.links_gleichungstext_bereinigt)
        ## Fall 2: Rechte Halbzelle wurde bereits ausgewählt => Halbzellengleichung links und rechts
        if self.a2 != 'X':
            # Werte für Halbzellengleichung links
            self.links_koeff_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][0]
            self.links_sf_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][1]
            self.links_koeff_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][2]
            self.links_sf_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][3]
            self.links_koeff_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][4]
            self.links_sf_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][5]
            self.links_koeff_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][0]
            self.links_sf_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][1]
            self.links_koeff_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][2]
            self.links_sf_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][3]
            self.links_koeff_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][4]
            self.links_sf_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][5]
            self.links_koeff_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][6]
            self.links_sf_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][7]
            self.links_reduktionsliste_li=[
                self.links_koeff_redm_li+' '+self.links_sf_redm_li,             #0
                self.links_koeff_ladaus_li+' '+self.links_sf_ladaus_li,         #1
                self.links_koeff_stoffaus_li+' '+self.links_sf_stoffaus_li,     #2
                ]
            self.links_reduktionsliste_re=[
                self.links_koeff_oxm_re+' '+self.links_sf_oxm_re,               #0
                self.links_koeff_el_re+' '+self.links_sf_el_re,                 #1
                self.links_koeff_ladaus_re+' '+self.links_sf_ladaus_re,         #2
                self.links_koeff_stoffaus_re+' '+self.links_sf_stoffaus_re      #3
                ]
            # Listen bereinigen
            laenge_li=len(self.links_reduktionsliste_li)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.links_reduktionsliste_li[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.links_reduktionsliste_li.remove(i)
                        remove = True
                        break
            laenge_re=len(self.links_reduktionsliste_re)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.links_reduktionsliste_re[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.links_reduktionsliste_re.remove(i)
                        remove = True
                        break
            # Halbzellengleichung nur links
            self.links_gleichungstext_li=''
            for i in range(0, len(self.links_reduktionsliste_li)):
                if i == 0:
                    self.links_gleichungstext_li=self.links_gleichungstext_li+self.links_reduktionsliste_li[i]
                elif i > 0 and i < len(self.links_reduktionsliste_li):
                    self.links_gleichungstext_li=self.links_gleichungstext_li+'+'+self.links_reduktionsliste_li[i]
            self.links_gleichungstext_re=''
            for i in range(0, len(self.links_reduktionsliste_re)):
                if i == 0:
                    self.links_gleichungstext_re=self.links_gleichungstext_re+self.links_reduktionsliste_re[i]
                elif i > 0 and i < len(self.links_reduktionsliste_re):
                    self.links_gleichungstext_re=self.links_gleichungstext_re+'+'+self.links_reduktionsliste_re[i]
            # Werte für Halbzellengleichung rechts
            self.rechts_koeff_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][0]
            self.rechts_sf_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][1]
            self.rechts_koeff_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][2]
            self.rechts_sf_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][3]
            self.rechts_koeff_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][4]
            self.rechts_sf_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][5]
            self.rechts_koeff_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][0]
            self.rechts_sf_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][1]
            self.rechts_koeff_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][2]
            self.rechts_sf_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][3]
            self.rechts_koeff_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][4]
            self.rechts_sf_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][5]
            self.rechts_koeff_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][6]
            self.rechts_sf_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][7]
            self.rechts_reduktionsliste_li=[
                self.rechts_koeff_redm_li+' '+self.rechts_sf_redm_li,             #0
                self.rechts_koeff_ladaus_li+' '+self.rechts_sf_ladaus_li,         #1
                self.rechts_koeff_stoffaus_li+' '+self.rechts_sf_stoffaus_li,     #2
                ]
            self.rechts_reduktionsliste_re=[
                self.rechts_koeff_oxm_re+' '+self.rechts_sf_oxm_re,               #0
                self.rechts_koeff_el_re+' '+self.rechts_sf_el_re,                 #1
                self.rechts_koeff_ladaus_re+' '+self.rechts_sf_ladaus_re,         #2
                self.rechts_koeff_stoffaus_re+' '+self.rechts_sf_stoffaus_re      #3
                ]
            # Listen bereinigen
            laenge_li=len(self.rechts_reduktionsliste_li)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.rechts_reduktionsliste_li[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.rechts_reduktionsliste_li.remove(i)
                        remove = True
                        break
            laenge_re=len(self.rechts_reduktionsliste_re)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.rechts_reduktionsliste_re[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.rechts_reduktionsliste_re.remove(i)
                        remove = True
                        break
            # Halbzellengleichung links und rechts
            self.rechts_gleichungstext_li=''
            for i in range(0, len(self.rechts_reduktionsliste_li)):
                if i == 0:
                    self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+self.rechts_reduktionsliste_li[i]
                elif i > 0 and i < len(self.rechts_reduktionsliste_li):
                    self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+'+'+self.rechts_reduktionsliste_li[i]
            self.rechts_gleichungstext_re=''
            for i in range(0, len(self.rechts_reduktionsliste_re)):
                if i == 0:
                    self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+self.rechts_reduktionsliste_re[i]
                elif i > 0 and i < len(self.rechts_reduktionsliste_re):
                    self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+'+'+self.rechts_reduktionsliste_re[i]
            ########### Zeichenelemente links erzeugen -ANFANG
            # vorhandene links löschen
            for i in self.f2canvas1.find_all():
                self.f2canvas1.delete(i)
            self.farbe_loesung=self.linke_halbzellen[self.a1]['beschriftung'][3]
            self.farbe_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][2]
            self.beschriftung_loesung=self.linke_halbzellen[self.a1]['beschriftung'][1]
            self.beschriftung_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][0]
            self.versuchsaufbau_linke_halbzelle=Linke_halbzelle(self.f2canvas1,
                                                                0,
                                                                0,
                                                                self.farbe_loesung,
                                                                self.farbe_elektrode,
                                                                self.beschriftung_loesung,
                                                                self.beschriftung_elektrode,
                                                                NORMAL)
            ########### erzeugen Zeichenelemente links - ENDE
            ########### Zeichenelemente rechts erzeugen -ANFANG
            # vorhandene rechts löschen
            for i in self.f2canvas3.find_all():
                self.f2canvas3.delete(i)
            self.farbe_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][3]
            self.farbe_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][2]
            self.beschriftung_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][1]
            self.beschriftung_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][0]
            self.versuchsaufbau_rechte_halbzelle=Rechte_halbzelle(self.f2canvas3,
                                                                  0,
                                                                  0,
                                                                  self.farbe_loesung,
                                                                  self.farbe_elektrode,
                                                                  self.beschriftung_loesung,
                                                                  self.beschriftung_elektrode,
                                                                  NORMAL)
            ########### erzeugen Zeichenelemente rechts - ENDE
            # Linke und rechte Hälfte kombinieren und anpassen Zeichenelemente links
            if self.linkes_halbzellenpotential_float < self.rechtes_halbzellenpotential_float:
                self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
                self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
                self.messgeraet.pfeilpos_aendern(LAST)
                self.messgeraet.pfeilzustand_aendern(NORMAL)
                self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('blue')
                self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
                self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('red')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
            elif self.linkes_halbzellenpotential_float > self.rechtes_halbzellenpotential_float:
                self.links_gleichungstext=self.links_gleichungstext_re+' ⇌ '+self.links_gleichungstext_li
                self.rechts_gleichungstext=self.rechts_gleichungstext_li+' ⇌ '+self.rechts_gleichungstext_re
                self.messgeraet.pfeilpos_aendern(FIRST)
                self.messgeraet.pfeilzustand_aendern(NORMAL)
                self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('red')
                self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
                self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('blue')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
            elif self.linkes_halbzellenpotential_float == self.rechtes_halbzellenpotential_float:
                self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
                self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
                self.messgeraet.pfeilpos_aendern(NONE)
                self.messgeraet.pfeilzustand_aendern(HIDDEN)
                self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('black')
                self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
                self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('black')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
            self.links_gleichungstext_bereinigt=re.sub('1', '', self.links_gleichungstext)
            self.rechts_gleichungstext_bereinigt=re.sub('1', '', self.rechts_gleichungstext)
            #print(self.links_gleichungstext)
            self.f3l2.config(state=NORMAL)
            self.f3e1.config(state=NORMAL)
            self.f3e1.delete(0, END)
            self.f3e1.insert(0, self.links_gleichungstext_bereinigt)
            self.f3l4.config(state=NORMAL)
            self.f3e2.config(state=NORMAL)
            self.f3e2.delete(0, END)
            self.f3e2.insert(0, self.rechts_gleichungstext_bereinigt)
        # Leinwand1 und Leinwand2 updaten
        self.f2canvas1.config(background='white')
        self.f2canvas2.config(background='white')
        self.f2canvas1.update()
        self.f2canvas2.update()


    def auswahl_rechte_halbzelle(self):
        self.kapitel=str(kapitel.get())
        #print(self.kapitel, 'auswahl_rechte_halbzelle')
        # linke halbzellenauswahl deaktivieren
        #self.mb_linke_halbzelle.config(state=DISABLED)
        self.a1=str(a1.get())
        self.a2=str(a2.get())
        #print(self.a1+self.a2)
        self.f3e4.config(state=NORMAL)
        self.linkes_halbzellenpotential_text=str(self.linke_halbzellen[self.a1]['E0'])
        self.rechtes_halbzellenpotential_text=str(self.rechte_halbzellen[self.a2]['E0'])
        self.linkes_halbzellenpotential_float=float(self.linke_halbzellen[self.a1]['E0'])
        self.rechtes_halbzellenpotential_float=float(self.rechte_halbzellen[self.a2]['E0'])
        self.f3e4.delete(0, END)
        self.f3e4.insert(0, self.rechtes_halbzellenpotential_text)
        # Löschen des Messgeräts
        for i in self.f2canvas2.find_all():
            self.f2canvas2.delete(i)
        # Zeichnen des Messgeräts
        self.messgeraet=Messgeraet_und_ionenbruecke(self.f2canvas2,
                                                    50,
                                                    50,
                                                    self.linkes_halbzellenpotential_float,
                                                    self.rechtes_halbzellenpotential_float,
                                                    NORMAL)
        # Leinwand2 updaten
        self.f2canvas2.config(background='white')
        self.f2canvas2.update()
        # Werte für Halbzellengleichung links
        self.links_koeff_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][0]
        self.links_sf_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][1]
        self.links_koeff_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][2]
        self.links_sf_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][3]
        self.links_koeff_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][4]
        self.links_sf_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][5]
        self.links_koeff_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][0]
        self.links_sf_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][1]
        self.links_koeff_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][2]
        self.links_sf_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][3]
        self.links_koeff_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][4]
        self.links_sf_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][5]
        self.links_koeff_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][6]
        self.links_sf_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][7]
        self.links_reduktionsliste_li=[
            self.links_koeff_redm_li+' '+self.links_sf_redm_li,             #0
            self.links_koeff_ladaus_li+' '+self.links_sf_ladaus_li,         #1
            self.links_koeff_stoffaus_li+' '+self.links_sf_stoffaus_li,     #2
            ]
        self.links_reduktionsliste_re=[
            self.links_koeff_oxm_re+' '+self.links_sf_oxm_re,               #0
            self.links_koeff_el_re+' '+self.links_sf_el_re,                 #1
            self.links_koeff_ladaus_re+' '+self.links_sf_ladaus_re,         #2
            self.links_koeff_stoffaus_re+' '+self.links_sf_stoffaus_re      #3
            ]
        # Listen bereinigen
        laenge_li=len(self.links_reduktionsliste_li)
        i = 0
        remove = True
        while remove:
            remove = False
            for i in self.links_reduktionsliste_li[:]:
                for j in i[:]:
                    if len(j) < 1:
                        i.remove(j)
                if len(i) < 2:
                    self.links_reduktionsliste_li.remove(i)
                    remove = True
                    break
        laenge_re=len(self.links_reduktionsliste_re)
        i = 0
        remove = True
        while remove:
            remove = False
            for i in self.links_reduktionsliste_re[:]:
                for j in i[:]:
                    if len(j) < 1:
                        i.remove(j)
                if len(i) < 2:
                    self.links_reduktionsliste_re.remove(i)
                    remove = True
                    break
        # Werte für Halbzellengleichung rechts
        self.rechts_koeff_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][0]
        self.rechts_sf_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][1]
        self.rechts_koeff_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][2]
        self.rechts_sf_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][3]
        self.rechts_koeff_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][4]
        self.rechts_sf_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][5]
        self.rechts_koeff_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][0]
        self.rechts_sf_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][1]
        self.rechts_koeff_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][2]
        self.rechts_sf_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][3]
        self.rechts_koeff_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][4]
        self.rechts_sf_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][5]
        self.rechts_koeff_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][6]
        self.rechts_sf_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][7]
        self.rechts_reduktionsliste_li=[
            self.rechts_koeff_redm_li+' '+self.rechts_sf_redm_li,             #0
            self.rechts_koeff_ladaus_li+' '+self.rechts_sf_ladaus_li,         #1
            self.rechts_koeff_stoffaus_li+' '+self.rechts_sf_stoffaus_li,     #2
            ]
        self.rechts_reduktionsliste_re=[
            self.rechts_koeff_oxm_re+' '+self.rechts_sf_oxm_re,               #0
            self.rechts_koeff_el_re+' '+self.rechts_sf_el_re,                 #1
            self.rechts_koeff_ladaus_re+' '+self.rechts_sf_ladaus_re,         #2
            self.rechts_koeff_stoffaus_re+' '+self.rechts_sf_stoffaus_re      #3
            ]
        # Listen bereinigen
        laenge_li=len(self.rechts_reduktionsliste_li)
        i = 0
        remove = True
        while remove:
            remove = False
            for i in self.rechts_reduktionsliste_li[:]:
                for j in i[:]:
                    if len(j) < 1:
                        i.remove(j)
                if len(i) < 2:
                    self.rechts_reduktionsliste_li.remove(i)
                    remove = True
                    break
        laenge_re=len(self.rechts_reduktionsliste_re)
        i = 0
        remove = True
        while remove:
            remove = False
            for i in self.rechts_reduktionsliste_re[:]:
                for j in i[:]:
                    if len(j) < 1:
                        i.remove(j)
                if len(i) < 2:
                    self.rechts_reduktionsliste_re.remove(i)
                    remove = True
                    break
        # Halbzellengleichung links und rechts
        self.rechts_gleichungstext_li=''
        for i in range(0, len(self.rechts_reduktionsliste_li)):
            if i == 0:
                self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+self.rechts_reduktionsliste_li[i]
            elif i > 0 and i < len(self.rechts_reduktionsliste_li):
                self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+'+'+self.rechts_reduktionsliste_li[i]
        self.rechts_gleichungstext_re=''
        for i in range(0, len(self.rechts_reduktionsliste_re)):
            if i == 0:
                self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+self.rechts_reduktionsliste_re[i]
            elif i > 0 and i < len(self.rechts_reduktionsliste_re):
                self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+'+'+self.rechts_reduktionsliste_re[i]
        ########### Zeichenelemente links erzeugen -ANFANG
        # vorhandene links löschen
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        self.farbe_loesung=self.linke_halbzellen[self.a1]['beschriftung'][3]
        self.farbe_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][2]
        self.beschriftung_loesung=self.linke_halbzellen[self.a1]['beschriftung'][1]
        self.beschriftung_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][0]
        self.versuchsaufbau_linke_halbzelle=Linke_halbzelle(self.f2canvas1,
                                                            0,
                                                            0,
                                                            self.farbe_loesung,
                                                            self.farbe_elektrode,
                                                            self.beschriftung_loesung,
                                                            self.beschriftung_elektrode,
                                                            NORMAL)
        ########### erzeugen Zeichenelemente links - ENDE
        ########### Zeichenelemente rechts erzeugen -ANFANG
        # vorhandene rechts löschen
        for i in self.f2canvas3.find_all():
            self.f2canvas3.delete(i)
        self.farbe_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][3]
        self.farbe_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][2]
        self.beschriftung_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][1]
        self.beschriftung_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][0]
        self.versuchsaufbau_rechte_halbzelle=Rechte_halbzelle(self.f2canvas3,
                                                                0,
                                                                0,
                                                                self.farbe_loesung,
                                                                self.farbe_elektrode,
                                                                self.beschriftung_loesung,
                                                                self.beschriftung_elektrode,
                                                                NORMAL)
        ########### erzeugen Zeichenelemente rechts - ENDE
        # Linke und rechte Hälfte kombinieren
        if self.linkes_halbzellenpotential_float < self.rechtes_halbzellenpotential_float:
            self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
            self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
            self.messgeraet.pfeilpos_aendern(LAST)
            self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('blue')
            self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
            self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
            self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('red')
            self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
            self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
            self.messgeraet.pfeilzustand_aendern(NORMAL)
        elif self.linkes_halbzellenpotential_float > self.rechtes_halbzellenpotential_float:
            self.links_gleichungstext=self.links_gleichungstext_re+' ⇌ '+self.links_gleichungstext_li
            self.rechts_gleichungstext=self.rechts_gleichungstext_li+' ⇌ '+self.rechts_gleichungstext_re
            self.messgeraet.pfeilpos_aendern(FIRST)
            self.messgeraet.pfeilzustand_aendern(NORMAL)
            self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('red')
            self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
            self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
            self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('blue')
            self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
            self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
        elif self.linkes_halbzellenpotential_float == self.rechtes_halbzellenpotential_float:
            self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
            self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
            self.messgeraet.pfeilpos_aendern(NONE)
            self.messgeraet.pfeilzustand_aendern(HIDDEN)
            self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('black')
            self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
            self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('black')
            self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
        self.links_gleichungstext_bereinigt=re.sub('1', '', self.links_gleichungstext)
        self.rechts_gleichungstext_bereinigt=re.sub('1', '', self.rechts_gleichungstext)
        #print(self.links_gleichungstext)
        self.f3l2.config(state=NORMAL)
        self.f3e1.config(state=NORMAL)
        self.f3e1.delete(0, END)
        self.f3e1.insert(0, self.links_gleichungstext_bereinigt)
        self.f3l4.config(state=NORMAL)
        self.f3e2.config(state=NORMAL)
        self.f3e2.delete(0, END)
        self.f3e2.insert(0, self.rechts_gleichungstext_bereinigt)
        # Leinwand1 und Leinwand2 updaten
        self.f2canvas1.config(background='white')
        self.f2canvas2.config(background='white')
        self.f2canvas1.update()
        self.f2canvas2.update()

        ########################################################################
        ####                 Funktionen Abhängigkeiten                      ####
        ########################################################################
        
    def konzentration_linke_halbzelle(self, a):
        #print('konzentration_linke_halbzelle', str(a))
        self.konzentration_links=float(a)
        self.konzentration_rechts=float(self.f3scale2.get())
        self.a1=str(a1.get())
        self.a2=str(a2.get())
        if self.a1 != 'X':
            self.linkes_halbzellenpotential_float=float(self.linke_halbzellen[self.a1]['E0'])
            self.elektronenzahl_links=float(self.linke_halbzellen[self.a1]['oxm_haelfte'][2])
            self.E_links_zu_lang=float(self.linkes_halbzellenpotential_float+(0.059/self.elektronenzahl_links)*math.log10(self.konzentration_links))
            self.E_links='%.2f' % (self.E_links_zu_lang,)
            self.f3e3.config(state=NORMAL)
            self.f3e3.delete(0, END)
            self.f3e3.insert(0, self.E_links)
        if self.a2 != 'X':
            self.rechtes_halbzellenpotential_float=float(self.rechte_halbzellen[self.a2]['E0'])
            self.elektronenzahl_rechts=float(self.rechte_halbzellen[self.a2]['oxm_haelfte'][2])
            self.E_rechts_zu_lang=float(self.rechtes_halbzellenpotential_float+(0.059/self.elektronenzahl_rechts)*math.log10(self.konzentration_rechts))
            self.E_rechts='%.2f' % (self.E_rechts_zu_lang,)
            self.f3e4.config(state=NORMAL)
            self.f3e4.delete(0, END)
            self.f3e4.insert(0, self.E_rechts)
        if self.a1 != 'X' and self.a2 != 'X':
            self.text_EMK_zu_lang=abs(float(self.E_links_zu_lang)-float(self.E_rechts_zu_lang))
            self.text_EMK='%.2f' % (self.text_EMK_zu_lang,)
            #print(self.text_EMK)
            self.messgeraet.text_EMK_aendern(self.text_EMK+' V')
        #### Reaktionsgleichung anpassen wie in auswahl_linke_halbzelle
        # Werte für Halbzellengleichung links
        try:
            self.links_koeff_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][0]
            self.links_sf_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][1]
            self.links_koeff_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][2]
            self.links_sf_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][3]
            self.links_koeff_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][4]
            self.links_sf_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][5]
            self.links_koeff_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][0]
            self.links_sf_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][1]
            self.links_koeff_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][2]
            self.links_sf_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][3]
            self.links_koeff_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][4]
            self.links_sf_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][5]
            self.links_koeff_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][6]
            self.links_sf_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][7]
            self.links_reduktionsliste_li=[
                self.links_koeff_redm_li+' '+self.links_sf_redm_li,             #0
                self.links_koeff_ladaus_li+' '+self.links_sf_ladaus_li,         #1
                self.links_koeff_stoffaus_li+' '+self.links_sf_stoffaus_li,     #2
                ]
            self.links_reduktionsliste_re=[
                self.links_koeff_oxm_re+' '+self.links_sf_oxm_re,               #0
                self.links_koeff_el_re+' '+self.links_sf_el_re,                 #1
                self.links_koeff_ladaus_re+' '+self.links_sf_ladaus_re,         #2
                self.links_koeff_stoffaus_re+' '+self.links_sf_stoffaus_re      #3
                ]
            # Listen bereinigen
            laenge_li=len(self.links_reduktionsliste_li)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.links_reduktionsliste_li[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.links_reduktionsliste_li.remove(i)
                        remove = True
                        break
            laenge_re=len(self.links_reduktionsliste_re)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.links_reduktionsliste_re[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.links_reduktionsliste_re.remove(i)
                        remove = True
                        break
            # Halbzellengleichung nur links
            if self.a2 == 'X':
                self.links_gleichungstext_li=''
                for i in range(0, len(self.links_reduktionsliste_li)):
                    if i == 0:
                        self.links_gleichungstext_li=self.links_gleichungstext_li+self.links_reduktionsliste_li[i]
                    elif i > 0 and i < len(self.links_reduktionsliste_li):
                        self.links_gleichungstext_li=self.links_gleichungstext_li+'+'+self.links_reduktionsliste_li[i]
                self.links_gleichungstext_re=''
                for i in range(0, len(self.links_reduktionsliste_re)):
                    if i == 0:
                        self.links_gleichungstext_re=self.links_gleichungstext_re+self.links_reduktionsliste_re[i]
                    elif i > 0 and i < len(self.links_reduktionsliste_re):
                        self.links_gleichungstext_re=self.links_gleichungstext_re+'+'+self.links_reduktionsliste_re[i]
                # Linke und rechte Hälfte kombinieren
                self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
                self.links_gleichungstext_bereinigt=re.sub('1', '', self.links_gleichungstext)
                #print(self.links_gleichungstext_bereinigt)
                self.f3l2.config(state=NORMAL)
                self.f3e1.config(state=NORMAL)
                self.f3e1.delete(0, END)
                self.f3e1.insert(0, self.links_gleichungstext_bereinigt)
            ## Fall 2: Rechte Halbzelle wurde bereits ausgewählt => Halbzellengleichung links und rechts
            if self.a2 != 'X':
                # Werte für Halbzellengleichung links
                self.links_koeff_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][0]
                self.links_sf_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][1]
                self.links_koeff_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][2]
                self.links_sf_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][3]
                self.links_koeff_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][4]
                self.links_sf_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][5]
                self.links_koeff_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][0]
                self.links_sf_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][1]
                self.links_koeff_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][2]
                self.links_sf_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][3]
                self.links_koeff_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][4]
                self.links_sf_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][5]
                self.links_koeff_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][6]
                self.links_sf_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][7]
                self.links_reduktionsliste_li=[
                    self.links_koeff_redm_li+' '+self.links_sf_redm_li,             #0
                    self.links_koeff_ladaus_li+' '+self.links_sf_ladaus_li,         #1
                    self.links_koeff_stoffaus_li+' '+self.links_sf_stoffaus_li,     #2
                    ]
                self.links_reduktionsliste_re=[
                    self.links_koeff_oxm_re+' '+self.links_sf_oxm_re,               #0
                    self.links_koeff_el_re+' '+self.links_sf_el_re,                 #1
                    self.links_koeff_ladaus_re+' '+self.links_sf_ladaus_re,         #2
                    self.links_koeff_stoffaus_re+' '+self.links_sf_stoffaus_re      #3
                    ]
                # Listen bereinigen
                laenge_li=len(self.links_reduktionsliste_li)
                i = 0
                remove = True
                while remove:
                    remove = False
                    for i in self.links_reduktionsliste_li[:]:
                        for j in i[:]:
                            if len(j) < 1:
                                i.remove(j)
                        if len(i) < 2:
                            self.links_reduktionsliste_li.remove(i)
                            remove = True
                            break
                laenge_re=len(self.links_reduktionsliste_re)
                i = 0
                remove = True
                while remove:
                    remove = False
                    for i in self.links_reduktionsliste_re[:]:
                        for j in i[:]:
                            if len(j) < 1:
                                i.remove(j)
                        if len(i) < 2:
                            self.links_reduktionsliste_re.remove(i)
                            remove = True
                            break
                # Halbzellengleichung nur links
                self.links_gleichungstext_li=''
                for i in range(0, len(self.links_reduktionsliste_li)):
                    if i == 0:
                        self.links_gleichungstext_li=self.links_gleichungstext_li+self.links_reduktionsliste_li[i]
                    elif i > 0 and i < len(self.links_reduktionsliste_li):
                        self.links_gleichungstext_li=self.links_gleichungstext_li+'+'+self.links_reduktionsliste_li[i]
                self.links_gleichungstext_re=''
                for i in range(0, len(self.links_reduktionsliste_re)):
                    if i == 0:
                        self.links_gleichungstext_re=self.links_gleichungstext_re+self.links_reduktionsliste_re[i]
                    elif i > 0 and i < len(self.links_reduktionsliste_re):
                        self.links_gleichungstext_re=self.links_gleichungstext_re+'+'+self.links_reduktionsliste_re[i]
                # Werte für Halbzellengleichung rechts
                self.rechts_koeff_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][0]
                self.rechts_sf_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][1]
                self.rechts_koeff_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][2]
                self.rechts_sf_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][3]
                self.rechts_koeff_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][4]
                self.rechts_sf_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][5]
                self.rechts_koeff_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][0]
                self.rechts_sf_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][1]
                self.rechts_koeff_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][2]
                self.rechts_sf_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][3]
                self.rechts_koeff_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][4]
                self.rechts_sf_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][5]
                self.rechts_koeff_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][6]
                self.rechts_sf_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][7]
                self.rechts_reduktionsliste_li=[
                    self.rechts_koeff_redm_li+' '+self.rechts_sf_redm_li,             #0
                    self.rechts_koeff_ladaus_li+' '+self.rechts_sf_ladaus_li,         #1
                    self.rechts_koeff_stoffaus_li+' '+self.rechts_sf_stoffaus_li,     #2
                    ]
                self.rechts_reduktionsliste_re=[
                    self.rechts_koeff_oxm_re+' '+self.rechts_sf_oxm_re,               #0
                    self.rechts_koeff_el_re+' '+self.rechts_sf_el_re,                 #1
                    self.rechts_koeff_ladaus_re+' '+self.rechts_sf_ladaus_re,         #2
                    self.rechts_koeff_stoffaus_re+' '+self.rechts_sf_stoffaus_re      #3
                    ]
                # Listen bereinigen
                laenge_li=len(self.rechts_reduktionsliste_li)
                i = 0
                remove = True
                while remove:
                    remove = False
                    for i in self.rechts_reduktionsliste_li[:]:
                        for j in i[:]:
                            if len(j) < 1:
                                i.remove(j)
                        if len(i) < 2:
                            self.rechts_reduktionsliste_li.remove(i)
                            remove = True
                            break
                laenge_re=len(self.rechts_reduktionsliste_re)
                i = 0
                remove = True
                while remove:
                    remove = False
                    for i in self.rechts_reduktionsliste_re[:]:
                        for j in i[:]:
                            if len(j) < 1:
                                i.remove(j)
                        if len(i) < 2:
                            self.rechts_reduktionsliste_re.remove(i)
                            remove = True
                            break
                # Halbzellengleichung links und rechts
                self.rechts_gleichungstext_li=''
                for i in range(0, len(self.rechts_reduktionsliste_li)):
                    if i == 0:
                        self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+self.rechts_reduktionsliste_li[i]
                    elif i > 0 and i < len(self.rechts_reduktionsliste_li):
                        self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+'+'+self.rechts_reduktionsliste_li[i]
                self.rechts_gleichungstext_re=''
                for i in range(0, len(self.rechts_reduktionsliste_re)):
                    if i == 0:
                        self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+self.rechts_reduktionsliste_re[i]
                    elif i > 0 and i < len(self.rechts_reduktionsliste_re):
                        self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+'+'+self.rechts_reduktionsliste_re[i]
                ########### Zeichenelemente links erzeugen -ANFANG
                # vorhandene links löschen
                for i in self.f2canvas1.find_all():
                    self.f2canvas1.delete(i)
                self.farbe_loesung=self.linke_halbzellen[self.a1]['beschriftung'][3]
                self.farbe_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][2]
                self.beschriftung_loesung=self.linke_halbzellen[self.a1]['beschriftung'][1]
                self.beschriftung_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][0]
                self.versuchsaufbau_linke_halbzelle=Linke_halbzelle(self.f2canvas1,
                                                                    0,
                                                                    0,
                                                                    self.farbe_loesung,
                                                                    self.farbe_elektrode,
                                                                    self.beschriftung_loesung,
                                                                    self.beschriftung_elektrode,
                                                                    NORMAL)
                ########### erzeugen Zeichenelemente links - ENDE
                ########### Zeichenelemente rechts erzeugen -ANFANG
                # vorhandene rechts löschen
                for i in self.f2canvas3.find_all():
                    self.f2canvas3.delete(i)
                self.farbe_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][3]
                self.farbe_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][2]
                self.beschriftung_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][1]
                self.beschriftung_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][0]
                self.versuchsaufbau_rechte_halbzelle=Rechte_halbzelle(self.f2canvas3,
                                                                        0,
                                                                        0,
                                                                        self.farbe_loesung,
                                                                        self.farbe_elektrode,
                                                                        self.beschriftung_loesung,
                                                                        self.beschriftung_elektrode,
                                                                        NORMAL)
                ########### erzeugen Zeichenelemente rechts - ENDE
                # Linke und rechte Hälfte kombinieren 
                # !!! Hier mit E_links/rechts_zu_lang statt linkes/rechtes_halbzellenpotential_float 
                if self.E_links_zu_lang < self.E_rechts_zu_lang:
                    self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
                    self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
                    self.messgeraet.pfeilpos_aendern(LAST)
                    self.messgeraet.pfeilzustand_aendern(NORMAL)
                    self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('blue')
                    self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
                    self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                    self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('red')
                    self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
                    self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                elif self.E_links_zu_lang > self.E_rechts_zu_lang:
                    self.links_gleichungstext=self.links_gleichungstext_re+' ⇌ '+self.links_gleichungstext_li
                    self.rechts_gleichungstext=self.rechts_gleichungstext_li+' ⇌ '+self.rechts_gleichungstext_re
                    self.messgeraet.pfeilpos_aendern(FIRST)
                    self.messgeraet.pfeilzustand_aendern(NORMAL)
                    self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('red')
                    self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
                    self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                    self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('blue')
                    self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
                    self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                elif self.E_links_zu_lang == self.E_rechts_zu_lang:
                    self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
                    self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
                    self.messgeraet.pfeilpos_aendern(NONE)
                    self.messgeraet.pfeilzustand_aendern(HIDDEN)
                    self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('black')
                    self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
                    self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('black')
                    self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
                    self.links_gleichungstext_bereinigt=re.sub('1', '', self.links_gleichungstext)
                    self.rechts_gleichungstext_bereinigt=re.sub('1', '', self.rechts_gleichungstext)
                #print(self.links_gleichungstext_bereinigt)
                self.f3l2.config(state=NORMAL)
                self.f3e1.config(state=NORMAL)
                self.f3e1.delete(0, END)
                self.f3e1.insert(0, self.links_gleichungstext_bereinigt)
                self.f3l4.config(state=NORMAL)
                self.f3e2.config(state=NORMAL)
                self.f3e2.delete(0, END)
                self.f3e2.insert(0, self.rechts_gleichungstext_bereinigt)
        except:
            pass
        # Leinwand1 und Leinwand2 updaten
        self.f2canvas1.config(background='white')
        self.f2canvas2.config(background='white')
        self.f2canvas1.update()
        self.f2canvas2.update()

    def konzentration_rechte_halbzelle(self, a):
        #print('konzentration_rechte_halbzelle', str(a))
        self.konzentration_rechts=float(a)
        self.konzentration_links=float(self.f3scale1.get())
        self.a1=str(a1.get())
        self.a2=str(a2.get())
        if self.a1 != 'X':
            self.linkes_halbzellenpotential_float=float(self.linke_halbzellen[self.a1]['E0'])
            self.elektronenzahl_links=float(self.linke_halbzellen[self.a1]['oxm_haelfte'][2])
            self.E_links_zu_lang=float(self.linkes_halbzellenpotential_float+(0.059/self.elektronenzahl_links)*math.log10(self.konzentration_links))
            self.E_links='%.2f' % (self.E_links_zu_lang,)
            self.f3e3.config(state=NORMAL)
            self.f3e3.delete(0, END)
            self.f3e3.insert(0, self.E_links)
        if self.a2 != 'X':
            self.rechtes_halbzellenpotential_float=float(self.rechte_halbzellen[self.a2]['E0'])
            self.elektronenzahl_rechts=float(self.rechte_halbzellen[self.a2]['oxm_haelfte'][2])
            self.E_rechts_zu_lang=float(self.rechtes_halbzellenpotential_float+(0.059/self.elektronenzahl_rechts)*math.log10(self.konzentration_rechts))
            self.E_rechts='%.2f' % (self.E_rechts_zu_lang,)
            self.f3e4.config(state=NORMAL)
            self.f3e4.delete(0, END)
            self.f3e4.insert(0, self.E_rechts)
        if self.a1 != 'X' and self.a2 != 'X':
            self.text_EMK_zu_lang=abs(float(self.E_links_zu_lang)-float(self.E_rechts_zu_lang))
            self.text_EMK='%.2f' % (self.text_EMK_zu_lang,)
            #print(self.text_EMK)
            self.messgeraet.text_EMK_aendern(self.text_EMK+' V')
        #### Reaktionsgleichung anpassen wie in auswahl_rechte_halbzelle
        try:
            # Werte für Halbzellengleichung links
            self.links_koeff_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][0]
            self.links_sf_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][1]
            self.links_koeff_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][2]
            self.links_sf_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][3]
            self.links_koeff_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][4]
            self.links_sf_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][5]
            self.links_koeff_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][0]
            self.links_sf_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][1]
            self.links_koeff_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][2]
            self.links_sf_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][3]
            self.links_koeff_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][4]
            self.links_sf_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][5]
            self.links_koeff_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][6]
            self.links_sf_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][7]
            self.links_reduktionsliste_li=[
                self.links_koeff_redm_li+' '+self.links_sf_redm_li,             #0
                self.links_koeff_ladaus_li+' '+self.links_sf_ladaus_li,         #1
                self.links_koeff_stoffaus_li+' '+self.links_sf_stoffaus_li,     #2
                ]
            self.links_reduktionsliste_re=[
                self.links_koeff_oxm_re+' '+self.links_sf_oxm_re,               #0
                self.links_koeff_el_re+' '+self.links_sf_el_re,                 #1
                self.links_koeff_ladaus_re+' '+self.links_sf_ladaus_re,         #2
                self.links_koeff_stoffaus_re+' '+self.links_sf_stoffaus_re      #3
                ]
            # Listen bereinigen
            laenge_li=len(self.links_reduktionsliste_li)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.links_reduktionsliste_li[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.links_reduktionsliste_li.remove(i)
                        remove = True
                        break
            laenge_re=len(self.links_reduktionsliste_re)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.links_reduktionsliste_re[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.links_reduktionsliste_re.remove(i)
                        remove = True
                        break
            # Werte für Halbzellengleichung rechts
            self.rechts_koeff_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][0]
            self.rechts_sf_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][1]
            self.rechts_koeff_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][2]
            self.rechts_sf_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][3]
            self.rechts_koeff_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][4]
            self.rechts_sf_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][5]
            self.rechts_koeff_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][0]
            self.rechts_sf_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][1]
            self.rechts_koeff_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][2]
            self.rechts_sf_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][3]
            self.rechts_koeff_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][4]
            self.rechts_sf_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][5]
            self.rechts_koeff_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][6]
            self.rechts_sf_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][7]
            self.rechts_reduktionsliste_li=[
                self.rechts_koeff_redm_li+' '+self.rechts_sf_redm_li,             #0
                self.rechts_koeff_ladaus_li+' '+self.rechts_sf_ladaus_li,         #1
                self.rechts_koeff_stoffaus_li+' '+self.rechts_sf_stoffaus_li,     #2
                ]
            self.rechts_reduktionsliste_re=[
                self.rechts_koeff_oxm_re+' '+self.rechts_sf_oxm_re,               #0
                self.rechts_koeff_el_re+' '+self.rechts_sf_el_re,                 #1
                self.rechts_koeff_ladaus_re+' '+self.rechts_sf_ladaus_re,         #2
                self.rechts_koeff_stoffaus_re+' '+self.rechts_sf_stoffaus_re      #3
                ]
            # Listen bereinigen
            laenge_li=len(self.rechts_reduktionsliste_li)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.rechts_reduktionsliste_li[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.rechts_reduktionsliste_li.remove(i)
                        remove = True
                        break
            laenge_re=len(self.rechts_reduktionsliste_re)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.rechts_reduktionsliste_re[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.rechts_reduktionsliste_re.remove(i)
                        remove = True
                        break
            # Halbzellengleichung links und rechts
            self.rechts_gleichungstext_li=''
            for i in range(0, len(self.rechts_reduktionsliste_li)):
                if i == 0:
                    self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+self.rechts_reduktionsliste_li[i]
                elif i > 0 and i < len(self.rechts_reduktionsliste_li):
                    self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+'+'+self.rechts_reduktionsliste_li[i]
            self.rechts_gleichungstext_re=''
            for i in range(0, len(self.rechts_reduktionsliste_re)):
                if i == 0:
                    self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+self.rechts_reduktionsliste_re[i]
                elif i > 0 and i < len(self.rechts_reduktionsliste_re):
                    self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+'+'+self.rechts_reduktionsliste_re[i]
            ########### Zeichenelemente links erzeugen -ANFANG
            # vorhandene links löschen
            for i in self.f2canvas1.find_all():
                self.f2canvas1.delete(i)
            self.farbe_loesung=self.linke_halbzellen[self.a1]['beschriftung'][3]
            self.farbe_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][2]
            self.beschriftung_loesung=self.linke_halbzellen[self.a1]['beschriftung'][1]
            self.beschriftung_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][0]
            self.versuchsaufbau_linke_halbzelle=Linke_halbzelle(self.f2canvas1,
                                                                0,
                                                                0,
                                                                self.farbe_loesung,
                                                                self.farbe_elektrode,
                                                                self.beschriftung_loesung,
                                                                self.beschriftung_elektrode,
                                                                NORMAL)
            ########### erzeugen Zeichenelemente links - ENDE
            ########### Zeichenelemente rechts erzeugen -ANFANG
            # vorhandene rechts löschen
            for i in self.f2canvas3.find_all():
                self.f2canvas3.delete(i)
            self.farbe_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][3]
            self.farbe_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][2]
            self.beschriftung_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][1]
            self.beschriftung_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][0]
            self.versuchsaufbau_rechte_halbzelle=Rechte_halbzelle(self.f2canvas3,
                                                                    0,
                                                                    0,
                                                                    self.farbe_loesung,
                                                                    self.farbe_elektrode,
                                                                    self.beschriftung_loesung,
                                                                    self.beschriftung_elektrode,
                                                                    NORMAL)
            ########### erzeugen Zeichenelemente rechts - ENDE
            # Linke und rechte Hälfte kombinieren
            # !!! Hier mit E_links/rechts_zu_lang statt linkes/rechtes_halbzellenpotential_float 
            if self.E_links_zu_lang < self.E_rechts_zu_lang:
                self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
                self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
                self.messgeraet.pfeilpos_aendern(LAST)
                self.messgeraet.pfeilzustand_aendern(NORMAL)
                self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('blue')
                self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
                self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('red')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
            elif self.E_links_zu_lang > self.E_rechts_zu_lang:
                self.links_gleichungstext=self.links_gleichungstext_re+' ⇌ '+self.links_gleichungstext_li
                self.rechts_gleichungstext=self.rechts_gleichungstext_li+' ⇌ '+self.rechts_gleichungstext_re
                self.messgeraet.pfeilpos_aendern(FIRST)
                self.messgeraet.pfeilzustand_aendern(NORMAL)
                self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('red')
                self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
                self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('blue')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
            elif self.E_links_zu_lang == self.E_rechts_zu_lang:
                self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
                self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
                self.messgeraet.pfeilpos_aendern(NONE)
                self.messgeraet.pfeilzustand_aendern(HIDDEN)
                self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('black')
                self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
                self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('black')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
            self.links_gleichungstext_bereinigt=re.sub('1', '', self.links_gleichungstext)
            self.rechts_gleichungstext_bereinigt=re.sub('1', '', self.rechts_gleichungstext)
            #print(self.links_gleichungstext_bereinigt)
            self.f3l2.config(state=NORMAL)
            self.f3e1.config(state=NORMAL)
            self.f3e1.delete(0, END)
            self.f3e1.insert(0, self.links_gleichungstext_bereinigt)
            self.f3l4.config(state=NORMAL)
            self.f3e2.config(state=NORMAL)
            self.f3e2.delete(0, END)
            self.f3e2.insert(0, self.rechts_gleichungstext_bereinigt)
        except:
            pass
        # Leinwand1 und Leinwand2 updaten
        self.f2canvas1.config(background='white')
        self.f2canvas2.config(background='white')
        self.f2canvas1.update()
        self.f2canvas2.update()

    def phwert_rechte_halbzelle(self, a):
        #print('phwert_rechte_halbzelle', str(a))
        self.ph_rechts=float(a)
        self.a1=str(a1.get())
        self.a2=str(a2.get())
        if self.a1 != 'X' and self.a2 != 'X':
            self.linkes_halbzellenpotential_float=float(self.linke_halbzellen[self.a1]['E0'])
            self.rechtes_halbzellenpotential_float=float(self.rechte_halbzellen[self.a2]['E0'])
            self.elektronenzahl_rechts=float(self.rechte_halbzellen[self.a2]['oxm_haelfte'][2])
            if self.a2 == '11':
                self.koeff_ladaus=float(self.rechte_halbzellen[self.a2]['oxm_haelfte'][0])
            elif self.a2 == '19':
                self.koeff_ladaus=float(self.rechte_halbzellen[self.a2]['oxm_haelfte'][4])
            self.E_rechts_zu_lang=self.berechne_e_ph(self.rechtes_halbzellenpotential_float,
                                                     self.elektronenzahl_rechts,
                                                     self.koeff_ladaus,
                                                     self.ph_rechts)
            self.E_rechts='%.2f' % (self.E_rechts_zu_lang,)
            self.f3e4.config(state=NORMAL)
            self.f3e4.delete(0, END)
            self.f3e4.insert(0, self.E_rechts)
                
            self.text_EMK_zu_lang=abs(self.linkes_halbzellenpotential_float-float(self.E_rechts_zu_lang))
            self.text_EMK='%.2f' % (self.text_EMK_zu_lang,)
            #print(self.text_EMK)
            self.messgeraet.text_EMK_aendern(self.text_EMK+' V')
        #### Reaktionsgleichung anpassen wie in auswahl_rechte_halbzelle
        try:
            # Werte für Halbzellengleichung links
            self.links_koeff_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][0]
            self.links_sf_redm_li=self.linke_halbzellen[self.a1]['redm_haelfte'][1]
            self.links_koeff_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][2]
            self.links_sf_ladaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][3]
            self.links_koeff_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][4]
            self.links_sf_stoffaus_li=self.linke_halbzellen[self.a1]['redm_haelfte'][5]
            self.links_koeff_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][0]
            self.links_sf_oxm_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][1]
            self.links_koeff_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][2]
            self.links_sf_el_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][3]
            self.links_koeff_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][4]
            self.links_sf_ladaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][5]
            self.links_koeff_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][6]
            self.links_sf_stoffaus_re=self.linke_halbzellen[self.a1]['oxm_haelfte'][7]
            self.links_reduktionsliste_li=[
                self.links_koeff_redm_li+' '+self.links_sf_redm_li,             #0
                self.links_koeff_ladaus_li+' '+self.links_sf_ladaus_li,         #1
                self.links_koeff_stoffaus_li+' '+self.links_sf_stoffaus_li,     #2
                ]
            self.links_reduktionsliste_re=[
                self.links_koeff_oxm_re+' '+self.links_sf_oxm_re,               #0
                self.links_koeff_el_re+' '+self.links_sf_el_re,                 #1
                self.links_koeff_ladaus_re+' '+self.links_sf_ladaus_re,         #2
                self.links_koeff_stoffaus_re+' '+self.links_sf_stoffaus_re      #3
                ]
            # Listen bereinigen
            laenge_li=len(self.links_reduktionsliste_li)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.links_reduktionsliste_li[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.links_reduktionsliste_li.remove(i)
                        remove = True
                        break
            laenge_re=len(self.links_reduktionsliste_re)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.links_reduktionsliste_re[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.links_reduktionsliste_re.remove(i)
                        remove = True
                        break
            # Werte für Halbzellengleichung rechts
            self.rechts_koeff_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][0]
            self.rechts_sf_redm_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][1]
            self.rechts_koeff_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][2]
            self.rechts_sf_ladaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][3]
            self.rechts_koeff_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][4]
            self.rechts_sf_stoffaus_li=self.rechte_halbzellen[self.a2]['redm_haelfte'][5]
            self.rechts_koeff_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][0]
            self.rechts_sf_oxm_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][1]
            self.rechts_koeff_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][2]
            self.rechts_sf_el_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][3]
            self.rechts_koeff_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][4]
            self.rechts_sf_ladaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][5]
            self.rechts_koeff_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][6]
            self.rechts_sf_stoffaus_re=self.rechte_halbzellen[self.a2]['oxm_haelfte'][7]
            self.rechts_reduktionsliste_li=[
                self.rechts_koeff_redm_li+' '+self.rechts_sf_redm_li,             #0
                self.rechts_koeff_ladaus_li+' '+self.rechts_sf_ladaus_li,         #1
                self.rechts_koeff_stoffaus_li+' '+self.rechts_sf_stoffaus_li,     #2
                ]
            self.rechts_reduktionsliste_re=[
                self.rechts_koeff_oxm_re+' '+self.rechts_sf_oxm_re,               #0
                self.rechts_koeff_el_re+' '+self.rechts_sf_el_re,                 #1
                self.rechts_koeff_ladaus_re+' '+self.rechts_sf_ladaus_re,         #2
                self.rechts_koeff_stoffaus_re+' '+self.rechts_sf_stoffaus_re      #3
                ]
            # Listen bereinigen
            laenge_li=len(self.rechts_reduktionsliste_li)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.rechts_reduktionsliste_li[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.rechts_reduktionsliste_li.remove(i)
                        remove = True
                        break
            laenge_re=len(self.rechts_reduktionsliste_re)
            i = 0
            remove = True
            while remove:
                remove = False
                for i in self.rechts_reduktionsliste_re[:]:
                    for j in i[:]:
                        if len(j) < 1:
                            i.remove(j)
                    if len(i) < 2:
                        self.rechts_reduktionsliste_re.remove(i)
                        remove = True
                        break
            # Halbzellengleichung links und rechts
            self.rechts_gleichungstext_li=''
            for i in range(0, len(self.rechts_reduktionsliste_li)):
                if i == 0:
                    self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+self.rechts_reduktionsliste_li[i]
                elif i > 0 and i < len(self.rechts_reduktionsliste_li):
                    self.rechts_gleichungstext_li=self.rechts_gleichungstext_li+'+'+self.rechts_reduktionsliste_li[i]
            self.rechts_gleichungstext_re=''
            for i in range(0, len(self.rechts_reduktionsliste_re)):
                if i == 0:
                    self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+self.rechts_reduktionsliste_re[i]
                elif i > 0 and i < len(self.rechts_reduktionsliste_re):
                    self.rechts_gleichungstext_re=self.rechts_gleichungstext_re+'+'+self.rechts_reduktionsliste_re[i]
            ########### Zeichenelemente links erzeugen -ANFANG
            # vorhandene links löschen
            for i in self.f2canvas1.find_all():
                self.f2canvas1.delete(i)
            self.farbe_loesung=self.linke_halbzellen[self.a1]['beschriftung'][3]
            self.farbe_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][2]
            self.beschriftung_loesung=self.linke_halbzellen[self.a1]['beschriftung'][1]
            self.beschriftung_elektrode=self.linke_halbzellen[self.a1]['beschriftung'][0]
            self.versuchsaufbau_linke_halbzelle=Linke_halbzelle(self.f2canvas1,
                                                                0,
                                                                0,
                                                                self.farbe_loesung,
                                                                self.farbe_elektrode,
                                                                self.beschriftung_loesung,
                                                                self.beschriftung_elektrode,
                                                                NORMAL)
            ########### erzeugen Zeichenelemente links - ENDE
            ########### Zeichenelemente rechts erzeugen -ANFANG
            # vorhandene rechts löschen
            for i in self.f2canvas3.find_all():
                self.f2canvas3.delete(i)
            self.farbe_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][3]
            self.farbe_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][2]
            self.beschriftung_loesung=self.rechte_halbzellen[self.a2]['beschriftung'][1]
            self.beschriftung_elektrode=self.rechte_halbzellen[self.a2]['beschriftung'][0]
            self.versuchsaufbau_rechte_halbzelle=Rechte_halbzelle(self.f2canvas3,
                                                                    0,
                                                                    0,
                                                                    self.farbe_loesung,
                                                                    self.farbe_elektrode,
                                                                    self.beschriftung_loesung,
                                                                    self.beschriftung_elektrode,
                                                                    NORMAL)
            ########### erzeugen Zeichenelemente rechts - ENDE
            # Linke und rechte Hälfte kombinieren
            if self.linkes_halbzellenpotential_float < self.E_rechts_zu_lang:
                self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
                self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
                self.messgeraet.pfeilpos_aendern(LAST)
                self.messgeraet.pfeilzustand_aendern(NORMAL)
                self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('blue')
                self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
                self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('red')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
            elif self.linkes_halbzellenpotential_float > self.E_rechts_zu_lang:
                self.links_gleichungstext=self.links_gleichungstext_re+' ⇌ '+self.links_gleichungstext_li
                self.rechts_gleichungstext=self.rechts_gleichungstext_li+' ⇌ '+self.rechts_gleichungstext_re
                self.messgeraet.pfeilpos_aendern(FIRST)
                self.messgeraet.pfeilzustand_aendern(NORMAL)
                self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('red')
                self.versuchsaufbau_linke_halbzelle.polbeschriftung_aendern('Kathode (Ort der Reduktionsteilreaktion)')
                self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
                self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('blue')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftung_aendern('Anode (Ort der Oxidationsteilreaktion)')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(NORMAL)
            elif self.linkes_halbzellenpotential_float == self.E_rechts_zu_lang:
                self.links_gleichungstext=self.links_gleichungstext_li+' ⇌ '+self.links_gleichungstext_re
                self.rechts_gleichungstext=self.rechts_gleichungstext_re+' ⇌ '+self.rechts_gleichungstext_li
                self.messgeraet.pfeilpos_aendern(NONE)
                self.messgeraet.pfeilzustand_aendern(HIDDEN)
                self.versuchsaufbau_linke_halbzelle.kabelfarbe_aendern('black')
                self.versuchsaufbau_linke_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
                self.versuchsaufbau_rechte_halbzelle.kabelfarbe_aendern('black')
                self.versuchsaufbau_rechte_halbzelle.polbeschriftungs_zustand_aendern(HIDDEN)
            self.links_gleichungstext_bereinigt=re.sub('1', '', self.links_gleichungstext)
            self.rechts_gleichungstext_bereinigt=re.sub('1', '', self.rechts_gleichungstext)
            #print(self.links_gleichungstext_bereinigt)
            self.f3l2.config(state=NORMAL)
            self.f3e1.config(state=NORMAL)
            self.f3e1.delete(0, END)
            self.f3e1.insert(0, self.links_gleichungstext_bereinigt)
            self.f3l4.config(state=NORMAL)
            self.f3e2.config(state=NORMAL)
            self.f3e2.delete(0, END)
            self.f3e2.insert(0, self.rechts_gleichungstext_bereinigt)
        except:
            pass
        # Leinwand1 und Leinwand2 updaten
        self.f2canvas1.config(background='white')
        self.f2canvas2.config(background='white')
        self.f2canvas1.update()
        self.f2canvas2.update()

    def berechne_e_ph(self, E0, n, koeff_oxoniumion, ph):
        E=float(E0+0.059/n*(-koeff_oxoniumion*ph))
        return E

################################################################################
####                     Zeichenobjektklassen                               ####
################################################################################

##### Mittlere Leinwand
class Messgeraet_und_ionenbruecke:
    def __init__(self,
                 canvas,
                 x1,
                 y1,
                 EMK_links,
                 EMK_rechts,
                 ausgangszustand):
        self.canvas=canvas
        self.x1=x1
        self.y1=y1
        self.EMK_links=EMK_links
        self.EMK_rechts=EMK_rechts
        self.ausgangszustand=ausgangszustand
        self.EMK_zu_lang=abs(self.EMK_links-self.EMK_rechts)
        self.EMK='%.2f' % (self.EMK_zu_lang,)
        self.pfeilpos=NONE
        # Voltmeter Schema (ohne Kabel!)
        self.kasten=self.canvas.create_oval(self.x1-46,
                                            self.y1-40,
                                            self.x1+96,
                                            self.y1+60,
                                            fill='white',
                                            width=6,
                                            state=self.ausgangszustand)
        # Textanzeige im Voltmeter
        self.textfeld_EMK=self.canvas.create_text(self.x1,
                                                  self.y1,
                                                  text=self.EMK+' V',
                                                  font=('dejavu', 14),
                                                  anchor=NW,
                                                  justify=LEFT,
                                                  state=self.ausgangszustand)
        # Pfeil Elektronenflussrichtung im Voltmeter
        self.linie_elektronenfluss=self.canvas.create_line(self.x1-5,
                                                           self.y1+30,
                                                           self.x1+55,
                                                           self.y1+30,
                                                           fill='orange',
                                                           arrow=self.pfeilpos,
                                                           arrowshape='8 15 5',
                                                           width=4)
        self.textfeld_elektronenfluss=self.canvas.create_text(self.x1+20,
                                                              self.y1+35,
                                                              text='e⁻',
                                                              font=('dejavu', 12, 'bold'),
                                                              fill='orange',
                                                              anchor=NW,
                                                              justify=LEFT,
                                                              state=self.ausgangszustand)
        # Salzbrücke (zwei Linien)
        self.linie_salzbruecke_oben=self.canvas.create_line(self.x1-50,
                                                            self.y1+90,
                                                            self.x1+100,
                                                            self.y1+90,
                                                            width=4)
        self.linie_salzbruecke_unten=self.canvas.create_line(self.x1-50,
                                                            self.y1+130,
                                                            self.x1+100,
                                                            self.y1+130,
                                                            width=4)

    def pfeilpos_aendern(self, pfeilpos):
        self.pfeilpos=pfeilpos
        self.canvas.itemconfig(self.linie_elektronenfluss, arrow=self.pfeilpos)

    def pfeilzustand_aendern(self, zustand):
        self.zustand=zustand
        self.canvas.itemconfig(self.linie_elektronenfluss, state=self.zustand)
        self.canvas.itemconfig(self.textfeld_elektronenfluss, state=self.zustand)

    def zustand_aendern(self, zustand):
        self.zustand=zustand
        self.canvas.itemconfig(self.textfeld_EMK, state=self.zustand)

    def text_EMK_aendern(self, text_EMK_neu):
        self.text_EMK_neu=text_EMK_neu
        self.canvas.itemconfig(self.textfeld_EMK, text=self.text_EMK_neu)
        self.canvas.update()

##### Linke Leinwand
class Linke_halbzelle:
    def __init__(self,
                 canvas,
                 x1,
                 y1,
                 farbe_loesung,
                 farbe_elektrode,
                 beschriftung_loesung,
                 beschriftung_elektrode,
                 ausgangszustand):
        self.canvas=canvas
        self.x1=x1
        self.y1=y1
        self.farbe_loesung=farbe_loesung
        self.farbe_elektrode=farbe_elektrode
        self.beschriftung_loesung=beschriftung_loesung
        self.beschriftung_elektrode=beschriftung_elektrode
        self.ausgangszustand=ausgangszustand
        # Lösung: Rechteck mit Füllfarbe und drei obere Begrenzungslinien
        self.loesung=self.canvas.create_rectangle(self.x1+50,
                                                  self.y1+250,
                                                  self.x1+350,
                                                  self.y1+550,
                                                  fill=self.farbe_loesung,
                                                  width=0.0,
                                                  state=self.ausgangszustand)
        self.loesung_linie_links=self.canvas.create_line(self.x1+50,
                                                         self.y1+250,
                                                         self.x1+100,
                                                         self.y1+250)
        self.loesung_linie_mitte=self.canvas.create_line(self.x1+150,
                                                         self.y1+250,
                                                         self.x1+260,
                                                         self.y1+250)
        self.loesung_linie_rechts=self.canvas.create_line(self.x1+300,
                                                          self.y1+250,
                                                          self.x1+350,
                                                          self.y1+250)
        # Elektrode: Rechteck mit Füllfarbe 
        self.elektrode=self.canvas.create_rectangle(self.x1+100,
                                                    self.y1+150,
                                                    self.x1+150,
                                                    self.y1+450,
                                                    fill=self.farbe_elektrode,
                                                    #width=6,
                                                    state=self.ausgangszustand)
        # Gefäßbegrenzungen: Linien
        self.linie_gefaess_links=self.canvas.create_line(self.x1+50,
                                                         self.y1+220,
                                                         self.x1+50,
                                                         self.y1+550,
                                                         width=4)
        self.linie_gefaess_unten=self.canvas.create_line(self.x1+50,
                                                         self.y1+550,
                                                         self.x1+350,
                                                         self.y1+550,
                                                         width=4)
        self.linie_gefaess_rechts=self.canvas.create_line(self.x1+350,
                                                          self.y1+220,
                                                          self.x1+350,
                                                          self.y1+550,
                                                          width=4)
        # Salzbrücke: Linien
        self.linie_salzbruecke_links_senkrecht=self.canvas.create_line(self.x1+260,
                                                                       self.y1+140,
                                                                       self.x1+260,
                                                                       self.y1+300,
                                                                       width=4)
        self.linie_salzbruecke_oben_waagrecht=self.canvas.create_line(self.x1+260,
                                                                      self.y1+140,
                                                                      self.x1+400,
                                                                      self.y1+140,
                                                                      width=4)
        self.linie_salzbruecke_rechts_senkrecht=self.canvas.create_line(self.x1+300,
                                                                        self.y1+180,
                                                                        self.x1+300,
                                                                        self.y1+300,
                                                                        width=4)
        self.linie_salzbruecke_unten_waagrecht=self.canvas.create_line(self.x1+300,
                                                                       self.y1+180,
                                                                       self.x1+400,
                                                                       self.y1+180,
                                                                       width=4)
        # Kabelverbindungen
        self.linie_kabel_senkrecht=self.canvas.create_line(self.x1+125,
                                                           self.y1+60,
                                                           self.x1+125,
                                                           self.y1+150,
                                                           width=6)
        self.linie_kabel_waagrecht=self.canvas.create_line(self.x1+125,
                                                           self.y1+60,
                                                           self.x1+400,
                                                           self.y1+60,
                                                           width=6)
        # Beschriftung Anode/Kathode
        ## Falls Ox.-Teilreaktion: Anode, hier also MINUSPOL (nur bei Elektrolyse Pluspol!)
        self.textfeld_pol=self.canvas.create_text(self.x1+100,
                                                  self.y1+20,
                                                  text='Anode',
                                                  font=('dejavu', 10),
                                                  anchor=NW,
                                                  justify=LEFT,
                                                  state=self.ausgangszustand)
        # Beschriftung Elektrode: Linie und Text
        self.linie_elektrode_waagrecht=self.canvas.create_line(self.x1+125,
                                                               self.y1+355,
                                                               self.x1+170,
                                                               self.y1+355)
        self.textfeld_elektrode=self.canvas.create_text(self.x1+180,
                                                        self.y1+350,
                                                        text=self.beschriftung_elektrode,
                                                        font=('dejavu', 10),
                                                        anchor=NW,
                                                        justify=LEFT,
                                                        state=self.ausgangszustand)
        # Beschriftung Lösung
        self.textfeld_loesung=self.canvas.create_text(self.x1+180,
                                                      self.y1+400,
                                                      text=self.beschriftung_loesung,
                                                      font=('dejavu', 10),
                                                      anchor=NW,
                                                      justify=LEFT,
                                                      state=self.ausgangszustand)

    def kabelfarbe_aendern(self, kabelfarbe):
        self.kabelfarbe=kabelfarbe
        self.canvas.itemconfig(self.linie_kabel_senkrecht, fill=self.kabelfarbe)
        self.canvas.itemconfig(self.linie_kabel_waagrecht, fill=self.kabelfarbe)
        self.canvas.itemconfig(self.textfeld_pol, fill=self.kabelfarbe)

    def polbeschriftung_aendern(self, polbeschriftung):
        self.polbeschriftung=polbeschriftung
        self.canvas.itemconfig(self.textfeld_pol, text=self.polbeschriftung)

    def polbeschriftungs_zustand_aendern(self, zustand_neu):
        self.zustand_neu=zustand_neu
        self.canvas.itemconfig(self.textfeld_pol, state=self.zustand_neu)

##### Rechte Leinwand
class Rechte_halbzelle:
    def __init__(self,
                 canvas,
                 x1,
                 y1,
                 farbe_loesung,
                 farbe_elektrode,
                 beschriftung_loesung,
                 beschriftung_elektrode,
                 ausgangszustand):
        self.canvas=canvas
        self.x1=x1
        self.y1=y1
        self.farbe_loesung=farbe_loesung
        self.farbe_elektrode=farbe_elektrode
        self.beschriftung_loesung=beschriftung_loesung
        self.beschriftung_elektrode=beschriftung_elektrode
        self.ausgangszustand=ausgangszustand
        # Lösung: Rechteck mit Füllfarbe und drei obere Begrenzungslinien
        self.loesung=self.canvas.create_rectangle(self.x1+50,
                                                  self.y1+250,
                                                  self.x1+350,
                                                  self.y1+550,
                                                  fill=self.farbe_loesung,
                                                  width=0.0,
                                                  state=self.ausgangszustand)
        self.loesung_linie_links=self.canvas.create_line(self.x1+50,
                                                         self.y1+250,
                                                         self.x1+100,
                                                         self.y1+250)
        self.loesung_linie_mitte=self.canvas.create_line(self.x1+140,
                                                         self.y1+250,
                                                         self.x1+260,
                                                         self.y1+250)
        self.loesung_linie_rechts=self.canvas.create_line(self.x1+300,
                                                          self.y1+250,
                                                          self.x1+350,
                                                          self.y1+250)
        # Elektrode: Rechteck mit Füllfarbe 
        self.elektrode=self.canvas.create_rectangle(self.x1+250,
                                                    self.y1+150,
                                                    self.x1+300,
                                                    self.y1+450,
                                                    fill=self.farbe_elektrode,
                                                    #width=6,
                                                    state=self.ausgangszustand)
        # Gefäßbegrenzungen: Linien
        self.linie_gefaess_links=self.canvas.create_line(self.x1+50,
                                                         self.y1+220,
                                                         self.x1+50,
                                                         self.y1+550,
                                                         width=4)
        self.linie_gefaess_unten=self.canvas.create_line(self.x1+50,
                                                         self.y1+550,
                                                         self.x1+350,
                                                         self.y1+550,
                                                         width=4)
        self.linie_gefaess_rechts=self.canvas.create_line(self.x1+350,
                                                          self.y1+220,
                                                          self.x1+350,
                                                          self.y1+550,
                                                          width=4)
        # Salzbrücke: Linien
        self.linie_salzbruecke_links_senkrecht=self.canvas.create_line(self.x1+140,
                                                                       self.y1+140,
                                                                       self.x1+140,
                                                                       self.y1+300,
                                                                       width=4)
        self.linie_salzbruecke_oben_waagrecht=self.canvas.create_line(self.x1+0,
                                                                      self.y1+140,
                                                                      self.x1+140,
                                                                      self.y1+140,
                                                                      width=4)
        self.linie_salzbruecke_rechts_senkrecht=self.canvas.create_line(self.x1+100,
                                                                        self.y1+180,
                                                                        self.x1+100,
                                                                        self.y1+300,
                                                                        width=4)
        self.linie_salzbruecke_unten_waagrecht=self.canvas.create_line(self.x1+0,
                                                                       self.y1+180,
                                                                       self.x1+100,
                                                                       self.y1+180,
                                                                       width=4)
        # Kabelverbindungen
        self.linie_kabel_senkrecht=self.canvas.create_line(self.x1+275,
                                                           self.y1+60,
                                                           self.x1+275,
                                                           self.y1+150,
                                                           width=6)
        self.linie_kabel_waagrecht=self.canvas.create_line(self.x1+0,
                                                           self.y1+60,
                                                           self.x1+275,
                                                           self.y1+60,
                                                           width=6)
        # Beschriftung Anode/Kathode
        ## Falls Red.-Teilreaktion: Kathode, hier also PLUSPOL (nur bei Elektrolyse Minuspol!)
        self.textfeld_pol=self.canvas.create_text(self.x1+300,
                                                  self.y1+20,
                                                  text='Anode',
                                                  font=('dejavu', 10),
                                                  anchor=NE,
                                                  justify=RIGHT,
                                                  state=self.ausgangszustand)
        # Beschriftung Elektrode: Linie und Text
        self.linie_elektrode_waagrecht=self.canvas.create_line(self.x1+230,
                                                               self.y1+355,
                                                               self.x1+275,
                                                               self.y1+355)
        self.textfeld_elektrode=self.canvas.create_text(self.x1+220,
                                                        self.y1+350,
                                                        text=self.beschriftung_elektrode,
                                                        font=('dejavu', 10),
                                                        anchor=NE,
                                                        justify=RIGHT,
                                                        state=self.ausgangszustand)
        # Beschriftung Lösung
        self.textfeld_loesung=self.canvas.create_text(self.x1+220,
                                                      self.y1+400,
                                                      text=self.beschriftung_loesung,
                                                      font=('dejavu', 10),
                                                      anchor=NE,
                                                      justify=RIGHT,
                                                      state=self.ausgangszustand)

    def kabelfarbe_aendern(self, kabelfarbe):
        self.kabelfarbe=kabelfarbe
        self.canvas.itemconfig(self.linie_kabel_senkrecht, fill=self.kabelfarbe)
        self.canvas.itemconfig(self.linie_kabel_waagrecht, fill=self.kabelfarbe)
        self.canvas.itemconfig(self.textfeld_pol, fill=self.kabelfarbe)

    def polbeschriftung_aendern(self, polbeschriftung):
        self.polbeschriftung=polbeschriftung
        self.canvas.itemconfig(self.textfeld_pol, text=self.polbeschriftung)

    def polbeschriftungs_zustand_aendern(self, zustand_neu):
        self.zustand_neu=zustand_neu
        self.canvas.itemconfig(self.textfeld_pol, state=self.zustand_neu)

################################################################################
####                     Hauptschleife                                      ####
################################################################################

root = Tk()
root.title('Elektrochemer')
root.minsize(640, 520)
root.option_add('*Entry.Font', 'dejavu 10')
root.option_add('*Menu.Font', 'dejavu 10')
app = Fenster(root)
root.mainloop()
