#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from tkinter import *
import os
import string
import webbrowser

textfeld_schriftart='arial'
textfeld_schriftgroesse='11'
textfeld_schrift=textfeld_schriftart+' '+textfeld_schriftgroesse

class Fenster:
    def __init__(self, master):
        frame=Frame(master, padx=2, pady=2)
        self.frame_cont=Frame(frame, padx=3, pady=0, bd=4)
        self.frame0=Frame(self.frame_cont, padx=0, pady=0, bd=1.5, bg='#FFFF66660000')
        self.frame1=Frame(self.frame_cont, padx=0, pady=0, bd=1.5, bg='darkgrey')
        self.frame2=Frame(frame, bd=8, padx=2, pady=2)
        self.frame3=Frame(frame)
        for f, row, column, columnspan, sticky in (
                    (frame,       0, 0, 1, E),
                    (self.frame_cont, 1, 0, 1, E),
                    (self.frame0, 1, 0, 1, N+E),(self.frame1, 1, 1, 1, N+W),
                    (self.frame2, 2, 0, 2, E),
                    (self.frame3, 3, 0, 2, E)):
            f.grid(row=row, column=column, columnspan=columnspan)
        self.disacchararide={
            'r1z1':('Maltose (Malzzucker)', 
                    'Ja',
                    'Abbauprodukt der Stärke, kommt z.B. in Gerstenkeimen und in Kartoffelkeimen vor.\nMaltose bildet sich u. a. beim Bierbrauen  durch Einwirkung von Amylasen auf Stärke.'),
            'r1z3':('Trehalose', 
                    'Nein',
                    'Reserverstoff in Pflanzen, kann durch das Enzym Trehalase zu D-Glucose abgebaut werden.\nWirkt als natürliches Frostschutzmittel in Bärtierchen.'),
            'r1z4':('Isomaltose™', 
                    'Ja',
                    'Bildet die Verzweigungsstellen in Stärke.'),
            'r1z5':('Isomaltulose (Palatinose)', 
                    'Nein',
                    'Erhöht den Blutzuckerspiegel langsamer als Saccharose und kann von Kariesbakterien nicht zur Säureproduktion verwendet werden.'),
            'r2z2':('Cellobiose', 
                    'Ja',
                    'Grundbaustein der Cellulose, wird von Pflanzenfressern durch enzymatische Spaltung mit Hilfe von Einzellern aus Cellulose gewonnen. '),
            'r3z3':('Saccharose (Haushaltszucker, Kristallzucker)', 
                    'Nein',
                    'Enthalten in Zuckerrübe, Zuckerrohr und Zuckerahorn, wird häufig als Süßungsmittel verwendet.'),
            'r4z2':('Lactose (Milchzucker)', 
                    'Ja',
                    'Enthalten in Milchprodukten. Die Spaltung während der Verdauung benötigt das Enzym Lactase.'
                    )
        }
        # Rahmen 0: Auswahl der beteiligten Monosaccharid-Reste
        self.f1l1=Label(self.frame0, text='Monosaccharid-Rest')
        global rest
        rest=StringVar()
        rest.set('X')
        self.rr1=Radiobutton(self.frame0, 
                             text='1-α-D-Glucopyranosyl-',
                             variable=rest, 
                             value='r1',
                             indicatoron=0, 
                             command=self.rest_bestimmen,
                             anchor=NE,
                             justify=RIGHT)
        self.rr2=Radiobutton(self.frame0, 
                             text='1-β-D-Glucopyranosyl-',
                             variable=rest, 
                             value='r2',
                             indicatoron=0, 
                             command=self.rest_bestimmen,
                             anchor=NE,
                             justify=RIGHT)
        self.rr3=Radiobutton(self.frame0, 
                             text='2-β-D-Fructofuranosyl-',
                             variable=rest, 
                             value='r3',
                             indicatoron=0, 
                             command=self.rest_bestimmen,
                             anchor=NE,
                             justify=RIGHT)
        self.rr4=Radiobutton(self.frame0, 
                             text='1-β-D-Galactopyranosyl-',
                             variable=rest, 
                             value='r4',
                             indicatoron=0, 
                             command=self.rest_bestimmen,
                             anchor=NE,
                             justify=RIGHT)
        self.f0l0=Label(self.frame0, text='')
        # Rahmen 1: Auswahl der beteiligten Monosaccharide
        self.f1l2=Label(self.frame1, text='Monosaccharid')
        global zucker
        zucker=StringVar()
        zucker.set('X')
        self.zr1=Radiobutton(self.frame1, 
                              text='4-α-D-Glucopyranose',
                              variable=zucker, 
                              value='z1',
                              indicatoron=0, 
                              command=self.zucker_bestimmen,
                              anchor=NW,
                              justify=LEFT)
        self.zr2=Radiobutton(self.frame1, 
                              text='4-β-D-Glucopyranose',
                              variable=zucker, 
                              value='z2',
                              indicatoron=0, 
                              command=self.zucker_bestimmen,
                              anchor=NW,
                              justify=LEFT)
        self.zr3=Radiobutton(self.frame1, 
                              text='1-α-D-Glucopyranosid',
                              variable=zucker, 
                              value='z3',
                              indicatoron=0, 
                              command=self.zucker_bestimmen,
                              anchor=NW,
                              justify=LEFT)
        self.zr4=Radiobutton(self.frame1, 
                              text='6-α-D-Glucopyranose',
                              variable=zucker, 
                              value='z4',
                              indicatoron=0, 
                              command=self.zucker_bestimmen,
                              anchor=NW,
                              justify=LEFT)
        self.zr5=Radiobutton(self.frame1, 
                              text='6-D-Fructofuranose',
                              variable=zucker, 
                              value='z5',
                              indicatoron=0, 
                              command=self.zucker_bestimmen,
                              anchor=NW,
                              justify=LEFT)
        for i, state in ((self.zr1, DISABLED), 
                         (self.zr2, DISABLED), 
                         (self.zr3, DISABLED), 
                         (self.zr4, DISABLED), 
                         (self.zr5, DISABLED)):
            i.config(state=state)

        ## Rahmen 2: Zeichenfläche zur Bildanzeige
        self.f2l1=Label(self.frame2, text='Name:', anchor=NE)
        self.f2text1=Text(self.frame2, width='60', height=1, bg='white', wrap=WORD)
        icon_help = PhotoImage(file='daten/img/help.gif')
        self.f2b1=Button(self.frame2,
                         command=self.info_seite_aufrufen,
                         image=icon_help,
                         compound=LEFT,
                         text='',
                         state=DISABLED,
                         anchor=E)
        self.f2b1.icon_help=icon_help
        self.f2l2=Label(self.frame2, text='Struktur:', anchor=NE)
        self.f2canvas1=Canvas(self.frame2,
                              width=640, 
                              height=324, 
                              bg='white')
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f2canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        self.f2l3=Label(self.frame2, text='Reduzierend?', anchor=NE)
        self.f2text2=Text(self.frame2, width='10', height=1, bg='white', wrap=WORD)
        self.f2l4=Label(self.frame2, text='Bedeutung:', anchor=NE)
        self.f2text3=Text(self.frame2, width='80', height='3', bg='white', wrap=WORD)

        ## Rahmen 3: Navigation und Steuerung
        icon_reset = PhotoImage(file='daten/img/view-refresh.gif')
        self.f3b1=Button(self.frame3, 
                         text='Zurücksetzen', 
                         command=self.zurueck_setzen,
                         image=icon_reset,
                         compound=LEFT)
        self.f3b1.icon_reset=icon_reset
        icon_exit = PhotoImage(file='daten/img/dialog-close.gif')
        self.f3b2=Button(self.frame3, 
                         text='Beenden', 
                         command=root.destroy,
                         image=icon_exit,
                         compound=LEFT)
        self.f3b2.icon_exit=icon_exit

        ## Fensterelmente setzen und anzeigen
        for i, row, column, columnspan, sticky in (
                # Rahmen 1
                (self.f1l1, 0, 0, 1, E+W),  (self.f1l2, 0, 1, 1, E+W),
                (self.rr1,  1, 0, 1, E+W),  (self.zr1,  1, 1, 1, E+W),
                (self.rr2,  2, 0, 1, E+W),  (self.zr2,  2, 1, 1, E+W),
                (self.rr3,  3, 0, 1, E+W),  (self.zr3,  3, 1, 1, E+W),
                (self.rr4,  4, 0, 1, E+W),  (self.zr4,  4, 1, 1, E+W),
                (self.f0l0, 5, 0, 1, E+W),   (self.zr5,  5, 1, 1, E+W),
                # Rahmen 2
                (self.f2l1, 0, 0, 1, E),  (self.f2text1,   0, 1, 1, E+W), (self.f2b1,   0, 2, 1, W),
                (self.f2l2, 1, 0, 1, E),  (self.f2canvas1, 1, 1, 2, W),
                (self.f2l3, 2, 0, 1, E),  (self.f2text2,   2, 1, 2, W),
                (self.f2l4, 3, 0, 1, E),  (self.f2text3,   3, 1, 2, W),
                # Rahmen 3
                (self.f3b1, 0, 0, 1, E+W),  (self.f3b2,    0, 1, 1, E+W)
                ):
            i.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        #### Funktionen ########################################################

    def zurueck_setzen(self):
        #print('zurueck_setzen')
        rest.set('X')
        zucker.set('X')
        for i, state in ((self.rr1, NORMAL), (self.zr1, DISABLED), 
                         (self.rr2, NORMAL), (self.zr2, DISABLED), 
                         (self.rr3, NORMAL), (self.zr3, DISABLED), 
                         (self.rr4, NORMAL), (self.zr4, DISABLED), 
                                             (self.zr5, DISABLED)):
            i.config(state=state)
        for i in (self.f2text1, self.f2text2, self.f2text3):
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        self.f2b1.config(state=DISABLED)
        # Alle Bilder löschen
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        # Startbild wieder herstellen
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f2canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        # Leinwand updaten
        self.f2canvas1.config(background='white')
        self.f2canvas1.update()

    def rest_bestimmen(self):
        self.rest=str(rest.get())
        zucker.set('X')
        #print('rest_bestimmen')
        if self.rest == 'r1':
            for i, state in ((self.zr1, NORMAL),    # Maltose
                             (self.zr2, DISABLED), 
                             (self.zr3, NORMAL),    # Trehalose
                             (self.zr4, NORMAL),    # Isomaltose
                             (self.zr5, NORMAL)     # Isomaltulose
                             ): 
                i.config(state=state)
        elif self.rest == 'r2':
            for i, state in ((self.zr1, DISABLED), 
                             (self.zr2, NORMAL),    # Cellobiose
                             (self.zr3, DISABLED), 
                             (self.zr4, DISABLED), 
                             (self.zr5, DISABLED)):
                i.config(state=state)
        elif self.rest == 'r3':
            for i, state in ((self.zr1, DISABLED), 
                             (self.zr2, DISABLED), 
                             (self.zr3, NORMAL),    # Saccharose
                             (self.zr4, DISABLED), 
                             (self.zr5, DISABLED)):
                i.config(state=state)
        elif self.rest == 'r4':
            for i, state in ((self.zr1, DISABLED), 
                             (self.zr2, NORMAL),    # Lactose
                             (self.zr3, DISABLED), 
                             (self.zr4, DISABLED), 
                             (self.zr5, DISABLED)):
                i.config(state=state)
        for i in (self.f2text1, self.f2text2, self.f2text3):
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.config(state=DISABLED)
        self.f2b1.config(state=DISABLED)
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        self.name=self.rest
        self.bild1=PhotoImage(file='daten/img'+os.sep+self.name+'.gif')
        self.f2canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        # Leinwand updaten
        self.f2canvas1.config(background='white')
        self.f2canvas1.update()

    def zucker_bestimmen(self):
        self.rest=str(rest.get())
        self.zucker=str(zucker.get())
        self.schluessel=self.rest+self.zucker
        self.name=self.disacchararide[self.schluessel][0]
        self.reduzeig=self.disacchararide[self.schluessel][1]
        self.bedeutung=self.disacchararide[self.schluessel][2]
        #print('zucker_bestimmen', self.schluessel, self.name)
        for i, text in ((self.f2text1,     self.name),
                        (self.f2text2,     self.reduzeig),
                        (self.f2text3,     self.bedeutung)):
            i.config(state=NORMAL)
            i.delete(0.0, END)
            i.insert(0.0, text)
            i.config(state=DISABLED)
        self.f2b1.config(state=NORMAL)
        # Vorheriges Bild löschen
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        # Neues Bild anzeigen
        self.name_gross=str(self.disacchararide[self.schluessel][0])
        #print(self.name_gross)
        if self.name_gross.lower() == 'isomaltulose (palatinose)':
            self.name_fuer_bildpfad='isum'
        else:
            self.name_fuer_bildpfad=self.name_gross.lower()[:4]
        #print(self.name_fuer_bildpfad)
        self.bild1=PhotoImage(file='daten/img'+os.sep+self.name_fuer_bildpfad+'.gif')
        self.f2canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        # Leinwand updaten
        self.f2canvas1.config(background='white')
        self.f2canvas1.update()

    def info_seite_aufrufen(self):
        self.rest=str(rest.get())
        self.zucker=str(zucker.get())
        self.schluessel=self.rest+self.zucker
        self.name_gross=str(self.disacchararide[self.schluessel][0])
        #print(self.name_gross)
        if self.name_gross.lower() == 'isomaltulose (palatinose)':
            self.name='isum'
        else:
            self.name=self.name_gross.lower()[:4]
        #print(self.name)
        self.info_oeffnen(self.name)

    def info_oeffnen(self, seitenname):
        self.seitenname=seitenname
        self.seiten_url='http://chemie-lernprogramme.de/daten/help/disaccharider/html/index.html'
        webbrowser.open(self.seiten_url)

################################################################################
root = Tk()
root.title('Disaccharider')
root.option_add('*Text.Font', textfeld_schrift)
app = Fenster(root)
root.mainloop()
