#!/usr/bin/env python3
# -*- encoding: utf-8 -*-
## Zeichensatz fuer Umlaute alternativ mit:
## encoding: utf-8
## und in den Daten z.B. u'\xe4' = ä

# Daten daten.py fuer den acidbaser.pyw
# Saeure-Base-Reaktionsgleichungen-Generator

## Autor: Joachim Jakob
##        Kronberg-Gymnasiuim Aschaffenburg
## Lizenz: GNU GENERAL PUBLIC LICENSE (GPL)
## einzusehen unter:
## http://www.gnu.org/licenses/gpl.html

import codecs


## Datensammlung zu den Basen
## in der Form:
## Dictionary mit dem Teilchennamen des Ausgangsstoffs als Schluessel,
## Werte in einer Liste mit der Reihenfolge:
## Summenformel des Teilchens, pKB-Wert, grobe Staerke,
## Teilchenname der korrespondierenden Saeure

B1={'Chloridion':[u'Cl\u207B',
                  '15.74',
                  'sehr schwach',
                  'Chlorwasserstoff'],
    'Hydrogensulfation':[u'HSO\u2084\u207B',
                         '15.74',
                         'sehr schwach',
                        u'Schwefels\xe4ure'],
    'Wasser':[u'H\u2082O',
              '15.74',
              'schwach',
              'Oxoniumion'],
    'Nitration':[u'NO\u2083\u207B',
                 '15.32',
                 'schwach',
                u'Salpeters\xe4ure'],
    'Sulfation':[u'SO\u2084\u00B2\u207B',
                 '12.10',
                 'schwach',
                 'Hydrogensulfation'],
    'Dihydrogenphosphation':[u'H\u2082PO\u2084\u207B',
                            '11.87',
                            'schwach',
                           u'Phosphors\xe4ure'],
    'Acetation':[u'CH\u2083COO\u207B',
                 '9.25',
                 'mittelstark',
                 u'Essigs\xe4ure'],
    'Hydrogencarbonation':[u'HCO\u2083\u207B',
                           '7.48',
                           'mittelstark',
                          u'Kohlens\xe4ure'],
    'Hydrogenphosphation':[u'HPO\u2084\u00B2\u207B',
                           '6.80',
                           'mittelstark',
                           'Dihydrogenphosphation'],
    'Ammoniak':[u'NH\u2083',
                '4.75',
                'mittelstark',
                'Ammoniumion'],
    'Carbonation':[u'CO\u2083\u00B2\u207B',
                   '3.60',
                   'stark',
                   'Hydrogencarbonation'],
    'Phosphation':[u'PO\u2084³\u207B',
                   '1.64',
                   'stark',
                   'Hydrogenphosphation'],
    'Hydroxidion':[u'OH\u207B',
                   '-1.74',
                   'stark',
                   'Wasser'],
    'Amidion':[u'NH\u2082\u207B',
               '-1.74',
               'sehr stark',
               'Ammoniak'],
    'Oxidion':[u'O\u00B2\u207B',
               '-1.74',
               'sehr stark',
               'Hydroxidion']}

## Datensammlung zu den Saeuren
## in der Form:
## Dictionary mit dem Teilchennamen des Ausgangsstoffs als Schluessel,
## Werte in einer Liste mit der Reihenfolge:
## Summenformel des Teilchens, pKS-Wert, grobe Staerke,
## Teilchenname der korrespondierenden Base

S2={'Chlorwasserstoff':['HCl',
                        '-1.74',
                        'sehr stark',
                        'Chloridion'],
    u'Schwefels\xe4ure':[u'H\u2082SO\u2084',
                         '-1.74',
                         'sehr stark',
                         'Hydrogensulfation'],
    'Oxoniumion':[u'H\u2083O\u207A',
                  '-1.74',
                  'stark',
                  'Wasser'],
    u'Salpeters\xe4ure':[u'HNO\u2083',
                         '-1.32',
                         'stark',
                         'Nitration'],
    'Hydrogensulfation':[u'HSO\u2084\u207B',
                         '1.92',
                         'stark',
                         'Sulfation'],
    u'Phosphors\xe4ure':[u'H\u2083PO\u2084',
                         '2.13',
                         'stark',
                         'Dihydrogenphosphation'],
    u'Essigs\xe4ure':[u'CH\u2083COOH',
                      '4.75',
                      'mittelstark',
                      'Acetation'],
    u'Kohlens\xe4ure':[u'H\u2082CO\u2083',
                       '6.52',
                       'mittelstark',
                       'Hydrogencarbonation'],
    'Dihydrogenphosphation':[u'H\u2082PO\u2084\u207B',
                             '7.20',
                             'mittelstark',
                             'Hydrogenphosphation'],
    'Ammoniumion':[u'NH\u2084\u207A',
                  '9.25',
                  'mittelstark',
                  'Ammoniak'],
    'Hydrogencarbonation':[u'HCO\u2083\u207B',
                           '10.40',
                           'schwach',
                           'Carbonation'],
    'Hydrogenphosphation':[u'HPO\u2084\u00B2\u207B',
                           '12.36',
                           'schwach',
                           'Phosphation'],
    'Wasser':[u'H\u2082O',
              '15.74',
              'schwach',
              'Hydroxidion'],
    'Ammoniak':[u'NH\u2083',
                '15.74',
                'sehr schwach',
                'Amidion'],
    'Hydroxidion':[u'OH\u207B',
                   '15.74',
                   'sehr schwach',
                   'Oxidion']}
