#!/usr/bin/env python3
# -*- coding: utf-8 -*-
## Zeichensatz fuer Umlaute alternativ mit:
## encoding: utf-8
## und in den Daten z.B. u'\xe4' = ä

# acidbaser.pyw
# Saeure-Base-Reaktionsgleichungen-Generator

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import codecs

## Import des TK-GUI-Moduls:
from tkinter import *
from tkinter import font

## Datensammlung zu den Basen
## in der Form:
## Dictionary mit dem Teilchennamen des Ausgangsstoffs als Schluessel,
## Werte in einer Liste mit der Reihenfolge:
## Summenformel des Teilchens, pKB-Wert, grobe Staerke,
## Teilchenname der korrespondierenden Saeure
import sys
sys.path.insert(0, 'daten')

from daten import B1


## Datensammlung zu den Saeuren
## in der Form:
## Dictionary mit dem Teilchennamen des Ausgangsstoffs als Schluessel,
## Werte in einer Liste mit der Reihenfolge:
## Summenformel des Teilchens, pKS-Wert, grobe Staerke,
## Teilchenname der korrespondierenden Base

from daten import S2


## GUI

class Fenster:

    def __init__(self, master):

        frame = Frame(master)
        frame.pack()

        ## Schriften festlegen
        helv16 = font.Font (family='Helvetica', size=12, weight='bold')
        helv14 = font.Font (family='Helvetica', size=11)
        courier14 = font.Font (family='courier new', size=12, weight='bold')

        ## Ausgangsvariablen-Deklaration c fuer Kontrollvariablen z.B. in Labels
        global cFB1
        cFB1=StringVar()
        cFB1.set('B')
        global cFS2
        cFS2=StringVar()
        cFS2.set('HA')
        global cFS1
        cFS1=StringVar()
        cFS1.set('BH+')
        global cFB2
        cFB2=StringVar()
        cFB2.set('A-')

        global cNS1
        cNS1=StringVar()
        cNS1.set('-')
        global cNB2
        cNB2=StringVar()
        cNB2.set('-')

        global cTB1
        cTB1=StringVar()
        cTB1.set('-')
        global cTS2
        cTS2=StringVar()
        cTS2.set('-')
        global cTS1
        cTS1=StringVar()
        cTS1.set('-')
        global cTB2
        cTB2=StringVar()
        cTB2.set('-')

        global cpKEd
        cpKEd=StringVar()
        cpKEd.set(u'Ausgangsstoffe noch nicht gew\xe4hlt')
        global cpKProd
        cpKProd=StringVar()
        cpKProd.set('Endstoffe noch nicht ermittelt')

        ## Abfrage der Ausgangsstoffe
        self.l1 = Label(frame, text='Gib den Teilchennamen der Base 1 ein:', font=helv16)
        self.l1.grid(row=0, column=0, columnspan=8, padx=8, pady=8)
        self.e1 = Entry(frame, width=40, font=helv14, fg='blue', bg='white')
        self.e1.bind("<Return>", self.eingabe_berechnen_enter)
        self.e1.grid(row=1, column=0, columnspan=8, padx=4, pady=4)
        self.l2 = Label(frame, text=u'Gib den Teilchennamen der S\xe4ure 2 ein:', font=helv16)
        self.l2.grid(row=2, column=0, columnspan=8, padx=8, pady=8)
        self.e2 = Entry(frame, width=40, font=helv14, fg='red', bg='white')
        self.e2.bind("<Return>", self.eingabe_berechnen_enter)
        self.e2.grid(row=3, column=0, columnspan=8, padx=4, pady=4)
        ## Berechnung
        self.b1 = Button(frame, text='Reaktionsgleichung ermitteln lassen', command=self.eingabe_berechnen_knopf)
        self.b1.grid(row=4, column=0, columnspan=3, padx=4, pady=4, sticky=E+W)
        ## Reset
        self.b2 = Button(frame, text=u'Auf Startwerte zur\xfccksetzen', command=self.neu)
        self.b2.grid(row=4, column=3, columnspan=5, padx=4, pady=4, sticky=E+W)
        
        ## Ausgabe der Reaktionsgleichung:
        self.l3 = Label(frame, text=u'Die prinzipiell m\xf6gliche Reaktionsgleichung lautet:', font=helv16)
        self.l3.grid(row=5, column=0, columnspan=8, padx=8, pady=8)
        self.l4 = Label(frame, text='Summenformelgleichung:', font=helv14)
        self.l4.grid(row=7, column=0, padx=4, pady=4)
        self.l5 = Label(frame, textvariable=cFB1, font=courier14, fg='blue', relief=RIDGE)
        self.l5.grid(row=7, column=1, padx=4, pady=4, sticky=E+W)
        self.l6 = Label(frame, text=' + ', font=helv14)
        self.l6.grid(row=7, column=2, padx=4, pady=4)
        self.l7 = Label(frame, textvariable=cFS2, font=courier14, fg='red', relief=RIDGE)
        self.l7.grid(row=7, column=3, padx=4, pady=4, sticky=E+W)
        self.l8 = Label(frame, text=u' \u2192 ', font=helv14)
        self.l8.grid(row=7, column=4, padx=4, pady=4)
        self.l9 = Label(frame, textvariable=cFS1, font=courier14, fg='red', relief=RIDGE)
        self.l9.grid(row=7, column=5, padx=4, pady=4, sticky=E+W)
        self.l10 = Label(frame, text= ' + ', font=helv14)
        self.l10.grid(row=7, column=6, padx=4, pady=4)
        self.l11 = Label(frame, textvariable=cFB2, font=courier14, fg='blue', relief=RIDGE)
        self.l11.grid(row=7, column=7, padx=4, pady=4, sticky=E+W)

        ## Namen der Stoffe
        self.l12 = Label(frame, text='Teilchennamen der Endstoffe:', font=helv14)
        self.l12.grid(row=8, column=0, padx=4, pady=4)
        self.l13 = Label(frame, textvariable=cNS1, font=helv14, fg='red', relief=RIDGE)
        self.l13.grid(row=8, column=5, padx=4, pady=4, sticky=E+W)
        self.l14 = Label(frame, textvariable=cNB2, font=helv14, fg='blue', relief=RIDGE)
        self.l14.grid(row=8, column=7, padx=4, pady=4, sticky=E+W)

        self.l15 = Label(frame, text='Korrespondierende Paare:', font=helv14)
        self.l15.grid(row=9, column=0, padx=4, pady=4)
        self.l16 = Label(frame, text='Base 1', font=helv14, fg='blue')
        self.l16.grid(row=9, column=1, padx=4, pady=4)
        self.l17 = Label(frame, text='Säure 2', font=helv14, fg='red')
        self.l17.grid(row=9, column=3, padx=4, pady=4)
        self.l18 = Label(frame, text='Säure 1', font=helv14, fg='red')
        self.l18.grid(row=9, column=5, padx=4, pady=4)
        self.l19 = Label(frame, text='Base 2', font=helv14, fg='blue')
        self.l19.grid(row=9, column=7, padx=4, pady=4)

        ## Saeure- bzw. Basenstärke
        self.l20 = Label(frame, text=u'Dies entspricht bez\xfcglich der jeweiligen S\xe4ure- bzw. Basenst\xe4rke:', font=helv16)
        self.l20.grid(row=10, column=0, columnspan=8, padx=8, pady=8)

        self.l21 = Label(frame, text=u'St\xe4rke:', font=helv14)
        self.l21.grid(row=11, column=0, padx=4, pady=4)
        self.l22 = Label(frame, textvariable=cTB1, font=helv14, fg='blue', relief=RIDGE)
        self.l22.grid(row=11, column=1, padx=4, pady=4, sticky=E+W)
        self.l23 = Label(frame, text=' mit ', font=helv14)
        self.l23.grid(row=11, column=2, padx=4, pady=4)
        self.l24 = Label(frame, textvariable=cTS2, font=helv14, fg='red', relief=RIDGE)
        self.l24.grid(row=11, column=3, padx=4, pady=4, sticky=E+W)
        self.l25 = Label(frame, text=' zu  ', font=helv14)
        self.l25.grid(row=11, column=4, padx=4, pady=4)
        self.l26 = Label(frame, textvariable=cTS1, font=helv14, fg='red', relief=RIDGE)
        self.l26.grid(row=11, column=5, padx=4, pady=4, sticky=E+W)
        self.l27 = Label(frame, text=' und ', font=helv14)
        self.l27.grid(row=11, column=6, padx=4, pady=4)
        self.l28 = Label(frame, textvariable=cTB2, font=helv14, fg='blue', relief=RIDGE)
        self.l28.grid(row=11, column=7, padx=4, pady=4, sticky=E+W)

        ## pKS + PKB
        self.l29 = Label(frame, text='Summe der pKS und pKB-Werte:', font=helv14)
        self.l29.grid(row=12, column=0, padx=4, pady=4)

        self.l30 = Label(frame, textvariable=cpKEd, font=helv14, relief=RIDGE)
        self.l30.grid(row=12, column=1, columnspan=3, padx=4, pady=4)
        self.l31 = Label(frame, textvariable=cpKProd, font=helv14, relief=RIDGE)
        self.l31.grid(row=12, column=5, columnspan=3, padx=4, pady=4)

        ## Abbruch
        self.b3 = Button(frame, text='Programm Beenden', command=frame.quit)
        self.b3.grid(row=20, column=6, columnspan=2, padx=4, pady=4, sticky=E+W)
        
    def eingabe_berechnen_knopf(self):
        ## Werte holen
        global EB1
        EB1 = self.e1.get()
        global ES2
        ES2 = self.e2.get()

        ## Summenformeln der Ausgangsstoffe
        global FB1
        FB1 = B1[EB1][0]
        cFB1.set(FB1)
        global FS2
        FS2 = S2[ES2][0]
        cFS2.set(FS2)

        ## Summenformeln der korrespondierenden Saeure bzw. Base
        global FS1
        FS1 = S2[B1[EB1][3]][0]
        cFS1.set(FS1)
        global FB2
        FB2 = B1[S2[ES2][3]][0]
        cFB2.set(FB2)

        ## Teilchennamen der korrespondierenden Saeure bzw. Base
        global NS1
        NS1 = B1[EB1][3]
        cNS1.set(NS1)
        global NB2
        NB2 = S2[ES2][3]
        cNB2.set(NB2)

        ## Saeure- bzw. Basenstaerke
        global TB1
        TB1 = B1[EB1][2]
        cTB1.set(TB1)
        global TS2
        TS2 = S2[ES2][2]
        cTS2.set(TS2)
        global TS1
        TS1 = S2[B1[EB1][3]][2]
        cTS1.set(TS1)
        global TB2
        TB2 = B1[S2[ES2][3]][2]
        cTB2.set(TB2)

        ## pKS und PKB Werte
        global pKB1
        pKB1 = float(B1[EB1][1])
        global pKS2
        pKS2 = float(S2[ES2][1])
        global pKS1
        pKS1 = float(S2[B1[EB1][3]][1])
        global pKB2
        pKB2 = float(B1[S2[ES2][3]][1])
        global pKEd
        pKEd = float(pKB1 + pKS2)
        pKEd = '%.2f' % (pKEd,)
        cpKEd.set(pKEd)
        global pKProd
        pKProd = float(pKS1 + pKB2)
        pKProd = '%.2f' % (pKProd,)
        cpKProd.set(pKProd)

    def eingabe_berechnen_enter(self, event):
        ## Werte holen
        global EB1
        EB1 = self.e1.get()
        global ES2
        ES2 = self.e2.get()

        ## Summenformeln der Ausgangsstoffe
        global FB1
        FB1 = B1[EB1][0]
        cFB1.set(FB1)
        global FS2
        FS2 = S2[ES2][0]
        cFS2.set(FS2)

        ## Summenformeln der korrespondierenden Saeure bzw. Base
        global FS1
        FS1 = S2[B1[EB1][3]][0]
        cFS1.set(FS1)
        global FB2
        FB2 = B1[S2[ES2][3]][0]
        cFB2.set(FB2)

        ## Teilchennamen der korrespondierenden Saeure bzw. Base
        global NS1
        NS1 = B1[EB1][3]
        cNS1.set(NS1)
        global NB2
        NB2 = S2[ES2][3]
        cNB2.set(NB2)

        ## Saeure- bzw. Basenstaerke
        global TB1
        TB1 = B1[EB1][2]
        cTB1.set(TB1)
        global TS2
        TS2 = S2[ES2][2]
        cTS2.set(TS2)
        global TS1
        TS1 = S2[B1[EB1][3]][2]
        cTS1.set(TS1)
        global TB2
        TB2 = B1[S2[ES2][3]][2]
        cTB2.set(TB2)

        ## pKS und PKB Werte
        global pKB1
        pKB1 = float(B1[EB1][1])
        global pKS2
        pKS2 = float(S2[ES2][1])
        global pKS1
        pKS1 = float(S2[B1[EB1][3]][1])
        global pKB2
        pKB2 = float(B1[S2[ES2][3]][1])
        global pKEd
        pKEd = float(pKB1 + pKS2)
        pKEd = '%.2f' % (pKEd,)
        cpKEd.set(pKEd)
        global pKProd
        pKProd = float(pKS1 + pKB2)
        pKProd = '%.2f' % (pKProd,)
        cpKProd.set(pKProd)    

    def neu(self):
        cFB1.set('B')
        cFS2.set('HA')
        cFS1.set('BH+')
        cFB2.set('A-')
        cTB1.set('-')
        cTS2.set('-')
        cTS1.set('-')
        cTB2.set('-')
        cNS1.set('-')
        cNB2.set('-')
        cpKEd.set(u'Ausgangsstoffe noch nicht gew\xe4hlt')
        cpKProd.set('Endstoffe noch nicht ermittelt')
        self.e1.delete(0, END)
        self.e2.delete(0, END)
  
root = Tk()
root.title('Acidbaser')
root.minsize(740,480)

app = Fenster(root)

root.mainloop()


