/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Dots;
import org.jmol.util.FastBitSet;
import org.jmol.util.Geodesic;

public class DotsRenderer
extends ShapeRenderer {
    public boolean iShowSolid;
    Vector3f[] verticesTransformed;
    public int screenLevel;
    public int screenDotCount;
    public int[] screenCoordinates;
    public int[] faceMap = null;
    private int dotScale;
    protected float testRadiusAdjust;

    protected void initRenderer() {
        this.screenLevel = Dots.MAX_LEVEL;
        this.screenDotCount = Geodesic.getVertexCount(Dots.MAX_LEVEL);
        this.verticesTransformed = new Vector3f[this.screenDotCount];
        int n = this.screenDotCount;
        while (--n >= 0) {
            this.verticesTransformed[n] = new Vector3f();
        }
        this.screenCoordinates = new int[3 * this.screenDotCount];
    }

    protected void render() {
        Dots dots = (Dots)this.shape;
        this.render1(dots);
    }

    protected void render1(Dots dots) {
        if (!this.iShowSolid && !this.g3d.setColix((short)4)) {
            return;
        }
        int n = (int)this.viewer.getScalePixelsPerAngstrom(true);
        int n2 = this.iShowSolid || n > 20 ? 3 : (n > 10 ? 2 : (this.screenLevel = n > 5 ? 1 : 0));
        if (!this.iShowSolid) {
            this.screenLevel += this.viewer.getDotDensity() - 3;
        }
        this.screenLevel = Math.max(Math.min(this.screenLevel, Dots.MAX_LEVEL), 0);
        this.screenDotCount = Geodesic.getVertexCount(this.screenLevel);
        this.dotScale = this.viewer.getDotScale();
        int n3 = this.screenDotCount;
        while (--n3 >= 0) {
            this.viewer.transformVector(Geodesic.getVertexVector(n3), this.verticesTransformed[n3]);
        }
        FastBitSet[] fastBitSetArray = dots.ec.getDotsConvexMaps();
        int n4 = dots.ec.getDotsConvexMax();
        while (--n4 >= 0) {
            Atom atom = this.modelSet.atoms[n4];
            FastBitSet fastBitSet = fastBitSetArray[n4];
            if (fastBitSet == null || !atom.isVisible(this.myVisibilityFlag) || !this.g3d.isInDisplayRange(atom.screenX, atom.screenY)) continue;
            try {
                int n5 = this.calcScreenPoints(fastBitSet, dots.ec.getAppropriateRadius(n4) + this.testRadiusAdjust, atom.screenX, atom.screenY, atom.screenZ);
                if (n5 == 0) continue;
                this.renderConvex(Graphics3D.getColixInherited(dots.colixes[n4], atom.getColix()), fastBitSet, n5);
            }
            catch (Exception exception) {
                System.out.println("Dots rendering error");
                exception.printStackTrace();
            }
        }
    }

    private int calcScreenPoints(FastBitSet fastBitSet, float f, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        float f2 = this.viewer.scaleToPerspective(n3, f);
        int n6 = Math.min(fastBitSet.size(), this.screenDotCount);
        while (--n6 >= 0) {
            if (!fastBitSet.get(n6)) continue;
            Vector3f vector3f = this.verticesTransformed[n6];
            if (this.faceMap != null) {
                this.faceMap[n6] = n5;
            }
            this.screenCoordinates[n5++] = n + (int)((double)(f2 * vector3f.x) + (vector3f.x < 0.0f ? -0.5 : 0.5));
            this.screenCoordinates[n5++] = n2 + (int)((double)(f2 * vector3f.y) + (vector3f.y < 0.0f ? -0.5 : 0.5));
            this.screenCoordinates[n5++] = n3 + (int)((double)(f2 * vector3f.z) + (vector3f.z < 0.0f ? -0.5 : 0.5));
            ++n4;
        }
        return n4;
    }

    protected void renderConvex(short s, FastBitSet fastBitSet, int n) {
        this.colix = Graphics3D.getColixTranslucent(s, false, 0.0f);
        this.renderDots(n);
    }

    protected void renderDots(int n) {
        this.g3d.setColix(this.colix);
        this.g3d.drawPoints(n, this.screenCoordinates, this.dotScale);
    }
}

