/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.Interface;
import org.jmol.api.QuantumPlaneCalculationInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

abstract class VolumeFileReader
extends SurfaceFileReader {
    protected boolean endOfData;
    protected boolean negativeAtomCount;
    protected int atomCount;
    protected int nSurfaces;
    protected boolean isAngstroms;
    protected boolean canDownsample;
    private int[] downsampleRemainders;
    private boolean preProcessPlanes;
    private int nData;
    boolean readerClosed;
    Point4f thePlane;
    protected int downsampleFactor;
    private int nSkipX;
    private int nSkipY;
    private int nSkipZ;
    private float[][] yzPlanesRaw;
    private int iPlaneRaw;
    protected Point3f[] boundingBox;
    private boolean isScaledAlready;

    VolumeFileReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isXLowToHigh = true;
        this.isProgressive = true;
        this.canDownsample = true;
        this.jvxlData.wasCubic = true;
        this.boundingBox = this.params.boundingBox;
        if (this.params.qmOrbitalType == 4) {
            this.hasColorData = this.params.parameters == null || this.params.parameters[1] >= 0.0f;
            this.preProcessPlanes = true;
            this.params.insideOut = !this.params.insideOut;
        }
    }

    protected float recordData(float f) {
        if (Float.isNaN(f)) {
            return f;
        }
        if (f < this.dataMin) {
            this.dataMin = f;
        }
        if (f > this.dataMax) {
            this.dataMax = f;
        }
        this.dataMean += f;
        ++this.nData;
        return f;
    }

    protected void closeReader() {
        if (this.readerClosed) {
            return;
        }
        this.readerClosed = true;
        super.closeReader();
        if (this.nData == 0 || this.dataMax == -3.4028235E38f) {
            return;
        }
        this.dataMean /= (float)this.nData;
        Logger.info("VolumeFileReader closing file: " + this.nData + " points read \ndata min/max/mean = " + this.dataMin + "/" + this.dataMax + "/" + this.dataMean);
    }

    protected boolean readVolumeParameters(boolean bl) {
        this.endOfData = false;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces == 0) {
            return false;
        }
        if (this.nSurfaces < this.params.fileIndex) {
            Logger.warn("not enough surfaces in file -- resetting params.fileIndex to " + this.nSurfaces);
            this.params.fileIndex = this.nSurfaces;
        }
        return true;
    }

    protected boolean readVolumeData(boolean bl) {
        if (!this.gotoAndReadVoxelData(bl)) {
            return false;
        }
        if (!this.vertexDataOnly) {
            Logger.info("JVXL read: " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points");
        }
        return true;
    }

    private int readVolumetricHeader() {
        try {
            int n;
            boolean bl;
            this.readParameters();
            if (this.atomCount == Integer.MIN_VALUE) {
                return 0;
            }
            Logger.info("voxel grid origin:" + this.volumetricOrigin);
            int n2 = this.params.downsampleFactor;
            boolean bl2 = bl = this.canDownsample && n2 > 0;
            if (bl) {
                this.downsampleRemainders = new int[3];
                Logger.info("downsample factor = " + n2);
                for (n = 0; n < 3; ++n) {
                    int n3 = this.voxelCounts[n];
                    this.downsampleRemainders[n] = n3 % n2;
                    int n4 = n;
                    this.voxelCounts[n4] = this.voxelCounts[n4] / n2;
                    this.volumetricVectors[n].scale(n2);
                    Logger.info("downsampling axis " + (n + 1) + " from " + n3 + " to " + this.voxelCounts[n]);
                }
            }
            for (n = 0; n < 3; ++n) {
                if (!this.isAngstroms) {
                    this.volumetricVectors[n].scale(0.5291772f);
                }
                this.line = this.voxelCounts[n] + " " + this.volumetricVectors[n].x + " " + this.volumetricVectors[n].y + " " + this.volumetricVectors[n].z;
                this.jvxlFileHeaderBuffer.append(this.line).append('\n');
                Logger.info("voxel grid count/vector:" + this.line);
            }
            this.scaleIsosurface(this.params.scale);
            this.volumeData.setVolumetricXml();
            return this.nSurfaces;
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            return 0;
        }
    }

    protected abstract void readParameters() throws Exception;

    protected String skipComments(boolean bl) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.readLine() != null && (bl && this.line.length() == 0 || this.line.indexOf("#") == 0)) {
            stringBuffer.append(this.line).append('\n');
        }
        return stringBuffer.toString();
    }

    protected void readVoxelVector(int n) throws Exception {
        this.readLine();
        Vector3f vector3f = this.volumetricVectors[n];
        this.voxelCounts[n] = this.parseInt(this.line);
        if (this.voxelCounts[n] == Integer.MIN_VALUE) {
            this.next[0] = this.line.indexOf(" ");
        }
        vector3f.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
        if (this.isAnisotropic) {
            this.setVectorAnisotropy(vector3f);
        }
    }

    protected void initializeSurfaceData() {
        this.downsampleFactor = this.params.downsampleFactor;
        this.nSkipX = 0;
        this.nSkipY = 0;
        this.nSkipZ = 0;
        if (this.canDownsample && this.downsampleFactor > 0) {
            this.nSkipX = this.downsampleFactor - 1;
            this.nSkipZ = this.nPointsZ * this.downsampleFactor + this.downsampleRemainders[2];
            this.nSkipY = this.downsampleRemainders[2] + (this.downsampleFactor - 1) * this.nSkipZ;
            this.nSkipZ = this.downsampleRemainders[1] * this.nSkipZ + (this.downsampleFactor - 1) * this.nSkipZ * (this.nPointsY * this.downsampleFactor + this.downsampleRemainders[1]);
        }
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
        } else if (this.isJvxl) {
            this.params.cutoff = this.params.isBicolorMap || this.params.colorBySign ? 0.01f : 0.5f;
        }
        this.nDataPoints = 0;
        this.next[0] = 0;
        this.line = "";
        this.jvxlNSurfaceInts = 0;
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        this.initializeSurfaceData();
        if (this.isProgressive && !bl || this.isJvxl) {
            this.nDataPoints = this.volumeData.setVoxelCounts(this.nPointsX, this.nPointsY, this.nPointsZ);
            this.voxelData = null;
            if (this.isJvxl) {
                this.jvxlVoxelBitSet = this.getVoxelBitSet(this.nDataPoints);
            }
        } else if (bl && this.volumeData.hasPlane()) {
            this.volumeData.setVoxelMap();
            float f = this.volumeData.getToPlaneParameter();
            for (int i = 0; i < this.nPointsX; ++i) {
                for (int j = 0; j < this.nPointsY; ++j) {
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        float f2 = this.recordData(this.getNextVoxelValue());
                        if (this.volumeData.isNearPlane(i, j, k, f)) {
                            this.volumeData.setVoxelMapValue(i, j, k, f2);
                        }
                        if (this.nSkipX == 0) continue;
                        this.skipVoxels(this.nSkipX);
                    }
                    if (this.nSkipY == 0) continue;
                    this.skipVoxels(this.nSkipY);
                }
                if (this.nSkipZ == 0) continue;
                this.skipVoxels(this.nSkipZ);
            }
        } else {
            this.voxelData = new float[this.nPointsX][][];
            for (int i = 0; i < this.nPointsX; ++i) {
                float[][] fArrayArray = new float[this.nPointsY][];
                this.voxelData[i] = fArrayArray;
                for (int j = 0; j < this.nPointsY; ++j) {
                    float[] fArray = new float[this.nPointsZ];
                    fArrayArray[j] = fArray;
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        fArray[k] = this.recordData(this.getNextVoxelValue());
                        if (this.nSkipX == 0) continue;
                        this.skipVoxels(this.nSkipX);
                    }
                    if (this.nSkipY == 0) continue;
                    this.skipVoxels(this.nSkipY);
                }
                if (this.nSkipZ == 0) continue;
                this.skipVoxels(this.nSkipZ);
            }
        }
        this.volumeData.setVoxelData(this.voxelData);
    }

    public float[] getPlane(int n) {
        if (n == 0) {
            this.initPlanes();
        }
        if (this.preProcessPlanes) {
            return this.getPlaneProcessed(n);
        }
        float[] fArray = super.getPlane(n);
        if (this.qpc == null) {
            this.getPlane(fArray, true);
        }
        return fArray;
    }

    public float[] getPlaneProcessed(int n) {
        float[] fArray;
        if (this.iPlaneRaw == 0) {
            this.qpc = (QuantumPlaneCalculationInterface)Interface.getOptionInterface("quantum.NciCalculation");
            AtomData atomData = new AtomData();
            atomData.modelIndex = -1;
            atomData.bsSelected = this.params.bsSelected;
            this.sg.fillAtomData(atomData, 1);
            this.qpc.setupCalculation(this.volumeData, this.sg.getBsSelected(), null, null, null, atomData.atomXyz, -1, null, null, null, null, null, null, null, this.params.theProperty, true, null, this.params.parameters, this.params.testFlags);
            this.iPlaneRaw = 1;
            this.yzPlanesRaw = new float[4][this.yzCount];
            this.qpc.setPlanes(this.yzPlanesRaw);
            if (this.hasColorData) {
                this.getPlane(this.yzPlanesRaw[0], false);
                this.getPlane(this.yzPlanesRaw[1], false);
                float[] fArray2 = this.yzPlanes[0];
                for (int i = 0; i < this.yzCount; ++i) {
                    fArray2[i] = Float.NaN;
                }
                return fArray2;
            }
            this.iPlaneRaw = -1;
        }
        float f = this.qpc.getNoValue();
        int n2 = this.nPointsX - 1;
        switch (this.iPlaneRaw) {
            case -1: {
                fArray = this.yzPlanes[n % 2];
                ++n2;
                break;
            }
            case 3: {
                fArray = this.yzPlanesRaw[0];
                this.yzPlanesRaw[0] = this.yzPlanesRaw[1];
                this.yzPlanesRaw[1] = this.yzPlanesRaw[2];
                this.yzPlanesRaw[2] = this.yzPlanesRaw[3];
                this.yzPlanesRaw[3] = fArray;
                fArray = this.yzPlanesRaw[this.iPlaneRaw];
                break;
            }
            default: {
                ++this.iPlaneRaw;
                fArray = this.yzPlanesRaw[this.iPlaneRaw];
            }
        }
        if (n < n2) {
            this.getPlane(fArray, false);
            fArray = this.yzPlanes[n % 2];
            this.qpc.calcPlane(n, fArray);
            for (int i = 0; i < this.yzCount; ++i) {
                if (fArray[i] == f) continue;
                this.recordData(fArray[i]);
            }
        } else {
            for (int i = 0; i < this.yzCount; ++i) {
                fArray[i] = Float.NaN;
            }
        }
        return fArray;
    }

    private void getPlane(float[] fArray, boolean bl) {
        try {
            int n = 0;
            for (int i = 0; i < this.nPointsY; ++i) {
                for (int j = 0; j < this.nPointsZ; ++j) {
                    float f = this.getNextVoxelValue();
                    if (bl) {
                        this.recordData(f);
                    }
                    fArray[n++] = f;
                    if (this.nSkipX == 0) continue;
                    this.skipVoxels(this.nSkipX);
                }
                if (this.nSkipY == 0) continue;
                this.skipVoxels(this.nSkipY);
            }
            if (this.nSkipZ != 0) {
                this.skipVoxels(this.nSkipZ);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float getValue(int n, int n2, int n3, int n4) {
        if (this.boundingBox != null) {
            this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptTemp);
            if (this.ptTemp.x < this.boundingBox[0].x || this.ptTemp.x > this.boundingBox[1].x || this.ptTemp.y < this.boundingBox[0].y || this.ptTemp.y > this.boundingBox[1].y || this.ptTemp.z < this.boundingBox[0].z || this.ptTemp.z > this.boundingBox[1].z) {
                return Float.NaN;
            }
        }
        return super.getValue(n, n2, n3, n4);
    }

    private void skipVoxels(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.getNextVoxelValue();
        }
    }

    protected BitSet getVoxelBitSet(int n) throws Exception {
        return null;
    }

    protected float getNextVoxelValue() throws Exception {
        float f = 0.0f;
        if (this.nSurfaces > 1 && !this.params.blockCubeData) {
            int n;
            for (n = 1; n < this.params.fileIndex; ++n) {
                this.nextVoxel();
            }
            f = this.nextVoxel();
            for (n = this.params.fileIndex; n < this.nSurfaces; ++n) {
                this.nextVoxel();
            }
        } else {
            f = this.nextVoxel();
        }
        return f;
    }

    protected float nextVoxel() throws Exception {
        float f = this.parseFloat();
        if (Float.isNaN(f)) {
            while (this.readLine() != null && Float.isNaN(f = this.parseFloat(this.line))) {
            }
            if (this.line == null) {
                if (!this.endOfData) {
                    Logger.warn("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line);
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
        }
        return f;
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + n2 + " points each");
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(n2);
        }
    }

    protected void skipData(int n) throws Exception {
        for (int i = 0; i < n; i += this.countData(this.readLine())) {
        }
    }

    private int countData(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c;
            while (n2 < n3 && ((c = string.charAt(n2)) == ' ' || c == '\t')) {
                ++n2;
            }
            if (n2 < n3) {
                ++n;
            }
            while (n2 < n3 && (c = string.charAt(n2)) != ' ' && c != '\t') {
                ++n2;
            }
        }
        return n;
    }

    protected static boolean checkAtomLine(boolean bl, boolean bl2, String string, String string2, StringBuffer stringBuffer) {
        if (string2.indexOf("ANGSTROMS") >= 0) {
            bl2 = true;
        }
        int n = string == null ? Integer.MAX_VALUE : Parser.parseInt(string);
        switch (n) {
            case -2147483648: {
                n = 0;
                string2 = " " + string2.substring(string2.indexOf(" ") + 1);
                break;
            }
            case 0x7FFFFFFF: {
                n = Integer.MIN_VALUE;
                break;
            }
            default: {
                String string3 = "" + n;
                string2 = string2.substring(string2.indexOf(string3) + string3.length());
            }
        }
        if (bl2) {
            if (string2.indexOf("ANGSTROM") < 0) {
                string2 = string2 + " ANGSTROMS";
            }
        } else if (string2.indexOf("BOHR") < 0) {
            string2 = string2 + " BOHR";
        }
        string2 = (n == Integer.MIN_VALUE ? "" : (bl ? "+" : "-") + Math.abs(n)) + string2 + "\n";
        stringBuffer.append(string2);
        return bl2;
    }

    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, Point3f point3f, Vector3f vector3f, int n, int n2, int n3, int n4, int n5, float[] fArray, Point3f point3f2) {
        float f4 = super.getSurfacePointAndFraction(f, bl, f2, f3, point3f, vector3f, n, n2, n3, n4, n5, fArray, point3f2);
        if (this.qpc == null || Float.isNaN(f4) || !this.hasColorData) {
            return f4;
        }
        n4 = this.marchingCubes.getLinearOffset(n, n2, n3, n4);
        n5 = this.marchingCubes.getLinearOffset(n, n2, n3, n5);
        return this.qpc.process(n4, n5, fArray[0]);
    }

    private void scaleIsosurface(float f) {
        if (this.isScaledAlready) {
            return;
        }
        this.isScaledAlready = true;
        if (this.isAnisotropic) {
            this.setVolumetricAnisotropy();
        }
        if (Float.isNaN(f)) {
            return;
        }
        Logger.info("applying scaling factor of " + f);
        this.volumetricOrigin.scaleAdd((1.0f - f) / 2.0f, this.volumetricVectors[0]);
        this.volumetricOrigin.scaleAdd((1.0f - f) / 2.0f, this.volumetricVectors[1]);
        this.volumetricOrigin.scaleAdd((1.0f - f) / 2.0f, this.volumetricVectors[2]);
        this.volumetricVectors[0].scale(f);
        this.volumetricVectors[1].scale(f);
        this.volumetricVectors[2].scale(f);
    }
}

