/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jmol.util.Logger;

public class GT {
    private static boolean ignoreApplicationBundle = false;
    private static GT getTextWrapper;
    private ResourceBundle[] translationResources = null;
    private int translationResourcesCount = 0;
    private boolean doTranslate = true;
    private String language;
    private static Language[] languageList;

    public GT(String string) {
        this.getTranslation(string);
    }

    private GT() {
        this.getTranslation(null);
    }

    public static Language[] getLanguageList() {
        return languageList != null ? languageList : GT.getTextWrapper().createLanguageList();
    }

    private synchronized Language[] createLanguageList() {
        boolean bl = this.doTranslate;
        this.doTranslate = false;
        languageList = new Language[]{new Language("ar", GT._("Arabic"), "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", false), new Language("ast", GT._("Asturian"), "Asturian", false), new Language("bs", GT._("Bosnian"), "bosanski jezik", false), new Language("ca", GT._("Catalan"), "Catal\u00e0", true), new Language("cs", GT._("Czech"), "\u010ce\u0161tina", true), new Language("da", GT._("Danish"), "Dansk", true), new Language("de", GT._("German"), "Deutsch", true), new Language("el", GT._("Greek"), "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", false), new Language("en_AU", GT._("Australian English"), "Australian English", false), new Language("en_GB", GT._("British English"), "British English", true), new Language("en_US", GT._("American English"), "American English", true), new Language("es", GT._("Spanish"), "Espa\u00f1ol", true), new Language("et", GT._("Estonian"), "Eesti", false), new Language("fi", GT._("Finnish"), "Suomi", true), new Language("fo", GT._("Faroese"), "F\u00f8royskt", false), new Language("fr", GT._("French"), "Fran\u00e7ais", true), new Language("fy", GT._("Frisian"), "Frysk", false), new Language("gl", GT._("Galician"), "Galego", false), new Language("hr", GT._("Croatian"), "Hrvatski", false), new Language("hu", GT._("Hungarian"), "Magyar", true), new Language("hy", GT._("Armenian"), "\u0540\u0561\u0575\u0565\u0580\u0565\u0576", false), new Language("id", GT._("Indonesian"), "Indonesia", true), new Language("it", GT._("Italian"), "Italiano", true), new Language("ja", GT._("Japanese"), "\u65e5\u672c\u8a9e", false), new Language("jv", GT._("Javanese"), "Basa Jawa", false), new Language("ko", GT._("Korean"), "\ud55c\uad6d\uc5b4", true), new Language("ms", GT._("Malay"), "Bahasa Melayu", true), new Language("nb", GT._("Norwegian Bokmal"), "Norsk Bokm\u00e5l", false), new Language("nl", GT._("Dutch"), "Nederlands", true), new Language("oc", GT._("Occitan"), "Occitan", false), new Language("pl", GT._("Polish"), "Polski", false), new Language("pt", GT._("Portuguese"), "Portugu\u00eas", false), new Language("pt_BR", GT._("Brazilian Portuguese"), "Portugu\u00eas brasileiro", true), new Language("ru", GT._("Russian"), "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", false), new Language("sl", GT._("Slovenian"), "Sloven\u0161\u010dina", false), new Language("sr", GT._("Serbian"), "\u0441\u0440\u043f\u0441\u043a\u0438 \u0458\u0435\u0437\u0438\u043a", false), new Language("sv", GT._("Swedish"), "Svenska", false), new Language("ta", GT._("Tamil"), "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd", false), new Language("te", GT._("Telugu"), "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41", false), new Language("tr", GT._("Turkish"), "T\u00fcrk\u00e7e", true), new Language("ug", GT._("Uyghur"), "Uy\u01a3urq\u0259", false), new Language("uk", GT._("Ukrainian"), "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430", true), new Language("zh_CN", GT._("Simplified Chinese"), "\u7b80\u4f53\u4e2d\u6587", true), new Language("zh_TW", GT._("Traditional Chinese"), "\u7e41\u9ad4\u4e2d\u6587", true)};
        this.doTranslate = bl;
        return languageList;
    }

    private String getSupported(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (languageList == null) {
            this.createLanguageList();
        }
        for (int i = 0; i < languageList.length; ++i) {
            if (!GT.languageList[i].code.equalsIgnoreCase(string)) continue;
            return GT.languageList[i].code;
        }
        return bl ? null : this.findClosest(string);
    }

    private String findClosest(String string) {
        int n = languageList.length;
        while (--n >= 0) {
            if (!GT.languageList[n].code.startsWith(string)) continue;
            return GT.languageList[n].code;
        }
        return null;
    }

    public static String getLanguage() {
        return GT.getTextWrapper().language;
    }

    private synchronized void getTranslation(String string) {
        Locale locale;
        this.translationResources = null;
        this.translationResourcesCount = 0;
        getTextWrapper = this;
        if (string != null && string.length() == 0) {
            string = "none";
        }
        if (string != null) {
            this.language = string;
        }
        if ("none".equals(this.language)) {
            this.language = null;
        }
        if (this.language == null && (locale = Locale.getDefault()) != null) {
            this.language = locale.getLanguage();
            if (locale.getCountry() != null) {
                this.language = this.language + "_" + locale.getCountry();
                if (locale.getVariant() != null && locale.getVariant().length() > 0) {
                    this.language = this.language + "_" + locale.getVariant();
                }
            }
        }
        if (this.language == null) {
            this.language = "en";
        }
        String string2 = this.language;
        String string3 = this.language;
        String string4 = this.language;
        int n = this.language.indexOf("_");
        if (n >= 0) {
            string2 = string2.substring(0, n);
            ++n;
            if ((n = this.language.indexOf("_", n)) >= 0) {
                string3 = this.language.substring(0, n);
            } else {
                string4 = null;
            }
        } else {
            string3 = null;
            string4 = null;
        }
        this.language = this.getSupported(string4, false);
        if (this.language == null && (this.language = this.getSupported(string3, false)) == null && (this.language = this.getSupported(string2, false)) == null) {
            this.language = "en";
            Logger.debug(this.language + " not supported -- using en");
            return;
        }
        string4 = null;
        string3 = null;
        switch (this.language.length()) {
            case 2: {
                string2 = this.language;
                break;
            }
            case 5: {
                string3 = this.language;
                string2 = this.language.substring(0, 2);
                break;
            }
            default: {
                string4 = this.language;
                string3 = this.language.substring(0, 5);
                string2 = this.language.substring(0, 2);
            }
        }
        string3 = this.getSupported(string3, false);
        string2 = this.getSupported(string2, false);
        if (string2 == string3 || "en_US".equals(string2)) {
            string2 = null;
        }
        if (string3 == string4) {
            string3 = null;
        }
        if ("en_US".equals(string3)) {
            return;
        }
        if (Logger.debugging) {
            Logger.debug("Instantiating gettext wrapper for " + this.language + " using files for language:" + string2 + " country:" + string3 + " variant:" + string4);
        }
        if (!ignoreApplicationBundle) {
            this.addBundles("Jmol", string4, string3, string2);
        }
        this.addBundles("JmolApplet", string4, string3, string2);
    }

    private void addBundles(String string, String string2, String string3, String string4) {
        try {
            String string5 = "org.jmol.translation." + string + ".";
            if (string2 != null) {
                this.addBundle(string5, string2);
            }
            if (string3 != null) {
                this.addBundle(string5, string3);
            }
            if (string4 != null) {
                this.addBundle(string5, string4);
            }
        }
        catch (Exception exception) {
            Logger.error("Some exception occurred!", exception);
            this.translationResources = null;
            this.translationResourcesCount = 0;
        }
    }

    private void addBundle(String string, String string2) {
        Class<?> clazz = null;
        string = string + string2 + ".Messages_" + string2;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            Logger.error("GT could not find the class " + string);
        }
        if (clazz == null || !ResourceBundle.class.isAssignableFrom(clazz)) {
            return;
        }
        try {
            ResourceBundle resourceBundle = (ResourceBundle)clazz.newInstance();
            if (resourceBundle != null) {
                if (this.translationResources == null) {
                    this.translationResources = new ResourceBundle[8];
                    this.translationResourcesCount = 0;
                }
                this.translationResources[this.translationResourcesCount] = resourceBundle;
                ++this.translationResourcesCount;
                Logger.debug("GT adding " + string);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.warn("Illegal Access Exception: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            Logger.warn("Instantiation Excaption: " + instantiationException.getMessage());
        }
    }

    private static GT getTextWrapper() {
        return getTextWrapper == null ? (getTextWrapper = new GT()) : getTextWrapper;
    }

    public static void ignoreApplicationBundle() {
        ignoreApplicationBundle = true;
    }

    public static void setDoTranslate(boolean bl) {
        GT.getTextWrapper().doTranslate = bl;
    }

    public static boolean getDoTranslate() {
        return GT.getTextWrapper().doTranslate;
    }

    public static String _(String string) {
        return GT.getTextWrapper().getString(string);
    }

    public static String _(String string, String string2) {
        return GT.getTextWrapper().getString(string, new Object[]{string2});
    }

    public static String _(String string, int n) {
        return GT.getTextWrapper().getString(string, new Object[]{n});
    }

    public static String _(String string, Object[] objectArray) {
        return GT.getTextWrapper().getString(string, objectArray);
    }

    public static String _(String string, boolean bl) {
        return GT._(string, (Object[])null, bl);
    }

    public static String _(String string, String string2, boolean bl) {
        return GT._(string, new Object[]{string2});
    }

    public static String _(String string, int n, boolean bl) {
        return GT._(string, new Object[]{n});
    }

    public static synchronized String _(String string, Object[] objectArray, boolean bl) {
        String string2;
        boolean bl2 = GT.getTextWrapper().doTranslate;
        if (!bl2) {
            GT.setDoTranslate(true);
        }
        String string3 = string2 = objectArray == null ? GT._(string) : GT._(string, objectArray);
        if (!bl2) {
            GT.setDoTranslate(false);
        }
        return string2;
    }

    private String getString(String string) {
        if (this.doTranslate) {
            int n = this.translationResourcesCount;
            while (--n >= 0) {
                try {
                    return this.translationResources[n].getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            if (Logger.debugging) {
                Logger.info("No trans, using default: " + string);
            }
        }
        if (string.startsWith("[")) {
            string = string.substring(string.indexOf("]") + 1);
        } else if (string.endsWith("]")) {
            string = string.substring(0, string.indexOf("["));
        }
        return string;
    }

    private String getString(String string, Object[] objectArray) {
        String string2 = null;
        if (!this.doTranslate) {
            return MessageFormat.format(string, objectArray);
        }
        for (int i = 0; i < this.translationResourcesCount; ++i) {
            try {
                string2 = MessageFormat.format(this.translationResources[i].getString(string), objectArray);
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                continue;
            }
        }
        string2 = MessageFormat.format(string, objectArray);
        if (this.translationResourcesCount > 0 && Logger.debugging) {
            Logger.debug("No trans, using default: " + string2);
        }
        return string2;
    }

    public static String escapeHTML(String string) {
        int n = string.length();
        while (--n >= 0) {
            char c = string.charAt(n);
            if (c <= '\u007f') continue;
            string = string.substring(0, n) + "&#" + c + ";" + string.substring(n + 1);
        }
        return string;
    }

    public static class Language {
        public final String code;
        public final String language;
        public final String nativeLanguage;
        private boolean display;

        public Language(String string, String string2, String string3, boolean bl) {
            this.code = string;
            this.language = string2;
            this.nativeLanguage = string3;
            this.display = bl;
        }

        public boolean shouldDisplay() {
            return this.display;
        }

        public void forceDisplay() {
            this.display = true;
        }
    }
}

