/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.api.ApiPlatform;

class Platform3D {
    int windowWidth;
    int windowHeight;
    int windowSize;
    int bufferWidth;
    int bufferHeight;
    int bufferSize;
    int bufferSizeT;
    Object imagePixelBuffer;
    int[] pBuffer;
    int[] pBufferT;
    int[] zBuffer;
    int[] zBufferT;
    int widthOffscreen;
    int heightOffscreen;
    Object imageForText;
    Object graphicForText;
    Object graphicsOffscreen;
    static final boolean forcePlatformAWT = false;
    static final boolean desireClearingThread = false;
    boolean useClearingThread = true;
    ClearingThread clearingThread;
    ApiPlatform apiPlatform;
    private static boolean backgroundTransparent = false;

    Platform3D() {
    }

    static Platform3D createInstance(ApiPlatform apiPlatform) {
        Platform3D platform3D = new Platform3D();
        platform3D.initialize(false);
        platform3D.apiPlatform = apiPlatform;
        platform3D.graphicsOffscreen = apiPlatform.getGraphics(platform3D.allocateOffscreenImage(1, 1));
        return platform3D;
    }

    final void initialize(boolean bl) {
        this.useClearingThread = bl;
        if (bl) {
            this.clearingThread = new ClearingThread();
            this.clearingThread.start();
        }
    }

    void allocateTBuffers(boolean bl) {
        this.bufferSizeT = bl ? this.bufferSize : this.windowSize;
        this.zBufferT = new int[this.bufferSizeT];
        this.pBufferT = new int[this.bufferSizeT];
    }

    void allocateBuffers(int n, int n2, boolean bl) {
        this.windowWidth = n;
        this.windowHeight = n2;
        this.windowSize = n * n2;
        if (bl) {
            this.bufferWidth = n * 2;
            this.bufferHeight = n2 * 2;
        } else {
            this.bufferWidth = n;
            this.bufferHeight = n2;
        }
        this.bufferSize = this.bufferWidth * this.bufferHeight;
        this.zBuffer = new int[this.bufferSize];
        this.pBuffer = new int[this.bufferSize];
        this.imagePixelBuffer = this.apiPlatform.allocateRgbImage(this.windowWidth, this.windowHeight, this.pBuffer, this.windowSize, backgroundTransparent);
    }

    void releaseBuffers() {
        this.bufferSize = -1;
        this.bufferHeight = -1;
        this.bufferWidth = -1;
        this.windowHeight = -1;
        this.windowWidth = -1;
        if (this.imagePixelBuffer != null) {
            this.apiPlatform.flushImage(this.imagePixelBuffer);
            this.imagePixelBuffer = null;
        }
        this.pBuffer = null;
        this.zBuffer = null;
        this.pBufferT = null;
        this.zBufferT = null;
    }

    boolean hasContent() {
        int n = this.bufferSize;
        while (--n >= 0) {
            if (this.zBuffer[n] == Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    void clearScreenBuffer() {
        int n = this.bufferSize;
        while (--n >= 0) {
            this.zBuffer[n] = Integer.MAX_VALUE;
            this.pBuffer[n] = 0;
        }
    }

    void setBackgroundColor(int n) {
        if (this.pBuffer == null) {
            return;
        }
        int n2 = this.bufferSize;
        while (--n2 >= 0) {
            if (this.pBuffer[n2] != 0) continue;
            this.pBuffer[n2] = n;
        }
    }

    void clearTBuffer() {
        int n = this.bufferSizeT;
        while (--n >= 0) {
            this.zBufferT[n] = Integer.MAX_VALUE;
            this.pBufferT[n] = 0;
        }
    }

    final void obtainScreenBuffer() {
        if (this.useClearingThread) {
            this.clearingThread.obtainBufferForClient();
        } else {
            this.clearScreenBuffer();
        }
    }

    final void clearScreenBufferThreaded() {
        if (this.useClearingThread) {
            this.clearingThread.releaseBufferForClearing();
        }
    }

    void notifyEndOfRendering() {
    }

    boolean checkOffscreenSize(int n, int n2) {
        if (n <= this.widthOffscreen && n2 <= this.heightOffscreen) {
            return true;
        }
        if (this.imageForText != null) {
            this.apiPlatform.disposeGraphics(this.graphicForText);
            this.apiPlatform.flushImage(this.imageForText);
        }
        if (n > this.widthOffscreen) {
            this.widthOffscreen = n + 63 & 0xFFFFFFC0;
        }
        if (n2 > this.heightOffscreen) {
            this.heightOffscreen = n2 + 15 & 0xFFFFFFF0;
        }
        this.imageForText = this.allocateOffscreenImage(this.widthOffscreen, this.heightOffscreen);
        this.graphicForText = this.getGraphics(this.imageForText);
        return false;
    }

    void setBackgroundTransparent(boolean bl) {
        backgroundTransparent = bl;
    }

    private Object allocateOffscreenImage(int n, int n2) {
        return this.apiPlatform.newBufferedRgbImage(n, n2);
    }

    private Object getGraphics(Object object) {
        return this.apiPlatform.getStaticGraphics(object, backgroundTransparent);
    }

    class ClearingThread
    extends Thread {
        boolean bufferHasBeenCleared = false;
        boolean clientHasBuffer = false;

        ClearingThread() {
        }

        synchronized void notifyBackgroundChange(int n) {
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void obtainBufferForClient() {
            while (!this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.clientHasBuffer = true;
        }

        synchronized void releaseBufferForClearing() {
            this.clientHasBuffer = false;
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void waitForClientRelease() {
            while (this.clientHasBuffer || this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void notifyBufferReady() {
            this.bufferHasBeenCleared = true;
            this.notify();
        }

        public void run() {
            while (true) {
                this.waitForClientRelease();
                Platform3D.this.clearScreenBuffer();
                this.notifyBufferReady();
            }
        }
    }
}

