/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import jspecview.util.TextFormat;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Eigen;

public class MagResReader
extends AtomSetCollectionReader {
    private float[] cellParams;
    private float maxIso = 10000.0f;
    private Atom atom;

    protected void initializeReader() {
        this.setFractionalCoordinates(false);
        this.doApplySymmetry = false;
        this.atomSetCollection.newAtomSet();
    }

    protected boolean checkLine() throws Exception {
        if (this.line.startsWith("lattice")) {
            this.readCellParams();
        } else if (this.line.contains("Coordinates")) {
            this.readAtom();
        } else if (this.line.contains("J-coupling Total") || this.line.contains("TOTAL tensor")) {
            this.readTensor();
        }
        return true;
    }

    private void readCellParams() throws Exception {
        String[] stringArray = this.getTokens();
        this.cellParams = new float[9];
        for (int i = 0; i < 9; ++i) {
            this.cellParams[i] = this.parseFloat(stringArray[i + 1]) * 0.5291772f;
        }
        this.addPrimitiveLatticeVector(0, this.cellParams, 0);
        this.addPrimitiveLatticeVector(1, this.cellParams, 3);
        this.addPrimitiveLatticeVector(2, this.cellParams, 6);
        this.setSpaceGroupName("P1");
    }

    private void readAtom() throws Exception {
        float f = this.line.trim().endsWith("A") ? 1.0f : 0.5291772f;
        String[] stringArray = this.getTokens();
        this.atom = this.atomSetCollection.addNewAtom();
        this.atom.elementSymbol = stringArray[0];
        this.atom.atomName = stringArray[0] + stringArray[1];
        float f2 = this.parseFloat(stringArray[3]) * f;
        float f3 = this.parseFloat(stringArray[4]) * f;
        float f4 = this.parseFloat(stringArray[5]) * f;
        this.atom.set(f2, f3, f4);
        this.setAtomCoord(this.atom);
    }

    private void readTensor() throws Exception {
        boolean bl = this.line.indexOf("J-") >= 0;
        this.atomSetCollection.setAtomSetName(this.line.trim());
        float[] fArray = new float[9];
        this.readLine();
        String string = TextFormat.simpleReplace((String)(this.readLine() + this.readLine() + this.readLine()), (String)"-", (String)" -");
        this.fillFloatArray(string, 0, fArray);
        float f = 3.0f;
        if (bl) {
            this.discardLinesUntilContains("Isotropic");
            float f2 = this.parseFloat(this.getTokens()[3]);
            if (Math.abs(f2) > this.maxIso) {
                return;
            }
            f = 0.04f;
        }
        double[][] dArray = new double[3][3];
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = fArray[n++];
            }
        }
        this.atom.setEllipsoid(Eigen.getEllipsoid(dArray));
        this.atom.ellipsoid[0].scale(f);
    }
}

