/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import jspecview.util.Parser;

public class TextFormat {
    private static final DecimalFormat[] formatters = new DecimalFormat[10];
    private static final String[] formattingStrings = new String[]{"0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"};
    private static final Boolean[] useNumberLocalization = new Boolean[1];
    public static final String newLine = System.getProperty("line.separator");
    private static Map<String, DecimalFormat> htFormats = new Hashtable<String, DecimalFormat>();
    static DecimalFormat formatter1 = TextFormat.getDecimalFormat("0.000000E00");
    static DecimalFormat formatter2 = TextFormat.getDecimalFormat("0.0000000000");

    public TextFormat() {
        TextFormat.useNumberLocalization[0] = Boolean.TRUE;
    }

    public static void setUseNumberLocalization(boolean TF) {
        TextFormat.useNumberLocalization[0] = TF ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String formatDecimal(float value, int decimalDigits) {
        DecimalFormat formatter;
        if (decimalDigits == Integer.MAX_VALUE) {
            return "" + value;
        }
        if (decimalDigits < 0) {
            double d;
            if ((decimalDigits = -decimalDigits) > formattingStrings.length) {
                decimalDigits = formattingStrings.length;
            }
            if (value == 0.0f) {
                return String.valueOf(formattingStrings[decimalDigits]) + "E+0";
            }
            int n = 0;
            if (Math.abs(value) < 1.0f) {
                n = 10;
                d = (double)value * 1.0E-10;
            } else {
                n = -10;
                d = (double)value * 1.0E10;
            }
            String s = ("" + d).toUpperCase();
            int i = s.indexOf("E");
            n = Parser.parseInt(s.substring(i + 1)) + n;
            return i < 0 ? "" + value : String.valueOf(TextFormat.formatDecimal(Parser.parseFloat(s.substring(0, i)), decimalDigits - 1)) + "E" + (n >= 0 ? "+" : "") + n;
        }
        if (decimalDigits >= formattingStrings.length) {
            decimalDigits = formattingStrings.length - 1;
        }
        if ((formatter = formatters[decimalDigits]) == null) {
            formatter = TextFormat.formatters[decimalDigits] = new DecimalFormat(formattingStrings[decimalDigits]);
        }
        String s = formatter.format(value);
        return Boolean.TRUE.equals(useNumberLocalization[0]) ? s : s.replace(',', '.');
    }

    public static String format(float value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        return TextFormat.format(TextFormat.formatDecimal(value, precision), width, 0, alignLeft, zeroPad);
    }

    public static String format(String value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        if (value == null) {
            return "";
        }
        if (precision != Integer.MAX_VALUE && precision > 0 && precision < value.length()) {
            value = value.substring(0, precision);
        } else if (precision < 0 && -precision < value.length()) {
            value = value.substring(value.length() + precision);
        }
        int padLength = width - value.length();
        if (padLength <= 0) {
            return value;
        }
        boolean isNeg = zeroPad && !alignLeft && value.charAt(0) == '-';
        char padChar = zeroPad ? (char)'0' : ' ';
        char padChar0 = isNeg ? (char)'-' : padChar;
        StringBuffer sb = new StringBuffer();
        if (alignLeft) {
            sb.append(value);
        }
        sb.append(padChar0);
        int i = padLength;
        while (--i > 0) {
            sb.append(padChar);
        }
        if (!alignLeft) {
            sb.append(isNeg ? String.valueOf(padChar) + value.substring(1) : value);
        }
        return sb.toString();
    }

    public static String formatString(String strFormat, String key, String strT) {
        return TextFormat.formatString(strFormat, key, strT, Float.NaN);
    }

    public static String formatString(String strFormat, String key, float floatT) {
        return TextFormat.formatString(strFormat, key, null, floatT);
    }

    public static String formatString(String strFormat, String key, int intT) {
        return TextFormat.formatString(strFormat, key, "" + intT, Float.NaN);
    }

    public static String sprintf(String strFormat, Object[] values) {
        if (values == null) {
            return strFormat;
        }
        int o = 0;
        while (o < values.length) {
            if (values[o] != null) {
                int i;
                if (values[o] instanceof String[]) {
                    String[] sVal = (String[])values[o];
                    i = 0;
                    while (i < sVal.length) {
                        strFormat = TextFormat.formatString(strFormat, "s", sVal[i], Float.NaN, true);
                        ++i;
                    }
                } else if (values[o] instanceof float[]) {
                    float[] fVal = (float[])values[o];
                    i = 0;
                    while (i < fVal.length) {
                        strFormat = TextFormat.formatString(strFormat, "f", null, fVal[i], true);
                        ++i;
                    }
                } else if (values[o] instanceof int[]) {
                    int[] iVal = (int[])values[o];
                    i = 0;
                    while (i < iVal.length) {
                        strFormat = TextFormat.formatString(strFormat, "d", "" + iVal[i], Float.NaN, true);
                        ++i;
                    }
                }
            }
            ++o;
        }
        return strFormat;
    }

    public static String sprintf(String strFormat, String[] sVal, float[] fVal) {
        return TextFormat.sprintf(strFormat, new Object[]{sVal, fVal});
    }

    public static String sprintf(String strFormat, String[] sVal, float[] fVal, int[] iVal) {
        return TextFormat.sprintf(strFormat, new Object[]{sVal, fVal, iVal});
    }

    public static String formatString(String strFormat, String key, String strT, float floatT) {
        return TextFormat.formatString(strFormat, key, strT, floatT, false);
    }

    private static String formatString(String strFormat, String key, String strT, float floatT, boolean doOne) {
        int ichKey;
        int ichPercent;
        if (strFormat == null) {
            return null;
        }
        if ("".equals(strFormat)) {
            return "";
        }
        int len = key.length();
        if (strFormat.indexOf("%") < 0 || len == 0 || strFormat.indexOf(key) < 0) {
            return strFormat;
        }
        String strLabel = "";
        int ich = 0;
        while ((ichPercent = strFormat.indexOf(37, ich)) >= 0 && (ichKey = strFormat.indexOf(key, ichPercent + 1)) >= 0) {
            if (ich != ichPercent) {
                strLabel = String.valueOf(strLabel) + strFormat.substring(ich, ichPercent);
            }
            ich = ichPercent + 1;
            if (ichKey > ichPercent + 6) {
                strLabel = String.valueOf(strLabel) + '%';
                continue;
            }
            try {
                String st;
                char ch;
                boolean alignLeft = false;
                if (strFormat.charAt(ich) == '-') {
                    alignLeft = true;
                    ++ich;
                }
                boolean zeroPad = false;
                if (strFormat.charAt(ich) == '0') {
                    zeroPad = true;
                    ++ich;
                }
                int width = 0;
                while ((ch = strFormat.charAt(ich)) >= '0' && ch <= '9') {
                    width = 10 * width + (ch - 48);
                    ++ich;
                }
                int precision = Integer.MAX_VALUE;
                if (strFormat.charAt(ich) == '.' && (ch = strFormat.charAt(++ich)) >= '0' && ch <= '9') {
                    precision = ch - 48;
                    ++ich;
                }
                if (!(st = strFormat.substring(ich, ich + len)).equals(key)) {
                    ich = ichPercent + 1;
                    strLabel = String.valueOf(strLabel) + '%';
                    continue;
                }
                ich += len;
                if (!Float.isNaN(floatT)) {
                    strLabel = String.valueOf(strLabel) + TextFormat.format(floatT, width, precision, alignLeft, zeroPad);
                } else if (strT != null) {
                    strLabel = String.valueOf(strLabel) + TextFormat.format(strT, width, precision, alignLeft, zeroPad);
                }
                if (!doOne) continue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                ich = ichPercent;
            }
            break;
        }
        strLabel = String.valueOf(strLabel) + strFormat.substring(ich);
        return strLabel;
    }

    public static String[] split(String text, String run) {
        int n = 1;
        int i = text.indexOf(run);
        int runLen = run.length();
        if (i < 0 || runLen == 0) {
            String[] lines = new String[]{text};
            return lines;
        }
        int len = text.length() - runLen;
        while (i >= 0 && i < len) {
            i = text.indexOf(run, i + runLen);
            ++n;
        }
        String[] lines = new String[n];
        i = 0;
        int ipt = 0;
        int pt = 0;
        while ((ipt = text.indexOf(run, i)) >= 0 && pt + 1 < n) {
            lines[pt++] = text.substring(i, ipt);
            i = ipt + runLen;
        }
        if (text.indexOf(run, len) != len) {
            len += runLen;
        }
        lines[pt] = text.substring(i, len);
        return lines;
    }

    public static String replaceAllCharacters(String str, String strFrom, String strTo) {
        int i = strFrom.length();
        while (--i >= 0) {
            String chFrom = strFrom.substring(i, i + 1);
            str = TextFormat.simpleReplace(str, chFrom, strTo);
        }
        return str;
    }

    public static String replaceAllCharacters(String str, String strFrom, char chTo) {
        int i = strFrom.length();
        while (--i >= 0) {
            str = str.replace(strFrom.charAt(i), chTo);
        }
        return str;
    }

    public static String simpleReplace(String str, String strFrom, String strTo) {
        if (str == null || str.indexOf(strFrom) < 0 || strFrom.equals(strTo)) {
            return str;
        }
        int fromLength = strFrom.length();
        if (fromLength == 0) {
            return str;
        }
        boolean isOnce = strTo.indexOf(strFrom) >= 0;
        while (str.indexOf(strFrom) >= 0) {
            int ipt;
            StringBuffer s = new StringBuffer();
            int ipt0 = 0;
            while ((ipt = str.indexOf(strFrom, ipt0)) >= 0) {
                s.append(str.substring(ipt0, ipt)).append(strTo);
                ipt0 = ipt + fromLength;
            }
            s.append(str.substring(ipt0));
            str = s.toString();
            if (isOnce) break;
        }
        return str;
    }

    public static String trim(String str, String chars) {
        if (chars.length() == 0) {
            return str.trim();
        }
        int len = str.length();
        int k = 0;
        while (k < len && chars.indexOf(str.charAt(k)) >= 0) {
            ++k;
        }
        int m = str.length() - 1;
        while (m > k && chars.indexOf(str.charAt(m)) >= 0) {
            --m;
        }
        return str.substring(k, m + 1);
    }

    public static String rtrim(String str, String chars) {
        if (chars.length() == 0) {
            return str.trim();
        }
        int m = str.length() - 1;
        while (m >= 0 && chars.indexOf(str.charAt(m)) >= 0) {
            --m;
        }
        return str.substring(0, m + 1);
    }

    public static String[] split(String text, char ch) {
        return TextFormat.split(text, "" + ch);
    }

    public static void lFill(StringBuffer s, String s1, String s2) {
        s.append(s2);
        int n = s1.length() - s2.length();
        if (n > 0) {
            s.append(s1.substring(0, n));
        }
    }

    public static void rFill(StringBuffer s, String s1, String s2) {
        int n = s1.length() - s2.length();
        if (n > 0) {
            s.append(s1.substring(0, n));
        }
        s.append(s2);
    }

    public static String safeTruncate(float f, int n) {
        if ((double)f > -0.001 && (double)f < 0.001) {
            f = 0.0f;
        }
        return (String.valueOf(f) + "         ").substring(0, n);
    }

    public static boolean isWild(String s) {
        return s.indexOf("*") >= 0 || s.indexOf("?") >= 0;
    }

    public static boolean isMatch(String s, String strWildcard, boolean checkStar, boolean allowInitialStar) {
        boolean isStar0;
        int ich = 0;
        int cchWildcard = strWildcard.length();
        int cchs = s.length();
        if (cchs == 0 || cchWildcard == 0) {
            return false;
        }
        boolean bl = checkStar && allowInitialStar ? strWildcard.charAt(0) == '*' : (isStar0 = false);
        if (isStar0 && strWildcard.charAt(cchWildcard - 1) == '*') {
            return cchWildcard < 3 || s.indexOf(strWildcard.substring(1, cchWildcard - 1)) >= 0;
        }
        String qqq = "????";
        while (qqq.length() < s.length()) {
            qqq = String.valueOf(qqq) + qqq;
        }
        if (checkStar) {
            if (allowInitialStar && isStar0) {
                strWildcard = String.valueOf(qqq) + strWildcard.substring(1);
            }
            if (strWildcard.charAt(ich = strWildcard.length() - 1) == '*') {
                strWildcard = String.valueOf(strWildcard.substring(0, ich)) + qqq;
            }
            cchWildcard = strWildcard.length();
        }
        if (cchWildcard < cchs) {
            return false;
        }
        ich = 0;
        while (cchWildcard > cchs) {
            if (allowInitialStar && strWildcard.charAt(ich) == '?') {
                ++ich;
            } else if (strWildcard.charAt(ich + cchWildcard - 1) != '?') {
                return false;
            }
            --cchWildcard;
        }
        int i = cchs;
        while (--i >= 0) {
            char charWild = strWildcard.charAt(ich + i);
            if (charWild == '?' || charWild == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static DecimalFormat getDecimalFormat(String hash) {
        DecimalFormat df = htFormats.get(hash);
        if (df == null) {
            df = new DecimalFormat(hash.equals("") ? "0.00E0" : hash, new DecimalFormatSymbols(Locale.US));
            htFormats.put(hash, df);
        }
        return df;
    }

    public static String trimQuotes(String value) {
        return value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
    }

    public static String fixExponent(double x) {
        String s = formatter1.format(x);
        int pt = s.indexOf("E");
        if (pt < 0) {
            return s;
        }
        switch (s.length() - pt) {
            case 2: {
                s = String.valueOf(s.substring(0, pt + 1)) + "0" + s.substring(pt + 1);
                break;
            }
            case 3: {
                if (s.charAt(pt + 1) != '-') break;
                s = String.valueOf(s.substring(0, pt + 2)) + "0" + s.substring(pt + 2);
            }
        }
        if (s.indexOf("E-") < 0) {
            s = String.valueOf(s.substring(0, pt + 1)) + "+" + s.substring(pt + 1);
        }
        return s;
    }

    public static String fixExponentInt(double x) {
        return x == Math.floor(x) ? String.valueOf((long)x) : TextFormat.simpleReplace(TextFormat.fixExponent(x), "E+00", "");
    }

    public static String fixIntNoExponent(double x) {
        return x == Math.floor(x) ? String.valueOf((long)x) : TextFormat.rtrim(formatter2.format(x), "0");
    }

    public static boolean isAlmostInteger(double x) {
        return x != 0.0 && Math.abs(x - Math.floor(x)) / x > 1.0E-8;
    }
}

