/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.TreeNode;
import jspecview.common.AwtDialog;
import jspecview.common.JSVPanelNode;
import jspecview.common.JSVTree;
import jspecview.common.JSVTreeNode;
import jspecview.common.JSViewer;
import jspecview.common.ScriptInterface;

public class ViewDialog
extends AwtDialog
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private ScriptInterface si;
    private List<JSVTreeNode> treeNodes;
    private List<JCheckBox> checkBoxes;
    private JPanel spectrumPanel;
    private Insets cbInsets1;
    private Insets cbInsets2;
    private JButton closeSelectedButton;
    private JButton combineSelectedButton;
    private JButton viewSelectedButton;
    private static int[] posXY;
    private boolean checking = false;

    static {
        int[] nArray = new int[2];
        nArray[0] = Integer.MIN_VALUE;
        posXY = nArray;
    }

    public ViewDialog(ScriptInterface si, Component panel, boolean modal) {
        this.si = si;
        this.setTitle("View/Combine/Close Spectra");
        this.setModal(modal);
        this.setPosition(panel, this.getPosXY());
        this.setResizable(true);
        this.addWindowListener(this);
        this.setup();
    }

    protected int[] getPosXY() {
        return posXY;
    }

    private void setup() {
        try {
            this.jbInit();
            this.pack();
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.layoutCheckBoxes();
        JButton selectAllButton = this.newJButton();
        JButton selectNoneButton = this.newJButton();
        this.combineSelectedButton = this.newJButton();
        this.viewSelectedButton = this.newJButton();
        this.closeSelectedButton = this.newJButton();
        JButton doneButton = this.newJButton();
        selectAllButton.setText("Select All");
        selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewDialog.this.select(true);
            }
        });
        selectNoneButton.setText("Select None");
        selectNoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewDialog.this.select(false);
            }
        });
        this.viewSelectedButton.setText("View Selected");
        this.viewSelectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewDialog.this.viewSelected();
            }
        });
        this.combineSelectedButton.setText("Combine Selected");
        this.combineSelectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewDialog.this.combineSelected();
            }
        });
        this.closeSelectedButton.setText("Close Selected");
        this.closeSelectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewDialog.this.closeSelected();
            }
        });
        doneButton.setText("Done");
        doneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewDialog.this.done();
            }
        });
        Insets buttonInsets = new Insets(5, 5, 5, 5);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setMinimumSize(new Dimension(150, 300));
        int i = 0;
        this.addButton(leftPanel, selectAllButton, i++, buttonInsets);
        this.addButton(leftPanel, selectNoneButton, i++, buttonInsets);
        this.addButton(leftPanel, this.viewSelectedButton, i++, buttonInsets);
        this.addButton(leftPanel, this.combineSelectedButton, i++, buttonInsets);
        this.addButton(leftPanel, this.closeSelectedButton, i++, buttonInsets);
        this.addButton(leftPanel, doneButton, i++, buttonInsets);
        JScrollPane scrollPane = new JScrollPane(this.spectrumPanel);
        JSplitPane mainSplitPane = new JSplitPane(1);
        mainSplitPane.setOneTouchExpandable(true);
        mainSplitPane.setResizeWeight(0.0);
        mainSplitPane.setRightComponent(scrollPane);
        mainSplitPane.setLeftComponent(leftPanel);
        this.setPreferredSize(new Dimension(500, 350));
        this.getContentPane().removeAll();
        this.getContentPane().add(mainSplitPane);
        this.checkEnables();
    }

    private void addButton(JPanel leftPanel, JButton selectAllButton, int i, Insets buttonInsets) {
        leftPanel.add((Component)selectAllButton, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 10, 0, buttonInsets, 0, 0));
    }

    private JButton newJButton() {
        JButton b = new JButton();
        b.setPreferredSize(new Dimension(120, 25));
        return b;
    }

    private void layoutCheckBoxes() {
        this.checkBoxes = new ArrayList<JCheckBox>();
        this.treeNodes = new ArrayList<JSVTreeNode>();
        this.cbInsets1 = new Insets(0, 0, 2, 2);
        this.cbInsets2 = new Insets(0, 20, 2, 2);
        this.spectrumPanel = new JPanel(new GridBagLayout());
        this.addCheckBoxes(((JSVTree)this.si.getSpectraTree()).getRootNode(), 0, true);
        this.addCheckBoxes(((JSVTree)this.si.getSpectraTree()).getRootNode(), 0, false);
    }

    private void addCheckBoxes(JSVTreeNode rootNode, int level, boolean addViews) {
        Enumeration<TreeNode> enume = rootNode.children();
        while (enume.hasMoreElements()) {
            JSVTreeNode treeNode = (JSVTreeNode)enume.nextElement();
            JSVPanelNode node = treeNode.panelNode;
            if (node.isView != addViews) continue;
            JCheckBox cb = new JCheckBox();
            cb.setSelected(node.isSelected);
            String title = node.toString();
            if (title.indexOf("\n") >= 0) {
                title = title.substring(0, title.indexOf(10));
            }
            cb.setText(title);
            cb.setActionCommand("" + this.treeNodes.size());
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewDialog.this.check(e);
                }
            });
            Insets insets = level < 1 ? this.cbInsets1 : this.cbInsets2;
            this.spectrumPanel.add((Component)cb, new GridBagConstraints(0, this.checkBoxes.size(), 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            treeNode.index = this.treeNodes.size();
            this.treeNodes.add(treeNode);
            this.checkBoxes.add(cb);
            this.addCheckBoxes(treeNode, level + 1, addViews);
        }
    }

    private void checkEnables() {
        this.closeSelectedButton.setEnabled(false);
        int i = 0;
        while (i < this.checkBoxes.size()) {
            if (this.checkBoxes.get(i).isSelected() && this.treeNodes.get((int)i).panelNode.jsvp == null) {
                this.closeSelectedButton.setEnabled(true);
                break;
            }
            ++i;
        }
        int n = 0;
        int i2 = 0;
        while (i2 < this.checkBoxes.size()) {
            if (this.checkBoxes.get(i2).isSelected() && this.treeNodes.get((int)i2).panelNode.jsvp != null) {
                ++n;
            }
            ++i2;
        }
        this.combineSelectedButton.setEnabled(n > 1);
        this.viewSelectedButton.setEnabled(n == 1);
    }

    protected void check(ActionEvent e) {
        int i = Integer.parseInt(e.getActionCommand());
        JSVTreeNode node = this.treeNodes.get(i);
        JCheckBox cb = (JCheckBox)e.getSource();
        boolean isSelected = cb.isSelected();
        if (node.panelNode.jsvp == null) {
            if (!this.checking && isSelected && cb.getText().startsWith("Overlay")) {
                this.checking = true;
                this.select(false);
                cb.setSelected(true);
                node.panelNode.isSelected = true;
                this.checking = false;
            }
            Enumeration<TreeNode> enume = node.children();
            while (enume.hasMoreElements()) {
                JSVTreeNode treeNode = (JSVTreeNode)enume.nextElement();
                this.checkBoxes.get(treeNode.index).setSelected(isSelected);
                treeNode.panelNode.isSelected = isSelected;
                node.panelNode.isSelected = isSelected;
            }
        } else {
            node.panelNode.isSelected = isSelected;
        }
        if (isSelected) {
            i = this.treeNodes.size();
            while (--i >= 0) {
                if (this.treeNodes.get((int)i).panelNode.isView == node.panelNode.isView) continue;
                this.checkBoxes.get(this.treeNodes.get((int)i).index).setSelected(false);
                this.treeNodes.get((int)i).panelNode.isSelected = false;
            }
        }
        this.checkEnables();
    }

    protected void select(boolean mode) {
        int i = this.checkBoxes.size();
        while (--i >= 0) {
            this.checkBoxes.get(i).setSelected(mode);
            this.treeNodes.get((int)i).panelNode.isSelected = mode;
        }
        this.checkEnables();
    }

    protected void combineSelected() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.checkBoxes.size()) {
            JCheckBox cb = this.checkBoxes.get(i);
            JSVPanelNode node = this.treeNodes.get((int)i).panelNode;
            if (cb.isSelected() && node.jsvp != null) {
                if (node.isView) {
                    this.si.setNode(node, true);
                    return;
                }
                String label = cb.getText();
                sb.append(" ").append(label.substring(0, label.indexOf(":")));
            }
            ++i;
        }
        JSViewer.execView(this.si, sb.toString().trim(), false);
        this.setup();
    }

    protected void viewSelected() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.checkBoxes.size()) {
            JCheckBox cb = this.checkBoxes.get(i);
            JSVPanelNode node = this.treeNodes.get((int)i).panelNode;
            if (cb.isSelected() && node.jsvp != null) {
                if (node.isView) {
                    this.si.setNode(node, true);
                    return;
                }
                String label = cb.getText();
                sb.append(" ").append(label.substring(0, label.indexOf(":")));
            }
            ++i;
        }
        JSViewer.execView(this.si, sb.toString().trim(), false);
        this.setup();
    }

    protected void closeSelected() {
        this.si.execClose("selected", false);
        this.setup();
    }

    protected void done() {
        this.dispose();
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent arg0) {
        this.dispose();
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
        this.dispose();
    }

    public void windowOpened(WindowEvent arg0) {
    }
}

