/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.text.DecimalFormat;
import java.util.Map;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.Parameters;
import jspecview.common.PeakPick;
import jspecview.common.ScaleData;
import jspecview.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeakData
extends MeasurementData {
    private static final long serialVersionUID = 1L;
    private double thresh;
    private double minY;
    private double maxY;
    private static final String[] HNMR_HEADER = new String[]{"peak", "shift/ppm", "intens", "shift/hz", "diff/hz", "2-diff", "3-diff"};

    public PeakData(Annotation.AType type, JDXSpectrum spec) {
        super(type, spec);
    }

    public double getThresh() {
        return this.thresh;
    }

    @Override
    public String[] getDataHeader() {
        String[] stringArray;
        if (this.spec.isHNMR()) {
            stringArray = HNMR_HEADER;
        } else {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "peak";
            stringArray2[1] = this.spec.getXUnits();
            stringArray = stringArray2;
            stringArray2[2] = this.spec.getYUnits();
        }
        return stringArray;
    }

    @Override
    public String[][] getMeasurementListArray(String units) {
        DecimalFormat df4 = TextFormat.getDecimalFormat("#0.0000");
        DecimalFormat df2 = TextFormat.getDecimalFormat("#0.00");
        String[][] data = new String[this.size()][];
        double[] last = new double[]{-1.0E100, 1.0E100, 1.0E100};
        int pt = 0;
        int i = this.size();
        while (--i >= 0) {
            double[] ddata = this.spec.getPeakListArray((Measurement)this.get(i), last, this.maxY);
            data[pt] = ddata.length == 2 ? new String[]{"" + (pt + 1), df2.format(ddata[0]), df4.format(ddata[1])} : new String[]{"" + (pt + 1), df4.format(ddata[0]), df4.format(ddata[1]), df2.format(ddata[2]), ddata[3] == 0.0 ? "" : df2.format(ddata[3]), ddata[4] == 0.0 ? "" : df2.format(ddata[4]), ddata[5] == 0.0 ? "" : df2.format(ddata[5])};
            ++pt;
        }
        return data;
    }

    @Override
    public double[][] getMeasurementListArrayReal(String units) {
        double[][] data = new double[this.size()][];
        double[] last = new double[]{-1.0E100, 1.0E100, 1.0E100};
        int pt = 0;
        int i = this.size();
        while (--i >= 0) {
            data[pt] = this.spec.getPeakListArray((Measurement)this.get(i), last, this.maxY);
            ++pt;
        }
        return data;
    }

    @Override
    public void getInfo(Map<String, Object> info) {
        info.put("interpolation", this.myParams.peakListInterpolation);
        info.put("threshold", this.myParams.peakListThreshold);
        super.getInfo(info);
    }

    public void setPeakList(Parameters p, DecimalFormat formatter, ScaleData view) {
        if (formatter == null) {
            formatter = TextFormat.getDecimalFormat(this.spec.getPeakPickHash());
        }
        this.df = formatter;
        Coordinate[] xyCoords = this.spec.getXYCoords();
        if (xyCoords.length < 3) {
            return;
        }
        this.clear();
        if (p != null) {
            this.myParams.peakListInterpolation = p.peakListInterpolation;
            this.myParams.peakListThreshold = p.peakListThreshold;
        }
        boolean doInterpolate = this.myParams.peakListInterpolation.equals("parabolic");
        boolean isInverted = this.spec.isInverted();
        this.minY = view.minYOnScale;
        this.maxY = view.maxYOnScale;
        double minX = view.minXOnScale;
        double maxX = view.maxXOnScale;
        this.thresh = this.myParams.peakListThreshold;
        if (Double.isNaN(this.thresh)) {
            this.thresh = this.myParams.peakListThreshold = (this.minY + this.maxY) / 2.0;
        }
        double yLast = 0.0;
        double[] y3 = new double[]{xyCoords[0].getYVal(), yLast = xyCoords[1].getYVal(), 0.0};
        int n = 0;
        int n2 = 0;
        if (isInverted) {
            int i = 2;
            while (i < xyCoords.length) {
                double d = xyCoords[i].getYVal();
                y3[i % 3] = d;
                double y = d;
                if (yLast < this.thresh && y3[(i - 2) % 3] > yLast && yLast < y) {
                    double x;
                    double d2 = x = doInterpolate ? Coordinate.parabolicInterpolation(xyCoords, i - 1) : xyCoords[i - 1].getXVal();
                    if (x >= minX || x <= maxX) {
                        PeakPick m = new PeakPick(this.spec, x, y);
                        this.add(m);
                        if (++n == 100) break;
                    }
                }
                yLast = y;
                ++i;
            }
        } else {
            int i = 2;
            while (i < xyCoords.length) {
                double d = xyCoords[i].getYVal();
                y3[i % 3] = d;
                double y = d;
                if (yLast > this.thresh && y3[(i - 2) % 3] < yLast && yLast > y) {
                    double x;
                    ++n2;
                    double d3 = x = doInterpolate ? Coordinate.parabolicInterpolation(xyCoords, i - 1) : xyCoords[i - 1].getXVal();
                    if (x >= minX && x <= maxX) {
                        PeakPick m = new PeakPick(this.spec, x, y, formatter.format(x), x);
                        this.add(m);
                        if (++n == 100) break;
                    }
                }
                yLast = y;
                ++i;
            }
        }
    }
}

