/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jspecview.common.Annotation;
import jspecview.common.AnnotationData;
import jspecview.common.AnnotationDialog;
import jspecview.common.Coordinate;
import jspecview.common.GraphSet;
import jspecview.common.Integral;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.PanelListener;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PlotWidget;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelData {
    private ArrayList<PanelListener> listeners = new ArrayList();
    private GraphSet currentGraphSet;
    Hashtable<ScriptToken, Object> options = new Hashtable();
    JSVPanel owner;
    List<GraphSet> graphSets;
    int currentSplitPoint;
    PlotWidget thisWidget;
    Coordinate coordClicked;
    Coordinate[] coordsClicked;
    static final int defaultPrintHeight = 450;
    static final int defaultPrintWidth = 280;
    static final int topMargin = 40;
    static final int bottomMargin = 50;
    static final int leftMargin = 60;
    static final int rightMargin = 50;
    boolean ctrlPressed;
    boolean shiftPressed;
    boolean drawXAxisLeftToRight;
    boolean isIntegralDrag;
    boolean xAxisLeftToRight = true;
    int scalingFactor = 1;
    int integralShiftMode;
    int left = 60;
    int right = 50;
    String coordStr = "";
    String startupPinTip = "Click to set.";
    String title;
    private int clickCount;
    private int nSpectra;
    int thisWidth;
    private int thisHeight;
    private int startIndex;
    private int endIndex;
    private String commonFilePath;
    private String viewTitle;
    private String displayFontName;
    private String titleFontName;
    boolean isPrinting;
    private boolean doReset = true;
    String printingFont;
    String printGraphPosition = "default";
    boolean titleDrawn;
    boolean display1D;
    boolean isLinked;
    String printJobTitle;
    List<JDXSpectrum> spectra;
    private Mouse mouseState;
    boolean gridOn;
    boolean titleOn;
    int mouseX;
    int mouseY;
    private boolean linking;

    PanelData(JSVPanel owner) {
        this.owner = owner;
    }

    public void addListener(PanelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    GraphSet getCurrentGraphSet() {
        return this.currentGraphSet;
    }

    void dispose() {
        this.owner = null;
        int i = 0;
        while (i < this.graphSets.size()) {
            this.graphSets.get(i).dispose();
            ++i;
        }
        this.graphSets = null;
        this.currentGraphSet = null;
        this.coordClicked = null;
        this.coordsClicked = null;
        this.thisWidget = null;
        this.options = null;
        this.listeners = null;
    }

    void setViewTitle(String title) {
        this.viewTitle = title;
    }

    String getViewTitle() {
        return this.viewTitle == null ? this.getTitle() : this.viewTitle;
    }

    Map<String, Object> getInfo(boolean selectedOnly, String key) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        ArrayList<Map<String, Object>> sets = null;
        if (selectedOnly) {
            return this.currentGraphSet.getInfo(key, this.getCurrentSpectrumIndex());
        }
        Set<Map.Entry<ScriptToken, Object>> entries = this.options.entrySet();
        for (Map.Entry<ScriptToken, Object> entry : entries) {
            Parameters.putInfo(key, info, entry.getKey().name(), entry.getValue());
        }
        Parameters.putInfo(key, info, "type", this.getSpectrumAt(0).getDataType());
        Parameters.putInfo(key, info, "title", this.title);
        Parameters.putInfo(key, info, "nSets", this.graphSets.size());
        sets = new ArrayList<Map<String, Object>>();
        int i = this.graphSets.size();
        while (--i >= 0) {
            sets.add(this.graphSets.get(i).getInfo(key, -1));
        }
        info.put("sets", sets);
        return info;
    }

    void setBoolean(Parameters parameters, ScriptToken st) {
        if (st == null) {
            Map<ScriptToken, Boolean> booleans = parameters.getBooleans();
            for (Map.Entry<ScriptToken, Boolean> entry : booleans.entrySet()) {
                this.setBoolean(parameters, entry.getKey());
            }
            return;
        }
        this.setBoolean(st, parameters.getBoolean(st));
    }

    public void setBoolean(ScriptToken st, boolean isTrue) {
        if (st == ScriptToken.REVERSEPLOT) {
            this.currentGraphSet.setReversePlot(isTrue);
            return;
        }
        this.options.put(st, isTrue);
        switch (st) {
            case DISPLAY1D: 
            case DISPLAY2D: {
                this.doReset = true;
            }
        }
    }

    public boolean getBoolean(ScriptToken st) {
        if (st == ScriptToken.REVERSEPLOT) {
            return this.currentGraphSet.reversePlot;
        }
        Object b = this.options.get((Object)st);
        return b != null && b instanceof Boolean && (Boolean)b == Boolean.TRUE;
    }

    void setFontName(ScriptToken st, String fontName) {
        switch (st) {
            case DISPLAYFONTNAME: {
                this.displayFontName = fontName;
                break;
            }
            case TITLEFONTNAME: {
                this.titleFontName = fontName;
            }
        }
        if (fontName != null) {
            this.options.put(st, fontName);
        }
    }

    public boolean getDisplay1D() {
        return this.display1D;
    }

    void initSingleSpectrum(JDXSpectrum spectrum) {
        this.spectra = new ArrayList<JDXSpectrum>();
        this.spectra.add(spectrum);
        this.initJSVPanel(this.spectra, 0, 0);
    }

    void initJSVPanel(List<JDXSpectrum> spectra, int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.owner.setupPlatform();
        this.nSpectra = spectra.size();
        this.spectra = spectra;
        this.commonFilePath = spectra.get(0).getFilePath();
        int i = 0;
        while (i < this.nSpectra) {
            if (!this.commonFilePath.equalsIgnoreCase(spectra.get(i).getFilePath())) {
                this.commonFilePath = null;
                break;
            }
            ++i;
        }
        this.setGraphSets(LinkMode.NONE);
    }

    private void setGraphSets(LinkMode linkMode) {
        this.graphSets = GraphSet.createGraphSetsAndSetLinkMode(this, this.owner, this.spectra, this.startIndex, this.endIndex, linkMode);
        this.currentGraphSet = this.graphSets.get(0);
        this.title = this.getSpectrum().getTitleLabel();
    }

    PeakInfo findMatchingPeakInfo(PeakInfo pi) {
        PeakInfo pi2 = null;
        int i = 0;
        while (i < this.graphSets.size()) {
            pi2 = this.graphSets.get(i).findMatchingPeakInfo(pi);
            if (pi2 != null) break;
            ++i;
        }
        return pi2;
    }

    public void integrateAll(Parameters parameters) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            this.graphSets.get(i).integrate(-1, parameters);
        }
    }

    public int getNumberOfGraphSets() {
        return this.graphSets.size();
    }

    String getTitle() {
        return this.title;
    }

    void refresh() {
        this.doReset = true;
    }

    void addAnnotation(List<String> tokens) {
        String title = this.currentGraphSet.addAnnotation(tokens, this.getTitle());
        if (title != null) {
            this.title = title;
        }
    }

    void addPeakHighlight(PeakInfo peakInfo) {
        int i = 0;
        while (i < this.graphSets.size()) {
            this.graphSets.get(i).addPeakHighlight(peakInfo);
            ++i;
        }
    }

    PeakInfo selectPeakByFileIndex(String filePath, String index) {
        PeakInfo pi = this.currentGraphSet.selectPeakByFileIndex(filePath, index);
        if (pi == null) {
            int i = this.graphSets.size();
            while (--i >= 0) {
                if (this.graphSets.get(i) != this.currentGraphSet && (pi = this.graphSets.get(i).selectPeakByFileIndex(filePath, index)) != null) break;
            }
        }
        return pi;
    }

    void selectSpectrum(String filePath, String type, String model, boolean andCurrent) {
        if (andCurrent) {
            this.currentGraphSet.selectSpectrum(filePath, type, model);
        }
        int i = 0;
        while (i < this.graphSets.size()) {
            if (this.graphSets.get(i) != this.currentGraphSet) {
                this.graphSets.get(i).selectSpectrum(filePath, type, model);
            }
            ++i;
        }
    }

    boolean hasFileLoaded(String filePath) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            if (!this.graphSets.get(i).hasFileLoaded(filePath)) continue;
            return true;
        }
        return false;
    }

    void clearAllView() {
        int i = this.graphSets.size();
        while (--i >= 0) {
            this.graphSets.get(i).clearAllViews();
        }
    }

    synchronized void drawGraph(Object g, int width, int height, boolean addFilePath) {
        boolean withCoords;
        this.display1D = !this.isLinked && this.getBoolean(ScriptToken.DISPLAY1D);
        int top = 40;
        int bottom = 50;
        if (this.isPrinting) {
            top *= 3;
            bottom *= 3;
            this.scalingFactor = 10;
            withCoords = false;
        } else {
            this.scalingFactor = 1;
            withCoords = this.getBoolean(ScriptToken.COORDINATESON);
            this.titleOn = this.getBoolean(ScriptToken.TITLEON);
            this.gridOn = this.getBoolean(ScriptToken.GRIDON);
        }
        boolean isResized = this.isPrinting || this.doReset || this.thisWidth != width || this.thisHeight != height;
        this.doReset = false;
        this.titleDrawn = false;
        this.thisWidth = width;
        this.thisHeight = height;
        int i = this.graphSets.size();
        while (--i >= 0) {
            this.graphSets.get(i).drawGraphSet(g, width, height, this.left, this.right, top, bottom, isResized);
        }
        if (this.titleOn && !this.titleDrawn) {
            this.owner.drawTitle(g, height * this.scalingFactor, width * this.scalingFactor, this.getDrawTitle(this.isPrinting));
        }
        if (withCoords) {
            this.owner.drawCoordinates(g, top);
        }
        if (addFilePath) {
            String s;
            String string = this.commonFilePath != null ? this.commonFilePath : (s = this.graphSets.size() == 1 && this.currentGraphSet.getTitle(true) != null ? this.getSpectrum().getFilePath() : null);
            if (s != null) {
                this.owner.printFilePath(g, this.left, height, s);
            }
        }
        if (this.isPrinting) {
            this.owner.printVersion(g, height);
        }
    }

    void selectFromEntireSet(int iSpec) {
        int i = 0;
        int pt = 0;
        while (i < this.graphSets.size()) {
            if (iSpec == Integer.MIN_VALUE) {
                this.graphSets.get(i).setSelected(-1);
            } else {
                List<JDXSpectrum> specs = this.graphSets.get((int)i).spectra;
                int j = 0;
                while (j < specs.size()) {
                    if (iSpec < 0 || iSpec == pt) {
                        this.graphSets.get(i).setSelected(j);
                    }
                    ++j;
                    ++pt;
                }
            }
            ++i;
        }
    }

    void addToList(int iSpec, List<JDXSpectrum> list) {
        int i = 0;
        while (i < this.spectra.size()) {
            if (iSpec < 0 || i == iSpec) {
                list.add(this.spectra.get(i));
            }
            ++i;
        }
    }

    void scaleSelectedBy(double f) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            this.graphSets.get(i).scaleSelectedBy(f);
        }
    }

    void setCurrentGraphSet(GraphSet gs, int yPixel, int clickCount) {
        int splitPoint = gs.getSplitPoint(yPixel);
        boolean isNewSet = this.currentGraphSet != gs;
        boolean isNewSplitPoint = isNewSet || this.currentSplitPoint != splitPoint;
        this.currentGraphSet = gs;
        this.currentSplitPoint = splitPoint;
        if (isNewSet || gs.nSplit > 1 && isNewSplitPoint) {
            this.setSpectrum(this.currentSplitPoint, true);
        }
        if (!isNewSet && !(isNewSet = gs.checkSpectrumClickedEvent(this.mouseX, this.mouseY, clickCount))) {
            return;
        }
        if (isNewSet || gs.nSplit > 1 && isNewSplitPoint) {
            this.setSpectrum(this.currentSplitPoint, true);
        }
        JDXSpectrum spec = gs.getSpectrum();
        this.notifySubSpectrumChange(spec.getSubIndex(), spec);
    }

    void splitStack(boolean doSplit) {
        this.currentGraphSet.splitStack(this.graphSets, doSplit);
    }

    public int getNumberOfSpectraInCurrentSet() {
        return this.currentGraphSet.nSpectra;
    }

    public int getStartingPointIndex(int index) {
        return this.currentGraphSet.viewData.getStartingPointIndex(index);
    }

    public int getEndingPointIndex(int index) {
        return this.currentGraphSet.viewData.getEndingPointIndex(index);
    }

    public String getSolutionColor() {
        return this.currentGraphSet.getSolutionColor();
    }

    boolean haveSelectedSpectrum() {
        return this.currentGraphSet.haveSelectedSpectrum();
    }

    boolean getShowAnnotation(Annotation.AType type) {
        return this.currentGraphSet.getShowAnnotation(type, -1);
    }

    void showAnnotation(Annotation.AType type, Boolean tfToggle) {
        this.currentGraphSet.setShowAnnotation(type, tfToggle);
    }

    void setYStackOffsetPercent(int offset) {
        this.currentGraphSet.yStackOffsetPercent = offset;
    }

    void setSpectrum(int iSpec, boolean isSplit) {
        this.currentGraphSet.setSpectrum(iSpec, isSplit);
    }

    public JDXSpectrum getSpectrum() {
        return this.currentGraphSet.getSpectrum();
    }

    void setSpectrum(JDXSpectrum spec) {
        JDXSpectrum spec0 = this.currentGraphSet.getSpectrum();
        this.currentGraphSet.setSpectrum(spec);
        int i = 0;
        while (i < this.spectra.size()) {
            if (this.spectra.get(i) == spec0) {
                this.spectra.set(i, spec);
            }
            ++i;
        }
    }

    boolean isShowAllStacked() {
        return this.currentGraphSet.showAllStacked;
    }

    public int getCurrentSpectrumIndex() {
        return this.currentGraphSet.getCurrentSpectrumIndex();
    }

    public JDXSpectrum getSpectrumAt(int index) {
        return this.currentGraphSet.getSpectrumAt(index);
    }

    void addHighlight(GraphSet gs, double x1, double x2, JDXSpectrum spec, int r, int g, int b, int a) {
        (gs == null ? this.currentGraphSet : gs).addHighlight(x1, x2, spec, this.owner.getColor(r, g, b, a));
    }

    void removeHighlight(double x1, double x2) {
        this.currentGraphSet.removeHighlight(x1, x2);
    }

    void removeAllHighlights() {
        this.currentGraphSet.removeAllHighlights();
    }

    public void setZoom(double x1, double y1, double x2, double y2) {
        this.currentGraphSet.setZoom(x1, y1, x2, y2);
        this.doReset = true;
        this.notifyListeners(new ZoomEvent(x1, y1, x2, y2));
    }

    void resetView() {
        this.currentGraphSet.resetView();
    }

    void previousView() {
        this.currentGraphSet.previousView();
    }

    void nextView() {
        this.currentGraphSet.nextView();
    }

    Integral getSelectedIntegral() {
        return this.currentGraphSet.getSelectedIntegral();
    }

    void advanceSubSpectrum(int dir) {
        this.currentGraphSet.advanceSubSpectrum(dir);
    }

    void setSelectedIntegral(double val) {
        this.currentGraphSet.setSelectedIntegral(val);
    }

    void scaleYBy(double f) {
        this.currentGraphSet.scaleYBy(f);
    }

    void toPeak(int i) {
        this.currentGraphSet.toPeak(i);
    }

    String getSolutionColorHtml() {
        String color = this.currentGraphSet.getSolutionColor();
        return "<html><body bgcolor=rgb(" + color + ")><br />Predicted Solution Colour- RGB(" + color + ")<br /><br /></body></html>";
    }

    Coordinate getClickedCoordinate() {
        return this.coordClicked;
    }

    public boolean getPickedCoordinates(Coordinate coord, Coordinate actualCoord) {
        return Coordinate.getPickedCoordinates(this.coordsClicked, this.coordClicked, coord, actualCoord);
    }

    boolean shiftSpectrum(double dx, double x1) {
        return this.currentGraphSet.shiftSpectrum(dx, x1);
    }

    void findX(JDXSpectrum spec, double d) {
        this.currentGraphSet.setXPointer(spec, d);
    }

    void findX2(JDXSpectrum spec, double d, JDXSpectrum spec2, double d2) {
        this.currentGraphSet.setXPointer(spec, d);
        this.currentGraphSet.setXPointer2(spec2, d2);
    }

    boolean isCurrentGraphSet(GraphSet graphSet) {
        return graphSet == this.currentGraphSet;
    }

    void repaint() {
        this.owner.doRepaint();
    }

    void setToolTipText(String s) {
        this.owner.setToolTipText(s);
    }

    Object getHighlightColor() {
        return this.owner.getColor(ScriptToken.HIGHLIGHTCOLOR);
    }

    void setHighlightColor(Object color) {
        this.owner.setColor(ScriptToken.HIGHLIGHTCOLOR, color);
    }

    String getInput(String message, String title, String sval) {
        return this.owner.getInput(message, title, sval);
    }

    void setFont(Object g, int width, int mode, int size, boolean isLabel) {
        this.owner.setFont(g, this.isPrinting ? this.printingFont : this.displayFontName, width, mode, size * this.scalingFactor, isLabel);
    }

    void notifySubSpectrumChange(int isub, JDXSpectrum spec) {
        this.notifyListeners(new SubSpecChangeEvent(isub, spec == null ? null : spec.getTitleLabel()));
    }

    void notifyPeakPickedListeners(PeakPickEvent p) {
        if (p == null) {
            p = new PeakPickEvent(this.owner, this.coordClicked, this.getSpectrum().getAssociatedPeakInfo(this.coordClicked));
        }
        this.notifyListeners(p);
    }

    void notifyListeners(Object eventObj) {
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.get(i) != null) {
                this.listeners.get(i).panelEvent(eventObj);
            }
            ++i;
        }
    }

    void escapeKeyPressed(boolean isDEL) {
        this.currentGraphSet.escapeKeyPressed(isDEL);
    }

    boolean hasFocus() {
        return this.owner.hasFocus();
    }

    boolean isMouseUp() {
        return this.mouseState == Mouse.UP;
    }

    void doMouseMoved(int xPixel, int yPixel) {
        this.mouseX = xPixel;
        this.mouseY = yPixel;
        this.mouseState = Mouse.UP;
        this.clickCount = 0;
        GraphSet gs = GraphSet.findGraphSet(this.graphSets, xPixel, yPixel);
        if (gs == null) {
            return;
        }
        gs.mouseMovedEvent(xPixel, yPixel);
    }

    void doMousePressed(int xPixel, int yPixel) {
        this.mouseState = Mouse.DOWN;
        GraphSet gs = GraphSet.findGraphSet(this.graphSets, xPixel, yPixel);
        if (gs == null) {
            return;
        }
        this.setCurrentGraphSet(gs, yPixel, 0);
        ++this.clickCount;
        gs.checkWidgetEvent(xPixel, yPixel, true);
    }

    void doMouseDragged(int xPixel, int yPixel) {
        this.isIntegralDrag |= this.ctrlPressed;
        this.mouseState = Mouse.DOWN;
        if (GraphSet.findGraphSet(this.graphSets, xPixel, yPixel) != this.currentGraphSet) {
            return;
        }
        this.currentGraphSet.checkWidgetEvent(xPixel, yPixel, false);
        this.currentGraphSet.mouseMovedEvent(xPixel, yPixel);
    }

    void doMouseReleased(boolean isButton1) {
        this.mouseState = Mouse.UP;
        if (this.thisWidget == null || !isButton1) {
            return;
        }
        this.currentGraphSet.mouseReleasedEvent();
        this.thisWidget = null;
        this.isIntegralDrag = false;
        this.integralShiftMode = 0;
    }

    void doMouseClicked(int xPixel, int yPixel, int clickCount, boolean isControlDown) {
        GraphSet gs = GraphSet.findGraphSet(this.graphSets, xPixel, yPixel);
        if (gs == null) {
            return;
        }
        this.setCurrentGraphSet(gs, yPixel, clickCount);
        gs.mouseClickedEvent(xPixel, yPixel, clickCount, isControlDown);
        this.repaint();
    }

    boolean hasCurrentMeasurements(Annotation.AType type) {
        return this.currentGraphSet.hasCurrentMeasurement(type);
    }

    AnnotationData getDialog(Annotation.AType type) {
        return this.currentGraphSet.getDialog(type, -1);
    }

    void addDialog(int iSpec, Annotation.AType type, AnnotationData dialog) {
        this.currentGraphSet.addDialog(iSpec, type, dialog);
    }

    void getPeakListing(Parameters p, Boolean tfToggle) {
        if (p != null) {
            this.currentGraphSet.getPeakListing(-1, p, true);
        }
        this.currentGraphSet.setPeakListing(tfToggle);
    }

    void checkIntegral(Parameters parameters, String value) {
        this.currentGraphSet.checkIntegral(parameters, value);
    }

    void setIntegrationRatios(String value) {
        this.currentGraphSet.setIntegrationRatios(value);
    }

    ScaleData getView() {
        return this.currentGraphSet.getCurrentView();
    }

    void closeAllDialogsExcept(Annotation.AType type) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            this.graphSets.get(i).closeDialogsExcept(type);
        }
    }

    void removeDialog(AnnotationDialog dialog) {
        this.currentGraphSet.removeDialog(dialog);
    }

    void normalizeIntegral() {
        Integral integral = this.getSelectedIntegral();
        if (integral == null) {
            return;
        }
        String sValue = integral.getText();
        if (sValue.length() == 0) {
            sValue = "" + integral.getValue();
        }
        String newValue = this.getInput("Enter a new value for this integral", "Normalize Integral", sValue);
        try {
            this.setSelectedIntegral(Double.parseDouble(newValue));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getDrawTitle(boolean isPrinting) {
        String title = null;
        if (isPrinting) {
            title = this.printJobTitle;
        } else if (this.nSpectra == 1) {
            title = this.getSpectrum().getPeakTitle();
        } else if (this.viewTitle != null) {
            if (this.currentGraphSet.getTitle(false) != null) {
                title = this.getSpectrum().getPeakTitle();
            }
            if (title == null) {
                title = this.viewTitle;
            }
        } else {
            title = this.owner.getTitle().trim();
        }
        if (title.indexOf("\n") >= 0) {
            title = title.substring(0, title.indexOf("\n")).trim();
        }
        return title;
    }

    String getPrintJobTitle(boolean isPrinting) {
        String title = null;
        if (this.nSpectra == 1) {
            title = this.getSpectrum().getTitle();
        } else if (this.viewTitle != null) {
            if (this.graphSets.size() == 1) {
                title = this.currentGraphSet.getTitle(isPrinting);
            }
            if (title == null) {
                title = this.viewTitle;
            }
        } else {
            title = this.owner.getTitle().trim();
        }
        if (title.indexOf("\n") >= 0) {
            title = title.substring(0, title.indexOf("\n")).trim();
        }
        return title;
    }

    synchronized void linkSpectra(LinkMode mode) {
        if (mode == LinkMode.ALL) {
            LinkMode linkMode = this.nSpectra == 2 ? LinkMode.AB : (mode = this.nSpectra == 3 ? LinkMode.ABC : LinkMode.NONE);
        }
        if (mode != LinkMode.NONE && mode.toString().length() != this.nSpectra) {
            return;
        }
        this.setGraphSets(mode);
    }

    void doZoomLinked(GraphSet graphSet, double initX, double finalX, boolean addZoom, boolean checkRange, boolean is1d) {
        if (this.linking) {
            return;
        }
        this.linking = true;
        JDXSpectrum spec = graphSet.getSpectrumAt(0);
        int i = this.graphSets.size();
        while (--i >= 0) {
            GraphSet gs = this.graphSets.get(i);
            if (gs == graphSet || !JDXSpectrum.areXScalesCompatible(spec, this.graphSets.get(i).getSpectrumAt(0), false, true)) continue;
            gs.doZoom(initX, 0.0, finalX, 0.0, is1d, false, checkRange, false, addZoom);
        }
        this.linking = false;
    }

    void clearLinkViews(GraphSet graphSet) {
        if (this.linking) {
            return;
        }
        this.linking = true;
        JDXSpectrum spec = graphSet.getSpectrum();
        int i = this.graphSets.size();
        while (--i >= 0) {
            GraphSet gs = this.graphSets.get(i);
            if (gs == graphSet || !JDXSpectrum.areXScalesCompatible(spec, this.graphSets.get(i).getSpectrum(), false, true)) continue;
            gs.clearViews();
        }
        this.linking = false;
    }

    void setlinkedXMove(GraphSet graphSet, double x, boolean isX2) {
        if (this.linking) {
            return;
        }
        this.linking = true;
        JDXSpectrum spec = graphSet.getSpectrum();
        int i = this.graphSets.size();
        while (--i >= 0) {
            GraphSet gs = this.graphSets.get(i);
            if (gs == graphSet || !JDXSpectrum.areXScalesCompatible(spec, this.graphSets.get(i).getSpectrum(), false, true) || gs.imageView != null) continue;
            if (isX2) {
                gs.setXPixelMovedTo(Double.MAX_VALUE, x, 0, 0);
                continue;
            }
            gs.setXPixelMovedTo(x, Double.MAX_VALUE, 0, 0);
        }
        this.linking = false;
    }

    void set2DCrossHairsLinked(GraphSet graphSet, double x, double y, boolean isLocked) {
        if (Math.abs(x - y) < 0.1) {
            y = Double.MAX_VALUE;
            x = Double.MAX_VALUE;
        }
        int i = this.graphSets.size();
        while (--i >= 0) {
            GraphSet gs = this.graphSets.get(i);
            if (gs == graphSet) continue;
            gs.set2DXY(x, y, isLocked);
        }
    }

    void dialogsToFront() {
        this.currentGraphSet.dialogsToFront();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LinkMode {
        ALL,
        NONE,
        AB,
        ABC;


        static LinkMode getMode(String abc) {
            if (abc.equals("*")) {
                return ALL;
            }
            LinkMode[] linkModeArray = LinkMode.values();
            int n = linkModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LinkMode mode = linkModeArray[n2];
                if (mode.name().equalsIgnoreCase(abc)) {
                    return mode;
                }
                ++n2;
            }
            return NONE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mouse {
        UP,
        DOWN;

    }
}

