/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import jspecview.common.Annotation;
import jspecview.common.AnnotationData;
import jspecview.common.AnnotationDialog;
import jspecview.common.AwtAnnotationDialog;
import jspecview.common.AwtGraphSet;
import jspecview.common.AwtIntegralListDialog;
import jspecview.common.AwtMeasurementListDialog;
import jspecview.common.AwtParameters;
import jspecview.common.AwtPeakListDialog;
import jspecview.common.AwtPopupMenu;
import jspecview.common.GraphSet;
import jspecview.common.Interface;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.JSVersion;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.PdfCreatorInterface;
import jspecview.common.PrintLayout;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.export.Exporter;
import jspecview.util.Logger;
import jspecview.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwtPanel
extends JPanel
implements JSVPanel,
Printable,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private AwtPopupMenu popup;
    private ScriptInterface si;
    public PanelData pd;
    private Color coordinatesColor;
    private Color gridColor;
    private Color integralPlotColor;
    private Color peakTabColor;
    private Color plotAreaColor;
    private Color scaleColor;
    private Color titleColor;
    private Color unitsColor;
    private Color highlightColor = new Color(255, 0, 0, 200);
    private Color zoomBoxColor = new Color(150, 150, 100, 130);
    private Color zoomBoxColor2 = new Color(150, 100, 100, 130);
    private static int MAC_COMMAND = 20;

    public void finalize() {
        Logger.info("JSVPanel " + this + " finalized");
    }

    @Override
    public PanelData getPanelData() {
        return this.pd;
    }

    @Override
    public String getTitle() {
        return this.pd.getTitle();
    }

    @Override
    public AwtPopupMenu getPopup() {
        return this.popup;
    }

    @Override
    public void dispose() {
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
        if (this.pd != null) {
            this.pd.dispose();
        }
        this.pd = null;
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    @Override
    public void setTitle(String title) {
        this.pd.title = title;
        this.setName(title);
    }

    @Override
    public void setPlotColors(Object oColors) {
        Color[] colors = (Color[])oColors;
        int i = this.pd.graphSets.size();
        while (--i >= 0) {
            this.pd.graphSets.get(i).setPlotColors(colors);
        }
    }

    @Override
    public void setColorOrFont(Parameters ds, ScriptToken st) {
        if (st == null) {
            Map<ScriptToken, Object> colors = ds.getColors();
            for (Map.Entry<ScriptToken, Object> entry : colors.entrySet()) {
                this.setColorOrFont(ds, entry.getKey());
            }
            this.setColorOrFont(ds, ScriptToken.DISPLAYFONTNAME);
            this.setColorOrFont(ds, ScriptToken.TITLEFONTNAME);
            return;
        }
        switch (st) {
            case DISPLAYFONTNAME: {
                this.pd.setFontName(st, ds.getDisplayFont());
                return;
            }
            case TITLEFONTNAME: {
                this.pd.setFontName(st, ds.getTitleFont());
                return;
            }
        }
        this.setColor(st, ds.getColor(st));
    }

    @Override
    public void setColor(ScriptToken st, Object oColor) {
        Color color = (Color)oColor;
        if (color != null) {
            this.pd.options.put(st, AwtParameters.colorToHexString(color));
        }
        switch (st) {
            case BACKGROUNDCOLOR: {
                this.setBackground(color);
                break;
            }
            case COORDINATESCOLOR: {
                this.coordinatesColor = color;
                break;
            }
            case GRIDCOLOR: {
                this.gridColor = color;
                break;
            }
            case HIGHLIGHTCOLOR: {
                this.highlightColor = color;
                break;
            }
            case INTEGRALPLOTCOLOR: {
                this.integralPlotColor = color;
                break;
            }
            case PEAKTABCOLOR: {
                this.peakTabColor = color;
                break;
            }
            case PLOTCOLOR: {
                int i = this.pd.graphSets.size();
                while (--i >= 0) {
                    this.pd.graphSets.get(i).setPlotColor0(color);
                }
                break;
            }
            case PLOTAREACOLOR: {
                this.plotAreaColor = color;
                break;
            }
            case SCALECOLOR: {
                this.scaleColor = color;
                break;
            }
            case TITLECOLOR: {
                this.titleColor = color;
                break;
            }
            case UNITSCOLOR: {
                this.unitsColor = color;
                break;
            }
            case ZOOMBOXCOLOR: {
                this.zoomBoxColor = color;
                break;
            }
            case ZOOMBOXCOLOR2: {
                this.zoomBoxColor2 = color;
                break;
            }
            default: {
                Logger.warn("AwtPanel --- unrecognized color: " + (Object)((Object)st));
            }
        }
    }

    public AwtPanel(ScriptInterface si, JDXSpectrum spectrum, AwtPopupMenu popup) {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        this.si = si;
        this.pd = new PanelData(this);
        this.popup = popup;
        this.pd.initSingleSpectrum(spectrum);
    }

    @Override
    public JSVPanel getNewPanel(ScriptInterface si, JDXSpectrum spectrum) {
        return new AwtPanel(si, spectrum, this.popup);
    }

    public static AwtPanel getJSVPanel(ScriptInterface si, List<JDXSpectrum> specs, int startIndex, int endIndex, AwtPopupMenu popup) {
        return new AwtPanel(si, specs, startIndex, endIndex, popup);
    }

    private AwtPanel(ScriptInterface si, List<JDXSpectrum> spectra, int startIndex, int endIndex, AwtPopupMenu popup) {
        this.pd = new PanelData(this);
        this.si = si;
        this.popup = popup;
        this.pd.initJSVPanel(spectra, startIndex, endIndex);
    }

    public static AwtPanel getNewPanel(ScriptInterface si, JDXSpectrum spec, AwtPopupMenu jsvpPopupMenu) {
        return new AwtPanel(si, spec, jsvpPopupMenu);
    }

    @Override
    public GraphSet getNewGraphSet() {
        return new AwtGraphSet(this);
    }

    @Override
    public Color getPlotColor(int index) {
        return ((AwtGraphSet)this.pd.getCurrentGraphSet()).getPlotColor(index);
    }

    @Override
    public Color getColor(int r, int g, int b, int a) {
        return new Color(r, g, b, a);
    }

    @Override
    public Color getColor(ScriptToken whatColor) {
        switch (whatColor) {
            default: {
                Logger.error("awtgraphset missing color " + (Object)((Object)whatColor));
                return Color.BLACK;
            }
            case ZOOMBOXCOLOR2: {
                return this.zoomBoxColor2;
            }
            case ZOOMBOXCOLOR: {
                return this.zoomBoxColor;
            }
            case HIGHLIGHTCOLOR: {
                return this.highlightColor;
            }
            case INTEGRALPLOTCOLOR: {
                return this.integralPlotColor;
            }
            case GRIDCOLOR: {
                return this.gridColor;
            }
            case PEAKTABCOLOR: {
                return this.peakTabColor;
            }
            case PLOTAREACOLOR: {
                return this.plotAreaColor;
            }
            case SCALECOLOR: {
                return this.scaleColor;
            }
            case TITLECOLOR: {
                return this.titleColor;
            }
            case UNITSCOLOR: 
        }
        return this.unitsColor;
    }

    @Override
    public void doRepaint() {
        if (!this.pd.isPrinting) {
            this.si.requestRepaint();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.si == null || this.pd == null || this.pd.graphSets == null || this.pd.isPrinting) {
            return;
        }
        super.paintComponent(g);
        this.pd.drawGraph(g, this.getWidth(), this.getHeight(), false);
        this.si.repaintCompleted();
    }

    @Override
    public void setFont(Object g, String name, int width, int mode, int size, boolean isLabel) {
        if (isLabel) {
            if (width < 400) {
                size = width * size / 400;
            }
        } else if (width < 250) {
            size = width * size / 250;
        }
        ((Graphics)g).setFont(new Font(name, mode, size));
    }

    @Override
    public void drawCoordinates(Object og, int top) {
        if (this.pd.coordStr == null) {
            return;
        }
        Graphics g = (Graphics)og;
        g.setColor(this.coordinatesColor);
        this.pd.setFont(g, this.getWidth(), 0, 12, true);
        FontMetrics fm = g.getFontMetrics();
        g.drawString(this.pd.coordStr, this.pd.thisWidth - this.pd.right - fm.stringWidth(this.pd.coordStr), top - 20);
    }

    @Override
    public void printFilePath(Object og, int x, int y, String s) {
        x *= this.pd.scalingFactor;
        y *= this.pd.scalingFactor;
        if (s.indexOf("?") > 0) {
            s = s.substring(s.indexOf("?") + 1);
        }
        s = s.substring(s.lastIndexOf("/") + 1);
        s = s.substring(s.lastIndexOf("\\") + 1);
        Graphics g = (Graphics)og;
        g.setColor(Color.BLACK);
        this.pd.setFont(g, 1000, 0, 9, true);
        FontMetrics fm = g.getFontMetrics();
        if (x != this.pd.left * this.pd.scalingFactor) {
            x -= fm.stringWidth(s);
        }
        g.drawString(s, x, y - fm.getHeight());
    }

    @Override
    public void printVersion(Object og, int pageHeight) {
        Graphics g = (Graphics)og;
        g.setColor(Color.BLACK);
        this.pd.setFont(g, 1000, 0, 9, true);
        FontMetrics fm = g.getFontMetrics();
        String s = String.valueOf(DateFormat.getInstance().format(new Date())) + " JSpecView " + JSVersion.VERSION_SHORT;
        int w = fm.stringWidth(s);
        g.drawString(s, (this.pd.thisWidth - this.pd.right) * this.pd.scalingFactor - w, pageHeight * this.pd.scalingFactor - fm.getHeight());
    }

    @Override
    public void drawTitle(Object og, int pageHeight, int pageWidth, String title) {
        title = title.replace('\n', ' ');
        Graphics g = (Graphics)og;
        this.pd.setFont(g, pageWidth, this.pd.isPrinting || this.pd.getBoolean(ScriptToken.TITLEBOLDON) ? 1 : 0, 14, true);
        FontMetrics fm = g.getFontMetrics();
        int nPixels = fm.stringWidth(title);
        if (nPixels > pageWidth) {
            int size = (int)(14.0 * (double)pageWidth / (double)nPixels);
            if (size < 10) {
                size = 10;
            }
            this.pd.setFont(g, pageWidth, this.pd.isPrinting || this.pd.getBoolean(ScriptToken.TITLEBOLDON) ? 1 : 0, size, true);
            fm = g.getFontMetrics();
        }
        g.setColor(this.titleColor);
        g.drawString(title, this.pd.isPrinting ? this.pd.left * this.pd.scalingFactor : 5, pageHeight - (int)((double)fm.getHeight() * (this.pd.isPrinting ? 2.0 : 0.5)));
    }

    private void createPdfDocument(OutputStream os, PrintLayout pl) {
        PdfCreatorInterface pdfCreator = (PdfCreatorInterface)Interface.getInterface("jspecview.common.PdfCreator");
        if (pdfCreator == null) {
            return;
        }
        pdfCreator.createPdfDocument(this, pl, os);
    }

    public void printPanel(PrintLayout pl, OutputStream os, String title) {
        this.pd.printingFont = os == null ? pl.font : "Helvetica";
        this.pd.printGraphPosition = pl.position;
        boolean gridOn = this.pd.gridOn;
        boolean titleOn = this.pd.titleOn;
        boolean xScaleOn = this.pd.getBoolean(ScriptToken.XSCALEON);
        boolean xUnitsOn = this.pd.getBoolean(ScriptToken.XUNITSON);
        boolean yScaleOn = this.pd.getBoolean(ScriptToken.YSCALEON);
        boolean yUnitsOn = this.pd.getBoolean(ScriptToken.YUNITSON);
        this.pd.gridOn = pl.showGrid;
        this.pd.titleOn = pl.showTitle;
        this.pd.setBoolean(ScriptToken.XSCALEON, pl.showXScale);
        this.pd.setBoolean(ScriptToken.XUNITSON, pl.showXScale);
        this.pd.setBoolean(ScriptToken.YSCALEON, pl.showYScale);
        this.pd.setBoolean(ScriptToken.YUNITSON, pl.showYScale);
        PrinterJob pj = os == null ? PrinterJob.getPrinterJob() : null;
        this.pd.printJobTitle = title;
        if (title.length() > 30) {
            title = title.substring(0, 30);
        }
        if (pj != null) {
            pj.setJobName(title);
            pj.setPrintable(this);
        }
        if (pj == null || pj.printDialog()) {
            try {
                if (pj == null) {
                    this.createPdfDocument(os, pl);
                } else {
                    HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                    aset.add(pl.layout.equals("landscape") ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
                    aset.add(pl.paper);
                    pj.print(aset);
                }
            }
            catch (PrinterException ex) {
                String s = ex.getMessage();
                if (s == null) {
                    return;
                }
                s = TextFormat.simpleReplace(s, "not accepting job.", "not accepting jobs.");
                this.showMessage(s, "Printer Error");
            }
        }
        this.pd.gridOn = gridOn;
        this.pd.titleOn = titleOn;
        this.pd.setBoolean(ScriptToken.XSCALEON, xScaleOn);
        this.pd.setBoolean(ScriptToken.XUNITSON, xUnitsOn);
        this.pd.setBoolean(ScriptToken.YSCALEON, yScaleOn);
        this.pd.setBoolean(ScriptToken.YUNITSON, yUnitsOn);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi == 0) {
            double width;
            double height;
            Graphics2D g2D = (Graphics2D)g;
            this.pd.isPrinting = true;
            boolean addFilePath = false;
            if (this.pd.printGraphPosition.equals("default")) {
                g2D.translate(pf.getImageableX(), pf.getImageableY());
                if (pf.getOrientation() == 1) {
                    height = 450.0;
                    width = 280.0;
                } else {
                    height = 280.0;
                    width = 450.0;
                }
            } else if (this.pd.printGraphPosition.equals("fit to page")) {
                g2D.translate(pf.getImageableX(), pf.getImageableY());
                addFilePath = true;
                height = pf.getImageableHeight();
                width = pf.getImageableWidth();
            } else {
                int y;
                int x;
                Paper paper = pf.getPaper();
                double paperHeight = paper.getHeight();
                double paperWidth = paper.getWidth();
                if (pf.getOrientation() == 1) {
                    height = 450.0;
                    width = 280.0;
                    x = (int)(paperWidth - width) / 2;
                    y = (int)(paperHeight - height) / 2;
                } else {
                    height = 280.0;
                    width = 450.0;
                    y = (int)(paperWidth - 280.0) / 2;
                    x = (int)(paperHeight - 450.0) / 2;
                }
                g2D.translate(x, y);
            }
            g2D.scale(0.1, 0.1);
            this.pd.drawGraph(g2D, (int)width, (int)height, addFilePath);
            this.pd.isPrinting = false;
            return 0;
        }
        this.pd.isPrinting = false;
        return 1;
    }

    @Override
    public void setupPlatform() {
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        if (this.popup == null) {
            this.pd.coordStr = "(0,0)";
        } else {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    public String export(String type, int n) {
        if (type == null) {
            type = "XY";
        }
        if (n < -1 || this.pd.getNumberOfSpectraInCurrentSet() <= n) {
            return "only " + this.pd.getNumberOfSpectraInCurrentSet() + " spectra available.";
        }
        try {
            JDXSpectrum spec = n < 0 ? this.pd.getSpectrum() : this.pd.getSpectrumAt(n);
            return Exporter.exportTheSpectrum(Exporter.ExportType.getType(type), null, spec, 0, spec.getXYCoords().length - 1);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.pd.getSpectrumAt(0).toString();
    }

    @Override
    public String getInput(String message, String title, String sval) {
        String ret = (String)JOptionPane.showInputDialog(this, message, title, 3, null, null, sval);
        this.getFocusNow(true);
        return ret;
    }

    @Override
    public void showMessage(String msg, String title) {
        Logger.info(msg);
        JOptionPane.showMessageDialog(this, msg, title, msg.startsWith("<html>") ? 1 : -1);
        this.getFocusNow(true);
    }

    @Override
    public void showHeader(Object jsvApplet) {
        JDXSpectrum spectrum = this.pd.getSpectrum();
        Object[][] rowData = spectrum.getHeaderRowDataAsArray();
        Object[] columnNames = new String[]{"Label", "Description"};
        JTable table = new JTable(rowData, columnNames);
        table.setPreferredScrollableViewportSize(new Dimension(400, 195));
        JScrollPane scrollPane = new JScrollPane(table);
        JOptionPane.showMessageDialog((Container)jsvApplet, scrollPane, "Header Information", -1);
        this.getFocusNow(true);
    }

    @Override
    public AnnotationDialog showDialog(Annotation.AType type) {
        AwtAnnotationDialog dialog = null;
        AnnotationData ad = this.pd.getDialog(type);
        this.pd.closeAllDialogsExcept(type);
        if (ad != null && ad instanceof AwtAnnotationDialog) {
            ((AwtAnnotationDialog)ad).reEnable();
            return (AnnotationDialog)ad;
        }
        int iSpec = this.pd.getCurrentSpectrumIndex();
        if (iSpec < 0) {
            this.showMessage("To enable " + (Object)((Object)type) + " first select a spectrum by clicking on it.", "" + (Object)((Object)type));
            return null;
        }
        JDXSpectrum spec = this.pd.getSpectrum();
        switch (type) {
            case Integration: {
                dialog = new AwtIntegralListDialog("Integration for " + spec, this.si, spec, this);
                break;
            }
            case Measurements: {
                dialog = new AwtMeasurementListDialog("Measurements for " + spec, this.si, spec, this);
                break;
            }
            case PeakList: {
                dialog = new AwtPeakListDialog("Peak List for " + spec, this.si, spec, this);
            }
        }
        if (ad != null) {
            dialog.setData(ad);
        }
        this.pd.addDialog(iSpec, type, dialog);
        dialog.reEnable();
        return dialog;
    }

    @Override
    public void getFocusNow(boolean asThread) {
        if (asThread) {
            SwingUtilities.invokeLater(new RequestThread());
        } else {
            this.requestFocusInWindow();
        }
        this.pd.dialogsToFront();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.pd.isPrinting) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.pd.doMousePressed(e.getX(), e.getY());
    }

    private boolean isControlDown(InputEvent e) {
        this.pd.ctrlPressed = this.pd.ctrlPressed | (e.isControlDown() || (e.getModifiers() & MAC_COMMAND) == MAC_COMMAND);
        return this.pd.ctrlPressed;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.pd.isPrinting) {
            return;
        }
        this.getFocusNow(false);
        if (e.getButton() != 0) {
            this.mouseDragged(e);
            return;
        }
        this.pd.doMouseMoved(e.getX(), e.getY());
        if (this.pd.coordStr != null) {
            this.doRepaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pd.isPrinting) {
            return;
        }
        this.pd.doMouseDragged(e.getX(), e.getY());
        this.doRepaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.pd.isPrinting) {
            return;
        }
        this.pd.doMouseReleased(e.getButton() == 1);
        this.doRepaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.pd.isPrinting) {
            return;
        }
        if (e.getButton() == 3) {
            this.popup.show(this, e.getX(), e.getY());
            return;
        }
        this.pd.doMouseClicked(e.getX(), e.getY(), e.getClickCount(), e.isControlDown());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.getFocusNow(false);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.pd.thisWidget = null;
        this.pd.isIntegralDrag = false;
        this.pd.integralShiftMode = 0;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.pd.isPrinting) {
            return;
        }
        this.checkControl(e, true);
        switch (e.getKeyCode()) {
            case 8: 
            case 27: 
            case 127: {
                this.pd.escapeKeyPressed(e.getKeyCode() != 27);
                this.pd.isIntegralDrag = false;
                this.doRepaint();
                e.consume();
                return;
            }
        }
        int code = e.getKeyCode();
        if (e.getModifiers() != 0) {
            if (e.isControlDown()) {
                switch (code) {
                    case 38: 
                    case 40: 
                    case 45: 
                    case 61: {
                        this.pd.scaleYBy(code == 61 || code == 38 ? GraphSet.RT2 : 1.0 / GraphSet.RT2);
                        e.consume();
                        break;
                    }
                    case 37: 
                    case 39: {
                        this.pd.toPeak(code == 39 ? 1 : -1);
                        e.consume();
                    }
                }
            }
            return;
        }
        switch (code) {
            case 37: 
            case 39: {
                this.pd.doMouseMoved(code == 39 ? (this.pd.mouseX = this.pd.mouseX + 1) : (this.pd.mouseX = this.pd.mouseX - 1), this.pd.mouseY);
                e.consume();
                this.doRepaint();
                break;
            }
            case 38: 
            case 40: {
                int dir;
                int n = dir = code == 40 ? -1 : 1;
                if (this.pd.getSpectrumAt(0).getSubSpectra() == null) {
                    this.pd.notifySubSpectrumChange(dir, null);
                } else {
                    this.pd.advanceSubSpectrum(dir);
                    this.doRepaint();
                }
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.pd.isPrinting) {
            return;
        }
        this.checkControl(e, false);
    }

    private void checkControl(KeyEvent e, boolean isPressed) {
        switch (e.getKeyCode()) {
            case 17: 
            case 157: {
                this.pd.ctrlPressed = isPressed;
                break;
            }
            case 16: {
                this.pd.shiftPressed = isPressed;
                break;
            }
            default: {
                this.pd.ctrlPressed = this.isControlDown(e);
                this.pd.shiftPressed = e.isShiftDown();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.pd.isPrinting) {
            return;
        }
        if (e.getKeyChar() == 'n') {
            this.pd.normalizeIntegral();
            this.doRepaint();
            e.consume();
            return;
        }
        if (e.getKeyChar() == 'z') {
            this.pd.previousView();
            e.consume();
            return;
        }
        if (e.getKeyChar() == 'y') {
            this.pd.nextView();
            e.consume();
            return;
        }
    }

    public class RequestThread
    implements Runnable {
        public void run() {
            AwtPanel.this.requestFocusInWindow();
        }
    }
}

