/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javax.vecmath.Point3f;
import org.jmol.util.SimpleUnitCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SymmetryInfo {
    boolean coordinatesAreFractional;
    boolean isMultiCell;
    String spaceGroup;
    String[] symmetryOperations;
    String symmetryInfoString;
    int[] cellRange;
    private Point3f periodicOriginXyz;

    boolean isPeriodic() {
        return this.periodicOriginXyz != null;
    }

    SymmetryInfo() {
    }

    float[] setSymmetryInfo(Map<String, Object> map) {
        this.cellRange = (int[])map.get("unitCellRange");
        this.periodicOriginXyz = (Point3f)map.get("periodicOriginXyz");
        this.spaceGroup = (String)map.get("spaceGroup");
        if (this.spaceGroup == null || this.spaceGroup == "") {
            this.spaceGroup = "spacegroup unspecified";
        }
        int n = map.containsKey("symmetryCount") ? (Integer)map.get("symmetryCount") : 0;
        this.symmetryOperations = (String[])map.get("symmetryOperations");
        this.symmetryInfoString = "Spacegroup: " + this.spaceGroup;
        if (this.symmetryOperations == null) {
            this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: ?\nSymmetry Operations: unspecified\n";
        } else {
            this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: " + (n == 0 ? 1 : n) + "\nSymmetry Operations:";
            for (int i = 0; i < n; ++i) {
                this.symmetryInfoString = this.symmetryInfoString + "\n" + this.symmetryOperations[i];
            }
        }
        this.symmetryInfoString = this.symmetryInfoString + "\n";
        float[] fArray = (float[])map.get("notionalUnitcell");
        if (!SimpleUnitCell.isValid((float[])fArray)) {
            return null;
        }
        this.coordinatesAreFractional = map.containsKey("coordinatesAreFractional") ? (Boolean)map.get("coordinatesAreFractional") : false;
        this.isMultiCell = this.coordinatesAreFractional && this.symmetryOperations != null;
        return fArray;
    }
}

