/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.openscience.jmol.app.surfacetool.Slice;

public class SurfaceStatus {
    String id;
    int kind;
    int color;
    boolean fillOn;
    int translucency;
    boolean meshOn;
    int meshColor;
    int meshTranslucency;
    int lighting;
    boolean frontonly;
    boolean show;
    boolean beenSliced;
    boolean capOn;
    boolean ghostOn;
    boolean foundDuringLastSync;
    Slice slice;

    public SurfaceStatus(Mesh mesh, int n) {
        this.id = mesh.thisID;
        this.kind = n;
        this.color = mesh.color;
        this.fillOn = mesh.fillTriangles;
        this.translucency = Graphics3D.getColixTranslucencyLevel(mesh.colix);
        this.meshOn = mesh.drawTriangles;
        this.meshColor = Graphics3D.getArgb(mesh.meshColix);
        this.meshTranslucency = 0;
        this.lighting = mesh.lighting;
        this.frontonly = mesh.frontOnly;
        this.beenSliced = false;
        this.capOn = false;
        this.ghostOn = false;
        this.foundDuringLastSync = true;
        this.slice = new Slice();
    }

    public void updateExisting(Mesh mesh) {
        this.color = mesh.color;
        this.fillOn = mesh.fillTriangles;
        this.translucency = Graphics3D.getColixTranslucencyLevel(mesh.colix);
        this.meshOn = mesh.drawTriangles;
        this.meshColor = Graphics3D.getArgb(mesh.meshColix);
        this.meshTranslucency = 0;
        this.lighting = mesh.lighting;
        this.frontonly = mesh.frontOnly;
        this.foundDuringLastSync = true;
    }
}

