/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import jspecview.application.MainFrame;
import org.jmol.api.JSVInterface;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolSyncInterface;
import org.jmol.api.JmolViewer;
import org.jmol.constant.EnumCallback;
import org.jmol.export.dialog.Dialog;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.AppConsole;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.webexport.WebExport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatusListener
implements JmolStatusListener,
JmolSyncInterface,
JSVInterface {
    private JmolPanel jmol;
    private DisplayPanel display;
    private JmolViewer viewer;
    private MainFrame jSpecViewFrame;
    private static String propertiesFileName = "jspecview.properties";

    void setViewer(JmolViewer jmolViewer) {
        this.viewer = jmolViewer;
    }

    StatusListener(JmolPanel jmolPanel, DisplayPanel displayPanel) {
        this.jmol = jmolPanel;
        this.display = displayPanel;
    }

    @Override
    public boolean notifyEnabled(EnumCallback enumCallback) {
        switch (enumCallback) {
            case ANIMFRAME: 
            case ECHO: 
            case LOADSTRUCT: 
            case MEASURE: 
            case MESSAGE: 
            case PICK: 
            case SCRIPT: 
            case SYNC: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyCallback(EnumCallback enumCallback, Object[] objectArray) {
        JmolCallbackListener jmolCallbackListener;
        String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
        switch (enumCallback) {
            case LOADSTRUCT: {
                this.notifyFileLoaded(string, (String)objectArray[2], (String)objectArray[3], (String)objectArray[4]);
                return;
            }
            case ANIMFRAME: {
                int[] nArray = (int[])objectArray[1];
                int n = nArray[0];
                if (n <= -2) {
                    n = -2 - n;
                }
                if (this.display.haveDisplay) {
                    String string2 = (String)objectArray[2];
                    this.display.status.setStatus(1, string2);
                    if (this.jmol.frame != null) {
                        this.jmol.frame.setTitle(string2);
                    }
                }
                return;
            }
            case SCRIPT: {
                int n = (Integer)objectArray[3];
                if (n == 0 && objectArray[2] != null && this.display.haveDisplay) {
                    this.display.status.setStatus(1, (String)objectArray[2]);
                }
                return;
            }
            case ECHO: {
                break;
            }
            case MEASURE: {
                String string3 = (String)objectArray[3];
                if (string3.indexOf("Sequence") >= 0) break;
                if (string3.indexOf("Pending") < 0 && this.display.haveDisplay) {
                    this.display.measurementTable.updateTables();
                }
                if (string3.indexOf("Picked") >= 0) {
                    this.notifyAtomPicked(string);
                    break;
                }
                if (string3.indexOf("Completed") >= 0) break;
                return;
            }
            case MESSAGE: {
                break;
            }
            case PICK: {
                this.notifyAtomPicked(string);
                break;
            }
            case SYNC: {
                if (string != null && string.toLowerCase().startsWith("jspecview")) {
                    this.setJSpecView(string.substring(9).trim());
                    return;
                }
                this.jmol.sendNioMessage((Integer)objectArray[3], string);
                return;
            }
            case ERROR: 
            case HOVER: 
            case MINIMIZATION: 
            case RESIZE: {
                return;
            }
        }
        if (this.jmol.service != null) {
            this.jmol.service.scriptCallback(string);
        }
        if ((jmolCallbackListener = (JmolCallbackListener)this.viewer.getProperty("DATA_API", "getAppConsole", null)) != null) {
            jmolCallbackListener.notifyCallback(enumCallback, objectArray);
        }
    }

    @Override
    public void setCallbackFunction(String string, String string2) {
        if (string.equals("modelkit")) {
            if (string2.equals("ON")) {
                this.display.buttonModelkit.setSelected(true);
            } else {
                this.display.buttonRotate.setSelected(true);
            }
            return;
        }
        if (string.equalsIgnoreCase("language")) {
            AppConsole appConsole;
            JmolResourceHandler.clear();
            Dialog.setupUIManager();
            if (this.jmol.webExport != null) {
                WebExport.saveHistory();
                WebExport.dispose();
                this.jmol.createWebExport();
            }
            if ((appConsole = (AppConsole)this.viewer.getProperty("DATA_API", "getAppConsole", null)) != null) {
                appConsole.sendConsoleEcho(null);
            }
            this.display.jmolPanel.updateLabels();
            return;
        }
    }

    @Override
    public String eval(String string) {
        String string2 = "# this funcationality is implemented only for the applet.\n" + string;
        this.sendConsoleMessage(string2);
        return string2;
    }

    @Override
    public String createImage(String string, String string2, Object object, int n) {
        return null;
    }

    private void notifyAtomPicked(String string) {
        if (this.display.haveDisplay) {
            this.display.status.setStatus(1, string);
        }
    }

    private void notifyFileLoaded(String string, String string2, String string3, String string4) {
        if (string4 != null) {
            return;
        }
        if (!this.display.haveDisplay) {
            return;
        }
        String string5 = "Jmol";
        if (string3 != null && string2 != null) {
            string5 = string2 + " - " + string3;
        } else if (string2 != null) {
            string5 = string2;
        } else if (string3 != null) {
            string5 = string3;
        }
        this.jmol.notifyFileOpen(string, string5);
        if (this.jSpecViewFrame != null) {
            if (string == null) {
                this.jSpecViewFrame.syncScript("close ALL");
            } else if (string.endsWith(".jdx")) {
                this.jSpecViewFrame.syncScript("load CHECK " + Escape.escape(string));
            }
        }
    }

    private void sendConsoleMessage(String string) {
        JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)this.viewer.getProperty("DATA_API", "getAppConsole", null);
        if (jmolAppConsoleInterface != null) {
            jmolAppConsoleInterface.sendConsoleMessage(string);
        }
    }

    @Override
    public void showUrl(String string) {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Method method = clazz.getMethod("getDesktop", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("browse", URI.class);
            Object[] objectArray = new Object[]{new URI(string)};
            method2.invoke(object, objectArray);
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
            JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)this.viewer.getProperty("DATA_API", "getAppConsole", null);
            if (jmolAppConsoleInterface != null) {
                jmolAppConsoleInterface.sendConsoleMessage("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
            }
            Logger.error("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
        }
    }

    @Override
    public float[][] functionXY(String string, int n, int n2) {
        n = Math.abs(n);
        n2 = Math.abs(n2);
        float[][] fArray = new float[n][n2];
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                float f = (float)n3 / 5.0f;
                float f2 = (float)n4 / 5.0f;
                fArray[n3][n4] = f * f + f2;
                if (!Float.isNaN(fArray[n3][n4])) continue;
                fArray[n3][n4] = -((float)Math.sqrt(-f * f - f2));
            }
        }
        return fArray;
    }

    @Override
    public float[][][] functionXYZ(String string, int n, int n2, int n3) {
        n = Math.abs(n);
        n2 = Math.abs(n2);
        n3 = Math.abs(n3);
        float[][][] fArray = new float[n][n2][n3];
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                int n6 = n3;
                while (--n6 >= 0) {
                    float f = (float)n4 / ((float)(n - 1) / 2.0f) - 1.0f;
                    float f2 = (float)n5 / ((float)(n2 - 1) / 2.0f) - 1.0f;
                    float f3 = (float)n6 / ((float)(n3 - 1) / 2.0f) - 1.0f;
                    fArray[n4][n5][n6] = f * f + f2 * f2 - f3 * f3;
                }
            }
        }
        return fArray;
    }

    @Override
    public Map<String, Object> getRegistryInfo() {
        return null;
    }

    @Override
    public void resizeInnerPanel(String string) {
        this.jmol.resizeInnerPanel(string);
    }

    public void setJSpecView(String string) {
        if (!this.display.isRotateMode()) {
            return;
        }
        if (string.startsWith(":")) {
            string = string.substring(1);
        }
        if (this.jSpecViewFrame == null) {
            String string2;
            this.jSpecViewFrame = new MainFrame((Component)this.viewer.getDisplay(), this);
            this.jSpecViewFrame.setSize(800, 500);
            this.jSpecViewFrame.setLocation(400, 400);
            this.jSpecViewFrame.register("Jmol", this);
            if (string.length() == 0 && (string2 = "" + this.viewer.getParameter("_modelfile")).indexOf("/") >= 0) {
                string = "hidden false; load " + Escape.escape(string2);
            }
        }
        if (!this.jSpecViewFrame.isVisible() && !string.toLowerCase().startsWith("hidden")) {
            this.jSpecViewFrame.awaken(true);
            this.display.setViewer(this.viewer);
        }
        if (string.length() == 0) {
            string = "HIDDEN false";
        }
        this.jSpecViewFrame.syncScript(string);
    }

    @Override
    public void register(String string, JmolSyncInterface jmolSyncInterface) {
    }

    @Override
    public void syncScript(String string) {
        this.jmol.syncScript(string);
    }

    @Override
    public void setProperties(Properties properties) {
        try {
            FileInputStream fileInputStream = new FileInputStream(propertiesFileName);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveProperties(Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(propertiesFileName);
            properties.store(fileOutputStream, "JSpecView Application Properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitJSpecView(boolean bl, Object object) {
    }

    @Override
    public void runScript(String string) {
        this.jSpecViewFrame.runScriptNow(string);
    }

    @Override
    public void syncToJmol(String string) {
    }

    @Override
    public Map<String, Object> getProperty(String string) {
        if (string.toLowerCase().startsWith("jspecview")) {
            if ((string = string.substring(9)).startsWith(":")) {
                string = string.substring(1);
            }
            return this.jSpecViewFrame == null ? null : this.jSpecViewFrame.getProperty(string);
        }
        return null;
    }
}

