/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.constant.EnumPalette;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ColorUtil;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    private ColorEncoder propertyColorEncoder = new ColorEncoder(null);
    private Viewer viewer;
    private Graphics3D g3d;
    private int[] argbsCpk;
    private int[] altArgbsCpk;
    private float[] colorData;
    private boolean isDefaultColorRasmol;
    short colixRubberband = (short)22;
    short colixBackgroundContrast;

    ColorManager(Viewer viewer, Graphics3D graphics3D) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.argbsCpk = EnumPalette.argbsCpk;
        this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
    }

    void clear() {
    }

    boolean getDefaultColorRasmol() {
        return this.isDefaultColorRasmol;
    }

    void resetElementColors() {
        this.setDefaultColors(false);
    }

    void setDefaultColors(boolean bl) {
        if (bl) {
            this.isDefaultColorRasmol = true;
            this.argbsCpk = (int[])ColorEncoder.getRasmolScale().clone();
        } else {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = EnumPalette.argbsCpk;
        }
        this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
        this.propertyColorEncoder.getColorScheme(bl ? "Rasmol=" : "Jmol=", true, true);
        int n = EnumPalette.argbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)n, this.argbsCpk[n]);
        }
        n = JmolConstants.altArgbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)(Elements.elementNumberMax + n), this.altArgbsCpk[n]);
        }
    }

    void setRubberbandArgb(int n) {
        this.colixRubberband = n == 0 ? (short)0 : Graphics3D.getColix(n);
    }

    void setColixBackgroundContrast(int n) {
        this.colixBackgroundContrast = (short)((ColorUtil.calcGreyscaleRgbFromRgb(n) & 0xFF) < 128 ? 8 : 4);
    }

    short getColixBondPalette(Bond bond, int n) {
        int n2 = 0;
        switch (n) {
            case 19: {
                return this.propertyColorEncoder.getColorIndexFromPalette(bond.getEnergy(), -2.5f, -0.5f, 7, false);
            }
        }
        return n2 == 0 ? (short)10 : (short)Graphics3D.getColix(n2);
    }

    short getColixAtomPalette(Atom atom, byte by) {
        int n = 0;
        switch (by) {
            case 84: {
                return this.colorData == null || atom.index >= this.colorData.length ? (short)12 : this.getColixForPropertyValue(this.colorData[atom.index]);
            }
            case 0: 
            case 1: {
                short s = atom.getAtomicAndIsotopeNumber();
                if (s < Elements.elementNumberMax) {
                    return this.g3d.getChangeableColix(s, this.argbsCpk[s]);
                }
                s = (short)Elements.altElementIndexFromNumber(s);
                return this.g3d.getChangeableColix((short)(Elements.elementNumberMax + s), this.altArgbsCpk[s]);
            }
            case 2: {
                int n2 = ColorEncoder.quantize(atom.getPartialCharge(), -1.0f, 1.0f, 31);
                return this.g3d.getChangeableColix((short)(JmolConstants.PARTIAL_CHARGE_COLIX_RED + n2), JmolConstants.argbsRwbScale[n2]);
            }
            case 3: {
                int n3 = atom.getFormalCharge() - -4;
                return this.g3d.getChangeableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + n3), JmolConstants.argbsFormalCharge[n3]);
            }
            case 5: 
            case 68: {
                float f;
                float f2;
                if (by == 68) {
                    ModelSet modelSet = this.viewer.getModelSet();
                    f2 = modelSet.getBfactor100Lo();
                    f = modelSet.getBfactor100Hi();
                } else {
                    f2 = 0.0f;
                    f = 10000.0f;
                }
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getBfactor100(), f2, f, 7, false);
            }
            case 86: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getGroupParameter(1112539148), -1.0f, 1.0f, 7, false);
            }
            case 70: {
                float f = this.viewer.getSurfaceDistanceMax();
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getSurfaceDistance100(), 0.0f, f, 7, false);
            }
            case 8: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 5, false);
            }
            case 9: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 4, false);
            }
            case 75: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getSelectedGroupIndexWithinChain(), 0.0f, atom.getSelectedGroupCountWithinChain() - 1, 1, false);
            }
            case 87: {
                Model model = this.viewer.getModelSet().getModels()[atom.modelIndex];
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getPolymerIndexInModel(), 0.0f, model.getBioPolymerCount() - 1, 1, false);
            }
            case 76: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getSelectedMonomerIndexWithinPolymer(), 0.0f, atom.getSelectedMonomerCountWithinPolymer() - 1, 1, false);
            }
            case 77: {
                ModelSet modelSet = this.viewer.getModelSet();
                return this.propertyColorEncoder.getColorIndexFromPalette(modelSet.getMoleculeIndex(atom.getIndex(), true), 0.0f, modelSet.getMoleculeCountInModel(atom.getModelIndex()) - 1, 0, false);
            }
            case 14: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n4 = atom.getModelIndex();
                return this.propertyColorEncoder.getColorIndexFromPalette(modelSet.getAltLocIndexInModel(n4, atom.getAlternateLocationID()), 0.0f, modelSet.getAltLocCountInModel(n4), 0, false);
            }
            case 15: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n5 = atom.getModelIndex();
                return this.propertyColorEncoder.getColorIndexFromPalette(modelSet.getInsertionCodeIndexInModel(n5, atom.getInsertionCode()), 0.0f, modelSet.getInsertionCountInModel(n5), 0, false);
            }
            case 16: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = this.getJmolOrRasmolArgb(s, 1073741992);
                break;
            }
            case 17: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = this.getJmolOrRasmolArgb(s, 1073742116);
                break;
            }
            case 7: {
                n = atom.getProteinStructureSubType().getColor();
                break;
            }
            case 10: {
                int n6 = atom.getChainID() & 0x1F;
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 >= JmolConstants.argbsChainAtom.length) {
                    n6 %= JmolConstants.argbsChainAtom.length;
                }
                n = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[n6];
            }
        }
        return n == 0 ? (short)22 : (short)Graphics3D.getColix(n);
    }

    private int getJmolOrRasmolArgb(int n, int n2) {
        switch (n2) {
            case 1073741992: {
                if (n >= Elements.elementNumberMax) break;
                return this.propertyColorEncoder.getArgbFromPalette(n, 0.0f, 0.0f, 2);
            }
            case 1073742116: {
                if (n >= Elements.elementNumberMax) break;
                return this.propertyColorEncoder.getArgbFromPalette(n, 0.0f, 0.0f, 3);
            }
            default: {
                return n2;
            }
        }
        return JmolConstants.altArgbsCpk[Elements.altElementIndexFromNumber(n)];
    }

    void setElementArgb(int n, int n2) {
        if (n2 == 1073741992 && this.argbsCpk == EnumPalette.argbsCpk) {
            return;
        }
        n2 = this.getJmolOrRasmolArgb(n, n2);
        if (this.argbsCpk == EnumPalette.argbsCpk) {
            this.argbsCpk = ArrayUtil.arrayCopy(EnumPalette.argbsCpk, 0, -1, false);
            this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
        }
        if (n < Elements.elementNumberMax) {
            this.argbsCpk[n] = n2;
            this.g3d.changeColixArgb((short)n, n2);
            return;
        }
        n = Elements.altElementIndexFromNumber(n);
        this.altArgbsCpk[n] = n2;
        this.g3d.changeColixArgb((short)(Elements.elementNumberMax + n), n2);
    }

    float[] getPropertyColorRange() {
        if (this.propertyColorEncoder.isReversed) {
            return new float[]{this.propertyColorEncoder.hi, this.propertyColorEncoder.lo};
        }
        return new float[]{this.propertyColorEncoder.lo, this.propertyColorEncoder.hi};
    }

    void setPropertyColorRange(float[] fArray, BitSet bitSet, String string) {
        int n;
        this.colorData = fArray;
        this.propertyColorEncoder.currentPalette = this.propertyColorEncoder.getColorScheme(string, true, false);
        this.propertyColorEncoder.hi = Float.MIN_VALUE;
        this.propertyColorEncoder.lo = Float.MAX_VALUE;
        if (fArray == null) {
            return;
        }
        boolean bl = bitSet == null;
        int n2 = n = bl ? fArray.length - 1 : bitSet.nextSetBit(0);
        while (n2 >= 0) {
            float f = fArray[n2];
            if (!Float.isNaN(f)) {
                this.propertyColorEncoder.hi = Math.max(this.propertyColorEncoder.hi, f);
                this.propertyColorEncoder.lo = Math.min(this.propertyColorEncoder.lo, f);
            }
            n2 = bl ? n2 - 1 : bitSet.nextSetBit(n2 + 1);
        }
        this.setPropertyColorRange(this.propertyColorEncoder.lo, this.propertyColorEncoder.hi);
    }

    void setPropertyColorRange(float f, float f2) {
        this.propertyColorEncoder.setRange(f, f2, f > f2);
        Logger.info("ColorManager: color \"" + this.propertyColorEncoder.getColorSchemeName() + "\" range " + f + " " + f2);
    }

    void setPropertyColorScheme(String string, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = string.length() == 0;
        if (bl3) {
            string = "=";
        }
        float[] fArray = this.getPropertyColorRange();
        this.propertyColorEncoder.currentPalette = this.propertyColorEncoder.getColorScheme(string, true, bl2);
        if (!bl3) {
            this.setPropertyColorRange(fArray[0], fArray[1]);
        }
        this.propertyColorEncoder.isTranslucent = bl;
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = this.propertyColorEncoder.getState(stringBuffer2);
        if (n > 0 && stringBuffer != null) {
            stringBuffer.append("\n  _setColorState\n");
        }
        return n > 0 && stringBuffer != null ? "function _setColorState() {\n" + stringBuffer2.append("}\n\n").toString() : stringBuffer2.toString();
    }

    void setUserScale(int[] nArray) {
        this.propertyColorEncoder.setUserScale(nArray);
    }

    String getColorSchemeList(String string) {
        int n = string == null || string.length() == 0 ? this.propertyColorEncoder.currentPalette : this.propertyColorEncoder.getColorScheme(string, true, false);
        return ColorEncoder.getColorSchemeList(this.propertyColorEncoder.getColorSchemeArray(n));
    }

    short getColixForPropertyValue(float f) {
        return this.propertyColorEncoder.getColorIndex(f);
    }

    public ColorEncoder getColorEncoder(String string) {
        if (string == null || string.length() == 0) {
            return this.propertyColorEncoder;
        }
        ColorEncoder colorEncoder = new ColorEncoder(this.propertyColorEncoder);
        colorEncoder.currentPalette = colorEncoder.getColorScheme(string, false, true);
        return colorEncoder.currentPalette == Integer.MAX_VALUE ? null : colorEncoder;
    }
}

