/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolNode;

public class SmilesBond
extends JmolEdge {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_SINGLE = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_TRIPLE = 3;
    public static final int TYPE_AROMATIC = 17;
    public static final int TYPE_DIRECTIONAL_1 = 257;
    public static final int TYPE_DIRECTIONAL_2 = 513;
    public static final int TYPE_ATROPISOMER_1 = 769;
    public static final int TYPE_ATROPISOMER_2 = 1025;
    public static final int TYPE_RING = 65;
    public static final int TYPE_ANY = 81;
    public static final int TYPE_BIO_SEQUENCE = 96;
    public static final int TYPE_BIO_PAIR = 112;
    public static final int TYPE_MULTIPLE = 999;
    private SmilesAtom atom1;
    private SmilesAtom atom2;
    boolean isNot;
    JmolEdge matchingBond;
    public SmilesBond[] primitives;
    public int nPrimitives;
    public SmilesBond[] bondsOr;
    public int nBondsOr;

    static String getBondOrderString(int n) {
        switch (n) {
            case 1: {
                return "";
            }
            case 2: {
                return "=";
            }
            case 3: {
                return "#";
            }
        }
        return "";
    }

    public void set(SmilesBond smilesBond) {
        this.order = smilesBond.order;
        this.isNot = smilesBond.isNot;
        this.primitives = smilesBond.primitives;
        this.nPrimitives = smilesBond.nPrimitives;
        this.bondsOr = smilesBond.bondsOr;
        this.nBondsOr = smilesBond.nBondsOr;
    }

    public SmilesBond addBondOr() {
        SmilesBond[] smilesBondArray;
        if (this.bondsOr == null) {
            this.bondsOr = new SmilesBond[2];
        }
        if (this.nBondsOr >= this.bondsOr.length) {
            smilesBondArray = new SmilesBond[this.bondsOr.length * 2];
            System.arraycopy(this.bondsOr, 0, smilesBondArray, 0, this.bondsOr.length);
            this.bondsOr = smilesBondArray;
        }
        this.bondsOr[this.nBondsOr] = smilesBondArray = new SmilesBond(-1, false);
        ++this.nBondsOr;
        return smilesBondArray;
    }

    public SmilesBond addPrimitive() {
        SmilesBond[] smilesBondArray;
        if (this.primitives == null) {
            this.primitives = new SmilesBond[2];
        }
        if (this.nPrimitives >= this.primitives.length) {
            smilesBondArray = new SmilesBond[this.primitives.length * 2];
            System.arraycopy(this.primitives, 0, smilesBondArray, 0, this.primitives.length);
            this.primitives = smilesBondArray;
        }
        this.primitives[this.nPrimitives] = smilesBondArray = new SmilesBond(-1, false);
        ++this.nPrimitives;
        return smilesBondArray;
    }

    public String toString() {
        return this.atom1 + " -" + (this.isNot ? "!" : "") + this.order + "- " + this.atom2;
    }

    public SmilesBond(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, int n, boolean bl) {
        this.set(smilesAtom, smilesAtom2);
        this.set(n, bl);
    }

    SmilesBond(int n, boolean bl) {
        this.set(n, bl);
    }

    void set(int n, boolean bl) {
        this.order = n;
        this.isNot = bl;
    }

    void set(SmilesAtom smilesAtom, SmilesAtom smilesAtom2) {
        if (smilesAtom != null) {
            this.atom1 = smilesAtom;
            smilesAtom.addBond(this);
        }
        if (smilesAtom2 != null) {
            this.atom2 = smilesAtom2;
            smilesAtom2.isFirst = false;
            smilesAtom2.addBond(this);
        }
    }

    static boolean isBondType(char c, boolean bl, boolean bl2) throws InvalidSmilesException {
        if ("-=#:/\\.+!,&;@~^'".indexOf(c) < 0) {
            return false;
        }
        if (!bl && "-=#:/\\.~^'".indexOf(c) < 0) {
            throw new InvalidSmilesException("SMARTS bond type " + c + " not allowed in SMILES");
        }
        return !bl2 || c != '~';
    }

    public static int getBondTypeFromCode(char c) {
        switch (c) {
            case '.': {
                return 0;
            }
            case '-': {
                return 1;
            }
            case '=': {
                return 2;
            }
            case '#': {
                return 3;
            }
            case ':': {
                return 17;
            }
            case '/': {
                return 257;
            }
            case '\\': {
                return 513;
            }
            case '^': {
                return 769;
            }
            case '\'': {
                return 1025;
            }
            case '@': {
                return 65;
            }
            case '~': {
                return 81;
            }
            case '+': {
                return 96;
            }
        }
        return -1;
    }

    public SmilesAtom getAtom1() {
        return this.atom1;
    }

    public SmilesAtom getAtom2() {
        return this.atom2;
    }

    void setAtom2(SmilesAtom smilesAtom) {
        this.atom2 = smilesAtom;
        if (this.atom2 != null) {
            smilesAtom.addBond(this);
        }
    }

    public int getBondType() {
        return this.order;
    }

    public SmilesAtom getOtherAtom(SmilesAtom smilesAtom) {
        return this.atom1 == smilesAtom ? this.atom2 : this.atom1;
    }

    public int getAtomIndex1() {
        return this.atom1.index;
    }

    public int getAtomIndex2() {
        return this.atom2.index;
    }

    public int getCovalentOrder() {
        return this.order;
    }

    public JmolNode getOtherAtom(JmolNode jmolNode) {
        return jmolNode == this.atom1 ? this.atom2 : (jmolNode == this.atom2 ? this.atom1 : null);
    }

    public boolean isCovalent() {
        return this.order != 112;
    }

    public int getValence() {
        return this.order & 7;
    }

    public boolean isHydrogen() {
        return this.order == 112;
    }

    void switchAtoms() {
        SmilesAtom smilesAtom = this.atom1;
        this.atom1 = this.atom2;
        this.atom2 = smilesAtom;
        switch (this.order) {
            case 769: {
                this.order = 1025;
                break;
            }
            case 1025: {
                this.order = 769;
                break;
            }
            case 257: {
                this.order = 513;
                break;
            }
            case 513: {
                this.order = 257;
            }
        }
    }
}

