/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.MeshRenderer;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;

public class IsosurfaceRenderer
extends MeshRenderer {
    protected boolean iHideBackground;
    protected boolean isBicolorMap;
    protected short backgroundColix;
    protected int nError = 0;
    protected float[] vertexValues;
    protected IsosurfaceMesh imesh;
    private Isosurface isosurface;
    private boolean isNavigationMode;
    private boolean iShowNormals;
    private boolean showNumbers;
    private Boolean showKey;
    private boolean hasColorRange;
    private final Point3f ptTemp = new Point3f();
    private final Point3i ptTempi = new Point3i();

    protected void initRenderer() {
        super.initRenderer();
    }

    protected void render() {
        this.iShowNormals = this.viewer.getTestFlag(4);
        this.showNumbers = this.viewer.getTestFlag(3);
        this.isosurface = (Isosurface)this.shape;
        this.exportPass = this.isExport ? 2 : 0;
        this.isNavigationMode = this.viewer.getNavigationMode();
        int n = Integer.MAX_VALUE;
        int n2 = this.g3d.getSlab();
        Boolean bl = this.showKey = this.viewer.getIsosurfaceKey() ? Boolean.TRUE : null;
        if (this.isNavigationMode) {
            n = (int)this.viewer.getNavigationOffset().z;
        }
        this.isosurface.keyXy = null;
        int n3 = this.isosurface.meshCount;
        while (--n3 >= 0) {
            this.imesh = (IsosurfaceMesh)this.isosurface.meshes[n3];
            if (this.imesh.connections != null && !this.viewer.getModelSet().atoms[this.imesh.connections[0]].isVisible(0)) continue;
            this.hasColorRange = false;
            if (!this.renderMesh(n, n2)) continue;
            if (!this.isExport) {
                this.renderInfo();
            }
            if (!this.isExport || !this.haveBsSlabGhost) continue;
            this.exportPass = 1;
            this.renderMesh(n, n2);
            this.exportPass = 2;
        }
    }

    protected void renderInfo() {
        if (this.hasColorRange && this.imesh.colorEncoder != null && Boolean.TRUE == this.showKey) {
            this.showKey();
        }
    }

    private void showKey() {
        this.showKey = Boolean.FALSE;
        int[] nArray = null;
        short[] sArray = null;
        List<Object>[] listArray = null;
        int n = 0;
        int n2 = 0;
        if (this.imesh.showContourLines) {
            listArray = this.imesh.getContours();
            if (listArray == null) {
                sArray = this.imesh.jvxlData.contourColixes;
                if (sArray == null) {
                    return;
                }
                n = sArray.length;
            } else {
                n = listArray.length;
                n2 = 1;
            }
        } else {
            nArray = this.imesh.colorEncoder.getColorSchemeArray(this.imesh.colorEncoder.currentPalette);
            n = nArray.length;
            n2 = 2;
        }
        if (n < 2) {
            return;
        }
        int n3 = this.g3d.isAntialiased() ? 2 : 1;
        int n4 = this.viewer.getScreenHeight() * n3;
        int n5 = n4 / 2 / (n - 1);
        int n6 = n4 / 4 * 3 - n5;
        int n7 = 10 * n3;
        int n8 = 20 * n3;
        this.isosurface.keyXy = new int[]{n7 / n3, 0, (n7 + n8) / n3, (n6 + n5) / n3, n5 / n3};
        int n9 = 0;
        while (n9 < n) {
            switch (n2) {
                case 0: {
                    if (this.g3d.setColix(sArray[n9])) break;
                    return;
                }
                case 1: {
                    if (this.g3d.setColix(((short[])listArray[n9].get(3))[0])) break;
                    return;
                }
                case 2: {
                    this.g3d.setColor(nArray[n9]);
                }
            }
            this.g3d.fillRect(n7, n6, 5, 5, n8, n5);
            ++n9;
            n6 -= n5;
        }
        this.isosurface.keyXy[1] = (n6 + n5) / n3;
    }

    private boolean renderMesh(int n, int n2) {
        boolean bl;
        boolean bl2 = this.volumeRender = this.imesh.jvxlData.colorDensity && this.imesh.jvxlData.allowVolumeRender;
        if (!this.isNavigationMode && !(bl = this.imesh.jvxlData.slabValue) && this.imesh.jvxlData.isSlabbable) {
            Point3f[] point3fArray = this.imesh.jvxlData.boundingBox;
            this.pt2f.set(point3fArray[0]);
            this.pt2f.add(point3fArray[1]);
            this.pt2f.scale(0.5f);
            this.viewer.transformPoint(this.pt2f, this.pt2f);
            short s = this.viewer.scaleToScreen((int)this.pt2f.z, (int)point3fArray[0].distance(point3fArray[1]) * 500);
            n = (int)(this.pt2f.z + (float)s * (1.0f - (float)bl / 50.0f));
        }
        this.g3d.setTranslucentCoverOnly(this.imesh.frontOnly);
        this.thePlane = this.imesh.jvxlData.jvxlPlane;
        this.vertexValues = this.imesh.vertexValues;
        if (n != Integer.MAX_VALUE && this.imesh.jvxlData.isSlabbable) {
            this.g3d.setSlab(n);
            bl = this.render1(this.imesh);
            this.g3d.setSlab(n2);
        } else {
            bl = this.render1(this.imesh);
        }
        this.g3d.setTranslucentCoverOnly(false);
        return bl;
    }

    protected void render2(boolean bl) {
        if (this.volumeRender) {
            this.renderPoints();
            return;
        }
        switch (this.imesh.dataType) {
            case 70: {
                this.renderLonePair(false);
                return;
            }
            case 71: {
                this.renderLonePair(true);
                return;
            }
        }
        this.isBicolorMap = this.imesh.jvxlData.isBicolorMap;
        super.render2(bl);
        if (!this.g3d.setColix((short)4)) {
            return;
        }
        if (this.imesh.showContourLines) {
            this.renderContourLines();
        }
    }

    private void renderLonePair(boolean bl) {
        this.pt2f.set(this.vertices[1]);
        this.viewer.transformPoint(this.pt2f, this.pt2f);
        short s = this.viewer.scaleToScreen((int)this.pt2f.z, 100);
        if (s < 1) {
            s = 1;
        }
        if (!bl) {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            this.pt1f.set(this.vertices[0]);
            this.viewer.transformPoint(this.pt1f, this.pt1f);
            vector3f.sub(this.pt2f, this.pt1f);
            vector3f2.set(vector3f.x, vector3f.y, vector3f.z + 1.0f);
            vector3f2.cross(vector3f2, vector3f);
            vector3f2.normalize();
            float f = this.viewer.scaleToScreen((int)this.pt1f.z, 100);
            vector3f2.scale(f);
            this.pt1f.set(this.pt2f);
            this.pt1f.add(vector3f2);
            this.pt2f.sub(vector3f2);
            this.screens[0].set((int)this.pt1f.x, (int)this.pt1f.y, (int)this.pt1f.z);
            this.g3d.fillSphere((int)s, this.screens[0]);
        }
        this.screens[1].set((int)this.pt2f.x, (int)this.pt2f.y, (int)this.pt2f.z);
        this.g3d.fillSphere((int)s, this.screens[1]);
    }

    private void renderContourLines() {
        List<Object>[] listArray = this.imesh.getContours();
        if (listArray == null) {
            if (this.imesh.jvxlData.contourValues != null) {
                this.hasColorRange = true;
            }
            return;
        }
        if (this.imesh.jvxlData.vertexDataOnly) {
            return;
        }
        this.hasColorRange = this.imesh.meshColix == 0;
        int n = listArray.length;
        block0: while (--n >= 0) {
            List<Object> list = listArray[n];
            if (list.size() < 6) continue;
            short s = this.colix = this.imesh.meshColix == 0 ? ((short[])list.get(3))[0] : this.imesh.meshColix;
            if (!this.g3d.setColix(this.colix)) {
                return;
            }
            int n2 = list.size() - 1;
            for (int i = 6; i < n2; ++i) {
                Point3f point3f = (Point3f)list.get(i);
                Point3f point3f2 = (Point3f)list.get(++i);
                this.viewer.transformPoint(point3f, this.pt1i);
                this.viewer.transformPoint(point3f2, this.pt2i);
                if (Float.isNaN(point3f.x) || Float.isNaN(point3f2.x)) continue block0;
                this.pt1i.z -= 2;
                this.pt2i.z -= 2;
                this.g3d.drawLine(this.pt1i, this.pt2i);
            }
        }
    }

    protected void renderPoints() {
        try {
            int n;
            int n2;
            int n3;
            if (this.volumeRender) {
                this.g3d.volumeRender(true);
            }
            boolean bl = (this.volumeRender || this.imesh.polygonCount == 0) && this.haveBsSlabDisplay;
            int n4 = this.imesh.vertexIncrement;
            if (this.imesh.diameter <= 0) {
                n3 = this.viewer.getDotScale();
                this.frontOnly = false;
            } else {
                n3 = this.viewer.getScreenDim() / (this.volumeRender ? 50 : 100);
            }
            int n5 = (int)(this.imesh.volumeRenderPointSize * 1000.0f);
            if (n3 < 1) {
                n3 = 1;
            }
            int n6 = this.showNumbers ? this.viewer.getScreenWidth() / 2 : 0;
            int n7 = n2 = this.showNumbers ? this.viewer.getScreenHeight() / 2 : 0;
            if (this.showNumbers) {
                this.g3d.setFont(this.g3d.getFontFid("Monospaced", 24.0f));
            }
            int n8 = n = !this.imesh.hasGridPoints || this.imesh.firstRealVertex < 0 ? 0 : this.imesh.firstRealVertex;
            while (n < this.vertexCount) {
                if (!(this.vertexValues != null && Float.isNaN(this.vertexValues[n]) || this.frontOnly && this.transformedVectors[this.normixes[n]].z < 0.0f || this.imesh.jvxlData.thisSet >= 0 && this.imesh.vertexSets[n] != this.imesh.jvxlData.thisSet || !this.imesh.isColorSolid && this.imesh.vertexColixes != null && !this.setColix(this.imesh.vertexColixes[n]) || this.haveBsDisplay && !this.imesh.bsDisplay.get(n) || bl && !this.bsSlab.get(n))) {
                    this.hasColorRange = true;
                    if (this.showNumbers && this.screens[n].z > 10 && Math.abs(this.screens[n].x - n6) < 150 && Math.abs(this.screens[n].y - n2) < 150) {
                        String string = n + (this.imesh.isColorSolid ? "" : " " + this.imesh.vertexValues[n]);
                        this.g3d.setColix((short)4);
                        this.g3d.drawStringNoSlab(string, null, this.screens[n].x, this.screens[n].y, this.screens[n].z - 30);
                    }
                    if (this.volumeRender) {
                        n3 = this.viewer.scaleToScreen(this.screens[n].z, n5);
                        this.g3d.volumeRender(n3, this.screens[n].x, this.screens[n].y, this.screens[n].z);
                    } else {
                        this.g3d.fillSphere(n3, this.screens[n]);
                    }
                }
                n += n4;
            }
            if (n4 == 3) {
                this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)12, true, 0.5f) : (short)12);
                for (n = 1; n < this.vertexCount; n += 3) {
                    this.g3d.fillCylinder((byte)3, n3 / 4, this.screens[n], this.screens[n + 1]);
                }
                this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)21, true, 0.5f) : (short)21);
                for (n = 1; n < this.vertexCount; n += 3) {
                    this.g3d.fillSphere(n3, this.screens[n]);
                }
                this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)7, true, 0.5f) : (short)7);
                for (n = 2; n < this.vertexCount; n += 3) {
                    this.g3d.fillSphere(n3, this.screens[n]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.volumeRender) {
            this.g3d.volumeRender(false);
        }
    }

    protected void renderTriangles(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        int[][] nArray = this.imesh.polygonIndexes;
        this.colix = this.haveBsSlabGhost ? this.imesh.slabColix : (!bl && this.imesh.meshColix != 0 ? this.imesh.meshColix : this.imesh.colix);
        short[] sArray = (short[])(!bl && this.imesh.meshColix != 0 ? null : this.imesh.vertexColixes);
        this.g3d.setColix(this.colix);
        int n = Integer.MIN_VALUE;
        boolean bl5 = bl3;
        if (bl5) {
            if (this.frontOnly && bl) {
                this.frontOnly = false;
            }
            this.bsPolygons.clear();
        }
        if (this.exportType == 1) {
            this.frontOnly = false;
        }
        boolean bl6 = this.haveBsSlabGhost && !this.isBicolorMap || sArray == null || this.imesh.isColorSolid;
        boolean bl7 = this.haveBsSlabGhost && !this.isBicolorMap || sArray == null || !bl && this.imesh.meshColix != 0;
        boolean bl8 = this.imesh.jvxlData.jvxlPlane != null;
        short s = this.colix;
        if (bl8 && !bl6 && !bl && this.imesh.fillTriangles) {
            bl6 = true;
            s = 4;
        }
        boolean bl9 = bl4 = bl6 && this.imesh.polygonColixes != null;
        if (bl4 && !bl && this.imesh.fillTriangles) {
            bl4 = false;
        }
        short[] sArray2 = this.imesh.jvxlData.contourColixes;
        this.hasColorRange = !bl6 && !this.isBicolorMap;
        int n2 = this.imesh.polygonCount;
        while (--n2 >= 0) {
            short s2;
            short s3;
            short s4;
            int[] nArray2 = nArray[n2];
            if (nArray2 == null || this.haveBsSlabDisplay && !this.bsSlab.get(n2)) continue;
            int n3 = nArray2[0];
            int n4 = nArray2[1];
            int n5 = nArray2[2];
            if (this.imesh.jvxlData.thisSet >= 0 && this.imesh.vertexSets != null && this.imesh.vertexSets[n3] != this.imesh.jvxlData.thisSet || this.haveBsDisplay && (!this.imesh.bsDisplay.get(n3) || !this.imesh.bsDisplay.get(n4) || !this.imesh.bsDisplay.get(n5))) continue;
            short s5 = this.normixes[n3];
            short s6 = this.normixes[n4];
            short s7 = this.normixes[n5];
            int n6 = this.checkNormals(s5, s6, s7);
            if (bl && n6 == 0) continue;
            if (bl6) {
                if (bl4 && n2 < this.imesh.polygonColixes.length) {
                    short s8 = this.imesh.polygonColixes[n2];
                    if (s8 == 0) continue;
                    s = s8;
                }
                s3 = s4 = s;
                s2 = s4;
            } else {
                s2 = sArray[n3];
                s3 = sArray[n4];
                s4 = sArray[n5];
                if (this.isBicolorMap) {
                    if (s2 != s3 || s3 != s4) continue;
                    if (this.haveBsSlabGhost) {
                        s3 = s4 = Graphics3D.copyColixTranslucency(this.imesh.slabColix, s2);
                        s2 = s4;
                    }
                }
            }
            if (n == Integer.MIN_VALUE && (n = this.imesh.diameter <= 0 ? this.viewer.getMeshScale() : this.viewer.getScreenDim() / 100) < 1) {
                n = 1;
            }
            if (bl) {
                if (bl5) {
                    this.bsPolygons.set(n2);
                    continue;
                }
                if (n4 == n5) {
                    this.setColix(s2);
                    if (n3 == n4) {
                        this.g3d.fillSphere(n, this.screens[n3]);
                    } else {
                        this.g3d.fillCylinder((byte)3, n, this.screens[n3], this.screens[n4]);
                    }
                } else if (bl2) {
                    this.g3d.fillTriangle(this.screens[n3], s2, s5, this.screens[n4], s3, s6, this.screens[n5], s4, s7, 0.1f);
                } else {
                    this.g3d.fillTriangle(this.screens[n3], s2, s5, this.screens[n4], s3, s6, this.screens[n5], s4, s7);
                }
                if (!this.iShowNormals) continue;
                this.renderNormals();
                continue;
            }
            n6 &= nArray2[3];
            if (bl2) {
                n6 = 7;
            }
            if (n6 == 0) continue;
            this.pt1i.set(this.screens[n3]);
            this.pt2i.set(this.screens[n4]);
            this.pt3i.set(this.screens[n5]);
            this.pt1i.z -= 2;
            this.pt2i.z -= 2;
            this.pt3i.z -= 2;
            if (!bl7) {
                if (bl4) {
                    this.g3d.setColix(this.mesh.fillTriangles ? (short)4 : sArray2[nArray2[4] % sArray2.length]);
                } else {
                    this.drawTriangle(this.pt1i, s2, this.pt2i, s3, this.pt3i, s4, n6, n);
                    continue;
                }
            }
            this.drawTriangle(this.pt1i, s, this.pt2i, s, this.pt3i, s, n6, n);
        }
        if (bl5) {
            this.exportSurface(bl6 ? s : (short)0);
        }
    }

    private void renderNormals() {
        if (!this.g3d.setColix((short)8)) {
            return;
        }
        this.g3d.setFont(this.g3d.getFontFid("Monospaced", 24.0f));
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.vertexValues != null && Float.isNaN(this.vertexValues[n]) || n < 7117 || n > 7119) continue;
            this.ptTemp.set(this.vertices[n]);
            short s = this.mesh.normixes[n];
            if (s < 0) continue;
            this.ptTemp.add(Graphics3D.getNormixVector(s));
            this.viewer.transformPoint(this.ptTemp, this.ptTempi);
            this.g3d.drawLine(this.screens[n], this.ptTempi);
        }
    }
}

