/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

abstract class QuantumCalculation {
    protected boolean doDebug = false;
    protected BitSet bsExcluded;
    protected static final float bohr_per_angstrom = 1.8897161f;
    protected float[][][] voxelData;
    protected float[] vd;
    protected int[] countsXYZ;
    protected Point3f[] points;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected int zMin;
    protected int zMax;
    protected QMAtom[] qmAtoms;
    protected int atomIndex;
    protected QMAtom thisAtom;
    protected int firstAtomOffset;
    protected float[] xBohr;
    protected float[] yBohr;
    protected float[] zBohr;
    protected float[] originBohr = new float[3];
    protected float[] stepBohr = new float[3];
    protected int nX;
    protected int nY;
    protected int nZ;
    protected float[] X;
    protected float[] Y;
    protected float[] Z;
    protected float[] X2;
    protected float[] Y2;
    protected float[] Z2;
    protected float rangeBohrOrAngstroms = 10.0f;
    protected float unitFactor = 1.8897161f;
    protected float volume = 1.0f;

    QuantumCalculation() {
    }

    protected void initialize(int n, int n2, int n3, Point3f[] point3fArray) {
        if (point3fArray != null) {
            this.points = point3fArray;
            n2 = n3 = point3fArray.length;
            n = n3;
        }
        this.nX = this.xMax = n;
        this.nY = this.yMax = n2;
        this.nZ = this.zMax = n3;
        if (this.xBohr != null && this.xBohr.length >= n) {
            return;
        }
        this.xBohr = new float[n];
        this.yBohr = new float[n2];
        this.zBohr = new float[n3];
        this.X = new float[n];
        this.Y = new float[n2];
        this.Z = new float[n3];
        this.X2 = new float[n];
        this.Y2 = new float[n2];
        this.Z2 = new float[n3];
    }

    protected void setupCoordinates(float[] fArray, float[] fArray2, BitSet bitSet, Point3f[] point3fArray, Point3f[] point3fArray2, boolean bl) {
        int n;
        if (point3fArray2 == null) {
            this.volume = 1.0f;
            n = 3;
            while (--n >= 0) {
                this.originBohr[n] = fArray[n] * this.unitFactor;
                this.stepBohr[n] = fArray2[n] * this.unitFactor;
                this.volume *= this.stepBohr[n];
            }
            Logger.info("QuantumCalculation:\n origin = " + Escape.escape(fArray) + "\n steps = " + Escape.escape(fArray2) + "\n origin(Bohr)= " + Escape.escape(this.originBohr) + "\n steps(Bohr)= " + Escape.escape(this.stepBohr) + "\n counts= " + this.nX + " " + this.nY + " " + this.nZ);
        }
        if (point3fArray != null) {
            int n2;
            this.qmAtoms = new QMAtom[bl ? bitSet.cardinality() : point3fArray.length];
            n = bitSet == null ? 1 : 0;
            int n3 = n2 = n != 0 ? this.qmAtoms.length - 1 : bitSet.nextSetBit(0);
            int n4 = 0;
            while (n3 >= 0) {
                this.qmAtoms[bl ? n4++ : n3] = new QMAtom(n3, (Atom)point3fArray[n3], this.X, this.Y, this.Z, this.X2, this.Y2, this.Z2);
                n3 = n != 0 ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
            }
        }
    }

    public float process(Point3f point3f) {
        this.doDebug = false;
        if (this.points == null || this.nX != 1) {
            this.initializeOnePoint();
        }
        this.points[0].set(point3f);
        this.voxelData[0][0][0] = 0.0f;
        this.setXYZBohr(this.points);
        this.processPoints();
        return this.voxelData[0][0][0];
    }

    protected void processPoints() {
        this.process();
    }

    protected void initializeOnePoint() {
        this.points = new Point3f[1];
        this.points[0] = new Point3f();
        this.voxelData = new float[1][1][1];
        this.zMin = 0;
        this.yMin = 0;
        this.xMin = 0;
        this.initialize(1, 1, 1, this.points);
    }

    protected abstract void process();

    protected void setXYZBohr(Point3f[] point3fArray) {
        this.setXYZBohr(this.xBohr, 0, this.nX, point3fArray);
        this.setXYZBohr(this.yBohr, 1, this.nY, point3fArray);
        this.setXYZBohr(this.zBohr, 2, this.nZ, point3fArray);
    }

    private void setXYZBohr(float[] fArray, int n, int n2, Point3f[] point3fArray) {
        if (point3fArray != null) {
            float f = 0.0f;
            for (int i = 0; i < n2; ++i) {
                switch (n) {
                    case 0: {
                        f = point3fArray[i].x;
                        break;
                    }
                    case 1: {
                        f = point3fArray[i].y;
                        break;
                    }
                    case 2: {
                        f = point3fArray[i].z;
                    }
                }
                fArray[i] = f * this.unitFactor;
            }
            return;
        }
        fArray[0] = this.originBohr[n];
        float f = this.stepBohr[n];
        int n3 = 0;
        while (++n3 < n2) {
            fArray[n3] = fArray[n3 - 1] + f;
        }
    }

    protected void setMinMax(int n) {
        this.zMax = n < 0 ? this.xMax : n + 1;
        this.yMax = this.zMax;
        this.zMin = n < 0 ? 0 : n;
        this.yMin = this.zMin;
    }

    class QMAtom
    extends Point3f {
        private float[] myX;
        private float[] myY;
        private float[] myZ;
        private float[] myX2;
        private float[] myY2;
        private float[] myZ2;
        Atom atom;
        int index;
        int znuc;
        int iMolecule;
        boolean isExcluded;

        QMAtom(int n, Atom atom, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6) {
            this.index = n;
            this.myX = fArray;
            this.myY = fArray2;
            this.myZ = fArray3;
            this.myX2 = fArray4;
            this.myY2 = fArray5;
            this.myZ2 = fArray6;
            this.atom = atom;
            this.isExcluded = QuantumCalculation.this.bsExcluded != null && QuantumCalculation.this.bsExcluded.get(n);
            this.set(atom);
            this.scale(QuantumCalculation.this.unitFactor);
            this.znuc = atom.getElementNumber();
        }

        protected void setXYZ(boolean bl) {
            try {
                int n;
                if (bl) {
                    if (QuantumCalculation.this.points != null) {
                        QuantumCalculation.this.zMin = 0;
                        QuantumCalculation.this.yMin = 0;
                        QuantumCalculation.this.xMin = 0;
                        QuantumCalculation.this.yMax = QuantumCalculation.this.zMax = QuantumCalculation.this.points.length;
                        QuantumCalculation.this.xMax = QuantumCalculation.this.zMax;
                    } else {
                        n = (int)Math.floor((this.x - QuantumCalculation.this.xBohr[0] - QuantumCalculation.this.rangeBohrOrAngstroms) / QuantumCalculation.this.stepBohr[0]);
                        QuantumCalculation.this.xMin = n < 0 ? 0 : n;
                        n = (int)Math.floor(1.0f + (this.x - QuantumCalculation.this.xBohr[0] + QuantumCalculation.this.rangeBohrOrAngstroms) / QuantumCalculation.this.stepBohr[0]);
                        QuantumCalculation.this.xMax = n >= QuantumCalculation.this.nX ? QuantumCalculation.this.nX : n + 1;
                        n = (int)Math.floor((this.y - QuantumCalculation.this.yBohr[0] - QuantumCalculation.this.rangeBohrOrAngstroms) / QuantumCalculation.this.stepBohr[1]);
                        QuantumCalculation.this.yMin = n < 0 ? 0 : n;
                        n = (int)Math.floor(1.0f + (this.y - QuantumCalculation.this.yBohr[0] + QuantumCalculation.this.rangeBohrOrAngstroms) / QuantumCalculation.this.stepBohr[1]);
                        QuantumCalculation.this.yMax = n >= QuantumCalculation.this.nY ? QuantumCalculation.this.nY : n + 1;
                        n = (int)Math.floor((this.z - QuantumCalculation.this.zBohr[0] - QuantumCalculation.this.rangeBohrOrAngstroms) / QuantumCalculation.this.stepBohr[2]);
                        QuantumCalculation.this.zMin = n < 0 ? 0 : n;
                        n = (int)Math.floor(1.0f + (this.z - QuantumCalculation.this.zBohr[0] + QuantumCalculation.this.rangeBohrOrAngstroms) / QuantumCalculation.this.stepBohr[2]);
                        QuantumCalculation.this.zMax = n >= QuantumCalculation.this.nZ ? QuantumCalculation.this.nZ : n + 1;
                    }
                }
                n = QuantumCalculation.this.xMax;
                while (--n >= QuantumCalculation.this.xMin) {
                    this.myX2[n] = this.myX[n] = QuantumCalculation.this.xBohr[n] - this.x;
                    int n2 = n;
                    this.myX2[n2] = this.myX2[n2] * this.myX[n];
                }
                n = QuantumCalculation.this.yMax;
                while (--n >= QuantumCalculation.this.yMin) {
                    this.myY2[n] = this.myY[n] = QuantumCalculation.this.yBohr[n] - this.y;
                    int n3 = n;
                    this.myY2[n3] = this.myY2[n3] * this.myY[n];
                }
                n = QuantumCalculation.this.zMax;
                while (--n >= QuantumCalculation.this.zMin) {
                    this.myZ2[n] = this.myZ[n] = QuantumCalculation.this.zBohr[n] - this.z;
                    int n4 = n;
                    this.myZ2[n4] = this.myZ2[n4] * this.myZ[n];
                }
                if (QuantumCalculation.this.points != null) {
                    QuantumCalculation.this.zMax = 1;
                    QuantumCalculation.this.yMax = 1;
                }
            }
            catch (Exception exception) {
                Logger.error("Error in QuantumCalculation setting bounds");
            }
        }
    }
}

