/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.AtomSetObject;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Quadric;
import org.jmol.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomSetCollection {
    private String fileTypeName;
    private String collectionName;
    private Map<String, Object> atomSetCollectionAuxiliaryInfo = new Hashtable<String, Object>();
    public BitSet bsAtoms;
    private static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells", "someModelsHaveCONECT", "isPDB"};
    public static final int GLOBAL_FRACTCOORD = 0;
    public static final int GLOBAL_SYMMETRY = 1;
    public static final int GLOBAL_UNITCELLS = 2;
    private static final int GLOBAL_CONECT = 3;
    public static final int GLOBAL_ISPDB = 4;
    public static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    private int atomCount;
    private Atom[] atoms = new Atom[256];
    private int bondCount;
    private Bond[] bonds = new Bond[256];
    private int structureCount;
    private Structure[] structures = new Structure[16];
    private int atomSetCount;
    private int currentAtomSetIndex = -1;
    private int[] atomSetNumbers = new int[16];
    private int[] atomSetAtomIndexes = new int[16];
    private int[] atomSetAtomCounts = new int[16];
    private int[] atomSetBondCounts = new int[16];
    private Map<String, Object>[] atomSetAuxiliaryInfo = new Hashtable[16];
    private int[] latticeCells;
    public String errorMessage;
    public boolean coordinatesAreFractional;
    private boolean isTrajectory;
    private int trajectoryStepCount = 0;
    private List<Point3f[]> trajectorySteps;
    private List<Vector3f[]> vibrationSteps;
    private List<String> trajectoryNames;
    boolean doFixPeriodic;
    public float[] notionalUnitCell = new float[6];
    public boolean allowMultiple;
    List<int[]> vConnect;
    int connectNextAtomIndex = 0;
    int connectNextAtomSet = 0;
    int[] connectLast;
    float symmetryRange;
    private boolean doCentroidUnitCell;
    private boolean centroidPacked;
    public Point3f ptSupercell;
    public float[] fmatSupercell;
    SymmetryInterface symmetry;
    boolean haveUnitCell = false;
    boolean doNormalize = true;
    boolean doPackUnitCell = false;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final Point3f ptOffset = new Point3f();
    public Point3f unitCellOffset;
    private Point3i minXYZ;
    private Point3i maxXYZ;
    private Point3i minXYZ0;
    private Point3i maxXYZ0;
    public boolean haveAnisou;
    private int dtype = 3;
    private Vector3f[] unitCellTranslations;
    private int baseSymmetryAtomCount;
    Point3f[] cartesians;
    int bondCount0;
    int bondIndex0;
    boolean applySymmetryToBonds = false;
    boolean checkSpecial = true;
    private final Point3f ptTemp = new Point3f();
    private final Point3f ptTemp1 = new Point3f();
    private final Point3f ptTemp2 = new Point3f();
    Map<Object, Integer> atomSymbolicMap = new Hashtable<Object, Integer>();
    boolean haveMappedSerials;

    public String getFileTypeName() {
        return this.fileTypeName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String string) {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                return;
            }
            this.collectionName = string;
        }
    }

    public Map<String, Object> getAtomSetCollectionAuxiliaryInfo() {
        return this.atomSetCollectionAuxiliaryInfo;
    }

    public void clearGlobalBoolean(int n) {
        this.atomSetCollectionAuxiliaryInfo.remove(globalBooleans[n]);
    }

    public void setGlobalBoolean(int n) {
        this.setAtomSetCollectionAuxiliaryInfo(globalBooleans[n], Boolean.TRUE);
    }

    boolean getGlobalBoolean(int n) {
        return this.getAtomSetCollectionAuxiliaryInfo(globalBooleans[n]) == Boolean.TRUE;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public int getHydrogenAtomCount() {
        int n = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].elementNumber != 1 && !this.atoms[i].elementSymbol.equals("H")) continue;
            ++n;
        }
        return n;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtom(int n) {
        return this.atoms[n];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBond(int n) {
        return this.bonds[n];
    }

    public int getStructureCount() {
        return this.structureCount;
    }

    public Structure[] getStructures() {
        return this.structures;
    }

    public int getAtomSetCount() {
        return this.atomSetCount;
    }

    public int getCurrentAtomSetIndex() {
        return this.currentAtomSetIndex;
    }

    public void setCurrentAtomSetIndex(int n) {
        this.currentAtomSetIndex = n;
    }

    public void setDoFixPeriodic() {
        this.doFixPeriodic = true;
    }

    public AtomSetCollection(String string, AtomSetCollectionReader atomSetCollectionReader) {
        this.fileTypeName = string;
        this.allowMultiple = atomSetCollectionReader == null || atomSetCollectionReader.desiredVibrationNumber < 0;
        Properties properties = new Properties();
        properties.put("PATH_KEY", ".PATH");
        properties.put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
        this.setAtomSetCollectionAuxiliaryInfo("properties", properties);
    }

    public AtomSetCollection(AtomSetCollection[] atomSetCollectionArray) {
        this("Array", null);
        int n = 0;
        for (int i = 0; i < atomSetCollectionArray.length; ++i) {
            if (atomSetCollectionArray[i].atomCount <= 0) continue;
            this.appendAtomSetCollection(n++, atomSetCollectionArray[i]);
        }
        if (n > 1) {
            this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        }
    }

    public AtomSetCollection(List<?> list) {
        this("Array", null);
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        this.appendAtomSetCollection(list);
    }

    private void appendAtomSetCollection(List<?> list) {
        int n = list.size();
        if (n == 0) {
            this.errorMessage = "No file found!";
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            if (obj instanceof List) {
                this.appendAtomSetCollection((List)obj);
                continue;
            }
            this.appendAtomSetCollection(i, (AtomSetCollection)obj);
        }
    }

    public void setTrajectory() {
        if (!this.isTrajectory) {
            this.trajectorySteps = new ArrayList<Point3f[]>();
        }
        this.isTrajectory = true;
        this.addTrajectoryStep();
    }

    public void appendAtomSetCollection(int n, AtomSetCollection atomSetCollection) {
        Object object;
        int n2;
        int n3;
        int n4 = this.atomCount;
        this.setAtomSetCollectionAuxiliaryInfo("loadState", atomSetCollection.getAtomSetCollectionAuxiliaryInfo("loadState"));
        if (atomSetCollection.bsAtoms != null) {
            if (this.bsAtoms == null) {
                this.bsAtoms = new BitSet();
            }
            n3 = atomSetCollection.bsAtoms.nextSetBit(0);
            while (n3 >= 0) {
                this.bsAtoms.set(n4 + n3);
                n3 = atomSetCollection.bsAtoms.nextSetBit(n3 + 1);
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < atomSetCollection.atomSetCount; ++n2) {
            int n5;
            this.newAtomSet();
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = atomSetCollection.atomSetAuxiliaryInfo[n2];
            object = this.atomSetAuxiliaryInfo[this.currentAtomSetIndex];
            int[] nArray = (int[])object.get("PDB_CONECT_firstAtom_count_max");
            if (nArray != null) {
                nArray[0] = nArray[0] + n4;
            }
            this.setAtomSetAuxiliaryInfo("title", atomSetCollection.collectionName);
            this.setAtomSetName(atomSetCollection.getAtomSetName(n2));
            for (n5 = 0; n5 < atomSetCollection.atomSetAtomCounts[n2]; ++n5) {
                try {
                    if (this.bsAtoms != null) {
                        this.bsAtoms.set(this.atomCount);
                    }
                    this.newCloneAtom(atomSetCollection.atoms[n3]);
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
                ++n3;
            }
            for (n5 = 0; n5 < atomSetCollection.structureCount; ++n5) {
                if (atomSetCollection.structures[n5] == null || atomSetCollection.structures[n5].atomSetIndex != n2 && atomSetCollection.structures[n5].atomSetIndex != -1) continue;
                this.addStructure(atomSetCollection.structures[n5]);
            }
            this.atomSetNumbers[this.currentAtomSetIndex] = n < 0 ? this.currentAtomSetIndex + 1 : (n + 1) * 1000000 + atomSetCollection.atomSetNumbers[n2];
        }
        for (n2 = 0; n2 < atomSetCollection.bondCount; ++n2) {
            object = atomSetCollection.bonds[n2];
            this.addNewBond(((Bond)object).atomIndex1 + n4, ((Bond)object).atomIndex2 + n4, ((Bond)object).order);
        }
        n2 = globalBooleans.length;
        while (--n2 >= 0) {
            if (!Boolean.TRUE.equals(atomSetCollection.getAtomSetCollectionAuxiliaryInfo(globalBooleans[n2]))) continue;
            this.setGlobalBoolean(n2);
        }
    }

    void setNoAutoBond() {
        this.setAtomSetCollectionAuxiliaryInfo("noAutoBond", Boolean.TRUE);
    }

    void freeze(boolean bl) {
        if (bl) {
            this.reverseAtomSets();
        }
        if (this.trajectoryStepCount > 1) {
            this.finalizeTrajectory();
        }
        this.getList(true);
        this.getList(false);
        for (int i = 0; i < this.atomSetCount; ++i) {
            this.setAtomSetAuxiliaryInfo("initialAtomCount", this.atomSetAtomCounts[i], i);
            this.setAtomSetAuxiliaryInfo("initialBondCount", this.atomSetBondCounts[i], i);
        }
    }

    private void reverseAtomSets() {
        int n;
        int n2;
        this.reverse(this.atomSetAtomIndexes);
        this.reverse(this.atomSetNumbers);
        this.reverse(this.atomSetAtomCounts);
        this.reverse(this.atomSetBondCounts);
        AtomSetCollection.reverse(this.trajectorySteps);
        AtomSetCollection.reverse(this.trajectoryNames);
        AtomSetCollection.reverse(this.vibrationSteps);
        this.reverse(this.atomSetAuxiliaryInfo);
        for (n2 = 0; n2 < this.atomCount; ++n2) {
            this.atoms[n2].atomSetIndex = this.atomSetCount - 1 - this.atoms[n2].atomSetIndex;
        }
        for (n2 = 0; n2 < this.structureCount; ++n2) {
            if (this.structures[n2].atomSetIndex < 0) continue;
            this.structures[n2].atomSetIndex = this.atomSetCount - 1 - this.structures[n2].atomSetIndex;
        }
        for (n2 = 0; n2 < this.bondCount; ++n2) {
            this.bonds[n2].atomSetIndex = this.atomSetCount - 1 - this.atoms[this.bonds[n2].atomIndex1].atomSetIndex;
        }
        this.reverseSets(this.structures, this.structureCount);
        this.reverseSets(this.bonds, this.bondCount);
        List<T>[] listArray = ArrayUtil.createArrayOfArrayList(this.atomSetCount);
        for (n = 0; n < this.atomSetCount; ++n) {
            listArray[n] = new ArrayList();
        }
        for (n = 0; n < this.atomCount; ++n) {
            listArray[this.atoms[n].atomSetIndex].add(this.atoms[n]);
        }
        int[] nArray = new int[this.atomCount];
        int n3 = this.atomCount;
        int n4 = this.atomSetCount;
        while (--n4 >= 0) {
            int n5 = listArray[n4].size();
            while (--n5 >= 0) {
                Atom atom = this.atoms[--n3] = (Atom)listArray[n4].get(n5);
                nArray[atom.atomIndex] = n3;
                atom.atomIndex = n3;
            }
        }
        for (n4 = 0; n4 < this.bondCount; ++n4) {
            this.bonds[n4].atomIndex1 = nArray[this.bonds[n4].atomIndex1];
            this.bonds[n4].atomIndex2 = nArray[this.bonds[n4].atomIndex2];
        }
        for (n4 = 0; n4 < this.atomSetCount; ++n4) {
            int[] nArray2 = (int[])this.getAtomSetAuxiliaryInfo(n4, "PDB_CONECT_firstAtom_count_max");
            if (nArray2 == null) continue;
            nArray2[0] = nArray[nArray2[0]];
            nArray2[1] = this.atomSetAtomCounts[n4];
        }
    }

    private void reverseSets(AtomSetObject[] atomSetObjectArray, int n) {
        int n2;
        int n3;
        List<T>[] listArray = ArrayUtil.createArrayOfArrayList(this.atomSetCount);
        for (n3 = 0; n3 < this.atomSetCount; ++n3) {
            listArray[n3] = new ArrayList();
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = atomSetObjectArray[n3].atomSetIndex;
            if (n2 < 0) {
                return;
            }
            listArray[atomSetObjectArray[n3].atomSetIndex].add(atomSetObjectArray[n3]);
        }
        n3 = this.atomSetCount;
        while (--n3 >= 0) {
            n2 = listArray[n3].size();
            while (--n2 >= 0) {
                atomSetObjectArray[--n] = (AtomSetObject)listArray[n3].get(n2);
            }
        }
    }

    private void reverse(Object[] objectArray) {
        int n = this.atomSetCount;
        int n2 = n / 2;
        while (--n2 >= 0) {
            ArrayUtil.swap(objectArray, n2, n - 1 - n2);
        }
    }

    private static void reverse(List<?> list) {
        if (list == null) {
            return;
        }
        Collections.reverse(list);
    }

    private void reverse(int[] nArray) {
        int n = this.atomSetCount;
        int n2 = n / 2;
        while (--n2 >= 0) {
            ArrayUtil.swap(nArray, n2, n - 1 - n2);
        }
    }

    private void getList(boolean bl) {
        int n = this.atomCount;
        while (--n >= 0 && (this.atoms[n] == null || (bl ? this.atoms[n].alternateLocationID : this.atoms[n].insertionCode) == '\u0000')) {
        }
        if (n < 0) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.atomCount; ++n) {
            int n2;
            char c;
            if (this.atoms[n] == null) continue;
            char c2 = c = bl ? this.atoms[n].alternateLocationID : this.atoms[n].insertionCode;
            if (c == '\u0000' || stringArray[n2 = this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n3 = n2;
            stringArray[n3] = stringArray[n3] + c;
        }
        String string = bl ? "altLocs" : "insertionCodes";
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo(string, stringArray[n], n);
        }
    }

    void finish() {
        this.atoms = null;
        this.atomSetAtomCounts = new int[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.atomSetCollectionAuxiliaryInfo = new Hashtable<String, Object>();
        this.atomSetCount = 0;
        this.atomSetNumbers = new int[16];
        this.atomSymbolicMap = new Hashtable<Object, Integer>();
        this.bonds = null;
        this.cartesians = null;
        this.connectLast = null;
        this.currentAtomSetIndex = -1;
        this.latticeCells = null;
        this.notionalUnitCell = null;
        this.symmetry = null;
        this.structures = new Structure[16];
        this.structureCount = 0;
        this.trajectorySteps = null;
        this.vibrationSteps = null;
        this.vConnect = null;
    }

    public void discardPreviousAtoms() {
        int n = this.atomCount;
        while (--n >= 0) {
            this.atoms[n] = null;
        }
        this.atomCount = 0;
        this.clearSymbolicMap();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        n = this.atomSetAuxiliaryInfo.length;
        while (--n >= 0) {
            this.atomSetAtomCounts[n] = 0;
            this.atomSetBondCounts[n] = 0;
            this.atomSetAuxiliaryInfo[n] = null;
        }
    }

    public void removeAtomSet(int n) {
        int n2;
        if (this.bsAtoms == null) {
            this.bsAtoms = new BitSet();
            this.bsAtoms.set(0, this.atomCount);
        }
        int n3 = this.atomSetAtomIndexes[n];
        int n4 = this.atomSetAtomCounts[n];
        int n5 = n3 + n4;
        this.bsAtoms.clear(n3, n5);
        for (n2 = n5; n2 < this.atomCount; ++n2) {
            --this.atoms[n2].atomSetIndex;
        }
        for (n2 = n + 1; n2 < this.atomSetCount; ++n2) {
            this.atomSetAuxiliaryInfo[n2 - 1] = this.atomSetAuxiliaryInfo[n2];
            this.atomSetAtomIndexes[n2 - 1] = this.atomSetAtomIndexes[n2];
            this.atomSetBondCounts[n2 - 1] = this.atomSetBondCounts[n2];
            this.atomSetAtomCounts[n2 - 1] = this.atomSetAtomCounts[n2];
            this.atomSetNumbers[n2 - 1] = this.atomSetNumbers[n2];
        }
        for (n2 = 0; n2 < this.structureCount; ++n2) {
            if (this.structures[n2] == null) continue;
            if (this.structures[n2].atomSetIndex > n) {
                --this.structures[n2].atomSetIndex;
                continue;
            }
            if (this.structures[n2].atomSetIndex != n) continue;
            this.structures[n2] = null;
        }
        for (n2 = 0; n2 < this.bondCount; ++n2) {
            this.bonds[n2].atomSetIndex = this.atoms[this.bonds[n2].atomIndex1].atomSetIndex;
        }
        this.atomSetAuxiliaryInfo[--this.atomSetCount] = null;
    }

    public void removeAtomSet() {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        --this.currentAtomSetIndex;
        --this.atomSetCount;
    }

    Atom newCloneAtom(Atom atom) throws Exception {
        Atom atom2 = atom.cloneAtom();
        this.addAtom(atom2);
        return atom2;
    }

    public void cloneFirstAtomSet(int n) throws Exception {
        if (!this.allowMultiple) {
            return;
        }
        this.newAtomSet();
        if (n == 0) {
            n = this.atomSetAtomCounts[0];
        }
        for (int i = 0; i < n; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    public void cloneFirstAtomSetWithBonds(int n) throws Exception {
        if (!this.allowMultiple) {
            return;
        }
        this.cloneFirstAtomSet(0);
        int n2 = this.atomSetAtomCounts[0];
        for (int i = 0; i < n; ++i) {
            Bond bond = this.bonds[this.bondCount - n];
            this.addNewBond(bond.atomIndex1 + n2, bond.atomIndex2 + n2, bond.order);
        }
    }

    public void cloneLastAtomSet() throws Exception {
        this.cloneLastAtomSet(0, null);
    }

    public void cloneLastAtomSet(int n, Point3f[] point3fArray) throws Exception {
        if (!this.allowMultiple) {
            return;
        }
        int n2 = n > 0 ? n : this.getLastAtomSetAtomCount();
        int n3 = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        for (int i = 0; i < n2; ++i) {
            Atom atom = this.newCloneAtom(this.atoms[n3++]);
            if (point3fArray == null) continue;
            atom.set(point3fArray[i]);
        }
    }

    public int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    public int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    public void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = this.atomCount > 200000 ? (Atom[])ArrayUtil.ensureLength(this.atoms, this.atomCount + 50000) : (Atom[])ArrayUtil.doubleLength(this.atoms);
        }
        if (this.atomSetCount == 0) {
            this.newAtomSet();
        }
        atom.atomIndex = this.atomCount;
        this.atoms[this.atomCount++] = atom;
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        int n2 = this.atomSetAtomCounts[n];
        this.atomSetAtomCounts[n] = n2 + 1;
        atom.atomSite = n2;
    }

    public void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    public void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    public Bond addNewBond(int n, int n2) {
        return this.addNewBond(n, n2, 1);
    }

    Bond addNewBond(String string, String string2) {
        return this.addNewBond(string, string2, 1);
    }

    public Bond addNewBond(int n, int n2, int n3) {
        if (n < 0 || n >= this.atomCount || n2 < 0 || n2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(n, n2, n3);
        this.addBond(bond);
        return bond;
    }

    public Bond addNewBond(String string, String string2, int n) {
        return this.addNewBond(this.getAtomIndexFromName(string), this.getAtomIndexFromName(string2), n);
    }

    public Bond addNewBondWithMappedSerialNumbers(int n, int n2, int n3) {
        return this.addNewBond(this.getAtomIndexFromSerial(n), this.getAtomIndexFromSerial(n2), n3);
    }

    public void addConnection(int[] nArray) {
        if (this.vConnect == null) {
            this.connectLast = null;
            this.vConnect = new ArrayList<int[]>();
        }
        if (this.connectLast != null && nArray[0] == this.connectLast[0] && nArray[1] == this.connectLast[1] && nArray[2] != 2048) {
            this.connectLast[2] = this.connectLast[2] + 1;
            return;
        }
        this.connectLast = nArray;
        this.vConnect.add(nArray);
    }

    private void connectAllBad(int n) {
        int n2 = this.connectNextAtomIndex;
        for (int i = this.connectNextAtomSet; i < this.atomSetCount; ++i) {
            this.setAtomSetAuxiliaryInfo("PDB_CONECT_firstAtom_count_max", new int[]{n2, this.atomSetAtomCounts[i], n}, i);
            if (this.vConnect != null) {
                this.setAtomSetAuxiliaryInfo("PDB_CONECT_bonds", this.vConnect, i);
                this.setGlobalBoolean(3);
            }
            n2 += this.atomSetAtomCounts[i];
        }
        this.vConnect = null;
        this.connectNextAtomSet = this.currentAtomSetIndex + 1;
        this.connectNextAtomIndex = n2;
    }

    public void connectAll(int n, boolean bl) {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        if (bl) {
            this.connectAllBad(n);
            return;
        }
        this.setAtomSetAuxiliaryInfo("PDB_CONECT_firstAtom_count_max", new int[]{this.atomSetAtomIndexes[this.currentAtomSetIndex], this.atomSetAtomCounts[this.currentAtomSetIndex], n});
        if (this.vConnect == null) {
            return;
        }
        int n2 = this.connectNextAtomIndex;
        for (int i = this.connectNextAtomSet; i < this.atomSetCount; ++i) {
            this.setAtomSetAuxiliaryInfo("PDB_CONECT_bonds", this.vConnect, i);
            this.setGlobalBoolean(3);
            n2 += this.atomSetAtomCounts[i];
        }
        this.vConnect = null;
        this.connectNextAtomSet = this.currentAtomSetIndex + 1;
        this.connectNextAtomIndex = n2;
    }

    public void addBond(Bond bond) {
        if (this.trajectoryStepCount > 0) {
            return;
        }
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order < 0 || this.atoms[bond.atomIndex1].atomSetIndex != this.atoms[bond.atomIndex2].atomSetIndex) {
            if (Logger.debugging) {
                Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + " order=" + bond.order);
            }
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
        int n = this.currentAtomSetIndex;
        this.atomSetBondCounts[n] = this.atomSetBondCounts[n] + 1;
    }

    public void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 32);
        }
        structure.atomSetIndex = this.currentAtomSetIndex;
        this.structures[this.structureCount++] = structure;
        if (structure.strandCount >= 1) {
            int n = this.structureCount;
            n = this.structureCount;
            while (--n >= 0 && this.structures[n].atomSetIndex == this.currentAtomSetIndex && this.structures[n].structureID.equals(structure.structureID)) {
            }
            int n2 = this.structureCount - ++n;
            while (n < this.structureCount) {
                this.structures[n].strandCount = n2;
                ++n;
            }
        }
    }

    public void addVibrationVector(int n, float f, float f2, float f3, boolean bl) {
        if (!bl) {
            this.addVibrationVector(n, f, f2, f3);
            return;
        }
        int n2 = this.atoms[n].atomSite;
        int n3 = this.atoms[n].atomSetIndex;
        for (int i = n; i < this.atomCount && this.atoms[i].atomSetIndex == n3; ++i) {
            if (this.atoms[i].atomSite != n2) continue;
            this.addVibrationVector(i, f, f2, f3);
        }
    }

    public void addVibrationVector(int n, float f, float f2, float f3) {
        if (!this.allowMultiple) {
            n %= this.atomCount;
        }
        Atom atom = this.atoms[n];
        atom.vectorX = f;
        atom.vectorY = f2;
        atom.vectorZ = f3;
    }

    void setAtomSetSpaceGroupName(String string) {
        this.setAtomSetAuxiliaryInfo("spaceGroup", string + "");
    }

    public void setCoordinatesAreFractional(boolean bl) {
        this.coordinatesAreFractional = bl;
        this.setAtomSetAuxiliaryInfo("coordinatesAreFractional", bl);
        if (bl) {
            this.setGlobalBoolean(0);
        }
    }

    void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.setAtomSetCollectionAuxiliaryInfo("symmetryRange", new Float(f));
    }

    void setLatticeCells(int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, Point3f point3f) {
        this.latticeCells = nArray;
        boolean bl5 = nArray[0] <= 555 && nArray[1] >= 555 && (nArray[2] == 0 || nArray[2] == 1 || nArray[2] == -1);
        this.doNormalize = nArray[0] != 0 && (!bl5 || nArray[2] == 1);
        this.applySymmetryToBonds = bl;
        this.doPackUnitCell = bl2;
        this.doCentroidUnitCell = bl3;
        this.centroidPacked = bl4;
        if (string != null) {
            this.setSuperCell(string);
        } else {
            this.ptSupercell = point3f;
        }
    }

    public void setSupercell(Point3f point3f) {
        this.ptSupercell = point3f;
        Logger.info("Using supercell " + Escape.escape(point3f));
    }

    private void setSuperCell(String string) {
        if (this.fmatSupercell != null) {
            return;
        }
        this.fmatSupercell = new float[16];
        if (this.getSymmetry().getMatrixFromString(string, this.fmatSupercell, true) == null) {
            this.fmatSupercell = null;
            return;
        }
        Logger.info("Using supercell \n" + new Matrix4f(this.fmatSupercell));
    }

    public SymmetryInterface getSymmetry() {
        if (this.symmetry == null) {
            this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symmetry;
    }

    public void setNotionalUnitCell(float[] fArray, Matrix3f matrix3f, Point3f point3f) {
        this.notionalUnitCell = new float[fArray.length];
        this.unitCellOffset = point3f;
        for (int i = 0; i < fArray.length; ++i) {
            this.notionalUnitCell[i] = fArray[i];
        }
        this.haveUnitCell = true;
        this.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        this.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        if (point3f != null) {
            this.symmetry.setUnitCellOffset(point3f);
            this.setAtomSetAuxiliaryInfo("unitCellOffset", point3f);
        }
        if (matrix3f != null) {
            this.symmetry.setUnitCellOrientation(matrix3f);
            this.setAtomSetAuxiliaryInfo("matUnitCellOrientation", matrix3f);
        }
    }

    boolean addSpaceGroupOperation(String string) {
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(string, 0) >= 0;
    }

    public void setLatticeParameter(int n) {
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(n);
    }

    void applySymmetry() throws Exception {
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], Math.abs(this.latticeCells[2]));
    }

    void applySymmetry(SymmetryInterface symmetryInterface) throws Exception {
        this.getSymmetry().setSpaceGroup(symmetryInterface);
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], Math.abs(this.latticeCells[2]));
    }

    private void applySymmetry(int n, int n2, int n3) throws Exception {
        if (!this.coordinatesAreFractional || !this.getSymmetry().haveSpaceGroup()) {
            return;
        }
        if (this.fmatSupercell != null) {
            int n4;
            int n5;
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
            Point3f point3f = this.setSym(0, 1, 2);
            Point3f point3f2 = this.setSym(4, 5, 6);
            Point3f point3f3 = this.setSym(8, 9, 10);
            this.minXYZ = new Point3i((int)this.rminx, (int)this.rminy, (int)this.rminz);
            this.maxXYZ = new Point3i((int)this.rmaxx, (int)this.rmaxy, (int)this.rmaxz);
            this.applyAllSymmetry();
            for (n5 = n4 = this.getLastAtomSetAtomIndex(); n5 < this.atomCount; ++n5) {
                this.symmetry.toCartesian(this.atoms[n5], true);
            }
            this.symmetry = null;
            this.setNotionalUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, point3f.x, point3f.y, point3f.z, point3f2.x, point3f2.y, point3f2.z, point3f3.x, point3f3.y, point3f3.z}, null, (Point3f)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, "unitCellOffset"));
            this.setAtomSetSpaceGroupName("P1");
            this.getSymmetry().setSpaceGroup(this.doNormalize);
            this.symmetry.addSpaceGroupOperation("x,y,z", 0);
            for (n5 = n4; n5 < this.atomCount; ++n5) {
                this.symmetry.toFractional(this.atoms[n5], true);
            }
            this.haveAnisou = false;
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].remove("matUnitCellOrientation");
            this.doPackUnitCell = false;
        }
        this.minXYZ = new Point3i();
        this.maxXYZ = new Point3i(n, n2, n3);
        this.applyAllSymmetry();
        this.fmatSupercell = null;
    }

    private Point3f setSym(int n, int n2, int n3) {
        Point3f point3f = new Point3f();
        point3f.set(this.fmatSupercell[n], this.fmatSupercell[n2], this.fmatSupercell[n3]);
        this.setSymmetryMinMax(point3f);
        this.symmetry.toCartesian(point3f, false);
        return point3f;
    }

    private void setSymmetryMinMax(Point3f point3f) {
        if (this.rminx > point3f.x) {
            this.rminx = point3f.x;
        }
        if (this.rminy > point3f.y) {
            this.rminy = point3f.y;
        }
        if (this.rminz > point3f.z) {
            this.rminz = point3f.z;
        }
        if (this.rmaxx < point3f.x) {
            this.rmaxx = point3f.x;
        }
        if (this.rmaxy < point3f.y) {
            this.rmaxy = point3f.y;
        }
        if (this.rmaxz < point3f.z) {
            this.rmaxz = point3f.z;
        }
    }

    private boolean isInSymmetryRange(Point3f point3f) {
        return point3f.x >= this.rminx && point3f.y >= this.rminy && point3f.z >= this.rminz && point3f.x <= this.rmaxx && point3f.y <= this.rmaxy && point3f.z <= this.rmaxz;
    }

    private static boolean isWithinCell(int n, Point3f point3f, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f = 0.02f;
        return point3f.x > (float)n2 - f && point3f.x < (float)n3 + f && (n < 2 || point3f.y > (float)n4 - f && point3f.y < (float)n5 + f) && (n < 3 || point3f.z > (float)n6 - f && point3f.z < (float)n7 + f);
    }

    public void setAnisoBorU(Atom atom, float[] fArray, int n) {
        this.haveAnisou = true;
        atom.anisoBorU = fArray;
        fArray[6] = n;
    }

    public float[] getAnisoBorU(Atom atom) {
        return atom.anisoBorU;
    }

    public void setEllipsoids() {
        int n;
        if (!this.haveAnisou) {
            return;
        }
        for (int i = n = this.getLastAtomSetAtomIndex(); i < this.atomCount; ++i) {
            this.atoms[i].setEllipsoid(this.symmetry.getEllipsoid(this.atoms[i].anisoBorU));
        }
    }

    public void setBaseSymmetryAtomCount(int n) {
        this.baseSymmetryAtomCount = n;
    }

    private void applyAllSymmetry() throws Exception {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        int n5 = this.baseSymmetryAtomCount == 0 ? this.getLastAtomSetAtomCount() : this.baseSymmetryAtomCount;
        int n6 = this.getLastAtomSetAtomIndex();
        this.setEllipsoids();
        this.bondCount0 = this.bondCount;
        this.finalizeSymmetry(n6, n5);
        int n7 = this.symmetry.getSpaceGroupOperationCount();
        this.getSymmetry().setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        this.dtype = (int)this.getSymmetry().getUnitCellInfo(6);
        if (this.doCentroidUnitCell) {
            this.setAtomSetCollectionAuxiliaryInfo("centroidMinMax", new int[]{this.minXYZ.x, this.minXYZ.y, this.minXYZ.z, this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z, this.centroidPacked ? 1 : 0});
        }
        if (this.ptSupercell != null) {
            this.setAtomSetAuxiliaryInfo("supercell", this.ptSupercell);
            switch (this.dtype) {
                case 3: {
                    this.minXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                    this.maxXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                }
                case 2: {
                    this.minXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                    this.maxXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                }
                case 1: {
                    this.minXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                    this.maxXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                }
            }
        }
        if (this.doCentroidUnitCell || this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            this.minXYZ0 = new Point3i(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
            this.maxXYZ0 = new Point3i(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
            switch (this.dtype) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int n8 = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int n9 = this.checkSpecial ? n5 * n7 * n8 : (this.symmetryRange > 0.0f ? n5 * n7 : (this.symmetryRange < 0.0f ? 1 : 1));
        this.cartesians = new Point3f[n9];
        for (n4 = 0; n4 < n5; ++n4) {
            this.atoms[n4 + n6].bsSymmetry = new BitSet(n7 * (n8 + 1));
        }
        n4 = 0;
        int[] nArray = new int[n8];
        this.unitCellTranslations = new Vector3f[n8];
        int n10 = 0;
        int n11 = 0;
        float f = Math.abs(this.symmetryRange);
        boolean bl2 = this.symmetryRange != 0.0f;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = bl = this.symmetryRange > 0.0f;
        if (bl2) {
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
        }
        Matrix4f matrix4f = this.symmetry.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    this.unitCellTranslations[n10] = new Vector3f(n3, n2, n);
                    nArray[n10++] = 555 + n3 * 100 + n2 * 10 + n;
                    if (n3 != 0 || n2 != 0 || n != 0 || this.cartesians.length == 0) continue;
                    for (n4 = 0; n4 < n5; ++n4) {
                        Atom atom = this.atoms[n6 + n4];
                        Point3f point3f = new Point3f(atom);
                        matrix4f.transform(point3f);
                        this.symmetry.toCartesian(point3f, false);
                        if (this.doPackUnitCell) {
                            this.symmetry.toUnitCell(point3f, this.ptOffset);
                            atom.set(point3f);
                            this.symmetry.toFractional(atom, false);
                        }
                        atom.bsSymmetry.set(n10 * n7);
                        atom.bsSymmetry.set(0);
                        if (bl2) {
                            this.setSymmetryMinMax(point3f);
                        }
                        if (n4 >= n9) continue;
                        this.cartesians[n4] = point3f;
                    }
                    if (bl3) {
                        this.rminx -= f;
                        this.rminy -= f;
                        this.rminz -= f;
                        this.rmaxx += f;
                        this.rmaxy += f;
                        this.rmaxz += f;
                    }
                    n11 = n4 = this.symmetryAddAtoms(n6, n5, 0, 0, 0, 0, n4, n10 * n7);
                }
            }
        }
        if (bl) {
            this.rminx -= f;
            this.rminy -= f;
            this.rminz -= f;
            this.rmaxx += f;
            this.rmaxy += f;
            this.rmaxz += f;
        }
        n10 = 0;
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    ++n10;
                    if (n3 == 0 && n2 == 0 && n == 0) continue;
                    n4 = this.symmetryAddAtoms(n6, n5, n3, n2, n, n11, n4, n10 * n7);
                }
            }
        }
        if (n10 * n5 == this.atomCount - n6) {
            this.appendAtomProperties(n10);
        }
        this.setSymmetryOps();
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", n6);
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", n5);
        this.setAtomSetAuxiliaryInfo("latticeDesignation", this.symmetry.getLatticeDesignation());
        this.setAtomSetAuxiliaryInfo("unitCellRange", nArray);
        this.setAtomSetAuxiliaryInfo("unitCellTranslations", this.unitCellTranslations);
        this.symmetry.setSpaceGroup(null);
        this.notionalUnitCell = new float[6];
        this.coordinatesAreFractional = false;
        this.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.setGlobalBoolean(1);
    }

    private void finalizeSymmetry(int n, int n2) {
        this.symmetry.setFinalOperations(this.atoms, n, n2, this.doNormalize);
        String string = (String)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, "spaceGroup");
        if (string == null || string.equals("unspecified!")) {
            this.setAtomSetSpaceGroupName(this.symmetry.getSpaceGroupName());
        }
    }

    private void setSymmetryOps() {
        int n = this.symmetry.getSpaceGroupOperationCount();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.setAtomSetAuxiliaryInfo("symmetryOperations", stringArray);
        }
        this.setAtomSetAuxiliaryInfo("symmetryCount", n);
    }

    public void setCheckSpecial(boolean bl) {
        this.checkSpecial = bl;
    }

    private int symmetryAddAtoms(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws Exception {
        boolean bl;
        int[] nArray;
        boolean bl2 = n6 == 0;
        boolean bl3 = this.bondCount0 > this.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray2 = nArray = bl3 ? new int[n2] : null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(n3, n4, n5);
        }
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl4 = this.symmetryRange < 0.0f;
        boolean bl5 = this.symmetryRange > 0.0f;
        boolean bl6 = bl2 && bl5;
        bl5 &= !bl2;
        int n9 = this.symmetry.getSpaceGroupOperationCount();
        if (n9 == 1) {
            this.checkSpecial = false;
        }
        boolean bl7 = bl4 || bl5;
        boolean bl8 = this.checkSpecial || bl7;
        boolean bl9 = bl = this.checkSpecial || bl6;
        if (bl4) {
            n6 = n2;
        }
        int n10 = n + n2;
        Point3f point3f = new Point3f();
        for (int i = 0; i < n9; ++i) {
            Point3f point3f2;
            Object object;
            int n11;
            if (bl2 && this.symmetry.getSpaceGroupXyz(i, true).equals("x,y,z")) continue;
            int n12 = this.checkSpecial ? n7 : (bl5 ? n6 : 0);
            for (n11 = n; n11 < n10; ++n11) {
                if (this.atoms[n11].ignoreSymmetry) continue;
                this.symmetry.newSpaceGroupPoint(i, this.atoms[n11], point3f, n3, n4, n5);
                object = null;
                point3f2 = new Point3f(point3f);
                this.symmetry.toCartesian(point3f2, false);
                if (this.doPackUnitCell) {
                    this.symmetry.toUnitCell(point3f2, this.ptOffset);
                    point3f.set(point3f2);
                    this.symmetry.toFractional(point3f, false);
                    if (!AtomSetCollection.isWithinCell(this.dtype, point3f, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z)) continue;
                }
                if (bl6) {
                    this.setSymmetryMinMax(point3f2);
                }
                if (bl8) {
                    float f2 = Float.MAX_VALUE;
                    if (bl7 && !this.isInSymmetryRange(point3f2)) continue;
                    int n13 = n12;
                    while (--n13 >= 0) {
                        float f3 = point3f2.distanceSquared(this.cartesians[n13]);
                        if (this.checkSpecial && (double)f3 < 1.0E-4) {
                            object = this.atoms[n + n13];
                            break;
                        }
                        if (!bl5 || n13 >= n6 || !(f3 < f2)) continue;
                        f2 = f3;
                    }
                    if (bl5 && f2 > f) continue;
                }
                int n14 = this.atoms[n11].atomSite;
                if (object != null) {
                    if (bl3) {
                        nArray[n14] = ((Atom)object).atomIndex;
                    }
                    ((Atom)object).bsSymmetry.set(n8 + i);
                    ((Atom)object).bsSymmetry.set(i);
                    continue;
                }
                if (bl3) {
                    nArray[n14] = this.atomCount;
                }
                Atom atom = this.newCloneAtom(this.atoms[n11]);
                atom.set(point3f);
                atom.atomSite = n14;
                atom.bsSymmetry = BitSetUtil.setBit(n8 + i);
                atom.bsSymmetry.set(i);
                if (bl) {
                    this.cartesians[n7++] = point3f2;
                }
                if (this.atoms[n11].ellipsoid == null) continue;
                for (int j = 0; j < this.atoms[n11].ellipsoid.length; ++j) {
                    Quadric quadric = this.atoms[n11].ellipsoid[j];
                    if (quadric == null) continue;
                    Vector3f[] vector3fArray = quadric.vectors;
                    float[] fArray = quadric.lengths;
                    if (vector3fArray != null) {
                        if (bl) {
                            this.ptTemp.set(this.cartesians[n11 - n]);
                        } else {
                            this.ptTemp.set(this.atoms[n11]);
                            this.symmetry.toCartesian(this.ptTemp, false);
                        }
                        vector3fArray = this.symmetry.rotateEllipsoid(i, this.ptTemp, vector3fArray, this.ptTemp1, this.ptTemp2);
                    }
                    atom.ellipsoid[j] = new Quadric(vector3fArray, fArray, quadric.isThermalEllipsoid);
                }
            }
            if (!bl3) continue;
            for (n11 = this.bondIndex0; n11 < this.bondCount0; ++n11) {
                object = this.bonds[n11];
                point3f2 = this.atoms[((Bond)object).atomIndex1];
                Atom atom = this.atoms[((Bond)object).atomIndex2];
                if (point3f2 == null || atom == null) continue;
                int n15 = nArray[((Atom)point3f2).atomSite];
                int n16 = nArray[atom.atomSite];
                if (n15 < n10 && n16 < n10) continue;
                this.addNewBond(n15, n16, ((Bond)object).order);
            }
        }
        return n7;
    }

    public void applySymmetry(List<Matrix4f> list, float[] fArray, boolean bl, String string) {
        int n;
        if (this.latticeCells != null && this.latticeCells[0] != 0) {
            Logger.error("Cannot apply biomolecule when lattice cells are indicated");
            return;
        }
        this.doNormalize = false;
        this.symmetry = null;
        this.getSymmetry();
        this.setNotionalUnitCell(fArray, null, this.unitCellOffset);
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation("x,y,z");
        this.setAtomSetSpaceGroupName("biomolecule");
        int n2 = list.size();
        this.applySymmetryToBonds = bl;
        this.bondCount0 = this.bondCount;
        boolean bl2 = this.bondCount0 > this.bondIndex0 && bl;
        int[] nArray = bl2 ? new int[this.atomCount] : null;
        int n3 = this.getLastAtomSetAtomIndex();
        int n4 = this.atomCount;
        if (string.indexOf("#<") >= 0) {
            n2 = Math.min(n2, Parser.parseInt(string.substring(string.indexOf("#<") + 2)) - 1);
            string = TextFormat.simpleReplace(string, "#<", "_<");
        }
        for (n = n3; n < n4; ++n) {
            this.atoms[n].bsSymmetry = BitSetUtil.setBit(0);
        }
        for (n = 1; n < n2; ++n) {
            if (string.indexOf("!#") >= 0 ? string.indexOf("!#" + (n + 1) + ";") >= 0 : string.indexOf("#") >= 0 && string.indexOf("#" + (n + 1) + ";") < 0) continue;
            Matrix4f matrix4f = list.get(n);
            for (int i = n3; i < n4; ++i) {
                try {
                    int n5 = this.atoms[i].atomSite;
                    if (bl2) {
                        nArray[n5] = this.atomCount;
                    }
                    Atom atom = this.newCloneAtom(this.atoms[i]);
                    atom.atomSite = n5;
                    matrix4f.transform(atom);
                    atom.bsSymmetry = BitSetUtil.setBit(n);
                    if (!bl2) continue;
                    for (int j = this.bondIndex0; j < this.bondCount0; ++j) {
                        Bond bond = this.bonds[j];
                        int n6 = nArray[this.atoms[bond.atomIndex1].atomSite];
                        int n7 = nArray[this.atoms[bond.atomIndex2].atomSite];
                        if (n6 < n4 && n7 < n4) continue;
                        this.addNewBond(n6, n7, bond.order);
                    }
                    continue;
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
            }
            matrix4f.m03 /= fArray[0];
            matrix4f.m13 /= fArray[1];
            matrix4f.m23 /= fArray[2];
            if (this.symmetry == null || n <= 0) continue;
            this.symmetry.addSpaceGroupOperation(matrix4f);
        }
        n = n4 - n3;
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", n3);
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", n);
        this.setAtomSetAuxiliaryInfo("biosymmetryCount", n2);
        if (this.symmetry != null) {
            this.finalizeSymmetry(n3, n);
            this.setSymmetryOps();
        }
        this.symmetry = null;
        this.coordinatesAreFractional = false;
        this.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.setGlobalBoolean(1);
    }

    private void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int n = this.atomCount - 1;
            String string = this.atoms[n].atomName;
            if (string != null) {
                this.atomSymbolicMap.put(string, n);
            }
        }
    }

    public void clearSymbolicMap() {
        this.atomSymbolicMap.clear();
        this.haveMappedSerials = false;
    }

    void mapMostRecentAtomSerialNumber() {
        if (this.atomCount == 0) {
            return;
        }
        int n = this.atomCount - 1;
        int n2 = this.atoms[n].atomSerial;
        if (n2 != Integer.MIN_VALUE) {
            this.atomSymbolicMap.put(n2, n);
        }
        this.haveMappedSerials = true;
    }

    public void createAtomSerialMap() {
        if (this.haveMappedSerials || this.currentAtomSetIndex < 0) {
            return;
        }
        for (int i = this.getLastAtomSetAtomCount(); i < this.atomCount; ++i) {
            int n = this.atoms[i].atomSerial;
            if (n == Integer.MIN_VALUE) continue;
            this.atomSymbolicMap.put(n, i);
        }
        this.haveMappedSerials = true;
    }

    void mapAtomName(String string, int n) {
        this.atomSymbolicMap.put(string, n);
    }

    public int getAtomIndexFromName(String string) {
        int n = -1;
        Integer n2 = this.atomSymbolicMap.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public int getAtomIndexFromSerial(int n) {
        int n2 = -1;
        Integer n3 = this.atomSymbolicMap.get(n);
        if (n3 != null) {
            n2 = n3;
        }
        return n2;
    }

    public void setAtomSetCollectionAuxiliaryInfo(String string, Object object) {
        this.atomSetCollectionAuxiliaryInfo.put(string, object);
    }

    public boolean setAtomSetCollectionPartialCharges(String string) {
        if (!this.atomSetCollectionAuxiliaryInfo.containsKey(string)) {
            return false;
        }
        List list = (List)this.atomSetCollectionAuxiliaryInfo.get(string);
        int n = list.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)list.get(n)).floatValue();
        }
        Logger.info("Setting partial charges type " + string);
        return true;
    }

    public void mapPartialCharge(String string, float f) {
        this.atoms[this.getAtomIndexFromName((String)string)].partialCharge = f;
    }

    public Object getAtomSetCollectionAuxiliaryInfo(String string) {
        return this.atomSetCollectionAuxiliaryInfo.get(string);
    }

    private void addTrajectoryStep() {
        int n;
        Point3f[] point3fArray = new Point3f[this.atomCount];
        boolean bl = this.atomCount > 0 && !Float.isNaN(this.atoms[0].vectorX);
        Vector3f[] vector3fArray = bl ? new Vector3f[this.atomCount] : null;
        Point3f[] point3fArray2 = this.trajectoryStepCount == 0 ? null : this.trajectorySteps.get(this.trajectoryStepCount - 1);
        for (n = 0; n < this.atomCount; ++n) {
            Point3f point3f = new Point3f(this.atoms[n]);
            if (this.doFixPeriodic && point3fArray2 != null) {
                point3f = AtomSetCollection.fixPeriodic(point3f, point3fArray2[n]);
            }
            point3fArray[n] = point3f;
            if (!bl) continue;
            vector3fArray[n] = new Vector3f(this.atoms[n].vectorX, this.atoms[n].vectorY, this.atoms[n].vectorZ);
        }
        if (bl) {
            if (this.vibrationSteps == null) {
                this.vibrationSteps = new ArrayList<Vector3f[]>();
                for (n = 0; n < this.trajectoryStepCount; ++n) {
                    this.vibrationSteps.add(null);
                }
            }
            this.vibrationSteps.add(vector3fArray);
        }
        this.trajectorySteps.add(point3fArray);
        ++this.trajectoryStepCount;
    }

    private static Point3f fixPeriodic(Point3f point3f, Point3f point3f2) {
        point3f.x = AtomSetCollection.fixPoint(point3f.x, point3f2.x);
        point3f.y = AtomSetCollection.fixPoint(point3f.y, point3f2.y);
        point3f.z = AtomSetCollection.fixPoint(point3f.z, point3f2.z);
        return point3f;
    }

    private static float fixPoint(float f, float f2) {
        while ((double)(f - f2) > 0.9) {
            f -= 1.0f;
        }
        while ((double)(f - f2) < -0.9) {
            f += 1.0f;
        }
        return f;
    }

    void finalizeTrajectory(List<Point3f[]> list, List<Vector3f[]> list2) {
        this.trajectorySteps = list;
        this.vibrationSteps = list2;
        this.trajectoryStepCount = list.size();
        this.finalizeTrajectory();
    }

    private void finalizeTrajectory() {
        if (this.trajectoryStepCount == 0) {
            return;
        }
        Point3f[] point3fArray = this.trajectorySteps.get(0);
        Vector3f[] vector3fArray = this.vibrationSteps == null ? null : this.vibrationSteps.get(0);
        Vector3f vector3f = new Vector3f();
        if (this.vibrationSteps != null && vector3fArray.length < this.atomCount || point3fArray.length < this.atomCount) {
            this.errorMessage = "File cannot be loaded as a trajectory";
            return;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.vibrationSteps != null) {
                if (vector3fArray != null) {
                    vector3f = vector3fArray[i];
                }
                this.atoms[i].vectorX = vector3f.x;
                this.atoms[i].vectorY = vector3f.y;
                this.atoms[i].vectorZ = vector3f.z;
            }
            this.atoms[i].set(point3fArray[i]);
        }
        this.setAtomSetCollectionAuxiliaryInfo("trajectorySteps", this.trajectorySteps);
        if (this.vibrationSteps != null) {
            this.setAtomSetCollectionAuxiliaryInfo("vibrationSteps", this.vibrationSteps);
        }
    }

    public void newAtomSet() {
        if (!this.allowMultiple && this.currentAtomSetIndex >= 0) {
            this.discardPreviousAtoms();
        }
        this.bondIndex0 = this.bondCount;
        if (this.isTrajectory) {
            this.discardPreviousAtoms();
        }
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetAtomIndexes = ArrayUtil.doubleLength(this.atomSetAtomIndexes);
            this.atomSetAtomCounts = ArrayUtil.doubleLength(this.atomSetAtomCounts);
            this.atomSetBondCounts = ArrayUtil.doubleLength(this.atomSetBondCounts);
            this.atomSetAuxiliaryInfo = (Map[])ArrayUtil.doubleLength(this.atomSetAuxiliaryInfo);
        }
        this.atomSetAtomIndexes[this.currentAtomSetIndex] = this.atomCount;
        if (this.atomSetCount + this.trajectoryStepCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = ArrayUtil.doubleLength(this.atomSetNumbers);
        }
        if (this.isTrajectory) {
            this.atomSetNumbers[this.currentAtomSetIndex + this.trajectoryStepCount] = this.atomSetCount + this.trajectoryStepCount;
        } else {
            this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        }
        this.atomSymbolicMap.clear();
        this.setAtomSetAuxiliaryInfo("title", this.collectionName);
    }

    public int getAtomSetAtomIndex(int n) {
        return this.atomSetAtomIndexes[n];
    }

    public int getAtomSetAtomCount(int n) {
        return this.atomSetAtomCounts[n];
    }

    public int getAtomSetBondCount(int n) {
        return this.atomSetBondCounts[n];
    }

    public void setAtomSetName(String string) {
        if (this.isTrajectory) {
            this.setTrajectoryName(string);
            return;
        }
        this.setAtomSetAuxiliaryInfo("name", string, this.currentAtomSetIndex);
        if (!this.allowMultiple) {
            this.setCollectionName(string);
        }
    }

    private void setTrajectoryName(String string) {
        if (this.trajectoryStepCount == 0) {
            return;
        }
        if (this.trajectoryNames == null) {
            this.trajectoryNames = new ArrayList<String>();
        }
        for (int i = this.trajectoryNames.size(); i < this.trajectoryStepCount; ++i) {
            this.trajectoryNames.add(null);
        }
        this.trajectoryNames.set(this.trajectoryStepCount - 1, string);
    }

    public void setAtomSetNames(String string, int n) {
        for (int i = this.currentAtomSetIndex; --n >= 0 && i >= 0; --i) {
            this.setAtomSetAuxiliaryInfo("name", string, i);
        }
    }

    public void setAtomSetNumber(int n) {
        this.setAtomSetNumber(this.currentAtomSetIndex + (this.isTrajectory ? this.trajectoryStepCount : 0), n);
    }

    public void setAtomSetNumber(int n, int n2) {
        this.atomSetNumbers[n] = n2;
    }

    public void setAtomSetModelProperty(String string, String string2) {
        this.setAtomSetModelProperty(string, string2, this.currentAtomSetIndex);
    }

    public void setAtomSetModelProperty(String string, String string2, int n) {
        Properties properties = (Properties)this.getAtomSetAuxiliaryInfo(n, "modelProperties");
        if (properties == null) {
            properties = new Properties();
            this.setAtomSetAuxiliaryInfo("modelProperties", properties, n);
        }
        properties.put(string, string2);
    }

    public void setAtomSetAtomProperty(String string, String string2, int n) {
        Hashtable<String, String> hashtable;
        if (!string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        if (n < 0) {
            n = this.currentAtomSetIndex;
        }
        if ((hashtable = (Hashtable<String, String>)this.getAtomSetAuxiliaryInfo(n, "atomProperties")) == null) {
            hashtable = new Hashtable<String, String>();
            this.setAtomSetAuxiliaryInfo("atomProperties", hashtable, n);
        }
        hashtable.put(string, string2);
    }

    private void appendAtomProperties(int n) {
        Map map = (Map)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, "atomProperties");
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = n;
            while (--n2 >= 0) {
                stringBuilder.append(string2);
            }
            map.put(string, stringBuilder.toString());
        }
    }

    public void setAtomSetAuxiliaryInfo(String string, Object object) {
        this.setAtomSetAuxiliaryInfo(string, object, this.currentAtomSetIndex);
    }

    boolean setAtomSetPartialCharges(String string) {
        if (!this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].containsKey(string)) {
            return false;
        }
        List list = (List)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, string);
        int n = list.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)list.get(n)).floatValue();
        }
        return true;
    }

    public Object getAtomSetAuxiliaryInfo(int n, String string) {
        return this.atomSetAuxiliaryInfo[n].get(string);
    }

    public void setAtomSetAuxiliaryInfo(String string, Object object, int n) {
        if (n < 0) {
            return;
        }
        if (this.atomSetAuxiliaryInfo[n] == null) {
            this.atomSetAuxiliaryInfo[n] = new Hashtable<String, Object>();
        }
        if (object == null) {
            this.atomSetAuxiliaryInfo[n].remove(string);
        } else {
            this.atomSetAuxiliaryInfo[n].put(string, object);
        }
    }

    public void setAtomSetPropertyForSets(String string, String string2, int n) {
        for (int i = this.currentAtomSetIndex; --n >= 0 && i >= 0; --i) {
            this.setAtomSetModelProperty(string, string2, i);
        }
    }

    public void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int n) {
        Properties properties = (Properties)this.getAtomSetAuxiliaryInfo(n, "modelProperties");
        if (properties != null) {
            this.setAtomSetAuxiliaryInfo("modelProperties", properties.clone(), this.currentAtomSetIndex);
        }
    }

    int getAtomSetNumber(int n) {
        return this.atomSetNumbers[n >= this.atomSetCount ? 0 : n];
    }

    String getAtomSetName(int n) {
        if (this.trajectoryNames != null && n < this.trajectoryNames.size()) {
            return this.trajectoryNames.get(n);
        }
        if (n >= this.atomSetCount) {
            n = this.atomSetCount - 1;
        }
        return (String)this.getAtomSetAuxiliaryInfo(n, "name");
    }

    Map<String, Object> getAtomSetAuxiliaryInfo(int n) {
        return this.atomSetAuxiliaryInfo[n >= this.atomSetCount ? this.atomSetCount - 1 : n];
    }

    public Properties setAtomNames(Properties properties) {
        if (properties == null) {
            return null;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            String string = properties.getProperty(this.atoms[i].atomName);
            if (string == null) continue;
            this.atoms[i].atomName = string;
        }
        return null;
    }

    public void setAtomSetEnergy(String string, float f) {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        this.setAtomSetAuxiliaryInfo("EnergyString", string);
        this.setAtomSetAuxiliaryInfo("Energy", new Float(f));
        this.setAtomSetModelProperty("Energy", "" + f);
    }

    public void setAtomSetFrequency(String string, String string2, String string3, String string4) {
        string3 = string3 + " " + (string4 == null ? "cm^-1" : string4);
        this.setAtomSetName((string2 == null ? "" : string2 + " ") + string3);
        this.setAtomSetModelProperty("Frequency", string3);
        if (string2 != null) {
            this.setAtomSetModelProperty("FrequencyLabel", string2);
        }
        this.setAtomSetModelProperty(".PATH", (string == null ? "" : string + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies") + "Frequencies");
    }

    void toCartesian(SymmetryInterface symmetryInterface) {
        for (int i = this.getLastAtomSetAtomIndex(); i < this.atomCount; ++i) {
            symmetryInterface.toCartesian(this.atoms[i], true);
        }
    }

    public String[][] getBondList() {
        String[][] stringArray = new String[this.bondCount][];
        for (int i = 0; i < this.bondCount; ++i) {
            stringArray[i] = new String[]{this.atoms[this.bonds[i].atomIndex1].atomName, this.atoms[this.bonds[i].atomIndex2].atomName, "" + this.bonds[i].order};
        }
        return stringArray;
    }

    public void centralize() {
        Point3f point3f = new Point3f();
        for (int i = 0; i < this.atomSetCount; ++i) {
            int n = this.atomSetAtomCounts[i];
            int n2 = this.atomSetAtomIndexes[i];
            point3f.set(0.0f, 0.0f, 0.0f);
            int n3 = n2 + n;
            while (--n3 >= n2) {
                point3f.x += this.atoms[n3].x;
                point3f.y += this.atoms[n3].y;
                point3f.z += this.atoms[n3].z;
            }
            point3f.scale(1.0f / (float)n);
            n3 = n2 + n;
            while (--n3 >= n2) {
                this.atoms[n3].x -= point3f.x;
                this.atoms[n3].y -= point3f.y;
                this.atoms[n3].z -= point3f.z;
            }
        }
    }
}

